# ui-pagelist.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1996-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import WidgetClass
if {$tcl_platform(platform)=="windows"} {
	WidgetClass transparent_gif SystemButtonFace
}
import Observer DropDown/Text

# A set of widgets for mb pages.
# Call <tt>config_widgets</tt> with a list of widgets you want to be included.
#
Class MBPageNavPanel -superclass {MBWidget Observer}

# constructor <br>
# <u>parent</u>: parent widget
#
MBPageNavPanel public init {parent pageMgr} {
	$self set pageMgr_ $pageMgr
	$self set path_ [frame $parent.pgnavpanel]
	$pageMgr attach_observer $self
}

# observer call back from pageMgr
MBPageNavPanel private switch_page {page_id} {
	$self instvar pageList_ zoom_
	if [info exists pageList_] {
		$pageList_ switch_page $page_id
	}
	if [info exists zoom_] {
		# update after idle so that the configure event which
		# updates the new canvas scale value gets called first
		after idle "$self update_zoomscale"
	}
}

# observer call back from pageMgr
MBPageNavPanel public add_page {page_id} {
	[$self set pageList_] add_page $page_id
}

# <u>widget_list</u> is a list that is a subset of
# {pagelist prev next zoom}
# the widgets are build from left to right
MBPageNavPanel public build_widgets {widget_list} {
	foreach wgt $widget_list {
		$self build_$wgt
	}
}

# builds the pagelist widget which is a dropdown consisting of the various
# pages
MBPageNavPanel private build_pagelist {} {
	$self instvar path_ pageList_ pageMgr_
	set pageList_ [new MBPageList $pageMgr_ $path_ -padx 1 -pady 1 \
			-side left -anchor c -fill y]
}

# builds the previous page button
MBPageNavPanel private build_prev {} {
	$self instvar path_ pageList_ prev_
	set prev_ [button $path_.p -fg blue -bitmap back  \
                        -command "$pageList_ nextPage -1"]
	pack $prev_ -after [$pageList_ get_menubutton] \
			-side left  -anchor e -padx 1 -pady 3 -fill y
}

# builds the next page button
MBPageNavPanel private build_next {} {
	$self instvar path_ pageList_ next_
	set next_ [button $path_.n -fg blue -bitmap forw  \
                        -command "$pageList_ nextPage 1"]
	pack $next_ -after [$pageList_ get_menubutton] \
			-side left  -anchor e -padx 1 -pady 3 -fill y
}

# builds the zoom dropdown
MBPageNavPanel private build_zoom {} {
	$self instvar path_ pageList_ zoom_ zoomValue_
	$self tkvar zoomValue_
	set zoom_ [DropDown/Text $path_.z -width 5 \
			-var [$self tkvarname zoomValue_] -options {
		{ entry.width 15 }
	}]
	trace variable zoomValue_ w "$self set_zoom"
	$zoom_ insert end "fix to view" 50% 100% 125% 150% 175% 200% \
			"fit width" "fit height" \
			"fit all"

	pack $zoom_ -side left -anchor e -padx 1 -pady 1 -fill y
}

# sets zoom level, called when user presses "enter"
MBPageNavPanel private set_zoom {args} {
	$self instvar zoom_ pageMgr_
	$self tkvar zoomValue_
	set currCanvas [$pageMgr_ current_canvas]
	if {$currCanvas!={}} {
		$currCanvas zoom_policy $zoomValue_
		$self update_zoomscale
	}
}

# updates the zoom scale for the current canvas
MBPageNavPanel public update_zoomscale {} {
	$self instvar pageMgr_ zoom_
	$self tkvar zoomValue_

	set canv [$pageMgr_ current_canvas]
	if {$canv!={}} {
		if {$zoomValue_!="fix to view"} {
			set label ""
		} else {
			set label "\[$zoomValue_\] "
		}
#		puts "scale is [$canv getscale]"
		append label [expr {int(100*([$canv getscale]+0.005))}] "%"
#		puts "label=$label"
		$zoom_ configure -entryVal $label
	}
}

# DropDown box with a list of pages
Class MBPageList

MBPageList public init {pageMgr parent args} {
	$self next
	$self set pageMgr_ $pageMgr
        $self instvar menubutton_ pagelist_ menus_

	set medfont [$self get_option medfont]
        #    set label [label $parent.pagelistlabel -text "Page: "]
        set menubutton_ [menubutton $parent.pagelist -text "      " \
                        -menu $parent.pagelist.menu -indicator 0 \
			-font $medfont \
                        -relief raised -highlightthickness 2 -anchor c]

        # menus can be torn off, we store all torn off menus in a list
        # so that new pages can be updated in all.
        lappend menus_ [menu $parent.pagelist.menu \
                        -tearoff 1 -tearoffcommand [list $self tearoff]]

        #    eval pack $label -side left $args
        eval pack $menubutton_ $args

        # stores the list of defined pages during the session
        set pagelist_ {}
}

MBPageList public get_menubutton {} {
        return [$self set menubutton_]
}

MBPageList public get_copy {parent} {
	global tcl_version
	if {$tcl_version >= 8} {
		set clonemenu $parent.pagelist
		[lindex [$self set menus_] 0] clone $clonemenu
		return $clonemenu
	}

	# for tk version 7.4 and below
        $self instvar menus_ pagelist_ pageMgr_
	set medfont [$self get_option medfont]

        set menu [menu $parent.pagelist -tearoff 0]
        foreach pageid $pagelist_ {
                $menu add radiobutton -label [$self page_label $page_id] \
                                -value $page_id -font $medfont\
				-variable [$self tkvarname currPage_] \
                                -command "$pageMgr_ switch_page_later $page_id"

        }
        lappend menus_ $menu
        return $menu
}

MBPageList public tearoff {menu newmenu} {
        $self instvar menus_
        lappend menus_ $newmenu

        wm title $newmenu "MB Pages"
        wm resizable $newmenu false false
}

# function to be called when mb changes page
MBPageList public switch_page {page_id} {
	[$self set menubutton_] configure -text [$self page_label $page_id]
	$self tkvar currPage_
	set currPage_ $page_id
}

MBPageList private page_label {page_id} {
	return [[$self set pageMgr_] page_label $page_id]
}

# add a new page
MBPageList public add_page {page_id} {
        $self instvar menubutton_ pagelist_ menus_ labels_

        # sort according to srcid, than page number
        # page id is: addr_uid:pguid
        set wrk [split $page_id :]
        set host [lindex $wrk 0]
        set puid "0x"
        append puid [lindex $wrk 1]
        set idx 0
        foreach elt $pagelist_ {
                set wrk [split $elt :]
                if {[lindex $wrk 0] > $host} {
                        incr idx
                        continue
                }
                if {[lindex $wrk 0] == $host} {
                        set p "0x"
                        append p [lindex $wrk 1]
                        if {$puid > $p} {
                                incr idx
                                continue
                        }
                }
                break
        }
	#        puts "pagelist_ is: $pagelist_"
	#        if [info exists elt] { puts "elt=$elt idx=$idx" }
	set sortedlist [linsert $pagelist_ $idx $page_id]
	#        puts "new sortedlist is $sortedlist"
	set next_idx [lindex $sortedlist [expr $idx + 1]]
	#        puts "next_idx=$next_idx"

	# either append or insert before the label
	if {$next_idx=={}} {
                set next_idx "end"
        } else {
                set next_idx $labels_($next_idx)
        }
	set medfont [$self get_option medfont]

	global tcl_version
	# tcl version 8 and above will insert them automatically into
	# all forked off menus...
	if {$tcl_version < 8} {
		set menu_list $menus_
	} else {
		set menu_list [lindex $menus_ 0]
	}
	$self instvar pageMgr_
        foreach menu $menu_list {
                $menu insert "$next_idx" radiobutton -label \
                                [$self page_label $page_id] \
                                -value $page_id \
				-variable [$self tkvarname currPage_] \
                                -command "$pageMgr_ switch_page_later $page_id" \
                                -font $medfont
        }
        set labels_($page_id) [$self page_label $page_id]
        if {$pagelist_==""} {
                $menubutton_ configure -text [$self page_label $page_id]
                set currPage_ $page_id
        }
        set pagelist_ $sortedlist
}

MBPageList instproc pagelist {} {
	return [$self set pagelist_]
}

# dir is +1 or -1
MBPageList instproc nextPage { dir } {
        $self instvar pagelist_ pageMgr_
        if {$pagelist_=={}} { return }
        set c [lsearch -exact $pagelist_ [$pageMgr_ current_page]]
        set i $c
        if {$i==-1} {
                puts stderr "current page not in list! should not happen"
        }
        set l [llength $pagelist_]
        #wrap around
        incr i $dir
        set i [ expr ($i < 0) ? ($l - 1) : (($i >= $l) ? 0 : $i) ]
        if {$i != $c} {
                set next_pg [lindex $pagelist_ $i]
                mtrace trcVerbose "next_pg=$next_pg i=$i l=$l"
                $pageMgr_ switch_page_later $next_pg
        }
}

# source info has changed, update the page name to reflect it
MBPageList instproc update_src_info {src newcname} {
        $self instvar labels_ menus_ pagelist_
        # the pages are sorted according to page_ids', so when a cnames
        # is updated, only the label of pages from the source needs to be
        # changed.
        foreach pageid $pagelist_ {
                # puts "matching $pageid"
                #set patt [join [list [$src addr-hex] "_" [format "%x" [$src
                #uid]] "*"] ""] c

                set srcid [split [$src srcid] "@"]
                set patt [join [list [lindex $srcid 1] "_" \
                                [lindex $srcid 0] "*"] ""]

                # puts "with $patt"
                if [string match $patt $pageid] {
                        set newLabel [$self page_label $pageid]
                        # puts "match $labels_($pageid)"
                        foreach menu $menus_ {
                                $menu entryconfigure $labels_($pageid) \
                                                -label $newLabel
                        }
                        set labels_($pageid) $newLabel
                }
        }
	$self instvar menubutton_
	$self tkvar currPage_
	if [info exists currPage_] {
		$menubutton_ configure -text [$self page_label $currPage_]
	}
}
