# scrolled-ui.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/mplug/scrolled-ui.tcl,v 1.5 2002/02/03 04:27:54 lim Exp $


import ScrolledWindow Icons

Class ScrolledUI


ScrolledUI instproc init { {w {}} } {
	$self next
	$self instvar main_

	if { $w=={} } {
		set main_ .main
	} else {
		set main_ $w
	}

	#option add *ScrolledWindow*Scrollbar.borderWidth 1
	#option add *ScrolledWindow*Scrollbar.highlightThickness 0
	#option add *ScrolledWindow*Scrollbar.width 10

	set main_ [ScrolledWindow $main_ -scrollbar both -options \
			{{hscroll.borderwidth 1} \
			{hscroll.highlightthickness 0} \
			{hscroll.width 10} \
			{vscroll.borderwidth 1} \
			{vscroll.highlightthickness 0} \
			{vscroll.width 10}} ]
	set logo_frame [frame $main_.logo_frame]
	set logo [button $main_.logo -image Icons(cal) -padx 4 -pady 0 -bd 0 \
			-highlightthickness 0 -activebackground \
			[WidgetClass widget_default -background]]

	#
	# FIXME: I'm using some of my knowledge of the internals of the
	# ScrolledWindow object to get the following to work
	#
	set hscroll [$main_ subwidget hscroll]
	foreach entry [$hscroll configure] {
		if { [llength $entry]==5 } {
			lappend config [lindex $entry 0] [lindex $entry 4]
		}
	}

	set pack [pack info $hscroll]

	# must destroy and recreate the scrollbar, since it should be
	# created after the logo_frame

	$main_ subwidget bbox configure -xscrollcommand ""
	destroy $hscroll
	eval scrollbar $hscroll $config
	$main_ subwidget bbox configure -xscrollcommand "$hscroll set"

	pack $hscroll -side left -fill both -expand 1 -in $logo_frame -anchor s
	pack $logo -side right -fill y -in $logo_frame
	eval pack $logo_frame $pack

	pack $main_ -fill both -expand 1
}


ScrolledUI instproc root { } {
	$self instvar main_
	return [$main_ subwidget window]
}


Class MPlug/ScrolledUI -superclass { MPlug ScrolledUI }

