# gwtest.tcl --
#
#       Just to avoid the ui
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import CoordinationBus

proc mtrace { d s } {
	puts $s
}

Class GWTester
GWTester instproc alive { info } {
	$self instvar srcspec_
puts lklk
	if ![info exists srcspec_] {
puts xxxx
		set srcspec_ 1
		$self initgw
	}
}

GWTester instproc init {} {
	$self next
	$self instvar cb_
	set cb_ [new CoordinationBus -channel 3]
	$cb_ register alive "$self alive"
}

GWTester instproc initgw {} {
	$self instvar cb_

	set A global
	set B local

	$cb_ send "cb_init"
	# places of the world
#	$cb_ send cb_sessions "$A=224.2.172.238/51482/none/4!$B=128.32.131.58/6666/none/4"
	# mash video session
	$cb_ send cb_sessions "$A=224.2.196.249/50754/none/4!$B=224.2.6.8/8888/none/15"
	# mash audio sessions
#	$cb_ send cb_sessions "$A=224.2.204.152/25970/none/4!$B=224.6.6.6/6666/none/15"
	# mash encrypted video session
#	$cb_ send cb_sessions "$A=224.2.134.83/54248/none/4!$B=224.6.6.6/6666/none/15"
	# kb/s
	$cb_ send cb_set $A sessionbw 64000
	$cb_ send cb_set $B sessionbw 64000
	$cb_ send cb_set $A RC 0
	$cb_ send cb_set $B RC 1
#	$cb_ send cb_set $A txonly 0
#	$cb_ send cb_set $B txonly 1
	$cb_ send cb_set $A color 1
	$cb_ send cb_set $B color 1
	$cb_ send cb_set $A ofmt h261
	$cb_ send cb_set $B ofmt h261
#	$cb_ send cb_set $A key DULL/megatest
#	$cb_ send cb_set $B key DULL/megatest
}

set gwt [new GWTester]
vwait forever
