# layout.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#
# Used to aggregate info on a setup of video windows
# in rvic, defined by msgs:
# <br> "Set VideoWindowGeom CxD+A+B"
# <br> "Set VoiceSwitchList `vw_num list' ..."
# <br> "Set TimerSwitchList `vw_num list' ..."
# <br> "Set TimerSwitchInterval `vw_num secs' ..."
# <br>
#
Class RvicLayout

# create a new rvic layout
RvicLayout public init {{name "empty"} {msg ""}} {
	$self instvar numWindows_ name_ windows_
	set name_ $name
	set numWindows_ 0

	$self parse_msgs $msg
}

# parse a list of msgs and configure the layout appropriately
RvicLayout private parse_msgs {msg} {
	set msglist [$self convert_to_msglist $msg]
	foreach m $msglist {
		set m [string trim $m]
		if {[lindex $m 0] != "Set"} {
			puts "Bad msg in RvicLayout::init -- $m"
			continue
		}
		set i1 [lindex $m 1]
		switch $i1 {
			"VideoWindowGeom" {$self VideoWindowGeom $m}
			"VoiceSwitchList" {$self VoiceSwitchList $m}
			"TimerSwitchList" {$self TimerSwitchList $m}
			"TimerSwitchInterval" {$self TimerSwitchInterval $m}
		}
	}
}

#
RvicLayout public num_windows {} {return [$self set numWindows_]}

#
RvicLayout public name {} {return [$self set name_]}

#
RvicLayout public get_window {idx} {
	$self instvar windows_ numWindows_
	if ![info exists windows_($idx)] {
		set windows_($idx) [new RvicWindow]
		incr numWindows_
	}
	return $windows_($idx)
}

#
RvicLayout private VideoWindowGeom {msg} {
	set data [split $msg "\n"]
	set data [lrange $data 1 end]
	foreach line $data {
		set line [string trim $line]
		set idx [lindex $line 0]
		set val [lrange $line 1 end]
		set w [$self get_window $idx]
		$w geom $val
	}
}

#
RvicLayout private VoiceSwitchList {msg} {
	set data [split $msg "\n"]
	set data [lrange $data 1 end]
	foreach line $data {
		set line [string trim $line]
		set idx [lindex $line 0]
		set val [lrange $line 1 end]
		set w [$self get_window $idx]
		$w is_voice_switched 1
		$w voice_switch_list $val
	}
}

#
RvicLayout private TimerSwitchList {msg} {
	set data [split $msg "\n"]
	set data [lrange $data 1 end]
	foreach line $data {
		set line [string trim $line]
		set idx [lindex $line 0]
		set val [lrange $line 1 end]
		set w [$self get_window $idx]
		$w is_timer_switched 1
		$w timer_switch_list $val
		if ![$w timer_switch_interval] {
			$w timer_switch_interval 5
		}
	}

}

#
RvicLayout private TimerSwitchInterval {msg} {
	set data [split $msg "\n"]
	set data [lrange $data 1 end]
	foreach line $data {
		set line [string trim $line]
		set idx [lindex $line 0]
		set val [lrange $line 1 end]
		set w [$self get_window $idx]
		$w timer_switch_interval $val
	}
}

# takes a block of newline-separated "Get" and "Set" commands
# and parses them, returning a list of individual messages (each
# of which, temselves, may be multiple lines)
RvicLayout private convert_to_msglist {data} {
	set msglist ""
	set msg ""
	foreach i [split $data \n] {
		set i [string trim $i]
		set getset [string range $i 0 3]
		if {$getset == "Get " || $getset == "Set "} {
			# dump previous buffer as cmd
			if {$msg != ""} {
				lappend msglist $msg
			}
			set msg $i
		} else {
			append msg "\n$i"
		}
	}
	if {$msg != ""} {
		lappend msglist $msg
	}
	#puts "[llength $msglist] $msglist"
	return $msglist
}


#----------------------#----------------------#----------------------
#----------------------#----------------------#----------------------


# maintains info on a single `window' in an RvicLayout
#
Class RvicWindow

#
RvicWindow public init {} {
	$self instvar geom_ is_timer_ is_voice_ tl_ t_int_ vl_
	set geom_ "1x1+0+0"
	set is_timer_ 0
	set t_int_ 0
	set is_voice_ 0
	set tl_ ""
	set vl_ ""
}

#
RvicWindow public geom {args} {
	$self instvar geom_
	if {[llength $args] == 0} {
		return $geom_
	} else {
		set geom_ $args
	}
}


#
RvicWindow public is_timer_switched {args} {
	$self instvar is_timer_
	if {[llength $args] == 0} {
		return  $is_timer_
	} else {
		set is_timer_ $args
	}
}

#
RvicWindow public timer_switch_list {args} {
	$self instvar tl_
	if {[llength $args] == 0} {
		return $tl_
	} else {
		set tl_ $args
	}
}

#
RvicWindow public timer_switch_interval {args} {
	$self instvar t_int_
	if {[llength $args] == 0} {
		return $t_int_
	} else {
		set t_int_ $args
	}
}

#
RvicWindow public is_voice_switched {args} {
	$self instvar is_voice_
	if {[llength $args] == 0} {
		return  $is_voice_
	} else {
		set is_voice_ $args
	}
}

#
RvicWindow public voice_switch_list {args} {
	$self instvar vl_
	if {[llength $args] == 0} {
		return $vl_
	} else {
		set vl_ $args
	}
}

