# ui-remote.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1993-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/rvic/ui-remote.tcl,v 1.32 2002/02/03 04:29:27 lim Exp $


#--------------#--------------#--------------#--------------
# ::TODO::
#  - cl/srvr rendezvous
#  - MUA agent
#  -X use regex's for switching
#  -X use cname if name not unique across members
#  -X fix format change causing decoders to get confused
#  -X fix race condition with shared memory writes to switching window
#--------------#--------------#--------------#--------------
# ::instance variable type info::
#  - window_() ==> video widgets
#  - attached_src_() ==> Source/RTPs
#  - active_()  ==> keys = Source/RTP ; attribs = SimpleActiveSource
#  - allsrcs_ ==> Source/RTP
#--------------#--------------#--------------#--------------

import RTPAgent AudioMonitor VisualFrame Rendezvous RvicLayout


#-------------#-------------#-------------#-------------
# Class SimpleActiveSource
#-------------#-------------#-------------#-------------

# SimpleActiveSource has no tile thumbnails, no cmenu,
# and useHW hard-coded to 0.
Class SimpleActiveSource

#
SimpleActiveSource instproc init { parent src } {
	$self next
	$self instvar src_ parent_
	set src_ $src
	set parent_ $parent
}

# bind a source to a window so that the video stream from
# source $src appears in window $vw
SimpleActiveSource instproc attach-window vw {
	$self instvar src_ parent_
	# useHW set to 0 FIXME
	$vw attach-decoder $src_ [[$parent_ set vframe_] set colorModel_] 0
}

#
SimpleActiveSource instproc detach-window vw {
	$self instvar src_
	$vw detach-decoder $src_
}

#
SimpleActiveSource instproc detach-windows {} {
	#puts "SimpleActiveSource($self)::detach-windows"
	$self instvar parent_

	for {set i 1} {$i < 10} {incr i} {
		set rtps [$parent_ attached_source $i]
		set ss [$parent_ rtp2simple $rtps]
		if {$ss == $self} {
			set w [$parent_ window $i]
			$self detach-window $w
			#puts "detaching window [$parent_ window $i]"
			$parent_ attached_source $i ""
		}
	}
}



#-------------#-------------#-------------#-------------
# Class RemoteVicUI
#-------------#-------------#-------------#-------------


import VicUI

#
# The main user interface for the rvic application.
#
Class RemoteVicUI -superclass VicUI

# returns SimpleActiveSource object for a given Source/RTP object
RemoteVicUI public rtp2simple {src} {
	$self instvar active_
	if {[info exists active_($src)]} {
		return $active_($src)
	} else {
		return ""
	}
}

# get or set attached_src_ instvar
RemoteVicUI public attached_source {i args} {
	#puts "RemoteVicUI::attached_source $i $args"
	$self instvar attached_src_

	if {[llength $args] > 0} {
		switch $args {
			""      {unset attached_src_($i)}
			"{}"    {unset attached_src_($i)}
			default {set attached_src_($i) $args}
		}
	} else {
		if {[info exists attached_src_($i)]} {
			return $attached_src_($i)
		} else {
			return ""
		}
	}
}

# window_ instvar accessor
#
RemoteVicUI public window {i} {
	$self instvar window_
	return $window_($i)
}

# resize & move window number `i' according to to `geom'
# <br> if `geom' == 0, delete (actually just hide) the window
#
RemoteVicUI public window_geom {i geom} {
	$self instvar active_ path_
	#puts "RemoteVicUI::window_geom $i => $geom"

	if {$geom == 0} {
		foreach {at val} "width 1 height 1 x 0 y 0" {
			set $at $val
		}
	} else {
		set gl [split $geom "x+"]
		set width [expr int([lindex $gl 0]*640)]
		set height [expr int([lindex $gl 1]*480)]
		set x [lindex $gl 2]
		set y [lindex $gl 3]
	}
	#puts "RemoteVicUI::window_geom $i => $width-by-$height at +$x+$y"

	set w [$self window $i]
	[$w window] resize $width $height
	place configure $path_.top.vw$i -relx $x -rely $y

	set att [$self attached_source $i]
	if {$att != ""} {
		if [info exists active_($att)] {
			set as $active_($att)
			$as detach-window $w
			$as attach-window $w
		}
	}
	after idle $w redraw
}

# toggle transmitting
RemoteVicUI public toggle_transmit {} {
	$self instvar controlMenu_ xmit_
	if $xmit_ {set xmit_ 0} else {set xmit_ 1}
	#puts "RemoteVicUI::toggle_transmit (xmit_= $xmit_)"
	$controlMenu_ invoke_transmit
}


#
# Build the "user-interface."
#
RemoteVicUI instproc build_gui { w } {
	$self instvar videoAgent_ grid_ label_ controlMenu_ path_ vpipe_ \
			vframe_ allsrcs_ window_ al_ voice_switched_ voice_sw_regex_ \
			timer_switched_ timer_sw_regex_ layout_switched_ currLayout_ \
			xmit_
	set path_ $w
	set vframe_ [new VisualFrame $w.top]
	set allsrcs_ ""
	set voice_switched_ "1" ; # defaults to vw 1
	set voice_sw_regex_(1) "*"
	set timer_switched_ "2" ; # defaults to vw 2
	set timer_sw_regex_(2) "*"
	set layout_switched_ 0
	set xmit_ [$self yesno transmitOnStartup]

	$self init_layouts

	wm geometry . 640x480+0+0
	place $w.top -x -5 -y -5 -width 640 -height 480
	label $w.top.l -text "Waiting to finish configuring video windows..."
	place $w.top.l -relx 0.5 -rely 0.5 -anchor c
	set currLayout_ "none"
	after idle "$self reconfig FocusPlusContext"
	after idle "wm title . {rvic on [localaddr]:\
			[$self get_option conferenceName]}"
	after idle "$self match_layout_to_srcs"
	after idle "$self start_timer_switching"

	bind . <s> "$self print-active-sources"
	bind . <q> "exit"
	bind . <a> "$self switch_src all"
	bind . <t> "$self toggle_transmit"
	foreach {key configname} {y FocusPlusContext u Single i BradyBunch2x2 \
			o BradyBunch3x3 p PictureInPicture} {
		bind . <$key> "$self reconfig $configname"
	}

	foreach i {1 2 3 4 5 6 7 8 9} {
		set p $w.top.vw$i
		set window_($i) [new VideoWidget $p 320 240]
		bind all <Key-$i> "$self switch_src $i"
	}

	# Note: sending {} for the ActiveSourceManager parameter
	set controlMenu_ [new ControlMenu $self $videoAgent_ \
			$vpipe_ $vframe_ {} [new UISrcListWindow $w $videoAgent_]]
	$controlMenu_ build_window ;# never shows up

	# start remote control interface
	set ctrlAddr [$self get_option rvicCtrlSpec]
	set al_ [new RvicCtrl $ctrlAddr $self]

	# monitor the audio session for voice-switching
	set aspec [$self get_option audioMonitorSpec]
	if { $aspec != "" } {
		set ab [new AddressBlock $aspec]
		set monitor [new AudioMonitor $ab $self]
		# audio doesn't want traffic looped back
		#$audioAgent_ set-loopback 0
		# send back-to-back packets spaced out at 128kb/s
		#$audioAgent_ set-bandwidth 128
	}
	after 1000 "$self periodic_update"
}


# initialize to the set of "standard layouts", using the same syntax
# as messages on the wire
RemoteVicUI private init_layouts {} {
	$self instvar layouts_
	set layouts_ ""
	lappend layouts_ [new RvicLayout Single \
			"Set VideoWindowGeom\n\
			1 1.0x1.0+0.0+0.0\n\
			Set VoiceSwitchList\n\
			1 *"]
	lappend layouts_ [new RvicLayout PictureInPicture \
			"Set VideoWindowGeom\n\
			1 1.0x1.0+0.0+0.0\n\
			2 0.25x0.25+0.7+0.05\n\
			Set VoiceSwitchList\n\
			1 *\n\
			Set TimerSwitchList\n\
			2 *"]
	lappend layouts_ [new RvicLayout FocusPlusContext \
			"Set VideoWindowGeom\n\
			1 0.5x0.5+0.09375+0.09375\n\
			2 0.25x0.25+0.6875+0.0625\n\
			3 0.25x0.25+0.6875+0.3750\n\
			4 0.25x0.25+0.0625+0.6875\n\
			5 0.25x0.25+0.3750+0.6875\n\
			6 0.25x0.25+0.6875+0.6875\n\
			Set VoiceSwitchList\n\
			1 *\n\
			Set TimerSwitchList\n\
			2 *"]
	lappend layouts_ [new RvicLayout BradyBunch2x2 \
			"Set VideoWindowGeom\n\
			1 0.5x0.5+0.0+0.0\n\
			2 0.5x0.5+0.5+0.0\n\
			3 0.5x0.5+0.0+0.5\n\
			4 0.5x0.5+0.5+0.5\n\
			Set VoiceSwitchList\n\
			1 *\n\
			Set TimerSwitchList\n\
			2 *"]
	lappend layouts_ [new RvicLayout BradyBunch3x3 \
			"Set VideoWindowGeom\n\
			1 0.25x0.25+0.0625+0.0625\n\
			2 0.25x0.25+0.375+0.0625\n\
			3 0.25x0.25+0.6875+0.0625\n\
			4 0.25x0.25+0.0625+0.375\n\
			5 0.25x0.25+0.375+0.375\n\
			6 0.25x0.25+0.6875+0.375\n\
			7 0.25x0.25+0.0625+0.6875\n\
			8 0.25x0.25+0.375+0.6875\n\
			9 0.25x0.25+0.6875+0.6875\n\
			Set VoiceSwitchList\n\
			1 *\n\
			Set TimerSwitchList\n\
			2 *"]
}


#
# This reconfigures the video windows. <i>name</i> should be
# a string matching an RvicLayout::name of any of the existing
# RvicLayout objects listed in layouts_
#
RemoteVicUI instproc reconfig {name} {
	$self instvar currLayout_ allsrcs_ path_ layouts_

	# check for no sources
	if {[llength $allsrcs_] == 0} {
		if {[info commands $path_.top.l] == ""} {
			label $path_.top.l -text "Waiting for video..."
			place $path_.top.l -relx 0.5 -rely 0.5 -anchor c
		} else {
			$path_.top.l configure -text "Waiting for video..."
		}
		if {$currLayout_ == "none"} {after 6000 $self reconfig $name}
		foreach i {1 2 3 4 5 6 7 8 9} {
			$self window_geom $i 0
		}
		return
	} else {
		destroy $path_.top.l
	}

	set doneSwitch 0
	# check `name' against each layout
	foreach l $layouts_ {
		if {$name == [$l name]} {
			set doneSwitch 1
			set n [$l num_windows]
			for {set i 1} {$i <= $n} {incr i} {
				$self window_geom $i [[$l get_window $i] geom]
			}
			for {set i [expr $n+1]} {$i <= 9} {incr i} {
				$self window_geom $i 0
			}
		}
	}
	if !$doneSwitch {
		puts "reconfig:: Bad layout: $name"
		return
	}
	set currLayout_ $name
}


# Set up video widgets so that as many sources as possible are shown
# (a so-called "default view")
RemoteVicUI private default_vw_views {} {
	$self instvar active_ allsrcs_ layout_switched_

	set l [llength $allsrcs_]
	if {$l == 0} {
		after 5000 "$self default_vw_views"
		return
	}

	foreach i {1 2 3 4 5 6 7 8 9} {
		set idx [expr ($i-1) % $l]
		set s [lindex $allsrcs_ $idx]
		$self switch_src_to $i $s
	}
}

# finds best match of configuration of windows
# to the number of sources by count of the number of windows.
# `Best' is defined as:
# <br><i> the minimum numwins s.t. numwins >= numsrcs </i> .
# <br> if <i> numsrcs > numwins </i> for all layouts, the layout
# with maximum numwins is used
#
RemoteVicUI public match_layout_to_srcs {} {
	#puts "RemoteVicUI::match_layout_to_srcs"
	$self instvar allsrcs_ layout_switched_ layouts_

	if !$layout_switched_ {return}

	set nsrcs [llength $allsrcs_]
	set bestN 9999
	set bestL ""
	set maxN 0
	set maxL ""
	foreach l $layouts_ {
		set nwins [$l num_windows]
		if {$nwins > $maxN} {
			set maxN $nwins
			set maxL $l
		}
		#puts "$nsrcs <= $nwins && $nwins <= $bestN"
		if {$nsrcs <= $nwins && $nwins < $bestN} {
			set bestL $l
			set bestN $nwins
		}
	}
	if {$bestL == ""} {set bestL $maxL}
	#puts "best layout: [$bestL name] for $nsrcs srcs"
	$self reconfig [$bestL name]
	$self default_vw_views
}

# Return a list of the active simpleactivesources.
RemoteVicUI instproc active-sources {} {
	$self instvar active_
	return [array names active_]
}

# prints active simpleactivesources.
RemoteVicUI instproc print-active-sources {} {
	foreach i [$self active-sources] {puts "$i: [$i sdes cname] / [$i getid]"}
}


#
# Add the SimpleActiveSource, <i>ss</i>, to the <i>active_</i>
# array (indexed by Source/RTP, <i>src</i>).
# Also add the Source/RTP to the list, <i>allsrcs_</i>.
RemoteVicUI instproc add_active { ss src } {
	$self instvar active_ allsrcs_
	set active_($src) $ss
	lappend allsrcs_ $src
	$self match_layout_to_srcs
}

#
# Remove the Source, <i>src</i>, from the <i>active_</i> array and
# the <i>allsrcs_</i> list.
#
RemoteVicUI instproc rm_active src {
	$self instvar active_ allsrcs_
	unset active_($src)
	set i [lsearch $allsrcs_ $src]
	if {$i != -1} {
		set allsrcs_ [lreplace $allsrcs_ $i $i]
	}
	$self match_layout_to_srcs
}

#
# Update the source descprtion by updating the element of the global
# arrays src_info(), src_nickname(), and src_name() indexed by the
# specified <i>src</i>.  If the src_name() is changed, then this can
# be reflected via change_name
#
RemoteVicUI instproc trigger_sdes src {
	global src_info src_nickname src_name
	# Figure out best presentation from available information.
	set name [$src sdes name]
	set cname [$src sdes cname]
	set addr [$src addr]
	if { $name == "" } {
		if { $cname == "" } {
			set src_nickname($src) $addr
			set info $addr/[$src format_name]

		} else {
			set src_nickname($src) $cname
			set info "$addr/[$src format_name]"
		}
	} elseif [cname_redundant $name $cname] {
		set src_nickname($src) $name
		set info $addr/[$src format_name]
	} else {
		set src_nickname($src) $name
		set info $cname/[$src format_name]
	}
	set src_info($src) $cname/[$src format_name]

	set msg [$src sdes note]
	if { $msg != "" } {
		set info $msg
	}
	set src_info($src) $info

	# only call change_name when name really changes
	if { ![info exists src_name($src)] || "$src_name($src)" != "$name" } {
		set src_name($src) $name
		$self change_name $src
	}
}

# noop
RemoteVicUI private change_name src {
	#puts "RemoteVicUI::change_name $src ([$src sdes name]/[$src sdes cname])"
	#Switcher rebuild_switch_list_menu
}


# Add a src to the active senders list.  creates a
# SimpleActiveSource rather than an ActiveSource:
# i.e., no postage stamp window
RemoteVicUI instproc activate src {
	#
	# give the VideoAgent a chance to create and install
	# a decoder and for that decoder to see a packet so it can
	# determine the output geometry and color decimation.
	# we shouldn't have to do this (e.g., resize will
	# take care of a geometry change), but currently
	# decoders can't trigger a renderer realloation
	# when the decimation changes.FIXME fix this
	#
	after idle "$self really_activate $src"
}

#
RemoteVicUI instproc really_activate src {
	set as [new SimpleActiveSource $self $src]
	$self add_active $as $src
	$self instvar allsrcs_ active_
	# if any windows are empty, allocate this stream to them
	foreach i {1 2 3 4 5 6 7 8 9} {
		if {[$self attached_source $i] == ""} {
			$as attach-window [$self window $i]
			$self attached_source $i $src
		}
	}
}

# Remove a src from the active senders list.
#
RemoteVicUI instproc deactivate src {
	#puts "RemoteVicUI::deactivate: $src"
	$self instvar active_
	if [info exists active_($src)] {
		set as $active_($src)
		$as detach-windows
		$self rm_active $src
	}

	$src handler ""
}


# deal with format change  <br>
# (only marginally tested: doesn't crash but the decoders can get confused)
RemoteVicUI instproc trigger_format src {
	#puts "RemoteVicUI::trigger_format [$src getid]"
	$self instvar active_ videoAgent_
	if ![info exists active_($src)] {
		return
	}
	set as $active_($src)
	set L ""
	for {set i 1} {$i < 10} {incr i} {
		if {[$self attached_source $i] == $src} {
			lappend L $i
		}
	}
	$as detach-windows
	#FIXME
	set extoutList [extout_detach_src $src]

	set d [$videoAgent_ reactivate $src]
	###set d [$videoAgent_ create_decoder $src]
	$self update_decoder $src

	foreach i $L {
		set w [$self window $i]
		$as attach-window $w
		$w redraw
	}
	#FIXME
	extout_attach_src $src $extoutList
}

#
# Called when the video stream state changes in a way that would
# affect the choice of renderer.  For example, when a jpeg stream
# changes from type-0 to type-1 we might have to revert from
# hardware to software decoding, or we might have to reallocate
# a 422 renderer as a 411 renderer.  This never needs to happen
# for most stream types (i.e., because the decimation factor is fixed).
# <br> FIXME - copied from hvic -- NEVER TESTED
RemoteVicUI instproc decoder_changed src {
	$self instvar active_
	if ![info exists active_($src)] {
		return
	}
	#FIXME redundant with trigger_format
	set as $active_($src)
	$as detach-windows
	#FIXME
	set extoutList [extout_detach_src $src]
	foreach w $iw {
		$as attach-window $uw
		$w redraw
	}
	#FIXME
	extout_attach_src $src $extoutList
	return
}



#-------------#-------------#-------------#-------------
# methods for dealing with switching window sources
#-------------#-------------#-------------#-------------


#
RemoteVicUI instproc switch_src_by_name {int name} {
	$self instvar allsrcs_ active_

	#puts "trying to switch $int to $name"
	if { [llength $allsrcs_] > 0 } {
		if {$name == ""} {
			$self switch_src $int
			return
		}
		set target ""
		foreach s [array names active_] {
			#puts "$name ?=? [$s getid]"
			if {[string first $name [$s getid]] != -1} {
				set target $s
			}
		}
		if { $target == "" } {
			foreach s [array names active_] {
				if {[string first $name [$s sdes cname]] != -1} {
					set target $s
				}
			}
		}
		if { $target == "" } {
			foreach s [array names active_] {
				if {[string first $name [$s sdes name]] != -1} {
					set target $s
				}
			}
		}
		if { $target == "" } {
			foreach s [array names active_] {
				if {[string first $name [$s sdes note]] != -1} {
					set target $s
				}
			}
		}
		if { $target == "" } {
			puts stderr "no target - \"$name\""
			if {[llength $name] > 1} {
				puts "heuristic: trying [lindex $name 0]"
				if {[regexp -nocase [lindex $name 0] [$s getid]]} {
					set target $s
				}
			}
			if { $target == "" } {
				$self switch_src $int
				return
			}
		}
		$self switch_src_to $int $target
	}
}

# for timer- or iterative- switching window `num': <br>
# returns the "next" source in the list of sources
# or "" if there are no sources
RemoteVicUI public next_src {num} {
	$self instvar allsrcs_

	set len [llength $allsrcs_]
	if { $len > 0 } {
		set curr_src [$self attached_source $num]
		if {$curr_src != ""} {
			set j [lsearch $allsrcs_ $curr_src]
			set j [expr ($j+1) % $len]
			return [lindex $allsrcs_ $j]
		} else {
			return [lindex $allsrcs_ 0]
		}
	} else {
		return ""
	}
}

# switch to next src in window `num' <br>
# if num == "all", switch all the windows
RemoteVicUI instproc switch_src {num} {
	if {$num == "all"} {
		for {set i 1} {$i < 10} {incr i} {
			$self switch_src $i
		}
		return
	}

	$self instvar allsrcs_
	set len [llength $allsrcs_]
	if { $len > 0 } {
		set nxt [$self next_src $num]
		if {$nxt != ""} {
			$self switch_src_to $num $nxt
		}
	}
}

# switch window number `num' to source object `src'
RemoteVicUI public switch_src_to {num src} {
	$self instvar active_

	set w [$self window $num]
	if {[info exists active_($src)]} {
		# detach old source
		set curr_src [$self attached_source $num]
		if {$curr_src != ""} {
			if {[info exists active_($curr_src)]} {
				set olds $active_($curr_src)
				$olds detach-window $w
			}
		}
		# attach new source
		set as $active_($src)
		$as attach-window $w
		$self attached_source $num $src
		$w redraw
	}
}


#
# <i>audio_src</i> is an audio src. <br>
# <i>allsrcs_</i> are video sources <br>
# only voice-switches windows with indicies indicated
# in the list variable `voice_switched_'
#
RemoteVicUI instproc switch_to audio_src {
	$self instvar allsrcs_ active_ voice_switched_

	if { [string match *CoLab* [$audio_src getid]] } {
		puts "Warning: ignoring CoLab audio sources..."
		return
	}
	if { [llength $allsrcs_] > 0 } {
		set target ""
		foreach s $allsrcs_ {
			if { "[$audio_src sdes cname]" == "[$s sdes cname]" } {
				set target $s
			}
		}
		if { $target == "" } {
			puts stderr "no target: [$audio_src sdes cname]"
			return
		}
		foreach i $voice_switched_ {
			$self switch_src_to $i $target
		}
	}
}

#-----------------#-----------------#
# Timer switching
#-----------------#-----------------#


# initialize or re-initialize window timer switching
RemoteVicUI private start_timer_switching {} {
	$self instvar timer_switched_ timer_sw_int_

	# set default switch time
	foreach i {1 2 3 4 5 6 7 8 9} {
		set timer_sw_int_($i) 5
	}
	foreach i $timer_switched_ {
		$self sched_timer $i
	}
}

# schedule the next timer switching event for window `num'
# if it should be switched, canceling any existing scheduled switch
RemoteVicUI private sched_timer {num} {
	$self instvar timer_switched_ timer_sw_regex_ timers_ timer_sw_int_
	if [info exists timers_($num)] {
		after cancel $timers_($num)
	}

	# check for reasons to stop switching this window
	set idx [lsearch -exact $timer_switched_ $num]
	if {$idx == -1} {return}
	if {$timer_sw_int_($num) == 0} {
		set timer_switched_ [lreplace $timer_switched_ $idx $idx]
		return
	}

	set ms [expr $timer_sw_int_($num)*1000]
	set timers_($num) [after $ms "$self timer_switch $num"]
}

# timer-switch window `num', and then schedule the next switch
RemoteVicUI private timer_switch {num} {
	$self instvar timer_sw_int_ timer_sw_regex_ timers_
	# FIXME ignoring regex for now...
	$self switch_src $num
	unset timers_($num)
	$self sched_timer $num
}


#---------------#---------------#---------------#---------------
# RemoteVicUI methods that deal with messages of the form
#  Set MethodName  or  Get MethodName
#---------------#---------------#---------------#---------------

#
RemoteVicUI private SourceList {data} {
	$self instvar al_
	set reply "SourceList"
	foreach i [$self active-sources] {
		append reply "\n" [$i getid]
		#append reply "\n" [$i sdes cname]
	}
	$al_ announce $reply
}

#
RemoteVicUI private MonitorStyleList {data} {
	$self instvar al_ layouts_
	set reply "MonitorStyleList\n"
	foreach layout $layouts_  {
		append reply "[$layout name] {"
		for {set i 1} {$i <= [$layout num_windows]} {incr i} {
			append reply "[[$layout get_window $i] geom] "
		}
			append reply "}\n"
	}
	$al_ announce $reply
}

#
RemoteVicUI private MonitorStyle {data} {
	$self instvar al_ currLayout_
	if {[lrange $data 2 end] == ""} {
		$al_ announce "MonitorStyle $currLayout_"
	} else {
		$self reconfig [lrange $data 2 end]
	}
}

#
RemoteVicUI private VideoWindow {data} {
	$self instvar al_
	if {[llength $data] > 3} {
		$self switch_src_by_name [lindex $data 2] [lrange $data 3 end]
	} elseif {[llength $data] == 3} {
		$self switch_src [lindex $data 2]
	} else {
		# blank argument: return update of vw-->cname mapping
		set reply "VideoWindow\n"
		append reply [$self build_sources_list]
		$al_ announce $reply
	}
}

#
RemoteVicUI private VideoWindowGeom {data} {
	$self instvar al_
	if {[llength $data] == 2} {
		# FIXME respond with the geoms of the windows
		#
		#
		return
	}
	set lines [split $data \n]
	set lines [lrange $lines 1 end]
	foreach line $lines {
		if {$line == ""} {continue}
		set idx [lindex $line 0]
		set val [lrange $line 1 end]
		$self window_geom $idx $val
	}
}

#
RemoteVicUI private Autoswitchlayout {data} {
	$self instvar al_ layout_switched_
	switch [llength $data] {
		2 {
			if $layout_switched_ {set ls on} else {set ls off}
			$al_ announce "Autoswitchlayout $ls"
		}
		3 {
			set onoff [lindex $data 2]
			$self set_autoswitching $onoff
		}
		default {
			puts "Bad Autoswitchlayout msg: $data"
		}
	}
}

#
RemoteVicUI private VoiceSwitchList {data} {
	$self instvar voice_switched_ voice_sw_regex_ al_
	if {[llength $data] == 2} {
		set reply [$self build_vswlist]
		$al_ announce $reply
		return
	}
	set lines [split $data \n]
	set lines [lrange $lines 1 end]
	foreach l $lines {
		set idx [lindex $l 0]
		set val [lrange $l 1 end]
		if {$val == ""} {
			# disable voice-switching
			set lidx [lsearch -exact $voice_switched_ $idx]
			if {$lidx != -1} {
				set voice_switched_ \
						[lreplace $voice_switched_ $lidx $lidx]
			}
			return
		}
		if {[lsearch -exact $voice_switched_ $idx] == -1} {
			lappend voice_switched_ $idx
			set voice_sw_regex_($idx) $val
		}
	}
}

#
RemoteVicUI private TimerSwitchList {data} {
	$self instvar timer_switched_ timer_sw_regex_ al_
	if {[llength $data] == 2} {
		set reply [$self build_tswlist]
		$al_ announce $reply
		return
	}
	set lines [split $data \n]
	set lines [lrange $lines 1 end]
	foreach l $lines {
		set idx [lindex $l 0]
		set val [lrange $l 1 end]
		if {$val == ""} {
			# disable timer-switching
			set lidx [lsearch -exact $timer_switched_ $idx]
			if {$lidx != -1} {
				set timer_switched_ \
						[lreplace $timer_switched_ $lidx $lidx]
			}
			return
		}
		if {[lsearch -exact $timer_switched_ $idx] == -1} {
			lappend timer_switched_ $idx
			set timer_sw_regex_($idx) $val
			$self sched_timer $idx
		}
	}
}

#
RemoteVicUI private SwitchInterval {data} {
	$self instvar timer_sw_int_
	set lines [split $data \n]
	set lines [lrange $lines 1 end]
	foreach l $lines {
		set idx [lindex $l 0]
		set val [lrange $l 1 end]
		set timer_sw_int_($idx) $val
		$self sched_timer $idx
	}
}

# Set or Get TransmitVideo state
RemoteVicUI private TransmitVideo {data} {
	$self instvar xmit_ al_
	switch [llength $data] {
		2 {}
		3 {
			set onoff [lindex $data 2]
			if {$xmit_ != $onoff} {$self toggle_transmit}
		}
		default {puts "Bad TransmitVideo msg: $data"}
	}
	$al_ announce "TransmitVideo $xmit_"
}

#
# answer with the current session IP address (one line per 
# layer). If the command is Set, set the session address
#
RemoteVicUI private SessionAddress {data} {
	$self instvar al_
	$self instvar videoAgent_


	if {[lindex $data 0] == "Set"} {
		# set the new session address
		set spec [lindex $data 2]
		$videoAgent_ reset_spec $spec
	}

	# answer with the current (or new) session address
	set reply "SessionAddress"

	# get the network manager object from the VideoAgent
	set networkManager [$videoAgent_ set network_]

	for {set i 0} {$i < [$networkManager set nchan_]} {incr i} {
		# get the ith network layer
		set networkLayer [$networkManager set net_($i)]
		# get the ith network layer's address and source
		append reply "\n" "[$networkLayer set addr_]/[$networkLayer set port_]"
	}

	$al_ announce $reply
}


#-------------#-------------
# helpers for message handlers
#-------------#-------------

#
RemoteVicUI private build_vswlist {} {
	$self instvar voice_switched_ voice_sw_regex_
	set reply "VoiceSwitchList"
	foreach i $voice_switched_ {
		append reply "\n$i $voice_sw_regex_($i)"
	}
	return $reply
}

#
RemoteVicUI private build_tswlist {} {
	$self instvar timer_switched_ timer_sw_regex_
	set reply "TimerSwitchList"
	foreach i $timer_switched_ {
		append reply "\n$i $timer_sw_regex_($i)"
	}
	return $reply
}

# set whether to automatically match layout to the number of srcs
RemoteVicUI private set_autoswitching {onoff} {
	$self instvar layout_switched_
	if {$onoff == "on"} {set onoff 1} else {set onoff 0}
	set layout_switched_ $onoff
	$self match_layout_to_srcs
}

# return a textual list of the current window sources
# (indexed, newline-separated lines)
#
# (TODO: also append sdes name if different, handle the two @ client)
RemoteVicUI private build_sources_list {} {
	#puts "RemoteVicUI::build_sources_list"
	set reply ""
	foreach i {1 2 3 4 5 6 7 8 9} {
		#puts "$i: [$self attached_source $i]"
		append reply "$i "
		set as [$self attached_source $i]
		if {![string match *_o* $as] && ![string match "" $as]} {
			puts "Error: attached_source returned `$as'"
		}
		if {$as != ""} {
			append reply [$as getid]
		} else {
			append reply "(empty)"
		}
		append reply "\n"
	}
	##puts " ... done."
	return [string trim $reply]
}



#-------------#-------------#-------------#-------------
# Class RvcCtrl
#-------------#-------------#-------------#-------------

import UDPServer

# The remote-control interface to RVIC
Class RvicCtrl -superclass UDPServer

#
RvicCtrl public init {spec parent} {
	eval [list $self] next $spec
	$self instvar parent_
	set parent_ $parent
	puts "listening for rvic-client ctrl msgs on $spec"
}

# on receipt of announcement, demuxes to an RemoteVicUI procedure
RvicCtrl private recv {addr port data size} {
	#puts "Msg: $addr/$port\[$size\]: $data"
	$self instvar parent_

	set msglist [$self convert_to_msglist $data]
	foreach i $msglist {
		set methodName [lindex $i 1]
		if {[[$parent_ info class] info instprocs $methodName] != ""} {
			#puts "invoking $methodName"
			$parent_ $methodName $i
		} else {
			set r "No method in parent class `[$parent_ info class]'\
					accepting msg from $addr/$port: `$data'"
			puts $r
			$self announce $r
		}
	}
}

# takes a block of newline-separated "Get" and "Set" commands
# and parses them, returning a list of individual messages (each
# of which, themselves, may be multiple lines)
RvicCtrl private convert_to_msglist {data} {
	set msglist ""
	set msg ""
	foreach i [split $data \n] {
		set i [string trim $i]
		set getset [string range $i 0 3]
		if {$getset == "Get " || $getset == "Set "} {
			# dump previous buffer as cmd
			if {$msg != ""} {
				lappend msglist $msg
			}
			set msg $i
		} else {
			append msg "\n$i"
		}
	}
	if {$msg != ""} {
		lappend msglist $msg
	}
	#puts "[llength $msglist] $msglist"
	return $msglist
}


