# camera-canonVCC1.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/serial/camera-canonVCC1.tcl,v 1.10 2002/02/03 04:29:47 lim Exp $


import SerialChannel

#
# The extension of SerialChannel specialized to the Canon VCC1
# Remote-Controllable Camera
#
Class SerialChannel/Camera-Canon-VCC1 -superclass SerialChannel

#
# init and open cam
#
SerialChannel/Camera-Canon-VCC1 public init { args } {
	eval [list $self] next $args

	# unused placeholders for speed control and presets
	$self instvar zoomPerc_ panPerc_ tiltPerc_ presets_
	set zoomPerc_ 0 ; set panPerc_ 0 ; set tiltPerc_ 0 ; set presets_ ""

	$self device "/dev/cuac01"
	$self stopBits 2
	$self parity none
	$self open
}

SerialChannel/Camera-Canon-VCC1 public move_left {} {
	$self send "0xff 0x30 0x30 0x00 0x53 0x32 0xef"
}

SerialChannel/Camera-Canon-VCC1 public move_right {} {
	$self send "0xff 0x30 0x30 0x00 0x53 0x31 0xef"
}

SerialChannel/Camera-Canon-VCC1 public move_stop {} {
	$self send "0xff 0x30 0x30 0x00 0x53 0x30 0xef"
}

SerialChannel/Camera-Canon-VCC1 public move_up {} {
	$self send "0xff 0x30 0x30 0x00 0x53 0x33 0xef"
}

SerialChannel/Camera-Canon-VCC1 public move_down {} {
	$self send "0xff 0x30 0x30 0x00 0x53 0x34 0xef"
}

SerialChannel/Camera-Canon-VCC1 public move_home {} {
	$self send "0xff 0x30 0x30 0x00 0x57 0xef"
}

SerialChannel/Camera-Canon-VCC1 public init_home {} {
	$self send "0xff 0x30 0x30 0x00 0x58 0x30 0xef"
}

SerialChannel/Camera-Canon-VCC1 public init_orig {} {
	$self send "0xff 0x30 0x30 0x00 0x58 0x31 0xef"
}

SerialChannel/Camera-Canon-VCC1 public zoom_in {} {
	$self send "0xff 0x30 0x30 0x00 0xa2 0x32 0xef"
}

SerialChannel/Camera-Canon-VCC1 public zoom_out {} {
	$self send "0xff 0x30 0x30 0x00 0xa2 0x31 0xef"
}

SerialChannel/Camera-Canon-VCC1 public zoom_stop {} {
	$self send "0xff 0x30 0x30 0x00 0xa2 0x30 0xef"
}

#
# ----- These are for interfaces that can't time the move/stop
#       combinations
#

SerialChannel/Camera-Canon-VCC1 public bump_left {} {
    $self move_left
    after 100
    $self move_stop
}

SerialChannel/Camera-Canon-VCC1 public bump_right {} {
    $self move_right
    after 100
    $self move_stop
}

SerialChannel/Camera-Canon-VCC1 public bump_up {} {
    $self move_up
    after 100
    $self move_stop
}

SerialChannel/Camera-Canon-VCC1 public bump_down {} {
    $self move_down
    after 100
    $self move_stop
}

SerialChannel/Camera-Canon-VCC1 public bump_in {} {
    $self zoom_in
    after 100
    $self zoom_stop
}

SerialChannel/Camera-Canon-VCC1 public bump_out {} {
    $self zoom_out
    after 100
    $self zoom_stop
}
