# session-srmv2.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


# Transmitter requires these

Session/SRMv2 set nf_ 0
Session/SRMv2 set np_ 0
Session/SRMv2 set nb_ 0
Session/SRMv2 set loopback_ 0
Session/SRMv2 set loopbackLayer_ 0
Session/SRMv2 set lossProb_ 0.20
Session/SRMv2 set c1_ 1.0
Session/SRMv2 set c2_ 0.0

# Right now, we use a periodic timer. This needs
# to change to an adaptive timer, once we
# determine the best scheme.
Class SRMv2AnnounceTimer -superclass Timer/Periodic


SRMv2AnnounceTimer instproc init { session } {
	$self next
	$self set session_ $session
}

SRMv2AnnounceTimer instproc timeout { } {
	$self instvar session_
	$session_ send-announcement
}

Session/SRMv2 instproc send-data { data seqno len {name "/"} } {
	$self instvar lsrc_
	$self transmit-data $lsrc_ $data $seqno $len $name
}

#Session/SRMv2 instproc start-announce { } {
#	$self instvar timer_ simloss_
#
#	set timer_ [new SRMv2AnnounceTimer $self]
#	$timer_ start 2000
#	set simloss_ 0
#}

Session/SRMv2 instproc destroy {} {
	$self instvar timer_
	delete $timer_

	$self next
}

#Session/SRMv2 instproc print-local-ns { } {
#	$self instvar lsrc_
#	[$lsrc_ set ns_] print
#}

Session/SRMv2 instproc send-bind { oid {name "/"} } {
#	$self transmit-bind "$oid:$name"
}

Session/SRMv2 instproc send-rreq { addr uid inst oid ss es } {
#	$self transmit-rreq "$addr,$uid,$inst $ss-$es" $oid
}

Session/SRMv2 instproc send-announcement { } {
	$self instvar lsrc_
	if [info exists lsrc_] {
		set announcement [$lsrc_ get-recent]
#		$self transmit-announcement "$announcement"
	}
}

Session/SRMv2 instproc manager { mgr } {
	$self instvar manager_
	set manager_ $mgr
	$self set-manager $mgr
}

Session/SRMv2 instproc have-network {} {
	$self instvar network_
	return [info exists network_]
}

Session/SRMv2 instproc install-key {key} {
	$self instvar network_
	if [info exists network_] {
		$network_ install-key $key
	}
}

Session/SRMv2 instproc network {} {
	$self instvar network_
	if ![info exists network_] {
		return none
	}
	return [$network_ data-net 0]
}

Session/SRMv2 instproc session-addr {} {
	$self instvar network_
	if ![info exists network_] {
		return none
	}
	return [[$self network] addr]
}

Session/SRMv2 instproc session-port {} {
	$self instvar network_
	if ![info exists network_] {
		return none
	}
	return [[$self network] port]
}

Session/SRMv2 instproc session-rport {} {
	$self instvar network_
	if ![info exists network_] {
		return none
	}
	return [[$self network] rport]
}

Session/SRMv2 instproc session-sport {} {
	$self instvar network_
	if ![info exists network_] {
		return none
	}
	return [[$self network] sport]
}

Session/SRMv2 instproc session-ttl {} {
	$self instvar network_
	if ![info exists network_] {
		return none
	}
	return [[$self network] ttl]
}

Session/SRMv2 instproc crypt_clear {} {
	if [info exists network_] {
		$network_ crypt_clear
	}
}

Session/SRMv2 instproc create-source { srcID } {
	$self instvar map_

	if ![info exists map_($srcID)] {
		set agent [new SRMv2_Source $srcID]
		$agent  init-vars $self $srcID
		set map_($srcID) $agent
		return $agent
	}
	$self start-announce
	return $map_($srcID)
}


Session/SRMv2 instproc create-local-source { srcID } {
	$self instvar lsrc_
	if ![info exists lsrc_] {
		set lsrc_ [$self create-source $srcID]
		$lsrc_ session $self
		$lsrc_ host [info hostname]
		$self local-source $lsrc_
	}
	return $lsrc_
}

Session/SRMv2 instproc get-name { oid srcID } {
	$self instvar map_
	if [info exists map_($srcID)] {
		set s $map_($srcID)
		return [$s name $oid]
	}
	set s [$self create-source $srcID]
	#
	# Since we just created the source, the bind message must've
	# been lost
	#
	# Request a pair for container 0 [0-cnt_]
	$self send-rreq $srcID  0 1 $oid
	return ""
}

Session/SRMv2 instproc bind-name { combo srcID } {
	$self instvar map_
	if [info exists map_($srcID)] {
		set s $map_($srcID)
	}
	set s [$self create-source $srcID]
	$s add-binding $combo $srcID
}


Session/SRMv2 instproc handle-data { data oid ss len srcID } {
	$self instvar simloss_
	incr simloss_
	if {$simloss_ == 3} {
		set simloss_ 0
		return
	}
	# Packet survived this time.
	set s [$self create-source $srcID]
	$s detect-loss $oid $ss [expr $ss + $len - 1]
}

Session/SRMv2 instproc handle-rreq { srcID range oid } {
	$self instvar map_
	if [info exists map_($srcID)] {
		# Zero'th object corresponds to
		# bind container, which we cache.
		# For other objects, the request has to be
		# propagated up to the SRMv2Manager.
		if {$oid == 0} {
			$self repair-bind $map_($srcID) $range
		} else {
			puts "No data repairs yet."
		}
	}
}

Session/SRMv2 instproc handle-rrep { oid srcID data } {
	if {$oid == 0} {
		set blist [split $data " "]
		foreach b $blist {
			$self bind-name $b $srcID
		}
	}
}

Session/SRMv2 instproc handle-announce { announcement srcID } {
	set agent [$self create-source $srcID]
	foreach a $announcement {
		set alist [split   $announcement ":"]
		set oid   [lindex  $alist 0]
		set last  [lindex  $alist 1]

		# This is similar to receiving a 1B data packet
		# when it comes to updating object database information
		$agent update-objinfo $oid $last $last
	}
}

Session/SRMv2 instproc repair-bind { agent range } {
	set f  [split $range "-"]
	set ss [lindex $f 0]
	set es [lindex $f 1]

	set data ""
	for {set i $ss} {$i <= $es} {incr i} {
		set data "$data $i:[$agent name $i]"
	}
#	puts "repair data :: $data"
#	$self transmit-rrep $data 0
}

