# agent-rmx.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/tgmb/agent-rmx.tcl,v 1.4 2002/02/03 04:30:13 lim Exp $


import ALM/RMX TCP TGMB_Manager SRMAgent

Class RMXAgent


RMXAgent public initialize {servinst megactrl} {
	$self instvar sessSpec_ alm_ server_ port_

	# create the AS1 AnnounceListenManager
	set alm_ [new ALM/RMX $self $servinst $megactrl]

	set idx [string first : $servinst]
	set sessSpec_ [string range $servinst [expr $idx+1] end]
	# create the SRM agent
	puts "trying to create session for $sessSpec_ ($idx, '$servinst')"
	$self create_session $sessSpec_

	# create the TCP server socket
	set server_ [new TCP/Server]
	$server_ open 0 TCP/MediaPad
	set port_ [lindex [fconfigure [$server_ channel] -sockname] 2]
	puts stderr "Created RMX servent on port $port_"
}


RMXAgent public destroy {} {
	$self instvar alm_ server_
	delete $alm_
	delete $server_
	$self next
}


RMXAgent public port {} {
	return [$self set port_]
}


RMXAgent instproc create_session { spec } {
        global mb
	$self instvar ui_

	$self instvar mgr_ srmagent_ session_ dummy_sender_

	set mgr_ [new TGMB_Manager]
	set srmagent_ [new SRMAgent 0xEEEEEE {} \
			"Mediaboard RMX @ [localaddr]"]
	#set dummy_sender_ [new MB_Sender]

	set session_ [$srmagent_ create-session $mgr_ $mgr_]
	$mgr_ attach_session $session_

	if { $spec != "" } {
		$srmagent_ reset_spec $spec
	}

	# make the manager it's own UI
	$mgr_ attach_ui $mgr_
}


RMXAgent instproc reset { ab } {
	$self instvar srmagent_ session_ have_network_
	set nm [$srmagent_ set network_]
	[$nm data-net] loopback 1
	[$nm ctrl-net] loopback 1

        # do this for the first time only
	if { ![info exists have_network_] || $have_network_==0 } {
		$self instvar mgr_
		$session_ start_timers
		$mgr_ create_dummy_rcvr
		set have_network_ 1
		#[$self set dummy_sender_] attach $mgr_
	}
}



TCP/MediaPad superclass {TCP SplitObject}

TCP/MediaPad public init {} {
	$self next
	puts "creating a server side socket"
}


TCP/MediaPad public open {chan} {
	$self next $chan
	$self set_binary 1
	$self set_socket $chan

	$self handshake
}


TCP/MediaPad instproc chunk_error { } {
	delete $self
}
