# sim.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable

import MyAfter QMStateMachine

Class QMSim

QMSim instproc init {spec} {
    $self instvar gauges_ inputs_ thresholds_ historySize_
    $self instvar myAfter_ index_ outfile_ sampleFile_

    set index_ 0
    set dir [lindex $spec 0]
    set historySize_ [lindex $spec 1]
    set thresholds_(speaker) [lindex $spec 2]
    set thresholds_(audienceLeft) [lindex $spec 3]
    set thresholds_(audienceCenter) [lindex $spec 4]
    set thresholds_(audienceRight) [lindex $spec 5]
    set timeSlice [lindex $spec 6]
    set switchThreshold [lindex $spec 7]

    set numDevices_ 2
    if {$numDevices_ > 1} {
	set inputs_ [list "speaker" "audienceLeft" "audienceCenter" "audienceRight"]
    } else {
	set inputs_ [list "speaker" "audienceLeft"]
    }

    foreach input $inputs_ {
	# gauge transducer
	set gauges_($input) [new Transducer/Gauge $historySize_ "$input"]
	# this sets the threshold value for each gauge transducer
	$gauges_($input) setThreshold $thresholds_($input)
    }

    set myAfter_ [new MyAfter]

    set callback "$self handleMode"
    set callback2 "$self recordSample"
    set gaugeList [array get gauges_]
    set stateFileName "log.states"
    set getIndexCallback "$self getCurrentIndex"
    set stateMachine_ [new QMStateMachine $inputs_ $gaugeList $timeSlice $callback $stateFileName $getIndexCallback 1 $myAfter_ $callback2 $switchThreshold]

    set filename "sim.out"
    if {[catch {open $filename w} outfile_]} {
	puts stdout "Cannot open file $filename for writing"
	return 0
    }
    set filename "sim.samples.speaker"
    set sampleFile_(speaker) [open $filename w]
    set filename "sim.samples.left"
    set sampleFile_(left) [open $filename w]
    set filename "sim.samples.right"
    set sampleFile_(right) [open $filename w]
    set filename "sim.samples.center"
    set sampleFile_(center) [open $filename w]

    $stateMachine_ enable

    # we've now created all the gauge transducers
    $self processFiles $dir $inputs_

    close $outfile_
    close $sampleFile_(speaker)
    close $sampleFile_(left)
    close $sampleFile_(center)
    close $sampleFile_(right)
}

QMSim instproc processFiles {dir inputs} {
    $self instvar gauges_ index_

    foreach input $inputs {
	set filename "$dir/$input.dat"
	if {[catch {open $filename r} infile($input)]} {
	    puts stdout "Cannot open file $filename for reading"
	    return 0
	}
    }

    # now have array of infile things

#    puts stdout "TitleText: QM Microphone Inputs"
#    puts stdout "XUnitText: Set() calls (every 16.67 ms)"
#    puts stdout "YUnitText: Raw value"

    set go 1
    while {$go} {
	set x 0
	foreach input $inputs {
	    set ok [gets $infile($input) line]
	    if {$ok < 0} {
		set go 0
	    } else {
		#puts stdout "$input: $line"
		set sLine [split $line " "]
		set index_ [lindex $sLine 0]
		set val [lindex $sLine 1]
		for {set y 0} {$y < $x} {incr y 1} {
#		    puts -nonewline "\t"
		}
#		puts stdout "$input: index=$index   val=$val"
		$gauges_($input) setCall $val
#		set sum [$trans getActiveSum]
#		puts $outFd "$index $sum"
	    }
	    incr x 1
	}
	$self timestep
    }

    foreach input $inputs {
	close $infile($input)
    }

    return 1
}

QMSim instproc timestep {} {
    $self instvar myAfter_

    # we need to advance by 60, but we want events that go off every
    #    250 ms to activate at 250, not 300
    $myAfter_ advanceTime 10
    $myAfter_ advanceTime 10
    $myAfter_ advanceTime 10
    $myAfter_ advanceTime 10
    $myAfter_ advanceTime 10
    $myAfter_ advanceTime 10
#    $myAfter_ printAll
}

QMSim instproc handleMode {mode} {
    $self instvar gauges_ index_ myAfter_ outfile_

    set time [$myAfter_ getTime]
#    puts $outfile_ "new mode is $mode, index=$index_, time=$time"
    puts $outfile_ "$index_ $mode"
}

QMSim instproc recordSample {} {
    $self instvar gauges_ index_ myAfter_ sampleFile_

    set time [$myAfter_ getTime]
    set sum(speaker) [$gauges_(speaker) getActiveSum]
    set sum(left) [$gauges_(audienceLeft) getActiveSum]
    set sum(center) [$gauges_(audienceCenter) getActiveSum]
    set sum(right) [$gauges_(audienceRight) getActiveSum]
#    puts $sampleFile_ "$index_ $s $l $c $r"
    set prev [expr $index_ - 0.01]
    set after [expr $index_ + 0.01]
    set inputs [list speaker left center right]
    foreach input $inputs {
	puts $sampleFile_($input) "$prev 0"
	puts $sampleFile_($input) "$index_ $sum($input)"
	puts $sampleFile_($input) "$after 0"
    }
}


QMSim instproc getCurrentIndex {} {
    $self instvar index_

    return $index_
}

