# switcher.tcl --
#
#       Used to control video source connections in 405
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

global g_app g_inputSource g_outputSource g_useScan g_quickSwitch

Import enable

import Application 405Client

Class MatrixSwitchApp -superclass Application

MatrixSwitchApp instproc init {argv} {
    $self instvar amx_

    $self next $argv
    $self initUI
#    $self initAmx garfield.cs.berkeley.edu 6905
    $self initAmx htsr.bmrc.berkeley.edu 6901
}

#
# GUI stuff
#

MatrixSwitchApp instproc initUI {} {
    global g_inputSource g_outputSource g_useScan g_quickSwitch

    wm title . "Video Matrix Switcher"
    wm minsize . 150 0

    frame .entry
    pack .entry -side top -pady 10

    frame .entry.in
    pack .entry.in -side left

    label .entry.in.label  -text "Input" -foreground blue
    pack .entry.in.label -side top
    set parent ".entry.in"

    lappend inputs [list "wideCamera" "Wide Camera"]
    lappend inputs [list "speakerCamera" "Speaker Camera"]
    lappend inputs [list "audienceCamera" "Audience Camera"]
    lappend inputs [list "frontPC" "Front PC"]
    lappend inputs [list "frontVCR" "Front VCR"]
    lappend inputs [list "elmo" "Elmo"]
    lappend inputs [list "laptop" "Laptop"]
    lappend inputs [list "sgiPC" "SGI PC"]
    lappend inputs [list "rackVCR" "Rack VCR"]
    lappend inputs [list "mbonePC" "MBone PC"]
    lappend inputs [list "liveboard" "Liveboard"]
    foreach item $inputs {
	set name [lindex $item 0]
	set desc [lindex $item 1]
	frame $parent.but$name
	pack $parent.but$name -side top -fill x
	radiobutton $parent.but$name.but -text "$desc" -variable g_inputSource -value "$name" -command "$self doQuickSwitch"
	pack $parent.but$name.but -side left
    }

    set g_inputSource wideCamera

    frame .entry.out
    pack .entry.out -side top

    label .entry.out.label  -text "Output" -foreground blue
    pack .entry.out.label -side top
    set parent ".entry.out"

    lappend outputs [list "realNetworks" "Real Networks"]
    lappend outputs [list "htsr" "HTSR"]
    lappend outputs [list "htsr2" "HTSR 2"]
    lappend outputs [list "projector" "Projector"]
    lappend outputs [list "testMonitor" "405 Closet Monitor"]
    foreach item $outputs {
	set name [lindex $item 0]
	set desc [lindex $item 1]
	frame $parent.but$name
	pack $parent.but$name -side top -fill x
	radiobutton $parent.but$name.but -text "$desc" -variable g_outputSource -value "$name" -command "$self doQuickSwitch"
	pack $parent.but$name.but -side left
    }

    set g_outputSource htsr

    checkbutton $parent.scanConvert -text "Proj use Scan Converter" -variable g_useScan
    pack $parent.scanConvert -side top
    set g_useScan 0

    frame .but
    pack .but -side top -pady 10

    checkbutton .but.quick -text "Switch when radio button changed" -variable g_quickSwitch
    pack .but.quick -side top
    set g_quickSwitch 0

    frame .but2
    pack .but2 -side top -pady 10

    button .but2.send -text "Switch" -command "$self doSwitch"
    pack .but2.send -side left

    # make exit button
    button .exit -text "Exit" -command "$self exitApp"
    pack .exit -side bottom
}

MatrixSwitchApp instproc initAmx { {hostname htsr.bmrc.berkeley.edu} {port 6901}} {
    $self instvar amx_

    set amx_ [new 405Client]
}

MatrixSwitchApp instproc exitApp {} {
    $self instvar amx_

    $amx_ closeConnection
    exit
}

MatrixSwitchApp public doSwitch {} {
    global g_inputSource g_outputSource g_useScan
    $self instvar amx_

#    puts stdout "routing $g_inputSource to $g_outputSource"

    $amx_ matrix_switchVideoStream $g_inputSource $g_outputSource $g_useScan
}

MatrixSwitchApp public doQuickSwitch {} {
    global g_inputSource g_outputSource g_useScan g_quickSwitch
    $self instvar amx_

    if {$g_quickSwitch} {
#	puts stdout "routing $g_inputSource to $g_outputSource"

	$amx_ matrix_switchVideoStream $g_inputSource $g_outputSource $g_useScan
    }
}

#
# driver engine
#

set g_app [new MatrixSwitchApp $argv]

# next line is very important!!!
vwait forever

