# session-receiver.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2001-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable
import Application VideoAgent VideoWidget VisualFrame VEUserWindow

######
#SessionReceiver
# This class receives and displays RTP streams of video as thumbnails from
# a single session. It creates the SessionReceiverSM which attaches to the 
# VideoAgent and VisualFrame.
# 

Class SessionReceiver -superclass Application

SessionReceiver instproc init {spec w} {
    $self next sessionReceiver
    $self instvar agent_ srcmgr_ w_ vframe_
    global view
    set agent_ [new VideoAgent $self $spec]
    set w_ $w
    
    if {$view == "vic"} {
	frame $w_
    }
    
    if {![winfo exists $w_.sources]} {
	set vframe_ [new VisualFrame $w_.sources]
    }
    set srcmgr_ [new SessionReceiverSM $agent_ $w_.sources $vframe_ $spec]
    pack $w_.sources -expand true -fill both -side right
    $agent_ attach $srcmgr_
    $vframe_ attach_observer $srcmgr_
}

#
# Detaches the SessionReceiverSM from the VideoAgent and the VisualFrame.
#
SessionReceiver instproc detachAll {} {
    $self instvar agent_ srcmgr_ vframe_
    $agent_ detach $srcmgr_
    $vframe_ detach_observer $srcmgr_
    $srcmgr_ remove_active
}

#
# Destroys all the toplevel UserWindows that were originated from this
# session.
#
SessionReceiver instproc unpack_VEuw {} {
    $self instvar srcmgr_
    set source_list [$srcmgr_ source_list]
    foreach source $source_list {
	if {[winfo exists .vw$source]} {
	    set veuw [$source source_veUW]
	    $veuw destroy
	}
    }
}

######
#SessionReceiverSM
# This is the source manager for the SessionReceiver, which is attached 
# to the VideoAgent.  It takes care of firing up SessionRecieverAS 
# (active source) objects when they are needed.
# 

Class SessionReceiverSM -superclass Observer

SessionReceiverSM instproc init {agent w vframe spec} {
    ### w: .$view.$spec_window.sources

    $self next
    $self instvar agent_ target_ w_ label_ vframe_ source_list_ spec_
    global active_sources

    set w_ $w
    set vframe_ $vframe
    set agent_ $agent
    set source_list_ ""
    set target_ ""
    set spec_ $spec
    set active_sources($spec_) ""

    set label_ $w_.label
    label $label_ -text "Waiting for video..."
    pack $label_ -anchor c -expand 1 -side left -fill both
}

#
# Waits for incoming video packets.
#
SessionReceiverSM instproc trigger_media {src} {
    after idle "$self really_activate $src"
}

#
# When packets are received, it instantiates a new SessionReceiverAS and
# adds the active source to the source_list_.
#
SessionReceiverSM instproc really_activate {src} {
    $self instvar frame_ decoder_ renderer_ vframe_ source_list_ w_
    set as [new SessionReceiverAS $self $w_.$src $src $vframe_]
    set source_list_ [concat $source_list_ $as]
}

#
# Adds the source to the grid and the array active_.
#
SessionReceiverSM instproc add_active {sras src} {
    $self instvar active_ w_ label_ spec_
    global active_sources

    set active_sources($spec_) [concat $active_sources($spec_) $sras]
    set active_($src) $sras
    if { [array size active_] == 1 } {
	pack forget $label_
	pack $w_ -expand 1 -fill x -anchor n
    }	
}

#
# Removes the sources in this session by detaching the thumbnail.
#
SessionReceiverSM instproc remove_active {} {
    $self instvar source_list_
    foreach source $source_list_ {
	$source detach_window [$source source_thumbnail]
    }
}

#
# Returns the list of the active sources in this session.
#
SessionReceiverSM instproc source_list {} {
    $self instvar source_list_
    return $source_list_
}

######
#SessionReceiverAS
# This active source object creates a thumbnail sized VideoWidget for 
# it's source. The attach-thumbnail procedure calls the attach-decoder
# procedure, which creates the Renderer object to display the thumbnail.
# 

Class SessionReceiverAS -superclass TkWindow

SessionReceiverAS instproc init {srsm w src vframe} {
    ### w: $w_.$src
    
    $self next $w
    $srsm add_active $self $src 
    frame $w -relief groove 
    pack $w -side left

    $self instvar srsm_ src_ vframe_ thumbnail_
    set srsm_ $srsm
    set src_ $src
    set vframe_ $vframe

    set stamp $w.stamp
    frame $stamp -relief ridge -borderwidth 2
    set video_widget_path $stamp.video
    set thumbnail_ [new VideoWidget $video_widget_path 80 60]
    $thumbnail_ set is_slow_ 0
    $self attach_window $thumbnail_
    pack $stamp.video -side left -anchor c -padx 2
    pack $stamp -side left -fill y

    bind $video_widget_path <ButtonPress-1> "$self select_thumbnail"
    bind $video_widget_path <ButtonPress-3> "$self trigger_dropmenu"

}

#
# Attaches a decoder to the VideoWidget
#
SessionReceiverAS instproc attach_window {vw} {
    $self instvar src_ vframe_
    $vw attach-decoder $src_ [$vframe_ set colorModel_] true
}

#
# Detaches the decoder from the VideoWidget
#
SessionReceiverAS instproc detach_window {vw} {
    $self instvar src_
    $vw detach-decoder $src_
}

#
# If the user clicks on a thumbnail, it creates a larger video by 
# instantiating a VEUserWindow if it doesn't already exist, or else 
# destroy it.
#
SessionReceiverAS instproc select_thumbnail {} {
    $self instvar srsm_ VEuw_
    if {[winfo exists .vw$self]} {
	$VEuw_ destroy 
    } else {
	set VEuw_ [new VEUserWindow $srsm_ $self]
    }
}

#
# Return the thumbnail of this source.
#
SessionReceiverAS instproc source_thumbnail {} {
    $self instvar thumbnail_
    return $thumbnail_
}

#
# Returns the veUserWindow of this source.
#
SessionReceiverAS instproc source_veUW {} {
    $self instvar VEuw_
    return $VEuw_
}

#
# Returns the src variable of the active source
#
SessionReceiverAS instproc get_src {} {
    $self instvar $src_
    return $src_
}


#
# When the user clicks the right mouse button on a thumbnail, this method
# is called to create a dropdown menu
#
SessionReceiverAS instproc trigger_dropmenu {} {
    global videodrop
    if {[winfo exists .videodrop]} {	
	tk_popup $videodrop \
		[winfo pointerx .videodrop] [winfo pointery .videodrop]
    } else {
	set videodrop [menu .videodrop -tearoff 0]
	$videodrop add command -label Exit    
	tk_popup $videodrop \
		[winfo pointerx .videodrop] [winfo pointery .videodrop]
    }
}
