# session-scubavic.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/vic/session-scubavic.tcl,v 1.16 2002/02/03 04:39:54 lim Exp $

import Session/Scuba Observer NetworkManager/Scuba

#
Class Session/Scuba/Vic -superclass { Session/Scuba Observer }

#
Session/Scuba/Vic instproc init { rtpsess sm ab vpipe } {
	$self next
	$self set rtpsess_ $rtpsess
	$self source-manager $sm
	$self set vpipe_ $vpipe

	if { $ab != "" && [$ab nchan] > 0 } {
		$self reset $ab
	}
}

#
Session/Scuba/Vic instproc reset ab {
	$self instvar nm_ rtpsess_

	if [info exists nm_] {
		delete $nm_
	}
	set nm_ [new NetworkManager/Scuba $ab $rtpsess_ $self]
	$self scuba-net [$nm_ set scubaNet_]
	$self start-control
}

#
Session/Scuba/Vic instproc set_allocation {} {
	$self instvar scoretab_ share_ rtpsess_ sessionbw_

	set sm [$self source-manager]
	if { [$sm info vars local_] == "" } {
		return
	}
	set localsrc [$sm set local_]

	#
	# Tabulate scores
	#
	# For now, just find ourselves in the score table and allocate
	# our bandwith proportionally.  If our bandwidth is 0, we get a
	# proportional fraction of 5% of the bandwidth which is set aside for
	# this purpose.

	set total 0
	set tot($localsrc) 0
	set al [$sm active_list]
	set zerosrcs 0
	foreach src $al {
		set srcid [$src srcid]
		set voters [array names scoretab_ *:$srcid]
		set subtotal 0
		foreach v $voters {
			set subtotal [expr $subtotal+$scoretab_($v)]
		}
		set tot($src) $subtotal
		if { $subtotal == 0 } {
			incr zerosrcs
		}
		set total [expr $total+$subtotal]
	}
#puts "total=$total localtot=$tot($localsrc)"
	if { $total > 0 } {
		set avg [expr $tot($localsrc)/$total]
	} else {
		set avg 0
	}
	if { $avg > 0 } {
		set share_ [expr 0.95*$avg]
	} else {
		if { $zerosrcs == 0 } {
			set zerosrcs 1
		}
		set share_ [expr 0.05/$zerosrcs]
	}
#puts "$self: $localsrc set_bps $share_ of $sessionbw_=[expr $share_*$sessionbw_]"
	$self set_bps [expr $share_*$sessionbw_]
}

#
Session/Scuba/Vic instproc set_bps { bps } {
	set videoagent [$self source-manager]
	set b [expr int($bps)]
	$self instvar vpipe_
	$vpipe_ set_bps $b
	$videoagent local_bandwidth $b
	global bps_slider
	if [info exists bps_slider] {
		$bps_slider set $b
	}
}

#
Session/Scuba/Vic instproc build_report {} {
#puts "build_report"
	$self instvar focus_set_
	if ![info exists focus_set_] {
		return 0
	}
	set sm [$self source-manager]
	if { [$sm info vars local_] == "" } {
		return 0
	}
	set localsrc [$sm set local_]

	# Divvy up score equally among all in focus set
	set t 0
	set srcs [array names focus_set_]
	foreach s $srcs {
		# Ignore our own focus
		if { $s != $localsrc && $focus_set_($s) > 0 } {
			incr t
		}
	}

	$self clean_scoretab $localsrc

	if { $t != 0 } {
		set score [expr int(1e6/$t)]
		foreach s $srcs {
			if { $focus_set_($s) > 0 && $s != $localsrc } {
				set srcid [$s srcid]
				$self add-scuba-entry $srcid $score
				# Loopback our votes, but ignore our own.
				$self recv_scuba_entry $localsrc \
						$srcid $score
			}
		}
	}

	$self set_allocation

	return $t
}

#
Session/Scuba/Vic instproc activate { src } {
	$self set focus_set_($src) 0

	$self next $src
}

#
Session/Scuba/Vic instproc deactivate { src } {
	$self unset focus_set_($src)

	$self next $src
}

#
Session/Scuba/Vic instproc scuba_focus { src } {
	$self instvar focus_set_
	incr focus_set_($src)
}

#
Session/Scuba/Vic instproc scuba_unfocus { src } {
    $self instvar focus_set_
    if {[array names focus_set_ $src] == $src} {
        incr focus_set_($src) -1
    }
}
