/*
 * tgmb-app.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#include "tgmb-app.h"
#include "tgmb-resource.h"
#include "win-2bit.h"

#define TGMB_CREATOR		  'TGmb'
#define TGMB_APPTYPE              'TGmb'

#define TGMB_DBTYPE_TMP           'STOR'
#define TGMB_DBTYPE_SESSION       'SESS'
#define TGMB_DBTYPE_SESSIDX       'SIDX'

#define TGMB_DBNAME_TMP		  "TopGunMBTmpStorage"
#define TGMB_DBNAME_CACHE_INDEX	  "TopGunMBCacheIndex"


TGMB_Application *TGMB_Application::globalAppInstance_= NULL;


void
TGMB_Application::ClearDatabase(DmOpenRef db)
{
	ULong numRecs;
	LocalID lid;
	UInt cardno;
	ULong i;

	DmOpenDatabaseInfo(db, &lid, NULL, NULL, &cardno, NULL);
	DmDatabaseSize(cardno, lid, &numRecs, NULL, NULL);

	for (i = 0; i < numRecs; i++) {
		DmRemoveRecord(db, 0);
	}
}


void
TGMB_Application::OpenTmpStorageDatabase()
{
	DmOpenRef tmpDB;
	Err err;

	// open the temporary storage database (used by TGMB_Connection)
	tmpDB = DmOpenDatabaseByTypeCreator(TGMB_DBTYPE_TMP, TGMB_CREATOR,
					    dmModeReadWrite);
	if (tmpDB == NULL) {
		err = DmCreateDatabase(0, TGMB_DBNAME_TMP, TGMB_CREATOR,
				       TGMB_DBTYPE_TMP, 0);
		ErrFatalDisplayIf(err,
				  "Error creating temporary storage database");
		tmpDB = DmOpenDatabaseByTypeCreator(TGMB_DBTYPE_TMP,
						    TGMB_CREATOR,
						    dmModeReadWrite);
		ErrFatalDisplayIf(!tmpDB,
				  "Error opening temporary storage database");
	}
	else {
		ClearDatabase(tmpDB);
	}

	//TGMB_Connection::DB(tmpDB);
	tmpDB_ = tmpDB;
}


void
TGMB_Application::CloseDatabases()
{
	DmCloseDatabase(tmpDB_);
}


DWord
TGMB_Application::Init()
{
	DWord err = TG_NetworkApplication::Init();
	if (err) return err;

	OpenTmpStorageDatabase();
	Win2_Enable(TGMB_APPTYPE, tmpDB_);

	/*DWord i;
	TG_HashTable ht;
	TG_Pointer p;
	PageId id;
	ht.Open(tmpDB_, sizeof(PageId));
	for (i=0; i<40; i++) {
		p.handle = (VoidHand)i;
		p.offset = i;
		id.sid.ss_uid = i*16;
		id.sid.ss_addr= i*16;
		id.uid = i*16;
		ht.Insert(&id, &p);
	}

	ErrorDialog("starting to search");
	for (i=40; i<50; i--) {
		id.sid.ss_uid = i*16;
		id.sid.ss_addr= i*16;
		id.uid = i*16;
		if (ht.Find(&id, &p)==false) {
			ErrorDialog("Could not find %u", (Word)i);
		} else {
			if (i!=(DWord)p.handle ||
			    i!=p.offset) {
				ErrorDialog("error: %u -- %u:%u", (Word)i,
				    (Word)p.handle,
				    (Word)p.offset);
			}
		}
	}
	ErrorDialog("successfully found everything");
	ht.Close();*/

	FrmGotoForm(Frm_StartupForm);
	return 0;
}


DWord
TGMB_Application::Cleanup()
{
	if (session_.IsStarted()) session_.Stop();

	DWord err = TG_NetworkApplication::Cleanup();
	if (err) return err;

	Win2_Disable();
	CloseDatabases();

	FrmSaveAllForms();
	FrmCloseAllForms();

	return 0;
}


void
TGMB_Application::JoinSession()
{
	FrmPopupForm(Frm_NewSessionForm);
}

