/*
 * tgmb-conn.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */


#ifndef lint
static const char rcsid[] = "@(#) $Header: /usr/mash/src/repository/mash/mash-1/tgmb/gateway/tgmb-conn.cc,v 1.9 2002/02/03 04:18:21 lim Exp $";
#endif

#include "tgmb-conn.h"
#include "tgmb-mgr.h"
#include "tgmb-canv.h"


/*
 * The functions recv_dump and send_dump appear to be unused debugging
 * functions.  They have been retained, but disabled to suppress compiler
 * warning messages.  --LL
 */
#if 0
static void recv_dump(u_char *bytes, int len)
{
	static FILE *fp=NULL;
	if (fp==NULL) {
		fp = fopen("tgmb.recv.dump", "w");
	}
	fwrite(bytes, 1, len, fp);
	fflush(fp);
}


static void send_dump(u_char *bytes, int len)
{
	static FILE *fp=NULL;
	if (fp==NULL) {
		fp = fopen("tgmb.send.dump", "w");
	}
	fwrite(bytes, 1, len, fp);
	fflush(fp);
}
#endif


DEFINE_OTCL_CLASS(TCP_MediaPad, "TCP/MediaPad")
{
	INSTPROC(readable);
	INSTPROC(set_socket);
	INSTPROC(handshake);
	INSTPROC(zoom_factor);
	PROC(send_newpage);
	PROC(send_srcname);
	PROC(send_data_to_everyone);
}


Bool
Chunk::search(void *pv, u_int32_t dlen,
	      u_int16_t name, void *&value, u_int16_t &len)
{
	u_int16_t tmp, elemName, elemLen;

	value = NULL;
	len = 0;
	char* data = (char*)pv;
	while (dlen > 0) {
		if (dlen < 4) return FALSE;

		memcpy(&tmp, data, 2);
		elemName = ntohs(tmp);

		memcpy(&tmp, data+2, 2);
		elemLen = ntohs(tmp);

		data += 4;
		dlen -= 4;
		if (dlen < elemLen) return FALSE;

		if (elemName==name) {
			value = data;
			len   = elemLen;
			return TRUE;
		}

		data += elemLen;
		dlen -= elemLen;
	}

	return FALSE;
}


Bool
TCP_MediaPad::CreateNewChunk(Chunk *&chunk, u_char *hdrBuf)
{
	// create a chunk object
	chunk = new Chunk;
	if (chunk==NULL) return FALSE;

	// construct the header
	memcpy(&chunk->hdr.version, hdrBuf, 4);
	chunk->hdr.version = ntohl(chunk->hdr.version);

	memcpy(&chunk->hdr.requestId, hdrBuf+4, 4);
	chunk->hdr.requestId = ntohl(chunk->hdr.requestId);

	memcpy(&chunk->hdr.metadataSize, hdrBuf+8, 4);
	chunk->hdr.metadataSize = ntohl(chunk->hdr.metadataSize);

	memcpy(&chunk->hdr.dataSize, hdrBuf+12, 4);
	chunk->hdr.dataSize = ntohl(chunk->hdr.dataSize);

	memcpy(&chunk->hdr.comp, hdrBuf+16, 4);
	chunk->hdr.comp = ntohl(chunk->hdr.comp);

	// now create the metadata database record
	if (chunk->hdr.metadataSize <= 0) {
		chunk->metadata = NULL;
	} else {
		chunk->metadata = new u_char [chunk->hdr.metadataSize+1];
		if (!chunk->metadata) {
			delete chunk;
			chunk = NULL;
			return FALSE;
		}
		memset(chunk->metadata, 0, chunk->hdr.metadataSize+1);
	}

	// now create the data database record
	if (chunk->hdr.dataSize <= 0) {
		chunk->data = NULL;
	} else {
		chunk->data = new u_char [chunk->hdr.dataSize+1];
		if (!chunk->data) {
			delete chunk;
			chunk = NULL;
			return FALSE;
		}
		memset(chunk->data, 0, chunk->hdr.dataSize+1);
	}

	return TRUE;
}


int
TCP_MediaPad::send(Chunk *chunk)
{
	u_int32_t tmp;
	u_char hdrBuf[sizeof_WingmanHdr];
	int  retval;

	// send the header
	tmp = htonl(chunk->hdr.version);
	memcpy(hdrBuf+ 0, &tmp, 4);
	tmp = htonl(chunk->hdr.requestId);
	memcpy(hdrBuf+ 4, &tmp, 4);
	tmp = htonl(chunk->hdr.metadataSize);
	memcpy(hdrBuf+ 8, &tmp, 4);
	tmp = htonl(chunk->hdr.dataSize);
	memcpy(hdrBuf+12, &tmp, 4);
	tmp = htonl(chunk->hdr.comp);
	memcpy(hdrBuf+16, &tmp, 4);

	retval = send_all(hdrBuf, sizeof_WingmanHdr);
	//send_dump(hdrBuf, sizeof_WingmanHdr);
	if (retval!=sizeof_WingmanHdr) return retval;

	// send the metadata
	if (chunk->hdr.metadataSize > 0) {
		if (chunk->metadata==NULL) {
			errno = EINVAL;
			return -1;
		}
		retval = send_all(chunk->metadata, chunk->hdr.metadataSize);
		//send_dump(chunk->metadata, chunk->hdr.metadataSize);
		if (retval != int(chunk->hdr.metadataSize)) {
			return retval;
		}
	}

	// send the data
	if (chunk->hdr.dataSize > 0) {
		if (chunk->data==NULL) {
			errno = EINVAL;
			return -1;
		}
		retval = send_all(chunk->data, chunk->hdr.dataSize);
		//send_dump(chunk->data, chunk->hdr.dataSize);
		if (retval != int(chunk->hdr.dataSize)) {
			return retval;
		}
	}

	return sizeof_WingmanHdr +chunk->hdr.metadataSize +chunk->hdr.dataSize;
}


int
TCP_MediaPad::send(const u_char* buf, int len)
{
	if (sock_==-1) {
		Tcl::instance().result("socket not open");
		errno = EINVAL;
		return -1;
	}

	int cc = ::send(sock_, (const char*)buf, len, 0);
	if (cc < 0)
		Tcl::instance().resultf("send: %s", strerror(errno));
	return (cc);
}


int
TCP_MediaPad::send_all(const u_char* buf, int len)
{
	int sent = 0, sent_now;
	while (sent < len) {
		sent_now = send(buf+sent, len-sent);
		if (sent_now < 0) return sent_now;
		sent += sent_now;
	}

	return sent;
}


int
TCP_MediaPad::recv(u_char* buf, int len)
{
	if (sock_==-1) {
		Tcl::instance().result("socket not open");
		errno = EINVAL;
		return -1;
	}

	int cc = ::recv(sock_, (char*)buf, len, 0);
	if (cc < 0) {
		if (errno != EWOULDBLOCK) {
			Tcl::instance().resultf("recv: %s", strerror(errno));
		}
		return (-1);
	}
	return (cc);
}


void
TCP_MediaPad::recv()
{
	u_char     *ptr=NULL;
	u_int32_t  size=0, already=0;
	int        bytesRead=0;

	switch (state_) {
	case connReadingHdr:
		ptr     = recvHdrBuf_;
		size    = sizeof_WingmanHdr;
		already = 0;
		break;

	case connReadingMetadata:
		ptr     = chunk_->metadata;
		size    = chunk_->hdr.metadataSize;
		already = sizeof_WingmanHdr;
		break;

	case connReadingData:
		ptr     = chunk_->data;
		size    = chunk_->hdr.dataSize;
		already = sizeof_WingmanHdr + chunk_->hdr.metadataSize;
		break;
	}

	bytesRead = recv(ptr+readSoFar_, size-readSoFar_);
	//recv_dump(ptr+readSoFar_, bytesRead);
	if (bytesRead <= 0) {
		Error();
		return;
	}

	readSoFar_ += bytesRead;
	if (readSoFar_ >= size) {
		// we've got all the bytes in this state; let's move the
		// state machine to the next state

		readSoFar_ = 0;

		switch (state_) {
		case connReadingHdr:
			if (CreateNewChunk(chunk_, ptr) != TRUE) {
				Error();
				return;
			}

			if (chunk_->hdr.metadataSize > 0) {
				state_ = connReadingMetadata;
			} else if (chunk_->hdr.dataSize > 0) {
				state_ = connReadingData;
			} else {
				// we are done!
				NotifyChunkReceived();
			}
			break;

		case connReadingMetadata:
			if (chunk_->hdr.dataSize > 0) {
				state_ = connReadingData;
			} else {
				// we are done!
				NotifyChunkReceived();
				state_ = connReadingHdr;
			}
			break;

		case connReadingData:
			// we are done!
			NotifyChunkReceived();
			state_ = connReadingHdr;
			break;
		}
	}
}



List<TCP_MediaPad> TCP_MediaPad::allConnections_;


TCP_MediaPad::TCP_MediaPad()
	: currRequestId_(0), pRcvr_(NULL)
{
	reset();
	allConnections_.InsertAtTail(this);
	Tcl_InitHashTable(&htLastCanvCmdSent_, TCL_ONE_WORD_KEYS);
}


int
TCP_MediaPad::readable(int argc, const char *const *argv)
{
	BEGIN_PARSE_ARGS(argc, argv);
	END_PARSE_ARGS;
	recv();
	return TCL_OK;
}

int
TCP_MediaPad::set_socket(int argc, const char *const *argv)
{
	const char *channel;
	BEGIN_PARSE_ARGS(argc, argv);
	ARG(channel);
	END_PARSE_ARGS;

	int mode;
	Tcl_Channel chan=Tcl_GetChannel(Tcl::instance().interp(), (char*)channel,
					&mode);
	Tcl_GetChannelHandle(chan, mode, (ClientData*)&sock_);
	return TCL_OK;
}

int
TCP_MediaPad::zoom_factor(int argc, const char *const *argv)
{
	BEGIN_PARSE_ARGS(argc, argv);
	END_PARSE_ARGS;

	Tcl::instance().resultf("%d", (status_.zoomFactor_ ?
				       status_.zoomFactor_:100));
	return TCL_OK;
}


int
TCP_MediaPad::handshake(int argc, const char *const *argv)
{
	Tcl &tcl = Tcl::instance();
	int i, objc;
	Tcl_Obj *list, **objv;
	PageId pgIdHost, pgIdNet;
	u_char *pkt;
	u_int16_t len;
	Chunk chunk;
	ChunkFrag frag(NULL);

	BEGIN_PARSE_ARGS(argc, argv);
	END_PARSE_ARGS;

	// get the source list from the manager
	TGMB_Manager::instance()->Invoke("get_source_list", NULL);
	list = Tcl_NewStringObj(tcl.result(), -1);
	if (Tcl_ListObjGetElements(tcl.interp(), list, &objc, &objv)
	    == TCL_ERROR) {
		return TCL_ERROR;
	}

	// add the source list to the packet
	SrcId srcId;
	for (i=0; i<objc; i+=2) {
		if (! Str2SrcId(Tcl_GetStringFromObj(objv[i],NULL), srcId)) {
			return TCL_ERROR;
		}

		alloc_srcname_pkt(pkt, len, srcId,
				  Tcl_GetStringFromObj(objv[i+1],NULL));

		frag.insert_any(descrSrcName, pkt, len);
		delete [] pkt;
	}

	// get the page list from the manager
	TGMB_Manager::instance()->Invoke("get_page_list", NULL);
	list = Tcl_NewStringObj(tcl.result(), -1);
	if (Tcl_ListObjGetElements(tcl.interp(), list, &objc, &objv)
	    == TCL_ERROR) {
		return TCL_ERROR;
	}

	// add the page list to the packet
	for (i=0; i<objc; i++) {
		Str2PgId(Tcl_GetStringFromObj(objv[i], NULL), pgIdHost);
		host2net(pgIdHost, pgIdNet);
		frag.insert_any(descrNewPage, &pgIdNet,	sizeof(PageId));
	}

	// construct and send the chunk over to the client
	chunk.data = frag.data_;
	chunk.hdr.dataSize = frag.hdr_.len_;
	construct_chunk(&chunk, ContentTGMB_Control);

	if (send_chunk(&chunk)==FALSE) {
		tcl.result("cannot send chunk to client");
		return TCL_ERROR;
	}

	chunk.data = NULL;
	chunk.hdr.dataSize = 0;
	return TCL_OK;
}


TCP_MediaPad::~TCP_MediaPad()
{
	Tcl_DeleteHashTable(&htLastCanvCmdSent_);
	allConnections_.Remove(this);
	// don't delete the receiver here
	// in MB, a receiver, once created, sticks around forever
	//if (pRcvr_) delete pRcvr_;
}


Tcl_HashEntry *
TCP_MediaPad::FindLastCanvCmdSent(TGMB_Canvas *pCanv)
{
	int isNew;
	Tcl_HashEntry *pEntry = Tcl_CreateHashEntry(&htLastCanvCmdSent_,
						    (char*)pCanv, &isNew);
	if (isNew) {
		Tcl_SetHashValue(pEntry, NULL);
	}
	return pEntry;
}


Bool
TCP_MediaPad::send_ctl_to_everyone(const SrcId &dontSendToSid,
				   ChunkFragDescr descr,
				   void *data, u_int16_t len)
{
	Chunk chunk;
	ChunkFrag frag(NULL);
	ListIndex idx;
	Bool retval=TRUE;
	TCP_MediaPad *conn;

	frag.insert_any(descr, data, len);
	chunk.data = frag.data_;
	chunk.hdr.dataSize = frag.hdr_.len_;
	construct_chunk(&chunk, ContentTGMB_Control);

	for (idx = allConnections_.getFirst();
	     allConnections_.IsDone(idx)==FALSE;
	     idx = allConnections_.getNext(idx)) {
		conn = allConnections_.getData(idx);

		if ( !(conn->pRcvr_ && conn->pRcvr_->getSrcId()
		       ==dontSendToSid) ) {
			chunk.hdr.requestId = conn->currRequestId_;
			if (conn->send_chunk(&chunk)==FALSE) retval = FALSE;
		}
	}

	chunk.data = NULL;
	chunk.hdr.dataSize = 0;
	return retval;
}


void
TCP_MediaPad::construct_chunk(Chunk *chunk, u_int16_t contentType)
{
	u_int16_t tmp;

	// first construct the metadata
	chunk->metadata = new u_char [6];
	chunk->hdr.metadataSize = 6;
	tmp = htons(MetaContentType);
	memcpy(chunk->metadata+0, &tmp, 2);
	tmp = htons(2);
	memcpy(chunk->metadata+2, &tmp, 2);
	tmp = htons(contentType);
	memcpy(chunk->metadata+4, &tmp, 2);

	chunk->hdr.version   = TGMB_VERSION;
	chunk->hdr.requestId = 0;
	chunk->hdr.comp      = 0;
}


void
TCP_MediaPad::recv_chunk(Chunk *chunk)
{
	u_int16_t len, contentType;
	void   *contentTypePtr;
	if (!chunk->search_metadata(MetaContentType, contentTypePtr, len))
		return;
	assert(len==2);

	memcpy(&contentType, contentTypePtr, sizeof(u_int16_t));
	switch(ntohs(contentType)) {
	case ContentTGMB_CanvasCmds:
		recv_data(chunk->hdr.requestId, chunk->data,
			  chunk->hdr.dataSize);
		return;

	case ContentTGMB_Control:
		recv_ctl(chunk->data, chunk->hdr.dataSize);
		break;

	default:
		return;
	}
}


void
TCP_MediaPad::recv_ctl(u_char *data, u_int32_t len)
{
	u_int16_t descr, fraglen, tmp;

	while (len > 0) {
		if (len < 4) break;
		memcpy(&tmp, data, 2);
		descr = ntohs(tmp);
		memcpy(&tmp, data+2, 2);
		fraglen = ntohs(tmp);
		data += 4;
		len  -= 4;
		if (len < fraglen) break;

		switch(descr) {
		case descrSrcName:
			recv_srcname(data, fraglen);
			break;

		case descrClientStatus:
			recv_clientstatus(data, fraglen);
			break;

		case descrNewPage:
			recv_newpage(data, fraglen);
			break;

		case descrResendImage:
			recv_resendimage(data, fraglen);
			break;

		default:
			break;
		}

		fraglen += fraglen % 2;
		data += fraglen;
		len  -= fraglen;
	}
}


void
TCP_MediaPad::recv_srcname(u_char *ptr, u_int16_t len)
{
	// first check if a receiver object has been created for this client
	// if so, we have alreay received the first descrSrcName packet

	SrcId srcIdNet, clientSrcId;
	const char *name;

	memcpy(&srcIdNet, ptr, sizeof(SrcId));
	net2host(srcIdNet, clientSrcId);
	name = (const char*) (ptr + sizeof(SrcId));

	fprintf(stderr, "len: %d, expected: %d, name: '%s'\n", len,
		sizeof(SrcId) + strlen(name) + 1, name);
	assert(len==sizeof(SrcId) + strlen(name) + 1);
	if (pRcvr_==NULL) {
		SRM_Source *source = TGMB_Manager::instance()->session()->
			source_manager()->consult(clientSrcId);
		if (!source) {
			// this source doesn't exist
			// let's create it
			if (TGMB_Manager::instance()->session()->
			    Invokef("create-local 0x%lx 0x%lx {%s}",
				    clientSrcId.ss_uid, clientSrcId.ss_addr,
				    name)==TCL_ERROR) {
				return;
			}

			source = (SRM_Source*)
				Tcl::instance().lookup(Tcl::instance().
						       result());
		}

		if (source) {
			MBReceiver *r = (MBReceiver*)source->handler();
			if (TGMB_Manager::instance()->IsTGMBRcvr(r)) {
				pRcvr_ = (TGMB_LocalRcvr*)r;
			} else {
				// we must upgrade the receiver object to
				// a TGMB_LocalReceiver

				pRcvr_ = TGMB_Manager::instance()->Upgrade(r);
				source->handler(pRcvr_);
			}
			pRcvr_->attach(this);
		}
	} else {
		SRM_Source *source = TGMB_Manager::instance()->session()->
			source_manager()->consult(clientSrcId);
		assert(source!=NULL);
		source->cname(name);
	}
	// source->cname()/create-local will cause an upcall to cname_update
	// which will in turn send the descrSrcName packet to the
	// rest of the participants
}


void
#ifdef NDEBUG
TCP_MediaPad::recv_newpage(u_char *ptr, u_int16_t /* len */)
#else
TCP_MediaPad::recv_newpage(u_char *ptr, u_int16_t len)
#endif
{
	// first check if a receiver object has been created for this client
	// if not, we didn't receive the initial SrcName packet, yet
	if (pRcvr_==NULL) return;

	PageId pgIdNet, pgIdHost;
	assert(len==sizeof(PageId));
	memcpy(&pgIdNet, ptr, sizeof(PageId));
	net2host(pgIdNet, pgIdHost);

	if (pgIdHost.sid != pRcvr_->getSrcId()) {
		// the client is trying to create a page in someone else's
		// namespace! don't allow it
		return;
	}

	create_page(pgIdHost);
}


void
#ifdef NDEBUG
TCP_MediaPad::recv_clientstatus(u_char *ptr, u_int16_t /* len */)
#else
TCP_MediaPad::recv_clientstatus(u_char *ptr, u_int16_t len)
#endif
{
	// first check if a receiver object has been created for this client
	// if not, we didn't receive the initial SrcName packet, yet
	if (pRcvr_==NULL) return;

	Tcl &tcl = Tcl::instance();
	PageId origPgId = status_.currPgId_;

	assert(len==sizeof(TGMB_ClientStatus));
	TGMB_ClientStatus status;
	memcpy(&status, ptr, sizeof(TGMB_ClientStatus));

	status_.zoomFactor_ = ntohl(status.zoomFactor_);
	net2host(status.currPgId_, status_.currPgId_);

	fprintf(stderr, "Got new page id for handler %p: %d@%d:%ld\n",
		this,
		status_.currPgId_.sid.ss_uid,
		status_.currPgId_.sid.ss_addr,
		status_.currPgId_.uid);

	if (status_.currPgId_ != origPgId) {
		// send all data associated with the current page over

		if (status_.currPgId_.sid.ss_uid ==0 &&
		    status_.currPgId_.sid.ss_addr==0 &&
		    status_.currPgId_.uid==0) {
			return;
		}

		TGMB_Manager::instance()->Invoke("get_canvas",
						 PgId2Str(status_.currPgId_),
						 NULL);
		TGMB_Canvas *pCanv = (TGMB_Canvas*) tcl.lookup(tcl.result());
		if (pCanv==NULL) {
			memset(&status_.currPgId_, 0, sizeof(PageId));
			return;
		}

		send_data(pCanv);
	}
}


void
#ifdef NDEBUG
TCP_MediaPad::recv_resendimage(u_char *ptr, u_int16_t /* len */)
#else
TCP_MediaPad::recv_resendimage(u_char *ptr, u_int16_t len)
#endif
{
	PageId pgIdNet, pgId;
	u_int32_t canvId;
	Tcl &tcl = Tcl::instance();

	assert(len == sizeof(PageId) + sizeof(u_int32_t));
	memcpy(&pgIdNet, ptr, sizeof(PageId));
	net2host(pgIdNet, pgId);
	memcpy(&canvId, ptr+sizeof(PageId), 4);
	canvId = ntohl(canvId);

	if (TGMB_Manager::instance()->Invoke("get_canvas", PgId2Str(pgId),
					     NULL)==TCL_ERROR) {
		return;
	}

	TGMB_Canvas *pCanv = (TGMB_Canvas*) tcl.lookup(tcl.result());
	if (pCanv==NULL) return;

	Chunk chunk;
	if (pCanv->construct_image_payload(this, canvId, chunk.data,
					   chunk.hdr.dataSize)==TRUE) {
		// we have data to send
		construct_chunk(&chunk, ContentTGMB_CanvasCmds);
		chunk.hdr.requestId = currRequestId_;
		send_chunk(&chunk);
	}
}


Bool
TCP_MediaPad::send_data(TGMB_Canvas *pCanvas)
{
	Chunk chunk;
	Bool retval = TRUE;
	ListIndex lastSent;
	Tcl_HashEntry *pEntry = FindLastCanvCmdSent(pCanvas);

	lastSent = Tcl_GetHashValue(pEntry);
	if (pCanvas->construct_payload(this, chunk.data, chunk.hdr.dataSize,
				       lastSent)==TRUE) {
		// we have data to send
		construct_chunk(&chunk, ContentTGMB_CanvasCmds);
		chunk.hdr.requestId = currRequestId_;
		retval = send_chunk(&chunk);
	}
	Tcl_SetHashValue(pEntry, (ClientData)lastSent);

	return retval;
}


/*int
TGMB_TCPHandler::send_data(int argc, const char * const *argv)
{
	TclObject *canvas;
	BEGIN_PARSE_ARGS(argc, argv);
	ARG(canvas);
	END_PARSE_ARGS;

	Bool retval = send_data((TGMB_Canvas*)canvas);
	Tcl::instance().resultf("%d", retval);
	return TCL_OK;
}*/


int
TCP_MediaPad::send_data_to_everyone(int argc, const char * const *argv)
{
	TclObject *canv;
	BEGIN_PARSE_ARGS(argc, argv);
	ARG(canv);
	END_PARSE_ARGS;

	Bool retval = send_data_to_everyone((TGMB_Canvas*)canv);
	Tcl::instance().resultf("%d", retval);
	return TCL_OK;
}


Bool
TCP_MediaPad::send_data_to_everyone(TGMB_Canvas *pCanvas)
{
	ListIndex idx;
	TCP_MediaPad *conn;;
	Bool retval = TRUE;

	for (idx = allConnections_.getFirst();
	     allConnections_.IsDone(idx)==FALSE;
	     idx = allConnections_.getNext(idx)) {

		conn = allConnections_.getData(idx);
		fprintf(stderr, "Trying to send %d@%d:%ld to conn %p: "
			"%d@%d:%ld\n",
			pCanvas->getPageId().sid.ss_uid,
			pCanvas->getPageId().sid.ss_addr,
			pCanvas->getPageId().uid,
			conn,
			conn->status_.currPgId_.sid.ss_uid,
			conn->status_.currPgId_.sid.ss_addr,
			conn->status_.currPgId_.uid);
		if (conn->status_.currPgId_==pCanvas->getPageId()) {
			// the client is currently viewing this page
			if (conn->send_data(pCanvas)==FALSE) {
				retval = FALSE;
			}
		}
	}

	return retval;
}


int
TCP_MediaPad::send_newpage(int argc, const char * const *argv)
{
	const char *pgIdStr;
	PageId pgIdHost, pgIdNet;

	BEGIN_PARSE_ARGS(argc, argv);
	ARG(pgIdStr);
	END_PARSE_ARGS;

	Str2PgId(pgIdStr, pgIdHost);
	host2net(pgIdHost, pgIdNet);
	Bool retval = send_ctl_to_everyone(pgIdHost.sid, descrNewPage,
					   &pgIdNet, sizeof(PageId));
	Tcl::instance().resultf("%d", retval);
	return TCL_OK;
}


int
TCP_MediaPad::send_srcname(int argc, const char * const *argv)
{
	const char *srcIdStr, *name;
	u_char *pkt;
	u_int16_t len;
	SrcId srcId;

	BEGIN_PARSE_ARGS(argc, argv);
	ARG(srcIdStr);
	ARG(name);
	END_PARSE_ARGS;

	if (!Str2SrcId(srcIdStr, srcId)) {
		Tcl::instance().resultf("invalid argument for srcid: %s",
					srcIdStr);
		Tcl::instance().add_errorf("\ninvoked from within '%s %s'",
					   argv[0], argv[1]);
		return TCL_ERROR;
	}

	alloc_srcname_pkt(pkt, len, srcId, name);
	Bool retval = send_ctl_to_everyone(srcId, descrSrcName, pkt, len);
	delete [] pkt;
	Tcl::instance().resultf("%d", retval);
	return TCL_OK;
}


void
TCP_MediaPad::alloc_srcname_pkt(u_char *&pkt, u_int16_t &len,
				const SrcId &srcIdHost,
				const char *name)
{
	SrcId srcIdNet;

	len = strlen(name);
	pkt = new u_char[sizeof(SrcId) + len + 1];
	host2net(srcIdHost, srcIdNet);
	memcpy(pkt, &srcIdNet, sizeof(SrcId));
	memcpy(pkt + sizeof(SrcId), name, len+1);
	len = sizeof(SrcId) + len + 1;
}

