/*
 * real_encoder.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 2001-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "real_encoder.h"

// This file has the setup and the encode process of making raw YUV frames into Real Media streams.

BOOL g_bErrorOccurred = FALSE;
PN_RESULT g_nError = PNR_OK;


// This is the Tcl declaration, so that it is a registered Tcl class. Basically it just calls the RealWindow constructor.
static class RealWindowClass : public TclClass {
public:
  RealWindowClass() : TclClass ("RealWindow") {};
  TclObject* create(int argc, const char*const* argv) {
    int wantVideo=FALSE, wantAudio=FALSE, wantSureStream=FALSE;
    char* savefilename;
    char* datarate;
    
    if (atoi(argv[11]) != 0) {
      savefilename = (char*)argv[12];
    } else
      savefilename = "";

    if (strcmp(argv[16],"A/V") == 0) {
      wantVideo = TRUE;
      wantAudio = TRUE;
    } else if (strcmp(argv[16],"A") == 0)
      wantAudio = TRUE;
    else
      wantVideo = TRUE;
    
    if (strncmp(argv[10],"SS",2) == 0)
      wantSureStream = TRUE;

    if (wantSureStream)
      datarate = (char*)(&((argv[10])[2]));
    else
      datarate = (char*)argv[10];

    return (new RealWindow(argv[4],argv[5],argv[6],argv[7],atoi(argv[8]),atoi(argv[9]),datarate,atoi(argv[11]),savefilename,argv[13],argv[14],argv[15], wantAudio,wantVideo,wantSureStream));
  };
} realWindow;

// This is to catch the exceptions within the Real SDK
class CMyErrorSink : public IRMAErrorSink
{
public:
    static PN_RESULT CreateInstance(IUnknown **pUnk);

    STDMETHOD(QueryInterface)	(THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32,AddRef)	(THIS);
    STDMETHOD_(ULONG32,Release)	(THIS);

    STDMETHOD(ErrorOccurred)	(THIS_
				const UINT8	unSeverity,  
				const ULONG32	ulRMACode,
				const ULONG32	ulUserCode,
				const char*	pUserString,
				const char*	pMoreInfoURL
				);
    
protected:
    UINT32 m_nRefCount;

    CMyErrorSink();
    virtual ~CMyErrorSink();
};

// This is a helper function to get the current time in its correct form (ms).
ULONG32 GetTime()
{
    // using a local nFirstTime prevents overflow when multiplying
    // by 1000
    static BOOL bFirst = TRUE;
    static struct timeval start;

    struct timeval now;

    if(bFirst)
    {
	bFirst = FALSE;
	gettimeofday(&start, NULL);
    }

    gettimeofday(&now, NULL);

    ULONG32 sec = now.tv_sec - start.tv_sec;
    ULONG32 usec = 0;

    if(now.tv_usec < start.tv_usec)
    {
	// there will be overflow when subtracting
	sec--;
	usec = now.tv_usec + (1000000 - start.tv_usec);
    }
    else
	usec = now.tv_usec - start.tv_usec;

    return sec * 1000 + usec / 1000;
}

// This is the constructor for the Real Transcoder. 
RealWindow::RealWindow(const char* given_server, const char* given_filename, const char* given_username, const char* given_password, int port, int frame_rate, const char* given_data_rate, int given_save_file, const char* given_local_file_name, const char* given_title, const char* given_author, const char* given_copyright, int audio, int video, int surestr): res(PNR_OK), pBuildEngine(NULL), pSample(NULL), cVideoFormat_Width(0), cVideoFormat_Height(0), cVideoFormat_FrameRate(frame_rate), cAudioFormat_SampleRate(8000), cAudioFormat_NumChannels(1), cAudioFormat_BitsPerSample(16), nSuggestedAudioBufferSize(0), pAudioPin(NULL), pVideoPin(NULL), nAudioTimestamp(0), nSystemTimestamp(0), colorModel(0),nextIn(0), nextOut(0), portNum(port), save_file(given_save_file), useAudio(audio), useVideo(video), sureStream(surestr) {
  strcpy(server, given_server);
  strcpy(filename, given_filename);
  strcpy(username, given_username);
  strcpy(password, given_password);
  strcpy(data_rate, given_data_rate);
  strcpy(local_file_name, given_local_file_name);
  strcpy(title, given_title);
  strcpy(author, given_author);
  strcpy(copyright, given_copyright);

}

void RealWindow::setup_encoder() {
  nBufferSize = cVideoFormat_Width*cVideoFormat_Height*3/2;
  translate_frame = new u_int8_t[nBufferSize];

    //////////////////////////////////////////////////////////
    //
    // Initialize the DLL locations before you call any 
    // functions in the RealProducer Core SDK
    //
    //////////////////////////////////////////////////////////

    if(SUCCEEDED(res))
    {
	// Before you can call into the Build Engine DLL, you must 
	// initialize the DLL paths so that the Build Engine will 
	// know where to locate its required
	// DLLs when you create your first Build Engine

	printf("Setting up DLL paths\n");
	    
	// Create a null delimited, double-null terminated string containing
	// DLL category name/path pairs. In this sample, we use the same 
	// directory for all DLLs (the current directory). You can split 
	// up the DLLs into different directories by category if you wish.
	char szDllPath[2048];   
	UINT32 ulNumChars = 0;

	char cwd[4096];
	//	getcwd(cwd, 2048);
	bzero(cwd, 4096);
	strcat(cwd, getenv("MASH_HOME"));
	strcat(cwd, "/../realproducersdk/bin");
	printf("path to DLLs is: %s\n", cwd);
	
	ulNumChars += sprintf(szDllPath+ulNumChars, 
			"%s=%s", "DT_Plugins", cwd) + 1;
	ulNumChars += sprintf(szDllPath+ulNumChars, 
			"%s=%s", "DT_Codecs", cwd) + 1;
	ulNumChars += sprintf(szDllPath+ulNumChars, 
			"%s=%s", "DT_EncSDK", cwd) + 1;
	ulNumChars += sprintf(szDllPath+ulNumChars, 
			"%s=%s", "DT_Common", cwd) + 1;
	// terminator
	//ulNumChars += sprintf(szDllPath+ulNumChars, "") + 1;

	// Now that we have created the path, we hand it to the build engine
	// by using the exported SetDLLAccessPath function.
	
	res = SetDLLAccessPath(szDllPath);
    } 
	
    //////////////////////////////////////////////////////////
    //
    // Create the build engine object itself
    //
    //////////////////////////////////////////////////////////

    if(SUCCEEDED(res))
    {
	printf("creating build engine\n");

	res = RMACreateRMBuildEngine(&pBuildEngine);
    } else {
      printf("The path to the DLLs is incorrect or some are missing\n");
      exit(1);
    }
	
    //////////////////////////////////////////////////////////
    //
    // Enumerate the pins, and get the audio and video pins
    //
    //////////////////////////////////////////////////////////

    if(SUCCEEDED(res))
    {
	IUnknown* tempUnk = NULL;
	IRMAEnumeratorIUnknown* pPinEnum = NULL;
	
	// get the pin enumerator

	res = pBuildEngine->GetPinEnumerator(&pPinEnum);
	assert(SUCCEEDED(res));

	// enumerate the pins.
	
	PN_RESULT resEnum = PNR_OK;
	resEnum = pPinEnum->First(&tempUnk);
	
	char* outputTypeStr = new char[ENC_MAX_STR];
	while(SUCCEEDED(res) &&
		SUCCEEDED(resEnum) && 
		resEnum != PNR_ELEMENT_NOT_FOUND)
	{
	    IRMAInputPin* tempPin = NULL;
	    res = tempUnk->QueryInterface(IID_IRMAInputPin, (void**)&tempPin);
	    PN_RELEASE(tempUnk);
	    
	    if(SUCCEEDED(res))
		res = tempPin->GetOutputMimeType(outputTypeStr, ENC_MAX_STR);
    
	    if(SUCCEEDED(res))
	    {
		if(strcmp(outputTypeStr, MIME_REALAUDIO) == 0)
		{
		    // save this pin in pAudioPin
		    pAudioPin = tempPin;
		    // addref it because we are going to use it later
		    pAudioPin->AddRef();
		}
		else if(strcmp(outputTypeStr, MIME_REALVIDEO) == 0)
		{
		    // save this pin in pVideoPin
		    pVideoPin = tempPin;
		    // addref it because we are going to use it later
		    pVideoPin->AddRef();
		}
		
		printf("getting next pin\n");

		PN_RELEASE(tempPin);
		resEnum = pPinEnum->Next(&tempUnk);
	    } 
	    else 
	    {
		printf("Cannot query input pin interface.\n");
	    }
	} 
	delete [] outputTypeStr;
	
	PN_RELEASE(pPinEnum);
    } else {
      printf("couldn't set up the build engine!\n");
      exit(1);
    }
	
    //////////////////////////////////////////////////////////
    //
    // create the media sample object that we will use to
    // pass data to the pins
    //
    //////////////////////////////////////////////////////////

    if(SUCCEEDED(res))
    {
	printf("Creating a Media Sample\n");
	    
	IRMABuildClassFactory*  pClassFactory = NULL;
	    
	res = pBuildEngine->QueryInterface(IID_IRMABuildClassFactory,
						(void**)&pClassFactory);
	    
	if(SUCCEEDED(res))
	{
	    // create an instance of class IRMAMediaSample

	    res = pClassFactory->CreateInstance(CLSID_IRMAMediaSample,
			    NULL, IID_IRMAMediaSample, 
			    (void **)&pSample);
	}

	PN_RELEASE(pClassFactory);
    }
	
    //////////////////////////////////////////////////////////
    //
    // Setup the build engine main properties
    //
    //////////////////////////////////////////////////////////

    if(SUCCEEDED(res))
    {
	//
	// Do audio and video, but no events, or image maps 
	//

	if (SUCCEEDED(res))
	  res = pBuildEngine->SetDoOutputMimeType(MIME_REALAUDIO, useAudio);

	if(SUCCEEDED(res))
	  res = pBuildEngine->SetDoOutputMimeType(MIME_REALVIDEO, useVideo);

	if(SUCCEEDED(res))
	  res = pBuildEngine->SetDoOutputMimeType(MIME_REALEVENT, FALSE);

	if(SUCCEEDED(res))
	  res = pBuildEngine->SetDoOutputMimeType(MIME_REALIMAGEMAP, FALSE);

	//
	// for live capture, we must encode in realtime.
	//

	if(SUCCEEDED(res))
	  res = pBuildEngine->SetRealTimeEncoding(TRUE);
	    
	//
	// We will create a surestream file.  Set this to FALSE for a
	// single rate file for web servers.  
	//
	// With this set to TRUE, the build engine will generate multiple
	// streams even though we have selected only one target audience.
	// The extra streams are duress streams for low-bandwidth conditions.
	//

	if(SUCCEEDED(res))
	  res = pBuildEngine->SetDoMultiRateEncoding(sureStream);
    }
	
    //////////////////////////////////////////////////////////
    //
    // Setup main clip properties.  This configures what
    // we will output to: in this case to a server and
    // a static file [live archiving]
    //
    // Also, we set up title, author, copyright, etc...
    //
    //////////////////////////////////////////////////////////
    
    if(SUCCEEDED(res))
    {
	IRMAClipProperties* pClipProps = NULL;

	//
	// get the clip properties object
	//

	res = pBuildEngine->GetClipProperties(&pClipProps);
	    
	//
	// we want to create a file
	//

	if(SUCCEEDED(res)) {
	  if (save_file > 0) {
	    res = pClipProps->SetDoOutputFile(TRUE);
	    // here is the filename we want to create
	    if(SUCCEEDED(res))
	      res = pClipProps->SetOutputFilename(local_file_name);
	  }
	  else
	    res = pClipProps->SetDoOutputFile(FALSE);
	}
	//
	// we do not want to stream live to a server
	//

	if(SUCCEEDED(res)) {
	  if (save_file < 2) {
	    res = pClipProps->SetDoOutputServer(TRUE);
	    if(SUCCEEDED(res))
	      res = pClipProps->SetOutputServerInfo(server,filename,portNum,username,password);
	    if(SUCCEEDED(res))
	      printf("Connected successfully to the server\n");
	  }
	  else 
	    res = pClipProps->SetDoOutputServer(FALSE);
	}

	//
	// here is the server we want to stream to, and the
	// name of the file on that server.  If the server
	// is set up in the standard way, then you can play
	// it with this url in the player:


	//
	// title, author, etc...
	//
	
	if(SUCCEEDED(res))
	    res = pClipProps->SetTitle(title);
	if(SUCCEEDED(res))
	    res = pClipProps->SetAuthor(author);
	if(SUCCEEDED(res))
	    res = pClipProps->SetCopyright(copyright);


	PN_RELEASE(pClipProps);
    }

    //////////////////////////////////////////////////////////
    //
    // Select some target audiences, and other settings
    // related to how things are encoded.
    //
    //////////////////////////////////////////////////////////

    if(SUCCEEDED(res))
    {
	IRMABasicTargetSettings* pBasicSettings = NULL;
	IRMATargetSettings *pTargSettings = NULL;
	
	
	//
	// Build Engine returns a TargetSettings object,
	// we must query for BasicTargetSettings
	//

	res = pBuildEngine->GetTargetSettings(&pTargSettings);

	if(SUCCEEDED(res))
	    res = pTargSettings->QueryInterface(IID_IRMABasicTargetSettings,
						(void**)&pBasicSettings);
	PN_RELEASE(pTargSettings);
	    
	//
	// reset the target audiences
	//

	if(SUCCEEDED(res))
	    res = pBasicSettings->RemoveAllTargetAudiences();
		    
	//
	// set data rate
	//

	if(SUCCEEDED(res)) {
	  char* temp_data_rate = data_rate;
	  while (strncmp(temp_data_rate, "", 1) != 0) {
	    if ((strncmp(temp_data_rate,"56,",3)) == 0) {
	      res = pBasicSettings->AddTargetAudience(ENC_TARGET_56_MODEM);
	      temp_data_rate+=3;
	      printf("added target audience of 56K\n");
	    } else if ((strncmp(temp_data_rate,"128,",4)) == 0) {
	      res = pBasicSettings->AddTargetAudience(ENC_TARGET_DUAL_ISDN);
	      temp_data_rate+=4;
	      printf("added target audience of 128K\n");
	    } else if ((strncmp(temp_data_rate,"256,",4)) == 0) {
	      res = pBasicSettings->AddTargetAudience(ENC_TARGET_256_DSL_CABLE);
	      temp_data_rate+=4;
	      printf("added target audience of 256K\n");
	    } else if ((strncmp(temp_data_rate,"512,",4)) == 0) {
	      res = pBasicSettings->AddTargetAudience(ENC_TARGET_512_DSL_CABLE);
	      temp_data_rate+=4;
	      printf("added target audience of 512K\n");
	    } else {
	      if (TRUE /*see if valid data_rate */) {
		printf("trying to enter personal data_rate\n");
	      } else
		printf("invalid data_rate\n");
	    }
	  }
	}
	
	//
	// select audio optimized for content containing mostly music
	//

	if(SUCCEEDED(res) && useAudio)
	  res = pBasicSettings->SetAudioContent(ENC_AUDIO_CONTENT_VOICE);
	
	//
	// select video optimized for normal content
	//

	if(SUCCEEDED(res) && useVideo)
	    res = pBasicSettings->SetVideoQuality(ENC_VIDEO_QUALITY_NORMAL);
	
	//
	// we want to be compatible with G2 [6.0] players or later
	//

	if(SUCCEEDED(res))
	    res = pBasicSettings->SetPlayerCompatibility(6);

	PN_RELEASE(pBasicSettings);
    }

    //////////////////////////////////////////////////////////
    //
    // Setup the audio format on the audio pin
    //
    //////////////////////////////////////////////////////////

    if(SUCCEEDED(res) && useAudio) {
      IRMAPinProperties* pPinProps = NULL;
      IRMAAudioPinProperties* pAudioPinProps = NULL;
      
      res = pAudioPin->GetPinProperties(&pPinProps);
			    
      if(SUCCEEDED(res))
	res = pPinProps->QueryInterface(IID_IRMAAudioPinProperties,
					    (void**)&pAudioPinProps);

      PN_RELEASE(pPinProps);

	//
	// Here, we configure the audio pin with the format
	// of the data that we will be passing to it.
	// These constants are defined at the top of this file.
	//

      if(SUCCEEDED(res))
	res = pAudioPinProps->SetSampleRate(cAudioFormat_SampleRate);

      if(SUCCEEDED(res))
	res = pAudioPinProps->SetNumChannels(cAudioFormat_NumChannels);
      
      if(SUCCEEDED(res))
	res = pAudioPinProps->SetSampleSize(cAudioFormat_BitsPerSample);
      
    }
	
    //////////////////////////////////////////////////////////
    //
    // Setup the video format on the video pin
    //
    //////////////////////////////////////////////////////////

    if(SUCCEEDED(res) && useVideo)
    {
	IRMAPinProperties* pPinProps = NULL;
	IRMAVideoPinProperties* pVideoPinProps = NULL;

	res = pVideoPin->GetPinProperties(&pPinProps);
			    
	if(SUCCEEDED(res))
	    res = pPinProps->QueryInterface(IID_IRMAVideoPinProperties,
					    (void**)&pVideoPinProps);

	PN_RELEASE(pPinProps);

	//
	// Here, we configure the video pin with the video size and frame
	// rate, and video format.  This is the format in which we will
	// be providing video to the Encode() call.
	//

	if(SUCCEEDED(res))
	    res = pVideoPinProps->SetFrameRate(cVideoFormat_FrameRate);

	if(SUCCEEDED(res))
	    res = pVideoPinProps->SetVideoSize(
					cVideoFormat_Width,
					cVideoFormat_Height);

	if(SUCCEEDED(res))
	  res = pVideoPinProps->SetVideoFormat(ENC_VIDEO_FORMAT_I420);
    }

    // Do some Advanced Target Settings
    /*    if (SUCCEEDED(res) && (data_rate == 512)) {
      IRMABuildClassFactory*  pClassFactory = NULL;
      IRMATargetAudienceManager* pTargetAudMgr = NULL;
      IRMATargetAudienceInfo* pTargetInfo = NULL;
      IRMACodecInfoManager* pCodecInfoMgr = NULL;
      IUnknown* pCodecEnumTmp = NULL;
      IRMAEnumeratorIUnknown* pCodecEnum = NULL;
      IUnknown* tempUnk = NULL;
      IRMACodecInfo* tempCodec = NULL;
      PNCODECCOOKIE videoCodecToUse;
      PNCODECCOOKIE audioCodecToUse;
      
      res = pBuildEngine->QueryInterface(IID_IRMABuildClassFactory,
						(void**)&pClassFactory);
      if (SUCCEEDED(res)) {
	res = pClassFactory->CreateInstance(CLSID_IRMATargetAudienceManager,
		NULL, IID_IRMATargetAudienceManager, (void **)&pTargetAudMgr);
      }
      if (SUCCEEDED(res)) {
	res = pClassFactory->CreateInstance(CLSID_IRMACodecInfoManager, NULL,
      	       	    IID_IRMACodecInfoManager, (void **)&pCodecInfoMgr);
      }
      if (SUCCEEDED(res)) {
	char codecName[100];
	UINT32 codecCount;
	PN_RESULT resEnum = PNR_OK;
	
	res = pCodecInfoMgr->GetVideoCodecEnum(pCodecEnumTmp);
	pCodecEnumTmp->QueryInterface(IID_IRMAEnumeratorIUnknown, 
					   (void**)&pCodecEnum);
	res = pCodecEnum->GetCount(&codecCount);
	//printf("There are %d video codecs available\n", (int)codecCount);
	resEnum = pCodecEnum->First(&tempUnk);
	for(; codecCount > 0; codecCount--) {
	  res = tempUnk->QueryInterface(IID_IRMACodecInfo, (void**)&tempCodec);
	  tempCodec->GetCodecName(codecName, 100);
	  //printf("video codec name is %s\n", codecName);
	  if (strcmp(codecName, "RealVideo G2 with SVT") == 0) {
	    tempCodec->GetCodecCookie(videoCodecToUse);
	    printf("set video codec\n");
	  }
	  bzero(codecName, 100);
	  PN_RELEASE(tempCodec);
	  PN_RELEASE(tempUnk);
	  resEnum = pCodecEnum->Next(&tempUnk);
	}
	PN_RELEASE(pCodecEnumTmp);
	PN_RELEASE(pCodecEnum);
	PN_RELEASE(tempUnk);
	res = pCodecInfoMgr->GetAudioCodecEnum(pCodecEnumTmp);
	pCodecEnumTmp->QueryInterface(IID_IRMAEnumeratorIUnknown, 
					   (void**)&pCodecEnum);
	res = pCodecEnum->GetCount(&codecCount);
	//printf("There are %d audio codecs available\n", (int)codecCount);
	resEnum = pCodecEnum->First(&tempUnk);
	for(; codecCount > 0; codecCount--) {
	  res = tempUnk->QueryInterface(IID_IRMACodecInfo, (void**)&tempCodec);
	  tempCodec->GetCodecName(codecName, 100);
	  //printf("audio codec name is %s\n", codecName);
	  if (strcmp(codecName, "16 Kbps Voice") == 0) {
	    tempCodec->GetCodecCookie(audioCodecToUse);
	    printf("set audio codec\n");
	  }
	  bzero(codecName, 100);
	  PN_RELEASE(tempCodec);
	  PN_RELEASE(tempUnk);
	  resEnum = pCodecEnum->Next(&tempUnk);
	}
      }
      if (SUCCEEDED(res)) {
	res = pTargetAudMgr->GetTargetAudienceInfo(ENC_TARGET_512_DSL_CABLE, pTargetInfo);
      }
      if (SUCCEEDED(res)) {
	res = pTargetInfo->SetVideoCodec(videoCodecToUse);
	res = pTargetInfo->SetAudioCodec(ENC_TARGET_AUDIENCES_VIDEO,
					 ENC_AUDIO_CONTENT_VOICE, audioCodecToUse);
	res = pTargetInfo->SetTargetBitrate(1024);
	res = pTargetInfo->SetMaxFrameRate(30);
      }

      PN_RELEASE(pClassFactory);
      PN_RELEASE(pTargetAudMgr);
      PN_RELEASE(pTargetInfo);
      PN_RELEASE(pCodecInfoMgr);
      PN_RELEASE(pCodecEnumTmp);
      PN_RELEASE(pCodecEnum);
      PN_RELEASE(tempUnk);
   } */

    
    //////////////////////////////////////////////////////////
    //
    // Prepare the build engine for encoding
    //
    //////////////////////////////////////////////////////////

    if(SUCCEEDED(res))
    {
	printf("calling PrepareToEncode()\n");

	res = pBuildEngine->PrepareToEncode();
    }

    //////////////////////////////////////////////////////////
    //
    // The Build Engine will recommend a size for audio
    // buffers.  You should pass buffers of this size
    // into the audio pin
    //
    //////////////////////////////////////////////////////////

    if(SUCCEEDED(res) && useAudio)
    {
	UINT32 nSize = 0;

	IRMAAudioInputPin *pAudioSpecificPin = NULL;

	res = pAudioPin->QueryInterface(IID_IRMAAudioInputPin,
					(void **)&pAudioSpecificPin);
	
	if(SUCCEEDED(res))
	    res = pAudioSpecificPin->GetSuggestedInputSize(&nSize);

	if(SUCCEEDED(res))
	{
	    nSuggestedAudioBufferSize = nSize;
	    printf("Suggested Audio Buffer Size is %d\n", (int)nSize);
	    // 8bits per byte*1000ms per sec*160bytes per sample / obvious stuff.
	    nAudioBufferDuration = (8*1000*nSuggestedAudioBufferSize)/(cAudioFormat_SampleRate*cAudioFormat_NumChannels*cAudioFormat_BitsPerSample);
	}

	PN_RELEASE(pAudioSpecificPin);
    }

    //////////////////////////////////////////////////////////
    //
    // Register our error sink
    //
    //////////////////////////////////////////////////////////

    if(SUCCEEDED(res))
    {
	IUnknown *pMyErrorSinkObject = NULL;
	IRMAErrorSink *pErrorSink = NULL;
	IRMAErrorSinkControl *pErrorSinkControl = NULL;

	res = CMyErrorSink::CreateInstance(&pMyErrorSinkObject);

	if(SUCCEEDED(res))
	{
	    printf("ErrorSink: getting from MyErrorSink object\n");

	    res = pMyErrorSinkObject->QueryInterface(IID_IRMAErrorSink,
							(void **)&pErrorSink);
	}

	if(SUCCEEDED(res))
	{
	    printf("ErrorSink: getting from Build Engine\n");

	    res = pBuildEngine->QueryInterface(IID_IRMAErrorSinkControl,
						(void **)&pErrorSinkControl);
	}

	if(SUCCEEDED(res))
	{
	    printf("ErrorSink: adding error sink\n");

	    res = pErrorSinkControl->AddErrorSink(pErrorSink,
						PNLOG_EMERG, PNLOG_INFO);
	}
	printf("ErrorSink: done, res = 0x%08x\n", (uint) res);

	PN_RELEASE(pErrorSink);
	PN_RELEASE(pErrorSinkControl);
	PN_RELEASE(pMyErrorSinkObject);
    }
}

void RealWindow::planar422toI420(char* dest, char* src) {
  int width = cVideoFormat_Width/2;
  int height = cVideoFormat_Height/2;
  int size = cVideoFormat_Width * cVideoFormat_Height;
  
  memcpy(dest, src, size);
  src = src + size;
  dest = dest + size;
  
  for (int i = 0; i < height; i++) {
    memcpy(dest+(i*width),src+(2*i*width), width);
  }

  dest = dest + (width*height);
  src = src + (width*2*height);
  for (int i = 0; i < height; i++) {
    memcpy(dest+(i*width),src+(2*i*width), width);
  }
}

void RealWindow::recv(Buffer* buffer) {
  u_int8_t* in_frame_ = ((YuvFrame*)buffer)->bp_;
  ULONG32 nVideoTimestamp;
  
  if (!useVideo)
    return;
  
  // When capturing live data, you must pass it to the build
    // engine interleaved.
    //

  if (cVideoFormat_Width == 0) {
    cVideoFormat_Width = ((YuvFrame*)buffer)->width_;
    cVideoFormat_Height = ((YuvFrame*)buffer)->height_;
    setup_encoder();
  }

  // need to translate formats if it is a JPEG
  if (colorModel == 422) {
    planar422toI420((char*)translate_frame, (char*)in_frame_);
    in_frame_ = translate_frame;
  }

    //////////////////////////////////////////////////////////
    //
    // Encode!
    //
    // This sends interleaved audio and video packets
    // to the build engine.  In this sample app, we use
    // our random a/v generator to create random a/v packets.
    // Replace this with code to read your source data.
    //
    //////////////////////////////////////////////////////////

  if(SUCCEEDED(res)) {
    nVideoTimestamp = GetTime();
    if (useAudio) {
      nVideoTimestamp = (nVideoTimestamp - nSystemTimestamp) + nAudioTimestamp;
      if (nAudioTimestamp == 0)
	return;
    }    
        // put the data into our IRMAMediaSample so that
	// we can encode it.  Note: calling SetBuffer() 
	// stores a pointer to the buffer you give -- it 
	// does not copy it.  So keep the buffer around 
	// until you have called Encode().
	//
    //    printf("sending video frame at %d\n", (int)nVideoTimestamp);
    
	if(SUCCEEDED(res)) 
	  res = pSample->SetBuffer(
				   in_frame_,
				   nBufferSize,
				   nVideoTimestamp,
				   0);

	//
	// Encode it!
	//
	if(SUCCEEDED(res))
		res = pVideoPin->Encode(pSample);

	//
	// Very important: if there is an asynchronous error
	// while encoding, our CMyErrorSink object will have
	// set g_bErrorOccurred.  If this happened, we need
	// to stop encoding.  So we set our 'res' variable
	// to the error that occurred and this will break
	// our while loop.
	//

	if(SUCCEEDED(res) && g_bErrorOccurred)
	{
	    res = g_nError;
	}
    } else {
      printf("can't encode video block due to earlier error\n");
    }
}

void RealWindow::encodeAudio(u_short* buf, int size, ULONG32 now) {
  //printf("got a chunk of audio\n");
  if(!useAudio)
    return;

  if(SUCCEEDED(res)) {
    //nTimestamp = GetTime();
	/*	if(SUCCEEDED(res))
	  printf("time=%6d: %s buffer (size=%d)\n",
		nTimestamp,
		bIsAudio?"audio":"video",
		nBufferSize); */

	// 
	// put the data into our IRMAMediaSample so that
	// we can encode it.  Note: calling SetBuffer() 
	// stores a pointer to the buffer you give -- it 
	// does not copy it.  So keep the buffer around 
	// until you have called Encode().
	//

        nAudioTimestamp += nAudioBufferDuration;
        nSystemTimestamp = now;

	//	printf("sending audio frame at %d\n", (int)nAudioTimestamp);
	
	if(SUCCEEDED(res)) 
	  res = pSample->SetBuffer(
				   buf,
				   size,//nSuggestedAudioBufferSize,
				   nAudioTimestamp,
				   // might be 1 if this is a sync point
				   0);

       	//
	// Encode it!
	//
	if(SUCCEEDED(res))
		res = pAudioPin->Encode(pSample);

	//
	// Very important: if there is an asynchronous error
	// while encoding, our CMyErrorSink object will have
	// set g_bErrorOccurred.  If this happened, we need
	// to stop encoding.  So we set our 'res' variable
	// to the error that occurred and this will break
	// our while loop.
	//

	if(SUCCEEDED(res) && g_bErrorOccurred)
	{
	    res = g_nError;
	}
    } else {
      printf("can't encode audio block due to earlier error\n");
    }
}

int RealWindow::command(int argc, const char*const* argv) {
  if (argc == 3) {
    if (strcmp(argv[1], "setColorModel") == 0) {
      colorModel = atoi(argv[2]);
      return (TCL_OK);
    }
  }
  return (Renderer::command(argc,argv));
}

//////////////////////////////////////////////////////////
//
// We are done encoding -- cleanup
//
//////////////////////////////////////////////////////////
RealWindow::~RealWindow() {
  if(SUCCEEDED(res))
    {
      printf("calling DoneEncoding()\n");
      
      res = pBuildEngine->DoneEncoding();
    }

  PN_RELEASE(pAudioPin);
  PN_RELEASE(pVideoPin);
  PN_RELEASE(pSample);
  PN_RELEASE(pBuildEngine);

  printf("Done Encoding, res = 0x%08x\n", (uint)res);
    
  printf("Done, res = 0x%08x\n", (uint)res);
}

///////////////////////
// Error Sink stuff ///
///////////////////////

PN_RESULT CMyErrorSink::CreateInstance(IUnknown **ppUnk)
{
    CMyErrorSink *pObj = new CMyErrorSink();

    if(pObj == NULL)
    {
	*ppUnk = NULL;
	return PNR_OUTOFMEMORY;
    }
    else
    {
	*ppUnk = (IUnknown*)pObj;
	(*ppUnk)->AddRef();
	return PNR_OK;
    }
}

CMyErrorSink::CMyErrorSink()
: m_nRefCount(0)
{
}

CMyErrorSink::~CMyErrorSink()
{
}

STDMETHODIMP CMyErrorSink::QueryInterface(REFIID riid, void** ppvObj)
{
    if(!ppvObj)
	return PNR_POINTER;
    else if(IsEqualIID(IID_IUnknown, riid))
    {
	AddRef();
	*ppvObj = (IUnknown*)this;
	return PNR_OK;
    }
    else if(IsEqualIID(IID_IRMAErrorSink, riid))
    {
	AddRef();
	*ppvObj = (IRMAErrorSink*)this;
	return PNR_OK;
    }

    *ppvObj = NULL;
    return PNR_NOINTERFACE;
}

ULONG32 CMyErrorSink::AddRef()
{
    return InterlockedIncrement(&m_nRefCount);
}

ULONG32 CMyErrorSink::Release()
{
    if(InterlockedDecrement(&m_nRefCount) > 0)
	return m_nRefCount;
    
    delete this;
    return 0;
}

STDMETHODIMP CMyErrorSink::ErrorOccurred(const UINT8	unSeverity,  
				const ULONG32	ulRMACode,
				const ULONG32	ulUserCode,
				const char*	pUserString,
				const char*	pMoreInfoURL
				)
{
    printf("ERROR OCCURRED: "
		"sev=%d, err=0x%08x, usercode=%d, "
		"string=\"%s\", moreinfo=\"%s\"\n",
		unSeverity,  
		(uint)ulRMACode,
		(int)ulUserCode,
		pUserString,
		pMoreInfoURL);
    
    if(unSeverity <= PNLOG_ERR)
    {
	g_bErrorOccurred = TRUE;
	g_nError = ulRMACode;
    }
    return PNR_OK;
}




