/*
 * controller-erik.h --
 *
 *      Header file for ControllerErik.  It talks to the sound card and allows
 *      a stereo audio input to be split into left and right channels.
 *
 * Copyright (c) 1991-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/vd/audio/controller-erik.h,v 1.8 2002/02/03 04:19:42 lim Exp $
 */

#ifndef mash_controller_h
#define mash_controller_h

class Audio;
class SampleStream;
class Transducer;

#include "observe.h"
#include "audio.h"
#include "timer.h"
#include "inet.h"
#include "tclcl.h"
#include "media-timer.h"

#define TALK_LEAD (4)		// number of audio frames sent before a
				// silence-to-talk transition
#define TALK_TAIL (32)		// number of audio frames sent after a
				// talk-to-silence transition

class ControllerErik : public TclObject, public Observer,
			public AudioHandler, public Timer
{
 public:
  ControllerErik();
  virtual void update(Observable*);
  int active() const;
  virtual int command(int argc, const char*const* argv);
  inline int maxdel() const { return (leftStream_->MaxSamp()); }
 protected:
  virtual void timeout();
  virtual void audio_handle();
  void Activate();
  void DoAudio();
  void DoTimer();
  void mixaudio();

  Audio* audio_;
  u_int timer_interval_;

  u_long tsec_, tusec_;

  int ostate_;

  int test_tone_;		/* true to play test tone (and which) */

  Transducer* left_meter_;
  Transducer* right_meter_;

  int talk_thresh_;
  int max_playout_;
  int meter_update_;
  int active_;		/* set to 1 whenever audio or net written */

  u_int32_t last_mts_;	/* media timestamp of last block sent */
  timeval last_uts_;	/* unix timestamp associated with last_mts */

  // for stereo
  unsigned int blksize_;
  u_char* left_blk;
  u_char* right_blk;
  SampleStream* leftStream_;
  SampleStream* rightStream_;
};

inline int ControllerErik::active() const
{
  return (audio_->haveaudio());
}

#endif
