/*
 * transducer-gauge.h --
 *
 *      Receives audio levels and applies a filter.
 *
 * Copyright (c) 2000-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef VD_TRANSDUCER_GAUGE_H
#define VD_TRANSDUCER_GAUGE_H

#include "transducer.h"
#include "vd-utils.h"

class GaugeTransducer : public Transducer {
public:
  GaugeTransducer(int argc, const char* const* argv);
  ~GaugeTransducer();

  // set is called by the controller (sstream?) periodically (every 60 ms) and
  //   sets the "average" level
  virtual void set(double d);

  // threshold is the input value required for the stream to be considered "on"
  virtual void setThreshold(double newThreshold);

  virtual void attachTransducer(const char* trans);

  // Tcl interface
  virtual int command(int argc, const char* const* argv);

 private:
  double threshold;
  char gaugeName[100];

  int historySize;

  // this keeps a sum of the last X values that were passed to the Set
  //    function; in some sense it is a measure of volume over the last
  //    X time-slices
  MovingSum* levelSumPtr;
  // this keeps track of how many of the last X calls to Set resulted in an
  //    "active" level of the mike, where X is the history size
  //
  // it ranges [0,X]
  MovingSum* activeSumPtr;
  // to support chaining
  Transducer* slaveTransducer_;

  //
  // stuff below is not really related to the function of the gauge transducer,
  //    but is meant more for debugging, development, and testing work
  //

  // spoofing stuff
  double spoofLevel;
  int useSpoof;
};

#endif

