# net.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/srmv2/example/data/net.tcl,v 1.3 2002/02/03 03:04:58 lim Exp $


import Configuration SRMAgent AnnounceListenManager/AS/Client/MeGa

#
# Initializes some of the network state for the mediaboard.
#
Class MBNet -configuration {
	megaMbFormat null
	# multicast is default
	megaRecvMbPort 0
	mbSessionBW 20
	megaMbCtrl 224.4.5.24/50000/31
	megaMbCtrlBW 20000
	mbServiceLocation urn:mbgw

	delayParams default
        mbSessionSpec "224.2.55.66/8000"
}

#
# Creates an SRMAgent and MeGa Client if desired.
#
MBNet instproc init { app ui } {
        global mb
	
	set mgr [$app mgr]
	set srcList [$ui set srcList_]
	set pageList [[$ui set pageNavPanel_] set pageList_]
	
        $mgr proc new_source { src } "$srcList register \$src"
        $mgr proc cname_update { src newname }  \
		    "$srcList update_src_info \$src \$newname ; \
		     $pageList update_src_info \$src \$newname"

        set luid [$self get_option uid]
	if { $luid != "" } {
		set luid [format %x $luid]
	}
        
        set mbAgent_ [new SRMAgent $luid]
	$app set mbAgent_ $mbAgent_
	
	if { [$app get_option megaMbSession] != "" } {
		set sname [$app get_option megaMbSession]
		set sspec [$self get_option mbSessionSpec]
		set rportspec [$self get_option megaRecvMbPort]
		set ofmt [$self get_option megaMbFormat]

		set sbw [$self get_option mbSessionBW]
		set bw [expr 0.02*$sbw*1000]
		set megaspec [$self get_option megaMbCtrl]
		set loc [$self get_option mbServiceLocation]
		set al [new AnnounceListenManager/AS/Client/MeGa \
				$mbAgent_ $megaspec $bw mb mb \
				$sname $sspec $rportspec $ofmt $loc]
		$al start 1
                set addr ""
                
                set prefix [$app get_option iconPrefix]
                set hostname [lindex [split [info hostname] .] 0]
                append prefix "@" $hostname ":"
                set conf "Contacting MeGa..."
                $ui window_title $prefix $conf
	} else {
		set addr [$self get_option mbSessionSpec]
	} 

        set session_ [$mbAgent_ create-session $mgr $mgr]        
	$app set session_ $session_
        $mgr attach_session $session_
	
	if { $addr != "" } {
		#addressblock uses a different syntax,
		#so we have to change it..
		set comps [split $addr /]
		if {[llength $comps] > 2} {
			$app add_default defaultTTL [lindex $comps 2]
		}
 		$mbAgent_ reset_spec [lindex $comps 0]/[lindex $comps 1]
	}
	set params [$self get_option delayParams]
	if {"$params"!="default"} {
		eval $session_ delay-params $params
	}
	
	$mgr attach_ui $ui
}

