# utils.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1993-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


package provide mb_utils

#
# if old is found in list, replace it by new
# if new is {}, old is deleted.
# 
proc lsubst {list old new} {
    set ix [lsearch -exact $list $old]
    if {$ix >= 0} {
	    if {$new!={}} {
		    return [lreplace $list $ix $ix $new]
	    } else {
		    return [lreplace $list $ix $ix]
	    }
    } 
}

# we abstract this so that someday when can move this to C/C++
proc removeFirst {varName} {
        upvar $varName l
        set f [lindex $l 0]
        set l [lrange $l 1 end]
        return $f
}

# experimental superclass for functions that allows callbacks
Class Callback

# does nothing
Callback instproc init {} {
}

# register a callback for event
# the callback will be executed like: eval $cmd $args
Callback instproc add_callback {event cmd} {
	$self instvar callbacks_
	lappend callbacks_($event) $cmd
}

#
# call a callback on event, 
# if there is no such callback, nothing is executed
# otherwise a callback is issued for each registered callback
#
Callback instproc callback {event args} {
	$self instvar callbacks_
	if [info exists callbacks_($event)] {
		foreach cmd $callbacks_($event) {
			puts "callback: [concat $cmd $args]"
			uplevel #0 $cmd $args
		}
	}
}

