/*
 * Copyright (c) 1997 Carnegie Mellon University. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation is hereby granted (including for commercial or
 * for-profit use), provided that both the copyright notice and this
 * permission notice appear in all copies of the software, derivative
 * works, or modified versions, and any portions thereof, and that
 * both notices appear in supporting documentation, and that credit
 * is given to Carnegie Mellon University in all publications reporting
 * on direct or indirect use of this code or its derivatives.
 *
 * THIS SOFTWARE IS EXPERIMENTAL AND IS KNOWN TO HAVE BUGS, SOME OF
 * WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON PROVIDES THIS
 * SOFTWARE IN ITS ``AS IS'' CONDITION, AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * Carnegie Mellon encourages (but does not require) users of this
 * software to return any improvements or extensions that they make,
 * and to grant Carnegie Mellon the rights to redistribute these
 * changes without encumbrance.
 */

/*  
 * Revision: @(#)consts.h	1.2        8/24/93     Hui Zhang   
 */
#ifndef CONSTS_INCL
#define CONSTS_INCL

/* Network Size Constants     */
#define MAX_PATH_LENGTH        10
#define MAX_LINK_IN_GATEWAY    5
#define MAX_LINK               20
#define MAX_GATEWAY            20
#define MAX_CHANNEL            500
#define MAX_RTIPCBS            2000
#define NON_REAL_LCID          1
#define RESERVE_RTIPCB         2
#define RESERVE_CHANNEL        2

#define MAX_LEVEL              21

/* discipline types */
#define EDD                    0
#define FCFS                   1
#define SG                     2
#define RCSP                   3
#define HSCS                   4
#define WF2Q                   5
#define SFQ                    6
#define SCFQ                   7
#define HFSC                   8
#define MAX_DISCIPLINE         HFSC+1


#define DEFAULT_LINK_SPEED     1000 /* kbps */
#define DEFAULT_I              3000   /* ms   */

/* connection types */
#define DETERMINISTIC_DELAY    1
#define NON_REAL_TIME          2
#define HALF_TYPE              3
#define ONE_THIRD_TYPE         4
#define DEFAULT_TYPE DETERMINISTIC_DELAY 

#define epsilon                0.0000001

/* data generation */
#define	regular 	0
#define unif    	1
#define markov		2
#define peaked		3
#define synced		4
#define poison		5
#define cbr             6
#define burst           7 
/* random numbers streams */
#define TYPE_STREAM     0
#define DEST_STREAM     1
#define X_MIN_STREAM    2
#define X_AVG_STREAM    3
#define SIZE_STREAM     4
#define Z_STREAM        5
#define W_STREAM        6
#define D_STREAM        7
#define PATH_STREAM     8
#define PKT_STREAM      9
#define ATT_STREAM     10

#define MAX_RAND_STREAMS 11

#endif













