/*
 * Copyright (c) 1997 Carnegie Mellon University. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation is hereby granted (including for commercial or
 * for-profit use), provided that both the copyright notice and this
 * permission notice appear in all copies of the software, derivative
 * works, or modified versions, and any portions thereof, and that
 * both notices appear in supporting documentation, and that credit
 * is given to Carnegie Mellon University in all publications reporting
 * on direct or indirect use of this code or its derivatives.
 *
 * THIS SOFTWARE IS EXPERIMENTAL AND IS KNOWN TO HAVE BUGS, SOME OF
 * WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON PROVIDES THIS
 * SOFTWARE IN ITS ``AS IS'' CONDITION, AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * Carnegie Mellon encourages (but does not require) users of this
 * software to return any improvements or extensions that they make,
 * and to grant Carnegie Mellon the rights to redistribute these
 * changes without encumbrance.
 */

#ifndef lint
static const char sccsID[] = "Revision: @(#)list.c	1.4        8/24/93     Hui Zhang";
#endif

#include <stdio.h>

#ifdef BSD_KERNEL
#include <sys/malloc.h>
#else
#include <stdlib.h>
#endif

#include "hfsc_list.h"
#include "hfsc_fun.h"

#define nil 0

char *smalloc();

void init_list(qu)
pkt_str *qu;
{
	qu->head = nil;
	qu->tail = nil;
}


void pop_list(qu)
pkt_str *qu;
{

	if (empty_list(qu)) 
	    hfsc_panic("attempt to pop nil queue");
	qu->head = qu->head->next;
	if (qu->head) {
		qu->head->prev = nil;
	} else {
		qu->tail = nil;
		qu->head = nil;
	}
}
	
void destroy_entry(answer)
lstptr answer;
{
	free((char *) answer);
}

lstptr obj_to_lst(pkt)
char* pkt;
{
	lstptr new;

	new = (lstptr) smalloc (sizeof(lststr));
	new->next = new->prev = nil;
	new->udata = (void *) pkt;
	return(new);
}

void insert_in_nil_queue(nptr, qu)
lstptr nptr;
pkt_str *qu;
{
	if (!empty_list(qu)) {
		fprintf(stderr,"Expcting nill queue?");
		exit(-1);
	}
	/* Error checking here is an overkill but..*/
	qu->head = nptr;
	qu->tail = nptr;
	nptr->next = nptr->prev = nil;
}



void insert_at_head(nptr,qu)
lstptr nptr;
pkt_str *qu;
{
	if (empty_list(qu)) {
		insert_in_nil_queue(nptr,qu);
		return;
	}
	qu->head->prev = nptr;
	nptr->next = qu->head;
	nptr->prev = nil;
	qu->head = nptr;
}

void insert_at_tail(nptr,qu)
lstptr nptr;
pkt_str *qu;
{
	if (empty_list(qu)) {
		insert_in_nil_queue(nptr,qu);
		return;
	}
	qu->tail->next = nptr;
	nptr->prev = qu->tail;
	nptr->next = nil;
	qu->tail = nptr;
}

void insert_aftr(entry,lnbr,qu)
lstptr entry,lnbr;
pkt_str *qu;
{
	if (lnbr == nil) {
		insert_at_head(entry,qu);
		return;
	}

	if (lnbr->next == nil) {
		insert_at_tail(entry,qu);
		return;
	}

	entry->next = lnbr->next;
	lnbr->next = entry;
	entry->prev = lnbr;
	entry->next->prev = entry;
}

void InsertBefore(newEntry, curEntry, queue)
    lstptr newEntry, curEntry;
    pkt_str * queue;
{
    if (curEntry == nil)
	hfsc_panic("InsertBefore");
    if (queue->head == curEntry) {
	newEntry->next = curEntry;
	newEntry->prev = nil;
	queue->head = newEntry;
	curEntry->prev = newEntry;
    } else {
	newEntry->next = curEntry;
	newEntry->prev = curEntry->prev;
	curEntry->prev->next = newEntry;
	curEntry->prev = newEntry;
    }
}
void join_lists(qu1,qu2)
pkt_str *qu1, *qu2;
{
	if (empty_list(qu1)) {
		qu1->head = qu2->head;
		qu1->tail = qu2->tail;
		qu2->head = qu2->tail = nil;
		return;
	}

	if (empty_list(qu2)) {
		return;
	}

	qu1->tail->next = qu2->head;
	qu2->head->prev = qu1->tail;
	qu1->tail = qu2->tail;
	qu2->head = qu2->tail = nil;
}

void delete_list(ptr,qu)
lstptr ptr;
pkt_str *qu;
{
	if(ptr->next) { 
		ptr->next->prev = ptr->prev;
	}
	if(ptr->prev) {
		ptr->prev->next = ptr->next;
	}

	if (qu->head == ptr) {
		qu->head = ptr->next;
	}

	if (qu->tail == ptr) {
		qu->tail = ptr->prev;
	}
}



