/*
 * manager-srmv2.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/srmv2/srmv2/manager-srmv2.h,v 1.8 2002/02/03 03:05:47 lim Exp $
 */

#ifndef srmv2_manager_h
#define srmv2_manager_h

#include "net/inet.h"
#include "srmv2/srmv2.h"
#include "srmv2/srmv2-api.h"
#include "srmv2/session-srmv2.h"
#include "srmv2/pktbuf-srmv2.h"

class SRMv2_Source;
class SRMv2_Manager {
public:
	SRMv2_Manager() : session_(0) { }
	~SRMv2_Manager() { }
	void handle_data(SRMv2_Source *src, SRMv2_pktbuf *pb, unsigned int cid,
			 int seqno, int more, u_short *ttl,
			 const srm_adu_info *info);
	void handle_rreq(SRMv2_Source *src, u_int32_t ss, u_int32_t es, 
			 unsigned int sbytes, unsigned int ebytes,
			 unsigned int cid, unsigned int addr);
	void handle_announce(SRMv2_Source *src, unsigned int cid, unsigned int signature, 
			     unsigned int ebytes);
	void session(SRMv2_Session* s) { session_ = s; }
	
protected:
	SRMv2_Session *session_;
};
#endif

