/*
 * Copyright (C) 2000, 2001, Amnon Barak (amnon@cs.huji.ac.il)
 *
 * Permission to use this software is hereby granted under the terms of the
 * GNU General Public License, as published by the Free Software Foundation.
 *
 * THIS  SOFTWARE  IS  PROVIDED IN ITS  "AS IS"  CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/*
 * Author(s): Amnon Shiloh, Oren Laadan.
 */
#ifndef _MOS_PROTOCOL_H
#define _MOS_PROTOCOL_H
#ifdef CONFIG_MOSIX
#ifdef __KERNEL__

#include <linux/signal.h>
#include <linux/resource.h>
#include <linux/elf.h>

#define	EDIST	EDOM	/* MOSIX general error-code, that is otherwise */
			/* rarely-if-ever returned by kernel */

struct mosix_addr {
	struct sockaddr saddr;
};


/* structures passed between DEPUTY and REMOTE: */

struct mig_request_h
{
	long version;
	short reason;
	short topology;
	int personality;
	int wp_works_ok;
	int pages_sent;
	int request_type;
	int has_dfsa;
};

enum contact_type
{
	FROM_DEPUTY, DEPUTY_PROBE, FROM_REMOTE
};

struct please_migrate_h
{
	int reason;
	int to;
	struct mosix_addr ma;
};

struct mmap_parameters_h
{
	unsigned long addr;
	int fixed;
	unsigned long len;
	unsigned long flags;
	unsigned long pgoff;
	int origin;
	struct file *fp;
	struct dentry *dp;
	uint64_t uniq;
	off_t isize;
	nopage_t nopage;
};

struct brk_parameters_h
{
	unsigned long addr;
	unsigned long len;
};

struct munmap_parameters_h
{
	unsigned long addr;
	size_t len;
};

struct mprotect_parameters_h
{
	unsigned long addr;
	size_t len;
	unsigned long prot;
};

struct setupframe_parameters_h
{
	unsigned long sig;
	unsigned long flags;
	__sighandler_t handler;
	void (*restorer)(void);
	sigset_t set;
	struct siginfo info;
	unsigned long ss_sp;
	size_t ss_size;
};

struct restore_sigcontext_ret_h
{
	int result;
	int eax;
};

struct prequest_h
{
	char command;
	int param;
	int param2;
	int len;
};

struct prequest_reply_h
{
	int reply;
	int error;
	int datalen;
};

struct user_copy_h
{
	void *addr;
	unsigned int size;
	char verify;
};

struct strnlen_user_h
{
	char *addr;
	long len;
};

struct user_csum_copy_h
{
	void *addr;
	unsigned int len;
	int sum;
};

struct user_csum_copy_ret_h
{
	unsigned int newsum;
	unsigned int error;
};

struct asig_h
{
	unsigned int sigs;
	int nforced;
};

struct syscall_h
{
	int n;
	unsigned int args[6];
	int simple_data_type;
	unsigned long simple_data_addr;
	int simple_data_len;
	int simple_data_actual;
};

struct syscall_ret_h
{
	long ret;
	unsigned long deputytime;
	unsigned long simple_data_addr;
	int simple_data_len;	/* -1 = complex data */
};

struct bring_page_h
{
	struct file *fp;
	unsigned long offset;
	nopage_t nopage;
};

struct page_ret_h
{
	int ret;
	unsigned long deputytime;
};

struct rlimit_h
{
	int resource;
	struct rlimit limit;
};

struct execve_counts_h
{
	char **argp;
	char **envp;
};

struct execve_counts_ret_h
{
	int argc;
	int envc;
};

struct execve_bring_strings_h
{
	unsigned long p;
	char *filename;
	char **envp;
	int envc;
	char **argp;
	int argc;
};

struct execve_bring_strings_ret_h
{
	unsigned long p;
	unsigned long exec;
	int pgno;
	int len;
	int result;
};

struct execve_more_strings_h
{
	int pgno;
	int len;
};

struct execve_setup_args_h
{
	int create;
	int pgno;
	int len;
	int how;
	int p;
	int loader;
	int exec;
	int argc;
	int envc;
	unsigned long personality;
};

struct execve_setup_args_ret_h
{
	unsigned long p;
	unsigned long loader;
	unsigned long exec;
	int reply;
	unsigned long start_stack;
};

struct execve_exec_mmap_ret_h
{
	int result;
	char comm[16];
};

struct execve_elf_setup_h
{
	char *p;
	int argc;
	int envc;
	int hasexec;
	unsigned long exec_e_phoff;
	unsigned long exec_e_phnum;
	unsigned long exec_e_entry;
	unsigned long addr;
	unsigned long load_bias;
	unsigned long interp_load_addr;
	int ibcs;
	struct elf_tables_extras extras;
	int add_arg_start;
	unsigned long elf_brk;
	unsigned long end_code;
	unsigned long start_code;
	unsigned long start_data;
	unsigned long end_data;
	unsigned long elf_bss;
	unsigned long personality;
};

struct execve_fix_elf_aout_h
{
	unsigned bss;
	unsigned data;
	unsigned text;
};

struct list_vmas_ret_h
{
	int n;
	unsigned long argstart;
	unsigned long argend;
};

struct fork_h
{
	unsigned long usp;
	int do_forkmigrate;
	int pid;
};

struct mm_stats_h
{
	unsigned long start_code, end_code, start_data, end_data;
	unsigned long start_brk, brk, start_stack;
	unsigned long arg_start, arg_end, env_start, env_end;
};

struct disclosure_h
{
	uid_t uid;
	gid_t gid;
	pid_t pgrp;
	pid_t session;
	char disclosure;
	char comm[16];
	pid_t tgid;
};

struct mig_misc_h
{
	unsigned long ptrace;
	unsigned long dflags;
	long debugreg[8];
	long nice;
	kernel_cap_t caps;
	unsigned long it_prof_value, it_prof_incr, it_virt_value, it_virt_incr;
	struct pt_regs regs;
	struct rlimit rlim_cpu, rlim_data, rlim_stack, rlim_rss, rlim_as;
#ifdef CONFIG_MOSIX_DFSA
	struct rlimit rlim_nofile, rlim_fsz;
#endif /* CONFIG_MOSIX_DFSA */
	char stay;
	unsigned short deppe;
	unsigned short deputy_regs;
	u64 passedtime;
	u16 deccycle;
	s16 decay;
	u8 dpolicy;
	pid_t mypid;
	struct asig_h asig;
	struct disclosure_h info;
	int nmigs;
	int pagecredit;
	int lastxcpu;
	__u32 features[NCAPINTS];
	u64 tscval;
	struct opcost depcost[MAX_MOSIX_TOPOLOGY];
	int depspeed;
};

struct decay_h
{
	int policy;
	int deccycle;
	int decay;
};

struct aload_h
{
	int aload;
	int freepages;
#ifdef CONFIG_MOSIX_TOPOLOGY
	struct mfs_cost mfscosts[MAX_MOSIX_TOPOLOGY];
#endif /* CONFIG_MOSIX_TOPOLOGY */
};

#ifdef CONFIG_MOSIX_DFSA
struct read_yourself_h
{
	int dfsano;
	loff_t off;
	unsigned long addr;
	unsigned long len;
	int infolen;
};
#endif /* CONFIG_MOSIX_DFSA */

/* COMMAND CLASSES: */

#define	DEP_FLG	0x100
#define	MIG_FLG	0x200
#define	REPLY	0x400
#define	ANYTIME	0x800
#define	USERMODE 0x1000
#ifdef CONFIG_MOSIX_DFSA
#define	DFSA_NOUPDATE	0x2000
#else
#define	DFSA_NOUPDATE	0
#endif /* CONFIG_MOSIX_DFSA */

/* COMMANDS: */

#define	DEP_USERMODE		(DEP_FLG|0x00)
#define	DEP_SYNC		(DEP_FLG|0x01)
#define	DEP_NOTHING		(DEP_FLG|0x02)
#define	DEP_MMAP		(DEP_FLG|0x03)
#define	DEP_MUNMAP		(DEP_FLG|0x04)
#define	DEP_LISTHOLD		(DEP_FLG|0x05)
#define	DEP_SETUPFRAME		(DEP_FLG|0x06)
#define	DEP_NICE		(DEP_FLG|0x07)
#define	DEP_CPAS		(DEP_FLG|0x08)
#define	DEP_RESTORESIGCONTEXT	(DEP_FLG|0x09)
#define	DEP_PREQUEST		(DEP_FLG|0x10)
#define	DEP_COPY_FROM_USER	(DEP_FLG|0x11)
#define	DEP_COPY_TO_USER	(DEP_FLG|0x12)
#define	DEP_CLEAR_USER		(DEP_FLG|0x13)
#define	DEP_STRNCPY_FROM_USER	(DEP_FLG|0x14)
#define	DEP_STRNLEN_USER	(DEP_FLG|0x15)
#define	DEP_VERIFY_WRITE	(DEP_FLG|0x16)
#define	DEP_RLIMIT		(DEP_FLG|0x17)
#define	DEP_TAKEURGENT		(DEP_FLG|0x18)
#define	DEP_RUSAGE		(DEP_FLG|0x19)
#define	DEP_EXECVE_COUNTS	(DEP_FLG|0x20)
#define	DEP_BRING_STRINGS	(DEP_FLG|0x21)
#define	DEP_SETUP_ARGS		(DEP_FLG|0x22)
#define	DEP_EXEC_MMAP		(DEP_FLG|0x23)
#define	DEP_DUMP_THREAD		(DEP_FLG|0x24)
#define	DEP_INIT_AOUT_MM	(DEP_FLG|0x25)
#define	DEP_ELF_SETUP		(DEP_FLG|0x26)
#define	DEP_FIX_ELF_AOUT	(DEP_FLG|0x27)
#define	DEP_LIST_VMAS		(DEP_FLG|0x28)
#define	DEP_PLEASE_FORK		(DEP_FLG|0x29)
#define DEP_CONSIDER		(DEP_FLG|0x30)
#define	DEP_PERSONALITY		(DEP_FLG|0x31)
#define	DEP_BRING_ME_REGS	(DEP_FLG|0x32)
#define	DEP_CSUM_COPY_FROM_USER	(DEP_FLG|0x33)
#define	DEP_DUMP_FPU		(DEP_FLG|0x34)
#define	DEP_COME_BACK		(DEP_FLG|0x35)
#define DEP_PLEASE_MIGRATE	(DEP_FLG|0x36)
#define	DEP_CACHE_READ_DATA	(DEP_FLG|0x37)
#define	DEP_DATA_TO_USER	(DEP_FLG|0x38)
#define	DEP_UPDATE_DECAY	(DEP_FLG|0x39)
#define	DEP_UPDATE_LOCK		(DEP_FLG|0x40)
#define	DEP_PSINFO		(DEP_FLG|0x41)
#define	DEP_OPCOSTS		(DEP_FLG|0x42)
#define	DEP_MPROTECT		(DEP_FLG|0x43)
#define	DEP_BRK			(DEP_FLG|0x44)
#define	DEP_CAPS		(DEP_FLG|0x45)
#define	DEP_INFO		(DEP_FLG|0x46)
#ifdef CONFIG_MOSIX_DFSA
#define	DEP_DFSA_CHANGES	(DEP_FLG|0x80)
#define	DEP_DFSA_CLEAR		(DEP_FLG|0x81)
#define	DEP_READ_YOURSELF	(DEP_FLG|0x82)
#endif /* CONFIG_MOSIX_DFSA */

#define	REM_NOTHING		(ANYTIME|0x01)
#define	REM_PAGE		(ANYTIME|DFSA_NOUPDATE|0x02)
#define	REM_MORESTRINGS		(ANYTIME|0x03)
#define	REM_BRING_ME_REGS	(ANYTIME|0x04)
#define	REM_GETALOAD		(ANYTIME|0x05)
#define	REM_GETTSC		(ANYTIME|0x06)

#define	REM_NULLMSG		0x01
#define	REM_ASIG		0x02
#define	REM_SYSCALL_TRACE	0x03
#define	REM_SYSCALL		0x04
#define REM_BRING_ME_HOME	0x05
#define	REM_BRING_ME_TO		0x06
#define	REM_CONSIDERING		0x07
#define	REM_MUST_COME_HOME	0x08
#define	REM_CONNECT_TO		0x09

#define MIG_REQUEST		(MIG_FLG|0x01)

#define	MIG_MM_STATS		(MIG_FLG|0x10)
#define	MIG_MM_AREA		(MIG_FLG|0x11)
#define	MIG_PAGE		(MIG_FLG|0x12)
#define	MIG_FP			(MIG_FLG|0x13)
#define	MIG_XFP			(MIG_FLG|0x14)
#define	MIG_LDT			(MIG_FLG|0x15)
#define	MIG_MISC		(MIG_FLG|0x16)
#define	MIG_NOT_COMING		(MIG_FLG|0x17)

/* routines on the DEPUTY side of the protocol: */

extern int deputy_request(int, void *, int, void *, int, int, void **, int);
extern int deputy_wait(int, void **, int *);
extern int deputy_reply(int, void *, int, void *, int, int, int);
extern int deputy_handle_interim_request(int, void *, int);
extern void deputy_syscall(struct syscall_h *, int);
extern void deputy_rusage(int);
extern void deputy_add_rusage(struct rusage *);
extern void deputy_analyse_remote_signals(struct asig_h *);
extern int deputy_bring_page(struct bring_page_h *);
extern int deputy_tsc(void);
extern int deputy_more_strings(struct execve_more_strings_h *);
extern int deputy_bring_me_regs(unsigned long *);
extern void deputy_inform_remote_of_overheads(void);

/* routines on the REMOTE side of the protocol: */

extern int remote_request(int, void *, int, void *, int, int, void **, int);
extern void wait_for_permission_to_continue(void);
extern int remote_deputy_has_something_for_us(struct task_struct *);
extern void inform_deputy_of_urgent(void);
extern void transfer_signals_to_deputy(unsigned int, siginfo_t *, int);
extern void absorb_deptime(unsigned long);
extern int remote_rusage(int *);
extern int remote_execve_counts(struct execve_counts_h *);
extern int remote_bring_strings(struct execve_bring_strings_h *);
extern int remote_setup_args(struct execve_setup_args_h *);
extern int remote_exec_mmap(void);
extern int remote_urgent(void);
extern int remote_readpage(struct file *, struct page *);
extern int remote_dump_thread(void);
extern int remote_init_aout_mm(struct exec *);
extern int remote_elf_setup(struct execve_elf_setup_h *);
extern int remote_fix_elf_aout(struct execve_fix_elf_aout_h *);
extern int remote_list_vmas(void);
extern int remote_fork(struct fork_h *);
extern int remote_personality(unsigned long *);
extern int remote_prequest(struct prequest_h *);
extern int remote_mmap(struct mmap_parameters_h *, int);
extern int remote_brk(struct brk_parameters_h *);
extern int remote_munmap(struct munmap_parameters_h *);
extern int remote_mprotect(struct mprotect_parameters_h *);
extern int remote_come_back(void *);
extern int remote_goto_remote(void *);
extern int remote_copy_from_user(struct user_copy_h *);
extern int remote_copy_to_user(struct user_copy_h *);
extern int remote_data_to_user(struct user_copy_h *);
extern int remote_clear_user(struct user_copy_h *);
extern int remote_strncpy_from_user(struct user_copy_h *);
extern int remote_strnlen_user(struct strnlen_user_h *);
extern int remote_verify_write(struct user_copy_h *);
extern int remote_csum_copy_from_user(struct user_csum_copy_h *);
extern int remote_csum_copy_to_user(struct user_csum_copy_h *);
extern int remote_report_files(void);
extern int remote_setup_frame(struct setupframe_parameters_h *);
extern int remote_nice(long *);
extern int remote_caps(kernel_cap_t *);
extern int remote_depcosts(void *);
extern int remote_restore_sigcontext(struct sigcontext **);
extern int remote_bring_me_regs(unsigned long *);
extern int remote_dump_fpu(void);
extern int remote_consider(int *);
extern int remote_setdecay(struct decay_h *);
extern int remote_set_lock(int *);
extern int remote_psinfo(void);
#ifdef CONFIG_MOSIX_DFSA
extern int remote_receive_dfsachanges(int *);
extern int remote_read_yourself(struct read_yourself_h *);
#endif /* CONFIG_MOSIX_DFSA */
extern int remote_rlimit(struct rlimit_h *);
extern int remote_updinfo(struct disclosure_h *);
extern void remote_do_updinfo(struct disclosure_h *);
extern void remote_fill_rusage(struct rusage *, int);

/* routines used by both sides of the protocol: */

extern unsigned int which_regs_to_send(void);
extern void regs_were_sent(void);

#endif /*__KERNEL__*/
#endif /* CONFIG_MOSIX */
#endif
