/*
 * Copyright (c) 2000, Amnon BARAK (amnon@cs.huji.ac.il). All rights reserved.
 *
 *       MOSIX $Id: libmosix.c,v 1.9 2001/04/12 16:53:00 amnons Exp $
 *
 * Permission to use, copy and distribute this software is hereby granted 
 * under the terms of version 2 or any later version of the GNU General Public
 * License, as published by the Free Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED IN ITS "AS IS" CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/*
 * Author(s): Ariel Rosenblatt
 * Code derived from previous work by Amnon Shiloh and Oren Laadan.
 */

#include "mos.h"

int
msx_is_mosix() 
{
	return(!access("/proc/mosix/", 0));
}

int
msx_is_configured() 
{
	return(msx_read("/proc/mosix/admin/mospe") == -1 ? 0: 1);
}
 
int
msx_readval(char *fn, int *val)
{
	int fd = open(fn, 0);
	int r;
	char num[30];

	if(fd == -1)
		return(0);
	num[sizeof(num)-1] = '\0';
	r = read(fd, num, sizeof(num)-1);
	close(fd);
	return(r >= 0 && sscanf(num, "%d", val) == 1);
}

int
msx_readval2(char *fn, int *val1, int *val2)
{
	int fd = open(fn, 0);
	int r;
	char num[30];

	if(fd == -1)
		return(0);
	num[sizeof(num)-1] = '\0';
	r = read(fd, num, sizeof(num)-1);
	close(fd);
	if(r < 0)
		return(0);
	r = sscanf(num, "%d %d", val1, val2);
	if(r == 1)
		*val2 = 0;
	else if(r != 2)
		return(0);
	return(1);
}

int
msx_write(char *fn, int val)
{
	int fd = open(fn, 1);
	int l, r;
	char num[30];

	if(fd == -1)
		return(0);
	sprintf(num, "%d\n", val);
	r = write(fd, num, l = strlen(num));
	close(fd);
	return(r == l);
}

int
msx_write2(char *fn, int val1, int val2)
{
	int fd = open(fn, 1);
	int l, r;
	char num[30];

	if(fd == -1)
		return(0);
	sprintf(num, "%d %d\n", val1, val2);
	r = write(fd, num, l = strlen(num));
	close(fd);
	return(r == l);
}

int
msx_replace(char *fn, int val)
{
	int fd = open(fn, 2);
	int l, r;
	char num[30];
	int ret;

	if(fd == -1)
		return(0);
	num[sizeof(num)-1] = '\0';
	r = read(fd, num, sizeof(num)-1);
	if(r < 0 || sscanf(num, "%d", &ret) != 1)
		return(-1);
	sprintf(num, "%d\n", val);
	r = write(fd, num, l = strlen(num));
	close(fd);
	return(r == l ? ret : -1);
}

int
msx_read(char *fn)
{
	int val;

	return(msx_readval(fn, &val) ? val : -1);
}

int
msx_readnode(int node, char *item)
{
	char fn[40];
	int val;

	if(!node && !(node = msx_read("/proc/mosix/admin/mospe")))
		return(-1);
	sprintf(fn, "/proc/mosix/nodes/%d/%s", node, item);
	if(!msx_readval(fn, &val))
		return(-1);
	if(val >= 0)
		return(val);
	errno = -val;
	return(-1);
}

int
msx_writeproc(int pid, char *item, int val)
{
	char fn[30];

	sprintf(fn, "/proc/%d/%s", pid, item);
	return(msx_write(fn, val));
}

int
msx_readproc(int pid, char *item)
{
	char fn[30];

	sprintf(fn, "/proc/%d/%s", pid, item);
	return(msx_read(fn));
}

int
msx_readdata(char *fn, void *into, int max, int size)
{
	int fd = open(fn, 0);
	int r;

	if(fd == -1)
		return(0);
	r = read(fd, into, max * size);
	close(fd);
	if(r == -1 || (r % size))
		return(0);
	return(r / size);
}

int
msx_count_ints(char *fn)
{
	int fd = open(fn, 0);
	int r;
	char buf[4096];
	char *p = buf, *np;
	int n = 0;

	if(fd == -1)
		return(0);
	r = read(fd, buf, sizeof(buf));
	close(fd);
	if(r < 0)
		return(-1);
	if(r == sizeof(buf))
	{
		errno = E2BIG;
		return(-1);
	}
	buf[r] = '\0';
	for(p = buf ; strtol(p, &np, 0) , np != p ; p = np)
		n++;
	return(n);
}

int
msx_fill_ints(char *fn, int *into, int max)
{
	int fd = open(fn, 0);
	int r;
	char buf[4096];
	char *p = buf, *np;
	int n = 0;

	if(fd == -1)
		return(0);
	r = read(fd, buf, sizeof(buf));
	close(fd);
	if(r < 0)
		return(-1);
	if(r == sizeof(buf))
	{
		errno = E2BIG;
		return(-1);
	}
	buf[r] = '\0';
	for(p = buf ; n < max && (into[n] = strtol(p, &np, 0) , np != p) ; p=np)
		n++;
	return(n);
}
