// $Id: Autofire.cc,v 1.10 2005/01/17 19:29:11 m9710797 Exp $

#include "Autofire.hh"
#include "IntegerSetting.hh"

using std::string;

namespace openmsx {

Autofire::Autofire(unsigned newMinInts, unsigned newMaxInts, const string& name)
	: min_ints(newMinInts)
	, max_ints(newMaxInts)
	, speedSetting(new IntegerSetting(name,
	               "controls the speed of this autofire circuit", 0, 0, 100))
{
	if (min_ints < 1) {
		min_ints = 1;
	}
	if (max_ints <= min_ints) {
		max_ints = min_ints + 1;
	}
	setClock();

	speedSetting->addListener(this);
}

Autofire::~Autofire()
{
	speedSetting->removeListener(this);
}

void Autofire::setClock()
{
	int speed = speedSetting->getValue();
	clock.setFreq(
	    (2 * 50 * 60) / (max_ints - (speed * (max_ints - min_ints)) / 100));
}

void Autofire::update(const Setting* setting)
{
	assert(setting == speedSetting.get());
	setClock();
}

byte Autofire::getSignal(const EmuTime& time)
{
	return speedSetting->getValue() == 0 ? 0 : clock.getTicksTill(time) & 1;
}

} // namespace openmsx
