// $Id: MSXS1990.hh,v 1.11 2005/01/17 19:29:31 m9710797 Exp $

#ifndef __MSXS1990_HH__
#define __MSXS1990_HH__

#include "MSXDevice.hh"
#include <memory>

namespace openmsx {

class FirmwareSwitch;

/**
 * This class implements the MSX-engine found in a MSX Turbo-R (S1990)
 *
 * TODO explanation
 */
class MSXS1990 : public MSXDevice
{
public:
	MSXS1990(const XMLElement& config, const EmuTime& time);
	virtual ~MSXS1990();

	virtual void reset(const EmuTime& time);
	virtual byte readIO(byte port, const EmuTime& time);
	virtual byte peekIO(byte port, const EmuTime& time) const;
	virtual void writeIO(byte port, byte value, const EmuTime& time);

private:
	void setCPUStatus(byte value);

	const std::auto_ptr<FirmwareSwitch> firmwareSwitch;
	byte registerSelect;
	byte cpuStatus;
};

} // namespace openmsx

#endif // __MSXS1990_HH__
