// $Id: MSXTurboRLeds.cc,v 1.13 2005/03/01 17:16:39 m9710797 Exp $

#include "MSXTurboRLeds.hh"
#include "LedEvent.hh"
#include "EventDistributor.hh"

namespace openmsx {

MSXTurboRLeds::MSXTurboRLeds(const XMLElement& config, const EmuTime& time)
	: MSXDevice(config, time)
	, prev(255)
{
	reset(time);
}

MSXTurboRLeds::~MSXTurboRLeds()
{
}

void MSXTurboRLeds::reset(const EmuTime& time)
{
	writeIO(0, 0, time);
}

void MSXTurboRLeds::powerDown(const EmuTime& time)
{
	writeIO(0, 0, time);
}

void MSXTurboRLeds::writeIO(byte /*port*/, byte value, const EmuTime& /*time*/)
{
	if ((prev ^ value) & 0x01) {
		EventDistributor::instance().distributeEvent(
			new LedEvent(LedEvent::PAUSE, value & 0x01));
	}
	if ((prev ^ value) & 0x80) {
		EventDistributor::instance().distributeEvent(
			new LedEvent(LedEvent::TURBO, value & 0x80));
	}
	prev = value;
}

} // namespace openmsx
