// $Id: MSXTurboRPause.cc,v 1.10 2004/10/19 19:47:44 m9710797 Exp $

#include "MSXTurboRPause.hh"

namespace openmsx {

MSXTurboRPause::MSXTurboRPause(const XMLElement& config, const EmuTime& time)
	: MSXDevice(config, time),
	  turboRPauseSetting("turborpause", 
	                     "status of the TurboR pause", false)
{
	reset(time);
}

MSXTurboRPause::~MSXTurboRPause()
{
}
 
void MSXTurboRPause::reset(const EmuTime& /*time*/)
{
	turboRPauseSetting.setValue(false);
}

byte MSXTurboRPause::readIO(byte port, const EmuTime& time)
{
	return peekIO(port, time);
}

byte MSXTurboRPause::peekIO(byte /*port*/, const EmuTime& /*time*/) const
{
	return turboRPauseSetting.getValue() ? 1 : 0;
}

} // namespace openmsx
