// $Id: IDEDevice.hh,v 1.4 2004/12/15 09:09:47 m9710797 Exp $

#ifndef __IDEDevice_HH__
#define __IDEDevice_HH__

#include "openmsx.hh"

namespace openmsx {

class EmuTime;

class IDEDevice
{
public:
	virtual ~IDEDevice() {}
	virtual void reset(const EmuTime &time) = 0;

	virtual word readData(const EmuTime &time) = 0;
	virtual byte readReg(nibble reg, const EmuTime &time) = 0;

	virtual void writeData(word value, const EmuTime &time) = 0;
	virtual void writeReg(nibble reg, byte value, const EmuTime &time) = 0;
};

} // namespace openmsx
#endif
