// $Id: RomSynthesizer.hh,v 1.10 2005/01/13 18:25:41 m9710797 Exp $

#ifndef __ROMSYNTHESIZER_HH__
#define __ROMSYNTHESIZER_HH__

#include "Rom16kBBlocks.hh"

namespace openmsx {

class DACSound8U;

class RomSynthesizer : public Rom16kBBlocks
{
public:
	RomSynthesizer(const XMLElement& config, const EmuTime& time,
	               std::auto_ptr<Rom> rom);
	virtual ~RomSynthesizer();

	virtual void reset(const EmuTime& time);
	virtual void writeMem(word address, byte value, const EmuTime& time);
	virtual byte* getWriteCacheLine(word address) const;

private:
	std::auto_ptr<DACSound8U> dac;
};

} // namespace openmsx

#endif
