// $Id: MidiOutConnector.hh,v 1.10 2004/12/15 09:09:49 m9710797 Exp $

#ifndef __MIDIOUTCONNECTOR_HH__
#define __MIDIOUTCONNECTOR_HH__

#include "Connector.hh"
#include "SerialDataInterface.hh"
#include "MidiOutDevice.hh"

namespace openmsx {

class MidiOutConnector : public Connector, public SerialDataInterface
{
public:
	MidiOutConnector(const std::string& name);
	virtual ~MidiOutConnector();

	// Connector
	virtual const std::string& getDescription() const;
	virtual const std::string& getClass() const;
	virtual MidiOutDevice& getPlugged() const;

	// SerialDataInterface
	virtual void setDataBits(DataBits bits);
	virtual void setStopBits(StopBits bits);
	virtual void setParityBit(bool enable, ParityBit parity);
	virtual void recvByte(byte value, const EmuTime& time);
};

} // namespace openmsx

#endif // __MIDIOUTCONNECTOR_HH__
