// $Id: InfoTopic.cc,v 1.3 2005/09/30 12:56:05 m9710797 Exp $

#include "InfoTopic.hh"
#include "CommandController.hh"
#include "InfoCommand.hh"

using std::string;
using std::vector;

namespace openmsx {

InfoTopic::InfoTopic(CommandController& commandController, const string& name)
	: Completer(commandController, name)
{
	getCommandController().getInfoCommand().registerTopic(*this, getName());
}

InfoTopic::~InfoTopic()
{
	getCommandController().getInfoCommand().unregisterTopic(*this, getName());
}

void InfoTopic::tabCompletion(vector<string>& /*tokens*/) const
{
	// do nothing
}

} // namespace openmsx
