// $Id: MSXRom.cc,v 1.24 2006/01/16 17:59:50 m9710797 Exp $

#include "MSXRom.hh"
#include "MSXMotherBoard.hh"
#include "Rom.hh"

namespace openmsx {

MSXRom::MSXRom(MSXMotherBoard& motherBoard, const XMLElement& config,
               const EmuTime& time, std::auto_ptr<Rom> rom_)
	: MSXDevice(motherBoard, config, time, rom_->getName()), rom(rom_)
	, cpu(motherBoard.getCPU())
{
}

MSXRom::~MSXRom()
{
}

void MSXRom::writeMem(word /*address*/, byte /*value*/, const EmuTime& /*time*/)
{
	// nothing
}

byte* MSXRom::getWriteCacheLine(word /*address*/) const
{
	return unmappedWrite;
}

} // namespace openmsx
