// $Id: SettingsConfig.hh 5779 2006-10-14 16:17:32Z m9710797 $

#ifndef SETTINGSCONFIG_HH
#define SETTINGSCONFIG_HH

#include "XMLElement.hh"
#include "noncopyable.hh"
#include <memory>

namespace openmsx {

class SettingsManager;
class HotKey;
class GlobalCommandController;
class SaveSettingsCommand;
class LoadSettingsCommand;

class SettingsConfig : public XMLElement, private noncopyable
{
public:
	SettingsConfig(GlobalCommandController& commandController, HotKey& hotKey);
	~SettingsConfig();

	void loadSetting(FileContext& context, const std::string& filename);
	void saveSetting(const std::string& filename = "");
	void setSaveSettings(bool save);

	SettingsManager& getSettingsManager();

private:
	GlobalCommandController& commandController;

	const std::auto_ptr<SaveSettingsCommand> saveSettingsCommand;
	const std::auto_ptr<LoadSettingsCommand> loadSettingsCommand;

	std::auto_ptr<SettingsManager> settingsManager;
	HotKey& hotKey;
	std::string saveName;
	bool mustSaveSettings;
};

} // namespace openmsx

#endif
