// $Id: CLIOption.hh 7731 2008-04-03 19:58:10Z m9710797 $

#ifndef CLIOPTION_HH
#define CLIOPTION_HH

#include <string>
#include <deque>

namespace openmsx {

class CLIOption
{
public:
	virtual ~CLIOption() {}
	virtual bool parseOption(const std::string& option,
	                         std::deque<std::string>& cmdLine) = 0;
	virtual const std::string& optionHelp() const = 0;

protected:
	std::string getArgument(const std::string& option,
	                        std::deque<std::string>& cmdLine) const;
	std::string peekArgument(const std::deque<std::string>& cmdLine) const;
};

class CLIFileType
{
public:
	virtual ~CLIFileType() {}
	virtual void parseFileType(const std::string& filename,
	                           std::deque<std::string>& cmdLine) = 0;
	virtual const std::string& fileTypeHelp() const = 0;
};

} // namespace openmsx

#endif
