#!/usr/bin/env python
# Copyright (C) 2000-2001 The OpenRPG Project
#
#        openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: main.py
# Author: Chris Davis
# Maintainer:
# Version:
#   $Id: main.py,v 1.80 2005/11/07 03:21:05 mduo13 Exp $
#
# Description: This is the main entry point of the oprg application
#

__version__ = "$Id: main.py,v 1.80 2005/11/07 03:21:05 mduo13 Exp $"

import orpg.plugins#mDuo13 added
from orpg_version import *
import orpg.dirpath
from orpg.orpg_windows import *
import orpg.orpg_xml
import orpg.player_list

#from orpg.orpg_settings import *
import orpg.tools.orpg_settings
#from orpg.gametree.gametree import *
import orpg.gametree.gametree
#from orpg.chat.chatutils import *
import orpg.chat.chatwnd
from wxPython.lib.splashscreen import SplashScreen
from string import *
import orpg.tools.toolBars
import orpg.tools.passtool
import orpg.tools.autoupdate
import orpg.dieroller.utils

import orpg.networking.mplay_client
import orpg.networking.gsclient
import orpg.mapper.map
import orpg.mapper.images
import os
import time
import thread
import traceback
import orpg.tools.orpg_sound
import sys

# menu ids
EXIT_TOOL = wxNewId()
GAMSERV_TOOL = wxNewId()
L_GAME_SERVER = wxNewId()
GS = wxNewId() #menu close Game Server ID
CA = wxNewId() #menu close Cancel ID
EX = wxNewId() #menu close Exit Program ID
EXIT_GAME_TOOL = wxNewId()
PREFS_TOOL = wxNewId()
INSTALL_TOOL = wxNewId()

#MENU_FLUSH_CACHE = wxNewId()

PLUGIN_TOOL = wxNewId()#mDuo13 added
MAP_TOOL = wxNewId()
#INIT_TOOL = wxNewId()
CHAT_TOOL = wxNewId()
PLAYER_TOOL = wxNewId()
STATUS_TOOL = wxNewId()
D_LAYOUT = wxNewId()
WND_MODE_TOOL = wxNewId()
ABOUT_TOOL = wxNewId()
DICEBAR_TOOL = wxNewId()
MAPBAR_TOOL = wxNewId()
PWDMGR_TOOL = wxNewId()
#AUTO_SPLITTER_TOGGLE = wxNewId()

#help menu imports and ids
import webbrowser
ONLINE_USERGUIDE = wxNewId()
ONLINE_HELP_URL ="http://openrpg.wrathof.com/faq"


# windowing options
WND_ONE = 0
WND_MANY = 1

# mins between ping intervals
PING_INTERVAL = 5



########################
## timer
########################

class mytimer(wxTimer):
    def __init__(self,func):
        self.func = func
        wxTimer.__init__(self)

    def Notify(self):
        self.func()

########################
## openrpg object
########################

class open_rpg:
    def __init__(self,coms):
        self.components = {}
        self.components.update(coms)

    def add_component(self,key,com):
        self.components[key]=com

    def get_component(self,key):
        if self.components.has_key(key):
            return self.components[key]
        else:
            return None

########################
## About HTML Dialog
########################

class AboutHTMLWindow( wxHtmlWindow ):
    "Window used to display the About dialog box"

    # Init using the derived from class
    def __init__( self, parent, id, position, size, style ):
        wxHtmlWindow.__init__( self, parent, id, position, size, style )


    def OnLinkClicked( self, ref ):
        "Open an external browser to resolve our About box links!!!"

        href = ref.GetHref()
        webbrowser.open( href )



#  This class extends wxSplitterWindow to add an auto expand behavior.  The idea is that the sash
#       determines the ratio of the two windows, while the mouse position determines which
#       side will get the larger share of the screen real estate.  It is used instead of regular
#       wxSplitterWindows if the EnableSplittersAutoExpand setting doesn't evaluate as false.
#
#  Note:  To be truly functional, some way of passing EVT_MOTION events to this class, even when the
#       event takes place over child windows needs to be accomplished.  Once this is accomplished,
#       however, the class should work as written.
class orpgFocusSplitterWindow(wxSplitterWindow):

    def __init__(self,parent,id = -1,AutoExpand = 1,point = wxDefaultPosition,size = wxDefaultSize,style = wxSP_3D,name="splitterWindow"):
        wxSplitterWindow.__init__(self,parent,id,point,size,style,name)

        self.auto = AutoExpand
        EVT_IDLE(self,self.OnIdle)  # used in workaround idea from Robin Dunn instead of EVT_MOTION

    #  Get's called during idle times.  It checks to see if the mouse is over self and calls
    #      OnMotion with the coordinates

    def EnableAutoExpand(self,value):
        self.auto = value

    def OnIdle(self,event):
        if self.auto:
            (screen_x,screen_y) = wxGetMousePosition()
            (x,y) = self.ScreenToClientXY(screen_x,screen_y) # translate coordinates
            (w,h) = self.GetSizeTuple()
            if x >= 0 and x < w and y >= 0 and y < h:
                self.OnMotion(x,y)
        event.Skip()


    def OnMotion(self,mouse_X,mouse_Y):
        # Gather some info using standard wxWindows calls
        (w,h) = self.GetClientSizeTuple()
        (second_w,second_h) = self.GetWindow2().GetClientSizeTuple()
        (second_x,second_y) = self.GetWindow2().GetPositionTuple()
        splitmode = self.GetSplitMode()
        sash = self.GetSashPosition()

        if splitmode == wxSPLIT_VERTICAL:
            pos = mouse_X #  Position of the mouse pointer
            second = second_x  #  Beginning of the second (Right) pane
            second_size = second_w  # Size of the second pane
        else:
            pos = mouse_Y #  Position of the mouse pointer
            second = second_y  #  Beginning of the second (Bottom) pane
            second_size = second_h  # Size of the second pane

        sash_size = second - sash    # Beginning of sash to beginning of second is the sash size

        if (pos > sash + sash_size and second_size < sash) or (pos < sash and second_size > sash):
            #  Equivalent to the following
            #  if
            #  (the mouse position is below/to the right of the sash, including it's thickness
            #      i.e. in the second window
            #  AND
            #  the second window is smaller than the 1st (size = the sash position))
            #
            #  OR
            #
            #  (the mouse position is above/to the left of the sash
            #      i.e. in the first window
            #  AND
            #  the second window is bigger than the 1st)


            # flip the split
            self.SetSashPosition(second_size)
            #  Both cases above set the sash to a position that corresponds to the size of the
            #  second window.  This has the effect of making the first window trade sizes with
            #  the second window.
            #      In the first part of the OR clause, the first window takes the second window's
            #      size because the user wants the currently small lower window to be big, so
            #      the first must take on the size of the small.
            #
            #      In the second case of the OR clause, the first window takes the second window's
            #      size because the user wants the currently small upper window to be big (which
            #      the second window currently is), so make the first take the size of the second.



####################################
## Main Frame
####################################

class orpgFrame(wxFrame):
    def __init__(self, parent, id, title):
        wxFrame.__init__(self, parent, id,title, wxPoint(100, 100),
                         wxSize(600,420),style = wxDEFAULT_FRAME_STYLE)

        # Determine which icon format to use
        icon = None
        if wxPlatform == '__WXMSW__':
            icon = wxIcon(orpg.dirpath.dir_struct["icon"]+'d20.ico', wxBITMAP_TYPE_ICO)

        else:
            icon = wxIcon(orpg.dirpath.dir_struct["icon"]+"d20.xpm", wxBITMAP_TYPE_XPM )

        # Set it if we have it
        if icon != None:
            self.SetIcon( icon )

        self.settings = orpg.tools.orpg_settings.settings()

        # create session
        call_backs = {"on_receive":self.on_receive,
                "on_mplay_event":self.on_mplay_event,
                "on_group_event":self.on_group_event,
                "on_player_event":self.on_player_event,
                "on_status_event":self.on_status_event,
                "on_password_signal":self.on_password_signal,
                "orpgFrame":self}

        self.session = orpg.networking.mplay_client.mplay_client(self.settings.get_setting("player"),call_backs)
        self.poll_timer = mytimer(self.session.poll)
        self.poll_timer.Start(500)
        self.ping_timer = mytimer(self.session.update)


        # create roller manager
        self.roller_manager = orpg.dieroller.utils.roller_manager(self.settings.get_setting("dieroller"))

        #create password manager --SD 8/03
        self.password_manager = orpg.tools.passtool.PassTool()

        self.myopenrpg = open_rpg({ "session":self.session,
                                    'frame':self, 'settings':self.settings,
                                    'roller_manager':self.roller_manager,
                                    'password_manager':self.password_manager})

        # build frame windows
        self.build_menu()
        self.build_gui()
        self.build_hotkeys()

        self.myopenrpg.add_component("chat",self.chat)
        self.myopenrpg.add_component("map",self.map)
        self.tree.load_tree(self.settings.get_setting("gametree"))
        self.players.size_cols()

        #Plugins Window
        orpg.plugins.frame = orpg.plugins.PluginFrame( self, -1 )#mDuo13 added

        # check for updates
        autoupdater = orpg.tools.autoupdate.AutoUpdate()
        if (autoupdater.check(self, self.settings)):
            self.closed_confirmed()


        EVT_CLOSE(self,self.OnCloseWindow)
        #self.set_window_mode(int(s.get_setting("MultipleWindows")))


    def toggle_password_manager(self,evt):
        id = evt.GetId()
        if id == PWDMGR_TOOL:
            if self.toolmenu.IsChecked( PWDMGR_TOOL ):
                self.password_manager.Enable()
            else:
                self.password_manager.Disable()



    def on_password_signal(self,signal,type,id,data):
        try:
            print ("DEBUG: password response= "+str(signal)+" (T:"+str(type)+"  #"+str(id)+")" )
            id = int(id)
            type = str(type)
            data = str(data)
            signal = str(signal)
            if signal == "fail":
                if type == "server":
                    self.password_manager.ClearPassword("server", 0)
                elif type == "admin":
                    self.password_manager.ClearPassword("admin",int(id))
                elif type == "room":
                    self.password_manager.ClearPassword("room", int(id))
                else:
                    pass
        except:
            traceback.print_exc()


    def reset_windows(self, evt=None):
        settings = self.myopenrpg.get_component('settings')
        layouts = self.frame_layouts

        for pos_key in layouts.keys():
            settings.set_setting(pos_key, str(layouts[pos_key][1]), hidden=1)

        self.arange_windows()

    def arange_windows(self,evt=None):
        w = wxSystemSettings_GetSystemMetric(wxSYS_SCREEN_X)-50
        h = wxSystemSettings_GetSystemMetric(wxSYS_SCREEN_Y)-100

        settings = self.myopenrpg.get_component('settings')

        layouts = {"tree_pos": [self, (0,0,300,(h-220))],
                   "chat_pos": [self.chat_frame, (300,h/2,w-300,(h/2)-20)],
                   "player_pos": [self.player_frame, (0,h-250,300,200)],
                   "map_pos": [self.map_frame, (300,0,w-300,h/2)]}

        for pos_key in layouts.keys():
            pos = settings.get_setting(pos_key, create=0)
            if pos:
                pos = map(int, string.split(pos[1:-1], ',')) # str => tuple of ints
            else:
                pos = layouts[pos_key][1]
                settings.set_setting(pos_key, str(pos), hidden=1)
            layouts[pos_key][0].SetDimensions(pos[0], pos[1], pos[2], pos[3])
            layouts[pos_key][0].Show( true )
            layouts[pos_key][0].Raise()
        self.frame_layouts = layouts


    def set_splitters_auto_expand(self,value):
        try:
            expanding_splitters = int(value)  # attempt to convert to int
        except:
            expanding_splitters = 1  # arbitrarily assume that a failure means yes.

        try:
            self.splitter.EnableAutoExpand(expanding_splitters)
            self.splitter2.EnableAutoExpand(expanding_splitters)
            self.splitter3.EnableAutoExpand(expanding_splitters)

        except:
            pass


    def build_gui(self):
        self.splitters = []
        self.dlgs = []
        orpg.tools.config_files.validate_config_file("gui.xml","default_gui.xml")
        filename = orpg.dirpath.dir_struct["user"] + "gui.xml"
        temp_file = open(filename)
        txt = temp_file.read()
        xml_dom = orpg.orpg_xml.parseXml(txt)._get_documentElement()
        temp_file.close()
        children = xml_dom._get_childNodes()
        for c in children:
            self.build_window(c,self)

        # status window
        self.status_frame = wxPFrame(None, "Status Bar",only_hide=1,style = wxCAPTION | wxSYSTEM_MENU | wxSTAY_ON_TOP)
        self.status = status_bar(self.status_frame)
        self.status_frame.SetStatusBar(self.status)
        # Create and show the floating dice toolbar
        self.dieToolBar = orpg.tools.toolBars.DiceToolBar( self, callBack = self.chat.ParsePost )
        self.mapToolBar = orpg.tools.toolBars.MapToolBar( self, callBack = self.map.MapBar )

        self.gs_frame = None
        self.gs = None

        screen_w = wxSystemSettings_GetSystemMetric(wxSYS_SCREEN_X)
        screen_h = wxSystemSettings_GetSystemMetric(wxSYS_SCREEN_Y)-100

        h = int(xml_dom.getAttribute("height"))
        w = int(xml_dom.getAttribute("width"))

        if h > screen_h or h < 250:
            h = screen_h
        if w > screen_w or w < 250:
            w = screen_w

        posx = int(xml_dom.getAttribute("posx"))
        posy = int(xml_dom.getAttribute("posy"))

        ## On Apple OSX the apple menu bar is not figured into the available screen space
        ## This fix adjusts the window position automatically so the top of
        ## the openrpg window doesn't appear behind the apple menu
        ## current as of OSX 10.3.8 --Snowdog 2-22-05
        if sys.platform == 'darwin':
            if posy < 45: posy = 45




        if posy > screen_h:
            posy = 0
        if posx > screen_w:
            posx = 0

        self.SetDimensions(posx,posy,w,h)

        # temp fix... but doesn't work on linux
        #for s in self.splitters:
        #    s.SetSashPosition(300)

    def post_show_init(self):
        # Some actions need to be done after the main window is created and shown.
        # You can place that code here
        for d in self.dlgs:
            d.Show(1)
        self.players.size_cols()

    def do_splitter_window(self,xml_dom,parent_wnd):
        temp_wnd = wxSplitterWindow(parent_wnd,-1) #orpgFocusSplitterWindow(parent = parent_wnd, id = -1, AutoExpand = 0)
        children = xml_dom._get_childNodes()
        sp1 = self.build_window(children[0],temp_wnd)
        sp2 = self.build_window(children[1],temp_wnd)
        pos = int(xml_dom.getAttribute("pos"))
        if xml_dom.getAttribute("type") == "v":
            temp_wnd.SplitVertically(sp1,sp2,pos)
        else:
            temp_wnd.SplitHorizontally(sp1,sp2,pos)
        temp_wnd.SetMinimumPaneSize(50)
        #temp_wnd.SetSashPosition(int(xml_dom.getAttribute("pos")))
        return temp_wnd


    def do_tab_window(self,xml_dom,parent_wnd):
        # if cotainer window loop through childern and do a recursive call
        temp_wnd = wxNotebook(parent_wnd, -1)
        children = xml_dom._get_childNodes()
        for c in children:
            wnd = self.build_window(c,temp_wnd)
            name = c.getAttribute("name")
            temp_wnd.AddPage(wnd,name)
        return temp_wnd

    def do_dlg_window(self,xml_dom,parent_wnd):
        children = xml_dom._get_childNodes()
        name = children[0].getAttribute("name")
        h = int(xml_dom.getAttribute("height"))
        w = int(xml_dom.getAttribute("width"))
        posx = int(xml_dom.getAttribute("posx"))
        posy = int(xml_dom.getAttribute("posy"))
        temp_wnd = wxPFrame(self, name, pos = (posx,posy), size = (w,h), only_hide=1,style = wxCAPTION | wxSYSTEM_MENU | wxSTAY_ON_TOP | wxRESIZE_BORDER)
        temp_wnd.panel = self.build_window(children[0],temp_wnd)
        #temp_wnd.Show(1)
        return temp_wnd

    def build_window(self,xml_dom,parent_wnd):
        name = xml_dom._get_nodeName()
        #container = 0
        if name=="tab":
            temp_wnd = self.do_tab_window(xml_dom,parent_wnd)
        elif name=="splitter":
            temp_wnd = self.do_splitter_window(xml_dom,parent_wnd)
            self.splitters.append(temp_wnd)
        elif name=="dialog":
            temp_wnd = self.do_dlg_window(xml_dom,parent_wnd)
            self.dlgs.append(temp_wnd)
        elif name=="map":
            temp_wnd = orpg.mapper.map.map_wnd(parent_wnd,-1,self.myopenrpg)
            self.map = temp_wnd
        elif name=="tree":
            temp_wnd = orpg.gametree.gametree.game_tree(parent_wnd,-1,self.myopenrpg)
            self.tree = temp_wnd
        elif name=="chat":
            if self.settings.get_setting('tabbedwhispers') == "1":
                temp_wnd = orpg.chat.chatwnd.chat_notebook(parent_wnd, -1,self.myopenrpg)
                self.chat = temp_wnd.MainChatPanel
            else:
                temp_wnd  = orpg.chat.chatwnd.chat_panel(parent_wnd, -1, self.myopenrpg, sendtarget="all")
                self.chat = temp_wnd
        elif name=="player":
            temp_wnd = orpg.player_list.player_list(parent_wnd, self.myopenrpg )
            self.players = temp_wnd

        return temp_wnd


    def build_menu(self):
        self.mainmenu = wxMenuBar()
        menu = wxMenu()
        menu.Append(PREFS_TOOL,"&Settings\tCtrl-S")
        menu.Append(ABOUT_TOOL, "&About")
        menu.AppendSeparator()
        menu.Append(EXIT_TOOL,"&Exit")

        EVT_MENU(self, EXIT_TOOL, self.OnCloseWindow)
        EVT_MENU(self, PREFS_TOOL, self.OnPrefs)
        self.mainmenu.Append(menu, '&OpenRPG')

        menu = wxMenu()
        menu.Append(GAMSERV_TOOL,"&Browse Servers\tCtrl-B")
        menu.AppendSeparator()
        menu.Append(L_GAME_SERVER,"&Start Server")
        EVT_MENU(self, GAMSERV_TOOL, self.on_gs_client)
        EVT_MENU(self,L_GAME_SERVER, self.launch_gameserver)

        self.mainmenu.Append(menu, '&Game Server')
        #menu = wxMenu()
        #menu.Append(CHAT_TOOL,"&Chat Window")
        #menu.Append(MAP_TOOL,"&Map Window")
        #menu.Append(PLAYER_TOOL,"&Player Window")
        #menu.AppendSeparator()
        #menu.Append(D_LAYOUT,"&Reset Layout")
        #menu.AppendSeparator()
        #menu.Append(WND_MODE_TOOL,"&Switch Window Mode")
#        menu.AppendSeparator()
#        menu.Append(AUTO_SPLITTER_TOGGLE,"&Auto-size panes")
        #self.mainmenu.Append( menu, "&Windows" )

        menu = wxMenu()
        menu.Append( PLUGIN_TOOL, "&Plugins" )#mDuo13 added
        self.toolmenu = menu
        menu.AppendSeparator()
        #menu.Append( INIT_TOOL, "&Initiative" )
        menu.AppendCheckItem( PWDMGR_TOOL, "Password Manager", "Enable/disable the Password Manager")
        EVT_MENU(self, PWDMGR_TOOL, self.toggle_password_manager)
        
        menu.AppendSeparator()
        menu.Append( DICEBAR_TOOL, "&Dice Tool Bar\tCtrl-D" )
        menu.Append( MAPBAR_TOOL, "&Map Tool Bar" )
        menu.Append( STATUS_TOOL, "S&tatus Bar\tCtrl-T" )
        menu.Enable( MAPBAR_TOOL, false )
        self.mainmenu.Append( menu, "&Tools" )

        EVT_MENU(self, PLUGIN_TOOL, self.on_window)#mDuo13 added
        EVT_MENU(self, CHAT_TOOL, self.on_window)
        EVT_MENU(self, MAP_TOOL, self.on_window)
        EVT_MENU(self, PLAYER_TOOL, self.on_window)
        EVT_MENU(self, STATUS_TOOL, self.on_window)
        EVT_MENU(self, DICEBAR_TOOL, self.on_window)
        EVT_MENU(self, MAPBAR_TOOL, self.on_window)
        #EVT_MENU(self, INIT_TOOL, self.on_init)
        EVT_MENU(self, WND_MODE_TOOL, self.on_window)
        EVT_MENU(self, D_LAYOUT, self.reset_windows)
#        EVT_MENU(self, AUTO_SPLITTER_TOGGLE, self.toggle_autosplitters)
        EVT_MENU(self, ABOUT_TOOL, self.OnAbout)

        #--------------------------------------------------------
        # help menu by Snowdog 5/03
        #--------------------------------------------------------
        EVT_MENU(self,ONLINE_USERGUIDE, self.on_user_guide_online)
        helpmenu = wxMenu()
        helpmenu.Append( ONLINE_USERGUIDE,"Online User Guide")
        self.mainmenu.Append( helpmenu, "Help" )

        #add the finished menu
        self.SetMenuBar(self.mainmenu)





    #--------------------------------------------------------
    # ONLINE HELP GUIDE MENU LINK by Snowdog 5/03
    #--------------------------------------------------------
    def on_user_guide_online(self,event):
        wb = webbrowser.get()
        wb.open(ONLINE_HELP_URL)




    def build_hotkeys(self):
        entries = []
        entries.append((wxACCEL_CTRL,ord('S'),PREFS_TOOL))
        entries.append((wxACCEL_CTRL,ord('D'),DICEBAR_TOOL))
        entries.append((wxACCEL_CTRL,ord('B'),GAMSERV_TOOL))
        entries.append((wxACCEL_CTRL,ord('T'),STATUS_TOOL))

        # get other hot keys
        entries.extend(self.chat.get_hot_keys())
        entries.extend(self.map.get_hot_keys())
        # set accelerator table
        accel = wxAcceleratorTable(entries)
        self.SetAcceleratorTable(accel)


    def on_window(self,evt):
        id = evt.GetId()
        if id == CHAT_TOOL:
            self.chat_frame.Show( true )
            self.chat_frame.Raise()
        elif id == MAP_TOOL:
            self.map_frame.Show( true )
            self.map_frame.Raise()
        elif id == PLAYER_TOOL:
            self.player_frame.Show( true )
            self.player_frame.Raise()
        #mDuo13 added lines below
        elif id == PLUGIN_TOOL:
            orpg.plugins.frame.Show(true)
            orpg.plugins.frame.Raise()
        #end mDuo13 added lines
        elif id == MAPBAR_TOOL:
            self.mapToolBar.Show( true )
            self.mapToolBar.Raise()
        elif id == DICEBAR_TOOL:
            self.dieToolBar.Show( true )
            self.dieToolBar.Raise()
        elif id == STATUS_TOOL:
            self.status_frame.Show( true )
            self.status_frame.Raise()
        elif id == WND_MODE_TOOL:
            if self.current_mode == WND_MANY:
                self.set_window_mode(WND_ONE)
            else:
                self.set_window_mode(WND_MANY)



    def start_timer(self):
        self.poll_timer.Start(333)
        s = self.myopenrpg.get_component('settings')
        if s.get_setting("Heartbeat") == "1":
            self.ping_timer.Start(1000*60*PING_INTERVAL)
            print "starting heartbeat..."


    def launch_gameserver(self,evt):
##        execommand = sys.executable + " start_server_gui.py "

        start_dialog=wxProgressDialog( "Server Loading", "Server Loading, Please Wait...", 1, self )

        # Spawn the new process and close the stdout handle from it
        start_dialog.Update( 0 )
        # Adjusted following code to work with win32, can't test for Unix
        # as per reported bug 586227
        if wxPlatform == "__WXMSW__":
            arg = '\"' + os.path.normpath(orpg.dirpath.dir_struct["home"] + 'start_server_gui.py') + '\"'
            args = ( sys.executable, arg )
        else:
            arg = orpg.dirpath.dir_struct["home"] + 'start_server_gui.py'
            args = (arg,arg)

        os.spawnv( os.P_NOWAIT, sys.executable, args )
        start_dialog.Update( 1 )

        start_dialog.Show(FALSE)
        start_dialog.Destroy()


    def server_stop(self):
        self.server_stop = "TRUE"


    def on_gs_client(self,evt):
        if self.gs_frame == None or self.gs_frame.destroyed:
            self.gs_frame = wxPFrame(None,"Game Server",only_hide=1)
            self.gs = orpg.networking.gsclient.game_server_panel(self.gs_frame,self.myopenrpg)
            self.gs_frame.panel = self.gs
            self.gs_frame.SetSize(wxSize(640,480))
            self.gs_frame.Show( true )
            self.gs_frame.Raise()
        else:
            self.gs_frame.Show( true )
            self.gs_frame.Raise()
            #self.gs.refresh_server_list()

    def kill_mplay_session(self):
        #gsclient.remove_game(self.game_info)
        self.game_name = ""
        self.session.start_disconnect()


    def quit_game(self,evt):
        dlg = wxMessageDialog(self,"Exit gaming session?","Game Session",wxYES_NO)
        if dlg.ShowModal() == wxID_YES:
            self.session.exitCondition.notifyAll()
            dlg.Destroy()
            self.kill_mplay_session()


    def on_status_event(self,evt):
        id = evt.get_id()
        status = evt.get_data()
        if id == orpg.networking.mplay_client.STATUS_SET_URL:
            self.status.set_url(status)

    def on_player_event(self, evt):
        id = evt.get_id()
        player = evt.get_data()
        display_name = self.chat.chat_display_name(player)
        time_str = time.strftime("%H:%M", time.localtime())
        if id == orpg.networking.mplay_client.PLAYER_NEW:
            self.players.add_player(player)
            self.chat.InfoPost(display_name + " (enter): " + time_str)
        elif id == orpg.networking.mplay_client.PLAYER_DEL:
            self.players.del_player(player)
            self.chat.InfoPost(display_name + " (exit): " + time_str)
        elif id == orpg.networking.mplay_client.PLAYER_UPDATE:
            self.players.update_player(player)
        self.players.Refresh()

    def on_group_event(self,evt):
        id = evt.get_id()
        data = evt.get_data()
        # if gs is up
        if self.gs_frame:
            if id == orpg.networking.mplay_client.GROUP_NEW:
                self.gs.add_room(data)
            elif id == orpg.networking.mplay_client.GROUP_DEL:
                self.password_manager.RemoveGroupData(data)
                self.gs.del_room(data)
            elif id == orpg.networking.mplay_client.GROUP_UPDATE:
                self.gs.update_room(data)



    def on_receive(self,data,player):
        #settings = self.myopenrpg.get_component('settings')
        session = self.myopenrpg.get_component("session")

        # see if we are ignoring this user
        (ignore_id,ignore_name) = session.get_ignore_list()
        for m in ignore_id:
            if m == player[2]:
                # yes we are
                print "ignoring message from player:" + player[0]
                return

        # ok we are not ignoring this message
        #recvSound = "RecvSound"                #  this will be the default sound.  Whisper will change this below
        if player:
            display_name = self.chat.chat_display_name(player)
        else:
            display_name = "Server Administrator"

        if data[:5] == "<tree":
            self.tree.on_receive_data(data,player)
            self.chat.InfoPost(display_name + " has sent you a tree node...")
            #self.tree.OnNewData(data)

        elif data[:4] == "<map":
            self.map.new_data(data)

        elif data[:5] == "<chat":
            msg = orpg.chat.chat_msg.chat_msg(data)
            self.chat.post_incoming_msg(msg,player)
        else:
        ##############################################################################################
        #  all this below code is for comptiablity with older clients and can be removed after a bit #
        ##############################################################################################
            if data[:3] == "/me":
                # This fixes the emote coloring to comply with what has been asked for by the user
                # population, not to mention, what I committed to many moons ago.
                #  In doing so, Woody's scheme has been tossed out.  I'm sure Woody won't be
                # happy but I'm invoking developer priveledge to satisfy user request, not to mention,
                # this scheme actually makes more sense.  In Woody's scheme, a user could over-ride another
                # users emote color.  This doesn't make sense, rather, people dictate their OWN colors...which is as
                # it should be in the first place and is as it has been with normal text.  In short, this makes
                # sense and is consistent.
                data = data.replace( "/me", "" )

                # Check to see if we find the closing ">" for the font within the first 22 values
                index = data[:22].find(  ">" )
                if index == -1:
                    data = "** " + self.chat.colorize( self.chat.infocolor, display_name + data ) + " **"

                else:
                    # This means that we found a valid font string, so we can simply plug the name into
                    # the string between the start and stop font delimiter
                    print "pre data = " + data
                    data = data[:22] + "** " + display_name + " " + data[22:] + " **"
                    print "post data = " + data


            elif data[:2] == "/w":
                data = data.replace("/w","")
                data = "<B>"+display_name+"</B> (whispering): " + data

            else:
                # Normal text
                if player:
                    data = "<B>"+display_name+"</B>: " + data
                else:
                    data = "<B><I><U>"+display_name+"</U>-></I></B> " + data

            self.chat.Post(data)




    def on_mplay_event(self,evt):
        id = evt.get_id()
        if id == orpg.networking.mplay_client.MPLAY_CONNECTED:
            self.chat.InfoPost("Game connected!")
            self.gs.set_connected(1)
            self.password_manager.ClearPassword("ALL")
            #self.tb.EnableTool(EXIT_GAME_TOOL,true)

        elif id == orpg.networking.mplay_client.MPLAY_DISCONNECTED:
            self.poll_timer.Stop()
            self.ping_timer.Stop()
            self.chat.SystemPost("Game disconnected!")
            self.players.reset()
            self.gs.set_connected(0)
            self.status.set_connect_status("Not Connected")
#            self.tb.EnableTool(EXIT_GAME_TOOL,false)

        ####Begin changes for Custom Exit Message by mDuo13######
        elif id == orpg.networking.mplay_client.MPLAY_DISCONNECTING:
            settings = self.myopenrpg.get_component('settings')
            custom_msg = settings.get_setting("dcmsg")
            custom_msg=custom_msg[:80]
            if custom_msg[:3]=="/me":
                self.chat.send_chat_message(custom_msg[3:], 3)
            else:
                self.chat.system_message(custom_msg)
        #####End Changes for Custom Exit Message by mDuo13

        elif id== orpg.networking.mplay_client.MPLAY_GROUP_CHANGE:
            group = evt.get_data()
            self.chat.InfoPost("Moving to room '"+group[1]+"'..")
            if self.gs : self.gs.set_cur_room_text(group[1])
            self.players.reset()

        elif id== orpg.networking.mplay_client.MPLAY_GROUP_CHANGE_F:
            self.chat.SystemPost("Room access denied!")


    def OnCloseWindow(self, event):
        dlg = wxMessageDialog(self,"Quit OpenRPG?","OpenRPG",wxYES_NO)
        if dlg.ShowModal() == wxID_YES:
            dlg.Destroy()
            self.closed_confirmed()

    def closed_confirmed(self):
        self.save_layout()
        try:
            s = self.myopenrpg.get_component('settings')
            s.save()
        except: print "[WARNING] Error saving 'settings' component"

        try:
            self.map.pre_exit_cleanup()
        except: print "[WARNING] Map error pre_exit_cleanup()"

        try:
            save_tree = string.upper(s.get_setting("SaveGameTreeOnExit"))
            if  (save_tree <> "0") and (save_tree <> "FALSE") and (save_tree <> "NO"):
                self.tree.save_tree(s.get_setting("gametree"))
        except: print "[WARNING] Error saving gametree"

        if self.session.get_status() == orpg.networking.mplay_client.MPLAY_CONNECTED:
            self.kill_mplay_session()

        #following lines added by mDuo13
        #########close_module()#########
        for plugin_fname in orpg.plugins.frame.enabled_plugins.keys():
            plugin = orpg.plugins.frame.enabled_plugins[plugin_fname]
            try:
                plugin.close_module(self)
            except Exception, e:
                if str(e) != "'module' object has no attribute 'close_module'":
                    #print e
                    traceback.print_exc()
        ####now, destroy the plugin window also###
        orpg.plugins.frame.Destroy()
        #end mDuo13 added code

        # destroy windows
        #if self.player_frame:
        #    self.player_frame.Destroy()
        #    self.player_frame = None
        #    self.chat_frame.Destroy()
        #    self.chat_frame = None
        #    self.map_frame.Destroy()
        #    self.map_frame = None

        if self.gs_frame:
            self.gs_frame.Destroy()
        self.status_frame.Destroy()
        self.status_frame = None
        self.Destroy()
        try:
            if self.server_pipe <> None:
                dlg = wxProgressDialog("Exit","Stoping server",2,self)
                dlg.Update(2)
                dlg.Show(TRUE)
                self.server_pipe.write("\nkill\n")
                print "Killing Server process:"
                time.sleep(5)
                self.server_stop()
                self.server_pipe.close()
                self.std_out.close()
                self.server_thread.exit()
                dlg.Destroy()
                print "Server killed:"
        except:
            pass

    def save_layout(self):
        return
        ## avoid this
        if self.current_mode == WND_MANY:
            settings = self.myopenrpg.get_component('settings')
            layouts = self.frame_layouts
            for pos_key in layouts.keys():
                rect = layouts[pos_key][0].GetRect()
                settings.set_setting(pos_key, "(%s, %s, %s, %s)" % (rect.x, rect.y, rect.width, rect.height), hidden=1)
        elif self.current_mode == WND_ONE:
            pass
            # maybe save the splitter positions here

    def OnPrefs(self, event):
        setobj = self.myopenrpg.get_component('settings')
        dlg = orpg.tools.orpg_settings.prefs_dialog(self,setobj,self.myopenrpg)
        dlg.ShowModal()
        self.session.set_name(setobj.get_setting("player"))
        self.chat.set_colors()
        self.chat.set_buffersize()


    def OnAbout( self, event ):
        "The about box.  We're making it n HTML about box because it's pretty cool!"
        "Inspired by the wxWindows about.cpp sample."

        topSizer = wxBoxSizer( wxVERTICAL )
        dlg = wxDialog( self, -1, "About" )
        html = AboutHTMLWindow( dlg, -1, wxDefaultPosition, wxSize(400, 200), wxHW_SCROLLBAR_NEVER )
        html.SetBorders( 0 )
        replace_text = "VeRsIoNrEpLaCeMeNtStRiNg"
        about_file = open(orpg.dirpath.dir_struct["template"]+"about.html","r")
        about_text = about_file.read()
        about_file.close()
        display_text = string.replace(about_text,replace_text,VERSION)
        html.SetPage(display_text)

        html.SetSize( wxSize(html.GetInternalRepresentation().GetWidth(),
                             html.GetInternalRepresentation().GetHeight()) )

        topSizer.Add( html, 1, wxALL, 10 )
        topSizer.Add( wxStaticLine( dlg, -1), 0, wxEXPAND | wxLEFT | wxRIGHT, 10 )

        wxOkay = wxButton( dlg, wxID_OK, "Okay" )
        wxOkay.SetDefault()

        topSizer.Add( wxOkay, 0, wxALL | wxALIGN_RIGHT, 15 )

        dlg.SetAutoLayout( TRUE )
        dlg.SetSizer( topSizer )
        topSizer.Fit( dlg )

        dlg.ShowModal()
        dlg.Destroy()


#########################
#status frame window
#########################
class status_bar(wxStatusBar):
    def __init__(self,parent):
        wxStatusBar.__init__(self, parent, -1)

        GENERAL_MENU = 1
        URL_MENU = 2
        self.parent = parent
        self.connect_status = "Not Connected"
        self.urlis = ""
        self.window = 1
        self.mainmenu = wxMenuBar()
        menu = wxMenu()
        menu.Append(GENERAL_MENU,"General")
        menu.Append(URL_MENU,"Url display")

        self.mainmenu.Append(menu,"Switch layout to...")
        self.parent.SetMenuBar(self.mainmenu)

        self.widths = [100,-1,200]
        (msgwidth,msgheight) = self.GetTextExtent(`self.connect_status`)
        parent.SetClientSize(wxSize(450,msgheight+8))
        #self.SetClientSize(wxSize(450,msgheight+7))
        self.SetFieldsCount(3)

        EVT_MENU(self.parent,GENERAL_MENU,self.on_menu)
        EVT_MENU(self.parent,URL_MENU,self.on_menu)
        EVT_SIZE(self, self.on_size)
        EVT_CLOSE(self, self.on_close)

        self.timer = wxPyTimer(self.Notify)
        self.timer.Start(1000)
        self.Notify()

    def on_menu(self,evt):
        self.window = evt.GetId()

    def set_connect_status(self,connect):
        self.connect_status = connect

    def Notify(self):
        if self.window == 1:
            self.bar0()
        elif self.window == 2:
            self.bar1()
        pass

    def bar1(self):
        self.SetFieldsCount(1)
        self.widths = [-1]
        self.SetStatusWidths(self.widths)
        self.SetStatusText("URL: " +self.urlis,0)

    def bar0(self):
        self.SetFieldsCount(3)
        self.widths = [100,-1,200]
        t = time.gmtime(time.time())
        st = time.strftime("GMT: %d-%b-%Y  %I:%M:%S", t)
        (x,y) = self.GetTextExtent(self.connect_status)
        self.widths[0] = x+10
        (x,y) = self.GetTextExtent(st)
        self.widths[1] = -1
        self.widths[2] =  x+10
        self.SetStatusWidths(self.widths)
        self.SetStatusText(self.connect_status,0)
        self.SetStatusText(st,2)

    def set_url(self,url):
        self.urlis = url

    def on_close(self,evt):
        self.Show( false )

    def on_size(self,evt):
        s = self.GetClientSizeTuple()
        w = s[0]
#        self.SetDimensions(0,0,s[0],s[1])


########################################
## Application class
########################################

class orpgApp(wxApp):
    def OnInit(self):
        wxInitAllImageHandlers()
        self.splash = SplashScreen(None, bitmapfile=orpg.dirpath.dir_struct["icon"]+'splash13.jpg',
                                   duration=3000, callback=self.AfterSplash)
        self.splash.Show(true)
        wxYield()
        return true

    def AfterSplash(self):
        self.splash.Close(true)
        self.frame = orpgFrame(NULL, -1, "OpenRPG v"+VERSION)
        self.frame.Raise()
        self.frame.Refresh()
        self.frame.Show(true)
        self.SetTopWindow(self.frame)
        #self.frame.show_dlgs()
        self.frame.post_show_init()
        return true
