name="Smilies!"
author="mDuo13"
help="""This plugin turns text smilies like >=) or :D into images. There are 15
images. Also, you can type '/smiley' to get a list of what emoticons are
converted to what images."""
#'name' should contain your plugin's long name.
#       Make sure it's not the same as another plugin's name.
#'author' is the author of the plugin. It will be listed in the plugin info.
#'help' is the help text that will be displayed when the user clicks the
#       'Plugin Info' button.
#--------------------------------------
import os
import orpg.dirpath

chat=None
session=None
tree=None
openrpg=None

smileylist={
    ">:)"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley8.gif'> ",
    ">:-("   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley7.gif'> ",
    ">:-)"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley8.gif'> ",
    ">:("   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley7.gif'> ",
    ">=("   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley7.gif'> ",
    ">=)"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley8.gif'> ",
    "=)"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley0.gif'> ",
    "=D"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley1.gif'> ",
    "8)"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley2.gif'> ",
    ";)"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley3.gif'> ",
    "=p"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley4.gif'> ",
    "=/"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley5.gif'> ",
    "=|"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley6.gif'> ",
    "=("    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley9.gif'> ",
    ":)"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley0.gif'> ",
    ":D"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley1.gif'> ",
    "B)"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley2.gif'> ",
    ":p"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley4.gif'> ",
    ":/"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley5.gif'> ",
    ":|"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley6.gif'> ",
    ":("    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley9.gif'> ",
    ":\\"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley5.gif'> ",
    "=\\"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley5.gif'> ",
    ":P"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley4.gif'> ",
    "=P"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley4.gif'> ",
    "|l"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley10.gif'> ",
    "l."    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley10.gif'> ",
    "|."    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley10.gif'> ",
    ":lol"  :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley11.gif'> ",
    "^_^"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley12.gif'> ",
    "^-^"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley12.gif'> ",
    "^.^"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley12.gif'> ",
    "n_n"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley12.gif'> ",
    "n.n"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley12.gif'> ",
    "n,n"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley12.gif'> ",
    "I-)"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley13.gif'> ",
    "n.n;"  :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley14.gif'> ",
    "n.n;;" :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley14.gif'> ",
    "n_n;"  :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley14.gif'> ",
    ":-)"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley0.gif'> ",
    ":-D"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley1.gif'> ",
    ":-P"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley2.gif'> ",
    ":-p"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley4.gif'> ",
    ":-/"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley5.gif'> ",
    ":-|"    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley6.gif'> ",
    ":-("    :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley9.gif'> ",
    ":-\\"   :       "<img src='" + orpg.dirpath.dir_struct["plugins"] + "smiley5.gif'> "}

##Now we have the functions. These are called from within OpenRPG at various
##times. You can reference and change the variables, and do other things too.
##The more you know about python and OpenRPG, the more you can do. The
##possibilities are larger than you'd think.
##Note that when I say "formatted" I mean that it has HTML tags like font colors
##and names already added.

def message(self, text):
    #This is called whenever the user types something and hits enter.
    #It covers all messages, before they are formatted.
    return text

def send_msg(self, text, send):
    #This is called when a message is about to be sent out.
    #It covers all messages sent by the user, before they have been formatted.
    #If send is set to 0, the message will not be sent out to other
    #users, but it will still be posted to the user's chat normally.
    #Otherwise, send defaults to 1. (The message is sent as normal)
    return text, send

def receive_msg(self, text, type, name, player):
    #This is called whenever a message from someone else is received, no matter
    #what type of message it is.
    #The text variable is the text of the message. If the type is a regular
    #message, it is already formatted. Otherwise, it's not.
    #The type variable is an integer which tells you the type: 1=chat, 2=whisper
    #3=emote, 4=info, and 5=system.
    #The name variable is the name of the player who sent you the message.
    #The player variable contains lots of info about the player sending the
    #message, including name, ID#, and currently-set role.
    #Uncomment the following line to see the format for the player variable.
    #print player
    posted = 0#If posted is set to 1 then the chat module will stop processing
    #the incoming message. Use this if you post the incoming message elsewhere,
    #for example in a special tab or window.
    return text, type, name, posted

def post_msg(self, text, myself):
    #This is called whenever a message written by the user is about to be posted
    #to chat; it doesn't affect the copy of the message that gets sent to others
    text = text.replace("> ", ">&nbsp;")
    text = text.replace(" <", "&nbsp<")
    text = text.replace("<", " %%<")
    text = text.replace(">", ">%% ")
    text = text.replace(" >%% ", " >")
    text2 = text.split()
    for num in range(0, len(text2)):
        chunk = text2[num]
        for key in smileylist.keys():
            if chunk == key:
                text2[num] = smileylist[key]
            if chunk == key+",":
                text2[num] = smileylist[key]+","
            if chunk == key+".":
                text2[num] = smileylist[key]+"."
    text=""
    for chunk in text2:
        text += chunk+" "
    text = text.replace("%% %%", "%%  %%")
    text = text.replace(" %%<", "<")
    text = text.replace(">%% ", ">")
    if text[:2]=="%%":
        text = text[2:]
    if text[-2:]=="%%":
        text = text[:-2]
    return text

def docmd(self, text, cmdlist):
    #This is called when the user enters a / command that OpenRPG doesn't
    #recognize. Thus, you can create new / commands. The text variable
    #is the text that the user inputted. If it is your custom command,
    #return 1. If it is not, return 0.
    global smileylist

    if cmdlist[0] == "/smiley":
        chat.Post("Available Smilies:", 0)
        the_list = ""
        for key in smileylist.keys():
            the_list += key+"&nbsp&nbsp&nbsp : &nbsp&nbsp&nbsp"+smileylist[key]+"<br>"
        chat.Post(the_list)
        return 1
    return 0

def refresh_counter(self):
    #This is called once per second. That's all you need to know.
    pass

def close_module(self):
    #This is called when OpenRPG shuts down
    pass
