**Language Features:**
* Added angle parameter to rotate_extrude()
* Extend list comprehension to allow looping over characters of a string
* Added ord() to convert from character to Unicode code point
* Allow echo() in expression context (e.g. for debugging recursive functions)
* Added assert() to stop script evaluation on failed constraints
* Added $preview variable which is set to true in preview mode (#1963)
* Removed glide() and subdiv() which were never implemented
* Added is_undef() to look up variables silently (#2535)
* Extended List-Comprehension (#1536)
* C-Style for in list comprehensions (#1537)

**Program Features:**
* Support for using 3D-Mouse / Joystick / Gamepad input devices for controlling the 3D view
* Add customizer for GUI based model changes
* Better Find/Replace in text editor
* Add AMF import/export
* Add SVG import/export
* Add 3MF import/export
* Play sound notification on render complete (#2393)
* hardwarning option - if enabled, the software stops on the first warning
* improved errors and warnings
   * line number and file name are now shown for many errors and warnings
   * warning when the parameters of a module call do not match module declaration
   * various new warnings
   * warn when a parameter passed to an buildin module is out of range
     (e.g. 0>=, not a number, infinitie)

**Bugfixes/improvements:**
* Align camera behavior and lighting between GUI and and command line (#2491)
* Fix linear_extrude() with scale factor for concave results (#2259)
* Optionally play sound on completion of render process
* Command line help automatically generated
* 2D shapes are rendered in the x-y plane (at z = 0)
* Parse errors include file name and line number
* Update to latest MCAD
* Fix crash when using each with scalar values (#1851)
* Fix view-all to be independent on object location
* Fix AMF loading on Windows
* improved errors and warnings
   * warning when conversions failed
   * Line Numbers
   * warn on the use of unknown $special_variables
   * warning for duplicate assigments
* log does not get cleared anymore (#2541)

**Various:**
* Ukrainian translation
* Polish translation
* line number in the editor can now be disabled in the preferences (#1612)
* multiline comment folding (#1603)

**Deprecations:**
