package OpenSRS::Util::Asia;

# $Id: Asia.pm,v 1.2 2008/03/12 17:07:48 sbelikov Exp $

# .ASIA specific lists, configs, validations, and related subroutines...
# (Mostly CED Contact Information)

require Exporter;
@ISA = qw (Exporter);

use strict 'vars';
use Data::Dumper;
use Time::Local;
use Time::localtime;
use OpenSRS::Util::Common qw(build_select_menu3);

use vars qw(@EXPORT_OK %asia_ced_locality_country
  @asia_ced_locality_country_list
  %asia_ced_entity_type
  @asia_ced_entity_type_list
  %asia_ced_contact_type
  @asia_ced_contact_type_list
  %asia_ced_identification_type
  @asia_ced_identification_type_list
);

@EXPORT_OK = qw (%asia_ced_locality_country
  @asia_ced_locality_country_list
  build_ced_locality_select_list
  %asia_ced_entity_type
  @asia_ced_entity_type_list
  build_ced_entity_type_select_list
  %asia_ced_contact_type
  @asia_ced_contact_type_list
  build_ced_contact_type_select_list
  %asia_ced_identification_type
  @asia_ced_identification_type_list
  build_ced_identification_type_select_list
);


# Locality of establishment of the Entity (based on the corresponding ISO3166 code)
# (from the .ASIA registrar manual)
%asia_ced_locality_country = (
    'CN' => 'China',
    'HK' => 'Hong Kong',
    'JP' => 'Japan',
    'KP' => 'Korea, Democratic People\'s Republic of',
    'KR' => 'Korea, Republic of',
    'MN' => 'Mongolia',
    'MO' => 'Macao',
    'TW' => 'Taiwan',
    'AE' => 'United Arab Emirates',
    'AF' => 'Afghanistan',
    'AM' => 'Armenia',
    'AZ' => 'Azerbaijan',
    'BH' => 'Bahrain',
    'CY' => 'Cyprus',
    'GE' => 'Georgia',
    'IL' => 'Israel',
    'IQ' => 'Iraq',
    'IR' => 'Iran, Islamic Republic of',
    'JO' => 'Jordan',
    'KG' => 'Kyrgyzstan',
    'KW' => 'Kuwait',
    'KZ' => 'Kazakhstan',
    'LB' => 'Lebanon',
    'OM' => 'Oman',
    'PS' => 'Palestinian Territories',
    'QA' => 'Qatar',
    'SA' => 'Saudi Arabia',
    'SY' => 'Syrian Arab Republic',
    'TJ' => 'Tajikistan',
    'TM' => 'Turkmenistan',
    'TR' => 'Turkey',
    'UZ' => 'Uzbekistan',
    'YE' => 'Yemen',
    'BD' => 'Bangladesh',
    'BN' => 'Brunei Darussalam',
    'BT' => 'Bhutan',
    'ID' => 'Indonesia',
    'IN' => 'India',
    'KH' => 'Cambodia',
    'LA' => 'Lao People\'s Democratic Republic',
    'LK' => 'Sri Lanka',
    'MN' => 'Myanmar',
    'MV' => 'Maldives',
    'MY' => 'Malaysia',
    'NP' => 'Nepal',
    'PH' => 'Philippines',
    'PK' => 'Pakistan',
    'SG' => 'Singapore',
    'TH' => 'Thailand',
    'TL' => 'Timor-Leste',
    'VN' => 'Viet Nam',
    'AQ' => 'Antarctica',
    'AU' => 'Australia',
    'CC' => 'Cocos (Keeling) Islands',
    'CK' => 'Cook Islands',
    'CX' => 'Christmas Island',
    'FJ' => 'Fiji',
    'FM' => 'Micronesia, Federated States of',
    'HM' => 'Heard Island and McDonald Islands',
    'KI' => 'Kiribati',
    'MH' => 'Marshall Islands',
    'NF' => 'Norfolk Island',
    'NR' => 'Nauru',
    'NU' => 'Niue',
    'NZ' => 'New Zealand',
    'PG' => 'Papua New Guinea',
    'PW' => 'Palau',
    'SB' => 'Solomon Islands',
    'TK' => 'Tokelau',
    'TO' => 'Tonga',
    'TV' => 'Tuvalu',
    'VU' => 'Vanuatu',
    'WS' => 'Samoa',
);
@asia_ced_locality_country_list = sort( { return ( $asia_ced_locality_country{$a} cmp $asia_ced_locality_country{$b} ) } keys(%asia_ced_locality_country) );

# Dynamic options list for locality selection...
sub build_ced_locality_select_list {
    my ($default) = @_;
    my $temp = { %asia_ced_locality_country, '' => 'Select Entity Establishment Location' };
  return build_select_menu3( $temp, [ '', @asia_ced_locality_country_list ], $default );
}


# Type of Entity
%asia_ced_entity_type = (
    'naturalPerson'  => 'Natural Persons',
    'corporation'    => 'Corporations or Companies',
    'cooperative'    => 'Cooperatives',
    'partnership'    => 'Partnerships or Collectives',
    'government'     => 'Government Bodies, States, Sovereigns or Municipalities',
    'politicalParty' => 'Political parties or Trade Unions',
    'society'        => 'Trusts, Estates, Associations or Societies',
    'institution'    => 'Institutions',
    'other'          => 'Other',
);
@asia_ced_entity_type_list = qw(naturalPerson corporation cooperative partnership government politicalParty society institution other);

# Dynamic options list for entity type selection...
sub build_ced_entity_type_select_list {
    my ($default) = @_;
    my $temp = { %asia_ced_entity_type, '' => 'Select Entity Type' };
  return build_select_menu3( $temp, [ '', @asia_ced_entity_type_list ], $default );
}


# Contact Type (Primary CED Contact)
%asia_ced_contact_type = (
	'owner' => 'Owner/Registrant',
	'tech' => 'Technical',
	'billing' => 'Billing',
	'admin' => 'Adminstrative',
);
@asia_ced_contact_type_list = sort keys %asia_ced_contact_type;

# Dynamic options list for contact type selection...
sub build_ced_contact_type_select_list {
    my ($default) = @_;
    my $temp = { %asia_ced_contact_type, '' => 'Select Contact Type' };
  return build_select_menu3( $temp, [ '', @asia_ced_contact_type_list ], $default );
}


# Form of Identification
%asia_ced_identification_type = (
    'passport'			=> 'Passport or Citizenship ID',
    'certificate'		=> 'Certificate of Incorporation or equivalent business registration certificate',
    'legislation'		=> 'Act, decree or legislation chartering the formation of an entity',
    'societyRegistry'		=> 'Societies Registry or equivalent registry for non-corporate entities',
    'politicalPartyRegistry'	=> 'Political Parties Registry',
    'other'			=> 'Other',
);
@asia_ced_identification_type_list = qw(passport certificate legislation societyRegistry politicalPartyRegistry other);

# Dynamic options list for identification type selection...
sub build_ced_identification_type_select_list {
    my ($default) = @_;
    my $temp = { %asia_ced_identification_type, '' => 'Select Form of Identification' };
  return build_select_menu3( $temp, [ '', @asia_ced_identification_type_list ], $default );
}

1;
