
# a controller node through the OCI's ENC:
#
#---
#classes:
#   oci_controller:
#      is_first_master: true
#      first_master: zigo-controller-node-3.infomaniak.ch
#      first_master_ip: 192.168.100.40
#      vip_hostname: zigo-api.infomaniak.ch
#      vip_ipaddr: 192.168.101.2
#      network_ipaddr: 192.168.101.0
#      network_cidr: 24
#      other_masters:
#         - zigo-controller-node-4.infomaniak.ch
#         - zigo-controller-node-5.infomaniak.ch
#      other_masters_ip:
#         - 192.168.100.41
#         - 192.168.100.32
#      all_masters:
#         - zigo-controller-node-3.infomaniak.ch
#         - zigo-controller-node-4.infomaniak.ch
#         - zigo-controller-node-5.infomaniak.ch
#      all_masters_ip:
#         - 192.168.100.40
#         - 192.168.100.41
#         - 192.168.100.32
#
# This is re-used in the oci_controller class below
#
class oci::controller(
  $machine_hostname         = undef,
  $machine_ip               = undef,
  $is_first_master          = false,
  $first_master             = undef,
  $first_master_ip          = undef,
  $other_masters            = undef,
  $other_masters_ip         = undef,
  $vip_hostname             = undef,
  $vip_ipaddr               = undef,
  $vip_netmask              = undef,
  $network_ipaddr           = undef,
  $network_cidr             = undef,
  $all_masters              = undef,
  $all_masters_ip           = undef,
  $all_masters_ids          = undef,
  $has_subrole_db           = true,
  $has_subrole_api_keystone = true,
  $has_subrole_heat         = true,
  $has_subrole_glance       = false,
  $has_subrole_nova         = false,
  $has_subrole_neutron      = false,
  $has_subrole_swift        = true,
  $has_subrole_horizon      = true,
  $has_subrole_barbican     = true,
  $has_subrole_cinder       = false,
  $use_ssl                  = true,
  $pass_keystone_db         = undef,
  $pass_nova_db             = undef,
  $pass_nova_apidb          = undef,
  $pass_placement_db        = undef,
  $pass_glance_db           = undef,
  $pass_cinder_db           = undef,
  $pass_neutron_db          = undef,
  $pass_heat_db             = undef,
  $pass_barbican_db         = undef,
){

  if $use_ssl {
    $proto = 'https'
    $messaging_default_port = '5671'
    $messaging_notify_port = '5671'
    $api_port = 443
  } else {
    $proto = 'http'
    $messaging_default_port = '5672'
    $messaging_notify_port = '5672'
    $api_port = 80
  }
  $messaging_default_proto = 'rabbit'
  $messaging_notify_proto = 'rabbit'

  $base_url = "${proto}://${vip_hostname}"
  $keystone_auth_uri  = "${base_url}:${api_port}/identity"
  $keystone_admin_uri = "${base_url}:${api_port}/identity-admin"
  #$memcached_servers  = ["127.0.0.1:11211"]
  $memcached_string = join([join($all_masters_ip,':11211,'), ':11211'],'')
  $memcached_servers  = ["${memcached_string}"]

    ensure_resource('file', '/root/oci-openrc', {
      'ensure'  => 'present',
      'content' => "
export OS_PROJECT_DOMAIN_NAME='default'
export OS_USER_DOMAIN_NAME='default'
export OS_PROJECT_NAME='admin'
export OS_USERNAME='admin'
export OS_PASSWORD='${pass_keystone_adminuser}'
export OS_AUTH_URL='https://${vip_hostname}/identity-admin/v3'
export OS_IDENTITY_API_VERSION=3
export OS_IMAGE_API_VERSION=2
export OS_CACERT=/etc/ssl/certs/oci-pki-oci-ca-chain.pem
",
    })

  if $vip_netmask == 32 {
    $vip_iface = 'lo'
  } else {
    $vip_iface = 'eth0'
  }

  class { 'galera':
    galera_servers      => $all_masters_ip,
    galera_master       => $first_master,
    package_ensure      => 'latest',
    mysql_package_name  => 'mariadb-server',
    client_package_name => 'default-mysql-client',
    vendor_type         => 'mariadb',
    root_password       => 'a_big_secret',
    status_password     => 'a_big_secret',
    configure_repo      => false,
    configure_firewall  => false,
    galera_package_name => 'galera-3',
    override_options => {
      'mysqld' => {
        'bind_address'                    => '0.0.0.0',
        'wait_timeout'                    => '28800',
        'interactive_timeout'             => '30',
        'connect_timeout'                 => '30',
        'character_set_server'            => 'utf8',
        'collation_server'                => 'utf8_general_ci',
      }
    }
  }->
  class { '::keystone::db::mysql':
    dbname   => 'keystonedb',
    password => $pass_keystone_db,
  }
  if $has_subrole_glance {
    class { '::glance::db::mysql':
      dbname   => 'glancedb',
      password => $pass_glance_db,
    }
  }
  if $has_subrole_heat {
    class { '::heat::db::mysql':
      dbname   => 'heatdb',
      password => $pass_heat_db,
    }
  }
  if $has_subrole_barbican {
    class { '::barbican::db::mysql':
      dbname   => 'barbicandb',
      password => $pass_barbican_db,
    }
  }
  if $has_subrole_nova {
    class { '::nova::db::mysql':
      user     => 'nova',
      dbname   => 'novadb',
      password => $pass_nova_db,
    }
    class { '::nova::db::mysql_api':
      user     => 'novaapi',
      dbname   => 'novaapidb',
      password => $pass_nova_apidb,
    }
    class { '::nova::db::mysql_placement':
      user     => 'placement',
      dbname   => 'placementdb',
      password => $pass_placement_db,
    }
  }
  if $has_subrole_neutron {
    class { '::neutron::db::mysql':
      dbname   => 'neutrondb',
      password => $pass_neutron_db,
    }
  }
  if $has_subrole_cinder {
    class { '::cinder::db::mysql':
      dbname        => 'cinderdb',
      password      => $pass_cinder_db,
      allowed_hosts => '%',
    }
  }
}
