//
// The Open Toolkit Library License
//
// Copyright (c) 2006 - 2013 Stefanos Apostolopoulos for the Open Toolkit Library
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights to 
// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
// the Software, and to permit persons to whom the Software is furnished to do
// so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//

using System;

namespace OpenTK.Graphics.OpenGL
{
    /// <summary>
    /// Used in GL.Accum
    /// </summary>
    public enum AccumOp : int
    {
        /// <summary>
        /// Original was GL_ACCUM = 0x0100
        /// </summary>
        Accum = ((int)0x0100)        ,
        /// <summary>
        /// Original was GL_LOAD = 0x0101
        /// </summary>
        Load = ((int)0x0101)        ,
        /// <summary>
        /// Original was GL_RETURN = 0x0102
        /// </summary>
        Return = ((int)0x0102)        ,
        /// <summary>
        /// Original was GL_MULT = 0x0103
        /// </summary>
        Mult = ((int)0x0103)        ,
        /// <summary>
        /// Original was GL_ADD = 0x0104
        /// </summary>
        Add = ((int)0x0104)        ,
    }

    /// <summary>
    /// Used in GL.GetActiveAttrib, GL.GetTransformFeedbackVarying and 1 other function
    /// </summary>
    public enum ActiveAttribType : int
    {
        /// <summary>
        /// Original was GL_NONE = 0
        /// </summary>
        None = ((int)0)        ,
        /// <summary>
        /// Original was GL_INT = 0x1404
        /// </summary>
        Int = ((int)0x1404)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT = 0x1405
        /// </summary>
        UnsignedInt = ((int)0x1405)        ,
        /// <summary>
        /// Original was GL_FLOAT = 0x1406
        /// </summary>
        Float = ((int)0x1406)        ,
        /// <summary>
        /// Original was GL_DOUBLE = 0x140A
        /// </summary>
        Double = ((int)0x140A)        ,
        /// <summary>
        /// Original was GL_FLOAT_VEC2 = 0x8B50
        /// </summary>
        FloatVec2 = ((int)0x8B50)        ,
        /// <summary>
        /// Original was GL_FLOAT_VEC3 = 0x8B51
        /// </summary>
        FloatVec3 = ((int)0x8B51)        ,
        /// <summary>
        /// Original was GL_FLOAT_VEC4 = 0x8B52
        /// </summary>
        FloatVec4 = ((int)0x8B52)        ,
        /// <summary>
        /// Original was GL_INT_VEC2 = 0x8B53
        /// </summary>
        IntVec2 = ((int)0x8B53)        ,
        /// <summary>
        /// Original was GL_INT_VEC3 = 0x8B54
        /// </summary>
        IntVec3 = ((int)0x8B54)        ,
        /// <summary>
        /// Original was GL_INT_VEC4 = 0x8B55
        /// </summary>
        IntVec4 = ((int)0x8B55)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT2 = 0x8B5A
        /// </summary>
        FloatMat2 = ((int)0x8B5A)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT3 = 0x8B5B
        /// </summary>
        FloatMat3 = ((int)0x8B5B)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT4 = 0x8B5C
        /// </summary>
        FloatMat4 = ((int)0x8B5C)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT2x3 = 0x8B65
        /// </summary>
        FloatMat2x3 = ((int)0x8B65)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT2x4 = 0x8B66
        /// </summary>
        FloatMat2x4 = ((int)0x8B66)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT3x2 = 0x8B67
        /// </summary>
        FloatMat3x2 = ((int)0x8B67)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT3x4 = 0x8B68
        /// </summary>
        FloatMat3x4 = ((int)0x8B68)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT4x2 = 0x8B69
        /// </summary>
        FloatMat4x2 = ((int)0x8B69)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT4x3 = 0x8B6A
        /// </summary>
        FloatMat4x3 = ((int)0x8B6A)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_VEC2 = 0x8DC6
        /// </summary>
        UnsignedIntVec2 = ((int)0x8DC6)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_VEC3 = 0x8DC7
        /// </summary>
        UnsignedIntVec3 = ((int)0x8DC7)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_VEC4 = 0x8DC8
        /// </summary>
        UnsignedIntVec4 = ((int)0x8DC8)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT2 = 0x8F46
        /// </summary>
        DoubleMat2 = ((int)0x8F46)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT3 = 0x8F47
        /// </summary>
        DoubleMat3 = ((int)0x8F47)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT4 = 0x8F48
        /// </summary>
        DoubleMat4 = ((int)0x8F48)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT2x3 = 0x8F49
        /// </summary>
        DoubleMat2x3 = ((int)0x8F49)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT2x4 = 0x8F4A
        /// </summary>
        DoubleMat2x4 = ((int)0x8F4A)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT3x2 = 0x8F4B
        /// </summary>
        DoubleMat3x2 = ((int)0x8F4B)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT3x4 = 0x8F4C
        /// </summary>
        DoubleMat3x4 = ((int)0x8F4C)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT4x2 = 0x8F4D
        /// </summary>
        DoubleMat4x2 = ((int)0x8F4D)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT4x3 = 0x8F4E
        /// </summary>
        DoubleMat4x3 = ((int)0x8F4E)        ,
        /// <summary>
        /// Original was GL_DOUBLE_VEC2 = 0x8FFC
        /// </summary>
        DoubleVec2 = ((int)0x8FFC)        ,
        /// <summary>
        /// Original was GL_DOUBLE_VEC3 = 0x8FFD
        /// </summary>
        DoubleVec3 = ((int)0x8FFD)        ,
        /// <summary>
        /// Original was GL_DOUBLE_VEC4 = 0x8FFE
        /// </summary>
        DoubleVec4 = ((int)0x8FFE)        ,
    }

    /// <summary>
    /// Used in GL.GetActiveSubroutineUniform
    /// </summary>
    public enum ActiveSubroutineUniformParameter : int
    {
        /// <summary>
        /// Original was GL_UNIFORM_SIZE = 0x8A38
        /// </summary>
        UniformSize = ((int)0x8A38)        ,
        /// <summary>
        /// Original was GL_UNIFORM_NAME_LENGTH = 0x8A39
        /// </summary>
        UniformNameLength = ((int)0x8A39)        ,
        /// <summary>
        /// Original was GL_NUM_COMPATIBLE_SUBROUTINES = 0x8E4A
        /// </summary>
        NumCompatibleSubroutines = ((int)0x8E4A)        ,
        /// <summary>
        /// Original was GL_COMPATIBLE_SUBROUTINES = 0x8E4B
        /// </summary>
        CompatibleSubroutines = ((int)0x8E4B)        ,
    }

    /// <summary>
    /// Used in GL.GetActiveUniformBlock
    /// </summary>
    public enum ActiveUniformBlockParameter : int
    {
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER = 0x84F0
        /// </summary>
        UniformBlockReferencedByTessControlShader = ((int)0x84F0)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x84F1
        /// </summary>
        UniformBlockReferencedByTessEvaluationShader = ((int)0x84F1)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_BINDING = 0x8A3F
        /// </summary>
        UniformBlockBinding = ((int)0x8A3F)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_DATA_SIZE = 0x8A40
        /// </summary>
        UniformBlockDataSize = ((int)0x8A40)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_NAME_LENGTH = 0x8A41
        /// </summary>
        UniformBlockNameLength = ((int)0x8A41)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS = 0x8A42
        /// </summary>
        UniformBlockActiveUniforms = ((int)0x8A42)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = 0x8A43
        /// </summary>
        UniformBlockActiveUniformIndices = ((int)0x8A43)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = 0x8A44
        /// </summary>
        UniformBlockReferencedByVertexShader = ((int)0x8A44)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER = 0x8A45
        /// </summary>
        UniformBlockReferencedByGeometryShader = ((int)0x8A45)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = 0x8A46
        /// </summary>
        UniformBlockReferencedByFragmentShader = ((int)0x8A46)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER = 0x90EC
        /// </summary>
        UniformBlockReferencedByComputeShader = ((int)0x90EC)        ,
    }

    /// <summary>
    /// Used in GL.GetActiveUniforms
    /// </summary>
    public enum ActiveUniformParameter : int
    {
        /// <summary>
        /// Original was GL_UNIFORM_TYPE = 0x8A37
        /// </summary>
        UniformType = ((int)0x8A37)        ,
        /// <summary>
        /// Original was GL_UNIFORM_SIZE = 0x8A38
        /// </summary>
        UniformSize = ((int)0x8A38)        ,
        /// <summary>
        /// Original was GL_UNIFORM_NAME_LENGTH = 0x8A39
        /// </summary>
        UniformNameLength = ((int)0x8A39)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_INDEX = 0x8A3A
        /// </summary>
        UniformBlockIndex = ((int)0x8A3A)        ,
        /// <summary>
        /// Original was GL_UNIFORM_OFFSET = 0x8A3B
        /// </summary>
        UniformOffset = ((int)0x8A3B)        ,
        /// <summary>
        /// Original was GL_UNIFORM_ARRAY_STRIDE = 0x8A3C
        /// </summary>
        UniformArrayStride = ((int)0x8A3C)        ,
        /// <summary>
        /// Original was GL_UNIFORM_MATRIX_STRIDE = 0x8A3D
        /// </summary>
        UniformMatrixStride = ((int)0x8A3D)        ,
        /// <summary>
        /// Original was GL_UNIFORM_IS_ROW_MAJOR = 0x8A3E
        /// </summary>
        UniformIsRowMajor = ((int)0x8A3E)        ,
        /// <summary>
        /// Original was GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX = 0x92DA
        /// </summary>
        UniformAtomicCounterBufferIndex = ((int)0x92DA)        ,
    }

    /// <summary>
    /// Used in GL.GetActiveUniform
    /// </summary>
    public enum ActiveUniformType : int
    {
        /// <summary>
        /// Original was GL_INT = 0x1404
        /// </summary>
        Int = ((int)0x1404)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT = 0x1405
        /// </summary>
        UnsignedInt = ((int)0x1405)        ,
        /// <summary>
        /// Original was GL_FLOAT = 0x1406
        /// </summary>
        Float = ((int)0x1406)        ,
        /// <summary>
        /// Original was GL_DOUBLE = 0x140A
        /// </summary>
        Double = ((int)0x140A)        ,
        /// <summary>
        /// Original was GL_FLOAT_VEC2 = 0x8B50
        /// </summary>
        FloatVec2 = ((int)0x8B50)        ,
        /// <summary>
        /// Original was GL_FLOAT_VEC3 = 0x8B51
        /// </summary>
        FloatVec3 = ((int)0x8B51)        ,
        /// <summary>
        /// Original was GL_FLOAT_VEC4 = 0x8B52
        /// </summary>
        FloatVec4 = ((int)0x8B52)        ,
        /// <summary>
        /// Original was GL_INT_VEC2 = 0x8B53
        /// </summary>
        IntVec2 = ((int)0x8B53)        ,
        /// <summary>
        /// Original was GL_INT_VEC3 = 0x8B54
        /// </summary>
        IntVec3 = ((int)0x8B54)        ,
        /// <summary>
        /// Original was GL_INT_VEC4 = 0x8B55
        /// </summary>
        IntVec4 = ((int)0x8B55)        ,
        /// <summary>
        /// Original was GL_BOOL = 0x8B56
        /// </summary>
        Bool = ((int)0x8B56)        ,
        /// <summary>
        /// Original was GL_BOOL_VEC2 = 0x8B57
        /// </summary>
        BoolVec2 = ((int)0x8B57)        ,
        /// <summary>
        /// Original was GL_BOOL_VEC3 = 0x8B58
        /// </summary>
        BoolVec3 = ((int)0x8B58)        ,
        /// <summary>
        /// Original was GL_BOOL_VEC4 = 0x8B59
        /// </summary>
        BoolVec4 = ((int)0x8B59)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT2 = 0x8B5A
        /// </summary>
        FloatMat2 = ((int)0x8B5A)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT3 = 0x8B5B
        /// </summary>
        FloatMat3 = ((int)0x8B5B)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT4 = 0x8B5C
        /// </summary>
        FloatMat4 = ((int)0x8B5C)        ,
        /// <summary>
        /// Original was GL_SAMPLER_1D = 0x8B5D
        /// </summary>
        Sampler1D = ((int)0x8B5D)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D = 0x8B5E
        /// </summary>
        Sampler2D = ((int)0x8B5E)        ,
        /// <summary>
        /// Original was GL_SAMPLER_3D = 0x8B5F
        /// </summary>
        Sampler3D = ((int)0x8B5F)        ,
        /// <summary>
        /// Original was GL_SAMPLER_CUBE = 0x8B60
        /// </summary>
        SamplerCube = ((int)0x8B60)        ,
        /// <summary>
        /// Original was GL_SAMPLER_1D_SHADOW = 0x8B61
        /// </summary>
        Sampler1DShadow = ((int)0x8B61)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_SHADOW = 0x8B62
        /// </summary>
        Sampler2DShadow = ((int)0x8B62)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_RECT = 0x8B63
        /// </summary>
        Sampler2DRect = ((int)0x8B63)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_RECT_SHADOW = 0x8B64
        /// </summary>
        Sampler2DRectShadow = ((int)0x8B64)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT2x3 = 0x8B65
        /// </summary>
        FloatMat2x3 = ((int)0x8B65)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT2x4 = 0x8B66
        /// </summary>
        FloatMat2x4 = ((int)0x8B66)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT3x2 = 0x8B67
        /// </summary>
        FloatMat3x2 = ((int)0x8B67)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT3x4 = 0x8B68
        /// </summary>
        FloatMat3x4 = ((int)0x8B68)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT4x2 = 0x8B69
        /// </summary>
        FloatMat4x2 = ((int)0x8B69)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT4x3 = 0x8B6A
        /// </summary>
        FloatMat4x3 = ((int)0x8B6A)        ,
        /// <summary>
        /// Original was GL_SAMPLER_1D_ARRAY = 0x8DC0
        /// </summary>
        Sampler1DArray = ((int)0x8DC0)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_ARRAY = 0x8DC1
        /// </summary>
        Sampler2DArray = ((int)0x8DC1)        ,
        /// <summary>
        /// Original was GL_SAMPLER_BUFFER = 0x8DC2
        /// </summary>
        SamplerBuffer = ((int)0x8DC2)        ,
        /// <summary>
        /// Original was GL_SAMPLER_1D_ARRAY_SHADOW = 0x8DC3
        /// </summary>
        Sampler1DArrayShadow = ((int)0x8DC3)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_ARRAY_SHADOW = 0x8DC4
        /// </summary>
        Sampler2DArrayShadow = ((int)0x8DC4)        ,
        /// <summary>
        /// Original was GL_SAMPLER_CUBE_SHADOW = 0x8DC5
        /// </summary>
        SamplerCubeShadow = ((int)0x8DC5)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_VEC2 = 0x8DC6
        /// </summary>
        UnsignedIntVec2 = ((int)0x8DC6)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_VEC3 = 0x8DC7
        /// </summary>
        UnsignedIntVec3 = ((int)0x8DC7)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_VEC4 = 0x8DC8
        /// </summary>
        UnsignedIntVec4 = ((int)0x8DC8)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_1D = 0x8DC9
        /// </summary>
        IntSampler1D = ((int)0x8DC9)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_2D = 0x8DCA
        /// </summary>
        IntSampler2D = ((int)0x8DCA)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_3D = 0x8DCB
        /// </summary>
        IntSampler3D = ((int)0x8DCB)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_CUBE = 0x8DCC
        /// </summary>
        IntSamplerCube = ((int)0x8DCC)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_2D_RECT = 0x8DCD
        /// </summary>
        IntSampler2DRect = ((int)0x8DCD)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_1D_ARRAY = 0x8DCE
        /// </summary>
        IntSampler1DArray = ((int)0x8DCE)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_2D_ARRAY = 0x8DCF
        /// </summary>
        IntSampler2DArray = ((int)0x8DCF)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_BUFFER = 0x8DD0
        /// </summary>
        IntSamplerBuffer = ((int)0x8DD0)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_1D = 0x8DD1
        /// </summary>
        UnsignedIntSampler1D = ((int)0x8DD1)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_2D = 0x8DD2
        /// </summary>
        UnsignedIntSampler2D = ((int)0x8DD2)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_3D = 0x8DD3
        /// </summary>
        UnsignedIntSampler3D = ((int)0x8DD3)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_CUBE = 0x8DD4
        /// </summary>
        UnsignedIntSamplerCube = ((int)0x8DD4)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_2D_RECT = 0x8DD5
        /// </summary>
        UnsignedIntSampler2DRect = ((int)0x8DD5)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_1D_ARRAY = 0x8DD6
        /// </summary>
        UnsignedIntSampler1DArray = ((int)0x8DD6)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_2D_ARRAY = 0x8DD7
        /// </summary>
        UnsignedIntSampler2DArray = ((int)0x8DD7)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_BUFFER = 0x8DD8
        /// </summary>
        UnsignedIntSamplerBuffer = ((int)0x8DD8)        ,
        /// <summary>
        /// Original was GL_DOUBLE_VEC2 = 0x8FFC
        /// </summary>
        DoubleVec2 = ((int)0x8FFC)        ,
        /// <summary>
        /// Original was GL_DOUBLE_VEC3 = 0x8FFD
        /// </summary>
        DoubleVec3 = ((int)0x8FFD)        ,
        /// <summary>
        /// Original was GL_DOUBLE_VEC4 = 0x8FFE
        /// </summary>
        DoubleVec4 = ((int)0x8FFE)        ,
        /// <summary>
        /// Original was GL_SAMPLER_CUBE_MAP_ARRAY = 0x900C
        /// </summary>
        SamplerCubeMapArray = ((int)0x900C)        ,
        /// <summary>
        /// Original was GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW = 0x900D
        /// </summary>
        SamplerCubeMapArrayShadow = ((int)0x900D)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_CUBE_MAP_ARRAY = 0x900E
        /// </summary>
        IntSamplerCubeMapArray = ((int)0x900E)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY = 0x900F
        /// </summary>
        UnsignedIntSamplerCubeMapArray = ((int)0x900F)        ,
        /// <summary>
        /// Original was GL_IMAGE_1D = 0x904C
        /// </summary>
        Image1D = ((int)0x904C)        ,
        /// <summary>
        /// Original was GL_IMAGE_2D = 0x904D
        /// </summary>
        Image2D = ((int)0x904D)        ,
        /// <summary>
        /// Original was GL_IMAGE_3D = 0x904E
        /// </summary>
        Image3D = ((int)0x904E)        ,
        /// <summary>
        /// Original was GL_IMAGE_2D_RECT = 0x904F
        /// </summary>
        Image2DRect = ((int)0x904F)        ,
        /// <summary>
        /// Original was GL_IMAGE_CUBE = 0x9050
        /// </summary>
        ImageCube = ((int)0x9050)        ,
        /// <summary>
        /// Original was GL_IMAGE_BUFFER = 0x9051
        /// </summary>
        ImageBuffer = ((int)0x9051)        ,
        /// <summary>
        /// Original was GL_IMAGE_1D_ARRAY = 0x9052
        /// </summary>
        Image1DArray = ((int)0x9052)        ,
        /// <summary>
        /// Original was GL_IMAGE_2D_ARRAY = 0x9053
        /// </summary>
        Image2DArray = ((int)0x9053)        ,
        /// <summary>
        /// Original was GL_IMAGE_CUBE_MAP_ARRAY = 0x9054
        /// </summary>
        ImageCubeMapArray = ((int)0x9054)        ,
        /// <summary>
        /// Original was GL_IMAGE_2D_MULTISAMPLE = 0x9055
        /// </summary>
        Image2DMultisample = ((int)0x9055)        ,
        /// <summary>
        /// Original was GL_IMAGE_2D_MULTISAMPLE_ARRAY = 0x9056
        /// </summary>
        Image2DMultisampleArray = ((int)0x9056)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_1D = 0x9057
        /// </summary>
        IntImage1D = ((int)0x9057)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_2D = 0x9058
        /// </summary>
        IntImage2D = ((int)0x9058)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_3D = 0x9059
        /// </summary>
        IntImage3D = ((int)0x9059)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_2D_RECT = 0x905A
        /// </summary>
        IntImage2DRect = ((int)0x905A)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_CUBE = 0x905B
        /// </summary>
        IntImageCube = ((int)0x905B)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_BUFFER = 0x905C
        /// </summary>
        IntImageBuffer = ((int)0x905C)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_1D_ARRAY = 0x905D
        /// </summary>
        IntImage1DArray = ((int)0x905D)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_2D_ARRAY = 0x905E
        /// </summary>
        IntImage2DArray = ((int)0x905E)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_CUBE_MAP_ARRAY = 0x905F
        /// </summary>
        IntImageCubeMapArray = ((int)0x905F)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_2D_MULTISAMPLE = 0x9060
        /// </summary>
        IntImage2DMultisample = ((int)0x9060)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY = 0x9061
        /// </summary>
        IntImage2DMultisampleArray = ((int)0x9061)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_1D = 0x9062
        /// </summary>
        UnsignedIntImage1D = ((int)0x9062)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_2D = 0x9063
        /// </summary>
        UnsignedIntImage2D = ((int)0x9063)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_3D = 0x9064
        /// </summary>
        UnsignedIntImage3D = ((int)0x9064)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_2D_RECT = 0x9065
        /// </summary>
        UnsignedIntImage2DRect = ((int)0x9065)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_CUBE = 0x9066
        /// </summary>
        UnsignedIntImageCube = ((int)0x9066)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_BUFFER = 0x9067
        /// </summary>
        UnsignedIntImageBuffer = ((int)0x9067)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_1D_ARRAY = 0x9068
        /// </summary>
        UnsignedIntImage1DArray = ((int)0x9068)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_2D_ARRAY = 0x9069
        /// </summary>
        UnsignedIntImage2DArray = ((int)0x9069)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY = 0x906A
        /// </summary>
        UnsignedIntImageCubeMapArray = ((int)0x906A)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE = 0x906B
        /// </summary>
        UnsignedIntImage2DMultisample = ((int)0x906B)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY = 0x906C
        /// </summary>
        UnsignedIntImage2DMultisampleArray = ((int)0x906C)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_MULTISAMPLE = 0x9108
        /// </summary>
        Sampler2DMultisample = ((int)0x9108)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_2D_MULTISAMPLE = 0x9109
        /// </summary>
        IntSampler2DMultisample = ((int)0x9109)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = 0x910A
        /// </summary>
        UnsignedIntSampler2DMultisample = ((int)0x910A)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910B
        /// </summary>
        Sampler2DMultisampleArray = ((int)0x910B)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910C
        /// </summary>
        IntSampler2DMultisampleArray = ((int)0x910C)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910D
        /// </summary>
        UnsignedIntSampler2DMultisampleArray = ((int)0x910D)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_ATOMIC_COUNTER = 0x92DB
        /// </summary>
        UnsignedIntAtomicCounter = ((int)0x92DB)        ,
    }

    /// <summary>
    /// Used in GL.Arb.GetProgramEnvParameter, GL.Arb.GetProgramLocalParameter and 9 other functions
    /// </summary>
    public enum All : int
    {
        /// <summary>
        /// Original was GL_FALSE = 0
        /// </summary>
        False = ((int)0)        ,
        /// <summary>
        /// Original was GL_LAYOUT_DEFAULT_INTEL = 0
        /// </summary>
        LayoutDefaultIntel = ((int)0)        ,
        /// <summary>
        /// Original was GL_NO_ERROR = 0
        /// </summary>
        NoError = ((int)0)        ,
        /// <summary>
        /// Original was GL_NONE = 0
        /// </summary>
        None = ((int)0)        ,
        /// <summary>
        /// Original was GL_NONE_OES = 0
        /// </summary>
        NoneOes = ((int)0)        ,
        /// <summary>
        /// Original was GL_ZERO = 0
        /// </summary>
        Zero = ((int)0)        ,
        /// <summary>
        /// Original was GL_CLOSE_PATH_NV = 0x00
        /// </summary>
        ClosePathNv = ((int)0x00)        ,
        /// <summary>
        /// Original was GL_Points = 0x0000
        /// </summary>
        Points = ((int)0x0000)        ,
        /// <summary>
        /// Original was GL_PERFQUERY_SINGLE_CONTEXT_INTEL = 0x00000000
        /// </summary>
        PerfquerySingleContextIntel = ((int)0x00000000)        ,
        /// <summary>
        /// Original was GL_CLIENT_PIXEL_STORE_BIT = 0x00000001
        /// </summary>
        ClientPixelStoreBit = ((int)0x00000001)        ,
        /// <summary>
        /// Original was GL_CONTEXT_CORE_PROFILE_BIT = 0x00000001
        /// </summary>
        ContextCoreProfileBit = ((int)0x00000001)        ,
        /// <summary>
        /// Original was GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT = 0x00000001
        /// </summary>
        ContextFlagForwardCompatibleBit = ((int)0x00000001)        ,
        /// <summary>
        /// Original was GL_CURRENT_BIT = 0x00000001
        /// </summary>
        CurrentBit = ((int)0x00000001)        ,
        /// <summary>
        /// Original was GL_2X_BIT_ATI = 0x00000001
        /// </summary>
        Gl2XBitAti = ((int)0x00000001)        ,
        /// <summary>
        /// Original was GL_PERFQUERY_GLOBAL_CONTEXT_INTEL = 0x00000001
        /// </summary>
        PerfqueryGlobalContextIntel = ((int)0x00000001)        ,
        /// <summary>
        /// Original was GL_QUERY_DEPTH_PASS_EVENT_BIT_AMD = 0x00000001
        /// </summary>
        QueryDepthPassEventBitAmd = ((int)0x00000001)        ,
        /// <summary>
        /// Original was GL_RED_BIT_ATI = 0x00000001
        /// </summary>
        RedBitAti = ((int)0x00000001)        ,
        /// <summary>
        /// Original was GL_SYNC_FLUSH_COMMANDS_BIT = 0x00000001
        /// </summary>
        SyncFlushCommandsBit = ((int)0x00000001)        ,
        /// <summary>
        /// Original was GL_TEXTURE_DEFORMATION_BIT_SGIX = 0x00000001
        /// </summary>
        TextureDeformationBitSgix = ((int)0x00000001)        ,
        /// <summary>
        /// Original was GL_TEXTURE_STORAGE_SPARSE_BIT_AMD = 0x00000001
        /// </summary>
        TextureStorageSparseBitAmd = ((int)0x00000001)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT = 0x00000001
        /// </summary>
        VertexAttribArrayBarrierBit = ((int)0x00000001)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT_EXT = 0x00000001
        /// </summary>
        VertexAttribArrayBarrierBitExt = ((int)0x00000001)        ,
        /// <summary>
        /// Original was GL_VERTEX_SHADER_BIT = 0x00000001
        /// </summary>
        VertexShaderBit = ((int)0x00000001)        ,
        /// <summary>
        /// Original was GL_VERTEX_SHADER_BIT_EXT = 0x00000001
        /// </summary>
        VertexShaderBitExt = ((int)0x00000001)        ,
        /// <summary>
        /// Original was GL_CLIENT_VERTEX_ARRAY_BIT = 0x00000002
        /// </summary>
        ClientVertexArrayBit = ((int)0x00000002)        ,
        /// <summary>
        /// Original was GL_COMP_BIT_ATI = 0x00000002
        /// </summary>
        CompBitAti = ((int)0x00000002)        ,
        /// <summary>
        /// Original was GL_CONTEXT_COMPATIBILITY_PROFILE_BIT = 0x00000002
        /// </summary>
        ContextCompatibilityProfileBit = ((int)0x00000002)        ,
        /// <summary>
        /// Original was GL_CONTEXT_FLAG_DEBUG_BIT = 0x00000002
        /// </summary>
        ContextFlagDebugBit = ((int)0x00000002)        ,
        /// <summary>
        /// Original was GL_CONTEXT_FLAG_DEBUG_BIT_KHR = 0x00000002
        /// </summary>
        ContextFlagDebugBitKhr = ((int)0x00000002)        ,
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_BARRIER_BIT = 0x00000002
        /// </summary>
        ElementArrayBarrierBit = ((int)0x00000002)        ,
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_BARRIER_BIT_EXT = 0x00000002
        /// </summary>
        ElementArrayBarrierBitExt = ((int)0x00000002)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_SHADER_BIT = 0x00000002
        /// </summary>
        FragmentShaderBit = ((int)0x00000002)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_SHADER_BIT_EXT = 0x00000002
        /// </summary>
        FragmentShaderBitExt = ((int)0x00000002)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_DEFORMATION_BIT_SGIX = 0x00000002
        /// </summary>
        GeometryDeformationBitSgix = ((int)0x00000002)        ,
        /// <summary>
        /// Original was GL_4X_BIT_ATI = 0x00000002
        /// </summary>
        Gl4XBitAti = ((int)0x00000002)        ,
        /// <summary>
        /// Original was GL_GREEN_BIT_ATI = 0x00000002
        /// </summary>
        GreenBitAti = ((int)0x00000002)        ,
        /// <summary>
        /// Original was GL_POINT_BIT = 0x00000002
        /// </summary>
        PointBit = ((int)0x00000002)        ,
        /// <summary>
        /// Original was GL_QUERY_DEPTH_FAIL_EVENT_BIT_AMD = 0x00000002
        /// </summary>
        QueryDepthFailEventBitAmd = ((int)0x00000002)        ,
        /// <summary>
        /// Original was GL_BLUE_BIT_ATI = 0x00000004
        /// </summary>
        BlueBitAti = ((int)0x00000004)        ,
        /// <summary>
        /// Original was GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB = 0x00000004
        /// </summary>
        ContextFlagRobustAccessBitArb = ((int)0x00000004)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_SHADER_BIT = 0x00000004
        /// </summary>
        GeometryShaderBit = ((int)0x00000004)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_SHADER_BIT_EXT = 0x00000004
        /// </summary>
        GeometryShaderBitExt = ((int)0x00000004)        ,
        /// <summary>
        /// Original was GL_8X_BIT_ATI = 0x00000004
        /// </summary>
        Gl8XBitAti = ((int)0x00000004)        ,
        /// <summary>
        /// Original was GL_LINE_BIT = 0x00000004
        /// </summary>
        LineBit = ((int)0x00000004)        ,
        /// <summary>
        /// Original was GL_NEGATE_BIT_ATI = 0x00000004
        /// </summary>
        NegateBitAti = ((int)0x00000004)        ,
        /// <summary>
        /// Original was GL_QUERY_STENCIL_FAIL_EVENT_BIT_AMD = 0x00000004
        /// </summary>
        QueryStencilFailEventBitAmd = ((int)0x00000004)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BARRIER_BIT = 0x00000004
        /// </summary>
        UniformBarrierBit = ((int)0x00000004)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BARRIER_BIT_EXT = 0x00000004
        /// </summary>
        UniformBarrierBitExt = ((int)0x00000004)        ,
        /// <summary>
        /// Original was GL_VERTEX23_BIT_PGI = 0x00000004
        /// </summary>
        Vertex23BitPgi = ((int)0x00000004)        ,
        /// <summary>
        /// Original was GL_BIAS_BIT_ATI = 0x00000008
        /// </summary>
        BiasBitAti = ((int)0x00000008)        ,
        /// <summary>
        /// Original was GL_HALF_BIT_ATI = 0x00000008
        /// </summary>
        HalfBitAti = ((int)0x00000008)        ,
        /// <summary>
        /// Original was GL_POLYGON_BIT = 0x00000008
        /// </summary>
        PolygonBit = ((int)0x00000008)        ,
        /// <summary>
        /// Original was GL_QUERY_DEPTH_BOUNDS_FAIL_EVENT_BIT_AMD = 0x00000008
        /// </summary>
        QueryDepthBoundsFailEventBitAmd = ((int)0x00000008)        ,
        /// <summary>
        /// Original was GL_TESS_CONTROL_SHADER_BIT = 0x00000008
        /// </summary>
        TessControlShaderBit = ((int)0x00000008)        ,
        /// <summary>
        /// Original was GL_TESS_CONTROL_SHADER_BIT_EXT = 0x00000008
        /// </summary>
        TessControlShaderBitExt = ((int)0x00000008)        ,
        /// <summary>
        /// Original was GL_TEXTURE_FETCH_BARRIER_BIT = 0x00000008
        /// </summary>
        TextureFetchBarrierBit = ((int)0x00000008)        ,
        /// <summary>
        /// Original was GL_TEXTURE_FETCH_BARRIER_BIT_EXT = 0x00000008
        /// </summary>
        TextureFetchBarrierBitExt = ((int)0x00000008)        ,
        /// <summary>
        /// Original was GL_VERTEX4_BIT_PGI = 0x00000008
        /// </summary>
        Vertex4BitPgi = ((int)0x00000008)        ,
        /// <summary>
        /// Original was GL_POLYGON_STIPPLE_BIT = 0x00000010
        /// </summary>
        PolygonStippleBit = ((int)0x00000010)        ,
        /// <summary>
        /// Original was GL_QUARTER_BIT_ATI = 0x00000010
        /// </summary>
        QuarterBitAti = ((int)0x00000010)        ,
        /// <summary>
        /// Original was GL_SHADER_GLOBAL_ACCESS_BARRIER_BIT_NV = 0x00000010
        /// </summary>
        ShaderGlobalAccessBarrierBitNv = ((int)0x00000010)        ,
        /// <summary>
        /// Original was GL_TESS_EVALUATION_SHADER_BIT = 0x00000010
        /// </summary>
        TessEvaluationShaderBit = ((int)0x00000010)        ,
        /// <summary>
        /// Original was GL_TESS_EVALUATION_SHADER_BIT_EXT = 0x00000010
        /// </summary>
        TessEvaluationShaderBitExt = ((int)0x00000010)        ,
        /// <summary>
        /// Original was GL_COMPUTE_SHADER_BIT = 0x00000020
        /// </summary>
        ComputeShaderBit = ((int)0x00000020)        ,
        /// <summary>
        /// Original was GL_EIGHTH_BIT_ATI = 0x00000020
        /// </summary>
        EighthBitAti = ((int)0x00000020)        ,
        /// <summary>
        /// Original was GL_PIXEL_MODE_BIT = 0x00000020
        /// </summary>
        PixelModeBit = ((int)0x00000020)        ,
        /// <summary>
        /// Original was GL_SHADER_IMAGE_ACCESS_BARRIER_BIT = 0x00000020
        /// </summary>
        ShaderImageAccessBarrierBit = ((int)0x00000020)        ,
        /// <summary>
        /// Original was GL_SHADER_IMAGE_ACCESS_BARRIER_BIT_EXT = 0x00000020
        /// </summary>
        ShaderImageAccessBarrierBitExt = ((int)0x00000020)        ,
        /// <summary>
        /// Original was GL_COMMAND_BARRIER_BIT = 0x00000040
        /// </summary>
        CommandBarrierBit = ((int)0x00000040)        ,
        /// <summary>
        /// Original was GL_COMMAND_BARRIER_BIT_EXT = 0x00000040
        /// </summary>
        CommandBarrierBitExt = ((int)0x00000040)        ,
        /// <summary>
        /// Original was GL_LIGHTING_BIT = 0x00000040
        /// </summary>
        LightingBit = ((int)0x00000040)        ,
        /// <summary>
        /// Original was GL_SATURATE_BIT_ATI = 0x00000040
        /// </summary>
        SaturateBitAti = ((int)0x00000040)        ,
        /// <summary>
        /// Original was GL_FOG_BIT = 0x00000080
        /// </summary>
        FogBit = ((int)0x00000080)        ,
        /// <summary>
        /// Original was GL_PIXEL_BUFFER_BARRIER_BIT = 0x00000080
        /// </summary>
        PixelBufferBarrierBit = ((int)0x00000080)        ,
        /// <summary>
        /// Original was GL_PIXEL_BUFFER_BARRIER_BIT_EXT = 0x00000080
        /// </summary>
        PixelBufferBarrierBitExt = ((int)0x00000080)        ,
        /// <summary>
        /// Original was GL_DEPTH_BUFFER_BIT = 0x00000100
        /// </summary>
        DepthBufferBit = ((int)0x00000100)        ,
        /// <summary>
        /// Original was GL_TEXTURE_UPDATE_BARRIER_BIT = 0x00000100
        /// </summary>
        TextureUpdateBarrierBit = ((int)0x00000100)        ,
        /// <summary>
        /// Original was GL_TEXTURE_UPDATE_BARRIER_BIT_EXT = 0x00000100
        /// </summary>
        TextureUpdateBarrierBitExt = ((int)0x00000100)        ,
        /// <summary>
        /// Original was GL_ACCUM_BUFFER_BIT = 0x00000200
        /// </summary>
        AccumBufferBit = ((int)0x00000200)        ,
        /// <summary>
        /// Original was GL_BUFFER_UPDATE_BARRIER_BIT = 0x00000200
        /// </summary>
        BufferUpdateBarrierBit = ((int)0x00000200)        ,
        /// <summary>
        /// Original was GL_BUFFER_UPDATE_BARRIER_BIT_EXT = 0x00000200
        /// </summary>
        BufferUpdateBarrierBitExt = ((int)0x00000200)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_BARRIER_BIT = 0x00000400
        /// </summary>
        FramebufferBarrierBit = ((int)0x00000400)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_BARRIER_BIT_EXT = 0x00000400
        /// </summary>
        FramebufferBarrierBitExt = ((int)0x00000400)        ,
        /// <summary>
        /// Original was GL_STENCIL_BUFFER_BIT = 0x00000400
        /// </summary>
        StencilBufferBit = ((int)0x00000400)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BARRIER_BIT = 0x00000800
        /// </summary>
        TransformFeedbackBarrierBit = ((int)0x00000800)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BARRIER_BIT_EXT = 0x00000800
        /// </summary>
        TransformFeedbackBarrierBitExt = ((int)0x00000800)        ,
        /// <summary>
        /// Original was GL_VIEWPORT_BIT = 0x00000800
        /// </summary>
        ViewportBit = ((int)0x00000800)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BARRIER_BIT = 0x00001000
        /// </summary>
        AtomicCounterBarrierBit = ((int)0x00001000)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BARRIER_BIT_EXT = 0x00001000
        /// </summary>
        AtomicCounterBarrierBitExt = ((int)0x00001000)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_BIT = 0x00001000
        /// </summary>
        TransformBit = ((int)0x00001000)        ,
        /// <summary>
        /// Original was GL_ENABLE_BIT = 0x00002000
        /// </summary>
        EnableBit = ((int)0x00002000)        ,
        /// <summary>
        /// Original was GL_SHADER_STORAGE_BARRIER_BIT = 0x00002000
        /// </summary>
        ShaderStorageBarrierBit = ((int)0x00002000)        ,
        /// <summary>
        /// Original was GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT = 0x00004000
        /// </summary>
        ClientMappedBufferBarrierBit = ((int)0x00004000)        ,
        /// <summary>
        /// Original was GL_COLOR_BUFFER_BIT = 0x00004000
        /// </summary>
        ColorBufferBit = ((int)0x00004000)        ,
        /// <summary>
        /// Original was GL_COVERAGE_BUFFER_BIT_NV = 0x00008000
        /// </summary>
        CoverageBufferBitNv = ((int)0x00008000)        ,
        /// <summary>
        /// Original was GL_HINT_BIT = 0x00008000
        /// </summary>
        HintBit = ((int)0x00008000)        ,
        /// <summary>
        /// Original was GL_QUERY_BUFFER_BARRIER_BIT = 0x00008000
        /// </summary>
        QueryBufferBarrierBit = ((int)0x00008000)        ,
        /// <summary>
        /// Original was GL_Lines = 0x0001
        /// </summary>
        Lines = ((int)0x0001)        ,
        /// <summary>
        /// Original was GL_MAP_READ_BIT = 0x0001
        /// </summary>
        MapReadBit = ((int)0x0001)        ,
        /// <summary>
        /// Original was GL_MAP_READ_BIT_EXT = 0x0001
        /// </summary>
        MapReadBitExt = ((int)0x0001)        ,
        /// <summary>
        /// Original was GL_RESTART_SUN = 0x0001
        /// </summary>
        RestartSun = ((int)0x0001)        ,
        /// <summary>
        /// Original was GL_COLOR3_BIT_PGI = 0x00010000
        /// </summary>
        Color3BitPgi = ((int)0x00010000)        ,
        /// <summary>
        /// Original was GL_EVAL_BIT = 0x00010000
        /// </summary>
        EvalBit = ((int)0x00010000)        ,
        /// <summary>
        /// Original was GL_FONT_X_MIN_BOUNDS_BIT_NV = 0x00010000
        /// </summary>
        FontXMinBoundsBitNv = ((int)0x00010000)        ,
        /// <summary>
        /// Original was GL_LINE_LOOP = 0x0002
        /// </summary>
        LineLoop = ((int)0x0002)        ,
        /// <summary>
        /// Original was GL_MAP_WRITE_BIT = 0x0002
        /// </summary>
        MapWriteBit = ((int)0x0002)        ,
        /// <summary>
        /// Original was GL_MAP_WRITE_BIT_EXT = 0x0002
        /// </summary>
        MapWriteBitExt = ((int)0x0002)        ,
        /// <summary>
        /// Original was GL_REPLACE_MIDDLE_SUN = 0x0002
        /// </summary>
        ReplaceMiddleSun = ((int)0x0002)        ,
        /// <summary>
        /// Original was GL_COLOR4_BIT_PGI = 0x00020000
        /// </summary>
        Color4BitPgi = ((int)0x00020000)        ,
        /// <summary>
        /// Original was GL_FONT_Y_MIN_BOUNDS_BIT_NV = 0x00020000
        /// </summary>
        FontYMinBoundsBitNv = ((int)0x00020000)        ,
        /// <summary>
        /// Original was GL_LIST_BIT = 0x00020000
        /// </summary>
        ListBit = ((int)0x00020000)        ,
        /// <summary>
        /// Original was GL_LINE_STRIP = 0x0003
        /// </summary>
        LineStrip = ((int)0x0003)        ,
        /// <summary>
        /// Original was GL_REPLACE_OLDEST_SUN = 0x0003
        /// </summary>
        ReplaceOldestSun = ((int)0x0003)        ,
        /// <summary>
        /// Original was GL_MAP_INVALIDATE_RANGE_BIT = 0x0004
        /// </summary>
        MapInvalidateRangeBit = ((int)0x0004)        ,
        /// <summary>
        /// Original was GL_MAP_INVALIDATE_RANGE_BIT_EXT = 0x0004
        /// </summary>
        MapInvalidateRangeBitExt = ((int)0x0004)        ,
        /// <summary>
        /// Original was GL_Triangles = 0x0004
        /// </summary>
        Triangles = ((int)0x0004)        ,
        /// <summary>
        /// Original was GL_EDGEFLAG_BIT_PGI = 0x00040000
        /// </summary>
        EdgeflagBitPgi = ((int)0x00040000)        ,
        /// <summary>
        /// Original was GL_FONT_X_MAX_BOUNDS_BIT_NV = 0x00040000
        /// </summary>
        FontXMaxBoundsBitNv = ((int)0x00040000)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BIT = 0x00040000
        /// </summary>
        TextureBit = ((int)0x00040000)        ,
        /// <summary>
        /// Original was GL_TRIANGLE_STRIP = 0x0005
        /// </summary>
        TriangleStrip = ((int)0x0005)        ,
        /// <summary>
        /// Original was GL_TRIANGLE_FAN = 0x0006
        /// </summary>
        TriangleFan = ((int)0x0006)        ,
        /// <summary>
        /// Original was GL_QUADS = 0x0007
        /// </summary>
        Quads = ((int)0x0007)        ,
        /// <summary>
        /// Original was GL_QUADS_EXT = 0x0007
        /// </summary>
        QuadsExt = ((int)0x0007)        ,
        /// <summary>
        /// Original was GL_MAP_INVALIDATE_BUFFER_BIT = 0x0008
        /// </summary>
        MapInvalidateBufferBit = ((int)0x0008)        ,
        /// <summary>
        /// Original was GL_MAP_INVALIDATE_BUFFER_BIT_EXT = 0x0008
        /// </summary>
        MapInvalidateBufferBitExt = ((int)0x0008)        ,
        /// <summary>
        /// Original was GL_QUAD_STRIP = 0x0008
        /// </summary>
        QuadStrip = ((int)0x0008)        ,
        /// <summary>
        /// Original was GL_FONT_Y_MAX_BOUNDS_BIT_NV = 0x00080000
        /// </summary>
        FontYMaxBoundsBitNv = ((int)0x00080000)        ,
        /// <summary>
        /// Original was GL_INDEX_BIT_PGI = 0x00080000
        /// </summary>
        IndexBitPgi = ((int)0x00080000)        ,
        /// <summary>
        /// Original was GL_SCISSOR_BIT = 0x00080000
        /// </summary>
        ScissorBit = ((int)0x00080000)        ,
        /// <summary>
        /// Original was GL_POLYGON = 0x0009
        /// </summary>
        Polygon = ((int)0x0009)        ,
        /// <summary>
        /// Original was GL_LINES_ADJACENCY = 0x000A
        /// </summary>
        LinesAdjacency = ((int)0x000A)        ,
        /// <summary>
        /// Original was GL_LINES_ADJACENCY_ARB = 0x000A
        /// </summary>
        LinesAdjacencyArb = ((int)0x000A)        ,
        /// <summary>
        /// Original was GL_LINES_ADJACENCY_EXT = 0x000A
        /// </summary>
        LinesAdjacencyExt = ((int)0x000A)        ,
        /// <summary>
        /// Original was GL_LINE_STRIP_ADJACENCY = 0x000B
        /// </summary>
        LineStripAdjacency = ((int)0x000B)        ,
        /// <summary>
        /// Original was GL_LINE_STRIP_ADJACENCY_ARB = 0x000B
        /// </summary>
        LineStripAdjacencyArb = ((int)0x000B)        ,
        /// <summary>
        /// Original was GL_LINE_STRIP_ADJACENCY_EXT = 0x000B
        /// </summary>
        LineStripAdjacencyExt = ((int)0x000B)        ,
        /// <summary>
        /// Original was GL_TRIANGLES_ADJACENCY = 0x000C
        /// </summary>
        TrianglesAdjacency = ((int)0x000C)        ,
        /// <summary>
        /// Original was GL_TRIANGLES_ADJACENCY_ARB = 0x000C
        /// </summary>
        TrianglesAdjacencyArb = ((int)0x000C)        ,
        /// <summary>
        /// Original was GL_TRIANGLES_ADJACENCY_EXT = 0x000C
        /// </summary>
        TrianglesAdjacencyExt = ((int)0x000C)        ,
        /// <summary>
        /// Original was GL_TRIANGLE_STRIP_ADJACENCY = 0x000D
        /// </summary>
        TriangleStripAdjacency = ((int)0x000D)        ,
        /// <summary>
        /// Original was GL_TRIANGLE_STRIP_ADJACENCY_ARB = 0x000D
        /// </summary>
        TriangleStripAdjacencyArb = ((int)0x000D)        ,
        /// <summary>
        /// Original was GL_TRIANGLE_STRIP_ADJACENCY_EXT = 0x000D
        /// </summary>
        TriangleStripAdjacencyExt = ((int)0x000D)        ,
        /// <summary>
        /// Original was GL_PATCHES = 0x000E
        /// </summary>
        Patches = ((int)0x000E)        ,
        /// <summary>
        /// Original was GL_PATCHES_EXT = 0x000E
        /// </summary>
        PatchesExt = ((int)0x000E)        ,
        /// <summary>
        /// Original was GL_MAP_FLUSH_EXPLICIT_BIT = 0x0010
        /// </summary>
        MapFlushExplicitBit = ((int)0x0010)        ,
        /// <summary>
        /// Original was GL_MAP_FLUSH_EXPLICIT_BIT_EXT = 0x0010
        /// </summary>
        MapFlushExplicitBitExt = ((int)0x0010)        ,
        /// <summary>
        /// Original was GL_FONT_UNITS_PER_EM_BIT_NV = 0x00100000
        /// </summary>
        FontUnitsPerEmBitNv = ((int)0x00100000)        ,
        /// <summary>
        /// Original was GL_MAT_AMBIENT_BIT_PGI = 0x00100000
        /// </summary>
        MatAmbientBitPgi = ((int)0x00100000)        ,
        /// <summary>
        /// Original was GL_MAP_UNSYNCHRONIZED_BIT = 0x0020
        /// </summary>
        MapUnsynchronizedBit = ((int)0x0020)        ,
        /// <summary>
        /// Original was GL_MAP_UNSYNCHRONIZED_BIT_EXT = 0x0020
        /// </summary>
        MapUnsynchronizedBitExt = ((int)0x0020)        ,
        /// <summary>
        /// Original was GL_FONT_ASCENDER_BIT_NV = 0x00200000
        /// </summary>
        FontAscenderBitNv = ((int)0x00200000)        ,
        /// <summary>
        /// Original was GL_MAT_AMBIENT_AND_DIFFUSE_BIT_PGI = 0x00200000
        /// </summary>
        MatAmbientAndDiffuseBitPgi = ((int)0x00200000)        ,
        /// <summary>
        /// Original was GL_MAP_PERSISTENT_BIT = 0x0040
        /// </summary>
        MapPersistentBit = ((int)0x0040)        ,
        /// <summary>
        /// Original was GL_FONT_DESCENDER_BIT_NV = 0x00400000
        /// </summary>
        FontDescenderBitNv = ((int)0x00400000)        ,
        /// <summary>
        /// Original was GL_MAT_DIFFUSE_BIT_PGI = 0x00400000
        /// </summary>
        MatDiffuseBitPgi = ((int)0x00400000)        ,
        /// <summary>
        /// Original was GL_MAP_COHERENT_BIT = 0x0080
        /// </summary>
        MapCoherentBit = ((int)0x0080)        ,
        /// <summary>
        /// Original was GL_FONT_HEIGHT_BIT_NV = 0x00800000
        /// </summary>
        FontHeightBitNv = ((int)0x00800000)        ,
        /// <summary>
        /// Original was GL_MAT_EMISSION_BIT_PGI = 0x00800000
        /// </summary>
        MatEmissionBitPgi = ((int)0x00800000)        ,
        /// <summary>
        /// Original was GL_BOLD_BIT_NV = 0x01
        /// </summary>
        BoldBitNv = ((int)0x01)        ,
        /// <summary>
        /// Original was GL_GLYPH_WIDTH_BIT_NV = 0x01
        /// </summary>
        GlyphWidthBitNv = ((int)0x01)        ,
        /// <summary>
        /// Original was GL_ACCUM = 0x0100
        /// </summary>
        Accum = ((int)0x0100)        ,
        /// <summary>
        /// Original was GL_DYNAMIC_STORAGE_BIT = 0x0100
        /// </summary>
        DynamicStorageBit = ((int)0x0100)        ,
        /// <summary>
        /// Original was GL_FONT_MAX_ADVANCE_WIDTH_BIT_NV = 0x01000000
        /// </summary>
        FontMaxAdvanceWidthBitNv = ((int)0x01000000)        ,
        /// <summary>
        /// Original was GL_MAT_COLOR_INDEXES_BIT_PGI = 0x01000000
        /// </summary>
        MatColorIndexesBitPgi = ((int)0x01000000)        ,
        /// <summary>
        /// Original was GL_LOAD = 0x0101
        /// </summary>
        Load = ((int)0x0101)        ,
        /// <summary>
        /// Original was GL_RETURN = 0x0102
        /// </summary>
        Return = ((int)0x0102)        ,
        /// <summary>
        /// Original was GL_MULT = 0x0103
        /// </summary>
        Mult = ((int)0x0103)        ,
        /// <summary>
        /// Original was GL_ADD = 0x0104
        /// </summary>
        Add = ((int)0x0104)        ,
        /// <summary>
        /// Original was GL_GLYPH_HEIGHT_BIT_NV = 0x02
        /// </summary>
        GlyphHeightBitNv = ((int)0x02)        ,
        /// <summary>
        /// Original was GL_ITALIC_BIT_NV = 0x02
        /// </summary>
        ItalicBitNv = ((int)0x02)        ,
        /// <summary>
        /// Original was GL_MOVE_TO_NV = 0x02
        /// </summary>
        MoveToNv = ((int)0x02)        ,
        /// <summary>
        /// Original was GL_CLIENT_STORAGE_BIT = 0x0200
        /// </summary>
        ClientStorageBit = ((int)0x0200)        ,
        /// <summary>
        /// Original was GL_NEVER = 0x0200
        /// </summary>
        Never = ((int)0x0200)        ,
        /// <summary>
        /// Original was GL_FONT_MAX_ADVANCE_HEIGHT_BIT_NV = 0x02000000
        /// </summary>
        FontMaxAdvanceHeightBitNv = ((int)0x02000000)        ,
        /// <summary>
        /// Original was GL_MAT_SHININESS_BIT_PGI = 0x02000000
        /// </summary>
        MatShininessBitPgi = ((int)0x02000000)        ,
        /// <summary>
        /// Original was GL_LESS = 0x0201
        /// </summary>
        Less = ((int)0x0201)        ,
        /// <summary>
        /// Original was GL_EQUAL = 0x0202
        /// </summary>
        Equal = ((int)0x0202)        ,
        /// <summary>
        /// Original was GL_LEQUAL = 0x0203
        /// </summary>
        Lequal = ((int)0x0203)        ,
        /// <summary>
        /// Original was GL_GREATER = 0x0204
        /// </summary>
        Greater = ((int)0x0204)        ,
        /// <summary>
        /// Original was GL_NOTEQUAL = 0x0205
        /// </summary>
        Notequal = ((int)0x0205)        ,
        /// <summary>
        /// Original was GL_GEQUAL = 0x0206
        /// </summary>
        Gequal = ((int)0x0206)        ,
        /// <summary>
        /// Original was GL_ALWAYS = 0x0207
        /// </summary>
        Always = ((int)0x0207)        ,
        /// <summary>
        /// Original was GL_RELATIVE_MOVE_TO_NV = 0x03
        /// </summary>
        RelativeMoveToNv = ((int)0x03)        ,
        /// <summary>
        /// Original was GL_SRC_COLOR = 0x0300
        /// </summary>
        SrcColor = ((int)0x0300)        ,
        /// <summary>
        /// Original was GL_ONE_MINUS_SRC_COLOR = 0x0301
        /// </summary>
        OneMinusSrcColor = ((int)0x0301)        ,
        /// <summary>
        /// Original was GL_SRC_ALPHA = 0x0302
        /// </summary>
        SrcAlpha = ((int)0x0302)        ,
        /// <summary>
        /// Original was GL_ONE_MINUS_SRC_ALPHA = 0x0303
        /// </summary>
        OneMinusSrcAlpha = ((int)0x0303)        ,
        /// <summary>
        /// Original was GL_DST_ALPHA = 0x0304
        /// </summary>
        DstAlpha = ((int)0x0304)        ,
        /// <summary>
        /// Original was GL_ONE_MINUS_DST_ALPHA = 0x0305
        /// </summary>
        OneMinusDstAlpha = ((int)0x0305)        ,
        /// <summary>
        /// Original was GL_DST_COLOR = 0x0306
        /// </summary>
        DstColor = ((int)0x0306)        ,
        /// <summary>
        /// Original was GL_ONE_MINUS_DST_COLOR = 0x0307
        /// </summary>
        OneMinusDstColor = ((int)0x0307)        ,
        /// <summary>
        /// Original was GL_SRC_ALPHA_SATURATE = 0x0308
        /// </summary>
        SrcAlphaSaturate = ((int)0x0308)        ,
        /// <summary>
        /// Original was GL_GLYPH_HORIZONTAL_BEARING_X_BIT_NV = 0x04
        /// </summary>
        GlyphHorizontalBearingXBitNv = ((int)0x04)        ,
        /// <summary>
        /// Original was GL_LINE_TO_NV = 0x04
        /// </summary>
        LineToNv = ((int)0x04)        ,
        /// <summary>
        /// Original was GL_FRONT_LEFT = 0x0400
        /// </summary>
        FrontLeft = ((int)0x0400)        ,
        /// <summary>
        /// Original was GL_FONT_UNDERLINE_POSITION_BIT_NV = 0x04000000
        /// </summary>
        FontUnderlinePositionBitNv = ((int)0x04000000)        ,
        /// <summary>
        /// Original was GL_MAT_SPECULAR_BIT_PGI = 0x04000000
        /// </summary>
        MatSpecularBitPgi = ((int)0x04000000)        ,
        /// <summary>
        /// Original was GL_FRONT_RIGHT = 0x0401
        /// </summary>
        FrontRight = ((int)0x0401)        ,
        /// <summary>
        /// Original was GL_BACK_LEFT = 0x0402
        /// </summary>
        BackLeft = ((int)0x0402)        ,
        /// <summary>
        /// Original was GL_BACK_RIGHT = 0x0403
        /// </summary>
        BackRight = ((int)0x0403)        ,
        /// <summary>
        /// Original was GL_FRONT = 0x0404
        /// </summary>
        Front = ((int)0x0404)        ,
        /// <summary>
        /// Original was GL_BACK = 0x0405
        /// </summary>
        Back = ((int)0x0405)        ,
        /// <summary>
        /// Original was GL_LEFT = 0x0406
        /// </summary>
        Left = ((int)0x0406)        ,
        /// <summary>
        /// Original was GL_RIGHT = 0x0407
        /// </summary>
        Right = ((int)0x0407)        ,
        /// <summary>
        /// Original was GL_FRONT_AND_BACK = 0x0408
        /// </summary>
        FrontAndBack = ((int)0x0408)        ,
        /// <summary>
        /// Original was GL_AUX0 = 0x0409
        /// </summary>
        Aux0 = ((int)0x0409)        ,
        /// <summary>
        /// Original was GL_AUX1 = 0x040A
        /// </summary>
        Aux1 = ((int)0x040A)        ,
        /// <summary>
        /// Original was GL_AUX2 = 0x040B
        /// </summary>
        Aux2 = ((int)0x040B)        ,
        /// <summary>
        /// Original was GL_AUX3 = 0x040C
        /// </summary>
        Aux3 = ((int)0x040C)        ,
        /// <summary>
        /// Original was GL_RELATIVE_LINE_TO_NV = 0x05
        /// </summary>
        RelativeLineToNv = ((int)0x05)        ,
        /// <summary>
        /// Original was GL_INVALID_ENUM = 0x0500
        /// </summary>
        InvalidEnum = ((int)0x0500)        ,
        /// <summary>
        /// Original was GL_INVALID_VALUE = 0x0501
        /// </summary>
        InvalidValue = ((int)0x0501)        ,
        /// <summary>
        /// Original was GL_INVALID_OPERATION = 0x0502
        /// </summary>
        InvalidOperation = ((int)0x0502)        ,
        /// <summary>
        /// Original was GL_STACK_OVERFLOW = 0x0503
        /// </summary>
        StackOverflow = ((int)0x0503)        ,
        /// <summary>
        /// Original was GL_STACK_OVERFLOW_KHR = 0x0503
        /// </summary>
        StackOverflowKhr = ((int)0x0503)        ,
        /// <summary>
        /// Original was GL_STACK_UNDERFLOW = 0x0504
        /// </summary>
        StackUnderflow = ((int)0x0504)        ,
        /// <summary>
        /// Original was GL_STACK_UNDERFLOW_KHR = 0x0504
        /// </summary>
        StackUnderflowKhr = ((int)0x0504)        ,
        /// <summary>
        /// Original was GL_OUT_OF_MEMORY = 0x0505
        /// </summary>
        OutOfMemory = ((int)0x0505)        ,
        /// <summary>
        /// Original was GL_INVALID_FRAMEBUFFER_OPERATION = 0x0506
        /// </summary>
        InvalidFramebufferOperation = ((int)0x0506)        ,
        /// <summary>
        /// Original was GL_INVALID_FRAMEBUFFER_OPERATION_EXT = 0x0506
        /// </summary>
        InvalidFramebufferOperationExt = ((int)0x0506)        ,
        /// <summary>
        /// Original was GL_INVALID_FRAMEBUFFER_OPERATION_OES = 0x0506
        /// </summary>
        InvalidFramebufferOperationOes = ((int)0x0506)        ,
        /// <summary>
        /// Original was GL_HORIZONTAL_LINE_TO_NV = 0x06
        /// </summary>
        HorizontalLineToNv = ((int)0x06)        ,
        /// <summary>
        /// Original was GL_2D = 0x0600
        /// </summary>
        Gl2D = ((int)0x0600)        ,
        /// <summary>
        /// Original was GL_3D = 0x0601
        /// </summary>
        Gl3D = ((int)0x0601)        ,
        /// <summary>
        /// Original was GL_3D_COLOR = 0x0602
        /// </summary>
        Gl3DColor = ((int)0x0602)        ,
        /// <summary>
        /// Original was GL_3D_COLOR_TEXTURE = 0x0603
        /// </summary>
        Gl3DColorTexture = ((int)0x0603)        ,
        /// <summary>
        /// Original was GL_4D_COLOR_TEXTURE = 0x0604
        /// </summary>
        Gl4DColorTexture = ((int)0x0604)        ,
        /// <summary>
        /// Original was GL_RELATIVE_HORIZONTAL_LINE_TO_NV = 0x07
        /// </summary>
        RelativeHorizontalLineToNv = ((int)0x07)        ,
        /// <summary>
        /// Original was GL_PASS_THROUGH_TOKEN = 0x0700
        /// </summary>
        PassThroughToken = ((int)0x0700)        ,
        /// <summary>
        /// Original was GL_POINT_TOKEN = 0x0701
        /// </summary>
        PointToken = ((int)0x0701)        ,
        /// <summary>
        /// Original was GL_LINE_TOKEN = 0x0702
        /// </summary>
        LineToken = ((int)0x0702)        ,
        /// <summary>
        /// Original was GL_POLYGON_TOKEN = 0x0703
        /// </summary>
        PolygonToken = ((int)0x0703)        ,
        /// <summary>
        /// Original was GL_BITMAP_TOKEN = 0x0704
        /// </summary>
        BitmapToken = ((int)0x0704)        ,
        /// <summary>
        /// Original was GL_DRAW_PIXEL_TOKEN = 0x0705
        /// </summary>
        DrawPixelToken = ((int)0x0705)        ,
        /// <summary>
        /// Original was GL_COPY_PIXEL_TOKEN = 0x0706
        /// </summary>
        CopyPixelToken = ((int)0x0706)        ,
        /// <summary>
        /// Original was GL_LINE_RESET_TOKEN = 0x0707
        /// </summary>
        LineResetToken = ((int)0x0707)        ,
        /// <summary>
        /// Original was GL_GLYPH_HORIZONTAL_BEARING_Y_BIT_NV = 0x08
        /// </summary>
        GlyphHorizontalBearingYBitNv = ((int)0x08)        ,
        /// <summary>
        /// Original was GL_VERTICAL_LINE_TO_NV = 0x08
        /// </summary>
        VerticalLineToNv = ((int)0x08)        ,
        /// <summary>
        /// Original was GL_EXP = 0x0800
        /// </summary>
        Exp = ((int)0x0800)        ,
        /// <summary>
        /// Original was GL_FONT_UNDERLINE_THICKNESS_BIT_NV = 0x08000000
        /// </summary>
        FontUnderlineThicknessBitNv = ((int)0x08000000)        ,
        /// <summary>
        /// Original was GL_NORMAL_BIT_PGI = 0x08000000
        /// </summary>
        NormalBitPgi = ((int)0x08000000)        ,
        /// <summary>
        /// Original was GL_EXP2 = 0x0801
        /// </summary>
        Exp2 = ((int)0x0801)        ,
        /// <summary>
        /// Original was GL_RELATIVE_VERTICAL_LINE_TO_NV = 0x09
        /// </summary>
        RelativeVerticalLineToNv = ((int)0x09)        ,
        /// <summary>
        /// Original was GL_CW = 0x0900
        /// </summary>
        Cw = ((int)0x0900)        ,
        /// <summary>
        /// Original was GL_CCW = 0x0901
        /// </summary>
        Ccw = ((int)0x0901)        ,
        /// <summary>
        /// Original was GL_QUADRATIC_CURVE_TO_NV = 0x0A
        /// </summary>
        QuadraticCurveToNv = ((int)0x0A)        ,
        /// <summary>
        /// Original was GL_COEFF = 0x0A00
        /// </summary>
        Coeff = ((int)0x0A00)        ,
        /// <summary>
        /// Original was GL_ORDER = 0x0A01
        /// </summary>
        Order = ((int)0x0A01)        ,
        /// <summary>
        /// Original was GL_DOMAIN = 0x0A02
        /// </summary>
        Domain = ((int)0x0A02)        ,
        /// <summary>
        /// Original was GL_RELATIVE_QUADRATIC_CURVE_TO_NV = 0x0B
        /// </summary>
        RelativeQuadraticCurveToNv = ((int)0x0B)        ,
        /// <summary>
        /// Original was GL_CURRENT_COLOR = 0x0B00
        /// </summary>
        CurrentColor = ((int)0x0B00)        ,
        /// <summary>
        /// Original was GL_CURRENT_INDEX = 0x0B01
        /// </summary>
        CurrentIndex = ((int)0x0B01)        ,
        /// <summary>
        /// Original was GL_CURRENT_NORMAL = 0x0B02
        /// </summary>
        CurrentNormal = ((int)0x0B02)        ,
        /// <summary>
        /// Original was GL_CURRENT_TEXTURE_COORDS = 0x0B03
        /// </summary>
        CurrentTextureCoords = ((int)0x0B03)        ,
        /// <summary>
        /// Original was GL_CURRENT_RASTER_COLOR = 0x0B04
        /// </summary>
        CurrentRasterColor = ((int)0x0B04)        ,
        /// <summary>
        /// Original was GL_CURRENT_RASTER_INDEX = 0x0B05
        /// </summary>
        CurrentRasterIndex = ((int)0x0B05)        ,
        /// <summary>
        /// Original was GL_CURRENT_RASTER_TEXTURE_COORDS = 0x0B06
        /// </summary>
        CurrentRasterTextureCoords = ((int)0x0B06)        ,
        /// <summary>
        /// Original was GL_CURRENT_RASTER_POSITION = 0x0B07
        /// </summary>
        CurrentRasterPosition = ((int)0x0B07)        ,
        /// <summary>
        /// Original was GL_CURRENT_RASTER_POSITION_VALID = 0x0B08
        /// </summary>
        CurrentRasterPositionValid = ((int)0x0B08)        ,
        /// <summary>
        /// Original was GL_CURRENT_RASTER_DISTANCE = 0x0B09
        /// </summary>
        CurrentRasterDistance = ((int)0x0B09)        ,
        /// <summary>
        /// Original was GL_POINT_SMOOTH = 0x0B10
        /// </summary>
        PointSmooth = ((int)0x0B10)        ,
        /// <summary>
        /// Original was GL_POINT_SIZE = 0x0B11
        /// </summary>
        PointSize = ((int)0x0B11)        ,
        /// <summary>
        /// Original was GL_POINT_SIZE_RANGE = 0x0B12
        /// </summary>
        PointSizeRange = ((int)0x0B12)        ,
        /// <summary>
        /// Original was GL_SMOOTH_POINT_SIZE_RANGE = 0x0B12
        /// </summary>
        SmoothPointSizeRange = ((int)0x0B12)        ,
        /// <summary>
        /// Original was GL_POINT_SIZE_GRANULARITY = 0x0B13
        /// </summary>
        PointSizeGranularity = ((int)0x0B13)        ,
        /// <summary>
        /// Original was GL_SMOOTH_POINT_SIZE_GRANULARITY = 0x0B13
        /// </summary>
        SmoothPointSizeGranularity = ((int)0x0B13)        ,
        /// <summary>
        /// Original was GL_LINE_SMOOTH = 0x0B20
        /// </summary>
        LineSmooth = ((int)0x0B20)        ,
        /// <summary>
        /// Original was GL_LINE_WIDTH = 0x0B21
        /// </summary>
        LineWidth = ((int)0x0B21)        ,
        /// <summary>
        /// Original was GL_LINE_WIDTH_RANGE = 0x0B22
        /// </summary>
        LineWidthRange = ((int)0x0B22)        ,
        /// <summary>
        /// Original was GL_SMOOTH_LINE_WIDTH_RANGE = 0x0B22
        /// </summary>
        SmoothLineWidthRange = ((int)0x0B22)        ,
        /// <summary>
        /// Original was GL_LINE_WIDTH_GRANULARITY = 0x0B23
        /// </summary>
        LineWidthGranularity = ((int)0x0B23)        ,
        /// <summary>
        /// Original was GL_SMOOTH_LINE_WIDTH_GRANULARITY = 0x0B23
        /// </summary>
        SmoothLineWidthGranularity = ((int)0x0B23)        ,
        /// <summary>
        /// Original was GL_LINE_STIPPLE = 0x0B24
        /// </summary>
        LineStipple = ((int)0x0B24)        ,
        /// <summary>
        /// Original was GL_LINE_STIPPLE_PATTERN = 0x0B25
        /// </summary>
        LineStipplePattern = ((int)0x0B25)        ,
        /// <summary>
        /// Original was GL_LINE_STIPPLE_REPEAT = 0x0B26
        /// </summary>
        LineStippleRepeat = ((int)0x0B26)        ,
        /// <summary>
        /// Original was GL_LIST_MODE = 0x0B30
        /// </summary>
        ListMode = ((int)0x0B30)        ,
        /// <summary>
        /// Original was GL_MAX_LIST_NESTING = 0x0B31
        /// </summary>
        MaxListNesting = ((int)0x0B31)        ,
        /// <summary>
        /// Original was GL_LIST_BASE = 0x0B32
        /// </summary>
        ListBase = ((int)0x0B32)        ,
        /// <summary>
        /// Original was GL_LIST_INDEX = 0x0B33
        /// </summary>
        ListIndex = ((int)0x0B33)        ,
        /// <summary>
        /// Original was GL_POLYGON_MODE = 0x0B40
        /// </summary>
        PolygonMode = ((int)0x0B40)        ,
        /// <summary>
        /// Original was GL_POLYGON_SMOOTH = 0x0B41
        /// </summary>
        PolygonSmooth = ((int)0x0B41)        ,
        /// <summary>
        /// Original was GL_POLYGON_STIPPLE = 0x0B42
        /// </summary>
        PolygonStipple = ((int)0x0B42)        ,
        /// <summary>
        /// Original was GL_EDGE_FLAG = 0x0B43
        /// </summary>
        EdgeFlag = ((int)0x0B43)        ,
        /// <summary>
        /// Original was GL_CULL_FACE = 0x0B44
        /// </summary>
        CullFace = ((int)0x0B44)        ,
        /// <summary>
        /// Original was GL_CULL_FACE_MODE = 0x0B45
        /// </summary>
        CullFaceMode = ((int)0x0B45)        ,
        /// <summary>
        /// Original was GL_FRONT_FACE = 0x0B46
        /// </summary>
        FrontFace = ((int)0x0B46)        ,
        /// <summary>
        /// Original was GL_LIGHTING = 0x0B50
        /// </summary>
        Lighting = ((int)0x0B50)        ,
        /// <summary>
        /// Original was GL_LIGHT_MODEL_LOCAL_VIEWER = 0x0B51
        /// </summary>
        LightModelLocalViewer = ((int)0x0B51)        ,
        /// <summary>
        /// Original was GL_LIGHT_MODEL_TWO_SIDE = 0x0B52
        /// </summary>
        LightModelTwoSide = ((int)0x0B52)        ,
        /// <summary>
        /// Original was GL_LIGHT_MODEL_AMBIENT = 0x0B53
        /// </summary>
        LightModelAmbient = ((int)0x0B53)        ,
        /// <summary>
        /// Original was GL_SHADE_MODEL = 0x0B54
        /// </summary>
        ShadeModel = ((int)0x0B54)        ,
        /// <summary>
        /// Original was GL_COLOR_MATERIAL_FACE = 0x0B55
        /// </summary>
        ColorMaterialFace = ((int)0x0B55)        ,
        /// <summary>
        /// Original was GL_COLOR_MATERIAL_PARAMETER = 0x0B56
        /// </summary>
        ColorMaterialParameter = ((int)0x0B56)        ,
        /// <summary>
        /// Original was GL_COLOR_MATERIAL = 0x0B57
        /// </summary>
        ColorMaterial = ((int)0x0B57)        ,
        /// <summary>
        /// Original was GL_FOG = 0x0B60
        /// </summary>
        Fog = ((int)0x0B60)        ,
        /// <summary>
        /// Original was GL_FOG_INDEX = 0x0B61
        /// </summary>
        FogIndex = ((int)0x0B61)        ,
        /// <summary>
        /// Original was GL_FOG_DENSITY = 0x0B62
        /// </summary>
        FogDensity = ((int)0x0B62)        ,
        /// <summary>
        /// Original was GL_FOG_START = 0x0B63
        /// </summary>
        FogStart = ((int)0x0B63)        ,
        /// <summary>
        /// Original was GL_FOG_END = 0x0B64
        /// </summary>
        FogEnd = ((int)0x0B64)        ,
        /// <summary>
        /// Original was GL_FOG_MODE = 0x0B65
        /// </summary>
        FogMode = ((int)0x0B65)        ,
        /// <summary>
        /// Original was GL_FOG_COLOR = 0x0B66
        /// </summary>
        FogColor = ((int)0x0B66)        ,
        /// <summary>
        /// Original was GL_DEPTH_RANGE = 0x0B70
        /// </summary>
        DepthRange = ((int)0x0B70)        ,
        /// <summary>
        /// Original was GL_DEPTH_TEST = 0x0B71
        /// </summary>
        DepthTest = ((int)0x0B71)        ,
        /// <summary>
        /// Original was GL_DEPTH_WRITEMASK = 0x0B72
        /// </summary>
        DepthWritemask = ((int)0x0B72)        ,
        /// <summary>
        /// Original was GL_DEPTH_CLEAR_VALUE = 0x0B73
        /// </summary>
        DepthClearValue = ((int)0x0B73)        ,
        /// <summary>
        /// Original was GL_DEPTH_FUNC = 0x0B74
        /// </summary>
        DepthFunc = ((int)0x0B74)        ,
        /// <summary>
        /// Original was GL_ACCUM_CLEAR_VALUE = 0x0B80
        /// </summary>
        AccumClearValue = ((int)0x0B80)        ,
        /// <summary>
        /// Original was GL_STENCIL_TEST = 0x0B90
        /// </summary>
        StencilTest = ((int)0x0B90)        ,
        /// <summary>
        /// Original was GL_STENCIL_CLEAR_VALUE = 0x0B91
        /// </summary>
        StencilClearValue = ((int)0x0B91)        ,
        /// <summary>
        /// Original was GL_STENCIL_FUNC = 0x0B92
        /// </summary>
        StencilFunc = ((int)0x0B92)        ,
        /// <summary>
        /// Original was GL_STENCIL_VALUE_MASK = 0x0B93
        /// </summary>
        StencilValueMask = ((int)0x0B93)        ,
        /// <summary>
        /// Original was GL_STENCIL_FAIL = 0x0B94
        /// </summary>
        StencilFail = ((int)0x0B94)        ,
        /// <summary>
        /// Original was GL_STENCIL_PASS_DEPTH_FAIL = 0x0B95
        /// </summary>
        StencilPassDepthFail = ((int)0x0B95)        ,
        /// <summary>
        /// Original was GL_STENCIL_PASS_DEPTH_PASS = 0x0B96
        /// </summary>
        StencilPassDepthPass = ((int)0x0B96)        ,
        /// <summary>
        /// Original was GL_STENCIL_REF = 0x0B97
        /// </summary>
        StencilRef = ((int)0x0B97)        ,
        /// <summary>
        /// Original was GL_STENCIL_WRITEMASK = 0x0B98
        /// </summary>
        StencilWritemask = ((int)0x0B98)        ,
        /// <summary>
        /// Original was GL_MATRIX_MODE = 0x0BA0
        /// </summary>
        MatrixMode = ((int)0x0BA0)        ,
        /// <summary>
        /// Original was GL_NORMALIZE = 0x0BA1
        /// </summary>
        Normalize = ((int)0x0BA1)        ,
        /// <summary>
        /// Original was GL_VIEWPORT = 0x0BA2
        /// </summary>
        Viewport = ((int)0x0BA2)        ,
        /// <summary>
        /// Original was GL_MODELVIEW0_STACK_DEPTH_EXT = 0x0BA3
        /// </summary>
        Modelview0StackDepthExt = ((int)0x0BA3)        ,
        /// <summary>
        /// Original was GL_MODELVIEW_STACK_DEPTH = 0x0BA3
        /// </summary>
        ModelviewStackDepth = ((int)0x0BA3)        ,
        /// <summary>
        /// Original was GL_PROJECTION_STACK_DEPTH = 0x0BA4
        /// </summary>
        ProjectionStackDepth = ((int)0x0BA4)        ,
        /// <summary>
        /// Original was GL_TEXTURE_STACK_DEPTH = 0x0BA5
        /// </summary>
        TextureStackDepth = ((int)0x0BA5)        ,
        /// <summary>
        /// Original was GL_MODELVIEW0_MATRIX_EXT = 0x0BA6
        /// </summary>
        Modelview0MatrixExt = ((int)0x0BA6)        ,
        /// <summary>
        /// Original was GL_MODELVIEW_MATRIX = 0x0BA6
        /// </summary>
        ModelviewMatrix = ((int)0x0BA6)        ,
        /// <summary>
        /// Original was GL_PROJECTION_MATRIX = 0x0BA7
        /// </summary>
        ProjectionMatrix = ((int)0x0BA7)        ,
        /// <summary>
        /// Original was GL_TEXTURE_MATRIX = 0x0BA8
        /// </summary>
        TextureMatrix = ((int)0x0BA8)        ,
        /// <summary>
        /// Original was GL_ATTRIB_STACK_DEPTH = 0x0BB0
        /// </summary>
        AttribStackDepth = ((int)0x0BB0)        ,
        /// <summary>
        /// Original was GL_CLIENT_ATTRIB_STACK_DEPTH = 0x0BB1
        /// </summary>
        ClientAttribStackDepth = ((int)0x0BB1)        ,
        /// <summary>
        /// Original was GL_ALPHA_TEST = 0x0BC0
        /// </summary>
        AlphaTest = ((int)0x0BC0)        ,
        /// <summary>
        /// Original was GL_ALPHA_TEST_QCOM = 0x0BC0
        /// </summary>
        AlphaTestQcom = ((int)0x0BC0)        ,
        /// <summary>
        /// Original was GL_ALPHA_TEST_FUNC = 0x0BC1
        /// </summary>
        AlphaTestFunc = ((int)0x0BC1)        ,
        /// <summary>
        /// Original was GL_ALPHA_TEST_FUNC_QCOM = 0x0BC1
        /// </summary>
        AlphaTestFuncQcom = ((int)0x0BC1)        ,
        /// <summary>
        /// Original was GL_ALPHA_TEST_REF = 0x0BC2
        /// </summary>
        AlphaTestRef = ((int)0x0BC2)        ,
        /// <summary>
        /// Original was GL_ALPHA_TEST_REF_QCOM = 0x0BC2
        /// </summary>
        AlphaTestRefQcom = ((int)0x0BC2)        ,
        /// <summary>
        /// Original was GL_DITHER = 0x0BD0
        /// </summary>
        Dither = ((int)0x0BD0)        ,
        /// <summary>
        /// Original was GL_BLEND_DST = 0x0BE0
        /// </summary>
        BlendDst = ((int)0x0BE0)        ,
        /// <summary>
        /// Original was GL_BLEND_SRC = 0x0BE1
        /// </summary>
        BlendSrc = ((int)0x0BE1)        ,
        /// <summary>
        /// Original was GL_BLEND = 0x0BE2
        /// </summary>
        Blend = ((int)0x0BE2)        ,
        /// <summary>
        /// Original was GL_LOGIC_OP_MODE = 0x0BF0
        /// </summary>
        LogicOpMode = ((int)0x0BF0)        ,
        /// <summary>
        /// Original was GL_INDEX_LOGIC_OP = 0x0BF1
        /// </summary>
        IndexLogicOp = ((int)0x0BF1)        ,
        /// <summary>
        /// Original was GL_LOGIC_OP = 0x0BF1
        /// </summary>
        LogicOp = ((int)0x0BF1)        ,
        /// <summary>
        /// Original was GL_COLOR_LOGIC_OP = 0x0BF2
        /// </summary>
        ColorLogicOp = ((int)0x0BF2)        ,
        /// <summary>
        /// Original was GL_CUBIC_CURVE_TO_NV = 0x0C
        /// </summary>
        CubicCurveToNv = ((int)0x0C)        ,
        /// <summary>
        /// Original was GL_AUX_BUFFERS = 0x0C00
        /// </summary>
        AuxBuffers = ((int)0x0C00)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER = 0x0C01
        /// </summary>
        DrawBuffer = ((int)0x0C01)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER_EXT = 0x0C01
        /// </summary>
        DrawBufferExt = ((int)0x0C01)        ,
        /// <summary>
        /// Original was GL_READ_BUFFER = 0x0C02
        /// </summary>
        ReadBuffer = ((int)0x0C02)        ,
        /// <summary>
        /// Original was GL_READ_BUFFER_EXT = 0x0C02
        /// </summary>
        ReadBufferExt = ((int)0x0C02)        ,
        /// <summary>
        /// Original was GL_READ_BUFFER_NV = 0x0C02
        /// </summary>
        ReadBufferNv = ((int)0x0C02)        ,
        /// <summary>
        /// Original was GL_SCISSOR_BOX = 0x0C10
        /// </summary>
        ScissorBox = ((int)0x0C10)        ,
        /// <summary>
        /// Original was GL_SCISSOR_TEST = 0x0C11
        /// </summary>
        ScissorTest = ((int)0x0C11)        ,
        /// <summary>
        /// Original was GL_INDEX_CLEAR_VALUE = 0x0C20
        /// </summary>
        IndexClearValue = ((int)0x0C20)        ,
        /// <summary>
        /// Original was GL_INDEX_WRITEMASK = 0x0C21
        /// </summary>
        IndexWritemask = ((int)0x0C21)        ,
        /// <summary>
        /// Original was GL_COLOR_CLEAR_VALUE = 0x0C22
        /// </summary>
        ColorClearValue = ((int)0x0C22)        ,
        /// <summary>
        /// Original was GL_COLOR_WRITEMASK = 0x0C23
        /// </summary>
        ColorWritemask = ((int)0x0C23)        ,
        /// <summary>
        /// Original was GL_INDEX_MODE = 0x0C30
        /// </summary>
        IndexMode = ((int)0x0C30)        ,
        /// <summary>
        /// Original was GL_RGBA_MODE = 0x0C31
        /// </summary>
        RgbaMode = ((int)0x0C31)        ,
        /// <summary>
        /// Original was GL_DOUBLEBUFFER = 0x0C32
        /// </summary>
        Doublebuffer = ((int)0x0C32)        ,
        /// <summary>
        /// Original was GL_STEREO = 0x0C33
        /// </summary>
        Stereo = ((int)0x0C33)        ,
        /// <summary>
        /// Original was GL_RENDER_MODE = 0x0C40
        /// </summary>
        RenderMode = ((int)0x0C40)        ,
        /// <summary>
        /// Original was GL_PERSPECTIVE_CORRECTION_HINT = 0x0C50
        /// </summary>
        PerspectiveCorrectionHint = ((int)0x0C50)        ,
        /// <summary>
        /// Original was GL_POINT_SMOOTH_HINT = 0x0C51
        /// </summary>
        PointSmoothHint = ((int)0x0C51)        ,
        /// <summary>
        /// Original was GL_LINE_SMOOTH_HINT = 0x0C52
        /// </summary>
        LineSmoothHint = ((int)0x0C52)        ,
        /// <summary>
        /// Original was GL_POLYGON_SMOOTH_HINT = 0x0C53
        /// </summary>
        PolygonSmoothHint = ((int)0x0C53)        ,
        /// <summary>
        /// Original was GL_FOG_HINT = 0x0C54
        /// </summary>
        FogHint = ((int)0x0C54)        ,
        /// <summary>
        /// Original was GL_TEXTURE_GEN_S = 0x0C60
        /// </summary>
        TextureGenS = ((int)0x0C60)        ,
        /// <summary>
        /// Original was GL_TEXTURE_GEN_T = 0x0C61
        /// </summary>
        TextureGenT = ((int)0x0C61)        ,
        /// <summary>
        /// Original was GL_TEXTURE_GEN_R = 0x0C62
        /// </summary>
        TextureGenR = ((int)0x0C62)        ,
        /// <summary>
        /// Original was GL_TEXTURE_GEN_Q = 0x0C63
        /// </summary>
        TextureGenQ = ((int)0x0C63)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAP_I_TO_I = 0x0C70
        /// </summary>
        PixelMapIToI = ((int)0x0C70)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAP_S_TO_S = 0x0C71
        /// </summary>
        PixelMapSToS = ((int)0x0C71)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAP_I_TO_R = 0x0C72
        /// </summary>
        PixelMapIToR = ((int)0x0C72)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAP_I_TO_G = 0x0C73
        /// </summary>
        PixelMapIToG = ((int)0x0C73)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAP_I_TO_B = 0x0C74
        /// </summary>
        PixelMapIToB = ((int)0x0C74)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAP_I_TO_A = 0x0C75
        /// </summary>
        PixelMapIToA = ((int)0x0C75)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAP_R_TO_R = 0x0C76
        /// </summary>
        PixelMapRToR = ((int)0x0C76)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAP_G_TO_G = 0x0C77
        /// </summary>
        PixelMapGToG = ((int)0x0C77)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAP_B_TO_B = 0x0C78
        /// </summary>
        PixelMapBToB = ((int)0x0C78)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAP_A_TO_A = 0x0C79
        /// </summary>
        PixelMapAToA = ((int)0x0C79)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAP_I_TO_I_SIZE = 0x0CB0
        /// </summary>
        PixelMapIToISize = ((int)0x0CB0)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAP_S_TO_S_SIZE = 0x0CB1
        /// </summary>
        PixelMapSToSSize = ((int)0x0CB1)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAP_I_TO_R_SIZE = 0x0CB2
        /// </summary>
        PixelMapIToRSize = ((int)0x0CB2)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAP_I_TO_G_SIZE = 0x0CB3
        /// </summary>
        PixelMapIToGSize = ((int)0x0CB3)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAP_I_TO_B_SIZE = 0x0CB4
        /// </summary>
        PixelMapIToBSize = ((int)0x0CB4)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAP_I_TO_A_SIZE = 0x0CB5
        /// </summary>
        PixelMapIToASize = ((int)0x0CB5)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAP_R_TO_R_SIZE = 0x0CB6
        /// </summary>
        PixelMapRToRSize = ((int)0x0CB6)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAP_G_TO_G_SIZE = 0x0CB7
        /// </summary>
        PixelMapGToGSize = ((int)0x0CB7)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAP_B_TO_B_SIZE = 0x0CB8
        /// </summary>
        PixelMapBToBSize = ((int)0x0CB8)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAP_A_TO_A_SIZE = 0x0CB9
        /// </summary>
        PixelMapAToASize = ((int)0x0CB9)        ,
        /// <summary>
        /// Original was GL_UNPACK_SWAP_BYTES = 0x0CF0
        /// </summary>
        UnpackSwapBytes = ((int)0x0CF0)        ,
        /// <summary>
        /// Original was GL_UNPACK_LSB_FIRST = 0x0CF1
        /// </summary>
        UnpackLsbFirst = ((int)0x0CF1)        ,
        /// <summary>
        /// Original was GL_UNPACK_ROW_LENGTH = 0x0CF2
        /// </summary>
        UnpackRowLength = ((int)0x0CF2)        ,
        /// <summary>
        /// Original was GL_UNPACK_ROW_LENGTH_EXT = 0x0CF2
        /// </summary>
        UnpackRowLengthExt = ((int)0x0CF2)        ,
        /// <summary>
        /// Original was GL_UNPACK_SKIP_ROWS = 0x0CF3
        /// </summary>
        UnpackSkipRows = ((int)0x0CF3)        ,
        /// <summary>
        /// Original was GL_UNPACK_SKIP_ROWS_EXT = 0x0CF3
        /// </summary>
        UnpackSkipRowsExt = ((int)0x0CF3)        ,
        /// <summary>
        /// Original was GL_UNPACK_SKIP_PIXELS = 0x0CF4
        /// </summary>
        UnpackSkipPixels = ((int)0x0CF4)        ,
        /// <summary>
        /// Original was GL_UNPACK_SKIP_PIXELS_EXT = 0x0CF4
        /// </summary>
        UnpackSkipPixelsExt = ((int)0x0CF4)        ,
        /// <summary>
        /// Original was GL_UNPACK_ALIGNMENT = 0x0CF5
        /// </summary>
        UnpackAlignment = ((int)0x0CF5)        ,
        /// <summary>
        /// Original was GL_RELATIVE_CUBIC_CURVE_TO_NV = 0x0D
        /// </summary>
        RelativeCubicCurveToNv = ((int)0x0D)        ,
        /// <summary>
        /// Original was GL_PACK_SWAP_BYTES = 0x0D00
        /// </summary>
        PackSwapBytes = ((int)0x0D00)        ,
        /// <summary>
        /// Original was GL_PACK_LSB_FIRST = 0x0D01
        /// </summary>
        PackLsbFirst = ((int)0x0D01)        ,
        /// <summary>
        /// Original was GL_PACK_ROW_LENGTH = 0x0D02
        /// </summary>
        PackRowLength = ((int)0x0D02)        ,
        /// <summary>
        /// Original was GL_PACK_SKIP_ROWS = 0x0D03
        /// </summary>
        PackSkipRows = ((int)0x0D03)        ,
        /// <summary>
        /// Original was GL_PACK_SKIP_PIXELS = 0x0D04
        /// </summary>
        PackSkipPixels = ((int)0x0D04)        ,
        /// <summary>
        /// Original was GL_PACK_ALIGNMENT = 0x0D05
        /// </summary>
        PackAlignment = ((int)0x0D05)        ,
        /// <summary>
        /// Original was GL_MAP_COLOR = 0x0D10
        /// </summary>
        MapColor = ((int)0x0D10)        ,
        /// <summary>
        /// Original was GL_MAP_STENCIL = 0x0D11
        /// </summary>
        MapStencil = ((int)0x0D11)        ,
        /// <summary>
        /// Original was GL_INDEX_SHIFT = 0x0D12
        /// </summary>
        IndexShift = ((int)0x0D12)        ,
        /// <summary>
        /// Original was GL_INDEX_OFFSET = 0x0D13
        /// </summary>
        IndexOffset = ((int)0x0D13)        ,
        /// <summary>
        /// Original was GL_RED_SCALE = 0x0D14
        /// </summary>
        RedScale = ((int)0x0D14)        ,
        /// <summary>
        /// Original was GL_RED_BIAS = 0x0D15
        /// </summary>
        RedBias = ((int)0x0D15)        ,
        /// <summary>
        /// Original was GL_ZOOM_X = 0x0D16
        /// </summary>
        ZoomX = ((int)0x0D16)        ,
        /// <summary>
        /// Original was GL_ZOOM_Y = 0x0D17
        /// </summary>
        ZoomY = ((int)0x0D17)        ,
        /// <summary>
        /// Original was GL_GREEN_SCALE = 0x0D18
        /// </summary>
        GreenScale = ((int)0x0D18)        ,
        /// <summary>
        /// Original was GL_GREEN_BIAS = 0x0D19
        /// </summary>
        GreenBias = ((int)0x0D19)        ,
        /// <summary>
        /// Original was GL_BLUE_SCALE = 0x0D1A
        /// </summary>
        BlueScale = ((int)0x0D1A)        ,
        /// <summary>
        /// Original was GL_BLUE_BIAS = 0x0D1B
        /// </summary>
        BlueBias = ((int)0x0D1B)        ,
        /// <summary>
        /// Original was GL_ALPHA_SCALE = 0x0D1C
        /// </summary>
        AlphaScale = ((int)0x0D1C)        ,
        /// <summary>
        /// Original was GL_ALPHA_BIAS = 0x0D1D
        /// </summary>
        AlphaBias = ((int)0x0D1D)        ,
        /// <summary>
        /// Original was GL_DEPTH_SCALE = 0x0D1E
        /// </summary>
        DepthScale = ((int)0x0D1E)        ,
        /// <summary>
        /// Original was GL_DEPTH_BIAS = 0x0D1F
        /// </summary>
        DepthBias = ((int)0x0D1F)        ,
        /// <summary>
        /// Original was GL_MAX_EVAL_ORDER = 0x0D30
        /// </summary>
        MaxEvalOrder = ((int)0x0D30)        ,
        /// <summary>
        /// Original was GL_MAX_LIGHTS = 0x0D31
        /// </summary>
        MaxLights = ((int)0x0D31)        ,
        /// <summary>
        /// Original was GL_MAX_CLIP_DISTANCES = 0x0D32
        /// </summary>
        MaxClipDistances = ((int)0x0D32)        ,
        /// <summary>
        /// Original was GL_MAX_CLIP_PLANES = 0x0D32
        /// </summary>
        MaxClipPlanes = ((int)0x0D32)        ,
        /// <summary>
        /// Original was GL_MAX_TEXTURE_SIZE = 0x0D33
        /// </summary>
        MaxTextureSize = ((int)0x0D33)        ,
        /// <summary>
        /// Original was GL_MAX_PIXEL_MAP_TABLE = 0x0D34
        /// </summary>
        MaxPixelMapTable = ((int)0x0D34)        ,
        /// <summary>
        /// Original was GL_MAX_ATTRIB_STACK_DEPTH = 0x0D35
        /// </summary>
        MaxAttribStackDepth = ((int)0x0D35)        ,
        /// <summary>
        /// Original was GL_MAX_MODELVIEW_STACK_DEPTH = 0x0D36
        /// </summary>
        MaxModelviewStackDepth = ((int)0x0D36)        ,
        /// <summary>
        /// Original was GL_MAX_NAME_STACK_DEPTH = 0x0D37
        /// </summary>
        MaxNameStackDepth = ((int)0x0D37)        ,
        /// <summary>
        /// Original was GL_MAX_PROJECTION_STACK_DEPTH = 0x0D38
        /// </summary>
        MaxProjectionStackDepth = ((int)0x0D38)        ,
        /// <summary>
        /// Original was GL_MAX_TEXTURE_STACK_DEPTH = 0x0D39
        /// </summary>
        MaxTextureStackDepth = ((int)0x0D39)        ,
        /// <summary>
        /// Original was GL_MAX_VIEWPORT_DIMS = 0x0D3A
        /// </summary>
        MaxViewportDims = ((int)0x0D3A)        ,
        /// <summary>
        /// Original was GL_MAX_CLIENT_ATTRIB_STACK_DEPTH = 0x0D3B
        /// </summary>
        MaxClientAttribStackDepth = ((int)0x0D3B)        ,
        /// <summary>
        /// Original was GL_SUBPIXEL_BITS = 0x0D50
        /// </summary>
        SubpixelBits = ((int)0x0D50)        ,
        /// <summary>
        /// Original was GL_INDEX_BITS = 0x0D51
        /// </summary>
        IndexBits = ((int)0x0D51)        ,
        /// <summary>
        /// Original was GL_RED_BITS = 0x0D52
        /// </summary>
        RedBits = ((int)0x0D52)        ,
        /// <summary>
        /// Original was GL_GREEN_BITS = 0x0D53
        /// </summary>
        GreenBits = ((int)0x0D53)        ,
        /// <summary>
        /// Original was GL_BLUE_BITS = 0x0D54
        /// </summary>
        BlueBits = ((int)0x0D54)        ,
        /// <summary>
        /// Original was GL_ALPHA_BITS = 0x0D55
        /// </summary>
        AlphaBits = ((int)0x0D55)        ,
        /// <summary>
        /// Original was GL_DEPTH_BITS = 0x0D56
        /// </summary>
        DepthBits = ((int)0x0D56)        ,
        /// <summary>
        /// Original was GL_STENCIL_BITS = 0x0D57
        /// </summary>
        StencilBits = ((int)0x0D57)        ,
        /// <summary>
        /// Original was GL_ACCUM_RED_BITS = 0x0D58
        /// </summary>
        AccumRedBits = ((int)0x0D58)        ,
        /// <summary>
        /// Original was GL_ACCUM_GREEN_BITS = 0x0D59
        /// </summary>
        AccumGreenBits = ((int)0x0D59)        ,
        /// <summary>
        /// Original was GL_ACCUM_BLUE_BITS = 0x0D5A
        /// </summary>
        AccumBlueBits = ((int)0x0D5A)        ,
        /// <summary>
        /// Original was GL_ACCUM_ALPHA_BITS = 0x0D5B
        /// </summary>
        AccumAlphaBits = ((int)0x0D5B)        ,
        /// <summary>
        /// Original was GL_NAME_STACK_DEPTH = 0x0D70
        /// </summary>
        NameStackDepth = ((int)0x0D70)        ,
        /// <summary>
        /// Original was GL_AUTO_NORMAL = 0x0D80
        /// </summary>
        AutoNormal = ((int)0x0D80)        ,
        /// <summary>
        /// Original was GL_MAP1_COLOR_4 = 0x0D90
        /// </summary>
        Map1Color4 = ((int)0x0D90)        ,
        /// <summary>
        /// Original was GL_MAP1_INDEX = 0x0D91
        /// </summary>
        Map1Index = ((int)0x0D91)        ,
        /// <summary>
        /// Original was GL_MAP1_NORMAL = 0x0D92
        /// </summary>
        Map1Normal = ((int)0x0D92)        ,
        /// <summary>
        /// Original was GL_MAP1_TEXTURE_COORD_1 = 0x0D93
        /// </summary>
        Map1TextureCoord1 = ((int)0x0D93)        ,
        /// <summary>
        /// Original was GL_MAP1_TEXTURE_COORD_2 = 0x0D94
        /// </summary>
        Map1TextureCoord2 = ((int)0x0D94)        ,
        /// <summary>
        /// Original was GL_MAP1_TEXTURE_COORD_3 = 0x0D95
        /// </summary>
        Map1TextureCoord3 = ((int)0x0D95)        ,
        /// <summary>
        /// Original was GL_MAP1_TEXTURE_COORD_4 = 0x0D96
        /// </summary>
        Map1TextureCoord4 = ((int)0x0D96)        ,
        /// <summary>
        /// Original was GL_MAP1_VERTEX_3 = 0x0D97
        /// </summary>
        Map1Vertex3 = ((int)0x0D97)        ,
        /// <summary>
        /// Original was GL_MAP1_VERTEX_4 = 0x0D98
        /// </summary>
        Map1Vertex4 = ((int)0x0D98)        ,
        /// <summary>
        /// Original was GL_MAP2_COLOR_4 = 0x0DB0
        /// </summary>
        Map2Color4 = ((int)0x0DB0)        ,
        /// <summary>
        /// Original was GL_MAP2_INDEX = 0x0DB1
        /// </summary>
        Map2Index = ((int)0x0DB1)        ,
        /// <summary>
        /// Original was GL_MAP2_NORMAL = 0x0DB2
        /// </summary>
        Map2Normal = ((int)0x0DB2)        ,
        /// <summary>
        /// Original was GL_MAP2_TEXTURE_COORD_1 = 0x0DB3
        /// </summary>
        Map2TextureCoord1 = ((int)0x0DB3)        ,
        /// <summary>
        /// Original was GL_MAP2_TEXTURE_COORD_2 = 0x0DB4
        /// </summary>
        Map2TextureCoord2 = ((int)0x0DB4)        ,
        /// <summary>
        /// Original was GL_MAP2_TEXTURE_COORD_3 = 0x0DB5
        /// </summary>
        Map2TextureCoord3 = ((int)0x0DB5)        ,
        /// <summary>
        /// Original was GL_MAP2_TEXTURE_COORD_4 = 0x0DB6
        /// </summary>
        Map2TextureCoord4 = ((int)0x0DB6)        ,
        /// <summary>
        /// Original was GL_MAP2_VERTEX_3 = 0x0DB7
        /// </summary>
        Map2Vertex3 = ((int)0x0DB7)        ,
        /// <summary>
        /// Original was GL_MAP2_VERTEX_4 = 0x0DB8
        /// </summary>
        Map2Vertex4 = ((int)0x0DB8)        ,
        /// <summary>
        /// Original was GL_MAP1_GRID_DOMAIN = 0x0DD0
        /// </summary>
        Map1GridDomain = ((int)0x0DD0)        ,
        /// <summary>
        /// Original was GL_MAP1_GRID_SEGMENTS = 0x0DD1
        /// </summary>
        Map1GridSegments = ((int)0x0DD1)        ,
        /// <summary>
        /// Original was GL_MAP2_GRID_DOMAIN = 0x0DD2
        /// </summary>
        Map2GridDomain = ((int)0x0DD2)        ,
        /// <summary>
        /// Original was GL_MAP2_GRID_SEGMENTS = 0x0DD3
        /// </summary>
        Map2GridSegments = ((int)0x0DD3)        ,
        /// <summary>
        /// Original was GL_TEXTURE_1D = 0x0DE0
        /// </summary>
        Texture1D = ((int)0x0DE0)        ,
        /// <summary>
        /// Original was GL_TEXTURE_2D = 0x0DE1
        /// </summary>
        Texture2D = ((int)0x0DE1)        ,
        /// <summary>
        /// Original was GL_FEEDBACK_BUFFER_POINTER = 0x0DF0
        /// </summary>
        FeedbackBufferPointer = ((int)0x0DF0)        ,
        /// <summary>
        /// Original was GL_FEEDBACK_BUFFER_SIZE = 0x0DF1
        /// </summary>
        FeedbackBufferSize = ((int)0x0DF1)        ,
        /// <summary>
        /// Original was GL_FEEDBACK_BUFFER_TYPE = 0x0DF2
        /// </summary>
        FeedbackBufferType = ((int)0x0DF2)        ,
        /// <summary>
        /// Original was GL_SELECTION_BUFFER_POINTER = 0x0DF3
        /// </summary>
        SelectionBufferPointer = ((int)0x0DF3)        ,
        /// <summary>
        /// Original was GL_SELECTION_BUFFER_SIZE = 0x0DF4
        /// </summary>
        SelectionBufferSize = ((int)0x0DF4)        ,
        /// <summary>
        /// Original was GL_SMOOTH_QUADRATIC_CURVE_TO_NV = 0x0E
        /// </summary>
        SmoothQuadraticCurveToNv = ((int)0x0E)        ,
        /// <summary>
        /// Original was GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV = 0x0F
        /// </summary>
        RelativeSmoothQuadraticCurveToNv = ((int)0x0F)        ,
        /// <summary>
        /// Original was GL_GLYPH_HORIZONTAL_BEARING_ADVANCE_BIT_NV = 0x10
        /// </summary>
        GlyphHorizontalBearingAdvanceBitNv = ((int)0x10)        ,
        /// <summary>
        /// Original was GL_SMOOTH_CUBIC_CURVE_TO_NV = 0x10
        /// </summary>
        SmoothCubicCurveToNv = ((int)0x10)        ,
        /// <summary>
        /// Original was GL_GLYPH_HAS_KERNING_BIT_NV = 0x100
        /// </summary>
        GlyphHasKerningBitNv = ((int)0x100)        ,
        /// <summary>
        /// Original was GL_TEXTURE_WIDTH = 0x1000
        /// </summary>
        TextureWidth = ((int)0x1000)        ,
        /// <summary>
        /// Original was GL_FONT_HAS_KERNING_BIT_NV = 0x10000000
        /// </summary>
        FontHasKerningBitNv = ((int)0x10000000)        ,
        /// <summary>
        /// Original was GL_TEXCOORD1_BIT_PGI = 0x10000000
        /// </summary>
        Texcoord1BitPgi = ((int)0x10000000)        ,
        /// <summary>
        /// Original was GL_TEXTURE_HEIGHT = 0x1001
        /// </summary>
        TextureHeight = ((int)0x1001)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPONENTS = 0x1003
        /// </summary>
        TextureComponents = ((int)0x1003)        ,
        /// <summary>
        /// Original was GL_TEXTURE_INTERNAL_FORMAT = 0x1003
        /// </summary>
        TextureInternalFormat = ((int)0x1003)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BORDER_COLOR = 0x1004
        /// </summary>
        TextureBorderColor = ((int)0x1004)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BORDER_COLOR_NV = 0x1004
        /// </summary>
        TextureBorderColorNv = ((int)0x1004)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BORDER = 0x1005
        /// </summary>
        TextureBorder = ((int)0x1005)        ,
        /// <summary>
        /// Original was GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV = 0x11
        /// </summary>
        RelativeSmoothCubicCurveToNv = ((int)0x11)        ,
        /// <summary>
        /// Original was GL_DONT_CARE = 0x1100
        /// </summary>
        DontCare = ((int)0x1100)        ,
        /// <summary>
        /// Original was GL_FASTEST = 0x1101
        /// </summary>
        Fastest = ((int)0x1101)        ,
        /// <summary>
        /// Original was GL_NICEST = 0x1102
        /// </summary>
        Nicest = ((int)0x1102)        ,
        /// <summary>
        /// Original was GL_SMALL_CCW_ARC_TO_NV = 0x12
        /// </summary>
        SmallCcwArcToNv = ((int)0x12)        ,
        /// <summary>
        /// Original was GL_AMBIENT = 0x1200
        /// </summary>
        Ambient = ((int)0x1200)        ,
        /// <summary>
        /// Original was GL_DIFFUSE = 0x1201
        /// </summary>
        Diffuse = ((int)0x1201)        ,
        /// <summary>
        /// Original was GL_SPECULAR = 0x1202
        /// </summary>
        Specular = ((int)0x1202)        ,
        /// <summary>
        /// Original was GL_POSITION = 0x1203
        /// </summary>
        Position = ((int)0x1203)        ,
        /// <summary>
        /// Original was GL_SPOT_DIRECTION = 0x1204
        /// </summary>
        SpotDirection = ((int)0x1204)        ,
        /// <summary>
        /// Original was GL_SPOT_EXPONENT = 0x1205
        /// </summary>
        SpotExponent = ((int)0x1205)        ,
        /// <summary>
        /// Original was GL_SPOT_CUTOFF = 0x1206
        /// </summary>
        SpotCutoff = ((int)0x1206)        ,
        /// <summary>
        /// Original was GL_CONSTANT_ATTENUATION = 0x1207
        /// </summary>
        ConstantAttenuation = ((int)0x1207)        ,
        /// <summary>
        /// Original was GL_LINEAR_ATTENUATION = 0x1208
        /// </summary>
        LinearAttenuation = ((int)0x1208)        ,
        /// <summary>
        /// Original was GL_QUADRATIC_ATTENUATION = 0x1209
        /// </summary>
        QuadraticAttenuation = ((int)0x1209)        ,
        /// <summary>
        /// Original was GL_RELATIVE_SMALL_CCW_ARC_TO_NV = 0x13
        /// </summary>
        RelativeSmallCcwArcToNv = ((int)0x13)        ,
        /// <summary>
        /// Original was GL_COMPILE = 0x1300
        /// </summary>
        Compile = ((int)0x1300)        ,
        /// <summary>
        /// Original was GL_COMPILE_AND_EXECUTE = 0x1301
        /// </summary>
        CompileAndExecute = ((int)0x1301)        ,
        /// <summary>
        /// Original was GL_SMALL_CW_ARC_TO_NV = 0x14
        /// </summary>
        SmallCwArcToNv = ((int)0x14)        ,
        /// <summary>
        /// Original was GL_BYTE = 0x1400
        /// </summary>
        Byte = ((int)0x1400)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_BYTE = 0x1401
        /// </summary>
        UnsignedByte = ((int)0x1401)        ,
        /// <summary>
        /// Original was GL_SHORT = 0x1402
        /// </summary>
        Short = ((int)0x1402)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_SHORT = 0x1403
        /// </summary>
        UnsignedShort = ((int)0x1403)        ,
        /// <summary>
        /// Original was GL_INT = 0x1404
        /// </summary>
        Int = ((int)0x1404)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT = 0x1405
        /// </summary>
        UnsignedInt = ((int)0x1405)        ,
        /// <summary>
        /// Original was GL_FLOAT = 0x1406
        /// </summary>
        Float = ((int)0x1406)        ,
        /// <summary>
        /// Original was GL_2_BYTES = 0x1407
        /// </summary>
        Gl2Bytes = ((int)0x1407)        ,
        /// <summary>
        /// Original was GL_3_BYTES = 0x1408
        /// </summary>
        Gl3Bytes = ((int)0x1408)        ,
        /// <summary>
        /// Original was GL_4_BYTES = 0x1409
        /// </summary>
        Gl4Bytes = ((int)0x1409)        ,
        /// <summary>
        /// Original was GL_DOUBLE = 0x140A
        /// </summary>
        Double = ((int)0x140A)        ,
        /// <summary>
        /// Original was GL_HALF_APPLE = 0x140B
        /// </summary>
        HalfApple = ((int)0x140B)        ,
        /// <summary>
        /// Original was GL_HALF_FLOAT = 0x140B
        /// </summary>
        HalfFloat = ((int)0x140B)        ,
        /// <summary>
        /// Original was GL_HALF_FLOAT_ARB = 0x140B
        /// </summary>
        HalfFloatArb = ((int)0x140B)        ,
        /// <summary>
        /// Original was GL_HALF_FLOAT_NV = 0x140B
        /// </summary>
        HalfFloatNv = ((int)0x140B)        ,
        /// <summary>
        /// Original was GL_FIXED = 0x140C
        /// </summary>
        Fixed = ((int)0x140C)        ,
        /// <summary>
        /// Original was GL_FIXED_OES = 0x140C
        /// </summary>
        FixedOes = ((int)0x140C)        ,
        /// <summary>
        /// Original was GL_INT64_NV = 0x140E
        /// </summary>
        Int64Nv = ((int)0x140E)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT64_ARB = 0x140F
        /// </summary>
        UnsignedInt64Arb = ((int)0x140F)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT64_NV = 0x140F
        /// </summary>
        UnsignedInt64Nv = ((int)0x140F)        ,
        /// <summary>
        /// Original was GL_RELATIVE_SMALL_CW_ARC_TO_NV = 0x15
        /// </summary>
        RelativeSmallCwArcToNv = ((int)0x15)        ,
        /// <summary>
        /// Original was GL_CLEAR = 0x1500
        /// </summary>
        Clear = ((int)0x1500)        ,
        /// <summary>
        /// Original was GL_AND = 0x1501
        /// </summary>
        And = ((int)0x1501)        ,
        /// <summary>
        /// Original was GL_AND_REVERSE = 0x1502
        /// </summary>
        AndReverse = ((int)0x1502)        ,
        /// <summary>
        /// Original was GL_COPY = 0x1503
        /// </summary>
        Copy = ((int)0x1503)        ,
        /// <summary>
        /// Original was GL_AND_INVERTED = 0x1504
        /// </summary>
        AndInverted = ((int)0x1504)        ,
        /// <summary>
        /// Original was GL_NOOP = 0x1505
        /// </summary>
        Noop = ((int)0x1505)        ,
        /// <summary>
        /// Original was GL_XOR = 0x1506
        /// </summary>
        Xor = ((int)0x1506)        ,
        /// <summary>
        /// Original was GL_XOR_NV = 0x1506
        /// </summary>
        XorNv = ((int)0x1506)        ,
        /// <summary>
        /// Original was GL_OR = 0x1507
        /// </summary>
        Or = ((int)0x1507)        ,
        /// <summary>
        /// Original was GL_NOR = 0x1508
        /// </summary>
        Nor = ((int)0x1508)        ,
        /// <summary>
        /// Original was GL_EQUIV = 0x1509
        /// </summary>
        Equiv = ((int)0x1509)        ,
        /// <summary>
        /// Original was GL_INVERT = 0x150A
        /// </summary>
        Invert = ((int)0x150A)        ,
        /// <summary>
        /// Original was GL_OR_REVERSE = 0x150B
        /// </summary>
        OrReverse = ((int)0x150B)        ,
        /// <summary>
        /// Original was GL_COPY_INVERTED = 0x150C
        /// </summary>
        CopyInverted = ((int)0x150C)        ,
        /// <summary>
        /// Original was GL_OR_INVERTED = 0x150D
        /// </summary>
        OrInverted = ((int)0x150D)        ,
        /// <summary>
        /// Original was GL_NAND = 0x150E
        /// </summary>
        Nand = ((int)0x150E)        ,
        /// <summary>
        /// Original was GL_SET = 0x150F
        /// </summary>
        Set = ((int)0x150F)        ,
        /// <summary>
        /// Original was GL_LARGE_CCW_ARC_TO_NV = 0x16
        /// </summary>
        LargeCcwArcToNv = ((int)0x16)        ,
        /// <summary>
        /// Original was GL_EMISSION = 0x1600
        /// </summary>
        Emission = ((int)0x1600)        ,
        /// <summary>
        /// Original was GL_SHININESS = 0x1601
        /// </summary>
        Shininess = ((int)0x1601)        ,
        /// <summary>
        /// Original was GL_AMBIENT_AND_DIFFUSE = 0x1602
        /// </summary>
        AmbientAndDiffuse = ((int)0x1602)        ,
        /// <summary>
        /// Original was GL_COLOR_INDEXES = 0x1603
        /// </summary>
        ColorIndexes = ((int)0x1603)        ,
        /// <summary>
        /// Original was GL_RELATIVE_LARGE_CCW_ARC_TO_NV = 0x17
        /// </summary>
        RelativeLargeCcwArcToNv = ((int)0x17)        ,
        /// <summary>
        /// Original was GL_MODELVIEW = 0x1700
        /// </summary>
        Modelview = ((int)0x1700)        ,
        /// <summary>
        /// Original was GL_MODELVIEW0_ARB = 0x1700
        /// </summary>
        Modelview0Arb = ((int)0x1700)        ,
        /// <summary>
        /// Original was GL_MODELVIEW0_EXT = 0x1700
        /// </summary>
        Modelview0Ext = ((int)0x1700)        ,
        /// <summary>
        /// Original was GL_PROJECTION = 0x1701
        /// </summary>
        Projection = ((int)0x1701)        ,
        /// <summary>
        /// Original was GL_TEXTURE = 0x1702
        /// </summary>
        Texture = ((int)0x1702)        ,
        /// <summary>
        /// Original was GL_LARGE_CW_ARC_TO_NV = 0x18
        /// </summary>
        LargeCwArcToNv = ((int)0x18)        ,
        /// <summary>
        /// Original was GL_COLOR = 0x1800
        /// </summary>
        Color = ((int)0x1800)        ,
        /// <summary>
        /// Original was GL_COLOR_EXT = 0x1800
        /// </summary>
        ColorExt = ((int)0x1800)        ,
        /// <summary>
        /// Original was GL_DEPTH = 0x1801
        /// </summary>
        Depth = ((int)0x1801)        ,
        /// <summary>
        /// Original was GL_DEPTH_EXT = 0x1801
        /// </summary>
        DepthExt = ((int)0x1801)        ,
        /// <summary>
        /// Original was GL_STENCIL = 0x1802
        /// </summary>
        Stencil = ((int)0x1802)        ,
        /// <summary>
        /// Original was GL_STENCIL_EXT = 0x1802
        /// </summary>
        StencilExt = ((int)0x1802)        ,
        /// <summary>
        /// Original was GL_RELATIVE_LARGE_CW_ARC_TO_NV = 0x19
        /// </summary>
        RelativeLargeCwArcToNv = ((int)0x19)        ,
        /// <summary>
        /// Original was GL_COLOR_INDEX = 0x1900
        /// </summary>
        ColorIndex = ((int)0x1900)        ,
        /// <summary>
        /// Original was GL_STENCIL_INDEX = 0x1901
        /// </summary>
        StencilIndex = ((int)0x1901)        ,
        /// <summary>
        /// Original was GL_DEPTH_COMPONENT = 0x1902
        /// </summary>
        DepthComponent = ((int)0x1902)        ,
        /// <summary>
        /// Original was GL_RED = 0x1903
        /// </summary>
        Red = ((int)0x1903)        ,
        /// <summary>
        /// Original was GL_RED_EXT = 0x1903
        /// </summary>
        RedExt = ((int)0x1903)        ,
        /// <summary>
        /// Original was GL_RED_NV = 0x1903
        /// </summary>
        RedNv = ((int)0x1903)        ,
        /// <summary>
        /// Original was GL_GREEN = 0x1904
        /// </summary>
        Green = ((int)0x1904)        ,
        /// <summary>
        /// Original was GL_GREEN_NV = 0x1904
        /// </summary>
        GreenNv = ((int)0x1904)        ,
        /// <summary>
        /// Original was GL_BLUE = 0x1905
        /// </summary>
        Blue = ((int)0x1905)        ,
        /// <summary>
        /// Original was GL_BLUE_NV = 0x1905
        /// </summary>
        BlueNv = ((int)0x1905)        ,
        /// <summary>
        /// Original was GL_ALPHA = 0x1906
        /// </summary>
        Alpha = ((int)0x1906)        ,
        /// <summary>
        /// Original was GL_RGB = 0x1907
        /// </summary>
        Rgb = ((int)0x1907)        ,
        /// <summary>
        /// Original was GL_RGBA = 0x1908
        /// </summary>
        Rgba = ((int)0x1908)        ,
        /// <summary>
        /// Original was GL_LUMINANCE = 0x1909
        /// </summary>
        Luminance = ((int)0x1909)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ALPHA = 0x190A
        /// </summary>
        LuminanceAlpha = ((int)0x190A)        ,
        /// <summary>
        /// Original was GL_RASTER_POSITION_UNCLIPPED_IBM = 0x19262
        /// </summary>
        RasterPositionUnclippedIbm = ((int)0x19262)        ,
        /// <summary>
        /// Original was GL_BITMAP = 0x1A00
        /// </summary>
        Bitmap = ((int)0x1A00)        ,
        /// <summary>
        /// Original was GL_PREFER_DOUBLEBUFFER_HINT_PGI = 0x1A1F8
        /// </summary>
        PreferDoublebufferHintPgi = ((int)0x1A1F8)        ,
        /// <summary>
        /// Original was GL_CONSERVE_MEMORY_HINT_PGI = 0x1A1FD
        /// </summary>
        ConserveMemoryHintPgi = ((int)0x1A1FD)        ,
        /// <summary>
        /// Original was GL_RECLAIM_MEMORY_HINT_PGI = 0x1A1FE
        /// </summary>
        ReclaimMemoryHintPgi = ((int)0x1A1FE)        ,
        /// <summary>
        /// Original was GL_NATIVE_GRAPHICS_HANDLE_PGI = 0x1A202
        /// </summary>
        NativeGraphicsHandlePgi = ((int)0x1A202)        ,
        /// <summary>
        /// Original was GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI = 0x1A203
        /// </summary>
        NativeGraphicsBeginHintPgi = ((int)0x1A203)        ,
        /// <summary>
        /// Original was GL_NATIVE_GRAPHICS_END_HINT_PGI = 0x1A204
        /// </summary>
        NativeGraphicsEndHintPgi = ((int)0x1A204)        ,
        /// <summary>
        /// Original was GL_ALWAYS_FAST_HINT_PGI = 0x1A20C
        /// </summary>
        AlwaysFastHintPgi = ((int)0x1A20C)        ,
        /// <summary>
        /// Original was GL_ALWAYS_SOFT_HINT_PGI = 0x1A20D
        /// </summary>
        AlwaysSoftHintPgi = ((int)0x1A20D)        ,
        /// <summary>
        /// Original was GL_ALLOW_DRAW_OBJ_HINT_PGI = 0x1A20E
        /// </summary>
        AllowDrawObjHintPgi = ((int)0x1A20E)        ,
        /// <summary>
        /// Original was GL_ALLOW_DRAW_WIN_HINT_PGI = 0x1A20F
        /// </summary>
        AllowDrawWinHintPgi = ((int)0x1A20F)        ,
        /// <summary>
        /// Original was GL_ALLOW_DRAW_FRG_HINT_PGI = 0x1A210
        /// </summary>
        AllowDrawFrgHintPgi = ((int)0x1A210)        ,
        /// <summary>
        /// Original was GL_ALLOW_DRAW_MEM_HINT_PGI = 0x1A211
        /// </summary>
        AllowDrawMemHintPgi = ((int)0x1A211)        ,
        /// <summary>
        /// Original was GL_STRICT_DEPTHFUNC_HINT_PGI = 0x1A216
        /// </summary>
        StrictDepthfuncHintPgi = ((int)0x1A216)        ,
        /// <summary>
        /// Original was GL_STRICT_LIGHTING_HINT_PGI = 0x1A217
        /// </summary>
        StrictLightingHintPgi = ((int)0x1A217)        ,
        /// <summary>
        /// Original was GL_STRICT_SCISSOR_HINT_PGI = 0x1A218
        /// </summary>
        StrictScissorHintPgi = ((int)0x1A218)        ,
        /// <summary>
        /// Original was GL_FULL_STIPPLE_HINT_PGI = 0x1A219
        /// </summary>
        FullStippleHintPgi = ((int)0x1A219)        ,
        /// <summary>
        /// Original was GL_CLIP_NEAR_HINT_PGI = 0x1A220
        /// </summary>
        ClipNearHintPgi = ((int)0x1A220)        ,
        /// <summary>
        /// Original was GL_CLIP_FAR_HINT_PGI = 0x1A221
        /// </summary>
        ClipFarHintPgi = ((int)0x1A221)        ,
        /// <summary>
        /// Original was GL_WIDE_LINE_HINT_PGI = 0x1A222
        /// </summary>
        WideLineHintPgi = ((int)0x1A222)        ,
        /// <summary>
        /// Original was GL_BACK_NORMALS_HINT_PGI = 0x1A223
        /// </summary>
        BackNormalsHintPgi = ((int)0x1A223)        ,
        /// <summary>
        /// Original was GL_VERTEX_DATA_HINT_PGI = 0x1A22A
        /// </summary>
        VertexDataHintPgi = ((int)0x1A22A)        ,
        /// <summary>
        /// Original was GL_VERTEX_CONSISTENT_HINT_PGI = 0x1A22B
        /// </summary>
        VertexConsistentHintPgi = ((int)0x1A22B)        ,
        /// <summary>
        /// Original was GL_MATERIAL_SIDE_HINT_PGI = 0x1A22C
        /// </summary>
        MaterialSideHintPgi = ((int)0x1A22C)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_HINT_PGI = 0x1A22D
        /// </summary>
        MaxVertexHintPgi = ((int)0x1A22D)        ,
        /// <summary>
        /// Original was GL_POINT = 0x1B00
        /// </summary>
        Point = ((int)0x1B00)        ,
        /// <summary>
        /// Original was GL_LINE = 0x1B01
        /// </summary>
        Line = ((int)0x1B01)        ,
        /// <summary>
        /// Original was GL_FILL = 0x1B02
        /// </summary>
        Fill = ((int)0x1B02)        ,
        /// <summary>
        /// Original was GL_RENDER = 0x1C00
        /// </summary>
        Render = ((int)0x1C00)        ,
        /// <summary>
        /// Original was GL_FEEDBACK = 0x1C01
        /// </summary>
        Feedback = ((int)0x1C01)        ,
        /// <summary>
        /// Original was GL_SELECT = 0x1C02
        /// </summary>
        Select = ((int)0x1C02)        ,
        /// <summary>
        /// Original was GL_FLAT = 0x1D00
        /// </summary>
        Flat = ((int)0x1D00)        ,
        /// <summary>
        /// Original was GL_SMOOTH = 0x1D01
        /// </summary>
        Smooth = ((int)0x1D01)        ,
        /// <summary>
        /// Original was GL_KEEP = 0x1E00
        /// </summary>
        Keep = ((int)0x1E00)        ,
        /// <summary>
        /// Original was GL_REPLACE = 0x1E01
        /// </summary>
        Replace = ((int)0x1E01)        ,
        /// <summary>
        /// Original was GL_INCR = 0x1E02
        /// </summary>
        Incr = ((int)0x1E02)        ,
        /// <summary>
        /// Original was GL_DECR = 0x1E03
        /// </summary>
        Decr = ((int)0x1E03)        ,
        /// <summary>
        /// Original was GL_VENDOR = 0x1F00
        /// </summary>
        Vendor = ((int)0x1F00)        ,
        /// <summary>
        /// Original was GL_RENDERER = 0x1F01
        /// </summary>
        Renderer = ((int)0x1F01)        ,
        /// <summary>
        /// Original was GL_VERSION = 0x1F02
        /// </summary>
        Version = ((int)0x1F02)        ,
        /// <summary>
        /// Original was GL_EXTENSIONS = 0x1F03
        /// </summary>
        Extensions = ((int)0x1F03)        ,
        /// <summary>
        /// Original was GL_GLYPH_VERTICAL_BEARING_X_BIT_NV = 0x20
        /// </summary>
        GlyphVerticalBearingXBitNv = ((int)0x20)        ,
        /// <summary>
        /// Original was GL_S = 0x2000
        /// </summary>
        S = ((int)0x2000)        ,
        /// <summary>
        /// Original was GL_MULTISAMPLE_BIT = 0x20000000
        /// </summary>
        MultisampleBit = ((int)0x20000000)        ,
        /// <summary>
        /// Original was GL_MULTISAMPLE_BIT_3DFX = 0x20000000
        /// </summary>
        MultisampleBit3Dfx = ((int)0x20000000)        ,
        /// <summary>
        /// Original was GL_MULTISAMPLE_BIT_ARB = 0x20000000
        /// </summary>
        MultisampleBitArb = ((int)0x20000000)        ,
        /// <summary>
        /// Original was GL_MULTISAMPLE_BIT_EXT = 0x20000000
        /// </summary>
        MultisampleBitExt = ((int)0x20000000)        ,
        /// <summary>
        /// Original was GL_TEXCOORD2_BIT_PGI = 0x20000000
        /// </summary>
        Texcoord2BitPgi = ((int)0x20000000)        ,
        /// <summary>
        /// Original was GL_T = 0x2001
        /// </summary>
        T = ((int)0x2001)        ,
        /// <summary>
        /// Original was GL_R = 0x2002
        /// </summary>
        R = ((int)0x2002)        ,
        /// <summary>
        /// Original was GL_Q = 0x2003
        /// </summary>
        Q = ((int)0x2003)        ,
        /// <summary>
        /// Original was GL_MODULATE = 0x2100
        /// </summary>
        Modulate = ((int)0x2100)        ,
        /// <summary>
        /// Original was GL_DECAL = 0x2101
        /// </summary>
        Decal = ((int)0x2101)        ,
        /// <summary>
        /// Original was GL_TEXTURE_ENV_MODE = 0x2200
        /// </summary>
        TextureEnvMode = ((int)0x2200)        ,
        /// <summary>
        /// Original was GL_TEXTURE_ENV_COLOR = 0x2201
        /// </summary>
        TextureEnvColor = ((int)0x2201)        ,
        /// <summary>
        /// Original was GL_TEXTURE_ENV = 0x2300
        /// </summary>
        TextureEnv = ((int)0x2300)        ,
        /// <summary>
        /// Original was GL_EYE_LINEAR = 0x2400
        /// </summary>
        EyeLinear = ((int)0x2400)        ,
        /// <summary>
        /// Original was GL_OBJECT_LINEAR = 0x2401
        /// </summary>
        ObjectLinear = ((int)0x2401)        ,
        /// <summary>
        /// Original was GL_SPHERE_MAP = 0x2402
        /// </summary>
        SphereMap = ((int)0x2402)        ,
        /// <summary>
        /// Original was GL_TEXTURE_GEN_MODE = 0x2500
        /// </summary>
        TextureGenMode = ((int)0x2500)        ,
        /// <summary>
        /// Original was GL_OBJECT_PLANE = 0x2501
        /// </summary>
        ObjectPlane = ((int)0x2501)        ,
        /// <summary>
        /// Original was GL_EYE_PLANE = 0x2502
        /// </summary>
        EyePlane = ((int)0x2502)        ,
        /// <summary>
        /// Original was GL_NEAREST = 0x2600
        /// </summary>
        Nearest = ((int)0x2600)        ,
        /// <summary>
        /// Original was GL_LINEAR = 0x2601
        /// </summary>
        Linear = ((int)0x2601)        ,
        /// <summary>
        /// Original was GL_NEAREST_MIPMAP_NEAREST = 0x2700
        /// </summary>
        NearestMipmapNearest = ((int)0x2700)        ,
        /// <summary>
        /// Original was GL_LINEAR_MIPMAP_NEAREST = 0x2701
        /// </summary>
        LinearMipmapNearest = ((int)0x2701)        ,
        /// <summary>
        /// Original was GL_NEAREST_MIPMAP_LINEAR = 0x2702
        /// </summary>
        NearestMipmapLinear = ((int)0x2702)        ,
        /// <summary>
        /// Original was GL_LINEAR_MIPMAP_LINEAR = 0x2703
        /// </summary>
        LinearMipmapLinear = ((int)0x2703)        ,
        /// <summary>
        /// Original was GL_TEXTURE_MAG_FILTER = 0x2800
        /// </summary>
        TextureMagFilter = ((int)0x2800)        ,
        /// <summary>
        /// Original was GL_TEXTURE_MIN_FILTER = 0x2801
        /// </summary>
        TextureMinFilter = ((int)0x2801)        ,
        /// <summary>
        /// Original was GL_TEXTURE_WRAP_S = 0x2802
        /// </summary>
        TextureWrapS = ((int)0x2802)        ,
        /// <summary>
        /// Original was GL_TEXTURE_WRAP_T = 0x2803
        /// </summary>
        TextureWrapT = ((int)0x2803)        ,
        /// <summary>
        /// Original was GL_CLAMP = 0x2900
        /// </summary>
        Clamp = ((int)0x2900)        ,
        /// <summary>
        /// Original was GL_REPEAT = 0x2901
        /// </summary>
        Repeat = ((int)0x2901)        ,
        /// <summary>
        /// Original was GL_POLYGON_OFFSET_UNITS = 0x2A00
        /// </summary>
        PolygonOffsetUnits = ((int)0x2A00)        ,
        /// <summary>
        /// Original was GL_POLYGON_OFFSET_POINT = 0x2A01
        /// </summary>
        PolygonOffsetPoint = ((int)0x2A01)        ,
        /// <summary>
        /// Original was GL_POLYGON_OFFSET_LINE = 0x2A02
        /// </summary>
        PolygonOffsetLine = ((int)0x2A02)        ,
        /// <summary>
        /// Original was GL_R3_G3_B2 = 0x2A10
        /// </summary>
        R3G3B2 = ((int)0x2A10)        ,
        /// <summary>
        /// Original was GL_V2F = 0x2A20
        /// </summary>
        V2f = ((int)0x2A20)        ,
        /// <summary>
        /// Original was GL_V3F = 0x2A21
        /// </summary>
        V3f = ((int)0x2A21)        ,
        /// <summary>
        /// Original was GL_C4UB_V2F = 0x2A22
        /// </summary>
        C4ubV2f = ((int)0x2A22)        ,
        /// <summary>
        /// Original was GL_C4UB_V3F = 0x2A23
        /// </summary>
        C4ubV3f = ((int)0x2A23)        ,
        /// <summary>
        /// Original was GL_C3F_V3F = 0x2A24
        /// </summary>
        C3fV3f = ((int)0x2A24)        ,
        /// <summary>
        /// Original was GL_N3F_V3F = 0x2A25
        /// </summary>
        N3fV3f = ((int)0x2A25)        ,
        /// <summary>
        /// Original was GL_C4F_N3F_V3F = 0x2A26
        /// </summary>
        C4fN3fV3f = ((int)0x2A26)        ,
        /// <summary>
        /// Original was GL_T2F_V3F = 0x2A27
        /// </summary>
        T2fV3f = ((int)0x2A27)        ,
        /// <summary>
        /// Original was GL_T4F_V4F = 0x2A28
        /// </summary>
        T4fV4f = ((int)0x2A28)        ,
        /// <summary>
        /// Original was GL_T2F_C4UB_V3F = 0x2A29
        /// </summary>
        T2fC4ubV3f = ((int)0x2A29)        ,
        /// <summary>
        /// Original was GL_T2F_C3F_V3F = 0x2A2A
        /// </summary>
        T2fC3fV3f = ((int)0x2A2A)        ,
        /// <summary>
        /// Original was GL_T2F_N3F_V3F = 0x2A2B
        /// </summary>
        T2fN3fV3f = ((int)0x2A2B)        ,
        /// <summary>
        /// Original was GL_T2F_C4F_N3F_V3F = 0x2A2C
        /// </summary>
        T2fC4fN3fV3f = ((int)0x2A2C)        ,
        /// <summary>
        /// Original was GL_T4F_C4F_N3F_V4F = 0x2A2D
        /// </summary>
        T4fC4fN3fV4f = ((int)0x2A2D)        ,
        /// <summary>
        /// Original was GL_CLIP_DISTANCE0 = 0x3000
        /// </summary>
        ClipDistance0 = ((int)0x3000)        ,
        /// <summary>
        /// Original was GL_CLIP_PLANE0 = 0x3000
        /// </summary>
        ClipPlane0 = ((int)0x3000)        ,
        /// <summary>
        /// Original was GL_CLIP_DISTANCE1 = 0x3001
        /// </summary>
        ClipDistance1 = ((int)0x3001)        ,
        /// <summary>
        /// Original was GL_CLIP_PLANE1 = 0x3001
        /// </summary>
        ClipPlane1 = ((int)0x3001)        ,
        /// <summary>
        /// Original was GL_CLIP_DISTANCE2 = 0x3002
        /// </summary>
        ClipDistance2 = ((int)0x3002)        ,
        /// <summary>
        /// Original was GL_CLIP_PLANE2 = 0x3002
        /// </summary>
        ClipPlane2 = ((int)0x3002)        ,
        /// <summary>
        /// Original was GL_CLIP_DISTANCE3 = 0x3003
        /// </summary>
        ClipDistance3 = ((int)0x3003)        ,
        /// <summary>
        /// Original was GL_CLIP_PLANE3 = 0x3003
        /// </summary>
        ClipPlane3 = ((int)0x3003)        ,
        /// <summary>
        /// Original was GL_CLIP_DISTANCE4 = 0x3004
        /// </summary>
        ClipDistance4 = ((int)0x3004)        ,
        /// <summary>
        /// Original was GL_CLIP_PLANE4 = 0x3004
        /// </summary>
        ClipPlane4 = ((int)0x3004)        ,
        /// <summary>
        /// Original was GL_CLIP_DISTANCE5 = 0x3005
        /// </summary>
        ClipDistance5 = ((int)0x3005)        ,
        /// <summary>
        /// Original was GL_CLIP_PLANE5 = 0x3005
        /// </summary>
        ClipPlane5 = ((int)0x3005)        ,
        /// <summary>
        /// Original was GL_CLIP_DISTANCE6 = 0x3006
        /// </summary>
        ClipDistance6 = ((int)0x3006)        ,
        /// <summary>
        /// Original was GL_CLIP_DISTANCE7 = 0x3007
        /// </summary>
        ClipDistance7 = ((int)0x3007)        ,
        /// <summary>
        /// Original was GL_GLYPH_VERTICAL_BEARING_Y_BIT_NV = 0x40
        /// </summary>
        GlyphVerticalBearingYBitNv = ((int)0x40)        ,
        /// <summary>
        /// Original was GL_LIGHT0 = 0x4000
        /// </summary>
        Light0 = ((int)0x4000)        ,
        /// <summary>
        /// Original was GL_TEXCOORD3_BIT_PGI = 0x40000000
        /// </summary>
        Texcoord3BitPgi = ((int)0x40000000)        ,
        /// <summary>
        /// Original was GL_LIGHT1 = 0x4001
        /// </summary>
        Light1 = ((int)0x4001)        ,
        /// <summary>
        /// Original was GL_LIGHT2 = 0x4002
        /// </summary>
        Light2 = ((int)0x4002)        ,
        /// <summary>
        /// Original was GL_LIGHT3 = 0x4003
        /// </summary>
        Light3 = ((int)0x4003)        ,
        /// <summary>
        /// Original was GL_LIGHT4 = 0x4004
        /// </summary>
        Light4 = ((int)0x4004)        ,
        /// <summary>
        /// Original was GL_LIGHT5 = 0x4005
        /// </summary>
        Light5 = ((int)0x4005)        ,
        /// <summary>
        /// Original was GL_LIGHT6 = 0x4006
        /// </summary>
        Light6 = ((int)0x4006)        ,
        /// <summary>
        /// Original was GL_LIGHT7 = 0x4007
        /// </summary>
        Light7 = ((int)0x4007)        ,
        /// <summary>
        /// Original was GL_GLYPH_VERTICAL_BEARING_ADVANCE_BIT_NV = 0x80
        /// </summary>
        GlyphVerticalBearingAdvanceBitNv = ((int)0x80)        ,
        /// <summary>
        /// Original was GL_ABGR_EXT = 0x8000
        /// </summary>
        AbgrExt = ((int)0x8000)        ,
        /// <summary>
        /// Original was GL_TEXCOORD4_BIT_PGI = 0x80000000
        /// </summary>
        Texcoord4BitPgi = unchecked((int)0x80000000)        ,
        /// <summary>
        /// Original was GL_CONSTANT_COLOR = 0x8001
        /// </summary>
        ConstantColor = ((int)0x8001)        ,
        /// <summary>
        /// Original was GL_CONSTANT_COLOR_EXT = 0x8001
        /// </summary>
        ConstantColorExt = ((int)0x8001)        ,
        /// <summary>
        /// Original was GL_ONE_MINUS_CONSTANT_COLOR = 0x8002
        /// </summary>
        OneMinusConstantColor = ((int)0x8002)        ,
        /// <summary>
        /// Original was GL_ONE_MINUS_CONSTANT_COLOR_EXT = 0x8002
        /// </summary>
        OneMinusConstantColorExt = ((int)0x8002)        ,
        /// <summary>
        /// Original was GL_CONSTANT_ALPHA = 0x8003
        /// </summary>
        ConstantAlpha = ((int)0x8003)        ,
        /// <summary>
        /// Original was GL_CONSTANT_ALPHA_EXT = 0x8003
        /// </summary>
        ConstantAlphaExt = ((int)0x8003)        ,
        /// <summary>
        /// Original was GL_ONE_MINUS_CONSTANT_ALPHA = 0x8004
        /// </summary>
        OneMinusConstantAlpha = ((int)0x8004)        ,
        /// <summary>
        /// Original was GL_ONE_MINUS_CONSTANT_ALPHA_EXT = 0x8004
        /// </summary>
        OneMinusConstantAlphaExt = ((int)0x8004)        ,
        /// <summary>
        /// Original was GL_BLEND_COLOR = 0x8005
        /// </summary>
        BlendColor = ((int)0x8005)        ,
        /// <summary>
        /// Original was GL_BLEND_COLOR_EXT = 0x8005
        /// </summary>
        BlendColorExt = ((int)0x8005)        ,
        /// <summary>
        /// Original was GL_FUNC_ADD = 0x8006
        /// </summary>
        FuncAdd = ((int)0x8006)        ,
        /// <summary>
        /// Original was GL_FUNC_ADD_EXT = 0x8006
        /// </summary>
        FuncAddExt = ((int)0x8006)        ,
        /// <summary>
        /// Original was GL_MIN = 0x8007
        /// </summary>
        Min = ((int)0x8007)        ,
        /// <summary>
        /// Original was GL_MIN_EXT = 0x8007
        /// </summary>
        MinExt = ((int)0x8007)        ,
        /// <summary>
        /// Original was GL_MAX = 0x8008
        /// </summary>
        Max = ((int)0x8008)        ,
        /// <summary>
        /// Original was GL_MAX_EXT = 0x8008
        /// </summary>
        MaxExt = ((int)0x8008)        ,
        /// <summary>
        /// Original was GL_BLEND_EQUATION = 0x8009
        /// </summary>
        BlendEquation = ((int)0x8009)        ,
        /// <summary>
        /// Original was GL_BLEND_EQUATION_EXT = 0x8009
        /// </summary>
        BlendEquationExt = ((int)0x8009)        ,
        /// <summary>
        /// Original was GL_BLEND_EQUATION_RGB = 0x8009
        /// </summary>
        BlendEquationRgb = ((int)0x8009)        ,
        /// <summary>
        /// Original was GL_BLEND_EQUATION_RGB_EXT = 0x8009
        /// </summary>
        BlendEquationRgbExt = ((int)0x8009)        ,
        /// <summary>
        /// Original was GL_FUNC_SUBTRACT = 0x800A
        /// </summary>
        FuncSubtract = ((int)0x800A)        ,
        /// <summary>
        /// Original was GL_FUNC_SUBTRACT_EXT = 0x800A
        /// </summary>
        FuncSubtractExt = ((int)0x800A)        ,
        /// <summary>
        /// Original was GL_FUNC_REVERSE_SUBTRACT = 0x800B
        /// </summary>
        FuncReverseSubtract = ((int)0x800B)        ,
        /// <summary>
        /// Original was GL_FUNC_REVERSE_SUBTRACT_EXT = 0x800B
        /// </summary>
        FuncReverseSubtractExt = ((int)0x800B)        ,
        /// <summary>
        /// Original was GL_CMYK_EXT = 0x800C
        /// </summary>
        CmykExt = ((int)0x800C)        ,
        /// <summary>
        /// Original was GL_CMYKA_EXT = 0x800D
        /// </summary>
        CmykaExt = ((int)0x800D)        ,
        /// <summary>
        /// Original was GL_PACK_CMYK_HINT_EXT = 0x800E
        /// </summary>
        PackCmykHintExt = ((int)0x800E)        ,
        /// <summary>
        /// Original was GL_UNPACK_CMYK_HINT_EXT = 0x800F
        /// </summary>
        UnpackCmykHintExt = ((int)0x800F)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_1D = 0x8010
        /// </summary>
        Convolution1D = ((int)0x8010)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_1D_EXT = 0x8010
        /// </summary>
        Convolution1DExt = ((int)0x8010)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_2D = 0x8011
        /// </summary>
        Convolution2D = ((int)0x8011)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_2D_EXT = 0x8011
        /// </summary>
        Convolution2DExt = ((int)0x8011)        ,
        /// <summary>
        /// Original was GL_SEPARABLE_2D = 0x8012
        /// </summary>
        Separable2D = ((int)0x8012)        ,
        /// <summary>
        /// Original was GL_SEPARABLE_2D_EXT = 0x8012
        /// </summary>
        Separable2DExt = ((int)0x8012)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_BORDER_MODE = 0x8013
        /// </summary>
        ConvolutionBorderMode = ((int)0x8013)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_BORDER_MODE_EXT = 0x8013
        /// </summary>
        ConvolutionBorderModeExt = ((int)0x8013)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_FILTER_SCALE = 0x8014
        /// </summary>
        ConvolutionFilterScale = ((int)0x8014)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_FILTER_SCALE_EXT = 0x8014
        /// </summary>
        ConvolutionFilterScaleExt = ((int)0x8014)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_FILTER_BIAS = 0x8015
        /// </summary>
        ConvolutionFilterBias = ((int)0x8015)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_FILTER_BIAS_EXT = 0x8015
        /// </summary>
        ConvolutionFilterBiasExt = ((int)0x8015)        ,
        /// <summary>
        /// Original was GL_REDUCE = 0x8016
        /// </summary>
        Reduce = ((int)0x8016)        ,
        /// <summary>
        /// Original was GL_REDUCE_EXT = 0x8016
        /// </summary>
        ReduceExt = ((int)0x8016)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_FORMAT = 0x8017
        /// </summary>
        ConvolutionFormat = ((int)0x8017)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_FORMAT_EXT = 0x8017
        /// </summary>
        ConvolutionFormatExt = ((int)0x8017)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_WIDTH = 0x8018
        /// </summary>
        ConvolutionWidth = ((int)0x8018)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_WIDTH_EXT = 0x8018
        /// </summary>
        ConvolutionWidthExt = ((int)0x8018)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_HEIGHT = 0x8019
        /// </summary>
        ConvolutionHeight = ((int)0x8019)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_HEIGHT_EXT = 0x8019
        /// </summary>
        ConvolutionHeightExt = ((int)0x8019)        ,
        /// <summary>
        /// Original was GL_MAX_CONVOLUTION_WIDTH = 0x801A
        /// </summary>
        MaxConvolutionWidth = ((int)0x801A)        ,
        /// <summary>
        /// Original was GL_MAX_CONVOLUTION_WIDTH_EXT = 0x801A
        /// </summary>
        MaxConvolutionWidthExt = ((int)0x801A)        ,
        /// <summary>
        /// Original was GL_MAX_CONVOLUTION_HEIGHT = 0x801B
        /// </summary>
        MaxConvolutionHeight = ((int)0x801B)        ,
        /// <summary>
        /// Original was GL_MAX_CONVOLUTION_HEIGHT_EXT = 0x801B
        /// </summary>
        MaxConvolutionHeightExt = ((int)0x801B)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_RED_SCALE = 0x801C
        /// </summary>
        PostConvolutionRedScale = ((int)0x801C)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_RED_SCALE_EXT = 0x801C
        /// </summary>
        PostConvolutionRedScaleExt = ((int)0x801C)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_GREEN_SCALE = 0x801D
        /// </summary>
        PostConvolutionGreenScale = ((int)0x801D)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_GREEN_SCALE_EXT = 0x801D
        /// </summary>
        PostConvolutionGreenScaleExt = ((int)0x801D)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_BLUE_SCALE = 0x801E
        /// </summary>
        PostConvolutionBlueScale = ((int)0x801E)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_BLUE_SCALE_EXT = 0x801E
        /// </summary>
        PostConvolutionBlueScaleExt = ((int)0x801E)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_ALPHA_SCALE = 0x801F
        /// </summary>
        PostConvolutionAlphaScale = ((int)0x801F)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_ALPHA_SCALE_EXT = 0x801F
        /// </summary>
        PostConvolutionAlphaScaleExt = ((int)0x801F)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_RED_BIAS = 0x8020
        /// </summary>
        PostConvolutionRedBias = ((int)0x8020)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_RED_BIAS_EXT = 0x8020
        /// </summary>
        PostConvolutionRedBiasExt = ((int)0x8020)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_GREEN_BIAS = 0x8021
        /// </summary>
        PostConvolutionGreenBias = ((int)0x8021)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_GREEN_BIAS_EXT = 0x8021
        /// </summary>
        PostConvolutionGreenBiasExt = ((int)0x8021)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_BLUE_BIAS = 0x8022
        /// </summary>
        PostConvolutionBlueBias = ((int)0x8022)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_BLUE_BIAS_EXT = 0x8022
        /// </summary>
        PostConvolutionBlueBiasExt = ((int)0x8022)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_ALPHA_BIAS = 0x8023
        /// </summary>
        PostConvolutionAlphaBias = ((int)0x8023)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_ALPHA_BIAS_EXT = 0x8023
        /// </summary>
        PostConvolutionAlphaBiasExt = ((int)0x8023)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM = 0x8024
        /// </summary>
        Histogram = ((int)0x8024)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_EXT = 0x8024
        /// </summary>
        HistogramExt = ((int)0x8024)        ,
        /// <summary>
        /// Original was GL_PROXY_HISTOGRAM = 0x8025
        /// </summary>
        ProxyHistogram = ((int)0x8025)        ,
        /// <summary>
        /// Original was GL_PROXY_HISTOGRAM_EXT = 0x8025
        /// </summary>
        ProxyHistogramExt = ((int)0x8025)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_WIDTH = 0x8026
        /// </summary>
        HistogramWidth = ((int)0x8026)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_WIDTH_EXT = 0x8026
        /// </summary>
        HistogramWidthExt = ((int)0x8026)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_FORMAT = 0x8027
        /// </summary>
        HistogramFormat = ((int)0x8027)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_FORMAT_EXT = 0x8027
        /// </summary>
        HistogramFormatExt = ((int)0x8027)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_RED_SIZE = 0x8028
        /// </summary>
        HistogramRedSize = ((int)0x8028)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_RED_SIZE_EXT = 0x8028
        /// </summary>
        HistogramRedSizeExt = ((int)0x8028)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_GREEN_SIZE = 0x8029
        /// </summary>
        HistogramGreenSize = ((int)0x8029)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_GREEN_SIZE_EXT = 0x8029
        /// </summary>
        HistogramGreenSizeExt = ((int)0x8029)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_BLUE_SIZE = 0x802A
        /// </summary>
        HistogramBlueSize = ((int)0x802A)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_BLUE_SIZE_EXT = 0x802A
        /// </summary>
        HistogramBlueSizeExt = ((int)0x802A)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_ALPHA_SIZE = 0x802B
        /// </summary>
        HistogramAlphaSize = ((int)0x802B)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_ALPHA_SIZE_EXT = 0x802B
        /// </summary>
        HistogramAlphaSizeExt = ((int)0x802B)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_LUMINANCE_SIZE = 0x802C
        /// </summary>
        HistogramLuminanceSize = ((int)0x802C)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_LUMINANCE_SIZE_EXT = 0x802C
        /// </summary>
        HistogramLuminanceSizeExt = ((int)0x802C)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_SINK = 0x802D
        /// </summary>
        HistogramSink = ((int)0x802D)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_SINK_EXT = 0x802D
        /// </summary>
        HistogramSinkExt = ((int)0x802D)        ,
        /// <summary>
        /// Original was GL_MINMAX = 0x802E
        /// </summary>
        Minmax = ((int)0x802E)        ,
        /// <summary>
        /// Original was GL_MINMAX_EXT = 0x802E
        /// </summary>
        MinmaxExt = ((int)0x802E)        ,
        /// <summary>
        /// Original was GL_MINMAX_FORMAT = 0x802F
        /// </summary>
        MinmaxFormat = ((int)0x802F)        ,
        /// <summary>
        /// Original was GL_MINMAX_FORMAT_EXT = 0x802F
        /// </summary>
        MinmaxFormatExt = ((int)0x802F)        ,
        /// <summary>
        /// Original was GL_MINMAX_SINK = 0x8030
        /// </summary>
        MinmaxSink = ((int)0x8030)        ,
        /// <summary>
        /// Original was GL_MINMAX_SINK_EXT = 0x8030
        /// </summary>
        MinmaxSinkExt = ((int)0x8030)        ,
        /// <summary>
        /// Original was GL_TABLE_TOO_LARGE = 0x8031
        /// </summary>
        TableTooLarge = ((int)0x8031)        ,
        /// <summary>
        /// Original was GL_TABLE_TOO_LARGE_EXT = 0x8031
        /// </summary>
        TableTooLargeExt = ((int)0x8031)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_BYTE_3_3_2 = 0x8032
        /// </summary>
        UnsignedByte332 = ((int)0x8032)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_BYTE_3_3_2_EXT = 0x8032
        /// </summary>
        UnsignedByte332Ext = ((int)0x8032)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_SHORT_4_4_4_4 = 0x8033
        /// </summary>
        UnsignedShort4444 = ((int)0x8033)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_SHORT_4_4_4_4_EXT = 0x8033
        /// </summary>
        UnsignedShort4444Ext = ((int)0x8033)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_SHORT_5_5_5_1 = 0x8034
        /// </summary>
        UnsignedShort5551 = ((int)0x8034)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_SHORT_5_5_5_1_EXT = 0x8034
        /// </summary>
        UnsignedShort5551Ext = ((int)0x8034)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_8_8_8_8 = 0x8035
        /// </summary>
        UnsignedInt8888 = ((int)0x8035)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_8_8_8_8_EXT = 0x8035
        /// </summary>
        UnsignedInt8888Ext = ((int)0x8035)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_10_10_10_2 = 0x8036
        /// </summary>
        UnsignedInt1010102 = ((int)0x8036)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_10_10_10_2_EXT = 0x8036
        /// </summary>
        UnsignedInt1010102Ext = ((int)0x8036)        ,
        /// <summary>
        /// Original was GL_POLYGON_OFFSET_EXT = 0x8037
        /// </summary>
        PolygonOffsetExt = ((int)0x8037)        ,
        /// <summary>
        /// Original was GL_POLYGON_OFFSET_FILL = 0x8037
        /// </summary>
        PolygonOffsetFill = ((int)0x8037)        ,
        /// <summary>
        /// Original was GL_POLYGON_OFFSET_FACTOR = 0x8038
        /// </summary>
        PolygonOffsetFactor = ((int)0x8038)        ,
        /// <summary>
        /// Original was GL_POLYGON_OFFSET_FACTOR_EXT = 0x8038
        /// </summary>
        PolygonOffsetFactorExt = ((int)0x8038)        ,
        /// <summary>
        /// Original was GL_POLYGON_OFFSET_BIAS_EXT = 0x8039
        /// </summary>
        PolygonOffsetBiasExt = ((int)0x8039)        ,
        /// <summary>
        /// Original was GL_RESCALE_NORMAL = 0x803A
        /// </summary>
        RescaleNormal = ((int)0x803A)        ,
        /// <summary>
        /// Original was GL_RESCALE_NORMAL_EXT = 0x803A
        /// </summary>
        RescaleNormalExt = ((int)0x803A)        ,
        /// <summary>
        /// Original was GL_ALPHA4 = 0x803B
        /// </summary>
        Alpha4 = ((int)0x803B)        ,
        /// <summary>
        /// Original was GL_ALPHA4_EXT = 0x803B
        /// </summary>
        Alpha4Ext = ((int)0x803B)        ,
        /// <summary>
        /// Original was GL_ALPHA8 = 0x803C
        /// </summary>
        Alpha8 = ((int)0x803C)        ,
        /// <summary>
        /// Original was GL_ALPHA8_EXT = 0x803C
        /// </summary>
        Alpha8Ext = ((int)0x803C)        ,
        /// <summary>
        /// Original was GL_ALPHA12 = 0x803D
        /// </summary>
        Alpha12 = ((int)0x803D)        ,
        /// <summary>
        /// Original was GL_ALPHA12_EXT = 0x803D
        /// </summary>
        Alpha12Ext = ((int)0x803D)        ,
        /// <summary>
        /// Original was GL_ALPHA16 = 0x803E
        /// </summary>
        Alpha16 = ((int)0x803E)        ,
        /// <summary>
        /// Original was GL_ALPHA16_EXT = 0x803E
        /// </summary>
        Alpha16Ext = ((int)0x803E)        ,
        /// <summary>
        /// Original was GL_LUMINANCE4 = 0x803F
        /// </summary>
        Luminance4 = ((int)0x803F)        ,
        /// <summary>
        /// Original was GL_LUMINANCE4_EXT = 0x803F
        /// </summary>
        Luminance4Ext = ((int)0x803F)        ,
        /// <summary>
        /// Original was GL_LUMINANCE8 = 0x8040
        /// </summary>
        Luminance8 = ((int)0x8040)        ,
        /// <summary>
        /// Original was GL_LUMINANCE8_EXT = 0x8040
        /// </summary>
        Luminance8Ext = ((int)0x8040)        ,
        /// <summary>
        /// Original was GL_LUMINANCE12 = 0x8041
        /// </summary>
        Luminance12 = ((int)0x8041)        ,
        /// <summary>
        /// Original was GL_LUMINANCE12_EXT = 0x8041
        /// </summary>
        Luminance12Ext = ((int)0x8041)        ,
        /// <summary>
        /// Original was GL_LUMINANCE16 = 0x8042
        /// </summary>
        Luminance16 = ((int)0x8042)        ,
        /// <summary>
        /// Original was GL_LUMINANCE16_EXT = 0x8042
        /// </summary>
        Luminance16Ext = ((int)0x8042)        ,
        /// <summary>
        /// Original was GL_LUMINANCE4_ALPHA4 = 0x8043
        /// </summary>
        Luminance4Alpha4 = ((int)0x8043)        ,
        /// <summary>
        /// Original was GL_LUMINANCE4_ALPHA4_EXT = 0x8043
        /// </summary>
        Luminance4Alpha4Ext = ((int)0x8043)        ,
        /// <summary>
        /// Original was GL_LUMINANCE6_ALPHA2 = 0x8044
        /// </summary>
        Luminance6Alpha2 = ((int)0x8044)        ,
        /// <summary>
        /// Original was GL_LUMINANCE6_ALPHA2_EXT = 0x8044
        /// </summary>
        Luminance6Alpha2Ext = ((int)0x8044)        ,
        /// <summary>
        /// Original was GL_LUMINANCE8_ALPHA8 = 0x8045
        /// </summary>
        Luminance8Alpha8 = ((int)0x8045)        ,
        /// <summary>
        /// Original was GL_LUMINANCE8_ALPHA8_EXT = 0x8045
        /// </summary>
        Luminance8Alpha8Ext = ((int)0x8045)        ,
        /// <summary>
        /// Original was GL_LUMINANCE12_ALPHA4 = 0x8046
        /// </summary>
        Luminance12Alpha4 = ((int)0x8046)        ,
        /// <summary>
        /// Original was GL_LUMINANCE12_ALPHA4_EXT = 0x8046
        /// </summary>
        Luminance12Alpha4Ext = ((int)0x8046)        ,
        /// <summary>
        /// Original was GL_LUMINANCE12_ALPHA12 = 0x8047
        /// </summary>
        Luminance12Alpha12 = ((int)0x8047)        ,
        /// <summary>
        /// Original was GL_LUMINANCE12_ALPHA12_EXT = 0x8047
        /// </summary>
        Luminance12Alpha12Ext = ((int)0x8047)        ,
        /// <summary>
        /// Original was GL_LUMINANCE16_ALPHA16 = 0x8048
        /// </summary>
        Luminance16Alpha16 = ((int)0x8048)        ,
        /// <summary>
        /// Original was GL_LUMINANCE16_ALPHA16_EXT = 0x8048
        /// </summary>
        Luminance16Alpha16Ext = ((int)0x8048)        ,
        /// <summary>
        /// Original was GL_INTENSITY = 0x8049
        /// </summary>
        Intensity = ((int)0x8049)        ,
        /// <summary>
        /// Original was GL_INTENSITY_EXT = 0x8049
        /// </summary>
        IntensityExt = ((int)0x8049)        ,
        /// <summary>
        /// Original was GL_INTENSITY4 = 0x804A
        /// </summary>
        Intensity4 = ((int)0x804A)        ,
        /// <summary>
        /// Original was GL_INTENSITY4_EXT = 0x804A
        /// </summary>
        Intensity4Ext = ((int)0x804A)        ,
        /// <summary>
        /// Original was GL_INTENSITY8 = 0x804B
        /// </summary>
        Intensity8 = ((int)0x804B)        ,
        /// <summary>
        /// Original was GL_INTENSITY8_EXT = 0x804B
        /// </summary>
        Intensity8Ext = ((int)0x804B)        ,
        /// <summary>
        /// Original was GL_INTENSITY12 = 0x804C
        /// </summary>
        Intensity12 = ((int)0x804C)        ,
        /// <summary>
        /// Original was GL_INTENSITY12_EXT = 0x804C
        /// </summary>
        Intensity12Ext = ((int)0x804C)        ,
        /// <summary>
        /// Original was GL_INTENSITY16 = 0x804D
        /// </summary>
        Intensity16 = ((int)0x804D)        ,
        /// <summary>
        /// Original was GL_INTENSITY16_EXT = 0x804D
        /// </summary>
        Intensity16Ext = ((int)0x804D)        ,
        /// <summary>
        /// Original was GL_RGB2_EXT = 0x804E
        /// </summary>
        Rgb2Ext = ((int)0x804E)        ,
        /// <summary>
        /// Original was GL_RGB4 = 0x804F
        /// </summary>
        Rgb4 = ((int)0x804F)        ,
        /// <summary>
        /// Original was GL_RGB4_EXT = 0x804F
        /// </summary>
        Rgb4Ext = ((int)0x804F)        ,
        /// <summary>
        /// Original was GL_RGB5 = 0x8050
        /// </summary>
        Rgb5 = ((int)0x8050)        ,
        /// <summary>
        /// Original was GL_RGB5_EXT = 0x8050
        /// </summary>
        Rgb5Ext = ((int)0x8050)        ,
        /// <summary>
        /// Original was GL_RGB8 = 0x8051
        /// </summary>
        Rgb8 = ((int)0x8051)        ,
        /// <summary>
        /// Original was GL_RGB8_EXT = 0x8051
        /// </summary>
        Rgb8Ext = ((int)0x8051)        ,
        /// <summary>
        /// Original was GL_RGB10 = 0x8052
        /// </summary>
        Rgb10 = ((int)0x8052)        ,
        /// <summary>
        /// Original was GL_RGB10_EXT = 0x8052
        /// </summary>
        Rgb10Ext = ((int)0x8052)        ,
        /// <summary>
        /// Original was GL_RGB12 = 0x8053
        /// </summary>
        Rgb12 = ((int)0x8053)        ,
        /// <summary>
        /// Original was GL_RGB12_EXT = 0x8053
        /// </summary>
        Rgb12Ext = ((int)0x8053)        ,
        /// <summary>
        /// Original was GL_RGB16 = 0x8054
        /// </summary>
        Rgb16 = ((int)0x8054)        ,
        /// <summary>
        /// Original was GL_RGB16_EXT = 0x8054
        /// </summary>
        Rgb16Ext = ((int)0x8054)        ,
        /// <summary>
        /// Original was GL_RGBA2 = 0x8055
        /// </summary>
        Rgba2 = ((int)0x8055)        ,
        /// <summary>
        /// Original was GL_RGBA2_EXT = 0x8055
        /// </summary>
        Rgba2Ext = ((int)0x8055)        ,
        /// <summary>
        /// Original was GL_RGBA4 = 0x8056
        /// </summary>
        Rgba4 = ((int)0x8056)        ,
        /// <summary>
        /// Original was GL_RGBA4_EXT = 0x8056
        /// </summary>
        Rgba4Ext = ((int)0x8056)        ,
        /// <summary>
        /// Original was GL_RGB5_A1 = 0x8057
        /// </summary>
        Rgb5A1 = ((int)0x8057)        ,
        /// <summary>
        /// Original was GL_RGB5_A1_EXT = 0x8057
        /// </summary>
        Rgb5A1Ext = ((int)0x8057)        ,
        /// <summary>
        /// Original was GL_RGBA8 = 0x8058
        /// </summary>
        Rgba8 = ((int)0x8058)        ,
        /// <summary>
        /// Original was GL_RGBA8_EXT = 0x8058
        /// </summary>
        Rgba8Ext = ((int)0x8058)        ,
        /// <summary>
        /// Original was GL_RGB10_A2 = 0x8059
        /// </summary>
        Rgb10A2 = ((int)0x8059)        ,
        /// <summary>
        /// Original was GL_RGB10_A2_EXT = 0x8059
        /// </summary>
        Rgb10A2Ext = ((int)0x8059)        ,
        /// <summary>
        /// Original was GL_RGBA12 = 0x805A
        /// </summary>
        Rgba12 = ((int)0x805A)        ,
        /// <summary>
        /// Original was GL_RGBA12_EXT = 0x805A
        /// </summary>
        Rgba12Ext = ((int)0x805A)        ,
        /// <summary>
        /// Original was GL_RGBA16 = 0x805B
        /// </summary>
        Rgba16 = ((int)0x805B)        ,
        /// <summary>
        /// Original was GL_RGBA16_EXT = 0x805B
        /// </summary>
        Rgba16Ext = ((int)0x805B)        ,
        /// <summary>
        /// Original was GL_TEXTURE_RED_SIZE = 0x805C
        /// </summary>
        TextureRedSize = ((int)0x805C)        ,
        /// <summary>
        /// Original was GL_TEXTURE_RED_SIZE_EXT = 0x805C
        /// </summary>
        TextureRedSizeExt = ((int)0x805C)        ,
        /// <summary>
        /// Original was GL_TEXTURE_GREEN_SIZE = 0x805D
        /// </summary>
        TextureGreenSize = ((int)0x805D)        ,
        /// <summary>
        /// Original was GL_TEXTURE_GREEN_SIZE_EXT = 0x805D
        /// </summary>
        TextureGreenSizeExt = ((int)0x805D)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BLUE_SIZE = 0x805E
        /// </summary>
        TextureBlueSize = ((int)0x805E)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BLUE_SIZE_EXT = 0x805E
        /// </summary>
        TextureBlueSizeExt = ((int)0x805E)        ,
        /// <summary>
        /// Original was GL_TEXTURE_ALPHA_SIZE = 0x805F
        /// </summary>
        TextureAlphaSize = ((int)0x805F)        ,
        /// <summary>
        /// Original was GL_TEXTURE_ALPHA_SIZE_EXT = 0x805F
        /// </summary>
        TextureAlphaSizeExt = ((int)0x805F)        ,
        /// <summary>
        /// Original was GL_TEXTURE_LUMINANCE_SIZE = 0x8060
        /// </summary>
        TextureLuminanceSize = ((int)0x8060)        ,
        /// <summary>
        /// Original was GL_TEXTURE_LUMINANCE_SIZE_EXT = 0x8060
        /// </summary>
        TextureLuminanceSizeExt = ((int)0x8060)        ,
        /// <summary>
        /// Original was GL_TEXTURE_INTENSITY_SIZE = 0x8061
        /// </summary>
        TextureIntensitySize = ((int)0x8061)        ,
        /// <summary>
        /// Original was GL_TEXTURE_INTENSITY_SIZE_EXT = 0x8061
        /// </summary>
        TextureIntensitySizeExt = ((int)0x8061)        ,
        /// <summary>
        /// Original was GL_REPLACE_EXT = 0x8062
        /// </summary>
        ReplaceExt = ((int)0x8062)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_1D = 0x8063
        /// </summary>
        ProxyTexture1D = ((int)0x8063)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_1D_EXT = 0x8063
        /// </summary>
        ProxyTexture1DExt = ((int)0x8063)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_2D = 0x8064
        /// </summary>
        ProxyTexture2D = ((int)0x8064)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_2D_EXT = 0x8064
        /// </summary>
        ProxyTexture2DExt = ((int)0x8064)        ,
        /// <summary>
        /// Original was GL_TEXTURE_TOO_LARGE_EXT = 0x8065
        /// </summary>
        TextureTooLargeExt = ((int)0x8065)        ,
        /// <summary>
        /// Original was GL_TEXTURE_PRIORITY = 0x8066
        /// </summary>
        TexturePriority = ((int)0x8066)        ,
        /// <summary>
        /// Original was GL_TEXTURE_PRIORITY_EXT = 0x8066
        /// </summary>
        TexturePriorityExt = ((int)0x8066)        ,
        /// <summary>
        /// Original was GL_TEXTURE_RESIDENT = 0x8067
        /// </summary>
        TextureResident = ((int)0x8067)        ,
        /// <summary>
        /// Original was GL_TEXTURE_RESIDENT_EXT = 0x8067
        /// </summary>
        TextureResidentExt = ((int)0x8067)        ,
        /// <summary>
        /// Original was GL_TEXTURE_1D_BINDING_EXT = 0x8068
        /// </summary>
        Texture1DBindingExt = ((int)0x8068)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_1D = 0x8068
        /// </summary>
        TextureBinding1D = ((int)0x8068)        ,
        /// <summary>
        /// Original was GL_TEXTURE_2D_BINDING_EXT = 0x8069
        /// </summary>
        Texture2DBindingExt = ((int)0x8069)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_2D = 0x8069
        /// </summary>
        TextureBinding2D = ((int)0x8069)        ,
        /// <summary>
        /// Original was GL_TEXTURE_3D_BINDING_EXT = 0x806A
        /// </summary>
        Texture3DBindingExt = ((int)0x806A)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_3D = 0x806A
        /// </summary>
        TextureBinding3D = ((int)0x806A)        ,
        /// <summary>
        /// Original was GL_PACK_SKIP_IMAGES = 0x806B
        /// </summary>
        PackSkipImages = ((int)0x806B)        ,
        /// <summary>
        /// Original was GL_PACK_SKIP_IMAGES_EXT = 0x806B
        /// </summary>
        PackSkipImagesExt = ((int)0x806B)        ,
        /// <summary>
        /// Original was GL_PACK_IMAGE_HEIGHT = 0x806C
        /// </summary>
        PackImageHeight = ((int)0x806C)        ,
        /// <summary>
        /// Original was GL_PACK_IMAGE_HEIGHT_EXT = 0x806C
        /// </summary>
        PackImageHeightExt = ((int)0x806C)        ,
        /// <summary>
        /// Original was GL_UNPACK_SKIP_IMAGES = 0x806D
        /// </summary>
        UnpackSkipImages = ((int)0x806D)        ,
        /// <summary>
        /// Original was GL_UNPACK_SKIP_IMAGES_EXT = 0x806D
        /// </summary>
        UnpackSkipImagesExt = ((int)0x806D)        ,
        /// <summary>
        /// Original was GL_UNPACK_IMAGE_HEIGHT = 0x806E
        /// </summary>
        UnpackImageHeight = ((int)0x806E)        ,
        /// <summary>
        /// Original was GL_UNPACK_IMAGE_HEIGHT_EXT = 0x806E
        /// </summary>
        UnpackImageHeightExt = ((int)0x806E)        ,
        /// <summary>
        /// Original was GL_TEXTURE_3D = 0x806F
        /// </summary>
        Texture3D = ((int)0x806F)        ,
        /// <summary>
        /// Original was GL_TEXTURE_3D_EXT = 0x806F
        /// </summary>
        Texture3DExt = ((int)0x806F)        ,
        /// <summary>
        /// Original was GL_TEXTURE_3D_OES = 0x806F
        /// </summary>
        Texture3DOes = ((int)0x806F)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_3D = 0x8070
        /// </summary>
        ProxyTexture3D = ((int)0x8070)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_3D_EXT = 0x8070
        /// </summary>
        ProxyTexture3DExt = ((int)0x8070)        ,
        /// <summary>
        /// Original was GL_TEXTURE_DEPTH = 0x8071
        /// </summary>
        TextureDepth = ((int)0x8071)        ,
        /// <summary>
        /// Original was GL_TEXTURE_DEPTH_EXT = 0x8071
        /// </summary>
        TextureDepthExt = ((int)0x8071)        ,
        /// <summary>
        /// Original was GL_TEXTURE_WRAP_R = 0x8072
        /// </summary>
        TextureWrapR = ((int)0x8072)        ,
        /// <summary>
        /// Original was GL_TEXTURE_WRAP_R_EXT = 0x8072
        /// </summary>
        TextureWrapRExt = ((int)0x8072)        ,
        /// <summary>
        /// Original was GL_TEXTURE_WRAP_R_OES = 0x8072
        /// </summary>
        TextureWrapROes = ((int)0x8072)        ,
        /// <summary>
        /// Original was GL_MAX_3D_TEXTURE_SIZE = 0x8073
        /// </summary>
        Max3DTextureSize = ((int)0x8073)        ,
        /// <summary>
        /// Original was GL_MAX_3D_TEXTURE_SIZE_EXT = 0x8073
        /// </summary>
        Max3DTextureSizeExt = ((int)0x8073)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY = 0x8074
        /// </summary>
        VertexArray = ((int)0x8074)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_EXT = 0x8074
        /// </summary>
        VertexArrayExt = ((int)0x8074)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_KHR = 0x8074
        /// </summary>
        VertexArrayKhr = ((int)0x8074)        ,
        /// <summary>
        /// Original was GL_NORMAL_ARRAY = 0x8075
        /// </summary>
        NormalArray = ((int)0x8075)        ,
        /// <summary>
        /// Original was GL_NORMAL_ARRAY_EXT = 0x8075
        /// </summary>
        NormalArrayExt = ((int)0x8075)        ,
        /// <summary>
        /// Original was GL_COLOR_ARRAY = 0x8076
        /// </summary>
        ColorArray = ((int)0x8076)        ,
        /// <summary>
        /// Original was GL_COLOR_ARRAY_EXT = 0x8076
        /// </summary>
        ColorArrayExt = ((int)0x8076)        ,
        /// <summary>
        /// Original was GL_INDEX_ARRAY = 0x8077
        /// </summary>
        IndexArray = ((int)0x8077)        ,
        /// <summary>
        /// Original was GL_INDEX_ARRAY_EXT = 0x8077
        /// </summary>
        IndexArrayExt = ((int)0x8077)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COORD_ARRAY = 0x8078
        /// </summary>
        TextureCoordArray = ((int)0x8078)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COORD_ARRAY_EXT = 0x8078
        /// </summary>
        TextureCoordArrayExt = ((int)0x8078)        ,
        /// <summary>
        /// Original was GL_EDGE_FLAG_ARRAY = 0x8079
        /// </summary>
        EdgeFlagArray = ((int)0x8079)        ,
        /// <summary>
        /// Original was GL_EDGE_FLAG_ARRAY_EXT = 0x8079
        /// </summary>
        EdgeFlagArrayExt = ((int)0x8079)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_SIZE = 0x807A
        /// </summary>
        VertexArraySize = ((int)0x807A)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_SIZE_EXT = 0x807A
        /// </summary>
        VertexArraySizeExt = ((int)0x807A)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_TYPE = 0x807B
        /// </summary>
        VertexArrayType = ((int)0x807B)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_TYPE_EXT = 0x807B
        /// </summary>
        VertexArrayTypeExt = ((int)0x807B)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_STRIDE = 0x807C
        /// </summary>
        VertexArrayStride = ((int)0x807C)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_STRIDE_EXT = 0x807C
        /// </summary>
        VertexArrayStrideExt = ((int)0x807C)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_COUNT_EXT = 0x807D
        /// </summary>
        VertexArrayCountExt = ((int)0x807D)        ,
        /// <summary>
        /// Original was GL_NORMAL_ARRAY_TYPE = 0x807E
        /// </summary>
        NormalArrayType = ((int)0x807E)        ,
        /// <summary>
        /// Original was GL_NORMAL_ARRAY_TYPE_EXT = 0x807E
        /// </summary>
        NormalArrayTypeExt = ((int)0x807E)        ,
        /// <summary>
        /// Original was GL_NORMAL_ARRAY_STRIDE = 0x807F
        /// </summary>
        NormalArrayStride = ((int)0x807F)        ,
        /// <summary>
        /// Original was GL_NORMAL_ARRAY_STRIDE_EXT = 0x807F
        /// </summary>
        NormalArrayStrideExt = ((int)0x807F)        ,
        /// <summary>
        /// Original was GL_NORMAL_ARRAY_COUNT_EXT = 0x8080
        /// </summary>
        NormalArrayCountExt = ((int)0x8080)        ,
        /// <summary>
        /// Original was GL_COLOR_ARRAY_SIZE = 0x8081
        /// </summary>
        ColorArraySize = ((int)0x8081)        ,
        /// <summary>
        /// Original was GL_COLOR_ARRAY_SIZE_EXT = 0x8081
        /// </summary>
        ColorArraySizeExt = ((int)0x8081)        ,
        /// <summary>
        /// Original was GL_COLOR_ARRAY_TYPE = 0x8082
        /// </summary>
        ColorArrayType = ((int)0x8082)        ,
        /// <summary>
        /// Original was GL_COLOR_ARRAY_TYPE_EXT = 0x8082
        /// </summary>
        ColorArrayTypeExt = ((int)0x8082)        ,
        /// <summary>
        /// Original was GL_COLOR_ARRAY_STRIDE = 0x8083
        /// </summary>
        ColorArrayStride = ((int)0x8083)        ,
        /// <summary>
        /// Original was GL_COLOR_ARRAY_STRIDE_EXT = 0x8083
        /// </summary>
        ColorArrayStrideExt = ((int)0x8083)        ,
        /// <summary>
        /// Original was GL_COLOR_ARRAY_COUNT_EXT = 0x8084
        /// </summary>
        ColorArrayCountExt = ((int)0x8084)        ,
        /// <summary>
        /// Original was GL_INDEX_ARRAY_TYPE = 0x8085
        /// </summary>
        IndexArrayType = ((int)0x8085)        ,
        /// <summary>
        /// Original was GL_INDEX_ARRAY_TYPE_EXT = 0x8085
        /// </summary>
        IndexArrayTypeExt = ((int)0x8085)        ,
        /// <summary>
        /// Original was GL_INDEX_ARRAY_STRIDE = 0x8086
        /// </summary>
        IndexArrayStride = ((int)0x8086)        ,
        /// <summary>
        /// Original was GL_INDEX_ARRAY_STRIDE_EXT = 0x8086
        /// </summary>
        IndexArrayStrideExt = ((int)0x8086)        ,
        /// <summary>
        /// Original was GL_INDEX_ARRAY_COUNT_EXT = 0x8087
        /// </summary>
        IndexArrayCountExt = ((int)0x8087)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COORD_ARRAY_SIZE = 0x8088
        /// </summary>
        TextureCoordArraySize = ((int)0x8088)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COORD_ARRAY_SIZE_EXT = 0x8088
        /// </summary>
        TextureCoordArraySizeExt = ((int)0x8088)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COORD_ARRAY_TYPE = 0x8089
        /// </summary>
        TextureCoordArrayType = ((int)0x8089)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COORD_ARRAY_TYPE_EXT = 0x8089
        /// </summary>
        TextureCoordArrayTypeExt = ((int)0x8089)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COORD_ARRAY_STRIDE = 0x808A
        /// </summary>
        TextureCoordArrayStride = ((int)0x808A)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COORD_ARRAY_STRIDE_EXT = 0x808A
        /// </summary>
        TextureCoordArrayStrideExt = ((int)0x808A)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COORD_ARRAY_COUNT_EXT = 0x808B
        /// </summary>
        TextureCoordArrayCountExt = ((int)0x808B)        ,
        /// <summary>
        /// Original was GL_EDGE_FLAG_ARRAY_STRIDE = 0x808C
        /// </summary>
        EdgeFlagArrayStride = ((int)0x808C)        ,
        /// <summary>
        /// Original was GL_EDGE_FLAG_ARRAY_STRIDE_EXT = 0x808C
        /// </summary>
        EdgeFlagArrayStrideExt = ((int)0x808C)        ,
        /// <summary>
        /// Original was GL_EDGE_FLAG_ARRAY_COUNT_EXT = 0x808D
        /// </summary>
        EdgeFlagArrayCountExt = ((int)0x808D)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_POINTER = 0x808E
        /// </summary>
        VertexArrayPointer = ((int)0x808E)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_POINTER_EXT = 0x808E
        /// </summary>
        VertexArrayPointerExt = ((int)0x808E)        ,
        /// <summary>
        /// Original was GL_NORMAL_ARRAY_POINTER = 0x808F
        /// </summary>
        NormalArrayPointer = ((int)0x808F)        ,
        /// <summary>
        /// Original was GL_NORMAL_ARRAY_POINTER_EXT = 0x808F
        /// </summary>
        NormalArrayPointerExt = ((int)0x808F)        ,
        /// <summary>
        /// Original was GL_COLOR_ARRAY_POINTER = 0x8090
        /// </summary>
        ColorArrayPointer = ((int)0x8090)        ,
        /// <summary>
        /// Original was GL_COLOR_ARRAY_POINTER_EXT = 0x8090
        /// </summary>
        ColorArrayPointerExt = ((int)0x8090)        ,
        /// <summary>
        /// Original was GL_INDEX_ARRAY_POINTER = 0x8091
        /// </summary>
        IndexArrayPointer = ((int)0x8091)        ,
        /// <summary>
        /// Original was GL_INDEX_ARRAY_POINTER_EXT = 0x8091
        /// </summary>
        IndexArrayPointerExt = ((int)0x8091)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COORD_ARRAY_POINTER = 0x8092
        /// </summary>
        TextureCoordArrayPointer = ((int)0x8092)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COORD_ARRAY_POINTER_EXT = 0x8092
        /// </summary>
        TextureCoordArrayPointerExt = ((int)0x8092)        ,
        /// <summary>
        /// Original was GL_EDGE_FLAG_ARRAY_POINTER = 0x8093
        /// </summary>
        EdgeFlagArrayPointer = ((int)0x8093)        ,
        /// <summary>
        /// Original was GL_EDGE_FLAG_ARRAY_POINTER_EXT = 0x8093
        /// </summary>
        EdgeFlagArrayPointerExt = ((int)0x8093)        ,
        /// <summary>
        /// Original was GL_INTERLACE_SGIX = 0x8094
        /// </summary>
        InterlaceSgix = ((int)0x8094)        ,
        /// <summary>
        /// Original was GL_DETAIL_TEXTURE_2D_SGIS = 0x8095
        /// </summary>
        DetailTexture2DSgis = ((int)0x8095)        ,
        /// <summary>
        /// Original was GL_DETAIL_TEXTURE_2D_BINDING_SGIS = 0x8096
        /// </summary>
        DetailTexture2DBindingSgis = ((int)0x8096)        ,
        /// <summary>
        /// Original was GL_LINEAR_DETAIL_SGIS = 0x8097
        /// </summary>
        LinearDetailSgis = ((int)0x8097)        ,
        /// <summary>
        /// Original was GL_LINEAR_DETAIL_ALPHA_SGIS = 0x8098
        /// </summary>
        LinearDetailAlphaSgis = ((int)0x8098)        ,
        /// <summary>
        /// Original was GL_LINEAR_DETAIL_COLOR_SGIS = 0x8099
        /// </summary>
        LinearDetailColorSgis = ((int)0x8099)        ,
        /// <summary>
        /// Original was GL_DETAIL_TEXTURE_LEVEL_SGIS = 0x809A
        /// </summary>
        DetailTextureLevelSgis = ((int)0x809A)        ,
        /// <summary>
        /// Original was GL_DETAIL_TEXTURE_MODE_SGIS = 0x809B
        /// </summary>
        DetailTextureModeSgis = ((int)0x809B)        ,
        /// <summary>
        /// Original was GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS = 0x809C
        /// </summary>
        DetailTextureFuncPointsSgis = ((int)0x809C)        ,
        /// <summary>
        /// Original was GL_MULTISAMPLE = 0x809D
        /// </summary>
        Multisample = ((int)0x809D)        ,
        /// <summary>
        /// Original was GL_MULTISAMPLE_ARB = 0x809D
        /// </summary>
        MultisampleArb = ((int)0x809D)        ,
        /// <summary>
        /// Original was GL_MULTISAMPLE_EXT = 0x809D
        /// </summary>
        MultisampleExt = ((int)0x809D)        ,
        /// <summary>
        /// Original was GL_MULTISAMPLE_SGIS = 0x809D
        /// </summary>
        MultisampleSgis = ((int)0x809D)        ,
        /// <summary>
        /// Original was GL_SAMPLE_ALPHA_TO_COVERAGE = 0x809E
        /// </summary>
        SampleAlphaToCoverage = ((int)0x809E)        ,
        /// <summary>
        /// Original was GL_SAMPLE_ALPHA_TO_COVERAGE_ARB = 0x809E
        /// </summary>
        SampleAlphaToCoverageArb = ((int)0x809E)        ,
        /// <summary>
        /// Original was GL_SAMPLE_ALPHA_TO_MASK_EXT = 0x809E
        /// </summary>
        SampleAlphaToMaskExt = ((int)0x809E)        ,
        /// <summary>
        /// Original was GL_SAMPLE_ALPHA_TO_MASK_SGIS = 0x809E
        /// </summary>
        SampleAlphaToMaskSgis = ((int)0x809E)        ,
        /// <summary>
        /// Original was GL_SAMPLE_ALPHA_TO_ONE = 0x809F
        /// </summary>
        SampleAlphaToOne = ((int)0x809F)        ,
        /// <summary>
        /// Original was GL_SAMPLE_ALPHA_TO_ONE_ARB = 0x809F
        /// </summary>
        SampleAlphaToOneArb = ((int)0x809F)        ,
        /// <summary>
        /// Original was GL_SAMPLE_ALPHA_TO_ONE_EXT = 0x809F
        /// </summary>
        SampleAlphaToOneExt = ((int)0x809F)        ,
        /// <summary>
        /// Original was GL_SAMPLE_ALPHA_TO_ONE_SGIS = 0x809F
        /// </summary>
        SampleAlphaToOneSgis = ((int)0x809F)        ,
        /// <summary>
        /// Original was GL_SAMPLE_COVERAGE = 0x80A0
        /// </summary>
        SampleCoverage = ((int)0x80A0)        ,
        /// <summary>
        /// Original was GL_SAMPLE_COVERAGE_ARB = 0x80A0
        /// </summary>
        SampleCoverageArb = ((int)0x80A0)        ,
        /// <summary>
        /// Original was GL_SAMPLE_MASK_EXT = 0x80A0
        /// </summary>
        SampleMaskExt = ((int)0x80A0)        ,
        /// <summary>
        /// Original was GL_SAMPLE_MASK_SGIS = 0x80A0
        /// </summary>
        SampleMaskSgis = ((int)0x80A0)        ,
        /// <summary>
        /// Original was GL_1PASS_EXT = 0x80A1
        /// </summary>
        Gl1PassExt = ((int)0x80A1)        ,
        /// <summary>
        /// Original was GL_1PASS_SGIS = 0x80A1
        /// </summary>
        Gl1PassSgis = ((int)0x80A1)        ,
        /// <summary>
        /// Original was GL_2PASS_0_EXT = 0x80A2
        /// </summary>
        Gl2Pass0Ext = ((int)0x80A2)        ,
        /// <summary>
        /// Original was GL_2PASS_0_SGIS = 0x80A2
        /// </summary>
        Gl2Pass0Sgis = ((int)0x80A2)        ,
        /// <summary>
        /// Original was GL_2PASS_1_EXT = 0x80A3
        /// </summary>
        Gl2Pass1Ext = ((int)0x80A3)        ,
        /// <summary>
        /// Original was GL_2PASS_1_SGIS = 0x80A3
        /// </summary>
        Gl2Pass1Sgis = ((int)0x80A3)        ,
        /// <summary>
        /// Original was GL_4PASS_0_EXT = 0x80A4
        /// </summary>
        Gl4Pass0Ext = ((int)0x80A4)        ,
        /// <summary>
        /// Original was GL_4PASS_0_SGIS = 0x80A4
        /// </summary>
        Gl4Pass0Sgis = ((int)0x80A4)        ,
        /// <summary>
        /// Original was GL_4PASS_1_EXT = 0x80A5
        /// </summary>
        Gl4Pass1Ext = ((int)0x80A5)        ,
        /// <summary>
        /// Original was GL_4PASS_1_SGIS = 0x80A5
        /// </summary>
        Gl4Pass1Sgis = ((int)0x80A5)        ,
        /// <summary>
        /// Original was GL_4PASS_2_EXT = 0x80A6
        /// </summary>
        Gl4Pass2Ext = ((int)0x80A6)        ,
        /// <summary>
        /// Original was GL_4PASS_2_SGIS = 0x80A6
        /// </summary>
        Gl4Pass2Sgis = ((int)0x80A6)        ,
        /// <summary>
        /// Original was GL_4PASS_3_EXT = 0x80A7
        /// </summary>
        Gl4Pass3Ext = ((int)0x80A7)        ,
        /// <summary>
        /// Original was GL_4PASS_3_SGIS = 0x80A7
        /// </summary>
        Gl4Pass3Sgis = ((int)0x80A7)        ,
        /// <summary>
        /// Original was GL_SAMPLE_BUFFERS = 0x80A8
        /// </summary>
        SampleBuffers = ((int)0x80A8)        ,
        /// <summary>
        /// Original was GL_SAMPLE_BUFFERS_ARB = 0x80A8
        /// </summary>
        SampleBuffersArb = ((int)0x80A8)        ,
        /// <summary>
        /// Original was GL_SAMPLE_BUFFERS_EXT = 0x80A8
        /// </summary>
        SampleBuffersExt = ((int)0x80A8)        ,
        /// <summary>
        /// Original was GL_SAMPLE_BUFFERS_SGIS = 0x80A8
        /// </summary>
        SampleBuffersSgis = ((int)0x80A8)        ,
        /// <summary>
        /// Original was GL_SAMPLES = 0x80A9
        /// </summary>
        Samples = ((int)0x80A9)        ,
        /// <summary>
        /// Original was GL_SAMPLES_ARB = 0x80A9
        /// </summary>
        SamplesArb = ((int)0x80A9)        ,
        /// <summary>
        /// Original was GL_SAMPLES_EXT = 0x80A9
        /// </summary>
        SamplesExt = ((int)0x80A9)        ,
        /// <summary>
        /// Original was GL_SAMPLES_SGIS = 0x80A9
        /// </summary>
        SamplesSgis = ((int)0x80A9)        ,
        /// <summary>
        /// Original was GL_SAMPLE_COVERAGE_VALUE = 0x80AA
        /// </summary>
        SampleCoverageValue = ((int)0x80AA)        ,
        /// <summary>
        /// Original was GL_SAMPLE_COVERAGE_VALUE_ARB = 0x80AA
        /// </summary>
        SampleCoverageValueArb = ((int)0x80AA)        ,
        /// <summary>
        /// Original was GL_SAMPLE_MASK_VALUE_EXT = 0x80AA
        /// </summary>
        SampleMaskValueExt = ((int)0x80AA)        ,
        /// <summary>
        /// Original was GL_SAMPLE_MASK_VALUE_SGIS = 0x80AA
        /// </summary>
        SampleMaskValueSgis = ((int)0x80AA)        ,
        /// <summary>
        /// Original was GL_SAMPLE_COVERAGE_INVERT = 0x80AB
        /// </summary>
        SampleCoverageInvert = ((int)0x80AB)        ,
        /// <summary>
        /// Original was GL_SAMPLE_COVERAGE_INVERT_ARB = 0x80AB
        /// </summary>
        SampleCoverageInvertArb = ((int)0x80AB)        ,
        /// <summary>
        /// Original was GL_SAMPLE_MASK_INVERT_EXT = 0x80AB
        /// </summary>
        SampleMaskInvertExt = ((int)0x80AB)        ,
        /// <summary>
        /// Original was GL_SAMPLE_MASK_INVERT_SGIS = 0x80AB
        /// </summary>
        SampleMaskInvertSgis = ((int)0x80AB)        ,
        /// <summary>
        /// Original was GL_SAMPLE_PATTERN_EXT = 0x80AC
        /// </summary>
        SamplePatternExt = ((int)0x80AC)        ,
        /// <summary>
        /// Original was GL_SAMPLE_PATTERN_SGIS = 0x80AC
        /// </summary>
        SamplePatternSgis = ((int)0x80AC)        ,
        /// <summary>
        /// Original was GL_LINEAR_SHARPEN_SGIS = 0x80AD
        /// </summary>
        LinearSharpenSgis = ((int)0x80AD)        ,
        /// <summary>
        /// Original was GL_LINEAR_SHARPEN_ALPHA_SGIS = 0x80AE
        /// </summary>
        LinearSharpenAlphaSgis = ((int)0x80AE)        ,
        /// <summary>
        /// Original was GL_LINEAR_SHARPEN_COLOR_SGIS = 0x80AF
        /// </summary>
        LinearSharpenColorSgis = ((int)0x80AF)        ,
        /// <summary>
        /// Original was GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS = 0x80B0
        /// </summary>
        SharpenTextureFuncPointsSgis = ((int)0x80B0)        ,
        /// <summary>
        /// Original was GL_COLOR_MATRIX = 0x80B1
        /// </summary>
        ColorMatrix = ((int)0x80B1)        ,
        /// <summary>
        /// Original was GL_COLOR_MATRIX_SGI = 0x80B1
        /// </summary>
        ColorMatrixSgi = ((int)0x80B1)        ,
        /// <summary>
        /// Original was GL_COLOR_MATRIX_STACK_DEPTH = 0x80B2
        /// </summary>
        ColorMatrixStackDepth = ((int)0x80B2)        ,
        /// <summary>
        /// Original was GL_COLOR_MATRIX_STACK_DEPTH_SGI = 0x80B2
        /// </summary>
        ColorMatrixStackDepthSgi = ((int)0x80B2)        ,
        /// <summary>
        /// Original was GL_MAX_COLOR_MATRIX_STACK_DEPTH = 0x80B3
        /// </summary>
        MaxColorMatrixStackDepth = ((int)0x80B3)        ,
        /// <summary>
        /// Original was GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI = 0x80B3
        /// </summary>
        MaxColorMatrixStackDepthSgi = ((int)0x80B3)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_RED_SCALE = 0x80B4
        /// </summary>
        PostColorMatrixRedScale = ((int)0x80B4)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_RED_SCALE_SGI = 0x80B4
        /// </summary>
        PostColorMatrixRedScaleSgi = ((int)0x80B4)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_GREEN_SCALE = 0x80B5
        /// </summary>
        PostColorMatrixGreenScale = ((int)0x80B5)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI = 0x80B5
        /// </summary>
        PostColorMatrixGreenScaleSgi = ((int)0x80B5)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_BLUE_SCALE = 0x80B6
        /// </summary>
        PostColorMatrixBlueScale = ((int)0x80B6)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI = 0x80B6
        /// </summary>
        PostColorMatrixBlueScaleSgi = ((int)0x80B6)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_ALPHA_SCALE = 0x80B7
        /// </summary>
        PostColorMatrixAlphaScale = ((int)0x80B7)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI = 0x80B7
        /// </summary>
        PostColorMatrixAlphaScaleSgi = ((int)0x80B7)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_RED_BIAS = 0x80B8
        /// </summary>
        PostColorMatrixRedBias = ((int)0x80B8)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_RED_BIAS_SGI = 0x80B8
        /// </summary>
        PostColorMatrixRedBiasSgi = ((int)0x80B8)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_GREEN_BIAS = 0x80B9
        /// </summary>
        PostColorMatrixGreenBias = ((int)0x80B9)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI = 0x80B9
        /// </summary>
        PostColorMatrixGreenBiasSgi = ((int)0x80B9)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_BLUE_BIAS = 0x80BA
        /// </summary>
        PostColorMatrixBlueBias = ((int)0x80BA)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI = 0x80BA
        /// </summary>
        PostColorMatrixBlueBiasSgi = ((int)0x80BA)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_ALPHA_BIAS = 0x80BB
        /// </summary>
        PostColorMatrixAlphaBias = ((int)0x80BB)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI = 0x80BB
        /// </summary>
        PostColorMatrixAlphaBiasSgi = ((int)0x80BB)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COLOR_TABLE_SGI = 0x80BC
        /// </summary>
        TextureColorTableSgi = ((int)0x80BC)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_COLOR_TABLE_SGI = 0x80BD
        /// </summary>
        ProxyTextureColorTableSgi = ((int)0x80BD)        ,
        /// <summary>
        /// Original was GL_TEXTURE_ENV_BIAS_SGIX = 0x80BE
        /// </summary>
        TextureEnvBiasSgix = ((int)0x80BE)        ,
        /// <summary>
        /// Original was GL_SHADOW_AMBIENT_SGIX = 0x80BF
        /// </summary>
        ShadowAmbientSgix = ((int)0x80BF)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPARE_FAIL_VALUE = 0x80BF
        /// </summary>
        TextureCompareFailValue = ((int)0x80BF)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPARE_FAIL_VALUE_ARB = 0x80BF
        /// </summary>
        TextureCompareFailValueArb = ((int)0x80BF)        ,
        /// <summary>
        /// Original was GL_BLEND_DST_RGB = 0x80C8
        /// </summary>
        BlendDstRgb = ((int)0x80C8)        ,
        /// <summary>
        /// Original was GL_BLEND_DST_RGB_EXT = 0x80C8
        /// </summary>
        BlendDstRgbExt = ((int)0x80C8)        ,
        /// <summary>
        /// Original was GL_BLEND_SRC_RGB = 0x80C9
        /// </summary>
        BlendSrcRgb = ((int)0x80C9)        ,
        /// <summary>
        /// Original was GL_BLEND_SRC_RGB_EXT = 0x80C9
        /// </summary>
        BlendSrcRgbExt = ((int)0x80C9)        ,
        /// <summary>
        /// Original was GL_BLEND_DST_ALPHA = 0x80CA
        /// </summary>
        BlendDstAlpha = ((int)0x80CA)        ,
        /// <summary>
        /// Original was GL_BLEND_DST_ALPHA_EXT = 0x80CA
        /// </summary>
        BlendDstAlphaExt = ((int)0x80CA)        ,
        /// <summary>
        /// Original was GL_BLEND_SRC_ALPHA = 0x80CB
        /// </summary>
        BlendSrcAlpha = ((int)0x80CB)        ,
        /// <summary>
        /// Original was GL_BLEND_SRC_ALPHA_EXT = 0x80CB
        /// </summary>
        BlendSrcAlphaExt = ((int)0x80CB)        ,
        /// <summary>
        /// Original was GL_422_EXT = 0x80CC
        /// </summary>
        Gl422Ext = ((int)0x80CC)        ,
        /// <summary>
        /// Original was GL_422_REV_EXT = 0x80CD
        /// </summary>
        Gl422RevExt = ((int)0x80CD)        ,
        /// <summary>
        /// Original was GL_422_AVERAGE_EXT = 0x80CE
        /// </summary>
        Gl422AverageExt = ((int)0x80CE)        ,
        /// <summary>
        /// Original was GL_422_REV_AVERAGE_EXT = 0x80CF
        /// </summary>
        Gl422RevAverageExt = ((int)0x80CF)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE = 0x80D0
        /// </summary>
        ColorTable = ((int)0x80D0)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_SGI = 0x80D0
        /// </summary>
        ColorTableSgi = ((int)0x80D0)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_COLOR_TABLE = 0x80D1
        /// </summary>
        PostConvolutionColorTable = ((int)0x80D1)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_COLOR_TABLE_SGI = 0x80D1
        /// </summary>
        PostConvolutionColorTableSgi = ((int)0x80D1)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_COLOR_TABLE = 0x80D2
        /// </summary>
        PostColorMatrixColorTable = ((int)0x80D2)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI = 0x80D2
        /// </summary>
        PostColorMatrixColorTableSgi = ((int)0x80D2)        ,
        /// <summary>
        /// Original was GL_PROXY_COLOR_TABLE = 0x80D3
        /// </summary>
        ProxyColorTable = ((int)0x80D3)        ,
        /// <summary>
        /// Original was GL_PROXY_COLOR_TABLE_SGI = 0x80D3
        /// </summary>
        ProxyColorTableSgi = ((int)0x80D3)        ,
        /// <summary>
        /// Original was GL_PROXY_POST_CONVOLUTION_COLOR_TABLE = 0x80D4
        /// </summary>
        ProxyPostConvolutionColorTable = ((int)0x80D4)        ,
        /// <summary>
        /// Original was GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI = 0x80D4
        /// </summary>
        ProxyPostConvolutionColorTableSgi = ((int)0x80D4)        ,
        /// <summary>
        /// Original was GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE = 0x80D5
        /// </summary>
        ProxyPostColorMatrixColorTable = ((int)0x80D5)        ,
        /// <summary>
        /// Original was GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI = 0x80D5
        /// </summary>
        ProxyPostColorMatrixColorTableSgi = ((int)0x80D5)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_SCALE = 0x80D6
        /// </summary>
        ColorTableScale = ((int)0x80D6)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_SCALE_SGI = 0x80D6
        /// </summary>
        ColorTableScaleSgi = ((int)0x80D6)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_BIAS = 0x80D7
        /// </summary>
        ColorTableBias = ((int)0x80D7)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_BIAS_SGI = 0x80D7
        /// </summary>
        ColorTableBiasSgi = ((int)0x80D7)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_FORMAT = 0x80D8
        /// </summary>
        ColorTableFormat = ((int)0x80D8)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_FORMAT_SGI = 0x80D8
        /// </summary>
        ColorTableFormatSgi = ((int)0x80D8)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_WIDTH = 0x80D9
        /// </summary>
        ColorTableWidth = ((int)0x80D9)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_WIDTH_SGI = 0x80D9
        /// </summary>
        ColorTableWidthSgi = ((int)0x80D9)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_RED_SIZE = 0x80DA
        /// </summary>
        ColorTableRedSize = ((int)0x80DA)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_RED_SIZE_SGI = 0x80DA
        /// </summary>
        ColorTableRedSizeSgi = ((int)0x80DA)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_GREEN_SIZE = 0x80DB
        /// </summary>
        ColorTableGreenSize = ((int)0x80DB)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_GREEN_SIZE_SGI = 0x80DB
        /// </summary>
        ColorTableGreenSizeSgi = ((int)0x80DB)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_BLUE_SIZE = 0x80DC
        /// </summary>
        ColorTableBlueSize = ((int)0x80DC)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_BLUE_SIZE_SGI = 0x80DC
        /// </summary>
        ColorTableBlueSizeSgi = ((int)0x80DC)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_ALPHA_SIZE = 0x80DD
        /// </summary>
        ColorTableAlphaSize = ((int)0x80DD)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_ALPHA_SIZE_SGI = 0x80DD
        /// </summary>
        ColorTableAlphaSizeSgi = ((int)0x80DD)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_LUMINANCE_SIZE = 0x80DE
        /// </summary>
        ColorTableLuminanceSize = ((int)0x80DE)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_LUMINANCE_SIZE_SGI = 0x80DE
        /// </summary>
        ColorTableLuminanceSizeSgi = ((int)0x80DE)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_INTENSITY_SIZE = 0x80DF
        /// </summary>
        ColorTableIntensitySize = ((int)0x80DF)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_INTENSITY_SIZE_SGI = 0x80DF
        /// </summary>
        ColorTableIntensitySizeSgi = ((int)0x80DF)        ,
        /// <summary>
        /// Original was GL_BGR = 0x80E0
        /// </summary>
        Bgr = ((int)0x80E0)        ,
        /// <summary>
        /// Original was GL_BGR_EXT = 0x80E0
        /// </summary>
        BgrExt = ((int)0x80E0)        ,
        /// <summary>
        /// Original was GL_BGRA = 0x80E1
        /// </summary>
        Bgra = ((int)0x80E1)        ,
        /// <summary>
        /// Original was GL_BGRA_EXT = 0x80E1
        /// </summary>
        BgraExt = ((int)0x80E1)        ,
        /// <summary>
        /// Original was GL_COLOR_INDEX1_EXT = 0x80E2
        /// </summary>
        ColorIndex1Ext = ((int)0x80E2)        ,
        /// <summary>
        /// Original was GL_COLOR_INDEX2_EXT = 0x80E3
        /// </summary>
        ColorIndex2Ext = ((int)0x80E3)        ,
        /// <summary>
        /// Original was GL_COLOR_INDEX4_EXT = 0x80E4
        /// </summary>
        ColorIndex4Ext = ((int)0x80E4)        ,
        /// <summary>
        /// Original was GL_COLOR_INDEX8_EXT = 0x80E5
        /// </summary>
        ColorIndex8Ext = ((int)0x80E5)        ,
        /// <summary>
        /// Original was GL_COLOR_INDEX12_EXT = 0x80E6
        /// </summary>
        ColorIndex12Ext = ((int)0x80E6)        ,
        /// <summary>
        /// Original was GL_COLOR_INDEX16_EXT = 0x80E7
        /// </summary>
        ColorIndex16Ext = ((int)0x80E7)        ,
        /// <summary>
        /// Original was GL_MAX_ELEMENTS_VERTICES = 0x80E8
        /// </summary>
        MaxElementsVertices = ((int)0x80E8)        ,
        /// <summary>
        /// Original was GL_MAX_ELEMENTS_VERTICES_EXT = 0x80E8
        /// </summary>
        MaxElementsVerticesExt = ((int)0x80E8)        ,
        /// <summary>
        /// Original was GL_MAX_ELEMENTS_INDICES = 0x80E9
        /// </summary>
        MaxElementsIndices = ((int)0x80E9)        ,
        /// <summary>
        /// Original was GL_MAX_ELEMENTS_INDICES_EXT = 0x80E9
        /// </summary>
        MaxElementsIndicesExt = ((int)0x80E9)        ,
        /// <summary>
        /// Original was GL_PHONG_WIN = 0x80EA
        /// </summary>
        PhongWin = ((int)0x80EA)        ,
        /// <summary>
        /// Original was GL_PHONG_HINT_WIN = 0x80EB
        /// </summary>
        PhongHintWin = ((int)0x80EB)        ,
        /// <summary>
        /// Original was GL_FOG_SPECULAR_TEXTURE_WIN = 0x80EC
        /// </summary>
        FogSpecularTextureWin = ((int)0x80EC)        ,
        /// <summary>
        /// Original was GL_TEXTURE_INDEX_SIZE_EXT = 0x80ED
        /// </summary>
        TextureIndexSizeExt = ((int)0x80ED)        ,
        /// <summary>
        /// Original was GL_PARAMETER_BUFFER_ARB = 0x80EE
        /// </summary>
        ParameterBufferArb = ((int)0x80EE)        ,
        /// <summary>
        /// Original was GL_PARAMETER_BUFFER_BINDING_ARB = 0x80EF
        /// </summary>
        ParameterBufferBindingArb = ((int)0x80EF)        ,
        /// <summary>
        /// Original was GL_CLIP_VOLUME_CLIPPING_HINT_EXT = 0x80F0
        /// </summary>
        ClipVolumeClippingHintExt = ((int)0x80F0)        ,
        /// <summary>
        /// Original was GL_DUAL_ALPHA4_SGIS = 0x8110
        /// </summary>
        DualAlpha4Sgis = ((int)0x8110)        ,
        /// <summary>
        /// Original was GL_DUAL_ALPHA8_SGIS = 0x8111
        /// </summary>
        DualAlpha8Sgis = ((int)0x8111)        ,
        /// <summary>
        /// Original was GL_DUAL_ALPHA12_SGIS = 0x8112
        /// </summary>
        DualAlpha12Sgis = ((int)0x8112)        ,
        /// <summary>
        /// Original was GL_DUAL_ALPHA16_SGIS = 0x8113
        /// </summary>
        DualAlpha16Sgis = ((int)0x8113)        ,
        /// <summary>
        /// Original was GL_DUAL_LUMINANCE4_SGIS = 0x8114
        /// </summary>
        DualLuminance4Sgis = ((int)0x8114)        ,
        /// <summary>
        /// Original was GL_DUAL_LUMINANCE8_SGIS = 0x8115
        /// </summary>
        DualLuminance8Sgis = ((int)0x8115)        ,
        /// <summary>
        /// Original was GL_DUAL_LUMINANCE12_SGIS = 0x8116
        /// </summary>
        DualLuminance12Sgis = ((int)0x8116)        ,
        /// <summary>
        /// Original was GL_DUAL_LUMINANCE16_SGIS = 0x8117
        /// </summary>
        DualLuminance16Sgis = ((int)0x8117)        ,
        /// <summary>
        /// Original was GL_DUAL_INTENSITY4_SGIS = 0x8118
        /// </summary>
        DualIntensity4Sgis = ((int)0x8118)        ,
        /// <summary>
        /// Original was GL_DUAL_INTENSITY8_SGIS = 0x8119
        /// </summary>
        DualIntensity8Sgis = ((int)0x8119)        ,
        /// <summary>
        /// Original was GL_DUAL_INTENSITY12_SGIS = 0x811A
        /// </summary>
        DualIntensity12Sgis = ((int)0x811A)        ,
        /// <summary>
        /// Original was GL_DUAL_INTENSITY16_SGIS = 0x811B
        /// </summary>
        DualIntensity16Sgis = ((int)0x811B)        ,
        /// <summary>
        /// Original was GL_DUAL_LUMINANCE_ALPHA4_SGIS = 0x811C
        /// </summary>
        DualLuminanceAlpha4Sgis = ((int)0x811C)        ,
        /// <summary>
        /// Original was GL_DUAL_LUMINANCE_ALPHA8_SGIS = 0x811D
        /// </summary>
        DualLuminanceAlpha8Sgis = ((int)0x811D)        ,
        /// <summary>
        /// Original was GL_QUAD_ALPHA4_SGIS = 0x811E
        /// </summary>
        QuadAlpha4Sgis = ((int)0x811E)        ,
        /// <summary>
        /// Original was GL_QUAD_ALPHA8_SGIS = 0x811F
        /// </summary>
        QuadAlpha8Sgis = ((int)0x811F)        ,
        /// <summary>
        /// Original was GL_QUAD_LUMINANCE4_SGIS = 0x8120
        /// </summary>
        QuadLuminance4Sgis = ((int)0x8120)        ,
        /// <summary>
        /// Original was GL_QUAD_LUMINANCE8_SGIS = 0x8121
        /// </summary>
        QuadLuminance8Sgis = ((int)0x8121)        ,
        /// <summary>
        /// Original was GL_QUAD_INTENSITY4_SGIS = 0x8122
        /// </summary>
        QuadIntensity4Sgis = ((int)0x8122)        ,
        /// <summary>
        /// Original was GL_QUAD_INTENSITY8_SGIS = 0x8123
        /// </summary>
        QuadIntensity8Sgis = ((int)0x8123)        ,
        /// <summary>
        /// Original was GL_DUAL_TEXTURE_SELECT_SGIS = 0x8124
        /// </summary>
        DualTextureSelectSgis = ((int)0x8124)        ,
        /// <summary>
        /// Original was GL_QUAD_TEXTURE_SELECT_SGIS = 0x8125
        /// </summary>
        QuadTextureSelectSgis = ((int)0x8125)        ,
        /// <summary>
        /// Original was GL_POINT_SIZE_MIN = 0x8126
        /// </summary>
        PointSizeMin = ((int)0x8126)        ,
        /// <summary>
        /// Original was GL_POINT_SIZE_MIN_ARB = 0x8126
        /// </summary>
        PointSizeMinArb = ((int)0x8126)        ,
        /// <summary>
        /// Original was GL_POINT_SIZE_MIN_EXT = 0x8126
        /// </summary>
        PointSizeMinExt = ((int)0x8126)        ,
        /// <summary>
        /// Original was GL_POINT_SIZE_MIN_SGIS = 0x8126
        /// </summary>
        PointSizeMinSgis = ((int)0x8126)        ,
        /// <summary>
        /// Original was GL_POINT_SIZE_MAX = 0x8127
        /// </summary>
        PointSizeMax = ((int)0x8127)        ,
        /// <summary>
        /// Original was GL_POINT_SIZE_MAX_ARB = 0x8127
        /// </summary>
        PointSizeMaxArb = ((int)0x8127)        ,
        /// <summary>
        /// Original was GL_POINT_SIZE_MAX_EXT = 0x8127
        /// </summary>
        PointSizeMaxExt = ((int)0x8127)        ,
        /// <summary>
        /// Original was GL_POINT_SIZE_MAX_SGIS = 0x8127
        /// </summary>
        PointSizeMaxSgis = ((int)0x8127)        ,
        /// <summary>
        /// Original was GL_POINT_FADE_THRESHOLD_SIZE = 0x8128
        /// </summary>
        PointFadeThresholdSize = ((int)0x8128)        ,
        /// <summary>
        /// Original was GL_POINT_FADE_THRESHOLD_SIZE_ARB = 0x8128
        /// </summary>
        PointFadeThresholdSizeArb = ((int)0x8128)        ,
        /// <summary>
        /// Original was GL_POINT_FADE_THRESHOLD_SIZE_EXT = 0x8128
        /// </summary>
        PointFadeThresholdSizeExt = ((int)0x8128)        ,
        /// <summary>
        /// Original was GL_POINT_FADE_THRESHOLD_SIZE_SGIS = 0x8128
        /// </summary>
        PointFadeThresholdSizeSgis = ((int)0x8128)        ,
        /// <summary>
        /// Original was GL_DISTANCE_ATTENUATION_EXT = 0x8129
        /// </summary>
        DistanceAttenuationExt = ((int)0x8129)        ,
        /// <summary>
        /// Original was GL_DISTANCE_ATTENUATION_SGIS = 0x8129
        /// </summary>
        DistanceAttenuationSgis = ((int)0x8129)        ,
        /// <summary>
        /// Original was GL_POINT_DISTANCE_ATTENUATION = 0x8129
        /// </summary>
        PointDistanceAttenuation = ((int)0x8129)        ,
        /// <summary>
        /// Original was GL_POINT_DISTANCE_ATTENUATION_ARB = 0x8129
        /// </summary>
        PointDistanceAttenuationArb = ((int)0x8129)        ,
        /// <summary>
        /// Original was GL_FOG_FUNC_SGIS = 0x812A
        /// </summary>
        FogFuncSgis = ((int)0x812A)        ,
        /// <summary>
        /// Original was GL_FOG_FUNC_POINTS_SGIS = 0x812B
        /// </summary>
        FogFuncPointsSgis = ((int)0x812B)        ,
        /// <summary>
        /// Original was GL_MAX_FOG_FUNC_POINTS_SGIS = 0x812C
        /// </summary>
        MaxFogFuncPointsSgis = ((int)0x812C)        ,
        /// <summary>
        /// Original was GL_CLAMP_TO_BORDER = 0x812D
        /// </summary>
        ClampToBorder = ((int)0x812D)        ,
        /// <summary>
        /// Original was GL_CLAMP_TO_BORDER_ARB = 0x812D
        /// </summary>
        ClampToBorderArb = ((int)0x812D)        ,
        /// <summary>
        /// Original was GL_CLAMP_TO_BORDER_NV = 0x812D
        /// </summary>
        ClampToBorderNv = ((int)0x812D)        ,
        /// <summary>
        /// Original was GL_CLAMP_TO_BORDER_SGIS = 0x812D
        /// </summary>
        ClampToBorderSgis = ((int)0x812D)        ,
        /// <summary>
        /// Original was GL_TEXTURE_MULTI_BUFFER_HINT_SGIX = 0x812E
        /// </summary>
        TextureMultiBufferHintSgix = ((int)0x812E)        ,
        /// <summary>
        /// Original was GL_CLAMP_TO_EDGE = 0x812F
        /// </summary>
        ClampToEdge = ((int)0x812F)        ,
        /// <summary>
        /// Original was GL_CLAMP_TO_EDGE_SGIS = 0x812F
        /// </summary>
        ClampToEdgeSgis = ((int)0x812F)        ,
        /// <summary>
        /// Original was GL_PACK_SKIP_VOLUMES_SGIS = 0x8130
        /// </summary>
        PackSkipVolumesSgis = ((int)0x8130)        ,
        /// <summary>
        /// Original was GL_PACK_IMAGE_DEPTH_SGIS = 0x8131
        /// </summary>
        PackImageDepthSgis = ((int)0x8131)        ,
        /// <summary>
        /// Original was GL_UNPACK_SKIP_VOLUMES_SGIS = 0x8132
        /// </summary>
        UnpackSkipVolumesSgis = ((int)0x8132)        ,
        /// <summary>
        /// Original was GL_UNPACK_IMAGE_DEPTH_SGIS = 0x8133
        /// </summary>
        UnpackImageDepthSgis = ((int)0x8133)        ,
        /// <summary>
        /// Original was GL_TEXTURE_4D_SGIS = 0x8134
        /// </summary>
        Texture4DSgis = ((int)0x8134)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_4D_SGIS = 0x8135
        /// </summary>
        ProxyTexture4DSgis = ((int)0x8135)        ,
        /// <summary>
        /// Original was GL_TEXTURE_4DSIZE_SGIS = 0x8136
        /// </summary>
        Texture4DsizeSgis = ((int)0x8136)        ,
        /// <summary>
        /// Original was GL_TEXTURE_WRAP_Q_SGIS = 0x8137
        /// </summary>
        TextureWrapQSgis = ((int)0x8137)        ,
        /// <summary>
        /// Original was GL_MAX_4D_TEXTURE_SIZE_SGIS = 0x8138
        /// </summary>
        Max4DTextureSizeSgis = ((int)0x8138)        ,
        /// <summary>
        /// Original was GL_PIXEL_TEX_GEN_SGIX = 0x8139
        /// </summary>
        PixelTexGenSgix = ((int)0x8139)        ,
        /// <summary>
        /// Original was GL_TEXTURE_MIN_LOD = 0x813A
        /// </summary>
        TextureMinLod = ((int)0x813A)        ,
        /// <summary>
        /// Original was GL_TEXTURE_MIN_LOD_SGIS = 0x813A
        /// </summary>
        TextureMinLodSgis = ((int)0x813A)        ,
        /// <summary>
        /// Original was GL_TEXTURE_MAX_LOD = 0x813B
        /// </summary>
        TextureMaxLod = ((int)0x813B)        ,
        /// <summary>
        /// Original was GL_TEXTURE_MAX_LOD_SGIS = 0x813B
        /// </summary>
        TextureMaxLodSgis = ((int)0x813B)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BASE_LEVEL = 0x813C
        /// </summary>
        TextureBaseLevel = ((int)0x813C)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BASE_LEVEL_SGIS = 0x813C
        /// </summary>
        TextureBaseLevelSgis = ((int)0x813C)        ,
        /// <summary>
        /// Original was GL_TEXTURE_MAX_LEVEL = 0x813D
        /// </summary>
        TextureMaxLevel = ((int)0x813D)        ,
        /// <summary>
        /// Original was GL_TEXTURE_MAX_LEVEL_SGIS = 0x813D
        /// </summary>
        TextureMaxLevelSgis = ((int)0x813D)        ,
        /// <summary>
        /// Original was GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX = 0x813E
        /// </summary>
        PixelTileBestAlignmentSgix = ((int)0x813E)        ,
        /// <summary>
        /// Original was GL_PIXEL_TILE_CACHE_INCREMENT_SGIX = 0x813F
        /// </summary>
        PixelTileCacheIncrementSgix = ((int)0x813F)        ,
        /// <summary>
        /// Original was GL_PIXEL_TILE_WIDTH_SGIX = 0x8140
        /// </summary>
        PixelTileWidthSgix = ((int)0x8140)        ,
        /// <summary>
        /// Original was GL_PIXEL_TILE_HEIGHT_SGIX = 0x8141
        /// </summary>
        PixelTileHeightSgix = ((int)0x8141)        ,
        /// <summary>
        /// Original was GL_PIXEL_TILE_GRID_WIDTH_SGIX = 0x8142
        /// </summary>
        PixelTileGridWidthSgix = ((int)0x8142)        ,
        /// <summary>
        /// Original was GL_PIXEL_TILE_GRID_HEIGHT_SGIX = 0x8143
        /// </summary>
        PixelTileGridHeightSgix = ((int)0x8143)        ,
        /// <summary>
        /// Original was GL_PIXEL_TILE_GRID_DEPTH_SGIX = 0x8144
        /// </summary>
        PixelTileGridDepthSgix = ((int)0x8144)        ,
        /// <summary>
        /// Original was GL_PIXEL_TILE_CACHE_SIZE_SGIX = 0x8145
        /// </summary>
        PixelTileCacheSizeSgix = ((int)0x8145)        ,
        /// <summary>
        /// Original was GL_FILTER4_SGIS = 0x8146
        /// </summary>
        Filter4Sgis = ((int)0x8146)        ,
        /// <summary>
        /// Original was GL_TEXTURE_FILTER4_SIZE_SGIS = 0x8147
        /// </summary>
        TextureFilter4SizeSgis = ((int)0x8147)        ,
        /// <summary>
        /// Original was GL_SPRITE_SGIX = 0x8148
        /// </summary>
        SpriteSgix = ((int)0x8148)        ,
        /// <summary>
        /// Original was GL_SPRITE_MODE_SGIX = 0x8149
        /// </summary>
        SpriteModeSgix = ((int)0x8149)        ,
        /// <summary>
        /// Original was GL_SPRITE_AXIS_SGIX = 0x814A
        /// </summary>
        SpriteAxisSgix = ((int)0x814A)        ,
        /// <summary>
        /// Original was GL_SPRITE_TRANSLATION_SGIX = 0x814B
        /// </summary>
        SpriteTranslationSgix = ((int)0x814B)        ,
        /// <summary>
        /// Original was GL_SPRITE_AXIAL_SGIX = 0x814C
        /// </summary>
        SpriteAxialSgix = ((int)0x814C)        ,
        /// <summary>
        /// Original was GL_SPRITE_OBJECT_ALIGNED_SGIX = 0x814D
        /// </summary>
        SpriteObjectAlignedSgix = ((int)0x814D)        ,
        /// <summary>
        /// Original was GL_SPRITE_EYE_ALIGNED_SGIX = 0x814E
        /// </summary>
        SpriteEyeAlignedSgix = ((int)0x814E)        ,
        /// <summary>
        /// Original was GL_TEXTURE_4D_BINDING_SGIS = 0x814F
        /// </summary>
        Texture4DBindingSgis = ((int)0x814F)        ,
        /// <summary>
        /// Original was GL_IGNORE_BORDER_HP = 0x8150
        /// </summary>
        IgnoreBorderHp = ((int)0x8150)        ,
        /// <summary>
        /// Original was GL_CONSTANT_BORDER = 0x8151
        /// </summary>
        ConstantBorder = ((int)0x8151)        ,
        /// <summary>
        /// Original was GL_CONSTANT_BORDER_HP = 0x8151
        /// </summary>
        ConstantBorderHp = ((int)0x8151)        ,
        /// <summary>
        /// Original was GL_REPLICATE_BORDER = 0x8153
        /// </summary>
        ReplicateBorder = ((int)0x8153)        ,
        /// <summary>
        /// Original was GL_REPLICATE_BORDER_HP = 0x8153
        /// </summary>
        ReplicateBorderHp = ((int)0x8153)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_BORDER_COLOR = 0x8154
        /// </summary>
        ConvolutionBorderColor = ((int)0x8154)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_BORDER_COLOR_HP = 0x8154
        /// </summary>
        ConvolutionBorderColorHp = ((int)0x8154)        ,
        /// <summary>
        /// Original was GL_IMAGE_SCALE_X_HP = 0x8155
        /// </summary>
        ImageScaleXHp = ((int)0x8155)        ,
        /// <summary>
        /// Original was GL_IMAGE_SCALE_Y_HP = 0x8156
        /// </summary>
        ImageScaleYHp = ((int)0x8156)        ,
        /// <summary>
        /// Original was GL_IMAGE_TRANSLATE_X_HP = 0x8157
        /// </summary>
        ImageTranslateXHp = ((int)0x8157)        ,
        /// <summary>
        /// Original was GL_IMAGE_TRANSLATE_Y_HP = 0x8158
        /// </summary>
        ImageTranslateYHp = ((int)0x8158)        ,
        /// <summary>
        /// Original was GL_IMAGE_ROTATE_ANGLE_HP = 0x8159
        /// </summary>
        ImageRotateAngleHp = ((int)0x8159)        ,
        /// <summary>
        /// Original was GL_IMAGE_ROTATE_ORIGIN_X_HP = 0x815A
        /// </summary>
        ImageRotateOriginXHp = ((int)0x815A)        ,
        /// <summary>
        /// Original was GL_IMAGE_ROTATE_ORIGIN_Y_HP = 0x815B
        /// </summary>
        ImageRotateOriginYHp = ((int)0x815B)        ,
        /// <summary>
        /// Original was GL_IMAGE_MAG_FILTER_HP = 0x815C
        /// </summary>
        ImageMagFilterHp = ((int)0x815C)        ,
        /// <summary>
        /// Original was GL_IMAGE_MIN_FILTER_HP = 0x815D
        /// </summary>
        ImageMinFilterHp = ((int)0x815D)        ,
        /// <summary>
        /// Original was GL_IMAGE_CUBIC_WEIGHT_HP = 0x815E
        /// </summary>
        ImageCubicWeightHp = ((int)0x815E)        ,
        /// <summary>
        /// Original was GL_CUBIC_HP = 0x815F
        /// </summary>
        CubicHp = ((int)0x815F)        ,
        /// <summary>
        /// Original was GL_AVERAGE_HP = 0x8160
        /// </summary>
        AverageHp = ((int)0x8160)        ,
        /// <summary>
        /// Original was GL_IMAGE_TRANSFORM_2D_HP = 0x8161
        /// </summary>
        ImageTransform2DHp = ((int)0x8161)        ,
        /// <summary>
        /// Original was GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP = 0x8162
        /// </summary>
        PostImageTransformColorTableHp = ((int)0x8162)        ,
        /// <summary>
        /// Original was GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP = 0x8163
        /// </summary>
        ProxyPostImageTransformColorTableHp = ((int)0x8163)        ,
        /// <summary>
        /// Original was GL_OCCLUSION_TEST_HP = 0x8165
        /// </summary>
        OcclusionTestHp = ((int)0x8165)        ,
        /// <summary>
        /// Original was GL_OCCLUSION_TEST_RESULT_HP = 0x8166
        /// </summary>
        OcclusionTestResultHp = ((int)0x8166)        ,
        /// <summary>
        /// Original was GL_TEXTURE_LIGHTING_MODE_HP = 0x8167
        /// </summary>
        TextureLightingModeHp = ((int)0x8167)        ,
        /// <summary>
        /// Original was GL_TEXTURE_POST_SPECULAR_HP = 0x8168
        /// </summary>
        TexturePostSpecularHp = ((int)0x8168)        ,
        /// <summary>
        /// Original was GL_TEXTURE_PRE_SPECULAR_HP = 0x8169
        /// </summary>
        TexturePreSpecularHp = ((int)0x8169)        ,
        /// <summary>
        /// Original was GL_LINEAR_CLIPMAP_LINEAR_SGIX = 0x8170
        /// </summary>
        LinearClipmapLinearSgix = ((int)0x8170)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CLIPMAP_CENTER_SGIX = 0x8171
        /// </summary>
        TextureClipmapCenterSgix = ((int)0x8171)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CLIPMAP_FRAME_SGIX = 0x8172
        /// </summary>
        TextureClipmapFrameSgix = ((int)0x8172)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CLIPMAP_OFFSET_SGIX = 0x8173
        /// </summary>
        TextureClipmapOffsetSgix = ((int)0x8173)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX = 0x8174
        /// </summary>
        TextureClipmapVirtualDepthSgix = ((int)0x8174)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX = 0x8175
        /// </summary>
        TextureClipmapLodOffsetSgix = ((int)0x8175)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CLIPMAP_DEPTH_SGIX = 0x8176
        /// </summary>
        TextureClipmapDepthSgix = ((int)0x8176)        ,
        /// <summary>
        /// Original was GL_MAX_CLIPMAP_DEPTH_SGIX = 0x8177
        /// </summary>
        MaxClipmapDepthSgix = ((int)0x8177)        ,
        /// <summary>
        /// Original was GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX = 0x8178
        /// </summary>
        MaxClipmapVirtualDepthSgix = ((int)0x8178)        ,
        /// <summary>
        /// Original was GL_POST_TEXTURE_FILTER_BIAS_SGIX = 0x8179
        /// </summary>
        PostTextureFilterBiasSgix = ((int)0x8179)        ,
        /// <summary>
        /// Original was GL_POST_TEXTURE_FILTER_SCALE_SGIX = 0x817A
        /// </summary>
        PostTextureFilterScaleSgix = ((int)0x817A)        ,
        /// <summary>
        /// Original was GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX = 0x817B
        /// </summary>
        PostTextureFilterBiasRangeSgix = ((int)0x817B)        ,
        /// <summary>
        /// Original was GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX = 0x817C
        /// </summary>
        PostTextureFilterScaleRangeSgix = ((int)0x817C)        ,
        /// <summary>
        /// Original was GL_REFERENCE_PLANE_SGIX = 0x817D
        /// </summary>
        ReferencePlaneSgix = ((int)0x817D)        ,
        /// <summary>
        /// Original was GL_REFERENCE_PLANE_EQUATION_SGIX = 0x817E
        /// </summary>
        ReferencePlaneEquationSgix = ((int)0x817E)        ,
        /// <summary>
        /// Original was GL_IR_INSTRUMENT1_SGIX = 0x817F
        /// </summary>
        IrInstrument1Sgix = ((int)0x817F)        ,
        /// <summary>
        /// Original was GL_INSTRUMENT_BUFFER_POINTER_SGIX = 0x8180
        /// </summary>
        InstrumentBufferPointerSgix = ((int)0x8180)        ,
        /// <summary>
        /// Original was GL_INSTRUMENT_MEASUREMENTS_SGIX = 0x8181
        /// </summary>
        InstrumentMeasurementsSgix = ((int)0x8181)        ,
        /// <summary>
        /// Original was GL_LIST_PRIORITY_SGIX = 0x8182
        /// </summary>
        ListPrioritySgix = ((int)0x8182)        ,
        /// <summary>
        /// Original was GL_CALLIGRAPHIC_FRAGMENT_SGIX = 0x8183
        /// </summary>
        CalligraphicFragmentSgix = ((int)0x8183)        ,
        /// <summary>
        /// Original was GL_PIXEL_TEX_GEN_Q_CEILING_SGIX = 0x8184
        /// </summary>
        PixelTexGenQCeilingSgix = ((int)0x8184)        ,
        /// <summary>
        /// Original was GL_PIXEL_TEX_GEN_Q_ROUND_SGIX = 0x8185
        /// </summary>
        PixelTexGenQRoundSgix = ((int)0x8185)        ,
        /// <summary>
        /// Original was GL_PIXEL_TEX_GEN_Q_FLOOR_SGIX = 0x8186
        /// </summary>
        PixelTexGenQFloorSgix = ((int)0x8186)        ,
        /// <summary>
        /// Original was GL_PIXEL_TEX_GEN_ALPHA_REPLACE_SGIX = 0x8187
        /// </summary>
        PixelTexGenAlphaReplaceSgix = ((int)0x8187)        ,
        /// <summary>
        /// Original was GL_PIXEL_TEX_GEN_ALPHA_NO_REPLACE_SGIX = 0x8188
        /// </summary>
        PixelTexGenAlphaNoReplaceSgix = ((int)0x8188)        ,
        /// <summary>
        /// Original was GL_PIXEL_TEX_GEN_ALPHA_LS_SGIX = 0x8189
        /// </summary>
        PixelTexGenAlphaLsSgix = ((int)0x8189)        ,
        /// <summary>
        /// Original was GL_PIXEL_TEX_GEN_ALPHA_MS_SGIX = 0x818A
        /// </summary>
        PixelTexGenAlphaMsSgix = ((int)0x818A)        ,
        /// <summary>
        /// Original was GL_FRAMEZOOM_SGIX = 0x818B
        /// </summary>
        FramezoomSgix = ((int)0x818B)        ,
        /// <summary>
        /// Original was GL_FRAMEZOOM_FACTOR_SGIX = 0x818C
        /// </summary>
        FramezoomFactorSgix = ((int)0x818C)        ,
        /// <summary>
        /// Original was GL_MAX_FRAMEZOOM_FACTOR_SGIX = 0x818D
        /// </summary>
        MaxFramezoomFactorSgix = ((int)0x818D)        ,
        /// <summary>
        /// Original was GL_TEXTURE_LOD_BIAS_S_SGIX = 0x818E
        /// </summary>
        TextureLodBiasSSgix = ((int)0x818E)        ,
        /// <summary>
        /// Original was GL_TEXTURE_LOD_BIAS_T_SGIX = 0x818F
        /// </summary>
        TextureLodBiasTSgix = ((int)0x818F)        ,
        /// <summary>
        /// Original was GL_TEXTURE_LOD_BIAS_R_SGIX = 0x8190
        /// </summary>
        TextureLodBiasRSgix = ((int)0x8190)        ,
        /// <summary>
        /// Original was GL_GENERATE_MIPMAP = 0x8191
        /// </summary>
        GenerateMipmap = ((int)0x8191)        ,
        /// <summary>
        /// Original was GL_GENERATE_MIPMAP_SGIS = 0x8191
        /// </summary>
        GenerateMipmapSgis = ((int)0x8191)        ,
        /// <summary>
        /// Original was GL_GENERATE_MIPMAP_HINT = 0x8192
        /// </summary>
        GenerateMipmapHint = ((int)0x8192)        ,
        /// <summary>
        /// Original was GL_GENERATE_MIPMAP_HINT_SGIS = 0x8192
        /// </summary>
        GenerateMipmapHintSgis = ((int)0x8192)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_DEFORMATION_SGIX = 0x8194
        /// </summary>
        GeometryDeformationSgix = ((int)0x8194)        ,
        /// <summary>
        /// Original was GL_TEXTURE_DEFORMATION_SGIX = 0x8195
        /// </summary>
        TextureDeformationSgix = ((int)0x8195)        ,
        /// <summary>
        /// Original was GL_DEFORMATIONS_MASK_SGIX = 0x8196
        /// </summary>
        DeformationsMaskSgix = ((int)0x8196)        ,
        /// <summary>
        /// Original was GL_MAX_DEFORMATION_ORDER_SGIX = 0x8197
        /// </summary>
        MaxDeformationOrderSgix = ((int)0x8197)        ,
        /// <summary>
        /// Original was GL_FOG_OFFSET_SGIX = 0x8198
        /// </summary>
        FogOffsetSgix = ((int)0x8198)        ,
        /// <summary>
        /// Original was GL_FOG_OFFSET_VALUE_SGIX = 0x8199
        /// </summary>
        FogOffsetValueSgix = ((int)0x8199)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPARE_SGIX = 0x819A
        /// </summary>
        TextureCompareSgix = ((int)0x819A)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPARE_OPERATOR_SGIX = 0x819B
        /// </summary>
        TextureCompareOperatorSgix = ((int)0x819B)        ,
        /// <summary>
        /// Original was GL_TEXTURE_LEQUAL_R_SGIX = 0x819C
        /// </summary>
        TextureLequalRSgix = ((int)0x819C)        ,
        /// <summary>
        /// Original was GL_TEXTURE_GEQUAL_R_SGIX = 0x819D
        /// </summary>
        TextureGequalRSgix = ((int)0x819D)        ,
        /// <summary>
        /// Original was GL_DEPTH_COMPONENT16 = 0x81A5
        /// </summary>
        DepthComponent16 = ((int)0x81A5)        ,
        /// <summary>
        /// Original was GL_DEPTH_COMPONENT16_ARB = 0x81A5
        /// </summary>
        DepthComponent16Arb = ((int)0x81A5)        ,
        /// <summary>
        /// Original was GL_DEPTH_COMPONENT16_SGIX = 0x81A5
        /// </summary>
        DepthComponent16Sgix = ((int)0x81A5)        ,
        /// <summary>
        /// Original was GL_DEPTH_COMPONENT24 = 0x81A6
        /// </summary>
        DepthComponent24 = ((int)0x81A6)        ,
        /// <summary>
        /// Original was GL_DEPTH_COMPONENT24_ARB = 0x81A6
        /// </summary>
        DepthComponent24Arb = ((int)0x81A6)        ,
        /// <summary>
        /// Original was GL_DEPTH_COMPONENT24_SGIX = 0x81A6
        /// </summary>
        DepthComponent24Sgix = ((int)0x81A6)        ,
        /// <summary>
        /// Original was GL_DEPTH_COMPONENT32 = 0x81A7
        /// </summary>
        DepthComponent32 = ((int)0x81A7)        ,
        /// <summary>
        /// Original was GL_DEPTH_COMPONENT32_ARB = 0x81A7
        /// </summary>
        DepthComponent32Arb = ((int)0x81A7)        ,
        /// <summary>
        /// Original was GL_DEPTH_COMPONENT32_SGIX = 0x81A7
        /// </summary>
        DepthComponent32Sgix = ((int)0x81A7)        ,
        /// <summary>
        /// Original was GL_ARRAY_ELEMENT_LOCK_FIRST_EXT = 0x81A8
        /// </summary>
        ArrayElementLockFirstExt = ((int)0x81A8)        ,
        /// <summary>
        /// Original was GL_ARRAY_ELEMENT_LOCK_COUNT_EXT = 0x81A9
        /// </summary>
        ArrayElementLockCountExt = ((int)0x81A9)        ,
        /// <summary>
        /// Original was GL_CULL_VERTEX_EXT = 0x81AA
        /// </summary>
        CullVertexExt = ((int)0x81AA)        ,
        /// <summary>
        /// Original was GL_CULL_VERTEX_EYE_POSITION_EXT = 0x81AB
        /// </summary>
        CullVertexEyePositionExt = ((int)0x81AB)        ,
        /// <summary>
        /// Original was GL_CULL_VERTEX_OBJECT_POSITION_EXT = 0x81AC
        /// </summary>
        CullVertexObjectPositionExt = ((int)0x81AC)        ,
        /// <summary>
        /// Original was GL_IUI_V2F_EXT = 0x81AD
        /// </summary>
        IuiV2fExt = ((int)0x81AD)        ,
        /// <summary>
        /// Original was GL_IUI_V3F_EXT = 0x81AE
        /// </summary>
        IuiV3fExt = ((int)0x81AE)        ,
        /// <summary>
        /// Original was GL_IUI_N3F_V2F_EXT = 0x81AF
        /// </summary>
        IuiN3fV2fExt = ((int)0x81AF)        ,
        /// <summary>
        /// Original was GL_IUI_N3F_V3F_EXT = 0x81B0
        /// </summary>
        IuiN3fV3fExt = ((int)0x81B0)        ,
        /// <summary>
        /// Original was GL_T2F_IUI_V2F_EXT = 0x81B1
        /// </summary>
        T2fIuiV2fExt = ((int)0x81B1)        ,
        /// <summary>
        /// Original was GL_T2F_IUI_V3F_EXT = 0x81B2
        /// </summary>
        T2fIuiV3fExt = ((int)0x81B2)        ,
        /// <summary>
        /// Original was GL_T2F_IUI_N3F_V2F_EXT = 0x81B3
        /// </summary>
        T2fIuiN3fV2fExt = ((int)0x81B3)        ,
        /// <summary>
        /// Original was GL_T2F_IUI_N3F_V3F_EXT = 0x81B4
        /// </summary>
        T2fIuiN3fV3fExt = ((int)0x81B4)        ,
        /// <summary>
        /// Original was GL_INDEX_TEST_EXT = 0x81B5
        /// </summary>
        IndexTestExt = ((int)0x81B5)        ,
        /// <summary>
        /// Original was GL_INDEX_TEST_FUNC_EXT = 0x81B6
        /// </summary>
        IndexTestFuncExt = ((int)0x81B6)        ,
        /// <summary>
        /// Original was GL_INDEX_TEST_REF_EXT = 0x81B7
        /// </summary>
        IndexTestRefExt = ((int)0x81B7)        ,
        /// <summary>
        /// Original was GL_INDEX_MATERIAL_EXT = 0x81B8
        /// </summary>
        IndexMaterialExt = ((int)0x81B8)        ,
        /// <summary>
        /// Original was GL_INDEX_MATERIAL_PARAMETER_EXT = 0x81B9
        /// </summary>
        IndexMaterialParameterExt = ((int)0x81B9)        ,
        /// <summary>
        /// Original was GL_INDEX_MATERIAL_FACE_EXT = 0x81BA
        /// </summary>
        IndexMaterialFaceExt = ((int)0x81BA)        ,
        /// <summary>
        /// Original was GL_YCRCB_422_SGIX = 0x81BB
        /// </summary>
        Ycrcb422Sgix = ((int)0x81BB)        ,
        /// <summary>
        /// Original was GL_YCRCB_444_SGIX = 0x81BC
        /// </summary>
        Ycrcb444Sgix = ((int)0x81BC)        ,
        /// <summary>
        /// Original was GL_WRAP_BORDER_SUN = 0x81D4
        /// </summary>
        WrapBorderSun = ((int)0x81D4)        ,
        /// <summary>
        /// Original was GL_UNPACK_CONSTANT_DATA_SUNX = 0x81D5
        /// </summary>
        UnpackConstantDataSunx = ((int)0x81D5)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CONSTANT_DATA_SUNX = 0x81D6
        /// </summary>
        TextureConstantDataSunx = ((int)0x81D6)        ,
        /// <summary>
        /// Original was GL_TRIANGLE_LIST_SUN = 0x81D7
        /// </summary>
        TriangleListSun = ((int)0x81D7)        ,
        /// <summary>
        /// Original was GL_REPLACEMENT_CODE_SUN = 0x81D8
        /// </summary>
        ReplacementCodeSun = ((int)0x81D8)        ,
        /// <summary>
        /// Original was GL_GLOBAL_ALPHA_SUN = 0x81D9
        /// </summary>
        GlobalAlphaSun = ((int)0x81D9)        ,
        /// <summary>
        /// Original was GL_GLOBAL_ALPHA_FACTOR_SUN = 0x81DA
        /// </summary>
        GlobalAlphaFactorSun = ((int)0x81DA)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COLOR_WRITEMASK_SGIS = 0x81EF
        /// </summary>
        TextureColorWritemaskSgis = ((int)0x81EF)        ,
        /// <summary>
        /// Original was GL_EYE_DISTANCE_TO_POINT_SGIS = 0x81F0
        /// </summary>
        EyeDistanceToPointSgis = ((int)0x81F0)        ,
        /// <summary>
        /// Original was GL_OBJECT_DISTANCE_TO_POINT_SGIS = 0x81F1
        /// </summary>
        ObjectDistanceToPointSgis = ((int)0x81F1)        ,
        /// <summary>
        /// Original was GL_EYE_DISTANCE_TO_LINE_SGIS = 0x81F2
        /// </summary>
        EyeDistanceToLineSgis = ((int)0x81F2)        ,
        /// <summary>
        /// Original was GL_OBJECT_DISTANCE_TO_LINE_SGIS = 0x81F3
        /// </summary>
        ObjectDistanceToLineSgis = ((int)0x81F3)        ,
        /// <summary>
        /// Original was GL_EYE_POINT_SGIS = 0x81F4
        /// </summary>
        EyePointSgis = ((int)0x81F4)        ,
        /// <summary>
        /// Original was GL_OBJECT_POINT_SGIS = 0x81F5
        /// </summary>
        ObjectPointSgis = ((int)0x81F5)        ,
        /// <summary>
        /// Original was GL_EYE_LINE_SGIS = 0x81F6
        /// </summary>
        EyeLineSgis = ((int)0x81F6)        ,
        /// <summary>
        /// Original was GL_OBJECT_LINE_SGIS = 0x81F7
        /// </summary>
        ObjectLineSgis = ((int)0x81F7)        ,
        /// <summary>
        /// Original was GL_LIGHT_MODEL_COLOR_CONTROL = 0x81F8
        /// </summary>
        LightModelColorControl = ((int)0x81F8)        ,
        /// <summary>
        /// Original was GL_LIGHT_MODEL_COLOR_CONTROL_EXT = 0x81F8
        /// </summary>
        LightModelColorControlExt = ((int)0x81F8)        ,
        /// <summary>
        /// Original was GL_SINGLE_COLOR = 0x81F9
        /// </summary>
        SingleColor = ((int)0x81F9)        ,
        /// <summary>
        /// Original was GL_SINGLE_COLOR_EXT = 0x81F9
        /// </summary>
        SingleColorExt = ((int)0x81F9)        ,
        /// <summary>
        /// Original was GL_SEPARATE_SPECULAR_COLOR = 0x81FA
        /// </summary>
        SeparateSpecularColor = ((int)0x81FA)        ,
        /// <summary>
        /// Original was GL_SEPARATE_SPECULAR_COLOR_EXT = 0x81FA
        /// </summary>
        SeparateSpecularColorExt = ((int)0x81FA)        ,
        /// <summary>
        /// Original was GL_SHARED_TEXTURE_PALETTE_EXT = 0x81FB
        /// </summary>
        SharedTexturePaletteExt = ((int)0x81FB)        ,
        /// <summary>
        /// Original was GL_TEXT_FRAGMENT_SHADER_ATI = 0x8200
        /// </summary>
        TextFragmentShaderAti = ((int)0x8200)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = 0x8210
        /// </summary>
        FramebufferAttachmentColorEncoding = ((int)0x8210)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = 0x8211
        /// </summary>
        FramebufferAttachmentComponentType = ((int)0x8211)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE = 0x8212
        /// </summary>
        FramebufferAttachmentRedSize = ((int)0x8212)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = 0x8213
        /// </summary>
        FramebufferAttachmentGreenSize = ((int)0x8213)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = 0x8214
        /// </summary>
        FramebufferAttachmentBlueSize = ((int)0x8214)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = 0x8215
        /// </summary>
        FramebufferAttachmentAlphaSize = ((int)0x8215)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = 0x8216
        /// </summary>
        FramebufferAttachmentDepthSize = ((int)0x8216)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = 0x8217
        /// </summary>
        FramebufferAttachmentStencilSize = ((int)0x8217)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_DEFAULT = 0x8218
        /// </summary>
        FramebufferDefault = ((int)0x8218)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_UNDEFINED = 0x8219
        /// </summary>
        FramebufferUndefined = ((int)0x8219)        ,
        /// <summary>
        /// Original was GL_DEPTH_STENCIL_ATTACHMENT = 0x821A
        /// </summary>
        DepthStencilAttachment = ((int)0x821A)        ,
        /// <summary>
        /// Original was GL_MAJOR_VERSION = 0x821B
        /// </summary>
        MajorVersion = ((int)0x821B)        ,
        /// <summary>
        /// Original was GL_MINOR_VERSION = 0x821C
        /// </summary>
        MinorVersion = ((int)0x821C)        ,
        /// <summary>
        /// Original was GL_NUM_EXTENSIONS = 0x821D
        /// </summary>
        NumExtensions = ((int)0x821D)        ,
        /// <summary>
        /// Original was GL_CONTEXT_FLAGS = 0x821E
        /// </summary>
        ContextFlags = ((int)0x821E)        ,
        /// <summary>
        /// Original was GL_BUFFER_IMMUTABLE_STORAGE = 0x821F
        /// </summary>
        BufferImmutableStorage = ((int)0x821F)        ,
        /// <summary>
        /// Original was GL_BUFFER_STORAGE_FLAGS = 0x8220
        /// </summary>
        BufferStorageFlags = ((int)0x8220)        ,
        /// <summary>
        /// Original was GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED = 0x8221
        /// </summary>
        PrimitiveRestartForPatchesSupported = ((int)0x8221)        ,
        /// <summary>
        /// Original was GL_INDEX = 0x8222
        /// </summary>
        Index = ((int)0x8222)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RED = 0x8225
        /// </summary>
        CompressedRed = ((int)0x8225)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RG = 0x8226
        /// </summary>
        CompressedRg = ((int)0x8226)        ,
        /// <summary>
        /// Original was GL_RG = 0x8227
        /// </summary>
        Rg = ((int)0x8227)        ,
        /// <summary>
        /// Original was GL_RG_INTEGER = 0x8228
        /// </summary>
        RgInteger = ((int)0x8228)        ,
        /// <summary>
        /// Original was GL_R8 = 0x8229
        /// </summary>
        R8 = ((int)0x8229)        ,
        /// <summary>
        /// Original was GL_R16 = 0x822A
        /// </summary>
        R16 = ((int)0x822A)        ,
        /// <summary>
        /// Original was GL_RG8 = 0x822B
        /// </summary>
        Rg8 = ((int)0x822B)        ,
        /// <summary>
        /// Original was GL_RG16 = 0x822C
        /// </summary>
        Rg16 = ((int)0x822C)        ,
        /// <summary>
        /// Original was GL_R16F = 0x822D
        /// </summary>
        R16f = ((int)0x822D)        ,
        /// <summary>
        /// Original was GL_R32F = 0x822E
        /// </summary>
        R32f = ((int)0x822E)        ,
        /// <summary>
        /// Original was GL_RG16F = 0x822F
        /// </summary>
        Rg16f = ((int)0x822F)        ,
        /// <summary>
        /// Original was GL_RG32F = 0x8230
        /// </summary>
        Rg32f = ((int)0x8230)        ,
        /// <summary>
        /// Original was GL_R8I = 0x8231
        /// </summary>
        R8i = ((int)0x8231)        ,
        /// <summary>
        /// Original was GL_R8UI = 0x8232
        /// </summary>
        R8ui = ((int)0x8232)        ,
        /// <summary>
        /// Original was GL_R16I = 0x8233
        /// </summary>
        R16i = ((int)0x8233)        ,
        /// <summary>
        /// Original was GL_R16UI = 0x8234
        /// </summary>
        R16ui = ((int)0x8234)        ,
        /// <summary>
        /// Original was GL_R32I = 0x8235
        /// </summary>
        R32i = ((int)0x8235)        ,
        /// <summary>
        /// Original was GL_R32UI = 0x8236
        /// </summary>
        R32ui = ((int)0x8236)        ,
        /// <summary>
        /// Original was GL_RG8I = 0x8237
        /// </summary>
        Rg8i = ((int)0x8237)        ,
        /// <summary>
        /// Original was GL_RG8UI = 0x8238
        /// </summary>
        Rg8ui = ((int)0x8238)        ,
        /// <summary>
        /// Original was GL_RG16I = 0x8239
        /// </summary>
        Rg16i = ((int)0x8239)        ,
        /// <summary>
        /// Original was GL_RG16UI = 0x823A
        /// </summary>
        Rg16ui = ((int)0x823A)        ,
        /// <summary>
        /// Original was GL_RG32I = 0x823B
        /// </summary>
        Rg32i = ((int)0x823B)        ,
        /// <summary>
        /// Original was GL_RG32UI = 0x823C
        /// </summary>
        Rg32ui = ((int)0x823C)        ,
        /// <summary>
        /// Original was GL_SYNC_CL_EVENT_ARB = 0x8240
        /// </summary>
        SyncClEventArb = ((int)0x8240)        ,
        /// <summary>
        /// Original was GL_SYNC_CL_EVENT_COMPLETE_ARB = 0x8241
        /// </summary>
        SyncClEventCompleteArb = ((int)0x8241)        ,
        /// <summary>
        /// Original was GL_DEBUG_OUTPUT_SYNCHRONOUS = 0x8242
        /// </summary>
        DebugOutputSynchronous = ((int)0x8242)        ,
        /// <summary>
        /// Original was GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB = 0x8242
        /// </summary>
        DebugOutputSynchronousArb = ((int)0x8242)        ,
        /// <summary>
        /// Original was GL_DEBUG_OUTPUT_SYNCHRONOUS_KHR = 0x8242
        /// </summary>
        DebugOutputSynchronousKhr = ((int)0x8242)        ,
        /// <summary>
        /// Original was GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH = 0x8243
        /// </summary>
        DebugNextLoggedMessageLength = ((int)0x8243)        ,
        /// <summary>
        /// Original was GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB = 0x8243
        /// </summary>
        DebugNextLoggedMessageLengthArb = ((int)0x8243)        ,
        /// <summary>
        /// Original was GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR = 0x8243
        /// </summary>
        DebugNextLoggedMessageLengthKhr = ((int)0x8243)        ,
        /// <summary>
        /// Original was GL_DEBUG_CALLBACK_FUNCTION = 0x8244
        /// </summary>
        DebugCallbackFunction = ((int)0x8244)        ,
        /// <summary>
        /// Original was GL_DEBUG_CALLBACK_FUNCTION_ARB = 0x8244
        /// </summary>
        DebugCallbackFunctionArb = ((int)0x8244)        ,
        /// <summary>
        /// Original was GL_DEBUG_CALLBACK_FUNCTION_KHR = 0x8244
        /// </summary>
        DebugCallbackFunctionKhr = ((int)0x8244)        ,
        /// <summary>
        /// Original was GL_DEBUG_CALLBACK_USER_PARAM = 0x8245
        /// </summary>
        DebugCallbackUserParam = ((int)0x8245)        ,
        /// <summary>
        /// Original was GL_DEBUG_CALLBACK_USER_PARAM_ARB = 0x8245
        /// </summary>
        DebugCallbackUserParamArb = ((int)0x8245)        ,
        /// <summary>
        /// Original was GL_DEBUG_CALLBACK_USER_PARAM_KHR = 0x8245
        /// </summary>
        DebugCallbackUserParamKhr = ((int)0x8245)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_API = 0x8246
        /// </summary>
        DebugSourceApi = ((int)0x8246)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_API_ARB = 0x8246
        /// </summary>
        DebugSourceApiArb = ((int)0x8246)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_API_KHR = 0x8246
        /// </summary>
        DebugSourceApiKhr = ((int)0x8246)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_WINDOW_SYSTEM = 0x8247
        /// </summary>
        DebugSourceWindowSystem = ((int)0x8247)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB = 0x8247
        /// </summary>
        DebugSourceWindowSystemArb = ((int)0x8247)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR = 0x8247
        /// </summary>
        DebugSourceWindowSystemKhr = ((int)0x8247)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_SHADER_COMPILER = 0x8248
        /// </summary>
        DebugSourceShaderCompiler = ((int)0x8248)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_SHADER_COMPILER_ARB = 0x8248
        /// </summary>
        DebugSourceShaderCompilerArb = ((int)0x8248)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_SHADER_COMPILER_KHR = 0x8248
        /// </summary>
        DebugSourceShaderCompilerKhr = ((int)0x8248)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_THIRD_PARTY = 0x8249
        /// </summary>
        DebugSourceThirdParty = ((int)0x8249)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_THIRD_PARTY_ARB = 0x8249
        /// </summary>
        DebugSourceThirdPartyArb = ((int)0x8249)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_THIRD_PARTY_KHR = 0x8249
        /// </summary>
        DebugSourceThirdPartyKhr = ((int)0x8249)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_APPLICATION = 0x824A
        /// </summary>
        DebugSourceApplication = ((int)0x824A)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_APPLICATION_ARB = 0x824A
        /// </summary>
        DebugSourceApplicationArb = ((int)0x824A)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_APPLICATION_KHR = 0x824A
        /// </summary>
        DebugSourceApplicationKhr = ((int)0x824A)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_OTHER = 0x824B
        /// </summary>
        DebugSourceOther = ((int)0x824B)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_OTHER_ARB = 0x824B
        /// </summary>
        DebugSourceOtherArb = ((int)0x824B)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_OTHER_KHR = 0x824B
        /// </summary>
        DebugSourceOtherKhr = ((int)0x824B)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_ERROR = 0x824C
        /// </summary>
        DebugTypeError = ((int)0x824C)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_ERROR_ARB = 0x824C
        /// </summary>
        DebugTypeErrorArb = ((int)0x824C)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_ERROR_KHR = 0x824C
        /// </summary>
        DebugTypeErrorKhr = ((int)0x824C)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR = 0x824D
        /// </summary>
        DebugTypeDeprecatedBehavior = ((int)0x824D)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB = 0x824D
        /// </summary>
        DebugTypeDeprecatedBehaviorArb = ((int)0x824D)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR = 0x824D
        /// </summary>
        DebugTypeDeprecatedBehaviorKhr = ((int)0x824D)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR = 0x824E
        /// </summary>
        DebugTypeUndefinedBehavior = ((int)0x824E)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB = 0x824E
        /// </summary>
        DebugTypeUndefinedBehaviorArb = ((int)0x824E)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR = 0x824E
        /// </summary>
        DebugTypeUndefinedBehaviorKhr = ((int)0x824E)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_PORTABILITY = 0x824F
        /// </summary>
        DebugTypePortability = ((int)0x824F)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_PORTABILITY_ARB = 0x824F
        /// </summary>
        DebugTypePortabilityArb = ((int)0x824F)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_PORTABILITY_KHR = 0x824F
        /// </summary>
        DebugTypePortabilityKhr = ((int)0x824F)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_PERFORMANCE = 0x8250
        /// </summary>
        DebugTypePerformance = ((int)0x8250)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_PERFORMANCE_ARB = 0x8250
        /// </summary>
        DebugTypePerformanceArb = ((int)0x8250)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_PERFORMANCE_KHR = 0x8250
        /// </summary>
        DebugTypePerformanceKhr = ((int)0x8250)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_OTHER = 0x8251
        /// </summary>
        DebugTypeOther = ((int)0x8251)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_OTHER_ARB = 0x8251
        /// </summary>
        DebugTypeOtherArb = ((int)0x8251)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_OTHER_KHR = 0x8251
        /// </summary>
        DebugTypeOtherKhr = ((int)0x8251)        ,
        /// <summary>
        /// Original was GL_LOSE_CONTEXT_ON_RESET_ARB = 0x8252
        /// </summary>
        LoseContextOnResetArb = ((int)0x8252)        ,
        /// <summary>
        /// Original was GL_GUILTY_CONTEXT_RESET_ARB = 0x8253
        /// </summary>
        GuiltyContextResetArb = ((int)0x8253)        ,
        /// <summary>
        /// Original was GL_INNOCENT_CONTEXT_RESET_ARB = 0x8254
        /// </summary>
        InnocentContextResetArb = ((int)0x8254)        ,
        /// <summary>
        /// Original was GL_UNKNOWN_CONTEXT_RESET_ARB = 0x8255
        /// </summary>
        UnknownContextResetArb = ((int)0x8255)        ,
        /// <summary>
        /// Original was GL_RESET_NOTIFICATION_STRATEGY_ARB = 0x8256
        /// </summary>
        ResetNotificationStrategyArb = ((int)0x8256)        ,
        /// <summary>
        /// Original was GL_PROGRAM_BINARY_RETRIEVABLE_HINT = 0x8257
        /// </summary>
        ProgramBinaryRetrievableHint = ((int)0x8257)        ,
        /// <summary>
        /// Original was GL_PROGRAM_SEPARABLE = 0x8258
        /// </summary>
        ProgramSeparable = ((int)0x8258)        ,
        /// <summary>
        /// Original was GL_PROGRAM_SEPARABLE_EXT = 0x8258
        /// </summary>
        ProgramSeparableExt = ((int)0x8258)        ,
        /// <summary>
        /// Original was GL_ACTIVE_PROGRAM = 0x8259
        /// </summary>
        ActiveProgram = ((int)0x8259)        ,
        /// <summary>
        /// Original was GL_PROGRAM_PIPELINE_BINDING = 0x825A
        /// </summary>
        ProgramPipelineBinding = ((int)0x825A)        ,
        /// <summary>
        /// Original was GL_PROGRAM_PIPELINE_BINDING_EXT = 0x825A
        /// </summary>
        ProgramPipelineBindingExt = ((int)0x825A)        ,
        /// <summary>
        /// Original was GL_MAX_VIEWPORTS = 0x825B
        /// </summary>
        MaxViewports = ((int)0x825B)        ,
        /// <summary>
        /// Original was GL_VIEWPORT_SUBPIXEL_BITS = 0x825C
        /// </summary>
        ViewportSubpixelBits = ((int)0x825C)        ,
        /// <summary>
        /// Original was GL_VIEWPORT_BOUNDS_RANGE = 0x825D
        /// </summary>
        ViewportBoundsRange = ((int)0x825D)        ,
        /// <summary>
        /// Original was GL_LAYER_PROVOKING_VERTEX = 0x825E
        /// </summary>
        LayerProvokingVertex = ((int)0x825E)        ,
        /// <summary>
        /// Original was GL_VIEWPORT_INDEX_PROVOKING_VERTEX = 0x825F
        /// </summary>
        ViewportIndexProvokingVertex = ((int)0x825F)        ,
        /// <summary>
        /// Original was GL_UNDEFINED_VERTEX = 0x8260
        /// </summary>
        UndefinedVertex = ((int)0x8260)        ,
        /// <summary>
        /// Original was GL_NO_RESET_NOTIFICATION_ARB = 0x8261
        /// </summary>
        NoResetNotificationArb = ((int)0x8261)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_SHARED_MEMORY_SIZE = 0x8262
        /// </summary>
        MaxComputeSharedMemorySize = ((int)0x8262)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_UNIFORM_COMPONENTS = 0x8263
        /// </summary>
        MaxComputeUniformComponents = ((int)0x8263)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS = 0x8264
        /// </summary>
        MaxComputeAtomicCounterBuffers = ((int)0x8264)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_ATOMIC_COUNTERS = 0x8265
        /// </summary>
        MaxComputeAtomicCounters = ((int)0x8265)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS = 0x8266
        /// </summary>
        MaxCombinedComputeUniformComponents = ((int)0x8266)        ,
        /// <summary>
        /// Original was GL_COMPUTE_WORK_GROUP_SIZE = 0x8267
        /// </summary>
        ComputeWorkGroupSize = ((int)0x8267)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_MARKER = 0x8268
        /// </summary>
        DebugTypeMarker = ((int)0x8268)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_MARKER_KHR = 0x8268
        /// </summary>
        DebugTypeMarkerKhr = ((int)0x8268)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_PUSH_GROUP = 0x8269
        /// </summary>
        DebugTypePushGroup = ((int)0x8269)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_PUSH_GROUP_KHR = 0x8269
        /// </summary>
        DebugTypePushGroupKhr = ((int)0x8269)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_POP_GROUP = 0x826A
        /// </summary>
        DebugTypePopGroup = ((int)0x826A)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_POP_GROUP_KHR = 0x826A
        /// </summary>
        DebugTypePopGroupKhr = ((int)0x826A)        ,
        /// <summary>
        /// Original was GL_DEBUG_SEVERITY_NOTIFICATION = 0x826B
        /// </summary>
        DebugSeverityNotification = ((int)0x826B)        ,
        /// <summary>
        /// Original was GL_DEBUG_SEVERITY_NOTIFICATION_KHR = 0x826B
        /// </summary>
        DebugSeverityNotificationKhr = ((int)0x826B)        ,
        /// <summary>
        /// Original was GL_MAX_DEBUG_GROUP_STACK_DEPTH = 0x826C
        /// </summary>
        MaxDebugGroupStackDepth = ((int)0x826C)        ,
        /// <summary>
        /// Original was GL_MAX_DEBUG_GROUP_STACK_DEPTH_KHR = 0x826C
        /// </summary>
        MaxDebugGroupStackDepthKhr = ((int)0x826C)        ,
        /// <summary>
        /// Original was GL_DEBUG_GROUP_STACK_DEPTH = 0x826D
        /// </summary>
        DebugGroupStackDepth = ((int)0x826D)        ,
        /// <summary>
        /// Original was GL_DEBUG_GROUP_STACK_DEPTH_KHR = 0x826D
        /// </summary>
        DebugGroupStackDepthKhr = ((int)0x826D)        ,
        /// <summary>
        /// Original was GL_MAX_UNIFORM_LOCATIONS = 0x826E
        /// </summary>
        MaxUniformLocations = ((int)0x826E)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_SUPPORTED = 0x826F
        /// </summary>
        InternalformatSupported = ((int)0x826F)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_PREFERRED = 0x8270
        /// </summary>
        InternalformatPreferred = ((int)0x8270)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_RED_SIZE = 0x8271
        /// </summary>
        InternalformatRedSize = ((int)0x8271)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_GREEN_SIZE = 0x8272
        /// </summary>
        InternalformatGreenSize = ((int)0x8272)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_BLUE_SIZE = 0x8273
        /// </summary>
        InternalformatBlueSize = ((int)0x8273)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_ALPHA_SIZE = 0x8274
        /// </summary>
        InternalformatAlphaSize = ((int)0x8274)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_DEPTH_SIZE = 0x8275
        /// </summary>
        InternalformatDepthSize = ((int)0x8275)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_STENCIL_SIZE = 0x8276
        /// </summary>
        InternalformatStencilSize = ((int)0x8276)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_SHARED_SIZE = 0x8277
        /// </summary>
        InternalformatSharedSize = ((int)0x8277)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_RED_TYPE = 0x8278
        /// </summary>
        InternalformatRedType = ((int)0x8278)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_GREEN_TYPE = 0x8279
        /// </summary>
        InternalformatGreenType = ((int)0x8279)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_BLUE_TYPE = 0x827A
        /// </summary>
        InternalformatBlueType = ((int)0x827A)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_ALPHA_TYPE = 0x827B
        /// </summary>
        InternalformatAlphaType = ((int)0x827B)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_DEPTH_TYPE = 0x827C
        /// </summary>
        InternalformatDepthType = ((int)0x827C)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_STENCIL_TYPE = 0x827D
        /// </summary>
        InternalformatStencilType = ((int)0x827D)        ,
        /// <summary>
        /// Original was GL_MAX_WIDTH = 0x827E
        /// </summary>
        MaxWidth = ((int)0x827E)        ,
        /// <summary>
        /// Original was GL_MAX_HEIGHT = 0x827F
        /// </summary>
        MaxHeight = ((int)0x827F)        ,
        /// <summary>
        /// Original was GL_MAX_DEPTH = 0x8280
        /// </summary>
        MaxDepth = ((int)0x8280)        ,
        /// <summary>
        /// Original was GL_MAX_LAYERS = 0x8281
        /// </summary>
        MaxLayers = ((int)0x8281)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_DIMENSIONS = 0x8282
        /// </summary>
        MaxCombinedDimensions = ((int)0x8282)        ,
        /// <summary>
        /// Original was GL_COLOR_COMPONENTS = 0x8283
        /// </summary>
        ColorComponents = ((int)0x8283)        ,
        /// <summary>
        /// Original was GL_DEPTH_COMPONENTS = 0x8284
        /// </summary>
        DepthComponents = ((int)0x8284)        ,
        /// <summary>
        /// Original was GL_STENCIL_COMPONENTS = 0x8285
        /// </summary>
        StencilComponents = ((int)0x8285)        ,
        /// <summary>
        /// Original was GL_COLOR_RENDERABLE = 0x8286
        /// </summary>
        ColorRenderable = ((int)0x8286)        ,
        /// <summary>
        /// Original was GL_DEPTH_RENDERABLE = 0x8287
        /// </summary>
        DepthRenderable = ((int)0x8287)        ,
        /// <summary>
        /// Original was GL_STENCIL_RENDERABLE = 0x8288
        /// </summary>
        StencilRenderable = ((int)0x8288)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_RENDERABLE = 0x8289
        /// </summary>
        FramebufferRenderable = ((int)0x8289)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_RENDERABLE_LAYERED = 0x828A
        /// </summary>
        FramebufferRenderableLayered = ((int)0x828A)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_BLEND = 0x828B
        /// </summary>
        FramebufferBlend = ((int)0x828B)        ,
        /// <summary>
        /// Original was GL_READ_PIXELS = 0x828C
        /// </summary>
        ReadPixels = ((int)0x828C)        ,
        /// <summary>
        /// Original was GL_READ_PIXELS_FORMAT = 0x828D
        /// </summary>
        ReadPixelsFormat = ((int)0x828D)        ,
        /// <summary>
        /// Original was GL_READ_PIXELS_TYPE = 0x828E
        /// </summary>
        ReadPixelsType = ((int)0x828E)        ,
        /// <summary>
        /// Original was GL_TEXTURE_IMAGE_FORMAT = 0x828F
        /// </summary>
        TextureImageFormat = ((int)0x828F)        ,
        /// <summary>
        /// Original was GL_TEXTURE_IMAGE_TYPE = 0x8290
        /// </summary>
        TextureImageType = ((int)0x8290)        ,
        /// <summary>
        /// Original was GL_GET_TEXTURE_IMAGE_FORMAT = 0x8291
        /// </summary>
        GetTextureImageFormat = ((int)0x8291)        ,
        /// <summary>
        /// Original was GL_GET_TEXTURE_IMAGE_TYPE = 0x8292
        /// </summary>
        GetTextureImageType = ((int)0x8292)        ,
        /// <summary>
        /// Original was GL_MIPMAP = 0x8293
        /// </summary>
        Mipmap = ((int)0x8293)        ,
        /// <summary>
        /// Original was GL_MANUAL_GENERATE_MIPMAP = 0x8294
        /// </summary>
        ManualGenerateMipmap = ((int)0x8294)        ,
        /// <summary>
        /// Original was GL_AUTO_GENERATE_MIPMAP = 0x8295
        /// </summary>
        AutoGenerateMipmap = ((int)0x8295)        ,
        /// <summary>
        /// Original was GL_COLOR_ENCODING = 0x8296
        /// </summary>
        ColorEncoding = ((int)0x8296)        ,
        /// <summary>
        /// Original was GL_SRGB_READ = 0x8297
        /// </summary>
        SrgbRead = ((int)0x8297)        ,
        /// <summary>
        /// Original was GL_SRGB_WRITE = 0x8298
        /// </summary>
        SrgbWrite = ((int)0x8298)        ,
        /// <summary>
        /// Original was GL_SRGB_DECODE_ARB = 0x8299
        /// </summary>
        SrgbDecodeArb = ((int)0x8299)        ,
        /// <summary>
        /// Original was GL_FILTER = 0x829A
        /// </summary>
        Filter = ((int)0x829A)        ,
        /// <summary>
        /// Original was GL_VERTEX_TEXTURE = 0x829B
        /// </summary>
        VertexTexture = ((int)0x829B)        ,
        /// <summary>
        /// Original was GL_TESS_CONTROL_TEXTURE = 0x829C
        /// </summary>
        TessControlTexture = ((int)0x829C)        ,
        /// <summary>
        /// Original was GL_TESS_EVALUATION_TEXTURE = 0x829D
        /// </summary>
        TessEvaluationTexture = ((int)0x829D)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_TEXTURE = 0x829E
        /// </summary>
        GeometryTexture = ((int)0x829E)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_TEXTURE = 0x829F
        /// </summary>
        FragmentTexture = ((int)0x829F)        ,
        /// <summary>
        /// Original was GL_COMPUTE_TEXTURE = 0x82A0
        /// </summary>
        ComputeTexture = ((int)0x82A0)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SHADOW = 0x82A1
        /// </summary>
        TextureShadow = ((int)0x82A1)        ,
        /// <summary>
        /// Original was GL_TEXTURE_GATHER = 0x82A2
        /// </summary>
        TextureGather = ((int)0x82A2)        ,
        /// <summary>
        /// Original was GL_TEXTURE_GATHER_SHADOW = 0x82A3
        /// </summary>
        TextureGatherShadow = ((int)0x82A3)        ,
        /// <summary>
        /// Original was GL_SHADER_IMAGE_LOAD = 0x82A4
        /// </summary>
        ShaderImageLoad = ((int)0x82A4)        ,
        /// <summary>
        /// Original was GL_SHADER_IMAGE_STORE = 0x82A5
        /// </summary>
        ShaderImageStore = ((int)0x82A5)        ,
        /// <summary>
        /// Original was GL_SHADER_IMAGE_ATOMIC = 0x82A6
        /// </summary>
        ShaderImageAtomic = ((int)0x82A6)        ,
        /// <summary>
        /// Original was GL_IMAGE_TEXEL_SIZE = 0x82A7
        /// </summary>
        ImageTexelSize = ((int)0x82A7)        ,
        /// <summary>
        /// Original was GL_IMAGE_COMPATIBILITY_CLASS = 0x82A8
        /// </summary>
        ImageCompatibilityClass = ((int)0x82A8)        ,
        /// <summary>
        /// Original was GL_IMAGE_PIXEL_FORMAT = 0x82A9
        /// </summary>
        ImagePixelFormat = ((int)0x82A9)        ,
        /// <summary>
        /// Original was GL_IMAGE_PIXEL_TYPE = 0x82AA
        /// </summary>
        ImagePixelType = ((int)0x82AA)        ,
        /// <summary>
        /// Original was GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST = 0x82AC
        /// </summary>
        SimultaneousTextureAndDepthTest = ((int)0x82AC)        ,
        /// <summary>
        /// Original was GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST = 0x82AD
        /// </summary>
        SimultaneousTextureAndStencilTest = ((int)0x82AD)        ,
        /// <summary>
        /// Original was GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE = 0x82AE
        /// </summary>
        SimultaneousTextureAndDepthWrite = ((int)0x82AE)        ,
        /// <summary>
        /// Original was GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE = 0x82AF
        /// </summary>
        SimultaneousTextureAndStencilWrite = ((int)0x82AF)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPRESSED_BLOCK_WIDTH = 0x82B1
        /// </summary>
        TextureCompressedBlockWidth = ((int)0x82B1)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT = 0x82B2
        /// </summary>
        TextureCompressedBlockHeight = ((int)0x82B2)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPRESSED_BLOCK_SIZE = 0x82B3
        /// </summary>
        TextureCompressedBlockSize = ((int)0x82B3)        ,
        /// <summary>
        /// Original was GL_CLEAR_BUFFER = 0x82B4
        /// </summary>
        ClearBuffer = ((int)0x82B4)        ,
        /// <summary>
        /// Original was GL_TEXTURE_VIEW = 0x82B5
        /// </summary>
        TextureView = ((int)0x82B5)        ,
        /// <summary>
        /// Original was GL_VIEW_COMPATIBILITY_CLASS = 0x82B6
        /// </summary>
        ViewCompatibilityClass = ((int)0x82B6)        ,
        /// <summary>
        /// Original was GL_FULL_SUPPORT = 0x82B7
        /// </summary>
        FullSupport = ((int)0x82B7)        ,
        /// <summary>
        /// Original was GL_CAVEAT_SUPPORT = 0x82B8
        /// </summary>
        CaveatSupport = ((int)0x82B8)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_4_X_32 = 0x82B9
        /// </summary>
        ImageClass4X32 = ((int)0x82B9)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_2_X_32 = 0x82BA
        /// </summary>
        ImageClass2X32 = ((int)0x82BA)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_1_X_32 = 0x82BB
        /// </summary>
        ImageClass1X32 = ((int)0x82BB)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_4_X_16 = 0x82BC
        /// </summary>
        ImageClass4X16 = ((int)0x82BC)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_2_X_16 = 0x82BD
        /// </summary>
        ImageClass2X16 = ((int)0x82BD)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_1_X_16 = 0x82BE
        /// </summary>
        ImageClass1X16 = ((int)0x82BE)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_4_X_8 = 0x82BF
        /// </summary>
        ImageClass4X8 = ((int)0x82BF)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_2_X_8 = 0x82C0
        /// </summary>
        ImageClass2X8 = ((int)0x82C0)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_1_X_8 = 0x82C1
        /// </summary>
        ImageClass1X8 = ((int)0x82C1)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_11_11_10 = 0x82C2
        /// </summary>
        ImageClass111110 = ((int)0x82C2)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_10_10_10_2 = 0x82C3
        /// </summary>
        ImageClass1010102 = ((int)0x82C3)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_128_BITS = 0x82C4
        /// </summary>
        ViewClass128Bits = ((int)0x82C4)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_96_BITS = 0x82C5
        /// </summary>
        ViewClass96Bits = ((int)0x82C5)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_64_BITS = 0x82C6
        /// </summary>
        ViewClass64Bits = ((int)0x82C6)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_48_BITS = 0x82C7
        /// </summary>
        ViewClass48Bits = ((int)0x82C7)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_32_BITS = 0x82C8
        /// </summary>
        ViewClass32Bits = ((int)0x82C8)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_24_BITS = 0x82C9
        /// </summary>
        ViewClass24Bits = ((int)0x82C9)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_16_BITS = 0x82CA
        /// </summary>
        ViewClass16Bits = ((int)0x82CA)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_8_BITS = 0x82CB
        /// </summary>
        ViewClass8Bits = ((int)0x82CB)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_S3TC_DXT1_RGB = 0x82CC
        /// </summary>
        ViewClassS3tcDxt1Rgb = ((int)0x82CC)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_S3TC_DXT1_RGBA = 0x82CD
        /// </summary>
        ViewClassS3tcDxt1Rgba = ((int)0x82CD)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_S3TC_DXT3_RGBA = 0x82CE
        /// </summary>
        ViewClassS3tcDxt3Rgba = ((int)0x82CE)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_S3TC_DXT5_RGBA = 0x82CF
        /// </summary>
        ViewClassS3tcDxt5Rgba = ((int)0x82CF)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_RGTC1_RED = 0x82D0
        /// </summary>
        ViewClassRgtc1Red = ((int)0x82D0)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_RGTC2_RG = 0x82D1
        /// </summary>
        ViewClassRgtc2Rg = ((int)0x82D1)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_BPTC_UNORM = 0x82D2
        /// </summary>
        ViewClassBptcUnorm = ((int)0x82D2)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_BPTC_FLOAT = 0x82D3
        /// </summary>
        ViewClassBptcFloat = ((int)0x82D3)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_BINDING = 0x82D4
        /// </summary>
        VertexAttribBinding = ((int)0x82D4)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_RELATIVE_OFFSET = 0x82D5
        /// </summary>
        VertexAttribRelativeOffset = ((int)0x82D5)        ,
        /// <summary>
        /// Original was GL_VERTEX_BINDING_DIVISOR = 0x82D6
        /// </summary>
        VertexBindingDivisor = ((int)0x82D6)        ,
        /// <summary>
        /// Original was GL_VERTEX_BINDING_OFFSET = 0x82D7
        /// </summary>
        VertexBindingOffset = ((int)0x82D7)        ,
        /// <summary>
        /// Original was GL_VERTEX_BINDING_STRIDE = 0x82D8
        /// </summary>
        VertexBindingStride = ((int)0x82D8)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET = 0x82D9
        /// </summary>
        MaxVertexAttribRelativeOffset = ((int)0x82D9)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_ATTRIB_BINDINGS = 0x82DA
        /// </summary>
        MaxVertexAttribBindings = ((int)0x82DA)        ,
        /// <summary>
        /// Original was GL_TEXTURE_VIEW_MIN_LEVEL = 0x82DB
        /// </summary>
        TextureViewMinLevel = ((int)0x82DB)        ,
        /// <summary>
        /// Original was GL_TEXTURE_VIEW_NUM_LEVELS = 0x82DC
        /// </summary>
        TextureViewNumLevels = ((int)0x82DC)        ,
        /// <summary>
        /// Original was GL_TEXTURE_VIEW_MIN_LAYER = 0x82DD
        /// </summary>
        TextureViewMinLayer = ((int)0x82DD)        ,
        /// <summary>
        /// Original was GL_TEXTURE_VIEW_NUM_LAYERS = 0x82DE
        /// </summary>
        TextureViewNumLayers = ((int)0x82DE)        ,
        /// <summary>
        /// Original was GL_TEXTURE_IMMUTABLE_LEVELS = 0x82DF
        /// </summary>
        TextureImmutableLevels = ((int)0x82DF)        ,
        /// <summary>
        /// Original was GL_BUFFER = 0x82E0
        /// </summary>
        Buffer = ((int)0x82E0)        ,
        /// <summary>
        /// Original was GL_BUFFER_KHR = 0x82E0
        /// </summary>
        BufferKhr = ((int)0x82E0)        ,
        /// <summary>
        /// Original was GL_SHADER = 0x82E1
        /// </summary>
        Shader = ((int)0x82E1)        ,
        /// <summary>
        /// Original was GL_SHADER_KHR = 0x82E1
        /// </summary>
        ShaderKhr = ((int)0x82E1)        ,
        /// <summary>
        /// Original was GL_PROGRAM = 0x82E2
        /// </summary>
        Program = ((int)0x82E2)        ,
        /// <summary>
        /// Original was GL_PROGRAM_KHR = 0x82E2
        /// </summary>
        ProgramKhr = ((int)0x82E2)        ,
        /// <summary>
        /// Original was GL_QUERY = 0x82E3
        /// </summary>
        Query = ((int)0x82E3)        ,
        /// <summary>
        /// Original was GL_QUERY_KHR = 0x82E3
        /// </summary>
        QueryKhr = ((int)0x82E3)        ,
        /// <summary>
        /// Original was GL_PROGRAM_PIPELINE = 0x82E4
        /// </summary>
        ProgramPipeline = ((int)0x82E4)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_ATTRIB_STRIDE = 0x82E5
        /// </summary>
        MaxVertexAttribStride = ((int)0x82E5)        ,
        /// <summary>
        /// Original was GL_SAMPLER = 0x82E6
        /// </summary>
        Sampler = ((int)0x82E6)        ,
        /// <summary>
        /// Original was GL_SAMPLER_KHR = 0x82E6
        /// </summary>
        SamplerKhr = ((int)0x82E6)        ,
        /// <summary>
        /// Original was GL_DISPLAY_LIST = 0x82E7
        /// </summary>
        DisplayList = ((int)0x82E7)        ,
        /// <summary>
        /// Original was GL_MAX_LABEL_LENGTH = 0x82E8
        /// </summary>
        MaxLabelLength = ((int)0x82E8)        ,
        /// <summary>
        /// Original was GL_MAX_LABEL_LENGTH_KHR = 0x82E8
        /// </summary>
        MaxLabelLengthKhr = ((int)0x82E8)        ,
        /// <summary>
        /// Original was GL_NUM_SHADING_LANGUAGE_VERSIONS = 0x82E9
        /// </summary>
        NumShadingLanguageVersions = ((int)0x82E9)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_HINT_SGIX = 0x8316
        /// </summary>
        ConvolutionHintSgix = ((int)0x8316)        ,
        /// <summary>
        /// Original was GL_YCRCB_SGIX = 0x8318
        /// </summary>
        YcrcbSgix = ((int)0x8318)        ,
        /// <summary>
        /// Original was GL_YCRCBA_SGIX = 0x8319
        /// </summary>
        YcrcbaSgix = ((int)0x8319)        ,
        /// <summary>
        /// Original was GL_ALPHA_MIN_SGIX = 0x8320
        /// </summary>
        AlphaMinSgix = ((int)0x8320)        ,
        /// <summary>
        /// Original was GL_ALPHA_MAX_SGIX = 0x8321
        /// </summary>
        AlphaMaxSgix = ((int)0x8321)        ,
        /// <summary>
        /// Original was GL_SCALEBIAS_HINT_SGIX = 0x8322
        /// </summary>
        ScalebiasHintSgix = ((int)0x8322)        ,
        /// <summary>
        /// Original was GL_ASYNC_MARKER_SGIX = 0x8329
        /// </summary>
        AsyncMarkerSgix = ((int)0x8329)        ,
        /// <summary>
        /// Original was GL_PIXEL_TEX_GEN_MODE_SGIX = 0x832B
        /// </summary>
        PixelTexGenModeSgix = ((int)0x832B)        ,
        /// <summary>
        /// Original was GL_ASYNC_HISTOGRAM_SGIX = 0x832C
        /// </summary>
        AsyncHistogramSgix = ((int)0x832C)        ,
        /// <summary>
        /// Original was GL_MAX_ASYNC_HISTOGRAM_SGIX = 0x832D
        /// </summary>
        MaxAsyncHistogramSgix = ((int)0x832D)        ,
        /// <summary>
        /// Original was GL_PIXEL_TRANSFORM_2D_EXT = 0x8330
        /// </summary>
        PixelTransform2DExt = ((int)0x8330)        ,
        /// <summary>
        /// Original was GL_PIXEL_MAG_FILTER_EXT = 0x8331
        /// </summary>
        PixelMagFilterExt = ((int)0x8331)        ,
        /// <summary>
        /// Original was GL_PIXEL_MIN_FILTER_EXT = 0x8332
        /// </summary>
        PixelMinFilterExt = ((int)0x8332)        ,
        /// <summary>
        /// Original was GL_PIXEL_CUBIC_WEIGHT_EXT = 0x8333
        /// </summary>
        PixelCubicWeightExt = ((int)0x8333)        ,
        /// <summary>
        /// Original was GL_CUBIC_EXT = 0x8334
        /// </summary>
        CubicExt = ((int)0x8334)        ,
        /// <summary>
        /// Original was GL_AVERAGE_EXT = 0x8335
        /// </summary>
        AverageExt = ((int)0x8335)        ,
        /// <summary>
        /// Original was GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT = 0x8336
        /// </summary>
        PixelTransform2DStackDepthExt = ((int)0x8336)        ,
        /// <summary>
        /// Original was GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT = 0x8337
        /// </summary>
        MaxPixelTransform2DStackDepthExt = ((int)0x8337)        ,
        /// <summary>
        /// Original was GL_PIXEL_TRANSFORM_2D_MATRIX_EXT = 0x8338
        /// </summary>
        PixelTransform2DMatrixExt = ((int)0x8338)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_MATERIAL_EXT = 0x8349
        /// </summary>
        FragmentMaterialExt = ((int)0x8349)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_NORMAL_EXT = 0x834A
        /// </summary>
        FragmentNormalExt = ((int)0x834A)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_COLOR_EXT = 0x834C
        /// </summary>
        FragmentColorExt = ((int)0x834C)        ,
        /// <summary>
        /// Original was GL_ATTENUATION_EXT = 0x834D
        /// </summary>
        AttenuationExt = ((int)0x834D)        ,
        /// <summary>
        /// Original was GL_SHADOW_ATTENUATION_EXT = 0x834E
        /// </summary>
        ShadowAttenuationExt = ((int)0x834E)        ,
        /// <summary>
        /// Original was GL_TEXTURE_APPLICATION_MODE_EXT = 0x834F
        /// </summary>
        TextureApplicationModeExt = ((int)0x834F)        ,
        /// <summary>
        /// Original was GL_TEXTURE_LIGHT_EXT = 0x8350
        /// </summary>
        TextureLightExt = ((int)0x8350)        ,
        /// <summary>
        /// Original was GL_TEXTURE_MATERIAL_FACE_EXT = 0x8351
        /// </summary>
        TextureMaterialFaceExt = ((int)0x8351)        ,
        /// <summary>
        /// Original was GL_TEXTURE_MATERIAL_PARAMETER_EXT = 0x8352
        /// </summary>
        TextureMaterialParameterExt = ((int)0x8352)        ,
        /// <summary>
        /// Original was GL_PIXEL_TEXTURE_SGIS = 0x8353
        /// </summary>
        PixelTextureSgis = ((int)0x8353)        ,
        /// <summary>
        /// Original was GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS = 0x8354
        /// </summary>
        PixelFragmentRgbSourceSgis = ((int)0x8354)        ,
        /// <summary>
        /// Original was GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS = 0x8355
        /// </summary>
        PixelFragmentAlphaSourceSgis = ((int)0x8355)        ,
        /// <summary>
        /// Original was GL_PIXEL_GROUP_COLOR_SGIS = 0x8356
        /// </summary>
        PixelGroupColorSgis = ((int)0x8356)        ,
        /// <summary>
        /// Original was GL_LINE_QUALITY_HINT_SGIX = 0x835B
        /// </summary>
        LineQualityHintSgix = ((int)0x835B)        ,
        /// <summary>
        /// Original was GL_ASYNC_TEX_IMAGE_SGIX = 0x835C
        /// </summary>
        AsyncTexImageSgix = ((int)0x835C)        ,
        /// <summary>
        /// Original was GL_ASYNC_DRAW_PIXELS_SGIX = 0x835D
        /// </summary>
        AsyncDrawPixelsSgix = ((int)0x835D)        ,
        /// <summary>
        /// Original was GL_ASYNC_READ_PIXELS_SGIX = 0x835E
        /// </summary>
        AsyncReadPixelsSgix = ((int)0x835E)        ,
        /// <summary>
        /// Original was GL_MAX_ASYNC_TEX_IMAGE_SGIX = 0x835F
        /// </summary>
        MaxAsyncTexImageSgix = ((int)0x835F)        ,
        /// <summary>
        /// Original was GL_MAX_ASYNC_DRAW_PIXELS_SGIX = 0x8360
        /// </summary>
        MaxAsyncDrawPixelsSgix = ((int)0x8360)        ,
        /// <summary>
        /// Original was GL_MAX_ASYNC_READ_PIXELS_SGIX = 0x8361
        /// </summary>
        MaxAsyncReadPixelsSgix = ((int)0x8361)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_BYTE_2_3_3_REV = 0x8362
        /// </summary>
        UnsignedByte233Rev = ((int)0x8362)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_BYTE_2_3_3_REVERSED = 0x8362
        /// </summary>
        UnsignedByte233Reversed = ((int)0x8362)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_SHORT_5_6_5 = 0x8363
        /// </summary>
        UnsignedShort565 = ((int)0x8363)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_SHORT_5_6_5_REV = 0x8364
        /// </summary>
        UnsignedShort565Rev = ((int)0x8364)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_SHORT_5_6_5_REVERSED = 0x8364
        /// </summary>
        UnsignedShort565Reversed = ((int)0x8364)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_SHORT_4_4_4_4_REV = 0x8365
        /// </summary>
        UnsignedShort4444Rev = ((int)0x8365)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_SHORT_4_4_4_4_REVERSED = 0x8365
        /// </summary>
        UnsignedShort4444Reversed = ((int)0x8365)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_SHORT_1_5_5_5_REV = 0x8366
        /// </summary>
        UnsignedShort1555Rev = ((int)0x8366)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_SHORT_1_5_5_5_REVERSED = 0x8366
        /// </summary>
        UnsignedShort1555Reversed = ((int)0x8366)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_8_8_8_8_REV = 0x8367
        /// </summary>
        UnsignedInt8888Rev = ((int)0x8367)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_8_8_8_8_REVERSED = 0x8367
        /// </summary>
        UnsignedInt8888Reversed = ((int)0x8367)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_2_10_10_10_REV = 0x8368
        /// </summary>
        UnsignedInt2101010Rev = ((int)0x8368)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_2_10_10_10_REVERSED = 0x8368
        /// </summary>
        UnsignedInt2101010Reversed = ((int)0x8368)        ,
        /// <summary>
        /// Original was GL_TEXTURE_MAX_CLAMP_S_SGIX = 0x8369
        /// </summary>
        TextureMaxClampSSgix = ((int)0x8369)        ,
        /// <summary>
        /// Original was GL_TEXTURE_MAX_CLAMP_T_SGIX = 0x836A
        /// </summary>
        TextureMaxClampTSgix = ((int)0x836A)        ,
        /// <summary>
        /// Original was GL_TEXTURE_MAX_CLAMP_R_SGIX = 0x836B
        /// </summary>
        TextureMaxClampRSgix = ((int)0x836B)        ,
        /// <summary>
        /// Original was GL_MIRRORED_REPEAT = 0x8370
        /// </summary>
        MirroredRepeat = ((int)0x8370)        ,
        /// <summary>
        /// Original was GL_MIRRORED_REPEAT_ARB = 0x8370
        /// </summary>
        MirroredRepeatArb = ((int)0x8370)        ,
        /// <summary>
        /// Original was GL_MIRRORED_REPEAT_IBM = 0x8370
        /// </summary>
        MirroredRepeatIbm = ((int)0x8370)        ,
        /// <summary>
        /// Original was GL_RGB_S3TC = 0x83A0
        /// </summary>
        RgbS3tc = ((int)0x83A0)        ,
        /// <summary>
        /// Original was GL_RGB4_S3TC = 0x83A1
        /// </summary>
        Rgb4S3tc = ((int)0x83A1)        ,
        /// <summary>
        /// Original was GL_RGBA_S3TC = 0x83A2
        /// </summary>
        RgbaS3tc = ((int)0x83A2)        ,
        /// <summary>
        /// Original was GL_RGBA4_S3TC = 0x83A3
        /// </summary>
        Rgba4S3tc = ((int)0x83A3)        ,
        /// <summary>
        /// Original was GL_RGBA_DXT5_S3TC = 0x83A4
        /// </summary>
        RgbaDxt5S3tc = ((int)0x83A4)        ,
        /// <summary>
        /// Original was GL_RGBA4_DXT5_S3TC = 0x83A5
        /// </summary>
        Rgba4Dxt5S3tc = ((int)0x83A5)        ,
        /// <summary>
        /// Original was GL_VERTEX_PRECLIP_SGIX = 0x83EE
        /// </summary>
        VertexPreclipSgix = ((int)0x83EE)        ,
        /// <summary>
        /// Original was GL_VERTEX_PRECLIP_HINT_SGIX = 0x83EF
        /// </summary>
        VertexPreclipHintSgix = ((int)0x83EF)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGB_S3TC_DXT1_EXT = 0x83F0
        /// </summary>
        CompressedRgbS3tcDxt1Ext = ((int)0x83F0)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_S3TC_DXT1_EXT = 0x83F1
        /// </summary>
        CompressedRgbaS3tcDxt1Ext = ((int)0x83F1)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_S3TC_DXT3_EXT = 0x83F2
        /// </summary>
        CompressedRgbaS3tcDxt3Ext = ((int)0x83F2)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_S3TC_DXT5_EXT = 0x83F3
        /// </summary>
        CompressedRgbaS3tcDxt5Ext = ((int)0x83F3)        ,
        /// <summary>
        /// Original was GL_PARALLEL_ARRAYS_INTEL = 0x83F4
        /// </summary>
        ParallelArraysIntel = ((int)0x83F4)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL = 0x83F5
        /// </summary>
        VertexArrayParallelPointersIntel = ((int)0x83F5)        ,
        /// <summary>
        /// Original was GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL = 0x83F6
        /// </summary>
        NormalArrayParallelPointersIntel = ((int)0x83F6)        ,
        /// <summary>
        /// Original was GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL = 0x83F7
        /// </summary>
        ColorArrayParallelPointersIntel = ((int)0x83F7)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL = 0x83F8
        /// </summary>
        TextureCoordArrayParallelPointersIntel = ((int)0x83F8)        ,
        /// <summary>
        /// Original was GL_PERFQUERY_DONOT_FLUSH_INTEL = 0x83F9
        /// </summary>
        PerfqueryDonotFlushIntel = ((int)0x83F9)        ,
        /// <summary>
        /// Original was GL_PERFQUERY_FLUSH_INTEL = 0x83FA
        /// </summary>
        PerfqueryFlushIntel = ((int)0x83FA)        ,
        /// <summary>
        /// Original was GL_PERFQUERY_WAIT_INTEL = 0x83FB
        /// </summary>
        PerfqueryWaitIntel = ((int)0x83FB)        ,
        /// <summary>
        /// Original was GL_TEXTURE_MEMORY_LAYOUT_INTEL = 0x83FF
        /// </summary>
        TextureMemoryLayoutIntel = ((int)0x83FF)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_LIGHTING_SGIX = 0x8400
        /// </summary>
        FragmentLightingSgix = ((int)0x8400)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_COLOR_MATERIAL_SGIX = 0x8401
        /// </summary>
        FragmentColorMaterialSgix = ((int)0x8401)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX = 0x8402
        /// </summary>
        FragmentColorMaterialFaceSgix = ((int)0x8402)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX = 0x8403
        /// </summary>
        FragmentColorMaterialParameterSgix = ((int)0x8403)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_LIGHTS_SGIX = 0x8404
        /// </summary>
        MaxFragmentLightsSgix = ((int)0x8404)        ,
        /// <summary>
        /// Original was GL_MAX_ACTIVE_LIGHTS_SGIX = 0x8405
        /// </summary>
        MaxActiveLightsSgix = ((int)0x8405)        ,
        /// <summary>
        /// Original was GL_CURRENT_RASTER_NORMAL_SGIX = 0x8406
        /// </summary>
        CurrentRasterNormalSgix = ((int)0x8406)        ,
        /// <summary>
        /// Original was GL_LIGHT_ENV_MODE_SGIX = 0x8407
        /// </summary>
        LightEnvModeSgix = ((int)0x8407)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX = 0x8408
        /// </summary>
        FragmentLightModelLocalViewerSgix = ((int)0x8408)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX = 0x8409
        /// </summary>
        FragmentLightModelTwoSideSgix = ((int)0x8409)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX = 0x840A
        /// </summary>
        FragmentLightModelAmbientSgix = ((int)0x840A)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX = 0x840B
        /// </summary>
        FragmentLightModelNormalInterpolationSgix = ((int)0x840B)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_LIGHT0_SGIX = 0x840C
        /// </summary>
        FragmentLight0Sgix = ((int)0x840C)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_LIGHT1_SGIX = 0x840D
        /// </summary>
        FragmentLight1Sgix = ((int)0x840D)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_LIGHT2_SGIX = 0x840E
        /// </summary>
        FragmentLight2Sgix = ((int)0x840E)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_LIGHT3_SGIX = 0x840F
        /// </summary>
        FragmentLight3Sgix = ((int)0x840F)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_LIGHT4_SGIX = 0x8410
        /// </summary>
        FragmentLight4Sgix = ((int)0x8410)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_LIGHT5_SGIX = 0x8411
        /// </summary>
        FragmentLight5Sgix = ((int)0x8411)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_LIGHT6_SGIX = 0x8412
        /// </summary>
        FragmentLight6Sgix = ((int)0x8412)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_LIGHT7_SGIX = 0x8413
        /// </summary>
        FragmentLight7Sgix = ((int)0x8413)        ,
        /// <summary>
        /// Original was GL_PACK_RESAMPLE_SGIX = 0x842C
        /// </summary>
        PackResampleSgix = ((int)0x842C)        ,
        /// <summary>
        /// Original was GL_UNPACK_RESAMPLE_SGIX = 0x842D
        /// </summary>
        UnpackResampleSgix = ((int)0x842D)        ,
        /// <summary>
        /// Original was GL_RESAMPLE_REPLICATE_SGIX = 0x842E
        /// </summary>
        ResampleReplicateSgix = ((int)0x842E)        ,
        /// <summary>
        /// Original was GL_RESAMPLE_ZERO_FILL_SGIX = 0x842F
        /// </summary>
        ResampleZeroFillSgix = ((int)0x842F)        ,
        /// <summary>
        /// Original was GL_RESAMPLE_DECIMATE_SGIX = 0x8430
        /// </summary>
        ResampleDecimateSgix = ((int)0x8430)        ,
        /// <summary>
        /// Original was GL_TANGENT_ARRAY_EXT = 0x8439
        /// </summary>
        TangentArrayExt = ((int)0x8439)        ,
        /// <summary>
        /// Original was GL_BINORMAL_ARRAY_EXT = 0x843A
        /// </summary>
        BinormalArrayExt = ((int)0x843A)        ,
        /// <summary>
        /// Original was GL_CURRENT_TANGENT_EXT = 0x843B
        /// </summary>
        CurrentTangentExt = ((int)0x843B)        ,
        /// <summary>
        /// Original was GL_CURRENT_BINORMAL_EXT = 0x843C
        /// </summary>
        CurrentBinormalExt = ((int)0x843C)        ,
        /// <summary>
        /// Original was GL_TANGENT_ARRAY_TYPE_EXT = 0x843E
        /// </summary>
        TangentArrayTypeExt = ((int)0x843E)        ,
        /// <summary>
        /// Original was GL_TANGENT_ARRAY_STRIDE_EXT = 0x843F
        /// </summary>
        TangentArrayStrideExt = ((int)0x843F)        ,
        /// <summary>
        /// Original was GL_BINORMAL_ARRAY_TYPE_EXT = 0x8440
        /// </summary>
        BinormalArrayTypeExt = ((int)0x8440)        ,
        /// <summary>
        /// Original was GL_BINORMAL_ARRAY_STRIDE_EXT = 0x8441
        /// </summary>
        BinormalArrayStrideExt = ((int)0x8441)        ,
        /// <summary>
        /// Original was GL_TANGENT_ARRAY_POINTER_EXT = 0x8442
        /// </summary>
        TangentArrayPointerExt = ((int)0x8442)        ,
        /// <summary>
        /// Original was GL_BINORMAL_ARRAY_POINTER_EXT = 0x8443
        /// </summary>
        BinormalArrayPointerExt = ((int)0x8443)        ,
        /// <summary>
        /// Original was GL_MAP1_TANGENT_EXT = 0x8444
        /// </summary>
        Map1TangentExt = ((int)0x8444)        ,
        /// <summary>
        /// Original was GL_MAP2_TANGENT_EXT = 0x8445
        /// </summary>
        Map2TangentExt = ((int)0x8445)        ,
        /// <summary>
        /// Original was GL_MAP1_BINORMAL_EXT = 0x8446
        /// </summary>
        Map1BinormalExt = ((int)0x8446)        ,
        /// <summary>
        /// Original was GL_MAP2_BINORMAL_EXT = 0x8447
        /// </summary>
        Map2BinormalExt = ((int)0x8447)        ,
        /// <summary>
        /// Original was GL_NEAREST_CLIPMAP_NEAREST_SGIX = 0x844D
        /// </summary>
        NearestClipmapNearestSgix = ((int)0x844D)        ,
        /// <summary>
        /// Original was GL_NEAREST_CLIPMAP_LINEAR_SGIX = 0x844E
        /// </summary>
        NearestClipmapLinearSgix = ((int)0x844E)        ,
        /// <summary>
        /// Original was GL_LINEAR_CLIPMAP_NEAREST_SGIX = 0x844F
        /// </summary>
        LinearClipmapNearestSgix = ((int)0x844F)        ,
        /// <summary>
        /// Original was GL_FOG_COORDINATE_SOURCE = 0x8450
        /// </summary>
        FogCoordinateSource = ((int)0x8450)        ,
        /// <summary>
        /// Original was GL_FOG_COORDINATE_SOURCE_EXT = 0x8450
        /// </summary>
        FogCoordinateSourceExt = ((int)0x8450)        ,
        /// <summary>
        /// Original was GL_FOG_COORD_SRC = 0x8450
        /// </summary>
        FogCoordSrc = ((int)0x8450)        ,
        /// <summary>
        /// Original was GL_FOG_COORD = 0x8451
        /// </summary>
        FogCoord = ((int)0x8451)        ,
        /// <summary>
        /// Original was GL_FOG_COORDINATE = 0x8451
        /// </summary>
        FogCoordinate = ((int)0x8451)        ,
        /// <summary>
        /// Original was GL_FOG_COORDINATE_EXT = 0x8451
        /// </summary>
        FogCoordinateExt = ((int)0x8451)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_DEPTH = 0x8452
        /// </summary>
        FragmentDepth = ((int)0x8452)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_DEPTH_EXT = 0x8452
        /// </summary>
        FragmentDepthExt = ((int)0x8452)        ,
        /// <summary>
        /// Original was GL_CURRENT_FOG_COORD = 0x8453
        /// </summary>
        CurrentFogCoord = ((int)0x8453)        ,
        /// <summary>
        /// Original was GL_CURRENT_FOG_COORDINATE = 0x8453
        /// </summary>
        CurrentFogCoordinate = ((int)0x8453)        ,
        /// <summary>
        /// Original was GL_CURRENT_FOG_COORDINATE_EXT = 0x8453
        /// </summary>
        CurrentFogCoordinateExt = ((int)0x8453)        ,
        /// <summary>
        /// Original was GL_FOG_COORD_ARRAY_TYPE = 0x8454
        /// </summary>
        FogCoordArrayType = ((int)0x8454)        ,
        /// <summary>
        /// Original was GL_FOG_COORDINATE_ARRAY_TYPE = 0x8454
        /// </summary>
        FogCoordinateArrayType = ((int)0x8454)        ,
        /// <summary>
        /// Original was GL_FOG_COORDINATE_ARRAY_TYPE_EXT = 0x8454
        /// </summary>
        FogCoordinateArrayTypeExt = ((int)0x8454)        ,
        /// <summary>
        /// Original was GL_FOG_COORD_ARRAY_STRIDE = 0x8455
        /// </summary>
        FogCoordArrayStride = ((int)0x8455)        ,
        /// <summary>
        /// Original was GL_FOG_COORDINATE_ARRAY_STRIDE = 0x8455
        /// </summary>
        FogCoordinateArrayStride = ((int)0x8455)        ,
        /// <summary>
        /// Original was GL_FOG_COORDINATE_ARRAY_STRIDE_EXT = 0x8455
        /// </summary>
        FogCoordinateArrayStrideExt = ((int)0x8455)        ,
        /// <summary>
        /// Original was GL_FOG_COORD_ARRAY_POINTER = 0x8456
        /// </summary>
        FogCoordArrayPointer = ((int)0x8456)        ,
        /// <summary>
        /// Original was GL_FOG_COORDINATE_ARRAY_POINTER = 0x8456
        /// </summary>
        FogCoordinateArrayPointer = ((int)0x8456)        ,
        /// <summary>
        /// Original was GL_FOG_COORDINATE_ARRAY_POINTER_EXT = 0x8456
        /// </summary>
        FogCoordinateArrayPointerExt = ((int)0x8456)        ,
        /// <summary>
        /// Original was GL_FOG_COORD_ARRAY = 0x8457
        /// </summary>
        FogCoordArray = ((int)0x8457)        ,
        /// <summary>
        /// Original was GL_FOG_COORDINATE_ARRAY = 0x8457
        /// </summary>
        FogCoordinateArray = ((int)0x8457)        ,
        /// <summary>
        /// Original was GL_FOG_COORDINATE_ARRAY_EXT = 0x8457
        /// </summary>
        FogCoordinateArrayExt = ((int)0x8457)        ,
        /// <summary>
        /// Original was GL_COLOR_SUM = 0x8458
        /// </summary>
        ColorSum = ((int)0x8458)        ,
        /// <summary>
        /// Original was GL_COLOR_SUM_ARB = 0x8458
        /// </summary>
        ColorSumArb = ((int)0x8458)        ,
        /// <summary>
        /// Original was GL_COLOR_SUM_EXT = 0x8458
        /// </summary>
        ColorSumExt = ((int)0x8458)        ,
        /// <summary>
        /// Original was GL_CURRENT_SECONDARY_COLOR = 0x8459
        /// </summary>
        CurrentSecondaryColor = ((int)0x8459)        ,
        /// <summary>
        /// Original was GL_CURRENT_SECONDARY_COLOR_EXT = 0x8459
        /// </summary>
        CurrentSecondaryColorExt = ((int)0x8459)        ,
        /// <summary>
        /// Original was GL_SECONDARY_COLOR_ARRAY_SIZE = 0x845A
        /// </summary>
        SecondaryColorArraySize = ((int)0x845A)        ,
        /// <summary>
        /// Original was GL_SECONDARY_COLOR_ARRAY_SIZE_EXT = 0x845A
        /// </summary>
        SecondaryColorArraySizeExt = ((int)0x845A)        ,
        /// <summary>
        /// Original was GL_SECONDARY_COLOR_ARRAY_TYPE = 0x845B
        /// </summary>
        SecondaryColorArrayType = ((int)0x845B)        ,
        /// <summary>
        /// Original was GL_SECONDARY_COLOR_ARRAY_TYPE_EXT = 0x845B
        /// </summary>
        SecondaryColorArrayTypeExt = ((int)0x845B)        ,
        /// <summary>
        /// Original was GL_SECONDARY_COLOR_ARRAY_STRIDE = 0x845C
        /// </summary>
        SecondaryColorArrayStride = ((int)0x845C)        ,
        /// <summary>
        /// Original was GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT = 0x845C
        /// </summary>
        SecondaryColorArrayStrideExt = ((int)0x845C)        ,
        /// <summary>
        /// Original was GL_SECONDARY_COLOR_ARRAY_POINTER = 0x845D
        /// </summary>
        SecondaryColorArrayPointer = ((int)0x845D)        ,
        /// <summary>
        /// Original was GL_SECONDARY_COLOR_ARRAY_POINTER_EXT = 0x845D
        /// </summary>
        SecondaryColorArrayPointerExt = ((int)0x845D)        ,
        /// <summary>
        /// Original was GL_SECONDARY_COLOR_ARRAY = 0x845E
        /// </summary>
        SecondaryColorArray = ((int)0x845E)        ,
        /// <summary>
        /// Original was GL_SECONDARY_COLOR_ARRAY_EXT = 0x845E
        /// </summary>
        SecondaryColorArrayExt = ((int)0x845E)        ,
        /// <summary>
        /// Original was GL_CURRENT_RASTER_SECONDARY_COLOR = 0x845F
        /// </summary>
        CurrentRasterSecondaryColor = ((int)0x845F)        ,
        /// <summary>
        /// Original was GL_RGB_ICC_SGIX = 0x8460
        /// </summary>
        RgbIccSgix = ((int)0x8460)        ,
        /// <summary>
        /// Original was GL_RGBA_ICC_SGIX = 0x8461
        /// </summary>
        RgbaIccSgix = ((int)0x8461)        ,
        /// <summary>
        /// Original was GL_ALPHA_ICC_SGIX = 0x8462
        /// </summary>
        AlphaIccSgix = ((int)0x8462)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ICC_SGIX = 0x8463
        /// </summary>
        LuminanceIccSgix = ((int)0x8463)        ,
        /// <summary>
        /// Original was GL_INTENSITY_ICC_SGIX = 0x8464
        /// </summary>
        IntensityIccSgix = ((int)0x8464)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ALPHA_ICC_SGIX = 0x8465
        /// </summary>
        LuminanceAlphaIccSgix = ((int)0x8465)        ,
        /// <summary>
        /// Original was GL_R5_G6_B5_ICC_SGIX = 0x8466
        /// </summary>
        R5G6B5IccSgix = ((int)0x8466)        ,
        /// <summary>
        /// Original was GL_R5_G6_B5_A8_ICC_SGIX = 0x8467
        /// </summary>
        R5G6B5A8IccSgix = ((int)0x8467)        ,
        /// <summary>
        /// Original was GL_ALPHA16_ICC_SGIX = 0x8468
        /// </summary>
        Alpha16IccSgix = ((int)0x8468)        ,
        /// <summary>
        /// Original was GL_LUMINANCE16_ICC_SGIX = 0x8469
        /// </summary>
        Luminance16IccSgix = ((int)0x8469)        ,
        /// <summary>
        /// Original was GL_INTENSITY16_ICC_SGIX = 0x846A
        /// </summary>
        Intensity16IccSgix = ((int)0x846A)        ,
        /// <summary>
        /// Original was GL_LUMINANCE16_ALPHA8_ICC_SGIX = 0x846B
        /// </summary>
        Luminance16Alpha8IccSgix = ((int)0x846B)        ,
        /// <summary>
        /// Original was GL_ALIASED_POINT_SIZE_RANGE = 0x846D
        /// </summary>
        AliasedPointSizeRange = ((int)0x846D)        ,
        /// <summary>
        /// Original was GL_ALIASED_LINE_WIDTH_RANGE = 0x846E
        /// </summary>
        AliasedLineWidthRange = ((int)0x846E)        ,
        /// <summary>
        /// Original was GL_SCREEN_COORDINATES_REND = 0x8490
        /// </summary>
        ScreenCoordinatesRend = ((int)0x8490)        ,
        /// <summary>
        /// Original was GL_INVERTED_SCREEN_W_REND = 0x8491
        /// </summary>
        InvertedScreenWRend = ((int)0x8491)        ,
        /// <summary>
        /// Original was GL_TEXTURE0 = 0x84C0
        /// </summary>
        Texture0 = ((int)0x84C0)        ,
        /// <summary>
        /// Original was GL_TEXTURE0_ARB = 0x84C0
        /// </summary>
        Texture0Arb = ((int)0x84C0)        ,
        /// <summary>
        /// Original was GL_TEXTURE1 = 0x84C1
        /// </summary>
        Texture1 = ((int)0x84C1)        ,
        /// <summary>
        /// Original was GL_TEXTURE1_ARB = 0x84C1
        /// </summary>
        Texture1Arb = ((int)0x84C1)        ,
        /// <summary>
        /// Original was GL_TEXTURE2 = 0x84C2
        /// </summary>
        Texture2 = ((int)0x84C2)        ,
        /// <summary>
        /// Original was GL_TEXTURE2_ARB = 0x84C2
        /// </summary>
        Texture2Arb = ((int)0x84C2)        ,
        /// <summary>
        /// Original was GL_TEXTURE3 = 0x84C3
        /// </summary>
        Texture3 = ((int)0x84C3)        ,
        /// <summary>
        /// Original was GL_TEXTURE3_ARB = 0x84C3
        /// </summary>
        Texture3Arb = ((int)0x84C3)        ,
        /// <summary>
        /// Original was GL_TEXTURE4 = 0x84C4
        /// </summary>
        Texture4 = ((int)0x84C4)        ,
        /// <summary>
        /// Original was GL_TEXTURE4_ARB = 0x84C4
        /// </summary>
        Texture4Arb = ((int)0x84C4)        ,
        /// <summary>
        /// Original was GL_TEXTURE5 = 0x84C5
        /// </summary>
        Texture5 = ((int)0x84C5)        ,
        /// <summary>
        /// Original was GL_TEXTURE5_ARB = 0x84C5
        /// </summary>
        Texture5Arb = ((int)0x84C5)        ,
        /// <summary>
        /// Original was GL_TEXTURE6 = 0x84C6
        /// </summary>
        Texture6 = ((int)0x84C6)        ,
        /// <summary>
        /// Original was GL_TEXTURE6_ARB = 0x84C6
        /// </summary>
        Texture6Arb = ((int)0x84C6)        ,
        /// <summary>
        /// Original was GL_TEXTURE7 = 0x84C7
        /// </summary>
        Texture7 = ((int)0x84C7)        ,
        /// <summary>
        /// Original was GL_TEXTURE7_ARB = 0x84C7
        /// </summary>
        Texture7Arb = ((int)0x84C7)        ,
        /// <summary>
        /// Original was GL_TEXTURE8 = 0x84C8
        /// </summary>
        Texture8 = ((int)0x84C8)        ,
        /// <summary>
        /// Original was GL_TEXTURE8_ARB = 0x84C8
        /// </summary>
        Texture8Arb = ((int)0x84C8)        ,
        /// <summary>
        /// Original was GL_TEXTURE9 = 0x84C9
        /// </summary>
        Texture9 = ((int)0x84C9)        ,
        /// <summary>
        /// Original was GL_TEXTURE9_ARB = 0x84C9
        /// </summary>
        Texture9Arb = ((int)0x84C9)        ,
        /// <summary>
        /// Original was GL_TEXTURE10 = 0x84CA
        /// </summary>
        Texture10 = ((int)0x84CA)        ,
        /// <summary>
        /// Original was GL_TEXTURE10_ARB = 0x84CA
        /// </summary>
        Texture10Arb = ((int)0x84CA)        ,
        /// <summary>
        /// Original was GL_TEXTURE11 = 0x84CB
        /// </summary>
        Texture11 = ((int)0x84CB)        ,
        /// <summary>
        /// Original was GL_TEXTURE11_ARB = 0x84CB
        /// </summary>
        Texture11Arb = ((int)0x84CB)        ,
        /// <summary>
        /// Original was GL_TEXTURE12 = 0x84CC
        /// </summary>
        Texture12 = ((int)0x84CC)        ,
        /// <summary>
        /// Original was GL_TEXTURE12_ARB = 0x84CC
        /// </summary>
        Texture12Arb = ((int)0x84CC)        ,
        /// <summary>
        /// Original was GL_TEXTURE13 = 0x84CD
        /// </summary>
        Texture13 = ((int)0x84CD)        ,
        /// <summary>
        /// Original was GL_TEXTURE13_ARB = 0x84CD
        /// </summary>
        Texture13Arb = ((int)0x84CD)        ,
        /// <summary>
        /// Original was GL_TEXTURE14 = 0x84CE
        /// </summary>
        Texture14 = ((int)0x84CE)        ,
        /// <summary>
        /// Original was GL_TEXTURE14_ARB = 0x84CE
        /// </summary>
        Texture14Arb = ((int)0x84CE)        ,
        /// <summary>
        /// Original was GL_TEXTURE15 = 0x84CF
        /// </summary>
        Texture15 = ((int)0x84CF)        ,
        /// <summary>
        /// Original was GL_TEXTURE15_ARB = 0x84CF
        /// </summary>
        Texture15Arb = ((int)0x84CF)        ,
        /// <summary>
        /// Original was GL_TEXTURE16 = 0x84D0
        /// </summary>
        Texture16 = ((int)0x84D0)        ,
        /// <summary>
        /// Original was GL_TEXTURE16_ARB = 0x84D0
        /// </summary>
        Texture16Arb = ((int)0x84D0)        ,
        /// <summary>
        /// Original was GL_TEXTURE17 = 0x84D1
        /// </summary>
        Texture17 = ((int)0x84D1)        ,
        /// <summary>
        /// Original was GL_TEXTURE17_ARB = 0x84D1
        /// </summary>
        Texture17Arb = ((int)0x84D1)        ,
        /// <summary>
        /// Original was GL_TEXTURE18 = 0x84D2
        /// </summary>
        Texture18 = ((int)0x84D2)        ,
        /// <summary>
        /// Original was GL_TEXTURE18_ARB = 0x84D2
        /// </summary>
        Texture18Arb = ((int)0x84D2)        ,
        /// <summary>
        /// Original was GL_TEXTURE19 = 0x84D3
        /// </summary>
        Texture19 = ((int)0x84D3)        ,
        /// <summary>
        /// Original was GL_TEXTURE19_ARB = 0x84D3
        /// </summary>
        Texture19Arb = ((int)0x84D3)        ,
        /// <summary>
        /// Original was GL_TEXTURE20 = 0x84D4
        /// </summary>
        Texture20 = ((int)0x84D4)        ,
        /// <summary>
        /// Original was GL_TEXTURE20_ARB = 0x84D4
        /// </summary>
        Texture20Arb = ((int)0x84D4)        ,
        /// <summary>
        /// Original was GL_TEXTURE21 = 0x84D5
        /// </summary>
        Texture21 = ((int)0x84D5)        ,
        /// <summary>
        /// Original was GL_TEXTURE21_ARB = 0x84D5
        /// </summary>
        Texture21Arb = ((int)0x84D5)        ,
        /// <summary>
        /// Original was GL_TEXTURE22 = 0x84D6
        /// </summary>
        Texture22 = ((int)0x84D6)        ,
        /// <summary>
        /// Original was GL_TEXTURE22_ARB = 0x84D6
        /// </summary>
        Texture22Arb = ((int)0x84D6)        ,
        /// <summary>
        /// Original was GL_TEXTURE23 = 0x84D7
        /// </summary>
        Texture23 = ((int)0x84D7)        ,
        /// <summary>
        /// Original was GL_TEXTURE23_ARB = 0x84D7
        /// </summary>
        Texture23Arb = ((int)0x84D7)        ,
        /// <summary>
        /// Original was GL_TEXTURE24 = 0x84D8
        /// </summary>
        Texture24 = ((int)0x84D8)        ,
        /// <summary>
        /// Original was GL_TEXTURE24_ARB = 0x84D8
        /// </summary>
        Texture24Arb = ((int)0x84D8)        ,
        /// <summary>
        /// Original was GL_TEXTURE25 = 0x84D9
        /// </summary>
        Texture25 = ((int)0x84D9)        ,
        /// <summary>
        /// Original was GL_TEXTURE25_ARB = 0x84D9
        /// </summary>
        Texture25Arb = ((int)0x84D9)        ,
        /// <summary>
        /// Original was GL_TEXTURE26 = 0x84DA
        /// </summary>
        Texture26 = ((int)0x84DA)        ,
        /// <summary>
        /// Original was GL_TEXTURE26_ARB = 0x84DA
        /// </summary>
        Texture26Arb = ((int)0x84DA)        ,
        /// <summary>
        /// Original was GL_TEXTURE27 = 0x84DB
        /// </summary>
        Texture27 = ((int)0x84DB)        ,
        /// <summary>
        /// Original was GL_TEXTURE27_ARB = 0x84DB
        /// </summary>
        Texture27Arb = ((int)0x84DB)        ,
        /// <summary>
        /// Original was GL_TEXTURE28 = 0x84DC
        /// </summary>
        Texture28 = ((int)0x84DC)        ,
        /// <summary>
        /// Original was GL_TEXTURE28_ARB = 0x84DC
        /// </summary>
        Texture28Arb = ((int)0x84DC)        ,
        /// <summary>
        /// Original was GL_TEXTURE29 = 0x84DD
        /// </summary>
        Texture29 = ((int)0x84DD)        ,
        /// <summary>
        /// Original was GL_TEXTURE29_ARB = 0x84DD
        /// </summary>
        Texture29Arb = ((int)0x84DD)        ,
        /// <summary>
        /// Original was GL_TEXTURE30 = 0x84DE
        /// </summary>
        Texture30 = ((int)0x84DE)        ,
        /// <summary>
        /// Original was GL_TEXTURE30_ARB = 0x84DE
        /// </summary>
        Texture30Arb = ((int)0x84DE)        ,
        /// <summary>
        /// Original was GL_TEXTURE31 = 0x84DF
        /// </summary>
        Texture31 = ((int)0x84DF)        ,
        /// <summary>
        /// Original was GL_TEXTURE31_ARB = 0x84DF
        /// </summary>
        Texture31Arb = ((int)0x84DF)        ,
        /// <summary>
        /// Original was GL_ACTIVE_TEXTURE = 0x84E0
        /// </summary>
        ActiveTexture = ((int)0x84E0)        ,
        /// <summary>
        /// Original was GL_ACTIVE_TEXTURE_ARB = 0x84E0
        /// </summary>
        ActiveTextureArb = ((int)0x84E0)        ,
        /// <summary>
        /// Original was GL_CLIENT_ACTIVE_TEXTURE = 0x84E1
        /// </summary>
        ClientActiveTexture = ((int)0x84E1)        ,
        /// <summary>
        /// Original was GL_CLIENT_ACTIVE_TEXTURE_ARB = 0x84E1
        /// </summary>
        ClientActiveTextureArb = ((int)0x84E1)        ,
        /// <summary>
        /// Original was GL_MAX_TEXTURE_UNITS = 0x84E2
        /// </summary>
        MaxTextureUnits = ((int)0x84E2)        ,
        /// <summary>
        /// Original was GL_MAX_TEXTURE_UNITS_ARB = 0x84E2
        /// </summary>
        MaxTextureUnitsArb = ((int)0x84E2)        ,
        /// <summary>
        /// Original was GL_TRANSPOSE_MODELVIEW_MATRIX = 0x84E3
        /// </summary>
        TransposeModelviewMatrix = ((int)0x84E3)        ,
        /// <summary>
        /// Original was GL_TRANSPOSE_MODELVIEW_MATRIX_ARB = 0x84E3
        /// </summary>
        TransposeModelviewMatrixArb = ((int)0x84E3)        ,
        /// <summary>
        /// Original was GL_TRANSPOSE_PROJECTION_MATRIX = 0x84E4
        /// </summary>
        TransposeProjectionMatrix = ((int)0x84E4)        ,
        /// <summary>
        /// Original was GL_TRANSPOSE_PROJECTION_MATRIX_ARB = 0x84E4
        /// </summary>
        TransposeProjectionMatrixArb = ((int)0x84E4)        ,
        /// <summary>
        /// Original was GL_TRANSPOSE_TEXTURE_MATRIX = 0x84E5
        /// </summary>
        TransposeTextureMatrix = ((int)0x84E5)        ,
        /// <summary>
        /// Original was GL_TRANSPOSE_TEXTURE_MATRIX_ARB = 0x84E5
        /// </summary>
        TransposeTextureMatrixArb = ((int)0x84E5)        ,
        /// <summary>
        /// Original was GL_TRANSPOSE_COLOR_MATRIX = 0x84E6
        /// </summary>
        TransposeColorMatrix = ((int)0x84E6)        ,
        /// <summary>
        /// Original was GL_TRANSPOSE_COLOR_MATRIX_ARB = 0x84E6
        /// </summary>
        TransposeColorMatrixArb = ((int)0x84E6)        ,
        /// <summary>
        /// Original was GL_SUBTRACT = 0x84E7
        /// </summary>
        Subtract = ((int)0x84E7)        ,
        /// <summary>
        /// Original was GL_SUBTRACT_ARB = 0x84E7
        /// </summary>
        SubtractArb = ((int)0x84E7)        ,
        /// <summary>
        /// Original was GL_MAX_RENDERBUFFER_SIZE = 0x84E8
        /// </summary>
        MaxRenderbufferSize = ((int)0x84E8)        ,
        /// <summary>
        /// Original was GL_MAX_RENDERBUFFER_SIZE_EXT = 0x84E8
        /// </summary>
        MaxRenderbufferSizeExt = ((int)0x84E8)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_ALPHA = 0x84E9
        /// </summary>
        CompressedAlpha = ((int)0x84E9)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_ALPHA_ARB = 0x84E9
        /// </summary>
        CompressedAlphaArb = ((int)0x84E9)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_LUMINANCE = 0x84EA
        /// </summary>
        CompressedLuminance = ((int)0x84EA)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_LUMINANCE_ARB = 0x84EA
        /// </summary>
        CompressedLuminanceArb = ((int)0x84EA)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_LUMINANCE_ALPHA = 0x84EB
        /// </summary>
        CompressedLuminanceAlpha = ((int)0x84EB)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_LUMINANCE_ALPHA_ARB = 0x84EB
        /// </summary>
        CompressedLuminanceAlphaArb = ((int)0x84EB)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_INTENSITY = 0x84EC
        /// </summary>
        CompressedIntensity = ((int)0x84EC)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_INTENSITY_ARB = 0x84EC
        /// </summary>
        CompressedIntensityArb = ((int)0x84EC)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGB = 0x84ED
        /// </summary>
        CompressedRgb = ((int)0x84ED)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGB_ARB = 0x84ED
        /// </summary>
        CompressedRgbArb = ((int)0x84ED)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA = 0x84EE
        /// </summary>
        CompressedRgba = ((int)0x84EE)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_ARB = 0x84EE
        /// </summary>
        CompressedRgbaArb = ((int)0x84EE)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPRESSION_HINT = 0x84EF
        /// </summary>
        TextureCompressionHint = ((int)0x84EF)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPRESSION_HINT_ARB = 0x84EF
        /// </summary>
        TextureCompressionHintArb = ((int)0x84EF)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER = 0x84F0
        /// </summary>
        UniformBlockReferencedByTessControlShader = ((int)0x84F0)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x84F1
        /// </summary>
        UniformBlockReferencedByTessEvaluationShader = ((int)0x84F1)        ,
        /// <summary>
        /// Original was GL_ALL_COMPLETED_NV = 0x84F2
        /// </summary>
        AllCompletedNv = ((int)0x84F2)        ,
        /// <summary>
        /// Original was GL_FENCE_STATUS_NV = 0x84F3
        /// </summary>
        FenceStatusNv = ((int)0x84F3)        ,
        /// <summary>
        /// Original was GL_FENCE_CONDITION_NV = 0x84F4
        /// </summary>
        FenceConditionNv = ((int)0x84F4)        ,
        /// <summary>
        /// Original was GL_TEXTURE_RECTANGLE = 0x84F5
        /// </summary>
        TextureRectangle = ((int)0x84F5)        ,
        /// <summary>
        /// Original was GL_TEXTURE_RECTANGLE_ARB = 0x84F5
        /// </summary>
        TextureRectangleArb = ((int)0x84F5)        ,
        /// <summary>
        /// Original was GL_TEXTURE_RECTANGLE_NV = 0x84F5
        /// </summary>
        TextureRectangleNv = ((int)0x84F5)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_RECTANGLE = 0x84F6
        /// </summary>
        TextureBindingRectangle = ((int)0x84F6)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_RECTANGLE_ARB = 0x84F6
        /// </summary>
        TextureBindingRectangleArb = ((int)0x84F6)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_RECTANGLE_NV = 0x84F6
        /// </summary>
        TextureBindingRectangleNv = ((int)0x84F6)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_RECTANGLE = 0x84F7
        /// </summary>
        ProxyTextureRectangle = ((int)0x84F7)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_RECTANGLE_ARB = 0x84F7
        /// </summary>
        ProxyTextureRectangleArb = ((int)0x84F7)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_RECTANGLE_NV = 0x84F7
        /// </summary>
        ProxyTextureRectangleNv = ((int)0x84F7)        ,
        /// <summary>
        /// Original was GL_MAX_RECTANGLE_TEXTURE_SIZE = 0x84F8
        /// </summary>
        MaxRectangleTextureSize = ((int)0x84F8)        ,
        /// <summary>
        /// Original was GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB = 0x84F8
        /// </summary>
        MaxRectangleTextureSizeArb = ((int)0x84F8)        ,
        /// <summary>
        /// Original was GL_MAX_RECTANGLE_TEXTURE_SIZE_NV = 0x84F8
        /// </summary>
        MaxRectangleTextureSizeNv = ((int)0x84F8)        ,
        /// <summary>
        /// Original was GL_DEPTH_STENCIL = 0x84F9
        /// </summary>
        DepthStencil = ((int)0x84F9)        ,
        /// <summary>
        /// Original was GL_DEPTH_STENCIL_EXT = 0x84F9
        /// </summary>
        DepthStencilExt = ((int)0x84F9)        ,
        /// <summary>
        /// Original was GL_DEPTH_STENCIL_NV = 0x84F9
        /// </summary>
        DepthStencilNv = ((int)0x84F9)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_24_8 = 0x84FA
        /// </summary>
        UnsignedInt248 = ((int)0x84FA)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_24_8_EXT = 0x84FA
        /// </summary>
        UnsignedInt248Ext = ((int)0x84FA)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_24_8_NV = 0x84FA
        /// </summary>
        UnsignedInt248Nv = ((int)0x84FA)        ,
        /// <summary>
        /// Original was GL_MAX_TEXTURE_LOD_BIAS = 0x84FD
        /// </summary>
        MaxTextureLodBias = ((int)0x84FD)        ,
        /// <summary>
        /// Original was GL_MAX_TEXTURE_LOD_BIAS_EXT = 0x84FD
        /// </summary>
        MaxTextureLodBiasExt = ((int)0x84FD)        ,
        /// <summary>
        /// Original was GL_TEXTURE_MAX_ANISOTROPY_EXT = 0x84FE
        /// </summary>
        TextureMaxAnisotropyExt = ((int)0x84FE)        ,
        /// <summary>
        /// Original was GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT = 0x84FF
        /// </summary>
        MaxTextureMaxAnisotropyExt = ((int)0x84FF)        ,
        /// <summary>
        /// Original was GL_TEXTURE_FILTER_CONTROL = 0x8500
        /// </summary>
        TextureFilterControl = ((int)0x8500)        ,
        /// <summary>
        /// Original was GL_TEXTURE_FILTER_CONTROL_EXT = 0x8500
        /// </summary>
        TextureFilterControlExt = ((int)0x8500)        ,
        /// <summary>
        /// Original was GL_TEXTURE_LOD_BIAS = 0x8501
        /// </summary>
        TextureLodBias = ((int)0x8501)        ,
        /// <summary>
        /// Original was GL_TEXTURE_LOD_BIAS_EXT = 0x8501
        /// </summary>
        TextureLodBiasExt = ((int)0x8501)        ,
        /// <summary>
        /// Original was GL_MODELVIEW1_STACK_DEPTH_EXT = 0x8502
        /// </summary>
        Modelview1StackDepthExt = ((int)0x8502)        ,
        /// <summary>
        /// Original was GL_COMBINE4_NV = 0x8503
        /// </summary>
        Combine4Nv = ((int)0x8503)        ,
        /// <summary>
        /// Original was GL_MAX_SHININESS_NV = 0x8504
        /// </summary>
        MaxShininessNv = ((int)0x8504)        ,
        /// <summary>
        /// Original was GL_MAX_SPOT_EXPONENT_NV = 0x8505
        /// </summary>
        MaxSpotExponentNv = ((int)0x8505)        ,
        /// <summary>
        /// Original was GL_MODELVIEW1_MATRIX_EXT = 0x8506
        /// </summary>
        Modelview1MatrixExt = ((int)0x8506)        ,
        /// <summary>
        /// Original was GL_INCR_WRAP = 0x8507
        /// </summary>
        IncrWrap = ((int)0x8507)        ,
        /// <summary>
        /// Original was GL_INCR_WRAP_EXT = 0x8507
        /// </summary>
        IncrWrapExt = ((int)0x8507)        ,
        /// <summary>
        /// Original was GL_DECR_WRAP = 0x8508
        /// </summary>
        DecrWrap = ((int)0x8508)        ,
        /// <summary>
        /// Original was GL_DECR_WRAP_EXT = 0x8508
        /// </summary>
        DecrWrapExt = ((int)0x8508)        ,
        /// <summary>
        /// Original was GL_VERTEX_WEIGHTING_EXT = 0x8509
        /// </summary>
        VertexWeightingExt = ((int)0x8509)        ,
        /// <summary>
        /// Original was GL_MODELVIEW1_ARB = 0x850A
        /// </summary>
        Modelview1Arb = ((int)0x850A)        ,
        /// <summary>
        /// Original was GL_MODELVIEW1_EXT = 0x850A
        /// </summary>
        Modelview1Ext = ((int)0x850A)        ,
        /// <summary>
        /// Original was GL_CURRENT_VERTEX_WEIGHT_EXT = 0x850B
        /// </summary>
        CurrentVertexWeightExt = ((int)0x850B)        ,
        /// <summary>
        /// Original was GL_VERTEX_WEIGHT_ARRAY_EXT = 0x850C
        /// </summary>
        VertexWeightArrayExt = ((int)0x850C)        ,
        /// <summary>
        /// Original was GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT = 0x850D
        /// </summary>
        VertexWeightArraySizeExt = ((int)0x850D)        ,
        /// <summary>
        /// Original was GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT = 0x850E
        /// </summary>
        VertexWeightArrayTypeExt = ((int)0x850E)        ,
        /// <summary>
        /// Original was GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT = 0x850F
        /// </summary>
        VertexWeightArrayStrideExt = ((int)0x850F)        ,
        /// <summary>
        /// Original was GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT = 0x8510
        /// </summary>
        VertexWeightArrayPointerExt = ((int)0x8510)        ,
        /// <summary>
        /// Original was GL_NORMAL_MAP = 0x8511
        /// </summary>
        NormalMap = ((int)0x8511)        ,
        /// <summary>
        /// Original was GL_NORMAL_MAP_ARB = 0x8511
        /// </summary>
        NormalMapArb = ((int)0x8511)        ,
        /// <summary>
        /// Original was GL_NORMAL_MAP_EXT = 0x8511
        /// </summary>
        NormalMapExt = ((int)0x8511)        ,
        /// <summary>
        /// Original was GL_NORMAL_MAP_NV = 0x8511
        /// </summary>
        NormalMapNv = ((int)0x8511)        ,
        /// <summary>
        /// Original was GL_REFLECTION_MAP = 0x8512
        /// </summary>
        ReflectionMap = ((int)0x8512)        ,
        /// <summary>
        /// Original was GL_REFLECTION_MAP_ARB = 0x8512
        /// </summary>
        ReflectionMapArb = ((int)0x8512)        ,
        /// <summary>
        /// Original was GL_REFLECTION_MAP_EXT = 0x8512
        /// </summary>
        ReflectionMapExt = ((int)0x8512)        ,
        /// <summary>
        /// Original was GL_REFLECTION_MAP_NV = 0x8512
        /// </summary>
        ReflectionMapNv = ((int)0x8512)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP = 0x8513
        /// </summary>
        TextureCubeMap = ((int)0x8513)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_ARB = 0x8513
        /// </summary>
        TextureCubeMapArb = ((int)0x8513)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_EXT = 0x8513
        /// </summary>
        TextureCubeMapExt = ((int)0x8513)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_CUBE_MAP = 0x8514
        /// </summary>
        TextureBindingCubeMap = ((int)0x8514)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_CUBE_MAP_ARB = 0x8514
        /// </summary>
        TextureBindingCubeMapArb = ((int)0x8514)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_CUBE_MAP_EXT = 0x8514
        /// </summary>
        TextureBindingCubeMapExt = ((int)0x8514)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_POSITIVE_X = 0x8515
        /// </summary>
        TextureCubeMapPositiveX = ((int)0x8515)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB = 0x8515
        /// </summary>
        TextureCubeMapPositiveXArb = ((int)0x8515)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT = 0x8515
        /// </summary>
        TextureCubeMapPositiveXExt = ((int)0x8515)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_NEGATIVE_X = 0x8516
        /// </summary>
        TextureCubeMapNegativeX = ((int)0x8516)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB = 0x8516
        /// </summary>
        TextureCubeMapNegativeXArb = ((int)0x8516)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT = 0x8516
        /// </summary>
        TextureCubeMapNegativeXExt = ((int)0x8516)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_POSITIVE_Y = 0x8517
        /// </summary>
        TextureCubeMapPositiveY = ((int)0x8517)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB = 0x8517
        /// </summary>
        TextureCubeMapPositiveYArb = ((int)0x8517)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT = 0x8517
        /// </summary>
        TextureCubeMapPositiveYExt = ((int)0x8517)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = 0x8518
        /// </summary>
        TextureCubeMapNegativeY = ((int)0x8518)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB = 0x8518
        /// </summary>
        TextureCubeMapNegativeYArb = ((int)0x8518)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT = 0x8518
        /// </summary>
        TextureCubeMapNegativeYExt = ((int)0x8518)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_POSITIVE_Z = 0x8519
        /// </summary>
        TextureCubeMapPositiveZ = ((int)0x8519)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB = 0x8519
        /// </summary>
        TextureCubeMapPositiveZArb = ((int)0x8519)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT = 0x8519
        /// </summary>
        TextureCubeMapPositiveZExt = ((int)0x8519)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = 0x851A
        /// </summary>
        TextureCubeMapNegativeZ = ((int)0x851A)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB = 0x851A
        /// </summary>
        TextureCubeMapNegativeZArb = ((int)0x851A)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT = 0x851A
        /// </summary>
        TextureCubeMapNegativeZExt = ((int)0x851A)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_CUBE_MAP = 0x851B
        /// </summary>
        ProxyTextureCubeMap = ((int)0x851B)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_CUBE_MAP_ARB = 0x851B
        /// </summary>
        ProxyTextureCubeMapArb = ((int)0x851B)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_CUBE_MAP_EXT = 0x851B
        /// </summary>
        ProxyTextureCubeMapExt = ((int)0x851B)        ,
        /// <summary>
        /// Original was GL_MAX_CUBE_MAP_TEXTURE_SIZE = 0x851C
        /// </summary>
        MaxCubeMapTextureSize = ((int)0x851C)        ,
        /// <summary>
        /// Original was GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB = 0x851C
        /// </summary>
        MaxCubeMapTextureSizeArb = ((int)0x851C)        ,
        /// <summary>
        /// Original was GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT = 0x851C
        /// </summary>
        MaxCubeMapTextureSizeExt = ((int)0x851C)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_RANGE_APPLE = 0x851D
        /// </summary>
        VertexArrayRangeApple = ((int)0x851D)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_RANGE_NV = 0x851D
        /// </summary>
        VertexArrayRangeNv = ((int)0x851D)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE = 0x851E
        /// </summary>
        VertexArrayRangeLengthApple = ((int)0x851E)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_RANGE_LENGTH_NV = 0x851E
        /// </summary>
        VertexArrayRangeLengthNv = ((int)0x851E)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_RANGE_VALID_NV = 0x851F
        /// </summary>
        VertexArrayRangeValidNv = ((int)0x851F)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_STORAGE_HINT_APPLE = 0x851F
        /// </summary>
        VertexArrayStorageHintApple = ((int)0x851F)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV = 0x8520
        /// </summary>
        MaxVertexArrayRangeElementNv = ((int)0x8520)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_RANGE_POINTER_APPLE = 0x8521
        /// </summary>
        VertexArrayRangePointerApple = ((int)0x8521)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_RANGE_POINTER_NV = 0x8521
        /// </summary>
        VertexArrayRangePointerNv = ((int)0x8521)        ,
        /// <summary>
        /// Original was GL_REGISTER_COMBINERS_NV = 0x8522
        /// </summary>
        RegisterCombinersNv = ((int)0x8522)        ,
        /// <summary>
        /// Original was GL_VARIABLE_A_NV = 0x8523
        /// </summary>
        VariableANv = ((int)0x8523)        ,
        /// <summary>
        /// Original was GL_VARIABLE_B_NV = 0x8524
        /// </summary>
        VariableBNv = ((int)0x8524)        ,
        /// <summary>
        /// Original was GL_VARIABLE_C_NV = 0x8525
        /// </summary>
        VariableCNv = ((int)0x8525)        ,
        /// <summary>
        /// Original was GL_VARIABLE_D_NV = 0x8526
        /// </summary>
        VariableDNv = ((int)0x8526)        ,
        /// <summary>
        /// Original was GL_VARIABLE_E_NV = 0x8527
        /// </summary>
        VariableENv = ((int)0x8527)        ,
        /// <summary>
        /// Original was GL_VARIABLE_F_NV = 0x8528
        /// </summary>
        VariableFNv = ((int)0x8528)        ,
        /// <summary>
        /// Original was GL_VARIABLE_G_NV = 0x8529
        /// </summary>
        VariableGNv = ((int)0x8529)        ,
        /// <summary>
        /// Original was GL_CONSTANT_COLOR0_NV = 0x852A
        /// </summary>
        ConstantColor0Nv = ((int)0x852A)        ,
        /// <summary>
        /// Original was GL_CONSTANT_COLOR1_NV = 0x852B
        /// </summary>
        ConstantColor1Nv = ((int)0x852B)        ,
        /// <summary>
        /// Original was GL_PRIMARY_COLOR_NV = 0x852C
        /// </summary>
        PrimaryColorNv = ((int)0x852C)        ,
        /// <summary>
        /// Original was GL_SECONDARY_COLOR_NV = 0x852D
        /// </summary>
        SecondaryColorNv = ((int)0x852D)        ,
        /// <summary>
        /// Original was GL_SPARE0_NV = 0x852E
        /// </summary>
        Spare0Nv = ((int)0x852E)        ,
        /// <summary>
        /// Original was GL_SPARE1_NV = 0x852F
        /// </summary>
        Spare1Nv = ((int)0x852F)        ,
        /// <summary>
        /// Original was GL_DISCARD_NV = 0x8530
        /// </summary>
        DiscardNv = ((int)0x8530)        ,
        /// <summary>
        /// Original was GL_E_TIMES_F_NV = 0x8531
        /// </summary>
        ETimesFNv = ((int)0x8531)        ,
        /// <summary>
        /// Original was GL_SPARE0_PLUS_SECONDARY_COLOR_NV = 0x8532
        /// </summary>
        Spare0PlusSecondaryColorNv = ((int)0x8532)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV = 0x8533
        /// </summary>
        VertexArrayRangeWithoutFlushNv = ((int)0x8533)        ,
        /// <summary>
        /// Original was GL_MULTISAMPLE_FILTER_HINT_NV = 0x8534
        /// </summary>
        MultisampleFilterHintNv = ((int)0x8534)        ,
        /// <summary>
        /// Original was GL_PER_STAGE_CONSTANTS_NV = 0x8535
        /// </summary>
        PerStageConstantsNv = ((int)0x8535)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_IDENTITY_NV = 0x8536
        /// </summary>
        UnsignedIdentityNv = ((int)0x8536)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INVERT_NV = 0x8537
        /// </summary>
        UnsignedInvertNv = ((int)0x8537)        ,
        /// <summary>
        /// Original was GL_EXPAND_NORMAL_NV = 0x8538
        /// </summary>
        ExpandNormalNv = ((int)0x8538)        ,
        /// <summary>
        /// Original was GL_EXPAND_NEGATE_NV = 0x8539
        /// </summary>
        ExpandNegateNv = ((int)0x8539)        ,
        /// <summary>
        /// Original was GL_HALF_BIAS_NORMAL_NV = 0x853A
        /// </summary>
        HalfBiasNormalNv = ((int)0x853A)        ,
        /// <summary>
        /// Original was GL_HALF_BIAS_NEGATE_NV = 0x853B
        /// </summary>
        HalfBiasNegateNv = ((int)0x853B)        ,
        /// <summary>
        /// Original was GL_SIGNED_IDENTITY_NV = 0x853C
        /// </summary>
        SignedIdentityNv = ((int)0x853C)        ,
        /// <summary>
        /// Original was GL_SIGNED_NEGATE_NV = 0x853D
        /// </summary>
        SignedNegateNv = ((int)0x853D)        ,
        /// <summary>
        /// Original was GL_SCALE_BY_TWO_NV = 0x853E
        /// </summary>
        ScaleByTwoNv = ((int)0x853E)        ,
        /// <summary>
        /// Original was GL_SCALE_BY_FOUR_NV = 0x853F
        /// </summary>
        ScaleByFourNv = ((int)0x853F)        ,
        /// <summary>
        /// Original was GL_SCALE_BY_ONE_HALF_NV = 0x8540
        /// </summary>
        ScaleByOneHalfNv = ((int)0x8540)        ,
        /// <summary>
        /// Original was GL_BIAS_BY_NEGATIVE_ONE_HALF_NV = 0x8541
        /// </summary>
        BiasByNegativeOneHalfNv = ((int)0x8541)        ,
        /// <summary>
        /// Original was GL_COMBINER_INPUT_NV = 0x8542
        /// </summary>
        CombinerInputNv = ((int)0x8542)        ,
        /// <summary>
        /// Original was GL_COMBINER_MAPPING_NV = 0x8543
        /// </summary>
        CombinerMappingNv = ((int)0x8543)        ,
        /// <summary>
        /// Original was GL_COMBINER_COMPONENT_USAGE_NV = 0x8544
        /// </summary>
        CombinerComponentUsageNv = ((int)0x8544)        ,
        /// <summary>
        /// Original was GL_COMBINER_AB_DOT_PRODUCT_NV = 0x8545
        /// </summary>
        CombinerAbDotProductNv = ((int)0x8545)        ,
        /// <summary>
        /// Original was GL_COMBINER_CD_DOT_PRODUCT_NV = 0x8546
        /// </summary>
        CombinerCdDotProductNv = ((int)0x8546)        ,
        /// <summary>
        /// Original was GL_COMBINER_MUX_SUM_NV = 0x8547
        /// </summary>
        CombinerMuxSumNv = ((int)0x8547)        ,
        /// <summary>
        /// Original was GL_COMBINER_SCALE_NV = 0x8548
        /// </summary>
        CombinerScaleNv = ((int)0x8548)        ,
        /// <summary>
        /// Original was GL_COMBINER_BIAS_NV = 0x8549
        /// </summary>
        CombinerBiasNv = ((int)0x8549)        ,
        /// <summary>
        /// Original was GL_COMBINER_AB_OUTPUT_NV = 0x854A
        /// </summary>
        CombinerAbOutputNv = ((int)0x854A)        ,
        /// <summary>
        /// Original was GL_COMBINER_CD_OUTPUT_NV = 0x854B
        /// </summary>
        CombinerCdOutputNv = ((int)0x854B)        ,
        /// <summary>
        /// Original was GL_COMBINER_SUM_OUTPUT_NV = 0x854C
        /// </summary>
        CombinerSumOutputNv = ((int)0x854C)        ,
        /// <summary>
        /// Original was GL_MAX_GENERAL_COMBINERS_NV = 0x854D
        /// </summary>
        MaxGeneralCombinersNv = ((int)0x854D)        ,
        /// <summary>
        /// Original was GL_NUM_GENERAL_COMBINERS_NV = 0x854E
        /// </summary>
        NumGeneralCombinersNv = ((int)0x854E)        ,
        /// <summary>
        /// Original was GL_COLOR_SUM_CLAMP_NV = 0x854F
        /// </summary>
        ColorSumClampNv = ((int)0x854F)        ,
        /// <summary>
        /// Original was GL_COMBINER0_NV = 0x8550
        /// </summary>
        Combiner0Nv = ((int)0x8550)        ,
        /// <summary>
        /// Original was GL_COMBINER1_NV = 0x8551
        /// </summary>
        Combiner1Nv = ((int)0x8551)        ,
        /// <summary>
        /// Original was GL_COMBINER2_NV = 0x8552
        /// </summary>
        Combiner2Nv = ((int)0x8552)        ,
        /// <summary>
        /// Original was GL_COMBINER3_NV = 0x8553
        /// </summary>
        Combiner3Nv = ((int)0x8553)        ,
        /// <summary>
        /// Original was GL_COMBINER4_NV = 0x8554
        /// </summary>
        Combiner4Nv = ((int)0x8554)        ,
        /// <summary>
        /// Original was GL_COMBINER5_NV = 0x8555
        /// </summary>
        Combiner5Nv = ((int)0x8555)        ,
        /// <summary>
        /// Original was GL_COMBINER6_NV = 0x8556
        /// </summary>
        Combiner6Nv = ((int)0x8556)        ,
        /// <summary>
        /// Original was GL_COMBINER7_NV = 0x8557
        /// </summary>
        Combiner7Nv = ((int)0x8557)        ,
        /// <summary>
        /// Original was GL_PRIMITIVE_RESTART_NV = 0x8558
        /// </summary>
        PrimitiveRestartNv = ((int)0x8558)        ,
        /// <summary>
        /// Original was GL_PRIMITIVE_RESTART_INDEX_NV = 0x8559
        /// </summary>
        PrimitiveRestartIndexNv = ((int)0x8559)        ,
        /// <summary>
        /// Original was GL_FOG_DISTANCE_MODE_NV = 0x855A
        /// </summary>
        FogDistanceModeNv = ((int)0x855A)        ,
        /// <summary>
        /// Original was GL_EYE_RADIAL_NV = 0x855B
        /// </summary>
        EyeRadialNv = ((int)0x855B)        ,
        /// <summary>
        /// Original was GL_EYE_PLANE_ABSOLUTE_NV = 0x855C
        /// </summary>
        EyePlaneAbsoluteNv = ((int)0x855C)        ,
        /// <summary>
        /// Original was GL_EMBOSS_LIGHT_NV = 0x855D
        /// </summary>
        EmbossLightNv = ((int)0x855D)        ,
        /// <summary>
        /// Original was GL_EMBOSS_CONSTANT_NV = 0x855E
        /// </summary>
        EmbossConstantNv = ((int)0x855E)        ,
        /// <summary>
        /// Original was GL_EMBOSS_MAP_NV = 0x855F
        /// </summary>
        EmbossMapNv = ((int)0x855F)        ,
        /// <summary>
        /// Original was GL_RED_MIN_CLAMP_INGR = 0x8560
        /// </summary>
        RedMinClampIngr = ((int)0x8560)        ,
        /// <summary>
        /// Original was GL_GREEN_MIN_CLAMP_INGR = 0x8561
        /// </summary>
        GreenMinClampIngr = ((int)0x8561)        ,
        /// <summary>
        /// Original was GL_BLUE_MIN_CLAMP_INGR = 0x8562
        /// </summary>
        BlueMinClampIngr = ((int)0x8562)        ,
        /// <summary>
        /// Original was GL_ALPHA_MIN_CLAMP_INGR = 0x8563
        /// </summary>
        AlphaMinClampIngr = ((int)0x8563)        ,
        /// <summary>
        /// Original was GL_RED_MAX_CLAMP_INGR = 0x8564
        /// </summary>
        RedMaxClampIngr = ((int)0x8564)        ,
        /// <summary>
        /// Original was GL_GREEN_MAX_CLAMP_INGR = 0x8565
        /// </summary>
        GreenMaxClampIngr = ((int)0x8565)        ,
        /// <summary>
        /// Original was GL_BLUE_MAX_CLAMP_INGR = 0x8566
        /// </summary>
        BlueMaxClampIngr = ((int)0x8566)        ,
        /// <summary>
        /// Original was GL_ALPHA_MAX_CLAMP_INGR = 0x8567
        /// </summary>
        AlphaMaxClampIngr = ((int)0x8567)        ,
        /// <summary>
        /// Original was GL_INTERLACE_READ_INGR = 0x8568
        /// </summary>
        InterlaceReadIngr = ((int)0x8568)        ,
        /// <summary>
        /// Original was GL_COMBINE = 0x8570
        /// </summary>
        Combine = ((int)0x8570)        ,
        /// <summary>
        /// Original was GL_COMBINE_ARB = 0x8570
        /// </summary>
        CombineArb = ((int)0x8570)        ,
        /// <summary>
        /// Original was GL_COMBINE_EXT = 0x8570
        /// </summary>
        CombineExt = ((int)0x8570)        ,
        /// <summary>
        /// Original was GL_COMBINE_RGB = 0x8571
        /// </summary>
        CombineRgb = ((int)0x8571)        ,
        /// <summary>
        /// Original was GL_COMBINE_RGB_ARB = 0x8571
        /// </summary>
        CombineRgbArb = ((int)0x8571)        ,
        /// <summary>
        /// Original was GL_COMBINE_RGB_EXT = 0x8571
        /// </summary>
        CombineRgbExt = ((int)0x8571)        ,
        /// <summary>
        /// Original was GL_COMBINE_ALPHA = 0x8572
        /// </summary>
        CombineAlpha = ((int)0x8572)        ,
        /// <summary>
        /// Original was GL_COMBINE_ALPHA_ARB = 0x8572
        /// </summary>
        CombineAlphaArb = ((int)0x8572)        ,
        /// <summary>
        /// Original was GL_COMBINE_ALPHA_EXT = 0x8572
        /// </summary>
        CombineAlphaExt = ((int)0x8572)        ,
        /// <summary>
        /// Original was GL_RGB_SCALE = 0x8573
        /// </summary>
        RgbScale = ((int)0x8573)        ,
        /// <summary>
        /// Original was GL_RGB_SCALE_ARB = 0x8573
        /// </summary>
        RgbScaleArb = ((int)0x8573)        ,
        /// <summary>
        /// Original was GL_RGB_SCALE_EXT = 0x8573
        /// </summary>
        RgbScaleExt = ((int)0x8573)        ,
        /// <summary>
        /// Original was GL_ADD_SIGNED = 0x8574
        /// </summary>
        AddSigned = ((int)0x8574)        ,
        /// <summary>
        /// Original was GL_ADD_SIGNED_ARB = 0x8574
        /// </summary>
        AddSignedArb = ((int)0x8574)        ,
        /// <summary>
        /// Original was GL_ADD_SIGNED_EXT = 0x8574
        /// </summary>
        AddSignedExt = ((int)0x8574)        ,
        /// <summary>
        /// Original was GL_INTERPOLATE = 0x8575
        /// </summary>
        Interpolate = ((int)0x8575)        ,
        /// <summary>
        /// Original was GL_INTERPOLATE_ARB = 0x8575
        /// </summary>
        InterpolateArb = ((int)0x8575)        ,
        /// <summary>
        /// Original was GL_INTERPOLATE_EXT = 0x8575
        /// </summary>
        InterpolateExt = ((int)0x8575)        ,
        /// <summary>
        /// Original was GL_CONSTANT = 0x8576
        /// </summary>
        Constant = ((int)0x8576)        ,
        /// <summary>
        /// Original was GL_CONSTANT_ARB = 0x8576
        /// </summary>
        ConstantArb = ((int)0x8576)        ,
        /// <summary>
        /// Original was GL_CONSTANT_EXT = 0x8576
        /// </summary>
        ConstantExt = ((int)0x8576)        ,
        /// <summary>
        /// Original was GL_PRIMARY_COLOR = 0x8577
        /// </summary>
        PrimaryColor = ((int)0x8577)        ,
        /// <summary>
        /// Original was GL_PRIMARY_COLOR_ARB = 0x8577
        /// </summary>
        PrimaryColorArb = ((int)0x8577)        ,
        /// <summary>
        /// Original was GL_PRIMARY_COLOR_EXT = 0x8577
        /// </summary>
        PrimaryColorExt = ((int)0x8577)        ,
        /// <summary>
        /// Original was GL_PREVIOUS = 0x8578
        /// </summary>
        Previous = ((int)0x8578)        ,
        /// <summary>
        /// Original was GL_PREVIOUS_ARB = 0x8578
        /// </summary>
        PreviousArb = ((int)0x8578)        ,
        /// <summary>
        /// Original was GL_PREVIOUS_EXT = 0x8578
        /// </summary>
        PreviousExt = ((int)0x8578)        ,
        /// <summary>
        /// Original was GL_SOURCE0_RGB = 0x8580
        /// </summary>
        Source0Rgb = ((int)0x8580)        ,
        /// <summary>
        /// Original was GL_SOURCE0_RGB_ARB = 0x8580
        /// </summary>
        Source0RgbArb = ((int)0x8580)        ,
        /// <summary>
        /// Original was GL_SOURCE0_RGB_EXT = 0x8580
        /// </summary>
        Source0RgbExt = ((int)0x8580)        ,
        /// <summary>
        /// Original was GL_SRC0_RGB = 0x8580
        /// </summary>
        Src0Rgb = ((int)0x8580)        ,
        /// <summary>
        /// Original was GL_SOURCE1_RGB = 0x8581
        /// </summary>
        Source1Rgb = ((int)0x8581)        ,
        /// <summary>
        /// Original was GL_SOURCE1_RGB_ARB = 0x8581
        /// </summary>
        Source1RgbArb = ((int)0x8581)        ,
        /// <summary>
        /// Original was GL_SOURCE1_RGB_EXT = 0x8581
        /// </summary>
        Source1RgbExt = ((int)0x8581)        ,
        /// <summary>
        /// Original was GL_SRC1_RGB = 0x8581
        /// </summary>
        Src1Rgb = ((int)0x8581)        ,
        /// <summary>
        /// Original was GL_SOURCE2_RGB = 0x8582
        /// </summary>
        Source2Rgb = ((int)0x8582)        ,
        /// <summary>
        /// Original was GL_SOURCE2_RGB_ARB = 0x8582
        /// </summary>
        Source2RgbArb = ((int)0x8582)        ,
        /// <summary>
        /// Original was GL_SOURCE2_RGB_EXT = 0x8582
        /// </summary>
        Source2RgbExt = ((int)0x8582)        ,
        /// <summary>
        /// Original was GL_SRC2_RGB = 0x8582
        /// </summary>
        Src2Rgb = ((int)0x8582)        ,
        /// <summary>
        /// Original was GL_SOURCE3_RGB_NV = 0x8583
        /// </summary>
        Source3RgbNv = ((int)0x8583)        ,
        /// <summary>
        /// Original was GL_SOURCE0_ALPHA = 0x8588
        /// </summary>
        Source0Alpha = ((int)0x8588)        ,
        /// <summary>
        /// Original was GL_SOURCE0_ALPHA_ARB = 0x8588
        /// </summary>
        Source0AlphaArb = ((int)0x8588)        ,
        /// <summary>
        /// Original was GL_SOURCE0_ALPHA_EXT = 0x8588
        /// </summary>
        Source0AlphaExt = ((int)0x8588)        ,
        /// <summary>
        /// Original was GL_SRC0_ALPHA = 0x8588
        /// </summary>
        Src0Alpha = ((int)0x8588)        ,
        /// <summary>
        /// Original was GL_SOURCE1_ALPHA = 0x8589
        /// </summary>
        Source1Alpha = ((int)0x8589)        ,
        /// <summary>
        /// Original was GL_SOURCE1_ALPHA_ARB = 0x8589
        /// </summary>
        Source1AlphaArb = ((int)0x8589)        ,
        /// <summary>
        /// Original was GL_SOURCE1_ALPHA_EXT = 0x8589
        /// </summary>
        Source1AlphaExt = ((int)0x8589)        ,
        /// <summary>
        /// Original was GL_SRC1_ALPHA = 0x8589
        /// </summary>
        Src1Alpha = ((int)0x8589)        ,
        /// <summary>
        /// Original was GL_SOURCE2_ALPHA = 0x858A
        /// </summary>
        Source2Alpha = ((int)0x858A)        ,
        /// <summary>
        /// Original was GL_SOURCE2_ALPHA_ARB = 0x858A
        /// </summary>
        Source2AlphaArb = ((int)0x858A)        ,
        /// <summary>
        /// Original was GL_SOURCE2_ALPHA_EXT = 0x858A
        /// </summary>
        Source2AlphaExt = ((int)0x858A)        ,
        /// <summary>
        /// Original was GL_SRC2_ALPHA = 0x858A
        /// </summary>
        Src2Alpha = ((int)0x858A)        ,
        /// <summary>
        /// Original was GL_SOURCE3_ALPHA_NV = 0x858B
        /// </summary>
        Source3AlphaNv = ((int)0x858B)        ,
        /// <summary>
        /// Original was GL_OPERAND0_RGB = 0x8590
        /// </summary>
        Operand0Rgb = ((int)0x8590)        ,
        /// <summary>
        /// Original was GL_OPERAND0_RGB_ARB = 0x8590
        /// </summary>
        Operand0RgbArb = ((int)0x8590)        ,
        /// <summary>
        /// Original was GL_OPERAND0_RGB_EXT = 0x8590
        /// </summary>
        Operand0RgbExt = ((int)0x8590)        ,
        /// <summary>
        /// Original was GL_OPERAND1_RGB = 0x8591
        /// </summary>
        Operand1Rgb = ((int)0x8591)        ,
        /// <summary>
        /// Original was GL_OPERAND1_RGB_ARB = 0x8591
        /// </summary>
        Operand1RgbArb = ((int)0x8591)        ,
        /// <summary>
        /// Original was GL_OPERAND1_RGB_EXT = 0x8591
        /// </summary>
        Operand1RgbExt = ((int)0x8591)        ,
        /// <summary>
        /// Original was GL_OPERAND2_RGB = 0x8592
        /// </summary>
        Operand2Rgb = ((int)0x8592)        ,
        /// <summary>
        /// Original was GL_OPERAND2_RGB_ARB = 0x8592
        /// </summary>
        Operand2RgbArb = ((int)0x8592)        ,
        /// <summary>
        /// Original was GL_OPERAND2_RGB_EXT = 0x8592
        /// </summary>
        Operand2RgbExt = ((int)0x8592)        ,
        /// <summary>
        /// Original was GL_OPERAND3_RGB_NV = 0x8593
        /// </summary>
        Operand3RgbNv = ((int)0x8593)        ,
        /// <summary>
        /// Original was GL_OPERAND0_ALPHA = 0x8598
        /// </summary>
        Operand0Alpha = ((int)0x8598)        ,
        /// <summary>
        /// Original was GL_OPERAND0_ALPHA_ARB = 0x8598
        /// </summary>
        Operand0AlphaArb = ((int)0x8598)        ,
        /// <summary>
        /// Original was GL_OPERAND0_ALPHA_EXT = 0x8598
        /// </summary>
        Operand0AlphaExt = ((int)0x8598)        ,
        /// <summary>
        /// Original was GL_OPERAND1_ALPHA = 0x8599
        /// </summary>
        Operand1Alpha = ((int)0x8599)        ,
        /// <summary>
        /// Original was GL_OPERAND1_ALPHA_ARB = 0x8599
        /// </summary>
        Operand1AlphaArb = ((int)0x8599)        ,
        /// <summary>
        /// Original was GL_OPERAND1_ALPHA_EXT = 0x8599
        /// </summary>
        Operand1AlphaExt = ((int)0x8599)        ,
        /// <summary>
        /// Original was GL_OPERAND2_ALPHA = 0x859A
        /// </summary>
        Operand2Alpha = ((int)0x859A)        ,
        /// <summary>
        /// Original was GL_OPERAND2_ALPHA_ARB = 0x859A
        /// </summary>
        Operand2AlphaArb = ((int)0x859A)        ,
        /// <summary>
        /// Original was GL_OPERAND2_ALPHA_EXT = 0x859A
        /// </summary>
        Operand2AlphaExt = ((int)0x859A)        ,
        /// <summary>
        /// Original was GL_OPERAND3_ALPHA_NV = 0x859B
        /// </summary>
        Operand3AlphaNv = ((int)0x859B)        ,
        /// <summary>
        /// Original was GL_PACK_SUBSAMPLE_RATE_SGIX = 0x85A0
        /// </summary>
        PackSubsampleRateSgix = ((int)0x85A0)        ,
        /// <summary>
        /// Original was GL_UNPACK_SUBSAMPLE_RATE_SGIX = 0x85A1
        /// </summary>
        UnpackSubsampleRateSgix = ((int)0x85A1)        ,
        /// <summary>
        /// Original was GL_PIXEL_SUBSAMPLE_4444_SGIX = 0x85A2
        /// </summary>
        PixelSubsample4444Sgix = ((int)0x85A2)        ,
        /// <summary>
        /// Original was GL_PIXEL_SUBSAMPLE_2424_SGIX = 0x85A3
        /// </summary>
        PixelSubsample2424Sgix = ((int)0x85A3)        ,
        /// <summary>
        /// Original was GL_PIXEL_SUBSAMPLE_4242_SGIX = 0x85A4
        /// </summary>
        PixelSubsample4242Sgix = ((int)0x85A4)        ,
        /// <summary>
        /// Original was GL_PERTURB_EXT = 0x85AE
        /// </summary>
        PerturbExt = ((int)0x85AE)        ,
        /// <summary>
        /// Original was GL_TEXTURE_NORMAL_EXT = 0x85AF
        /// </summary>
        TextureNormalExt = ((int)0x85AF)        ,
        /// <summary>
        /// Original was GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE = 0x85B0
        /// </summary>
        LightModelSpecularVectorApple = ((int)0x85B0)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_HINT_APPLE = 0x85B1
        /// </summary>
        TransformHintApple = ((int)0x85B1)        ,
        /// <summary>
        /// Original was GL_UNPACK_CLIENT_STORAGE_APPLE = 0x85B2
        /// </summary>
        UnpackClientStorageApple = ((int)0x85B2)        ,
        /// <summary>
        /// Original was GL_BUFFER_OBJECT_APPLE = 0x85B3
        /// </summary>
        BufferObjectApple = ((int)0x85B3)        ,
        /// <summary>
        /// Original was GL_STORAGE_CLIENT_APPLE = 0x85B4
        /// </summary>
        StorageClientApple = ((int)0x85B4)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_BINDING = 0x85B5
        /// </summary>
        VertexArrayBinding = ((int)0x85B5)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_BINDING_APPLE = 0x85B5
        /// </summary>
        VertexArrayBindingApple = ((int)0x85B5)        ,
        /// <summary>
        /// Original was GL_TEXTURE_RANGE_LENGTH_APPLE = 0x85B7
        /// </summary>
        TextureRangeLengthApple = ((int)0x85B7)        ,
        /// <summary>
        /// Original was GL_TEXTURE_RANGE_POINTER_APPLE = 0x85B8
        /// </summary>
        TextureRangePointerApple = ((int)0x85B8)        ,
        /// <summary>
        /// Original was GL_YCBCR_422_APPLE = 0x85B9
        /// </summary>
        Ycbcr422Apple = ((int)0x85B9)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_SHORT_8_8_APPLE = 0x85BA
        /// </summary>
        UnsignedShort88Apple = ((int)0x85BA)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_SHORT_8_8_MESA = 0x85BA
        /// </summary>
        UnsignedShort88Mesa = ((int)0x85BA)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_SHORT_8_8_REV_APPLE = 0x85BB
        /// </summary>
        UnsignedShort88RevApple = ((int)0x85BB)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_SHORT_8_8_REV_MESA = 0x85BB
        /// </summary>
        UnsignedShort88RevMesa = ((int)0x85BB)        ,
        /// <summary>
        /// Original was GL_TEXTURE_STORAGE_HINT_APPLE = 0x85BC
        /// </summary>
        TextureStorageHintApple = ((int)0x85BC)        ,
        /// <summary>
        /// Original was GL_STORAGE_PRIVATE_APPLE = 0x85BD
        /// </summary>
        StoragePrivateApple = ((int)0x85BD)        ,
        /// <summary>
        /// Original was GL_STORAGE_CACHED_APPLE = 0x85BE
        /// </summary>
        StorageCachedApple = ((int)0x85BE)        ,
        /// <summary>
        /// Original was GL_STORAGE_SHARED_APPLE = 0x85BF
        /// </summary>
        StorageSharedApple = ((int)0x85BF)        ,
        /// <summary>
        /// Original was GL_REPLACEMENT_CODE_ARRAY_SUN = 0x85C0
        /// </summary>
        ReplacementCodeArraySun = ((int)0x85C0)        ,
        /// <summary>
        /// Original was GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN = 0x85C1
        /// </summary>
        ReplacementCodeArrayTypeSun = ((int)0x85C1)        ,
        /// <summary>
        /// Original was GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN = 0x85C2
        /// </summary>
        ReplacementCodeArrayStrideSun = ((int)0x85C2)        ,
        /// <summary>
        /// Original was GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN = 0x85C3
        /// </summary>
        ReplacementCodeArrayPointerSun = ((int)0x85C3)        ,
        /// <summary>
        /// Original was GL_R1UI_V3F_SUN = 0x85C4
        /// </summary>
        R1uiV3fSun = ((int)0x85C4)        ,
        /// <summary>
        /// Original was GL_R1UI_C4UB_V3F_SUN = 0x85C5
        /// </summary>
        R1uiC4ubV3fSun = ((int)0x85C5)        ,
        /// <summary>
        /// Original was GL_R1UI_C3F_V3F_SUN = 0x85C6
        /// </summary>
        R1uiC3fV3fSun = ((int)0x85C6)        ,
        /// <summary>
        /// Original was GL_R1UI_N3F_V3F_SUN = 0x85C7
        /// </summary>
        R1uiN3fV3fSun = ((int)0x85C7)        ,
        /// <summary>
        /// Original was GL_R1UI_C4F_N3F_V3F_SUN = 0x85C8
        /// </summary>
        R1uiC4fN3fV3fSun = ((int)0x85C8)        ,
        /// <summary>
        /// Original was GL_R1UI_T2F_V3F_SUN = 0x85C9
        /// </summary>
        R1uiT2fV3fSun = ((int)0x85C9)        ,
        /// <summary>
        /// Original was GL_R1UI_T2F_N3F_V3F_SUN = 0x85CA
        /// </summary>
        R1uiT2fN3fV3fSun = ((int)0x85CA)        ,
        /// <summary>
        /// Original was GL_R1UI_T2F_C4F_N3F_V3F_SUN = 0x85CB
        /// </summary>
        R1uiT2fC4fN3fV3fSun = ((int)0x85CB)        ,
        /// <summary>
        /// Original was GL_SLICE_ACCUM_SUN = 0x85CC
        /// </summary>
        SliceAccumSun = ((int)0x85CC)        ,
        /// <summary>
        /// Original was GL_QUAD_MESH_SUN = 0x8614
        /// </summary>
        QuadMeshSun = ((int)0x8614)        ,
        /// <summary>
        /// Original was GL_TRIANGLE_MESH_SUN = 0x8615
        /// </summary>
        TriangleMeshSun = ((int)0x8615)        ,
        /// <summary>
        /// Original was GL_VERTEX_PROGRAM = 0x8620
        /// </summary>
        VertexProgram = ((int)0x8620)        ,
        /// <summary>
        /// Original was GL_VERTEX_PROGRAM_ARB = 0x8620
        /// </summary>
        VertexProgramArb = ((int)0x8620)        ,
        /// <summary>
        /// Original was GL_VERTEX_PROGRAM_NV = 0x8620
        /// </summary>
        VertexProgramNv = ((int)0x8620)        ,
        /// <summary>
        /// Original was GL_VERTEX_STATE_PROGRAM_NV = 0x8621
        /// </summary>
        VertexStateProgramNv = ((int)0x8621)        ,
        /// <summary>
        /// Original was GL_ARRAY_ENABLED = 0x8622
        /// </summary>
        ArrayEnabled = ((int)0x8622)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_ENABLED = 0x8622
        /// </summary>
        VertexAttribArrayEnabled = ((int)0x8622)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB = 0x8622
        /// </summary>
        VertexAttribArrayEnabledArb = ((int)0x8622)        ,
        /// <summary>
        /// Original was GL_ATTRIB_ARRAY_SIZE_NV = 0x8623
        /// </summary>
        AttribArraySizeNv = ((int)0x8623)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_SIZE = 0x8623
        /// </summary>
        VertexAttribArraySize = ((int)0x8623)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB = 0x8623
        /// </summary>
        VertexAttribArraySizeArb = ((int)0x8623)        ,
        /// <summary>
        /// Original was GL_ATTRIB_ARRAY_STRIDE_NV = 0x8624
        /// </summary>
        AttribArrayStrideNv = ((int)0x8624)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_STRIDE = 0x8624
        /// </summary>
        VertexAttribArrayStride = ((int)0x8624)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB = 0x8624
        /// </summary>
        VertexAttribArrayStrideArb = ((int)0x8624)        ,
        /// <summary>
        /// Original was GL_ARRAY_TYPE = 0x8625
        /// </summary>
        ArrayType = ((int)0x8625)        ,
        /// <summary>
        /// Original was GL_ATTRIB_ARRAY_TYPE_NV = 0x8625
        /// </summary>
        AttribArrayTypeNv = ((int)0x8625)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_TYPE = 0x8625
        /// </summary>
        VertexAttribArrayType = ((int)0x8625)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB = 0x8625
        /// </summary>
        VertexAttribArrayTypeArb = ((int)0x8625)        ,
        /// <summary>
        /// Original was GL_CURRENT_ATTRIB_NV = 0x8626
        /// </summary>
        CurrentAttribNv = ((int)0x8626)        ,
        /// <summary>
        /// Original was GL_CURRENT_VERTEX_ATTRIB = 0x8626
        /// </summary>
        CurrentVertexAttrib = ((int)0x8626)        ,
        /// <summary>
        /// Original was GL_CURRENT_VERTEX_ATTRIB_ARB = 0x8626
        /// </summary>
        CurrentVertexAttribArb = ((int)0x8626)        ,
        /// <summary>
        /// Original was GL_PROGRAM_LENGTH = 0x8627
        /// </summary>
        ProgramLength = ((int)0x8627)        ,
        /// <summary>
        /// Original was GL_PROGRAM_LENGTH_ARB = 0x8627
        /// </summary>
        ProgramLengthArb = ((int)0x8627)        ,
        /// <summary>
        /// Original was GL_PROGRAM_LENGTH_NV = 0x8627
        /// </summary>
        ProgramLengthNv = ((int)0x8627)        ,
        /// <summary>
        /// Original was GL_PROGRAM_STRING = 0x8628
        /// </summary>
        ProgramString = ((int)0x8628)        ,
        /// <summary>
        /// Original was GL_PROGRAM_STRING_ARB = 0x8628
        /// </summary>
        ProgramStringArb = ((int)0x8628)        ,
        /// <summary>
        /// Original was GL_PROGRAM_STRING_NV = 0x8628
        /// </summary>
        ProgramStringNv = ((int)0x8628)        ,
        /// <summary>
        /// Original was GL_MODELVIEW_PROJECTION_NV = 0x8629
        /// </summary>
        ModelviewProjectionNv = ((int)0x8629)        ,
        /// <summary>
        /// Original was GL_IDENTITY_NV = 0x862A
        /// </summary>
        IdentityNv = ((int)0x862A)        ,
        /// <summary>
        /// Original was GL_INVERSE_NV = 0x862B
        /// </summary>
        InverseNv = ((int)0x862B)        ,
        /// <summary>
        /// Original was GL_TRANSPOSE_NV = 0x862C
        /// </summary>
        TransposeNv = ((int)0x862C)        ,
        /// <summary>
        /// Original was GL_INVERSE_TRANSPOSE_NV = 0x862D
        /// </summary>
        InverseTransposeNv = ((int)0x862D)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB = 0x862E
        /// </summary>
        MaxProgramMatrixStackDepthArb = ((int)0x862E)        ,
        /// <summary>
        /// Original was GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV = 0x862E
        /// </summary>
        MaxTrackMatrixStackDepthNv = ((int)0x862E)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_MATRICES_ARB = 0x862F
        /// </summary>
        MaxProgramMatricesArb = ((int)0x862F)        ,
        /// <summary>
        /// Original was GL_MAX_TRACK_MATRICES_NV = 0x862F
        /// </summary>
        MaxTrackMatricesNv = ((int)0x862F)        ,
        /// <summary>
        /// Original was GL_MATRIX0_NV = 0x8630
        /// </summary>
        Matrix0Nv = ((int)0x8630)        ,
        /// <summary>
        /// Original was GL_MATRIX1_NV = 0x8631
        /// </summary>
        Matrix1Nv = ((int)0x8631)        ,
        /// <summary>
        /// Original was GL_MATRIX2_NV = 0x8632
        /// </summary>
        Matrix2Nv = ((int)0x8632)        ,
        /// <summary>
        /// Original was GL_MATRIX3_NV = 0x8633
        /// </summary>
        Matrix3Nv = ((int)0x8633)        ,
        /// <summary>
        /// Original was GL_MATRIX4_NV = 0x8634
        /// </summary>
        Matrix4Nv = ((int)0x8634)        ,
        /// <summary>
        /// Original was GL_MATRIX5_NV = 0x8635
        /// </summary>
        Matrix5Nv = ((int)0x8635)        ,
        /// <summary>
        /// Original was GL_MATRIX6_NV = 0x8636
        /// </summary>
        Matrix6Nv = ((int)0x8636)        ,
        /// <summary>
        /// Original was GL_MATRIX7_NV = 0x8637
        /// </summary>
        Matrix7Nv = ((int)0x8637)        ,
        /// <summary>
        /// Original was GL_CURRENT_MATRIX_STACK_DEPTH_ARB = 0x8640
        /// </summary>
        CurrentMatrixStackDepthArb = ((int)0x8640)        ,
        /// <summary>
        /// Original was GL_CURRENT_MATRIX_STACK_DEPTH_NV = 0x8640
        /// </summary>
        CurrentMatrixStackDepthNv = ((int)0x8640)        ,
        /// <summary>
        /// Original was GL_CURRENT_MATRIX_ARB = 0x8641
        /// </summary>
        CurrentMatrixArb = ((int)0x8641)        ,
        /// <summary>
        /// Original was GL_CURRENT_MATRIX_NV = 0x8641
        /// </summary>
        CurrentMatrixNv = ((int)0x8641)        ,
        /// <summary>
        /// Original was GL_PROGRAM_POINT_SIZE = 0x8642
        /// </summary>
        ProgramPointSize = ((int)0x8642)        ,
        /// <summary>
        /// Original was GL_PROGRAM_POINT_SIZE_ARB = 0x8642
        /// </summary>
        ProgramPointSizeArb = ((int)0x8642)        ,
        /// <summary>
        /// Original was GL_PROGRAM_POINT_SIZE_EXT = 0x8642
        /// </summary>
        ProgramPointSizeExt = ((int)0x8642)        ,
        /// <summary>
        /// Original was GL_VERTEX_PROGRAM_POINT_SIZE = 0x8642
        /// </summary>
        VertexProgramPointSize = ((int)0x8642)        ,
        /// <summary>
        /// Original was GL_VERTEX_PROGRAM_POINT_SIZE_ARB = 0x8642
        /// </summary>
        VertexProgramPointSizeArb = ((int)0x8642)        ,
        /// <summary>
        /// Original was GL_VERTEX_PROGRAM_POINT_SIZE_NV = 0x8642
        /// </summary>
        VertexProgramPointSizeNv = ((int)0x8642)        ,
        /// <summary>
        /// Original was GL_VERTEX_PROGRAM_TWO_SIDE = 0x8643
        /// </summary>
        VertexProgramTwoSide = ((int)0x8643)        ,
        /// <summary>
        /// Original was GL_VERTEX_PROGRAM_TWO_SIDE_ARB = 0x8643
        /// </summary>
        VertexProgramTwoSideArb = ((int)0x8643)        ,
        /// <summary>
        /// Original was GL_VERTEX_PROGRAM_TWO_SIDE_NV = 0x8643
        /// </summary>
        VertexProgramTwoSideNv = ((int)0x8643)        ,
        /// <summary>
        /// Original was GL_PROGRAM_PARAMETER_NV = 0x8644
        /// </summary>
        ProgramParameterNv = ((int)0x8644)        ,
        /// <summary>
        /// Original was GL_ARRAY_POINTER = 0x8645
        /// </summary>
        ArrayPointer = ((int)0x8645)        ,
        /// <summary>
        /// Original was GL_ATTRIB_ARRAY_POINTER_NV = 0x8645
        /// </summary>
        AttribArrayPointerNv = ((int)0x8645)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_POINTER = 0x8645
        /// </summary>
        VertexAttribArrayPointer = ((int)0x8645)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB = 0x8645
        /// </summary>
        VertexAttribArrayPointerArb = ((int)0x8645)        ,
        /// <summary>
        /// Original was GL_PROGRAM_TARGET_NV = 0x8646
        /// </summary>
        ProgramTargetNv = ((int)0x8646)        ,
        /// <summary>
        /// Original was GL_PROGRAM_RESIDENT_NV = 0x8647
        /// </summary>
        ProgramResidentNv = ((int)0x8647)        ,
        /// <summary>
        /// Original was GL_TRACK_MATRIX_NV = 0x8648
        /// </summary>
        TrackMatrixNv = ((int)0x8648)        ,
        /// <summary>
        /// Original was GL_TRACK_MATRIX_TRANSFORM_NV = 0x8649
        /// </summary>
        TrackMatrixTransformNv = ((int)0x8649)        ,
        /// <summary>
        /// Original was GL_VERTEX_PROGRAM_BINDING_NV = 0x864A
        /// </summary>
        VertexProgramBindingNv = ((int)0x864A)        ,
        /// <summary>
        /// Original was GL_PROGRAM_ERROR_POSITION_ARB = 0x864B
        /// </summary>
        ProgramErrorPositionArb = ((int)0x864B)        ,
        /// <summary>
        /// Original was GL_PROGRAM_ERROR_POSITION_NV = 0x864B
        /// </summary>
        ProgramErrorPositionNv = ((int)0x864B)        ,
        /// <summary>
        /// Original was GL_OFFSET_TEXTURE_RECTANGLE_NV = 0x864C
        /// </summary>
        OffsetTextureRectangleNv = ((int)0x864C)        ,
        /// <summary>
        /// Original was GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV = 0x864D
        /// </summary>
        OffsetTextureRectangleScaleNv = ((int)0x864D)        ,
        /// <summary>
        /// Original was GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV = 0x864E
        /// </summary>
        DotProductTextureRectangleNv = ((int)0x864E)        ,
        /// <summary>
        /// Original was GL_DEPTH_CLAMP = 0x864F
        /// </summary>
        DepthClamp = ((int)0x864F)        ,
        /// <summary>
        /// Original was GL_DEPTH_CLAMP_NV = 0x864F
        /// </summary>
        DepthClampNv = ((int)0x864F)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY0_NV = 0x8650
        /// </summary>
        VertexAttribArray0Nv = ((int)0x8650)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY1_NV = 0x8651
        /// </summary>
        VertexAttribArray1Nv = ((int)0x8651)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY2_NV = 0x8652
        /// </summary>
        VertexAttribArray2Nv = ((int)0x8652)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY3_NV = 0x8653
        /// </summary>
        VertexAttribArray3Nv = ((int)0x8653)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY4_NV = 0x8654
        /// </summary>
        VertexAttribArray4Nv = ((int)0x8654)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY5_NV = 0x8655
        /// </summary>
        VertexAttribArray5Nv = ((int)0x8655)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY6_NV = 0x8656
        /// </summary>
        VertexAttribArray6Nv = ((int)0x8656)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY7_NV = 0x8657
        /// </summary>
        VertexAttribArray7Nv = ((int)0x8657)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY8_NV = 0x8658
        /// </summary>
        VertexAttribArray8Nv = ((int)0x8658)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY9_NV = 0x8659
        /// </summary>
        VertexAttribArray9Nv = ((int)0x8659)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY10_NV = 0x865A
        /// </summary>
        VertexAttribArray10Nv = ((int)0x865A)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY11_NV = 0x865B
        /// </summary>
        VertexAttribArray11Nv = ((int)0x865B)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY12_NV = 0x865C
        /// </summary>
        VertexAttribArray12Nv = ((int)0x865C)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY13_NV = 0x865D
        /// </summary>
        VertexAttribArray13Nv = ((int)0x865D)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY14_NV = 0x865E
        /// </summary>
        VertexAttribArray14Nv = ((int)0x865E)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY15_NV = 0x865F
        /// </summary>
        VertexAttribArray15Nv = ((int)0x865F)        ,
        /// <summary>
        /// Original was GL_MAP1_VERTEX_ATTRIB0_4_NV = 0x8660
        /// </summary>
        Map1VertexAttrib04Nv = ((int)0x8660)        ,
        /// <summary>
        /// Original was GL_MAP1_VERTEX_ATTRIB1_4_NV = 0x8661
        /// </summary>
        Map1VertexAttrib14Nv = ((int)0x8661)        ,
        /// <summary>
        /// Original was GL_MAP1_VERTEX_ATTRIB2_4_NV = 0x8662
        /// </summary>
        Map1VertexAttrib24Nv = ((int)0x8662)        ,
        /// <summary>
        /// Original was GL_MAP1_VERTEX_ATTRIB3_4_NV = 0x8663
        /// </summary>
        Map1VertexAttrib34Nv = ((int)0x8663)        ,
        /// <summary>
        /// Original was GL_MAP1_VERTEX_ATTRIB4_4_NV = 0x8664
        /// </summary>
        Map1VertexAttrib44Nv = ((int)0x8664)        ,
        /// <summary>
        /// Original was GL_MAP1_VERTEX_ATTRIB5_4_NV = 0x8665
        /// </summary>
        Map1VertexAttrib54Nv = ((int)0x8665)        ,
        /// <summary>
        /// Original was GL_MAP1_VERTEX_ATTRIB6_4_NV = 0x8666
        /// </summary>
        Map1VertexAttrib64Nv = ((int)0x8666)        ,
        /// <summary>
        /// Original was GL_MAP1_VERTEX_ATTRIB7_4_NV = 0x8667
        /// </summary>
        Map1VertexAttrib74Nv = ((int)0x8667)        ,
        /// <summary>
        /// Original was GL_MAP1_VERTEX_ATTRIB8_4_NV = 0x8668
        /// </summary>
        Map1VertexAttrib84Nv = ((int)0x8668)        ,
        /// <summary>
        /// Original was GL_MAP1_VERTEX_ATTRIB9_4_NV = 0x8669
        /// </summary>
        Map1VertexAttrib94Nv = ((int)0x8669)        ,
        /// <summary>
        /// Original was GL_MAP1_VERTEX_ATTRIB10_4_NV = 0x866A
        /// </summary>
        Map1VertexAttrib104Nv = ((int)0x866A)        ,
        /// <summary>
        /// Original was GL_MAP1_VERTEX_ATTRIB11_4_NV = 0x866B
        /// </summary>
        Map1VertexAttrib114Nv = ((int)0x866B)        ,
        /// <summary>
        /// Original was GL_MAP1_VERTEX_ATTRIB12_4_NV = 0x866C
        /// </summary>
        Map1VertexAttrib124Nv = ((int)0x866C)        ,
        /// <summary>
        /// Original was GL_MAP1_VERTEX_ATTRIB13_4_NV = 0x866D
        /// </summary>
        Map1VertexAttrib134Nv = ((int)0x866D)        ,
        /// <summary>
        /// Original was GL_MAP1_VERTEX_ATTRIB14_4_NV = 0x866E
        /// </summary>
        Map1VertexAttrib144Nv = ((int)0x866E)        ,
        /// <summary>
        /// Original was GL_MAP1_VERTEX_ATTRIB15_4_NV = 0x866F
        /// </summary>
        Map1VertexAttrib154Nv = ((int)0x866F)        ,
        /// <summary>
        /// Original was GL_MAP2_VERTEX_ATTRIB0_4_NV = 0x8670
        /// </summary>
        Map2VertexAttrib04Nv = ((int)0x8670)        ,
        /// <summary>
        /// Original was GL_MAP2_VERTEX_ATTRIB1_4_NV = 0x8671
        /// </summary>
        Map2VertexAttrib14Nv = ((int)0x8671)        ,
        /// <summary>
        /// Original was GL_MAP2_VERTEX_ATTRIB2_4_NV = 0x8672
        /// </summary>
        Map2VertexAttrib24Nv = ((int)0x8672)        ,
        /// <summary>
        /// Original was GL_MAP2_VERTEX_ATTRIB3_4_NV = 0x8673
        /// </summary>
        Map2VertexAttrib34Nv = ((int)0x8673)        ,
        /// <summary>
        /// Original was GL_MAP2_VERTEX_ATTRIB4_4_NV = 0x8674
        /// </summary>
        Map2VertexAttrib44Nv = ((int)0x8674)        ,
        /// <summary>
        /// Original was GL_MAP2_VERTEX_ATTRIB5_4_NV = 0x8675
        /// </summary>
        Map2VertexAttrib54Nv = ((int)0x8675)        ,
        /// <summary>
        /// Original was GL_MAP2_VERTEX_ATTRIB6_4_NV = 0x8676
        /// </summary>
        Map2VertexAttrib64Nv = ((int)0x8676)        ,
        /// <summary>
        /// Original was GL_MAP2_VERTEX_ATTRIB7_4_NV = 0x8677
        /// </summary>
        Map2VertexAttrib74Nv = ((int)0x8677)        ,
        /// <summary>
        /// Original was GL_PROGRAM_BINDING = 0x8677
        /// </summary>
        ProgramBinding = ((int)0x8677)        ,
        /// <summary>
        /// Original was GL_PROGRAM_BINDING_ARB = 0x8677
        /// </summary>
        ProgramBindingArb = ((int)0x8677)        ,
        /// <summary>
        /// Original was GL_MAP2_VERTEX_ATTRIB8_4_NV = 0x8678
        /// </summary>
        Map2VertexAttrib84Nv = ((int)0x8678)        ,
        /// <summary>
        /// Original was GL_MAP2_VERTEX_ATTRIB9_4_NV = 0x8679
        /// </summary>
        Map2VertexAttrib94Nv = ((int)0x8679)        ,
        /// <summary>
        /// Original was GL_MAP2_VERTEX_ATTRIB10_4_NV = 0x867A
        /// </summary>
        Map2VertexAttrib104Nv = ((int)0x867A)        ,
        /// <summary>
        /// Original was GL_MAP2_VERTEX_ATTRIB11_4_NV = 0x867B
        /// </summary>
        Map2VertexAttrib114Nv = ((int)0x867B)        ,
        /// <summary>
        /// Original was GL_MAP2_VERTEX_ATTRIB12_4_NV = 0x867C
        /// </summary>
        Map2VertexAttrib124Nv = ((int)0x867C)        ,
        /// <summary>
        /// Original was GL_MAP2_VERTEX_ATTRIB13_4_NV = 0x867D
        /// </summary>
        Map2VertexAttrib134Nv = ((int)0x867D)        ,
        /// <summary>
        /// Original was GL_MAP2_VERTEX_ATTRIB14_4_NV = 0x867E
        /// </summary>
        Map2VertexAttrib144Nv = ((int)0x867E)        ,
        /// <summary>
        /// Original was GL_MAP2_VERTEX_ATTRIB15_4_NV = 0x867F
        /// </summary>
        Map2VertexAttrib154Nv = ((int)0x867F)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPRESSED_IMAGE_SIZE = 0x86A0
        /// </summary>
        TextureCompressedImageSize = ((int)0x86A0)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB = 0x86A0
        /// </summary>
        TextureCompressedImageSizeArb = ((int)0x86A0)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPRESSED = 0x86A1
        /// </summary>
        TextureCompressed = ((int)0x86A1)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPRESSED_ARB = 0x86A1
        /// </summary>
        TextureCompressedArb = ((int)0x86A1)        ,
        /// <summary>
        /// Original was GL_NUM_COMPRESSED_TEXTURE_FORMATS = 0x86A2
        /// </summary>
        NumCompressedTextureFormats = ((int)0x86A2)        ,
        /// <summary>
        /// Original was GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB = 0x86A2
        /// </summary>
        NumCompressedTextureFormatsArb = ((int)0x86A2)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_TEXTURE_FORMATS = 0x86A3
        /// </summary>
        CompressedTextureFormats = ((int)0x86A3)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_TEXTURE_FORMATS_ARB = 0x86A3
        /// </summary>
        CompressedTextureFormatsArb = ((int)0x86A3)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_UNITS_ARB = 0x86A4
        /// </summary>
        MaxVertexUnitsArb = ((int)0x86A4)        ,
        /// <summary>
        /// Original was GL_ACTIVE_VERTEX_UNITS_ARB = 0x86A5
        /// </summary>
        ActiveVertexUnitsArb = ((int)0x86A5)        ,
        /// <summary>
        /// Original was GL_WEIGHT_SUM_UNITY_ARB = 0x86A6
        /// </summary>
        WeightSumUnityArb = ((int)0x86A6)        ,
        /// <summary>
        /// Original was GL_VERTEX_BLEND_ARB = 0x86A7
        /// </summary>
        VertexBlendArb = ((int)0x86A7)        ,
        /// <summary>
        /// Original was GL_CURRENT_WEIGHT_ARB = 0x86A8
        /// </summary>
        CurrentWeightArb = ((int)0x86A8)        ,
        /// <summary>
        /// Original was GL_WEIGHT_ARRAY_TYPE_ARB = 0x86A9
        /// </summary>
        WeightArrayTypeArb = ((int)0x86A9)        ,
        /// <summary>
        /// Original was GL_WEIGHT_ARRAY_STRIDE_ARB = 0x86AA
        /// </summary>
        WeightArrayStrideArb = ((int)0x86AA)        ,
        /// <summary>
        /// Original was GL_WEIGHT_ARRAY_SIZE_ARB = 0x86AB
        /// </summary>
        WeightArraySizeArb = ((int)0x86AB)        ,
        /// <summary>
        /// Original was GL_WEIGHT_ARRAY_POINTER_ARB = 0x86AC
        /// </summary>
        WeightArrayPointerArb = ((int)0x86AC)        ,
        /// <summary>
        /// Original was GL_WEIGHT_ARRAY_ARB = 0x86AD
        /// </summary>
        WeightArrayArb = ((int)0x86AD)        ,
        /// <summary>
        /// Original was GL_DOT3_RGB = 0x86AE
        /// </summary>
        Dot3Rgb = ((int)0x86AE)        ,
        /// <summary>
        /// Original was GL_DOT3_RGB_ARB = 0x86AE
        /// </summary>
        Dot3RgbArb = ((int)0x86AE)        ,
        /// <summary>
        /// Original was GL_DOT3_RGBA = 0x86AF
        /// </summary>
        Dot3Rgba = ((int)0x86AF)        ,
        /// <summary>
        /// Original was GL_DOT3_RGBA_ARB = 0x86AF
        /// </summary>
        Dot3RgbaArb = ((int)0x86AF)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGB_FXT1_3DFX = 0x86B0
        /// </summary>
        CompressedRgbFxt13Dfx = ((int)0x86B0)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_FXT1_3DFX = 0x86B1
        /// </summary>
        CompressedRgbaFxt13Dfx = ((int)0x86B1)        ,
        /// <summary>
        /// Original was GL_MULTISAMPLE_3DFX = 0x86B2
        /// </summary>
        Multisample3Dfx = ((int)0x86B2)        ,
        /// <summary>
        /// Original was GL_SAMPLE_BUFFERS_3DFX = 0x86B3
        /// </summary>
        SampleBuffers3Dfx = ((int)0x86B3)        ,
        /// <summary>
        /// Original was GL_SAMPLES_3DFX = 0x86B4
        /// </summary>
        Samples3Dfx = ((int)0x86B4)        ,
        /// <summary>
        /// Original was GL_EVAL_2D_NV = 0x86C0
        /// </summary>
        Eval2DNv = ((int)0x86C0)        ,
        /// <summary>
        /// Original was GL_EVAL_TRIANGULAR_2D_NV = 0x86C1
        /// </summary>
        EvalTriangular2DNv = ((int)0x86C1)        ,
        /// <summary>
        /// Original was GL_MAP_TESSELLATION_NV = 0x86C2
        /// </summary>
        MapTessellationNv = ((int)0x86C2)        ,
        /// <summary>
        /// Original was GL_MAP_ATTRIB_U_ORDER_NV = 0x86C3
        /// </summary>
        MapAttribUOrderNv = ((int)0x86C3)        ,
        /// <summary>
        /// Original was GL_MAP_ATTRIB_V_ORDER_NV = 0x86C4
        /// </summary>
        MapAttribVOrderNv = ((int)0x86C4)        ,
        /// <summary>
        /// Original was GL_EVAL_FRACTIONAL_TESSELLATION_NV = 0x86C5
        /// </summary>
        EvalFractionalTessellationNv = ((int)0x86C5)        ,
        /// <summary>
        /// Original was GL_EVAL_VERTEX_ATTRIB0_NV = 0x86C6
        /// </summary>
        EvalVertexAttrib0Nv = ((int)0x86C6)        ,
        /// <summary>
        /// Original was GL_EVAL_VERTEX_ATTRIB1_NV = 0x86C7
        /// </summary>
        EvalVertexAttrib1Nv = ((int)0x86C7)        ,
        /// <summary>
        /// Original was GL_EVAL_VERTEX_ATTRIB2_NV = 0x86C8
        /// </summary>
        EvalVertexAttrib2Nv = ((int)0x86C8)        ,
        /// <summary>
        /// Original was GL_EVAL_VERTEX_ATTRIB3_NV = 0x86C9
        /// </summary>
        EvalVertexAttrib3Nv = ((int)0x86C9)        ,
        /// <summary>
        /// Original was GL_EVAL_VERTEX_ATTRIB4_NV = 0x86CA
        /// </summary>
        EvalVertexAttrib4Nv = ((int)0x86CA)        ,
        /// <summary>
        /// Original was GL_EVAL_VERTEX_ATTRIB5_NV = 0x86CB
        /// </summary>
        EvalVertexAttrib5Nv = ((int)0x86CB)        ,
        /// <summary>
        /// Original was GL_EVAL_VERTEX_ATTRIB6_NV = 0x86CC
        /// </summary>
        EvalVertexAttrib6Nv = ((int)0x86CC)        ,
        /// <summary>
        /// Original was GL_EVAL_VERTEX_ATTRIB7_NV = 0x86CD
        /// </summary>
        EvalVertexAttrib7Nv = ((int)0x86CD)        ,
        /// <summary>
        /// Original was GL_EVAL_VERTEX_ATTRIB8_NV = 0x86CE
        /// </summary>
        EvalVertexAttrib8Nv = ((int)0x86CE)        ,
        /// <summary>
        /// Original was GL_EVAL_VERTEX_ATTRIB9_NV = 0x86CF
        /// </summary>
        EvalVertexAttrib9Nv = ((int)0x86CF)        ,
        /// <summary>
        /// Original was GL_EVAL_VERTEX_ATTRIB10_NV = 0x86D0
        /// </summary>
        EvalVertexAttrib10Nv = ((int)0x86D0)        ,
        /// <summary>
        /// Original was GL_EVAL_VERTEX_ATTRIB11_NV = 0x86D1
        /// </summary>
        EvalVertexAttrib11Nv = ((int)0x86D1)        ,
        /// <summary>
        /// Original was GL_EVAL_VERTEX_ATTRIB12_NV = 0x86D2
        /// </summary>
        EvalVertexAttrib12Nv = ((int)0x86D2)        ,
        /// <summary>
        /// Original was GL_EVAL_VERTEX_ATTRIB13_NV = 0x86D3
        /// </summary>
        EvalVertexAttrib13Nv = ((int)0x86D3)        ,
        /// <summary>
        /// Original was GL_EVAL_VERTEX_ATTRIB14_NV = 0x86D4
        /// </summary>
        EvalVertexAttrib14Nv = ((int)0x86D4)        ,
        /// <summary>
        /// Original was GL_EVAL_VERTEX_ATTRIB15_NV = 0x86D5
        /// </summary>
        EvalVertexAttrib15Nv = ((int)0x86D5)        ,
        /// <summary>
        /// Original was GL_MAX_MAP_TESSELLATION_NV = 0x86D6
        /// </summary>
        MaxMapTessellationNv = ((int)0x86D6)        ,
        /// <summary>
        /// Original was GL_MAX_RATIONAL_EVAL_ORDER_NV = 0x86D7
        /// </summary>
        MaxRationalEvalOrderNv = ((int)0x86D7)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_PATCH_ATTRIBS_NV = 0x86D8
        /// </summary>
        MaxProgramPatchAttribsNv = ((int)0x86D8)        ,
        /// <summary>
        /// Original was GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV = 0x86D9
        /// </summary>
        RgbaUnsignedDotProductMappingNv = ((int)0x86D9)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_S8_S8_8_8_NV = 0x86DA
        /// </summary>
        UnsignedIntS8S888Nv = ((int)0x86DA)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_8_8_S8_S8_REV_NV = 0x86DB
        /// </summary>
        UnsignedInt88S8S8RevNv = ((int)0x86DB)        ,
        /// <summary>
        /// Original was GL_DSDT_MAG_INTENSITY_NV = 0x86DC
        /// </summary>
        DsdtMagIntensityNv = ((int)0x86DC)        ,
        /// <summary>
        /// Original was GL_SHADER_CONSISTENT_NV = 0x86DD
        /// </summary>
        ShaderConsistentNv = ((int)0x86DD)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SHADER_NV = 0x86DE
        /// </summary>
        TextureShaderNv = ((int)0x86DE)        ,
        /// <summary>
        /// Original was GL_SHADER_OPERATION_NV = 0x86DF
        /// </summary>
        ShaderOperationNv = ((int)0x86DF)        ,
        /// <summary>
        /// Original was GL_CULL_MODES_NV = 0x86E0
        /// </summary>
        CullModesNv = ((int)0x86E0)        ,
        /// <summary>
        /// Original was GL_OFFSET_TEXTURE_2D_MATRIX_NV = 0x86E1
        /// </summary>
        OffsetTexture2DMatrixNv = ((int)0x86E1)        ,
        /// <summary>
        /// Original was GL_OFFSET_TEXTURE_MATRIX_NV = 0x86E1
        /// </summary>
        OffsetTextureMatrixNv = ((int)0x86E1)        ,
        /// <summary>
        /// Original was GL_OFFSET_TEXTURE_2D_SCALE_NV = 0x86E2
        /// </summary>
        OffsetTexture2DScaleNv = ((int)0x86E2)        ,
        /// <summary>
        /// Original was GL_OFFSET_TEXTURE_SCALE_NV = 0x86E2
        /// </summary>
        OffsetTextureScaleNv = ((int)0x86E2)        ,
        /// <summary>
        /// Original was GL_OFFSET_TEXTURE_2D_BIAS_NV = 0x86E3
        /// </summary>
        OffsetTexture2DBiasNv = ((int)0x86E3)        ,
        /// <summary>
        /// Original was GL_OFFSET_TEXTURE_BIAS_NV = 0x86E3
        /// </summary>
        OffsetTextureBiasNv = ((int)0x86E3)        ,
        /// <summary>
        /// Original was GL_PREVIOUS_TEXTURE_INPUT_NV = 0x86E4
        /// </summary>
        PreviousTextureInputNv = ((int)0x86E4)        ,
        /// <summary>
        /// Original was GL_CONST_EYE_NV = 0x86E5
        /// </summary>
        ConstEyeNv = ((int)0x86E5)        ,
        /// <summary>
        /// Original was GL_PASS_THROUGH_NV = 0x86E6
        /// </summary>
        PassThroughNv = ((int)0x86E6)        ,
        /// <summary>
        /// Original was GL_CULL_FRAGMENT_NV = 0x86E7
        /// </summary>
        CullFragmentNv = ((int)0x86E7)        ,
        /// <summary>
        /// Original was GL_OFFSET_TEXTURE_2D_NV = 0x86E8
        /// </summary>
        OffsetTexture2DNv = ((int)0x86E8)        ,
        /// <summary>
        /// Original was GL_DEPENDENT_AR_TEXTURE_2D_NV = 0x86E9
        /// </summary>
        DependentArTexture2DNv = ((int)0x86E9)        ,
        /// <summary>
        /// Original was GL_DEPENDENT_GB_TEXTURE_2D_NV = 0x86EA
        /// </summary>
        DependentGbTexture2DNv = ((int)0x86EA)        ,
        /// <summary>
        /// Original was GL_SURFACE_STATE_NV = 0x86EB
        /// </summary>
        SurfaceStateNv = ((int)0x86EB)        ,
        /// <summary>
        /// Original was GL_DOT_PRODUCT_NV = 0x86EC
        /// </summary>
        DotProductNv = ((int)0x86EC)        ,
        /// <summary>
        /// Original was GL_DOT_PRODUCT_DEPTH_REPLACE_NV = 0x86ED
        /// </summary>
        DotProductDepthReplaceNv = ((int)0x86ED)        ,
        /// <summary>
        /// Original was GL_DOT_PRODUCT_TEXTURE_2D_NV = 0x86EE
        /// </summary>
        DotProductTexture2DNv = ((int)0x86EE)        ,
        /// <summary>
        /// Original was GL_DOT_PRODUCT_TEXTURE_3D_NV = 0x86EF
        /// </summary>
        DotProductTexture3DNv = ((int)0x86EF)        ,
        /// <summary>
        /// Original was GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV = 0x86F0
        /// </summary>
        DotProductTextureCubeMapNv = ((int)0x86F0)        ,
        /// <summary>
        /// Original was GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV = 0x86F1
        /// </summary>
        DotProductDiffuseCubeMapNv = ((int)0x86F1)        ,
        /// <summary>
        /// Original was GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV = 0x86F2
        /// </summary>
        DotProductReflectCubeMapNv = ((int)0x86F2)        ,
        /// <summary>
        /// Original was GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV = 0x86F3
        /// </summary>
        DotProductConstEyeReflectCubeMapNv = ((int)0x86F3)        ,
        /// <summary>
        /// Original was GL_HILO_NV = 0x86F4
        /// </summary>
        HiloNv = ((int)0x86F4)        ,
        /// <summary>
        /// Original was GL_DSDT_NV = 0x86F5
        /// </summary>
        DsdtNv = ((int)0x86F5)        ,
        /// <summary>
        /// Original was GL_DSDT_MAG_NV = 0x86F6
        /// </summary>
        DsdtMagNv = ((int)0x86F6)        ,
        /// <summary>
        /// Original was GL_DSDT_MAG_VIB_NV = 0x86F7
        /// </summary>
        DsdtMagVibNv = ((int)0x86F7)        ,
        /// <summary>
        /// Original was GL_HILO16_NV = 0x86F8
        /// </summary>
        Hilo16Nv = ((int)0x86F8)        ,
        /// <summary>
        /// Original was GL_SIGNED_HILO_NV = 0x86F9
        /// </summary>
        SignedHiloNv = ((int)0x86F9)        ,
        /// <summary>
        /// Original was GL_SIGNED_HILO16_NV = 0x86FA
        /// </summary>
        SignedHilo16Nv = ((int)0x86FA)        ,
        /// <summary>
        /// Original was GL_SIGNED_RGBA_NV = 0x86FB
        /// </summary>
        SignedRgbaNv = ((int)0x86FB)        ,
        /// <summary>
        /// Original was GL_SIGNED_RGBA8_NV = 0x86FC
        /// </summary>
        SignedRgba8Nv = ((int)0x86FC)        ,
        /// <summary>
        /// Original was GL_SURFACE_REGISTERED_NV = 0x86FD
        /// </summary>
        SurfaceRegisteredNv = ((int)0x86FD)        ,
        /// <summary>
        /// Original was GL_SIGNED_RGB_NV = 0x86FE
        /// </summary>
        SignedRgbNv = ((int)0x86FE)        ,
        /// <summary>
        /// Original was GL_SIGNED_RGB8_NV = 0x86FF
        /// </summary>
        SignedRgb8Nv = ((int)0x86FF)        ,
        /// <summary>
        /// Original was GL_SURFACE_MAPPED_NV = 0x8700
        /// </summary>
        SurfaceMappedNv = ((int)0x8700)        ,
        /// <summary>
        /// Original was GL_SIGNED_LUMINANCE_NV = 0x8701
        /// </summary>
        SignedLuminanceNv = ((int)0x8701)        ,
        /// <summary>
        /// Original was GL_SIGNED_LUMINANCE8_NV = 0x8702
        /// </summary>
        SignedLuminance8Nv = ((int)0x8702)        ,
        /// <summary>
        /// Original was GL_SIGNED_LUMINANCE_ALPHA_NV = 0x8703
        /// </summary>
        SignedLuminanceAlphaNv = ((int)0x8703)        ,
        /// <summary>
        /// Original was GL_SIGNED_LUMINANCE8_ALPHA8_NV = 0x8704
        /// </summary>
        SignedLuminance8Alpha8Nv = ((int)0x8704)        ,
        /// <summary>
        /// Original was GL_SIGNED_ALPHA_NV = 0x8705
        /// </summary>
        SignedAlphaNv = ((int)0x8705)        ,
        /// <summary>
        /// Original was GL_SIGNED_ALPHA8_NV = 0x8706
        /// </summary>
        SignedAlpha8Nv = ((int)0x8706)        ,
        /// <summary>
        /// Original was GL_SIGNED_INTENSITY_NV = 0x8707
        /// </summary>
        SignedIntensityNv = ((int)0x8707)        ,
        /// <summary>
        /// Original was GL_SIGNED_INTENSITY8_NV = 0x8708
        /// </summary>
        SignedIntensity8Nv = ((int)0x8708)        ,
        /// <summary>
        /// Original was GL_DSDT8_NV = 0x8709
        /// </summary>
        Dsdt8Nv = ((int)0x8709)        ,
        /// <summary>
        /// Original was GL_DSDT8_MAG8_NV = 0x870A
        /// </summary>
        Dsdt8Mag8Nv = ((int)0x870A)        ,
        /// <summary>
        /// Original was GL_DSDT8_MAG8_INTENSITY8_NV = 0x870B
        /// </summary>
        Dsdt8Mag8Intensity8Nv = ((int)0x870B)        ,
        /// <summary>
        /// Original was GL_SIGNED_RGB_UNSIGNED_ALPHA_NV = 0x870C
        /// </summary>
        SignedRgbUnsignedAlphaNv = ((int)0x870C)        ,
        /// <summary>
        /// Original was GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV = 0x870D
        /// </summary>
        SignedRgb8UnsignedAlpha8Nv = ((int)0x870D)        ,
        /// <summary>
        /// Original was GL_HI_SCALE_NV = 0x870E
        /// </summary>
        HiScaleNv = ((int)0x870E)        ,
        /// <summary>
        /// Original was GL_LO_SCALE_NV = 0x870F
        /// </summary>
        LoScaleNv = ((int)0x870F)        ,
        /// <summary>
        /// Original was GL_DS_SCALE_NV = 0x8710
        /// </summary>
        DsScaleNv = ((int)0x8710)        ,
        /// <summary>
        /// Original was GL_DT_SCALE_NV = 0x8711
        /// </summary>
        DtScaleNv = ((int)0x8711)        ,
        /// <summary>
        /// Original was GL_MAGNITUDE_SCALE_NV = 0x8712
        /// </summary>
        MagnitudeScaleNv = ((int)0x8712)        ,
        /// <summary>
        /// Original was GL_VIBRANCE_SCALE_NV = 0x8713
        /// </summary>
        VibranceScaleNv = ((int)0x8713)        ,
        /// <summary>
        /// Original was GL_HI_BIAS_NV = 0x8714
        /// </summary>
        HiBiasNv = ((int)0x8714)        ,
        /// <summary>
        /// Original was GL_LO_BIAS_NV = 0x8715
        /// </summary>
        LoBiasNv = ((int)0x8715)        ,
        /// <summary>
        /// Original was GL_DS_BIAS_NV = 0x8716
        /// </summary>
        DsBiasNv = ((int)0x8716)        ,
        /// <summary>
        /// Original was GL_DT_BIAS_NV = 0x8717
        /// </summary>
        DtBiasNv = ((int)0x8717)        ,
        /// <summary>
        /// Original was GL_MAGNITUDE_BIAS_NV = 0x8718
        /// </summary>
        MagnitudeBiasNv = ((int)0x8718)        ,
        /// <summary>
        /// Original was GL_VIBRANCE_BIAS_NV = 0x8719
        /// </summary>
        VibranceBiasNv = ((int)0x8719)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BORDER_VALUES_NV = 0x871A
        /// </summary>
        TextureBorderValuesNv = ((int)0x871A)        ,
        /// <summary>
        /// Original was GL_TEXTURE_HI_SIZE_NV = 0x871B
        /// </summary>
        TextureHiSizeNv = ((int)0x871B)        ,
        /// <summary>
        /// Original was GL_TEXTURE_LO_SIZE_NV = 0x871C
        /// </summary>
        TextureLoSizeNv = ((int)0x871C)        ,
        /// <summary>
        /// Original was GL_TEXTURE_DS_SIZE_NV = 0x871D
        /// </summary>
        TextureDsSizeNv = ((int)0x871D)        ,
        /// <summary>
        /// Original was GL_TEXTURE_DT_SIZE_NV = 0x871E
        /// </summary>
        TextureDtSizeNv = ((int)0x871E)        ,
        /// <summary>
        /// Original was GL_TEXTURE_MAG_SIZE_NV = 0x871F
        /// </summary>
        TextureMagSizeNv = ((int)0x871F)        ,
        /// <summary>
        /// Original was GL_MODELVIEW2_ARB = 0x8722
        /// </summary>
        Modelview2Arb = ((int)0x8722)        ,
        /// <summary>
        /// Original was GL_MODELVIEW3_ARB = 0x8723
        /// </summary>
        Modelview3Arb = ((int)0x8723)        ,
        /// <summary>
        /// Original was GL_MODELVIEW4_ARB = 0x8724
        /// </summary>
        Modelview4Arb = ((int)0x8724)        ,
        /// <summary>
        /// Original was GL_MODELVIEW5_ARB = 0x8725
        /// </summary>
        Modelview5Arb = ((int)0x8725)        ,
        /// <summary>
        /// Original was GL_MODELVIEW6_ARB = 0x8726
        /// </summary>
        Modelview6Arb = ((int)0x8726)        ,
        /// <summary>
        /// Original was GL_MODELVIEW7_ARB = 0x8727
        /// </summary>
        Modelview7Arb = ((int)0x8727)        ,
        /// <summary>
        /// Original was GL_MODELVIEW8_ARB = 0x8728
        /// </summary>
        Modelview8Arb = ((int)0x8728)        ,
        /// <summary>
        /// Original was GL_MODELVIEW9_ARB = 0x8729
        /// </summary>
        Modelview9Arb = ((int)0x8729)        ,
        /// <summary>
        /// Original was GL_MODELVIEW10_ARB = 0x872A
        /// </summary>
        Modelview10Arb = ((int)0x872A)        ,
        /// <summary>
        /// Original was GL_MODELVIEW11_ARB = 0x872B
        /// </summary>
        Modelview11Arb = ((int)0x872B)        ,
        /// <summary>
        /// Original was GL_MODELVIEW12_ARB = 0x872C
        /// </summary>
        Modelview12Arb = ((int)0x872C)        ,
        /// <summary>
        /// Original was GL_MODELVIEW13_ARB = 0x872D
        /// </summary>
        Modelview13Arb = ((int)0x872D)        ,
        /// <summary>
        /// Original was GL_MODELVIEW14_ARB = 0x872E
        /// </summary>
        Modelview14Arb = ((int)0x872E)        ,
        /// <summary>
        /// Original was GL_MODELVIEW15_ARB = 0x872F
        /// </summary>
        Modelview15Arb = ((int)0x872F)        ,
        /// <summary>
        /// Original was GL_MODELVIEW16_ARB = 0x8730
        /// </summary>
        Modelview16Arb = ((int)0x8730)        ,
        /// <summary>
        /// Original was GL_MODELVIEW17_ARB = 0x8731
        /// </summary>
        Modelview17Arb = ((int)0x8731)        ,
        /// <summary>
        /// Original was GL_MODELVIEW18_ARB = 0x8732
        /// </summary>
        Modelview18Arb = ((int)0x8732)        ,
        /// <summary>
        /// Original was GL_MODELVIEW19_ARB = 0x8733
        /// </summary>
        Modelview19Arb = ((int)0x8733)        ,
        /// <summary>
        /// Original was GL_MODELVIEW20_ARB = 0x8734
        /// </summary>
        Modelview20Arb = ((int)0x8734)        ,
        /// <summary>
        /// Original was GL_MODELVIEW21_ARB = 0x8735
        /// </summary>
        Modelview21Arb = ((int)0x8735)        ,
        /// <summary>
        /// Original was GL_MODELVIEW22_ARB = 0x8736
        /// </summary>
        Modelview22Arb = ((int)0x8736)        ,
        /// <summary>
        /// Original was GL_MODELVIEW23_ARB = 0x8737
        /// </summary>
        Modelview23Arb = ((int)0x8737)        ,
        /// <summary>
        /// Original was GL_MODELVIEW24_ARB = 0x8738
        /// </summary>
        Modelview24Arb = ((int)0x8738)        ,
        /// <summary>
        /// Original was GL_MODELVIEW25_ARB = 0x8739
        /// </summary>
        Modelview25Arb = ((int)0x8739)        ,
        /// <summary>
        /// Original was GL_MODELVIEW26_ARB = 0x873A
        /// </summary>
        Modelview26Arb = ((int)0x873A)        ,
        /// <summary>
        /// Original was GL_MODELVIEW27_ARB = 0x873B
        /// </summary>
        Modelview27Arb = ((int)0x873B)        ,
        /// <summary>
        /// Original was GL_MODELVIEW28_ARB = 0x873C
        /// </summary>
        Modelview28Arb = ((int)0x873C)        ,
        /// <summary>
        /// Original was GL_MODELVIEW29_ARB = 0x873D
        /// </summary>
        Modelview29Arb = ((int)0x873D)        ,
        /// <summary>
        /// Original was GL_MODELVIEW30_ARB = 0x873E
        /// </summary>
        Modelview30Arb = ((int)0x873E)        ,
        /// <summary>
        /// Original was GL_MODELVIEW31_ARB = 0x873F
        /// </summary>
        Modelview31Arb = ((int)0x873F)        ,
        /// <summary>
        /// Original was GL_DOT3_RGB_EXT = 0x8740
        /// </summary>
        Dot3RgbExt = ((int)0x8740)        ,
        /// <summary>
        /// Original was GL_DOT3_RGBA_EXT = 0x8741
        /// </summary>
        Dot3RgbaExt = ((int)0x8741)        ,
        /// <summary>
        /// Original was GL_PROGRAM_BINARY_LENGTH = 0x8741
        /// </summary>
        ProgramBinaryLength = ((int)0x8741)        ,
        /// <summary>
        /// Original was GL_MIRROR_CLAMP_ATI = 0x8742
        /// </summary>
        MirrorClampAti = ((int)0x8742)        ,
        /// <summary>
        /// Original was GL_MIRROR_CLAMP_EXT = 0x8742
        /// </summary>
        MirrorClampExt = ((int)0x8742)        ,
        /// <summary>
        /// Original was GL_MIRROR_CLAMP_TO_EDGE = 0x8743
        /// </summary>
        MirrorClampToEdge = ((int)0x8743)        ,
        /// <summary>
        /// Original was GL_MIRROR_CLAMP_TO_EDGE_ATI = 0x8743
        /// </summary>
        MirrorClampToEdgeAti = ((int)0x8743)        ,
        /// <summary>
        /// Original was GL_MIRROR_CLAMP_TO_EDGE_EXT = 0x8743
        /// </summary>
        MirrorClampToEdgeExt = ((int)0x8743)        ,
        /// <summary>
        /// Original was GL_MODULATE_ADD_ATI = 0x8744
        /// </summary>
        ModulateAddAti = ((int)0x8744)        ,
        /// <summary>
        /// Original was GL_MODULATE_SIGNED_ADD_ATI = 0x8745
        /// </summary>
        ModulateSignedAddAti = ((int)0x8745)        ,
        /// <summary>
        /// Original was GL_MODULATE_SUBTRACT_ATI = 0x8746
        /// </summary>
        ModulateSubtractAti = ((int)0x8746)        ,
        /// <summary>
        /// Original was GL_SET_AMD = 0x874A
        /// </summary>
        SetAmd = ((int)0x874A)        ,
        /// <summary>
        /// Original was GL_REPLACE_VALUE_AMD = 0x874B
        /// </summary>
        ReplaceValueAmd = ((int)0x874B)        ,
        /// <summary>
        /// Original was GL_STENCIL_OP_VALUE_AMD = 0x874C
        /// </summary>
        StencilOpValueAmd = ((int)0x874C)        ,
        /// <summary>
        /// Original was GL_STENCIL_BACK_OP_VALUE_AMD = 0x874D
        /// </summary>
        StencilBackOpValueAmd = ((int)0x874D)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_LONG = 0x874E
        /// </summary>
        VertexAttribArrayLong = ((int)0x874E)        ,
        /// <summary>
        /// Original was GL_OCCLUSION_QUERY_EVENT_MASK_AMD = 0x874F
        /// </summary>
        OcclusionQueryEventMaskAmd = ((int)0x874F)        ,
        /// <summary>
        /// Original was GL_YCBCR_MESA = 0x8757
        /// </summary>
        YcbcrMesa = ((int)0x8757)        ,
        /// <summary>
        /// Original was GL_PACK_INVERT_MESA = 0x8758
        /// </summary>
        PackInvertMesa = ((int)0x8758)        ,
        /// <summary>
        /// Original was GL_TEXTURE_1D_STACK_MESAX = 0x8759
        /// </summary>
        Texture1DStackMesax = ((int)0x8759)        ,
        /// <summary>
        /// Original was GL_TEXTURE_2D_STACK_MESAX = 0x875A
        /// </summary>
        Texture2DStackMesax = ((int)0x875A)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_1D_STACK_MESAX = 0x875B
        /// </summary>
        ProxyTexture1DStackMesax = ((int)0x875B)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_2D_STACK_MESAX = 0x875C
        /// </summary>
        ProxyTexture2DStackMesax = ((int)0x875C)        ,
        /// <summary>
        /// Original was GL_TEXTURE_1D_STACK_BINDING_MESAX = 0x875D
        /// </summary>
        Texture1DStackBindingMesax = ((int)0x875D)        ,
        /// <summary>
        /// Original was GL_TEXTURE_2D_STACK_BINDING_MESAX = 0x875E
        /// </summary>
        Texture2DStackBindingMesax = ((int)0x875E)        ,
        /// <summary>
        /// Original was GL_STATIC_ATI = 0x8760
        /// </summary>
        StaticAti = ((int)0x8760)        ,
        /// <summary>
        /// Original was GL_DYNAMIC_ATI = 0x8761
        /// </summary>
        DynamicAti = ((int)0x8761)        ,
        /// <summary>
        /// Original was GL_PRESERVE_ATI = 0x8762
        /// </summary>
        PreserveAti = ((int)0x8762)        ,
        /// <summary>
        /// Original was GL_DISCARD_ATI = 0x8763
        /// </summary>
        DiscardAti = ((int)0x8763)        ,
        /// <summary>
        /// Original was GL_BUFFER_SIZE = 0x8764
        /// </summary>
        BufferSize = ((int)0x8764)        ,
        /// <summary>
        /// Original was GL_BUFFER_SIZE_ARB = 0x8764
        /// </summary>
        BufferSizeArb = ((int)0x8764)        ,
        /// <summary>
        /// Original was GL_OBJECT_BUFFER_SIZE_ATI = 0x8764
        /// </summary>
        ObjectBufferSizeAti = ((int)0x8764)        ,
        /// <summary>
        /// Original was GL_BUFFER_USAGE = 0x8765
        /// </summary>
        BufferUsage = ((int)0x8765)        ,
        /// <summary>
        /// Original was GL_BUFFER_USAGE_ARB = 0x8765
        /// </summary>
        BufferUsageArb = ((int)0x8765)        ,
        /// <summary>
        /// Original was GL_OBJECT_BUFFER_USAGE_ATI = 0x8765
        /// </summary>
        ObjectBufferUsageAti = ((int)0x8765)        ,
        /// <summary>
        /// Original was GL_ARRAY_OBJECT_BUFFER_ATI = 0x8766
        /// </summary>
        ArrayObjectBufferAti = ((int)0x8766)        ,
        /// <summary>
        /// Original was GL_ARRAY_OBJECT_OFFSET_ATI = 0x8767
        /// </summary>
        ArrayObjectOffsetAti = ((int)0x8767)        ,
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_ATI = 0x8768
        /// </summary>
        ElementArrayAti = ((int)0x8768)        ,
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_TYPE_ATI = 0x8769
        /// </summary>
        ElementArrayTypeAti = ((int)0x8769)        ,
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_POINTER_ATI = 0x876A
        /// </summary>
        ElementArrayPointerAti = ((int)0x876A)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_STREAMS_ATI = 0x876B
        /// </summary>
        MaxVertexStreamsAti = ((int)0x876B)        ,
        /// <summary>
        /// Original was GL_VERTEX_STREAM0_ATI = 0x876C
        /// </summary>
        VertexStream0Ati = ((int)0x876C)        ,
        /// <summary>
        /// Original was GL_VERTEX_STREAM1_ATI = 0x876D
        /// </summary>
        VertexStream1Ati = ((int)0x876D)        ,
        /// <summary>
        /// Original was GL_VERTEX_STREAM2_ATI = 0x876E
        /// </summary>
        VertexStream2Ati = ((int)0x876E)        ,
        /// <summary>
        /// Original was GL_VERTEX_STREAM3_ATI = 0x876F
        /// </summary>
        VertexStream3Ati = ((int)0x876F)        ,
        /// <summary>
        /// Original was GL_VERTEX_STREAM4_ATI = 0x8770
        /// </summary>
        VertexStream4Ati = ((int)0x8770)        ,
        /// <summary>
        /// Original was GL_VERTEX_STREAM5_ATI = 0x8771
        /// </summary>
        VertexStream5Ati = ((int)0x8771)        ,
        /// <summary>
        /// Original was GL_VERTEX_STREAM6_ATI = 0x8772
        /// </summary>
        VertexStream6Ati = ((int)0x8772)        ,
        /// <summary>
        /// Original was GL_VERTEX_STREAM7_ATI = 0x8773
        /// </summary>
        VertexStream7Ati = ((int)0x8773)        ,
        /// <summary>
        /// Original was GL_VERTEX_SOURCE_ATI = 0x8774
        /// </summary>
        VertexSourceAti = ((int)0x8774)        ,
        /// <summary>
        /// Original was GL_BUMP_ROT_MATRIX_ATI = 0x8775
        /// </summary>
        BumpRotMatrixAti = ((int)0x8775)        ,
        /// <summary>
        /// Original was GL_BUMP_ROT_MATRIX_SIZE_ATI = 0x8776
        /// </summary>
        BumpRotMatrixSizeAti = ((int)0x8776)        ,
        /// <summary>
        /// Original was GL_BUMP_NUM_TEX_UNITS_ATI = 0x8777
        /// </summary>
        BumpNumTexUnitsAti = ((int)0x8777)        ,
        /// <summary>
        /// Original was GL_BUMP_TEX_UNITS_ATI = 0x8778
        /// </summary>
        BumpTexUnitsAti = ((int)0x8778)        ,
        /// <summary>
        /// Original was GL_DUDV_ATI = 0x8779
        /// </summary>
        DudvAti = ((int)0x8779)        ,
        /// <summary>
        /// Original was GL_DU8DV8_ATI = 0x877A
        /// </summary>
        Du8Dv8Ati = ((int)0x877A)        ,
        /// <summary>
        /// Original was GL_BUMP_ENVMAP_ATI = 0x877B
        /// </summary>
        BumpEnvmapAti = ((int)0x877B)        ,
        /// <summary>
        /// Original was GL_BUMP_TARGET_ATI = 0x877C
        /// </summary>
        BumpTargetAti = ((int)0x877C)        ,
        /// <summary>
        /// Original was GL_VERTEX_SHADER_EXT = 0x8780
        /// </summary>
        VertexShaderExt = ((int)0x8780)        ,
        /// <summary>
        /// Original was GL_VERTEX_SHADER_BINDING_EXT = 0x8781
        /// </summary>
        VertexShaderBindingExt = ((int)0x8781)        ,
        /// <summary>
        /// Original was GL_OP_INDEX_EXT = 0x8782
        /// </summary>
        OpIndexExt = ((int)0x8782)        ,
        /// <summary>
        /// Original was GL_OP_NEGATE_EXT = 0x8783
        /// </summary>
        OpNegateExt = ((int)0x8783)        ,
        /// <summary>
        /// Original was GL_OP_DOT3_EXT = 0x8784
        /// </summary>
        OpDot3Ext = ((int)0x8784)        ,
        /// <summary>
        /// Original was GL_OP_DOT4_EXT = 0x8785
        /// </summary>
        OpDot4Ext = ((int)0x8785)        ,
        /// <summary>
        /// Original was GL_OP_MUL_EXT = 0x8786
        /// </summary>
        OpMulExt = ((int)0x8786)        ,
        /// <summary>
        /// Original was GL_OP_ADD_EXT = 0x8787
        /// </summary>
        OpAddExt = ((int)0x8787)        ,
        /// <summary>
        /// Original was GL_OP_MADD_EXT = 0x8788
        /// </summary>
        OpMaddExt = ((int)0x8788)        ,
        /// <summary>
        /// Original was GL_OP_FRAC_EXT = 0x8789
        /// </summary>
        OpFracExt = ((int)0x8789)        ,
        /// <summary>
        /// Original was GL_OP_MAX_EXT = 0x878A
        /// </summary>
        OpMaxExt = ((int)0x878A)        ,
        /// <summary>
        /// Original was GL_OP_MIN_EXT = 0x878B
        /// </summary>
        OpMinExt = ((int)0x878B)        ,
        /// <summary>
        /// Original was GL_OP_SET_GE_EXT = 0x878C
        /// </summary>
        OpSetGeExt = ((int)0x878C)        ,
        /// <summary>
        /// Original was GL_OP_SET_LT_EXT = 0x878D
        /// </summary>
        OpSetLtExt = ((int)0x878D)        ,
        /// <summary>
        /// Original was GL_OP_CLAMP_EXT = 0x878E
        /// </summary>
        OpClampExt = ((int)0x878E)        ,
        /// <summary>
        /// Original was GL_OP_FLOOR_EXT = 0x878F
        /// </summary>
        OpFloorExt = ((int)0x878F)        ,
        /// <summary>
        /// Original was GL_OP_ROUND_EXT = 0x8790
        /// </summary>
        OpRoundExt = ((int)0x8790)        ,
        /// <summary>
        /// Original was GL_OP_EXP_BASE_2_EXT = 0x8791
        /// </summary>
        OpExpBase2Ext = ((int)0x8791)        ,
        /// <summary>
        /// Original was GL_OP_LOG_BASE_2_EXT = 0x8792
        /// </summary>
        OpLogBase2Ext = ((int)0x8792)        ,
        /// <summary>
        /// Original was GL_OP_POWER_EXT = 0x8793
        /// </summary>
        OpPowerExt = ((int)0x8793)        ,
        /// <summary>
        /// Original was GL_OP_RECIP_EXT = 0x8794
        /// </summary>
        OpRecipExt = ((int)0x8794)        ,
        /// <summary>
        /// Original was GL_OP_RECIP_SQRT_EXT = 0x8795
        /// </summary>
        OpRecipSqrtExt = ((int)0x8795)        ,
        /// <summary>
        /// Original was GL_OP_SUB_EXT = 0x8796
        /// </summary>
        OpSubExt = ((int)0x8796)        ,
        /// <summary>
        /// Original was GL_OP_CROSS_PRODUCT_EXT = 0x8797
        /// </summary>
        OpCrossProductExt = ((int)0x8797)        ,
        /// <summary>
        /// Original was GL_OP_MULTIPLY_MATRIX_EXT = 0x8798
        /// </summary>
        OpMultiplyMatrixExt = ((int)0x8798)        ,
        /// <summary>
        /// Original was GL_OP_MOV_EXT = 0x8799
        /// </summary>
        OpMovExt = ((int)0x8799)        ,
        /// <summary>
        /// Original was GL_OUTPUT_VERTEX_EXT = 0x879A
        /// </summary>
        OutputVertexExt = ((int)0x879A)        ,
        /// <summary>
        /// Original was GL_OUTPUT_COLOR0_EXT = 0x879B
        /// </summary>
        OutputColor0Ext = ((int)0x879B)        ,
        /// <summary>
        /// Original was GL_OUTPUT_COLOR1_EXT = 0x879C
        /// </summary>
        OutputColor1Ext = ((int)0x879C)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD0_EXT = 0x879D
        /// </summary>
        OutputTextureCoord0Ext = ((int)0x879D)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD1_EXT = 0x879E
        /// </summary>
        OutputTextureCoord1Ext = ((int)0x879E)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD2_EXT = 0x879F
        /// </summary>
        OutputTextureCoord2Ext = ((int)0x879F)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD3_EXT = 0x87A0
        /// </summary>
        OutputTextureCoord3Ext = ((int)0x87A0)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD4_EXT = 0x87A1
        /// </summary>
        OutputTextureCoord4Ext = ((int)0x87A1)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD5_EXT = 0x87A2
        /// </summary>
        OutputTextureCoord5Ext = ((int)0x87A2)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD6_EXT = 0x87A3
        /// </summary>
        OutputTextureCoord6Ext = ((int)0x87A3)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD7_EXT = 0x87A4
        /// </summary>
        OutputTextureCoord7Ext = ((int)0x87A4)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD8_EXT = 0x87A5
        /// </summary>
        OutputTextureCoord8Ext = ((int)0x87A5)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD9_EXT = 0x87A6
        /// </summary>
        OutputTextureCoord9Ext = ((int)0x87A6)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD10_EXT = 0x87A7
        /// </summary>
        OutputTextureCoord10Ext = ((int)0x87A7)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD11_EXT = 0x87A8
        /// </summary>
        OutputTextureCoord11Ext = ((int)0x87A8)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD12_EXT = 0x87A9
        /// </summary>
        OutputTextureCoord12Ext = ((int)0x87A9)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD13_EXT = 0x87AA
        /// </summary>
        OutputTextureCoord13Ext = ((int)0x87AA)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD14_EXT = 0x87AB
        /// </summary>
        OutputTextureCoord14Ext = ((int)0x87AB)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD15_EXT = 0x87AC
        /// </summary>
        OutputTextureCoord15Ext = ((int)0x87AC)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD16_EXT = 0x87AD
        /// </summary>
        OutputTextureCoord16Ext = ((int)0x87AD)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD17_EXT = 0x87AE
        /// </summary>
        OutputTextureCoord17Ext = ((int)0x87AE)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD18_EXT = 0x87AF
        /// </summary>
        OutputTextureCoord18Ext = ((int)0x87AF)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD19_EXT = 0x87B0
        /// </summary>
        OutputTextureCoord19Ext = ((int)0x87B0)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD20_EXT = 0x87B1
        /// </summary>
        OutputTextureCoord20Ext = ((int)0x87B1)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD21_EXT = 0x87B2
        /// </summary>
        OutputTextureCoord21Ext = ((int)0x87B2)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD22_EXT = 0x87B3
        /// </summary>
        OutputTextureCoord22Ext = ((int)0x87B3)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD23_EXT = 0x87B4
        /// </summary>
        OutputTextureCoord23Ext = ((int)0x87B4)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD24_EXT = 0x87B5
        /// </summary>
        OutputTextureCoord24Ext = ((int)0x87B5)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD25_EXT = 0x87B6
        /// </summary>
        OutputTextureCoord25Ext = ((int)0x87B6)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD26_EXT = 0x87B7
        /// </summary>
        OutputTextureCoord26Ext = ((int)0x87B7)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD27_EXT = 0x87B8
        /// </summary>
        OutputTextureCoord27Ext = ((int)0x87B8)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD28_EXT = 0x87B9
        /// </summary>
        OutputTextureCoord28Ext = ((int)0x87B9)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD29_EXT = 0x87BA
        /// </summary>
        OutputTextureCoord29Ext = ((int)0x87BA)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD30_EXT = 0x87BB
        /// </summary>
        OutputTextureCoord30Ext = ((int)0x87BB)        ,
        /// <summary>
        /// Original was GL_OUTPUT_TEXTURE_COORD31_EXT = 0x87BC
        /// </summary>
        OutputTextureCoord31Ext = ((int)0x87BC)        ,
        /// <summary>
        /// Original was GL_OUTPUT_FOG_EXT = 0x87BD
        /// </summary>
        OutputFogExt = ((int)0x87BD)        ,
        /// <summary>
        /// Original was GL_SCALAR_EXT = 0x87BE
        /// </summary>
        ScalarExt = ((int)0x87BE)        ,
        /// <summary>
        /// Original was GL_VECTOR_EXT = 0x87BF
        /// </summary>
        VectorExt = ((int)0x87BF)        ,
        /// <summary>
        /// Original was GL_MATRIX_EXT = 0x87C0
        /// </summary>
        MatrixExt = ((int)0x87C0)        ,
        /// <summary>
        /// Original was GL_VARIANT_EXT = 0x87C1
        /// </summary>
        VariantExt = ((int)0x87C1)        ,
        /// <summary>
        /// Original was GL_INVARIANT_EXT = 0x87C2
        /// </summary>
        InvariantExt = ((int)0x87C2)        ,
        /// <summary>
        /// Original was GL_LOCAL_CONSTANT_EXT = 0x87C3
        /// </summary>
        LocalConstantExt = ((int)0x87C3)        ,
        /// <summary>
        /// Original was GL_LOCAL_EXT = 0x87C4
        /// </summary>
        LocalExt = ((int)0x87C4)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT = 0x87C5
        /// </summary>
        MaxVertexShaderInstructionsExt = ((int)0x87C5)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_SHADER_VARIANTS_EXT = 0x87C6
        /// </summary>
        MaxVertexShaderVariantsExt = ((int)0x87C6)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_SHADER_INVARIANTS_EXT = 0x87C7
        /// </summary>
        MaxVertexShaderInvariantsExt = ((int)0x87C7)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = 0x87C8
        /// </summary>
        MaxVertexShaderLocalConstantsExt = ((int)0x87C8)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_SHADER_LOCALS_EXT = 0x87C9
        /// </summary>
        MaxVertexShaderLocalsExt = ((int)0x87C9)        ,
        /// <summary>
        /// Original was GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT = 0x87CA
        /// </summary>
        MaxOptimizedVertexShaderInstructionsExt = ((int)0x87CA)        ,
        /// <summary>
        /// Original was GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT = 0x87CB
        /// </summary>
        MaxOptimizedVertexShaderVariantsExt = ((int)0x87CB)        ,
        /// <summary>
        /// Original was GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = 0x87CC
        /// </summary>
        MaxOptimizedVertexShaderLocalConstantsExt = ((int)0x87CC)        ,
        /// <summary>
        /// Original was GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT = 0x87CD
        /// </summary>
        MaxOptimizedVertexShaderInvariantsExt = ((int)0x87CD)        ,
        /// <summary>
        /// Original was GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT = 0x87CE
        /// </summary>
        MaxOptimizedVertexShaderLocalsExt = ((int)0x87CE)        ,
        /// <summary>
        /// Original was GL_VERTEX_SHADER_INSTRUCTIONS_EXT = 0x87CF
        /// </summary>
        VertexShaderInstructionsExt = ((int)0x87CF)        ,
        /// <summary>
        /// Original was GL_VERTEX_SHADER_VARIANTS_EXT = 0x87D0
        /// </summary>
        VertexShaderVariantsExt = ((int)0x87D0)        ,
        /// <summary>
        /// Original was GL_VERTEX_SHADER_INVARIANTS_EXT = 0x87D1
        /// </summary>
        VertexShaderInvariantsExt = ((int)0x87D1)        ,
        /// <summary>
        /// Original was GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = 0x87D2
        /// </summary>
        VertexShaderLocalConstantsExt = ((int)0x87D2)        ,
        /// <summary>
        /// Original was GL_VERTEX_SHADER_LOCALS_EXT = 0x87D3
        /// </summary>
        VertexShaderLocalsExt = ((int)0x87D3)        ,
        /// <summary>
        /// Original was GL_VERTEX_SHADER_OPTIMIZED_EXT = 0x87D4
        /// </summary>
        VertexShaderOptimizedExt = ((int)0x87D4)        ,
        /// <summary>
        /// Original was GL_X_EXT = 0x87D5
        /// </summary>
        XExt = ((int)0x87D5)        ,
        /// <summary>
        /// Original was GL_Y_EXT = 0x87D6
        /// </summary>
        YExt = ((int)0x87D6)        ,
        /// <summary>
        /// Original was GL_Z_EXT = 0x87D7
        /// </summary>
        ZExt = ((int)0x87D7)        ,
        /// <summary>
        /// Original was GL_W_EXT = 0x87D8
        /// </summary>
        WExt = ((int)0x87D8)        ,
        /// <summary>
        /// Original was GL_NEGATIVE_X_EXT = 0x87D9
        /// </summary>
        NegativeXExt = ((int)0x87D9)        ,
        /// <summary>
        /// Original was GL_NEGATIVE_Y_EXT = 0x87DA
        /// </summary>
        NegativeYExt = ((int)0x87DA)        ,
        /// <summary>
        /// Original was GL_NEGATIVE_Z_EXT = 0x87DB
        /// </summary>
        NegativeZExt = ((int)0x87DB)        ,
        /// <summary>
        /// Original was GL_NEGATIVE_W_EXT = 0x87DC
        /// </summary>
        NegativeWExt = ((int)0x87DC)        ,
        /// <summary>
        /// Original was GL_ZERO_EXT = 0x87DD
        /// </summary>
        ZeroExt = ((int)0x87DD)        ,
        /// <summary>
        /// Original was GL_ONE_EXT = 0x87DE
        /// </summary>
        OneExt = ((int)0x87DE)        ,
        /// <summary>
        /// Original was GL_NEGATIVE_ONE_EXT = 0x87DF
        /// </summary>
        NegativeOneExt = ((int)0x87DF)        ,
        /// <summary>
        /// Original was GL_NORMALIZED_RANGE_EXT = 0x87E0
        /// </summary>
        NormalizedRangeExt = ((int)0x87E0)        ,
        /// <summary>
        /// Original was GL_FULL_RANGE_EXT = 0x87E1
        /// </summary>
        FullRangeExt = ((int)0x87E1)        ,
        /// <summary>
        /// Original was GL_CURRENT_VERTEX_EXT = 0x87E2
        /// </summary>
        CurrentVertexExt = ((int)0x87E2)        ,
        /// <summary>
        /// Original was GL_MVP_MATRIX_EXT = 0x87E3
        /// </summary>
        MvpMatrixExt = ((int)0x87E3)        ,
        /// <summary>
        /// Original was GL_VARIANT_VALUE_EXT = 0x87E4
        /// </summary>
        VariantValueExt = ((int)0x87E4)        ,
        /// <summary>
        /// Original was GL_VARIANT_DATATYPE_EXT = 0x87E5
        /// </summary>
        VariantDatatypeExt = ((int)0x87E5)        ,
        /// <summary>
        /// Original was GL_VARIANT_ARRAY_STRIDE_EXT = 0x87E6
        /// </summary>
        VariantArrayStrideExt = ((int)0x87E6)        ,
        /// <summary>
        /// Original was GL_VARIANT_ARRAY_TYPE_EXT = 0x87E7
        /// </summary>
        VariantArrayTypeExt = ((int)0x87E7)        ,
        /// <summary>
        /// Original was GL_VARIANT_ARRAY_EXT = 0x87E8
        /// </summary>
        VariantArrayExt = ((int)0x87E8)        ,
        /// <summary>
        /// Original was GL_VARIANT_ARRAY_POINTER_EXT = 0x87E9
        /// </summary>
        VariantArrayPointerExt = ((int)0x87E9)        ,
        /// <summary>
        /// Original was GL_INVARIANT_VALUE_EXT = 0x87EA
        /// </summary>
        InvariantValueExt = ((int)0x87EA)        ,
        /// <summary>
        /// Original was GL_INVARIANT_DATATYPE_EXT = 0x87EB
        /// </summary>
        InvariantDatatypeExt = ((int)0x87EB)        ,
        /// <summary>
        /// Original was GL_LOCAL_CONSTANT_VALUE_EXT = 0x87EC
        /// </summary>
        LocalConstantValueExt = ((int)0x87EC)        ,
        /// <summary>
        /// Original was GL_LOCAL_CONSTANT_DATATYPE_EXT = 0x87ED
        /// </summary>
        LocalConstantDatatypeExt = ((int)0x87ED)        ,
        /// <summary>
        /// Original was GL_PN_TRIANGLES_ATI = 0x87F0
        /// </summary>
        PnTrianglesAti = ((int)0x87F0)        ,
        /// <summary>
        /// Original was GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI = 0x87F1
        /// </summary>
        MaxPnTrianglesTesselationLevelAti = ((int)0x87F1)        ,
        /// <summary>
        /// Original was GL_PN_TRIANGLES_POINT_MODE_ATI = 0x87F2
        /// </summary>
        PnTrianglesPointModeAti = ((int)0x87F2)        ,
        /// <summary>
        /// Original was GL_PN_TRIANGLES_NORMAL_MODE_ATI = 0x87F3
        /// </summary>
        PnTrianglesNormalModeAti = ((int)0x87F3)        ,
        /// <summary>
        /// Original was GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI = 0x87F4
        /// </summary>
        PnTrianglesTesselationLevelAti = ((int)0x87F4)        ,
        /// <summary>
        /// Original was GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI = 0x87F5
        /// </summary>
        PnTrianglesPointModeLinearAti = ((int)0x87F5)        ,
        /// <summary>
        /// Original was GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI = 0x87F6
        /// </summary>
        PnTrianglesPointModeCubicAti = ((int)0x87F6)        ,
        /// <summary>
        /// Original was GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI = 0x87F7
        /// </summary>
        PnTrianglesNormalModeLinearAti = ((int)0x87F7)        ,
        /// <summary>
        /// Original was GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI = 0x87F8
        /// </summary>
        PnTrianglesNormalModeQuadraticAti = ((int)0x87F8)        ,
        /// <summary>
        /// Original was GL_VBO_FREE_MEMORY_ATI = 0x87FB
        /// </summary>
        VboFreeMemoryAti = ((int)0x87FB)        ,
        /// <summary>
        /// Original was GL_TEXTURE_FREE_MEMORY_ATI = 0x87FC
        /// </summary>
        TextureFreeMemoryAti = ((int)0x87FC)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_FREE_MEMORY_ATI = 0x87FD
        /// </summary>
        RenderbufferFreeMemoryAti = ((int)0x87FD)        ,
        /// <summary>
        /// Original was GL_NUM_PROGRAM_BINARY_FORMATS = 0x87FE
        /// </summary>
        NumProgramBinaryFormats = ((int)0x87FE)        ,
        /// <summary>
        /// Original was GL_PROGRAM_BINARY_FORMATS = 0x87FF
        /// </summary>
        ProgramBinaryFormats = ((int)0x87FF)        ,
        /// <summary>
        /// Original was GL_STENCIL_BACK_FUNC = 0x8800
        /// </summary>
        StencilBackFunc = ((int)0x8800)        ,
        /// <summary>
        /// Original was GL_STENCIL_BACK_FUNC_ATI = 0x8800
        /// </summary>
        StencilBackFuncAti = ((int)0x8800)        ,
        /// <summary>
        /// Original was GL_STENCIL_BACK_FAIL = 0x8801
        /// </summary>
        StencilBackFail = ((int)0x8801)        ,
        /// <summary>
        /// Original was GL_STENCIL_BACK_FAIL_ATI = 0x8801
        /// </summary>
        StencilBackFailAti = ((int)0x8801)        ,
        /// <summary>
        /// Original was GL_STENCIL_BACK_PASS_DEPTH_FAIL = 0x8802
        /// </summary>
        StencilBackPassDepthFail = ((int)0x8802)        ,
        /// <summary>
        /// Original was GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI = 0x8802
        /// </summary>
        StencilBackPassDepthFailAti = ((int)0x8802)        ,
        /// <summary>
        /// Original was GL_STENCIL_BACK_PASS_DEPTH_PASS = 0x8803
        /// </summary>
        StencilBackPassDepthPass = ((int)0x8803)        ,
        /// <summary>
        /// Original was GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI = 0x8803
        /// </summary>
        StencilBackPassDepthPassAti = ((int)0x8803)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_PROGRAM = 0x8804
        /// </summary>
        FragmentProgram = ((int)0x8804)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_PROGRAM_ARB = 0x8804
        /// </summary>
        FragmentProgramArb = ((int)0x8804)        ,
        /// <summary>
        /// Original was GL_PROGRAM_ALU_INSTRUCTIONS_ARB = 0x8805
        /// </summary>
        ProgramAluInstructionsArb = ((int)0x8805)        ,
        /// <summary>
        /// Original was GL_PROGRAM_TEX_INSTRUCTIONS_ARB = 0x8806
        /// </summary>
        ProgramTexInstructionsArb = ((int)0x8806)        ,
        /// <summary>
        /// Original was GL_PROGRAM_TEX_INDIRECTIONS_ARB = 0x8807
        /// </summary>
        ProgramTexIndirectionsArb = ((int)0x8807)        ,
        /// <summary>
        /// Original was GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = 0x8808
        /// </summary>
        ProgramNativeAluInstructionsArb = ((int)0x8808)        ,
        /// <summary>
        /// Original was GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = 0x8809
        /// </summary>
        ProgramNativeTexInstructionsArb = ((int)0x8809)        ,
        /// <summary>
        /// Original was GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = 0x880A
        /// </summary>
        ProgramNativeTexIndirectionsArb = ((int)0x880A)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB = 0x880B
        /// </summary>
        MaxProgramAluInstructionsArb = ((int)0x880B)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB = 0x880C
        /// </summary>
        MaxProgramTexInstructionsArb = ((int)0x880C)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB = 0x880D
        /// </summary>
        MaxProgramTexIndirectionsArb = ((int)0x880D)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = 0x880E
        /// </summary>
        MaxProgramNativeAluInstructionsArb = ((int)0x880E)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = 0x880F
        /// </summary>
        MaxProgramNativeTexInstructionsArb = ((int)0x880F)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = 0x8810
        /// </summary>
        MaxProgramNativeTexIndirectionsArb = ((int)0x8810)        ,
        /// <summary>
        /// Original was GL_RGBA32F = 0x8814
        /// </summary>
        Rgba32f = ((int)0x8814)        ,
        /// <summary>
        /// Original was GL_RGBA32F_ARB = 0x8814
        /// </summary>
        Rgba32fArb = ((int)0x8814)        ,
        /// <summary>
        /// Original was GL_RGBA_FLOAT32_APPLE = 0x8814
        /// </summary>
        RgbaFloat32Apple = ((int)0x8814)        ,
        /// <summary>
        /// Original was GL_RGBA_FLOAT32_ATI = 0x8814
        /// </summary>
        RgbaFloat32Ati = ((int)0x8814)        ,
        /// <summary>
        /// Original was GL_RGB32F = 0x8815
        /// </summary>
        Rgb32f = ((int)0x8815)        ,
        /// <summary>
        /// Original was GL_RGB32F_ARB = 0x8815
        /// </summary>
        Rgb32fArb = ((int)0x8815)        ,
        /// <summary>
        /// Original was GL_RGB_FLOAT32_APPLE = 0x8815
        /// </summary>
        RgbFloat32Apple = ((int)0x8815)        ,
        /// <summary>
        /// Original was GL_RGB_FLOAT32_ATI = 0x8815
        /// </summary>
        RgbFloat32Ati = ((int)0x8815)        ,
        /// <summary>
        /// Original was GL_ALPHA32F_ARB = 0x8816
        /// </summary>
        Alpha32fArb = ((int)0x8816)        ,
        /// <summary>
        /// Original was GL_ALPHA_FLOAT32_APPLE = 0x8816
        /// </summary>
        AlphaFloat32Apple = ((int)0x8816)        ,
        /// <summary>
        /// Original was GL_ALPHA_FLOAT32_ATI = 0x8816
        /// </summary>
        AlphaFloat32Ati = ((int)0x8816)        ,
        /// <summary>
        /// Original was GL_INTENSITY32F_ARB = 0x8817
        /// </summary>
        Intensity32fArb = ((int)0x8817)        ,
        /// <summary>
        /// Original was GL_INTENSITY_FLOAT32_APPLE = 0x8817
        /// </summary>
        IntensityFloat32Apple = ((int)0x8817)        ,
        /// <summary>
        /// Original was GL_INTENSITY_FLOAT32_ATI = 0x8817
        /// </summary>
        IntensityFloat32Ati = ((int)0x8817)        ,
        /// <summary>
        /// Original was GL_LUMINANCE32F_ARB = 0x8818
        /// </summary>
        Luminance32fArb = ((int)0x8818)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_FLOAT32_APPLE = 0x8818
        /// </summary>
        LuminanceFloat32Apple = ((int)0x8818)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_FLOAT32_ATI = 0x8818
        /// </summary>
        LuminanceFloat32Ati = ((int)0x8818)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ALPHA32F_ARB = 0x8819
        /// </summary>
        LuminanceAlpha32fArb = ((int)0x8819)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ALPHA_FLOAT32_APPLE = 0x8819
        /// </summary>
        LuminanceAlphaFloat32Apple = ((int)0x8819)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ALPHA_FLOAT32_ATI = 0x8819
        /// </summary>
        LuminanceAlphaFloat32Ati = ((int)0x8819)        ,
        /// <summary>
        /// Original was GL_RGBA16F = 0x881A
        /// </summary>
        Rgba16f = ((int)0x881A)        ,
        /// <summary>
        /// Original was GL_RGBA16F_ARB = 0x881A
        /// </summary>
        Rgba16fArb = ((int)0x881A)        ,
        /// <summary>
        /// Original was GL_RGBA_FLOAT16_APPLE = 0x881A
        /// </summary>
        RgbaFloat16Apple = ((int)0x881A)        ,
        /// <summary>
        /// Original was GL_RGBA_FLOAT16_ATI = 0x881A
        /// </summary>
        RgbaFloat16Ati = ((int)0x881A)        ,
        /// <summary>
        /// Original was GL_RGB16F = 0x881B
        /// </summary>
        Rgb16f = ((int)0x881B)        ,
        /// <summary>
        /// Original was GL_RGB16F_ARB = 0x881B
        /// </summary>
        Rgb16fArb = ((int)0x881B)        ,
        /// <summary>
        /// Original was GL_RGB_FLOAT16_APPLE = 0x881B
        /// </summary>
        RgbFloat16Apple = ((int)0x881B)        ,
        /// <summary>
        /// Original was GL_RGB_FLOAT16_ATI = 0x881B
        /// </summary>
        RgbFloat16Ati = ((int)0x881B)        ,
        /// <summary>
        /// Original was GL_ALPHA16F_ARB = 0x881C
        /// </summary>
        Alpha16fArb = ((int)0x881C)        ,
        /// <summary>
        /// Original was GL_ALPHA_FLOAT16_APPLE = 0x881C
        /// </summary>
        AlphaFloat16Apple = ((int)0x881C)        ,
        /// <summary>
        /// Original was GL_ALPHA_FLOAT16_ATI = 0x881C
        /// </summary>
        AlphaFloat16Ati = ((int)0x881C)        ,
        /// <summary>
        /// Original was GL_INTENSITY16F_ARB = 0x881D
        /// </summary>
        Intensity16fArb = ((int)0x881D)        ,
        /// <summary>
        /// Original was GL_INTENSITY_FLOAT16_APPLE = 0x881D
        /// </summary>
        IntensityFloat16Apple = ((int)0x881D)        ,
        /// <summary>
        /// Original was GL_INTENSITY_FLOAT16_ATI = 0x881D
        /// </summary>
        IntensityFloat16Ati = ((int)0x881D)        ,
        /// <summary>
        /// Original was GL_LUMINANCE16F_ARB = 0x881E
        /// </summary>
        Luminance16fArb = ((int)0x881E)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_FLOAT16_APPLE = 0x881E
        /// </summary>
        LuminanceFloat16Apple = ((int)0x881E)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_FLOAT16_ATI = 0x881E
        /// </summary>
        LuminanceFloat16Ati = ((int)0x881E)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ALPHA16F_ARB = 0x881F
        /// </summary>
        LuminanceAlpha16fArb = ((int)0x881F)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ALPHA_FLOAT16_APPLE = 0x881F
        /// </summary>
        LuminanceAlphaFloat16Apple = ((int)0x881F)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ALPHA_FLOAT16_ATI = 0x881F
        /// </summary>
        LuminanceAlphaFloat16Ati = ((int)0x881F)        ,
        /// <summary>
        /// Original was GL_RGBA_FLOAT_MODE = 0x8820
        /// </summary>
        RgbaFloatMode = ((int)0x8820)        ,
        /// <summary>
        /// Original was GL_RGBA_FLOAT_MODE_ARB = 0x8820
        /// </summary>
        RgbaFloatModeArb = ((int)0x8820)        ,
        /// <summary>
        /// Original was GL_RGBA_FLOAT_MODE_ATI = 0x8820
        /// </summary>
        RgbaFloatModeAti = ((int)0x8820)        ,
        /// <summary>
        /// Original was GL_MAX_DRAW_BUFFERS = 0x8824
        /// </summary>
        MaxDrawBuffers = ((int)0x8824)        ,
        /// <summary>
        /// Original was GL_MAX_DRAW_BUFFERS_ARB = 0x8824
        /// </summary>
        MaxDrawBuffersArb = ((int)0x8824)        ,
        /// <summary>
        /// Original was GL_MAX_DRAW_BUFFERS_ATI = 0x8824
        /// </summary>
        MaxDrawBuffersAti = ((int)0x8824)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER0 = 0x8825
        /// </summary>
        DrawBuffer0 = ((int)0x8825)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER0_ARB = 0x8825
        /// </summary>
        DrawBuffer0Arb = ((int)0x8825)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER0_ATI = 0x8825
        /// </summary>
        DrawBuffer0Ati = ((int)0x8825)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER1 = 0x8826
        /// </summary>
        DrawBuffer1 = ((int)0x8826)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER1_ARB = 0x8826
        /// </summary>
        DrawBuffer1Arb = ((int)0x8826)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER1_ATI = 0x8826
        /// </summary>
        DrawBuffer1Ati = ((int)0x8826)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER2 = 0x8827
        /// </summary>
        DrawBuffer2 = ((int)0x8827)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER2_ARB = 0x8827
        /// </summary>
        DrawBuffer2Arb = ((int)0x8827)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER2_ATI = 0x8827
        /// </summary>
        DrawBuffer2Ati = ((int)0x8827)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER3 = 0x8828
        /// </summary>
        DrawBuffer3 = ((int)0x8828)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER3_ARB = 0x8828
        /// </summary>
        DrawBuffer3Arb = ((int)0x8828)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER3_ATI = 0x8828
        /// </summary>
        DrawBuffer3Ati = ((int)0x8828)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER4 = 0x8829
        /// </summary>
        DrawBuffer4 = ((int)0x8829)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER4_ARB = 0x8829
        /// </summary>
        DrawBuffer4Arb = ((int)0x8829)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER4_ATI = 0x8829
        /// </summary>
        DrawBuffer4Ati = ((int)0x8829)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER5 = 0x882A
        /// </summary>
        DrawBuffer5 = ((int)0x882A)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER5_ARB = 0x882A
        /// </summary>
        DrawBuffer5Arb = ((int)0x882A)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER5_ATI = 0x882A
        /// </summary>
        DrawBuffer5Ati = ((int)0x882A)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER6 = 0x882B
        /// </summary>
        DrawBuffer6 = ((int)0x882B)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER6_ARB = 0x882B
        /// </summary>
        DrawBuffer6Arb = ((int)0x882B)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER6_ATI = 0x882B
        /// </summary>
        DrawBuffer6Ati = ((int)0x882B)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER7 = 0x882C
        /// </summary>
        DrawBuffer7 = ((int)0x882C)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER7_ARB = 0x882C
        /// </summary>
        DrawBuffer7Arb = ((int)0x882C)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER7_ATI = 0x882C
        /// </summary>
        DrawBuffer7Ati = ((int)0x882C)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER8 = 0x882D
        /// </summary>
        DrawBuffer8 = ((int)0x882D)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER8_ARB = 0x882D
        /// </summary>
        DrawBuffer8Arb = ((int)0x882D)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER8_ATI = 0x882D
        /// </summary>
        DrawBuffer8Ati = ((int)0x882D)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER9 = 0x882E
        /// </summary>
        DrawBuffer9 = ((int)0x882E)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER9_ARB = 0x882E
        /// </summary>
        DrawBuffer9Arb = ((int)0x882E)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER9_ATI = 0x882E
        /// </summary>
        DrawBuffer9Ati = ((int)0x882E)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER10 = 0x882F
        /// </summary>
        DrawBuffer10 = ((int)0x882F)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER10_ARB = 0x882F
        /// </summary>
        DrawBuffer10Arb = ((int)0x882F)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER10_ATI = 0x882F
        /// </summary>
        DrawBuffer10Ati = ((int)0x882F)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER11 = 0x8830
        /// </summary>
        DrawBuffer11 = ((int)0x8830)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER11_ARB = 0x8830
        /// </summary>
        DrawBuffer11Arb = ((int)0x8830)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER11_ATI = 0x8830
        /// </summary>
        DrawBuffer11Ati = ((int)0x8830)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER12 = 0x8831
        /// </summary>
        DrawBuffer12 = ((int)0x8831)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER12_ARB = 0x8831
        /// </summary>
        DrawBuffer12Arb = ((int)0x8831)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER12_ATI = 0x8831
        /// </summary>
        DrawBuffer12Ati = ((int)0x8831)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER13 = 0x8832
        /// </summary>
        DrawBuffer13 = ((int)0x8832)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER13_ARB = 0x8832
        /// </summary>
        DrawBuffer13Arb = ((int)0x8832)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER13_ATI = 0x8832
        /// </summary>
        DrawBuffer13Ati = ((int)0x8832)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER14 = 0x8833
        /// </summary>
        DrawBuffer14 = ((int)0x8833)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER14_ARB = 0x8833
        /// </summary>
        DrawBuffer14Arb = ((int)0x8833)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER14_ATI = 0x8833
        /// </summary>
        DrawBuffer14Ati = ((int)0x8833)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER15 = 0x8834
        /// </summary>
        DrawBuffer15 = ((int)0x8834)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER15_ARB = 0x8834
        /// </summary>
        DrawBuffer15Arb = ((int)0x8834)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER15_ATI = 0x8834
        /// </summary>
        DrawBuffer15Ati = ((int)0x8834)        ,
        /// <summary>
        /// Original was GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI = 0x8835
        /// </summary>
        ColorClearUnclampedValueAti = ((int)0x8835)        ,
        /// <summary>
        /// Original was GL_BLEND_EQUATION_ALPHA = 0x883D
        /// </summary>
        BlendEquationAlpha = ((int)0x883D)        ,
        /// <summary>
        /// Original was GL_BLEND_EQUATION_ALPHA_EXT = 0x883D
        /// </summary>
        BlendEquationAlphaExt = ((int)0x883D)        ,
        /// <summary>
        /// Original was GL_SUBSAMPLE_DISTANCE_AMD = 0x883F
        /// </summary>
        SubsampleDistanceAmd = ((int)0x883F)        ,
        /// <summary>
        /// Original was GL_MATRIX_PALETTE_ARB = 0x8840
        /// </summary>
        MatrixPaletteArb = ((int)0x8840)        ,
        /// <summary>
        /// Original was GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB = 0x8841
        /// </summary>
        MaxMatrixPaletteStackDepthArb = ((int)0x8841)        ,
        /// <summary>
        /// Original was GL_MAX_PALETTE_MATRICES_ARB = 0x8842
        /// </summary>
        MaxPaletteMatricesArb = ((int)0x8842)        ,
        /// <summary>
        /// Original was GL_CURRENT_PALETTE_MATRIX_ARB = 0x8843
        /// </summary>
        CurrentPaletteMatrixArb = ((int)0x8843)        ,
        /// <summary>
        /// Original was GL_MATRIX_INDEX_ARRAY_ARB = 0x8844
        /// </summary>
        MatrixIndexArrayArb = ((int)0x8844)        ,
        /// <summary>
        /// Original was GL_CURRENT_MATRIX_INDEX_ARB = 0x8845
        /// </summary>
        CurrentMatrixIndexArb = ((int)0x8845)        ,
        /// <summary>
        /// Original was GL_MATRIX_INDEX_ARRAY_SIZE_ARB = 0x8846
        /// </summary>
        MatrixIndexArraySizeArb = ((int)0x8846)        ,
        /// <summary>
        /// Original was GL_MATRIX_INDEX_ARRAY_TYPE_ARB = 0x8847
        /// </summary>
        MatrixIndexArrayTypeArb = ((int)0x8847)        ,
        /// <summary>
        /// Original was GL_MATRIX_INDEX_ARRAY_STRIDE_ARB = 0x8848
        /// </summary>
        MatrixIndexArrayStrideArb = ((int)0x8848)        ,
        /// <summary>
        /// Original was GL_MATRIX_INDEX_ARRAY_POINTER_ARB = 0x8849
        /// </summary>
        MatrixIndexArrayPointerArb = ((int)0x8849)        ,
        /// <summary>
        /// Original was GL_TEXTURE_DEPTH_SIZE = 0x884A
        /// </summary>
        TextureDepthSize = ((int)0x884A)        ,
        /// <summary>
        /// Original was GL_TEXTURE_DEPTH_SIZE_ARB = 0x884A
        /// </summary>
        TextureDepthSizeArb = ((int)0x884A)        ,
        /// <summary>
        /// Original was GL_DEPTH_TEXTURE_MODE = 0x884B
        /// </summary>
        DepthTextureMode = ((int)0x884B)        ,
        /// <summary>
        /// Original was GL_DEPTH_TEXTURE_MODE_ARB = 0x884B
        /// </summary>
        DepthTextureModeArb = ((int)0x884B)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPARE_MODE = 0x884C
        /// </summary>
        TextureCompareMode = ((int)0x884C)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPARE_MODE_ARB = 0x884C
        /// </summary>
        TextureCompareModeArb = ((int)0x884C)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPARE_FUNC = 0x884D
        /// </summary>
        TextureCompareFunc = ((int)0x884D)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPARE_FUNC_ARB = 0x884D
        /// </summary>
        TextureCompareFuncArb = ((int)0x884D)        ,
        /// <summary>
        /// Original was GL_COMPARE_REF_DEPTH_TO_TEXTURE_EXT = 0x884E
        /// </summary>
        CompareRefDepthToTextureExt = ((int)0x884E)        ,
        /// <summary>
        /// Original was GL_COMPARE_REF_TO_TEXTURE = 0x884E
        /// </summary>
        CompareRefToTexture = ((int)0x884E)        ,
        /// <summary>
        /// Original was GL_COMPARE_R_TO_TEXTURE = 0x884E
        /// </summary>
        CompareRToTexture = ((int)0x884E)        ,
        /// <summary>
        /// Original was GL_COMPARE_R_TO_TEXTURE_ARB = 0x884E
        /// </summary>
        CompareRToTextureArb = ((int)0x884E)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_SEAMLESS = 0x884F
        /// </summary>
        TextureCubeMapSeamless = ((int)0x884F)        ,
        /// <summary>
        /// Original was GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV = 0x8850
        /// </summary>
        OffsetProjectiveTexture2DNv = ((int)0x8850)        ,
        /// <summary>
        /// Original was GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV = 0x8851
        /// </summary>
        OffsetProjectiveTexture2DScaleNv = ((int)0x8851)        ,
        /// <summary>
        /// Original was GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV = 0x8852
        /// </summary>
        OffsetProjectiveTextureRectangleNv = ((int)0x8852)        ,
        /// <summary>
        /// Original was GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV = 0x8853
        /// </summary>
        OffsetProjectiveTextureRectangleScaleNv = ((int)0x8853)        ,
        /// <summary>
        /// Original was GL_OFFSET_HILO_TEXTURE_2D_NV = 0x8854
        /// </summary>
        OffsetHiloTexture2DNv = ((int)0x8854)        ,
        /// <summary>
        /// Original was GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV = 0x8855
        /// </summary>
        OffsetHiloTextureRectangleNv = ((int)0x8855)        ,
        /// <summary>
        /// Original was GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV = 0x8856
        /// </summary>
        OffsetHiloProjectiveTexture2DNv = ((int)0x8856)        ,
        /// <summary>
        /// Original was GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV = 0x8857
        /// </summary>
        OffsetHiloProjectiveTextureRectangleNv = ((int)0x8857)        ,
        /// <summary>
        /// Original was GL_DEPENDENT_HILO_TEXTURE_2D_NV = 0x8858
        /// </summary>
        DependentHiloTexture2DNv = ((int)0x8858)        ,
        /// <summary>
        /// Original was GL_DEPENDENT_RGB_TEXTURE_3D_NV = 0x8859
        /// </summary>
        DependentRgbTexture3DNv = ((int)0x8859)        ,
        /// <summary>
        /// Original was GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV = 0x885A
        /// </summary>
        DependentRgbTextureCubeMapNv = ((int)0x885A)        ,
        /// <summary>
        /// Original was GL_DOT_PRODUCT_PASS_THROUGH_NV = 0x885B
        /// </summary>
        DotProductPassThroughNv = ((int)0x885B)        ,
        /// <summary>
        /// Original was GL_DOT_PRODUCT_TEXTURE_1D_NV = 0x885C
        /// </summary>
        DotProductTexture1DNv = ((int)0x885C)        ,
        /// <summary>
        /// Original was GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV = 0x885D
        /// </summary>
        DotProductAffineDepthReplaceNv = ((int)0x885D)        ,
        /// <summary>
        /// Original was GL_HILO8_NV = 0x885E
        /// </summary>
        Hilo8Nv = ((int)0x885E)        ,
        /// <summary>
        /// Original was GL_SIGNED_HILO8_NV = 0x885F
        /// </summary>
        SignedHilo8Nv = ((int)0x885F)        ,
        /// <summary>
        /// Original was GL_FORCE_BLUE_TO_ONE_NV = 0x8860
        /// </summary>
        ForceBlueToOneNv = ((int)0x8860)        ,
        /// <summary>
        /// Original was GL_POINT_SPRITE = 0x8861
        /// </summary>
        PointSprite = ((int)0x8861)        ,
        /// <summary>
        /// Original was GL_POINT_SPRITE_ARB = 0x8861
        /// </summary>
        PointSpriteArb = ((int)0x8861)        ,
        /// <summary>
        /// Original was GL_POINT_SPRITE_NV = 0x8861
        /// </summary>
        PointSpriteNv = ((int)0x8861)        ,
        /// <summary>
        /// Original was GL_COORD_REPLACE = 0x8862
        /// </summary>
        CoordReplace = ((int)0x8862)        ,
        /// <summary>
        /// Original was GL_COORD_REPLACE_ARB = 0x8862
        /// </summary>
        CoordReplaceArb = ((int)0x8862)        ,
        /// <summary>
        /// Original was GL_COORD_REPLACE_NV = 0x8862
        /// </summary>
        CoordReplaceNv = ((int)0x8862)        ,
        /// <summary>
        /// Original was GL_POINT_SPRITE_R_MODE_NV = 0x8863
        /// </summary>
        PointSpriteRModeNv = ((int)0x8863)        ,
        /// <summary>
        /// Original was GL_PIXEL_COUNTER_BITS_NV = 0x8864
        /// </summary>
        PixelCounterBitsNv = ((int)0x8864)        ,
        /// <summary>
        /// Original was GL_QUERY_COUNTER_BITS = 0x8864
        /// </summary>
        QueryCounterBits = ((int)0x8864)        ,
        /// <summary>
        /// Original was GL_QUERY_COUNTER_BITS_ARB = 0x8864
        /// </summary>
        QueryCounterBitsArb = ((int)0x8864)        ,
        /// <summary>
        /// Original was GL_CURRENT_OCCLUSION_QUERY_ID_NV = 0x8865
        /// </summary>
        CurrentOcclusionQueryIdNv = ((int)0x8865)        ,
        /// <summary>
        /// Original was GL_CURRENT_QUERY = 0x8865
        /// </summary>
        CurrentQuery = ((int)0x8865)        ,
        /// <summary>
        /// Original was GL_CURRENT_QUERY_ARB = 0x8865
        /// </summary>
        CurrentQueryArb = ((int)0x8865)        ,
        /// <summary>
        /// Original was GL_PIXEL_COUNT_NV = 0x8866
        /// </summary>
        PixelCountNv = ((int)0x8866)        ,
        /// <summary>
        /// Original was GL_QUERY_RESULT = 0x8866
        /// </summary>
        QueryResult = ((int)0x8866)        ,
        /// <summary>
        /// Original was GL_QUERY_RESULT_ARB = 0x8866
        /// </summary>
        QueryResultArb = ((int)0x8866)        ,
        /// <summary>
        /// Original was GL_PIXEL_COUNT_AVAILABLE_NV = 0x8867
        /// </summary>
        PixelCountAvailableNv = ((int)0x8867)        ,
        /// <summary>
        /// Original was GL_QUERY_RESULT_AVAILABLE = 0x8867
        /// </summary>
        QueryResultAvailable = ((int)0x8867)        ,
        /// <summary>
        /// Original was GL_QUERY_RESULT_AVAILABLE_ARB = 0x8867
        /// </summary>
        QueryResultAvailableArb = ((int)0x8867)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV = 0x8868
        /// </summary>
        MaxFragmentProgramLocalParametersNv = ((int)0x8868)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_ATTRIBS = 0x8869
        /// </summary>
        MaxVertexAttribs = ((int)0x8869)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_ATTRIBS_ARB = 0x8869
        /// </summary>
        MaxVertexAttribsArb = ((int)0x8869)        ,
        /// <summary>
        /// Original was GL_ARRAY_NORMALIZED = 0x886A
        /// </summary>
        ArrayNormalized = ((int)0x886A)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 0x886A
        /// </summary>
        VertexAttribArrayNormalized = ((int)0x886A)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB = 0x886A
        /// </summary>
        VertexAttribArrayNormalizedArb = ((int)0x886A)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_CONTROL_INPUT_COMPONENTS = 0x886C
        /// </summary>
        MaxTessControlInputComponents = ((int)0x886C)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS = 0x886D
        /// </summary>
        MaxTessEvaluationInputComponents = ((int)0x886D)        ,
        /// <summary>
        /// Original was GL_DEPTH_STENCIL_TO_RGBA_NV = 0x886E
        /// </summary>
        DepthStencilToRgbaNv = ((int)0x886E)        ,
        /// <summary>
        /// Original was GL_DEPTH_STENCIL_TO_BGRA_NV = 0x886F
        /// </summary>
        DepthStencilToBgraNv = ((int)0x886F)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_PROGRAM_NV = 0x8870
        /// </summary>
        FragmentProgramNv = ((int)0x8870)        ,
        /// <summary>
        /// Original was GL_MAX_TEXTURE_COORDS = 0x8871
        /// </summary>
        MaxTextureCoords = ((int)0x8871)        ,
        /// <summary>
        /// Original was GL_MAX_TEXTURE_COORDS_ARB = 0x8871
        /// </summary>
        MaxTextureCoordsArb = ((int)0x8871)        ,
        /// <summary>
        /// Original was GL_MAX_TEXTURE_COORDS_NV = 0x8871
        /// </summary>
        MaxTextureCoordsNv = ((int)0x8871)        ,
        /// <summary>
        /// Original was GL_MAX_TEXTURE_IMAGE_UNITS = 0x8872
        /// </summary>
        MaxTextureImageUnits = ((int)0x8872)        ,
        /// <summary>
        /// Original was GL_MAX_TEXTURE_IMAGE_UNITS_ARB = 0x8872
        /// </summary>
        MaxTextureImageUnitsArb = ((int)0x8872)        ,
        /// <summary>
        /// Original was GL_MAX_TEXTURE_IMAGE_UNITS_NV = 0x8872
        /// </summary>
        MaxTextureImageUnitsNv = ((int)0x8872)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_PROGRAM_BINDING_NV = 0x8873
        /// </summary>
        FragmentProgramBindingNv = ((int)0x8873)        ,
        /// <summary>
        /// Original was GL_PROGRAM_ERROR_STRING_ARB = 0x8874
        /// </summary>
        ProgramErrorStringArb = ((int)0x8874)        ,
        /// <summary>
        /// Original was GL_PROGRAM_ERROR_STRING_NV = 0x8874
        /// </summary>
        ProgramErrorStringNv = ((int)0x8874)        ,
        /// <summary>
        /// Original was GL_PROGRAM_FORMAT_ASCII_ARB = 0x8875
        /// </summary>
        ProgramFormatAsciiArb = ((int)0x8875)        ,
        /// <summary>
        /// Original was GL_PROGRAM_FORMAT = 0x8876
        /// </summary>
        ProgramFormat = ((int)0x8876)        ,
        /// <summary>
        /// Original was GL_PROGRAM_FORMAT_ARB = 0x8876
        /// </summary>
        ProgramFormatArb = ((int)0x8876)        ,
        /// <summary>
        /// Original was GL_WRITE_PIXEL_DATA_RANGE_NV = 0x8878
        /// </summary>
        WritePixelDataRangeNv = ((int)0x8878)        ,
        /// <summary>
        /// Original was GL_READ_PIXEL_DATA_RANGE_NV = 0x8879
        /// </summary>
        ReadPixelDataRangeNv = ((int)0x8879)        ,
        /// <summary>
        /// Original was GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV = 0x887A
        /// </summary>
        WritePixelDataRangeLengthNv = ((int)0x887A)        ,
        /// <summary>
        /// Original was GL_READ_PIXEL_DATA_RANGE_LENGTH_NV = 0x887B
        /// </summary>
        ReadPixelDataRangeLengthNv = ((int)0x887B)        ,
        /// <summary>
        /// Original was GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV = 0x887C
        /// </summary>
        WritePixelDataRangePointerNv = ((int)0x887C)        ,
        /// <summary>
        /// Original was GL_READ_PIXEL_DATA_RANGE_POINTER_NV = 0x887D
        /// </summary>
        ReadPixelDataRangePointerNv = ((int)0x887D)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_SHADER_INVOCATIONS = 0x887F
        /// </summary>
        GeometryShaderInvocations = ((int)0x887F)        ,
        /// <summary>
        /// Original was GL_FLOAT_R_NV = 0x8880
        /// </summary>
        FloatRNv = ((int)0x8880)        ,
        /// <summary>
        /// Original was GL_FLOAT_RG_NV = 0x8881
        /// </summary>
        FloatRgNv = ((int)0x8881)        ,
        /// <summary>
        /// Original was GL_FLOAT_RGB_NV = 0x8882
        /// </summary>
        FloatRgbNv = ((int)0x8882)        ,
        /// <summary>
        /// Original was GL_FLOAT_RGBA_NV = 0x8883
        /// </summary>
        FloatRgbaNv = ((int)0x8883)        ,
        /// <summary>
        /// Original was GL_FLOAT_R16_NV = 0x8884
        /// </summary>
        FloatR16Nv = ((int)0x8884)        ,
        /// <summary>
        /// Original was GL_FLOAT_R32_NV = 0x8885
        /// </summary>
        FloatR32Nv = ((int)0x8885)        ,
        /// <summary>
        /// Original was GL_FLOAT_RG16_NV = 0x8886
        /// </summary>
        FloatRg16Nv = ((int)0x8886)        ,
        /// <summary>
        /// Original was GL_FLOAT_RG32_NV = 0x8887
        /// </summary>
        FloatRg32Nv = ((int)0x8887)        ,
        /// <summary>
        /// Original was GL_FLOAT_RGB16_NV = 0x8888
        /// </summary>
        FloatRgb16Nv = ((int)0x8888)        ,
        /// <summary>
        /// Original was GL_FLOAT_RGB32_NV = 0x8889
        /// </summary>
        FloatRgb32Nv = ((int)0x8889)        ,
        /// <summary>
        /// Original was GL_FLOAT_RGBA16_NV = 0x888A
        /// </summary>
        FloatRgba16Nv = ((int)0x888A)        ,
        /// <summary>
        /// Original was GL_FLOAT_RGBA32_NV = 0x888B
        /// </summary>
        FloatRgba32Nv = ((int)0x888B)        ,
        /// <summary>
        /// Original was GL_TEXTURE_FLOAT_COMPONENTS_NV = 0x888C
        /// </summary>
        TextureFloatComponentsNv = ((int)0x888C)        ,
        /// <summary>
        /// Original was GL_FLOAT_CLEAR_COLOR_VALUE_NV = 0x888D
        /// </summary>
        FloatClearColorValueNv = ((int)0x888D)        ,
        /// <summary>
        /// Original was GL_FLOAT_RGBA_MODE_NV = 0x888E
        /// </summary>
        FloatRgbaModeNv = ((int)0x888E)        ,
        /// <summary>
        /// Original was GL_TEXTURE_UNSIGNED_REMAP_MODE_NV = 0x888F
        /// </summary>
        TextureUnsignedRemapModeNv = ((int)0x888F)        ,
        /// <summary>
        /// Original was GL_DEPTH_BOUNDS_TEST_EXT = 0x8890
        /// </summary>
        DepthBoundsTestExt = ((int)0x8890)        ,
        /// <summary>
        /// Original was GL_DEPTH_BOUNDS_EXT = 0x8891
        /// </summary>
        DepthBoundsExt = ((int)0x8891)        ,
        /// <summary>
        /// Original was GL_ARRAY_BUFFER = 0x8892
        /// </summary>
        ArrayBuffer = ((int)0x8892)        ,
        /// <summary>
        /// Original was GL_ARRAY_BUFFER_ARB = 0x8892
        /// </summary>
        ArrayBufferArb = ((int)0x8892)        ,
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_BUFFER = 0x8893
        /// </summary>
        ElementArrayBuffer = ((int)0x8893)        ,
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_BUFFER_ARB = 0x8893
        /// </summary>
        ElementArrayBufferArb = ((int)0x8893)        ,
        /// <summary>
        /// Original was GL_ARRAY_BUFFER_BINDING = 0x8894
        /// </summary>
        ArrayBufferBinding = ((int)0x8894)        ,
        /// <summary>
        /// Original was GL_ARRAY_BUFFER_BINDING_ARB = 0x8894
        /// </summary>
        ArrayBufferBindingArb = ((int)0x8894)        ,
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_BUFFER_BINDING = 0x8895
        /// </summary>
        ElementArrayBufferBinding = ((int)0x8895)        ,
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB = 0x8895
        /// </summary>
        ElementArrayBufferBindingArb = ((int)0x8895)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_BUFFER_BINDING = 0x8896
        /// </summary>
        VertexArrayBufferBinding = ((int)0x8896)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_BUFFER_BINDING_ARB = 0x8896
        /// </summary>
        VertexArrayBufferBindingArb = ((int)0x8896)        ,
        /// <summary>
        /// Original was GL_NORMAL_ARRAY_BUFFER_BINDING = 0x8897
        /// </summary>
        NormalArrayBufferBinding = ((int)0x8897)        ,
        /// <summary>
        /// Original was GL_NORMAL_ARRAY_BUFFER_BINDING_ARB = 0x8897
        /// </summary>
        NormalArrayBufferBindingArb = ((int)0x8897)        ,
        /// <summary>
        /// Original was GL_COLOR_ARRAY_BUFFER_BINDING = 0x8898
        /// </summary>
        ColorArrayBufferBinding = ((int)0x8898)        ,
        /// <summary>
        /// Original was GL_COLOR_ARRAY_BUFFER_BINDING_ARB = 0x8898
        /// </summary>
        ColorArrayBufferBindingArb = ((int)0x8898)        ,
        /// <summary>
        /// Original was GL_INDEX_ARRAY_BUFFER_BINDING = 0x8899
        /// </summary>
        IndexArrayBufferBinding = ((int)0x8899)        ,
        /// <summary>
        /// Original was GL_INDEX_ARRAY_BUFFER_BINDING_ARB = 0x8899
        /// </summary>
        IndexArrayBufferBindingArb = ((int)0x8899)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING = 0x889A
        /// </summary>
        TextureCoordArrayBufferBinding = ((int)0x889A)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB = 0x889A
        /// </summary>
        TextureCoordArrayBufferBindingArb = ((int)0x889A)        ,
        /// <summary>
        /// Original was GL_EDGE_FLAG_ARRAY_BUFFER_BINDING = 0x889B
        /// </summary>
        EdgeFlagArrayBufferBinding = ((int)0x889B)        ,
        /// <summary>
        /// Original was GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB = 0x889B
        /// </summary>
        EdgeFlagArrayBufferBindingArb = ((int)0x889B)        ,
        /// <summary>
        /// Original was GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING = 0x889C
        /// </summary>
        SecondaryColorArrayBufferBinding = ((int)0x889C)        ,
        /// <summary>
        /// Original was GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB = 0x889C
        /// </summary>
        SecondaryColorArrayBufferBindingArb = ((int)0x889C)        ,
        /// <summary>
        /// Original was GL_FOG_COORD_ARRAY_BUFFER_BINDING = 0x889D
        /// </summary>
        FogCoordArrayBufferBinding = ((int)0x889D)        ,
        /// <summary>
        /// Original was GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING = 0x889D
        /// </summary>
        FogCoordinateArrayBufferBinding = ((int)0x889D)        ,
        /// <summary>
        /// Original was GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB = 0x889D
        /// </summary>
        FogCoordinateArrayBufferBindingArb = ((int)0x889D)        ,
        /// <summary>
        /// Original was GL_WEIGHT_ARRAY_BUFFER_BINDING = 0x889E
        /// </summary>
        WeightArrayBufferBinding = ((int)0x889E)        ,
        /// <summary>
        /// Original was GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB = 0x889E
        /// </summary>
        WeightArrayBufferBindingArb = ((int)0x889E)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 0x889F
        /// </summary>
        VertexAttribArrayBufferBinding = ((int)0x889F)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB = 0x889F
        /// </summary>
        VertexAttribArrayBufferBindingArb = ((int)0x889F)        ,
        /// <summary>
        /// Original was GL_PROGRAM_INSTRUCTION = 0x88A0
        /// </summary>
        ProgramInstruction = ((int)0x88A0)        ,
        /// <summary>
        /// Original was GL_PROGRAM_INSTRUCTIONS_ARB = 0x88A0
        /// </summary>
        ProgramInstructionsArb = ((int)0x88A0)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_INSTRUCTIONS = 0x88A1
        /// </summary>
        MaxProgramInstructions = ((int)0x88A1)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_INSTRUCTIONS_ARB = 0x88A1
        /// </summary>
        MaxProgramInstructionsArb = ((int)0x88A1)        ,
        /// <summary>
        /// Original was GL_PROGRAM_NATIVE_INSTRUCTIONS = 0x88A2
        /// </summary>
        ProgramNativeInstructions = ((int)0x88A2)        ,
        /// <summary>
        /// Original was GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB = 0x88A2
        /// </summary>
        ProgramNativeInstructionsArb = ((int)0x88A2)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS = 0x88A3
        /// </summary>
        MaxProgramNativeInstructions = ((int)0x88A3)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB = 0x88A3
        /// </summary>
        MaxProgramNativeInstructionsArb = ((int)0x88A3)        ,
        /// <summary>
        /// Original was GL_PROGRAM_TEMPORARIES = 0x88A4
        /// </summary>
        ProgramTemporaries = ((int)0x88A4)        ,
        /// <summary>
        /// Original was GL_PROGRAM_TEMPORARIES_ARB = 0x88A4
        /// </summary>
        ProgramTemporariesArb = ((int)0x88A4)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_TEMPORARIES = 0x88A5
        /// </summary>
        MaxProgramTemporaries = ((int)0x88A5)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_TEMPORARIES_ARB = 0x88A5
        /// </summary>
        MaxProgramTemporariesArb = ((int)0x88A5)        ,
        /// <summary>
        /// Original was GL_PROGRAM_NATIVE_TEMPORARIES = 0x88A6
        /// </summary>
        ProgramNativeTemporaries = ((int)0x88A6)        ,
        /// <summary>
        /// Original was GL_PROGRAM_NATIVE_TEMPORARIES_ARB = 0x88A6
        /// </summary>
        ProgramNativeTemporariesArb = ((int)0x88A6)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_NATIVE_TEMPORARIES = 0x88A7
        /// </summary>
        MaxProgramNativeTemporaries = ((int)0x88A7)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB = 0x88A7
        /// </summary>
        MaxProgramNativeTemporariesArb = ((int)0x88A7)        ,
        /// <summary>
        /// Original was GL_PROGRAM_PARAMETERS = 0x88A8
        /// </summary>
        ProgramParameters = ((int)0x88A8)        ,
        /// <summary>
        /// Original was GL_PROGRAM_PARAMETERS_ARB = 0x88A8
        /// </summary>
        ProgramParametersArb = ((int)0x88A8)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_PARAMETERS = 0x88A9
        /// </summary>
        MaxProgramParameters = ((int)0x88A9)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_PARAMETERS_ARB = 0x88A9
        /// </summary>
        MaxProgramParametersArb = ((int)0x88A9)        ,
        /// <summary>
        /// Original was GL_PROGRAM_NATIVE_PARAMETERS = 0x88AA
        /// </summary>
        ProgramNativeParameters = ((int)0x88AA)        ,
        /// <summary>
        /// Original was GL_PROGRAM_NATIVE_PARAMETERS_ARB = 0x88AA
        /// </summary>
        ProgramNativeParametersArb = ((int)0x88AA)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_NATIVE_PARAMETERS = 0x88AB
        /// </summary>
        MaxProgramNativeParameters = ((int)0x88AB)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB = 0x88AB
        /// </summary>
        MaxProgramNativeParametersArb = ((int)0x88AB)        ,
        /// <summary>
        /// Original was GL_PROGRAM_ATTRIBS = 0x88AC
        /// </summary>
        ProgramAttribs = ((int)0x88AC)        ,
        /// <summary>
        /// Original was GL_PROGRAM_ATTRIBS_ARB = 0x88AC
        /// </summary>
        ProgramAttribsArb = ((int)0x88AC)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_ATTRIBS = 0x88AD
        /// </summary>
        MaxProgramAttribs = ((int)0x88AD)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_ATTRIBS_ARB = 0x88AD
        /// </summary>
        MaxProgramAttribsArb = ((int)0x88AD)        ,
        /// <summary>
        /// Original was GL_PROGRAM_NATIVE_ATTRIBS = 0x88AE
        /// </summary>
        ProgramNativeAttribs = ((int)0x88AE)        ,
        /// <summary>
        /// Original was GL_PROGRAM_NATIVE_ATTRIBS_ARB = 0x88AE
        /// </summary>
        ProgramNativeAttribsArb = ((int)0x88AE)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_NATIVE_ATTRIBS = 0x88AF
        /// </summary>
        MaxProgramNativeAttribs = ((int)0x88AF)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB = 0x88AF
        /// </summary>
        MaxProgramNativeAttribsArb = ((int)0x88AF)        ,
        /// <summary>
        /// Original was GL_PROGRAM_ADDRESS_REGISTERS = 0x88B0
        /// </summary>
        ProgramAddressRegisters = ((int)0x88B0)        ,
        /// <summary>
        /// Original was GL_PROGRAM_ADDRESS_REGISTERS_ARB = 0x88B0
        /// </summary>
        ProgramAddressRegistersArb = ((int)0x88B0)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_ADDRESS_REGISTERS = 0x88B1
        /// </summary>
        MaxProgramAddressRegisters = ((int)0x88B1)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB = 0x88B1
        /// </summary>
        MaxProgramAddressRegistersArb = ((int)0x88B1)        ,
        /// <summary>
        /// Original was GL_PROGRAM_NATIVE_ADDRESS_REGISTERS = 0x88B2
        /// </summary>
        ProgramNativeAddressRegisters = ((int)0x88B2)        ,
        /// <summary>
        /// Original was GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = 0x88B2
        /// </summary>
        ProgramNativeAddressRegistersArb = ((int)0x88B2)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS = 0x88B3
        /// </summary>
        MaxProgramNativeAddressRegisters = ((int)0x88B3)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = 0x88B3
        /// </summary>
        MaxProgramNativeAddressRegistersArb = ((int)0x88B3)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_LOCAL_PARAMETERS = 0x88B4
        /// </summary>
        MaxProgramLocalParameters = ((int)0x88B4)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB = 0x88B4
        /// </summary>
        MaxProgramLocalParametersArb = ((int)0x88B4)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_ENV_PARAMETERS = 0x88B5
        /// </summary>
        MaxProgramEnvParameters = ((int)0x88B5)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_ENV_PARAMETERS_ARB = 0x88B5
        /// </summary>
        MaxProgramEnvParametersArb = ((int)0x88B5)        ,
        /// <summary>
        /// Original was GL_PROGRAM_UNDER_NATIVE_LIMITS = 0x88B6
        /// </summary>
        ProgramUnderNativeLimits = ((int)0x88B6)        ,
        /// <summary>
        /// Original was GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB = 0x88B6
        /// </summary>
        ProgramUnderNativeLimitsArb = ((int)0x88B6)        ,
        /// <summary>
        /// Original was GL_TRANSPOSE_CURRENT_MATRIX_ARB = 0x88B7
        /// </summary>
        TransposeCurrentMatrixArb = ((int)0x88B7)        ,
        /// <summary>
        /// Original was GL_READ_ONLY = 0x88B8
        /// </summary>
        ReadOnly = ((int)0x88B8)        ,
        /// <summary>
        /// Original was GL_READ_ONLY_ARB = 0x88B8
        /// </summary>
        ReadOnlyArb = ((int)0x88B8)        ,
        /// <summary>
        /// Original was GL_WRITE_ONLY = 0x88B9
        /// </summary>
        WriteOnly = ((int)0x88B9)        ,
        /// <summary>
        /// Original was GL_WRITE_ONLY_ARB = 0x88B9
        /// </summary>
        WriteOnlyArb = ((int)0x88B9)        ,
        /// <summary>
        /// Original was GL_READ_WRITE = 0x88BA
        /// </summary>
        ReadWrite = ((int)0x88BA)        ,
        /// <summary>
        /// Original was GL_READ_WRITE_ARB = 0x88BA
        /// </summary>
        ReadWriteArb = ((int)0x88BA)        ,
        /// <summary>
        /// Original was GL_BUFFER_ACCESS = 0x88BB
        /// </summary>
        BufferAccess = ((int)0x88BB)        ,
        /// <summary>
        /// Original was GL_BUFFER_ACCESS_ARB = 0x88BB
        /// </summary>
        BufferAccessArb = ((int)0x88BB)        ,
        /// <summary>
        /// Original was GL_BUFFER_MAPPED = 0x88BC
        /// </summary>
        BufferMapped = ((int)0x88BC)        ,
        /// <summary>
        /// Original was GL_BUFFER_MAPPED_ARB = 0x88BC
        /// </summary>
        BufferMappedArb = ((int)0x88BC)        ,
        /// <summary>
        /// Original was GL_BUFFER_MAP_POINTER = 0x88BD
        /// </summary>
        BufferMapPointer = ((int)0x88BD)        ,
        /// <summary>
        /// Original was GL_BUFFER_MAP_POINTER_ARB = 0x88BD
        /// </summary>
        BufferMapPointerArb = ((int)0x88BD)        ,
        /// <summary>
        /// Original was GL_WRITE_DISCARD_NV = 0x88BE
        /// </summary>
        WriteDiscardNv = ((int)0x88BE)        ,
        /// <summary>
        /// Original was GL_TIME_ELAPSED = 0x88BF
        /// </summary>
        TimeElapsed = ((int)0x88BF)        ,
        /// <summary>
        /// Original was GL_TIME_ELAPSED_EXT = 0x88BF
        /// </summary>
        TimeElapsedExt = ((int)0x88BF)        ,
        /// <summary>
        /// Original was GL_MATRIX0 = 0x88C0
        /// </summary>
        Matrix0 = ((int)0x88C0)        ,
        /// <summary>
        /// Original was GL_MATRIX0_ARB = 0x88C0
        /// </summary>
        Matrix0Arb = ((int)0x88C0)        ,
        /// <summary>
        /// Original was GL_MATRIX1 = 0x88C1
        /// </summary>
        Matrix1 = ((int)0x88C1)        ,
        /// <summary>
        /// Original was GL_MATRIX1_ARB = 0x88C1
        /// </summary>
        Matrix1Arb = ((int)0x88C1)        ,
        /// <summary>
        /// Original was GL_MATRIX2 = 0x88C2
        /// </summary>
        Matrix2 = ((int)0x88C2)        ,
        /// <summary>
        /// Original was GL_MATRIX2_ARB = 0x88C2
        /// </summary>
        Matrix2Arb = ((int)0x88C2)        ,
        /// <summary>
        /// Original was GL_MATRIX3 = 0x88C3
        /// </summary>
        Matrix3 = ((int)0x88C3)        ,
        /// <summary>
        /// Original was GL_MATRIX3_ARB = 0x88C3
        /// </summary>
        Matrix3Arb = ((int)0x88C3)        ,
        /// <summary>
        /// Original was GL_MATRIX4 = 0x88C4
        /// </summary>
        Matrix4 = ((int)0x88C4)        ,
        /// <summary>
        /// Original was GL_MATRIX4_ARB = 0x88C4
        /// </summary>
        Matrix4Arb = ((int)0x88C4)        ,
        /// <summary>
        /// Original was GL_MATRIX5 = 0x88C5
        /// </summary>
        Matrix5 = ((int)0x88C5)        ,
        /// <summary>
        /// Original was GL_MATRIX5_ARB = 0x88C5
        /// </summary>
        Matrix5Arb = ((int)0x88C5)        ,
        /// <summary>
        /// Original was GL_MATRIX6 = 0x88C6
        /// </summary>
        Matrix6 = ((int)0x88C6)        ,
        /// <summary>
        /// Original was GL_MATRIX6_ARB = 0x88C6
        /// </summary>
        Matrix6Arb = ((int)0x88C6)        ,
        /// <summary>
        /// Original was GL_MATRIX7 = 0x88C7
        /// </summary>
        Matrix7 = ((int)0x88C7)        ,
        /// <summary>
        /// Original was GL_MATRIX7_ARB = 0x88C7
        /// </summary>
        Matrix7Arb = ((int)0x88C7)        ,
        /// <summary>
        /// Original was GL_MATRIX8 = 0x88C8
        /// </summary>
        Matrix8 = ((int)0x88C8)        ,
        /// <summary>
        /// Original was GL_MATRIX8_ARB = 0x88C8
        /// </summary>
        Matrix8Arb = ((int)0x88C8)        ,
        /// <summary>
        /// Original was GL_MATRIX9 = 0x88C9
        /// </summary>
        Matrix9 = ((int)0x88C9)        ,
        /// <summary>
        /// Original was GL_MATRIX9_ARB = 0x88C9
        /// </summary>
        Matrix9Arb = ((int)0x88C9)        ,
        /// <summary>
        /// Original was GL_MATRIX10 = 0x88CA
        /// </summary>
        Matrix10 = ((int)0x88CA)        ,
        /// <summary>
        /// Original was GL_MATRIX10_ARB = 0x88CA
        /// </summary>
        Matrix10Arb = ((int)0x88CA)        ,
        /// <summary>
        /// Original was GL_MATRIX11 = 0x88CB
        /// </summary>
        Matrix11 = ((int)0x88CB)        ,
        /// <summary>
        /// Original was GL_MATRIX11_ARB = 0x88CB
        /// </summary>
        Matrix11Arb = ((int)0x88CB)        ,
        /// <summary>
        /// Original was GL_MATRIX12 = 0x88CC
        /// </summary>
        Matrix12 = ((int)0x88CC)        ,
        /// <summary>
        /// Original was GL_MATRIX12_ARB = 0x88CC
        /// </summary>
        Matrix12Arb = ((int)0x88CC)        ,
        /// <summary>
        /// Original was GL_MATRIX13 = 0x88CD
        /// </summary>
        Matrix13 = ((int)0x88CD)        ,
        /// <summary>
        /// Original was GL_MATRIX13_ARB = 0x88CD
        /// </summary>
        Matrix13Arb = ((int)0x88CD)        ,
        /// <summary>
        /// Original was GL_MATRIX14 = 0x88CE
        /// </summary>
        Matrix14 = ((int)0x88CE)        ,
        /// <summary>
        /// Original was GL_MATRIX14_ARB = 0x88CE
        /// </summary>
        Matrix14Arb = ((int)0x88CE)        ,
        /// <summary>
        /// Original was GL_MATRIX15 = 0x88CF
        /// </summary>
        Matrix15 = ((int)0x88CF)        ,
        /// <summary>
        /// Original was GL_MATRIX15_ARB = 0x88CF
        /// </summary>
        Matrix15Arb = ((int)0x88CF)        ,
        /// <summary>
        /// Original was GL_MATRIX16 = 0x88D0
        /// </summary>
        Matrix16 = ((int)0x88D0)        ,
        /// <summary>
        /// Original was GL_MATRIX16_ARB = 0x88D0
        /// </summary>
        Matrix16Arb = ((int)0x88D0)        ,
        /// <summary>
        /// Original was GL_MATRIX17 = 0x88D1
        /// </summary>
        Matrix17 = ((int)0x88D1)        ,
        /// <summary>
        /// Original was GL_MATRIX17_ARB = 0x88D1
        /// </summary>
        Matrix17Arb = ((int)0x88D1)        ,
        /// <summary>
        /// Original was GL_MATRIX18 = 0x88D2
        /// </summary>
        Matrix18 = ((int)0x88D2)        ,
        /// <summary>
        /// Original was GL_MATRIX18_ARB = 0x88D2
        /// </summary>
        Matrix18Arb = ((int)0x88D2)        ,
        /// <summary>
        /// Original was GL_MATRIX19 = 0x88D3
        /// </summary>
        Matrix19 = ((int)0x88D3)        ,
        /// <summary>
        /// Original was GL_MATRIX19_ARB = 0x88D3
        /// </summary>
        Matrix19Arb = ((int)0x88D3)        ,
        /// <summary>
        /// Original was GL_MATRIX20 = 0x88D4
        /// </summary>
        Matrix20 = ((int)0x88D4)        ,
        /// <summary>
        /// Original was GL_MATRIX20_ARB = 0x88D4
        /// </summary>
        Matrix20Arb = ((int)0x88D4)        ,
        /// <summary>
        /// Original was GL_MATRIX21 = 0x88D5
        /// </summary>
        Matrix21 = ((int)0x88D5)        ,
        /// <summary>
        /// Original was GL_MATRIX21_ARB = 0x88D5
        /// </summary>
        Matrix21Arb = ((int)0x88D5)        ,
        /// <summary>
        /// Original was GL_MATRIX22 = 0x88D6
        /// </summary>
        Matrix22 = ((int)0x88D6)        ,
        /// <summary>
        /// Original was GL_MATRIX22_ARB = 0x88D6
        /// </summary>
        Matrix22Arb = ((int)0x88D6)        ,
        /// <summary>
        /// Original was GL_MATRIX23 = 0x88D7
        /// </summary>
        Matrix23 = ((int)0x88D7)        ,
        /// <summary>
        /// Original was GL_MATRIX23_ARB = 0x88D7
        /// </summary>
        Matrix23Arb = ((int)0x88D7)        ,
        /// <summary>
        /// Original was GL_MATRIX24 = 0x88D8
        /// </summary>
        Matrix24 = ((int)0x88D8)        ,
        /// <summary>
        /// Original was GL_MATRIX24_ARB = 0x88D8
        /// </summary>
        Matrix24Arb = ((int)0x88D8)        ,
        /// <summary>
        /// Original was GL_MATRIX25 = 0x88D9
        /// </summary>
        Matrix25 = ((int)0x88D9)        ,
        /// <summary>
        /// Original was GL_MATRIX25_ARB = 0x88D9
        /// </summary>
        Matrix25Arb = ((int)0x88D9)        ,
        /// <summary>
        /// Original was GL_MATRIX26 = 0x88DA
        /// </summary>
        Matrix26 = ((int)0x88DA)        ,
        /// <summary>
        /// Original was GL_MATRIX26_ARB = 0x88DA
        /// </summary>
        Matrix26Arb = ((int)0x88DA)        ,
        /// <summary>
        /// Original was GL_MATRIX27 = 0x88DB
        /// </summary>
        Matrix27 = ((int)0x88DB)        ,
        /// <summary>
        /// Original was GL_MATRIX27_ARB = 0x88DB
        /// </summary>
        Matrix27Arb = ((int)0x88DB)        ,
        /// <summary>
        /// Original was GL_MATRIX28 = 0x88DC
        /// </summary>
        Matrix28 = ((int)0x88DC)        ,
        /// <summary>
        /// Original was GL_MATRIX28_ARB = 0x88DC
        /// </summary>
        Matrix28Arb = ((int)0x88DC)        ,
        /// <summary>
        /// Original was GL_MATRIX29 = 0x88DD
        /// </summary>
        Matrix29 = ((int)0x88DD)        ,
        /// <summary>
        /// Original was GL_MATRIX29_ARB = 0x88DD
        /// </summary>
        Matrix29Arb = ((int)0x88DD)        ,
        /// <summary>
        /// Original was GL_MATRIX30 = 0x88DE
        /// </summary>
        Matrix30 = ((int)0x88DE)        ,
        /// <summary>
        /// Original was GL_MATRIX30_ARB = 0x88DE
        /// </summary>
        Matrix30Arb = ((int)0x88DE)        ,
        /// <summary>
        /// Original was GL_MATRIX31 = 0x88DF
        /// </summary>
        Matrix31 = ((int)0x88DF)        ,
        /// <summary>
        /// Original was GL_MATRIX31_ARB = 0x88DF
        /// </summary>
        Matrix31Arb = ((int)0x88DF)        ,
        /// <summary>
        /// Original was GL_STREAM_DRAW = 0x88E0
        /// </summary>
        StreamDraw = ((int)0x88E0)        ,
        /// <summary>
        /// Original was GL_STREAM_DRAW_ARB = 0x88E0
        /// </summary>
        StreamDrawArb = ((int)0x88E0)        ,
        /// <summary>
        /// Original was GL_STREAM_READ = 0x88E1
        /// </summary>
        StreamRead = ((int)0x88E1)        ,
        /// <summary>
        /// Original was GL_STREAM_READ_ARB = 0x88E1
        /// </summary>
        StreamReadArb = ((int)0x88E1)        ,
        /// <summary>
        /// Original was GL_STREAM_COPY = 0x88E2
        /// </summary>
        StreamCopy = ((int)0x88E2)        ,
        /// <summary>
        /// Original was GL_STREAM_COPY_ARB = 0x88E2
        /// </summary>
        StreamCopyArb = ((int)0x88E2)        ,
        /// <summary>
        /// Original was GL_STATIC_DRAW = 0x88E4
        /// </summary>
        StaticDraw = ((int)0x88E4)        ,
        /// <summary>
        /// Original was GL_STATIC_DRAW_ARB = 0x88E4
        /// </summary>
        StaticDrawArb = ((int)0x88E4)        ,
        /// <summary>
        /// Original was GL_STATIC_READ = 0x88E5
        /// </summary>
        StaticRead = ((int)0x88E5)        ,
        /// <summary>
        /// Original was GL_STATIC_READ_ARB = 0x88E5
        /// </summary>
        StaticReadArb = ((int)0x88E5)        ,
        /// <summary>
        /// Original was GL_STATIC_COPY = 0x88E6
        /// </summary>
        StaticCopy = ((int)0x88E6)        ,
        /// <summary>
        /// Original was GL_STATIC_COPY_ARB = 0x88E6
        /// </summary>
        StaticCopyArb = ((int)0x88E6)        ,
        /// <summary>
        /// Original was GL_DYNAMIC_DRAW = 0x88E8
        /// </summary>
        DynamicDraw = ((int)0x88E8)        ,
        /// <summary>
        /// Original was GL_DYNAMIC_DRAW_ARB = 0x88E8
        /// </summary>
        DynamicDrawArb = ((int)0x88E8)        ,
        /// <summary>
        /// Original was GL_DYNAMIC_READ = 0x88E9
        /// </summary>
        DynamicRead = ((int)0x88E9)        ,
        /// <summary>
        /// Original was GL_DYNAMIC_READ_ARB = 0x88E9
        /// </summary>
        DynamicReadArb = ((int)0x88E9)        ,
        /// <summary>
        /// Original was GL_DYNAMIC_COPY = 0x88EA
        /// </summary>
        DynamicCopy = ((int)0x88EA)        ,
        /// <summary>
        /// Original was GL_DYNAMIC_COPY_ARB = 0x88EA
        /// </summary>
        DynamicCopyArb = ((int)0x88EA)        ,
        /// <summary>
        /// Original was GL_PIXEL_PACK_BUFFER = 0x88EB
        /// </summary>
        PixelPackBuffer = ((int)0x88EB)        ,
        /// <summary>
        /// Original was GL_PIXEL_PACK_BUFFER_ARB = 0x88EB
        /// </summary>
        PixelPackBufferArb = ((int)0x88EB)        ,
        /// <summary>
        /// Original was GL_PIXEL_PACK_BUFFER_EXT = 0x88EB
        /// </summary>
        PixelPackBufferExt = ((int)0x88EB)        ,
        /// <summary>
        /// Original was GL_PIXEL_UNPACK_BUFFER = 0x88EC
        /// </summary>
        PixelUnpackBuffer = ((int)0x88EC)        ,
        /// <summary>
        /// Original was GL_PIXEL_UNPACK_BUFFER_ARB = 0x88EC
        /// </summary>
        PixelUnpackBufferArb = ((int)0x88EC)        ,
        /// <summary>
        /// Original was GL_PIXEL_UNPACK_BUFFER_EXT = 0x88EC
        /// </summary>
        PixelUnpackBufferExt = ((int)0x88EC)        ,
        /// <summary>
        /// Original was GL_PIXEL_PACK_BUFFER_BINDING = 0x88ED
        /// </summary>
        PixelPackBufferBinding = ((int)0x88ED)        ,
        /// <summary>
        /// Original was GL_PIXEL_PACK_BUFFER_BINDING_ARB = 0x88ED
        /// </summary>
        PixelPackBufferBindingArb = ((int)0x88ED)        ,
        /// <summary>
        /// Original was GL_PIXEL_PACK_BUFFER_BINDING_EXT = 0x88ED
        /// </summary>
        PixelPackBufferBindingExt = ((int)0x88ED)        ,
        /// <summary>
        /// Original was GL_PIXEL_UNPACK_BUFFER_BINDING = 0x88EF
        /// </summary>
        PixelUnpackBufferBinding = ((int)0x88EF)        ,
        /// <summary>
        /// Original was GL_PIXEL_UNPACK_BUFFER_BINDING_ARB = 0x88EF
        /// </summary>
        PixelUnpackBufferBindingArb = ((int)0x88EF)        ,
        /// <summary>
        /// Original was GL_PIXEL_UNPACK_BUFFER_BINDING_EXT = 0x88EF
        /// </summary>
        PixelUnpackBufferBindingExt = ((int)0x88EF)        ,
        /// <summary>
        /// Original was GL_DEPTH24_STENCIL8 = 0x88F0
        /// </summary>
        Depth24Stencil8 = ((int)0x88F0)        ,
        /// <summary>
        /// Original was GL_DEPTH24_STENCIL8_EXT = 0x88F0
        /// </summary>
        Depth24Stencil8Ext = ((int)0x88F0)        ,
        /// <summary>
        /// Original was GL_TEXTURE_STENCIL_SIZE = 0x88F1
        /// </summary>
        TextureStencilSize = ((int)0x88F1)        ,
        /// <summary>
        /// Original was GL_TEXTURE_STENCIL_SIZE_EXT = 0x88F1
        /// </summary>
        TextureStencilSizeExt = ((int)0x88F1)        ,
        /// <summary>
        /// Original was GL_STENCIL_TAG_BITS_EXT = 0x88F2
        /// </summary>
        StencilTagBitsExt = ((int)0x88F2)        ,
        /// <summary>
        /// Original was GL_STENCIL_CLEAR_TAG_VALUE_EXT = 0x88F3
        /// </summary>
        StencilClearTagValueExt = ((int)0x88F3)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV = 0x88F4
        /// </summary>
        MaxProgramExecInstructionsNv = ((int)0x88F4)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_CALL_DEPTH_NV = 0x88F5
        /// </summary>
        MaxProgramCallDepthNv = ((int)0x88F5)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_IF_DEPTH_NV = 0x88F6
        /// </summary>
        MaxProgramIfDepthNv = ((int)0x88F6)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_LOOP_DEPTH_NV = 0x88F7
        /// </summary>
        MaxProgramLoopDepthNv = ((int)0x88F7)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_LOOP_COUNT_NV = 0x88F8
        /// </summary>
        MaxProgramLoopCountNv = ((int)0x88F8)        ,
        /// <summary>
        /// Original was GL_SRC1_COLOR = 0x88F9
        /// </summary>
        Src1Color = ((int)0x88F9)        ,
        /// <summary>
        /// Original was GL_ONE_MINUS_SRC1_COLOR = 0x88FA
        /// </summary>
        OneMinusSrc1Color = ((int)0x88FA)        ,
        /// <summary>
        /// Original was GL_ONE_MINUS_SRC1_ALPHA = 0x88FB
        /// </summary>
        OneMinusSrc1Alpha = ((int)0x88FB)        ,
        /// <summary>
        /// Original was GL_MAX_DUAL_SOURCE_DRAW_BUFFERS = 0x88FC
        /// </summary>
        MaxDualSourceDrawBuffers = ((int)0x88FC)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_INTEGER = 0x88FD
        /// </summary>
        VertexAttribArrayInteger = ((int)0x88FD)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_INTEGER_EXT = 0x88FD
        /// </summary>
        VertexAttribArrayIntegerExt = ((int)0x88FD)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_INTEGER_NV = 0x88FD
        /// </summary>
        VertexAttribArrayIntegerNv = ((int)0x88FD)        ,
        /// <summary>
        /// Original was GL_ARRAY_DIVISOR = 0x88FE
        /// </summary>
        ArrayDivisor = ((int)0x88FE)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_DIVISOR = 0x88FE
        /// </summary>
        VertexAttribArrayDivisor = ((int)0x88FE)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB = 0x88FE
        /// </summary>
        VertexAttribArrayDivisorArb = ((int)0x88FE)        ,
        /// <summary>
        /// Original was GL_MAX_ARRAY_TEXTURE_LAYERS = 0x88FF
        /// </summary>
        MaxArrayTextureLayers = ((int)0x88FF)        ,
        /// <summary>
        /// Original was GL_MAX_ARRAY_TEXTURE_LAYERS_EXT = 0x88FF
        /// </summary>
        MaxArrayTextureLayersExt = ((int)0x88FF)        ,
        /// <summary>
        /// Original was GL_MIN_PROGRAM_TEXEL_OFFSET = 0x8904
        /// </summary>
        MinProgramTexelOffset = ((int)0x8904)        ,
        /// <summary>
        /// Original was GL_MIN_PROGRAM_TEXEL_OFFSET_EXT = 0x8904
        /// </summary>
        MinProgramTexelOffsetExt = ((int)0x8904)        ,
        /// <summary>
        /// Original was GL_MIN_PROGRAM_TEXEL_OFFSET_NV = 0x8904
        /// </summary>
        MinProgramTexelOffsetNv = ((int)0x8904)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_TEXEL_OFFSET = 0x8905
        /// </summary>
        MaxProgramTexelOffset = ((int)0x8905)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_TEXEL_OFFSET_EXT = 0x8905
        /// </summary>
        MaxProgramTexelOffsetExt = ((int)0x8905)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_TEXEL_OFFSET_NV = 0x8905
        /// </summary>
        MaxProgramTexelOffsetNv = ((int)0x8905)        ,
        /// <summary>
        /// Original was GL_PROGRAM_ATTRIB_COMPONENTS_NV = 0x8906
        /// </summary>
        ProgramAttribComponentsNv = ((int)0x8906)        ,
        /// <summary>
        /// Original was GL_PROGRAM_RESULT_COMPONENTS_NV = 0x8907
        /// </summary>
        ProgramResultComponentsNv = ((int)0x8907)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV = 0x8908
        /// </summary>
        MaxProgramAttribComponentsNv = ((int)0x8908)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_RESULT_COMPONENTS_NV = 0x8909
        /// </summary>
        MaxProgramResultComponentsNv = ((int)0x8909)        ,
        /// <summary>
        /// Original was GL_STENCIL_TEST_TWO_SIDE_EXT = 0x8910
        /// </summary>
        StencilTestTwoSideExt = ((int)0x8910)        ,
        /// <summary>
        /// Original was GL_ACTIVE_STENCIL_FACE_EXT = 0x8911
        /// </summary>
        ActiveStencilFaceExt = ((int)0x8911)        ,
        /// <summary>
        /// Original was GL_MIRROR_CLAMP_TO_BORDER_EXT = 0x8912
        /// </summary>
        MirrorClampToBorderExt = ((int)0x8912)        ,
        /// <summary>
        /// Original was GL_SAMPLES_PASSED = 0x8914
        /// </summary>
        SamplesPassed = ((int)0x8914)        ,
        /// <summary>
        /// Original was GL_SAMPLES_PASSED_ARB = 0x8914
        /// </summary>
        SamplesPassedArb = ((int)0x8914)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_VERTICES_OUT = 0x8916
        /// </summary>
        GeometryVerticesOut = ((int)0x8916)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_INPUT_TYPE = 0x8917
        /// </summary>
        GeometryInputType = ((int)0x8917)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_OUTPUT_TYPE = 0x8918
        /// </summary>
        GeometryOutputType = ((int)0x8918)        ,
        /// <summary>
        /// Original was GL_SAMPLER_BINDING = 0x8919
        /// </summary>
        SamplerBinding = ((int)0x8919)        ,
        /// <summary>
        /// Original was GL_CLAMP_VERTEX_COLOR = 0x891A
        /// </summary>
        ClampVertexColor = ((int)0x891A)        ,
        /// <summary>
        /// Original was GL_CLAMP_VERTEX_COLOR_ARB = 0x891A
        /// </summary>
        ClampVertexColorArb = ((int)0x891A)        ,
        /// <summary>
        /// Original was GL_CLAMP_FRAGMENT_COLOR = 0x891B
        /// </summary>
        ClampFragmentColor = ((int)0x891B)        ,
        /// <summary>
        /// Original was GL_CLAMP_FRAGMENT_COLOR_ARB = 0x891B
        /// </summary>
        ClampFragmentColorArb = ((int)0x891B)        ,
        /// <summary>
        /// Original was GL_CLAMP_READ_COLOR = 0x891C
        /// </summary>
        ClampReadColor = ((int)0x891C)        ,
        /// <summary>
        /// Original was GL_CLAMP_READ_COLOR_ARB = 0x891C
        /// </summary>
        ClampReadColorArb = ((int)0x891C)        ,
        /// <summary>
        /// Original was GL_FIXED_ONLY = 0x891D
        /// </summary>
        FixedOnly = ((int)0x891D)        ,
        /// <summary>
        /// Original was GL_FIXED_ONLY_ARB = 0x891D
        /// </summary>
        FixedOnlyArb = ((int)0x891D)        ,
        /// <summary>
        /// Original was GL_TESS_CONTROL_PROGRAM_NV = 0x891E
        /// </summary>
        TessControlProgramNv = ((int)0x891E)        ,
        /// <summary>
        /// Original was GL_TESS_EVALUATION_PROGRAM_NV = 0x891F
        /// </summary>
        TessEvaluationProgramNv = ((int)0x891F)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_SHADER_ATI = 0x8920
        /// </summary>
        FragmentShaderAti = ((int)0x8920)        ,
        /// <summary>
        /// Original was GL_REG_0_ATI = 0x8921
        /// </summary>
        Reg0Ati = ((int)0x8921)        ,
        /// <summary>
        /// Original was GL_REG_1_ATI = 0x8922
        /// </summary>
        Reg1Ati = ((int)0x8922)        ,
        /// <summary>
        /// Original was GL_REG_2_ATI = 0x8923
        /// </summary>
        Reg2Ati = ((int)0x8923)        ,
        /// <summary>
        /// Original was GL_REG_3_ATI = 0x8924
        /// </summary>
        Reg3Ati = ((int)0x8924)        ,
        /// <summary>
        /// Original was GL_REG_4_ATI = 0x8925
        /// </summary>
        Reg4Ati = ((int)0x8925)        ,
        /// <summary>
        /// Original was GL_REG_5_ATI = 0x8926
        /// </summary>
        Reg5Ati = ((int)0x8926)        ,
        /// <summary>
        /// Original was GL_REG_6_ATI = 0x8927
        /// </summary>
        Reg6Ati = ((int)0x8927)        ,
        /// <summary>
        /// Original was GL_REG_7_ATI = 0x8928
        /// </summary>
        Reg7Ati = ((int)0x8928)        ,
        /// <summary>
        /// Original was GL_REG_8_ATI = 0x8929
        /// </summary>
        Reg8Ati = ((int)0x8929)        ,
        /// <summary>
        /// Original was GL_REG_9_ATI = 0x892A
        /// </summary>
        Reg9Ati = ((int)0x892A)        ,
        /// <summary>
        /// Original was GL_REG_10_ATI = 0x892B
        /// </summary>
        Reg10Ati = ((int)0x892B)        ,
        /// <summary>
        /// Original was GL_REG_11_ATI = 0x892C
        /// </summary>
        Reg11Ati = ((int)0x892C)        ,
        /// <summary>
        /// Original was GL_REG_12_ATI = 0x892D
        /// </summary>
        Reg12Ati = ((int)0x892D)        ,
        /// <summary>
        /// Original was GL_REG_13_ATI = 0x892E
        /// </summary>
        Reg13Ati = ((int)0x892E)        ,
        /// <summary>
        /// Original was GL_REG_14_ATI = 0x892F
        /// </summary>
        Reg14Ati = ((int)0x892F)        ,
        /// <summary>
        /// Original was GL_REG_15_ATI = 0x8930
        /// </summary>
        Reg15Ati = ((int)0x8930)        ,
        /// <summary>
        /// Original was GL_REG_16_ATI = 0x8931
        /// </summary>
        Reg16Ati = ((int)0x8931)        ,
        /// <summary>
        /// Original was GL_REG_17_ATI = 0x8932
        /// </summary>
        Reg17Ati = ((int)0x8932)        ,
        /// <summary>
        /// Original was GL_REG_18_ATI = 0x8933
        /// </summary>
        Reg18Ati = ((int)0x8933)        ,
        /// <summary>
        /// Original was GL_REG_19_ATI = 0x8934
        /// </summary>
        Reg19Ati = ((int)0x8934)        ,
        /// <summary>
        /// Original was GL_REG_20_ATI = 0x8935
        /// </summary>
        Reg20Ati = ((int)0x8935)        ,
        /// <summary>
        /// Original was GL_REG_21_ATI = 0x8936
        /// </summary>
        Reg21Ati = ((int)0x8936)        ,
        /// <summary>
        /// Original was GL_REG_22_ATI = 0x8937
        /// </summary>
        Reg22Ati = ((int)0x8937)        ,
        /// <summary>
        /// Original was GL_REG_23_ATI = 0x8938
        /// </summary>
        Reg23Ati = ((int)0x8938)        ,
        /// <summary>
        /// Original was GL_REG_24_ATI = 0x8939
        /// </summary>
        Reg24Ati = ((int)0x8939)        ,
        /// <summary>
        /// Original was GL_REG_25_ATI = 0x893A
        /// </summary>
        Reg25Ati = ((int)0x893A)        ,
        /// <summary>
        /// Original was GL_REG_26_ATI = 0x893B
        /// </summary>
        Reg26Ati = ((int)0x893B)        ,
        /// <summary>
        /// Original was GL_REG_27_ATI = 0x893C
        /// </summary>
        Reg27Ati = ((int)0x893C)        ,
        /// <summary>
        /// Original was GL_REG_28_ATI = 0x893D
        /// </summary>
        Reg28Ati = ((int)0x893D)        ,
        /// <summary>
        /// Original was GL_REG_29_ATI = 0x893E
        /// </summary>
        Reg29Ati = ((int)0x893E)        ,
        /// <summary>
        /// Original was GL_REG_30_ATI = 0x893F
        /// </summary>
        Reg30Ati = ((int)0x893F)        ,
        /// <summary>
        /// Original was GL_REG_31_ATI = 0x8940
        /// </summary>
        Reg31Ati = ((int)0x8940)        ,
        /// <summary>
        /// Original was GL_CON_0_ATI = 0x8941
        /// </summary>
        Con0Ati = ((int)0x8941)        ,
        /// <summary>
        /// Original was GL_CON_1_ATI = 0x8942
        /// </summary>
        Con1Ati = ((int)0x8942)        ,
        /// <summary>
        /// Original was GL_CON_2_ATI = 0x8943
        /// </summary>
        Con2Ati = ((int)0x8943)        ,
        /// <summary>
        /// Original was GL_CON_3_ATI = 0x8944
        /// </summary>
        Con3Ati = ((int)0x8944)        ,
        /// <summary>
        /// Original was GL_CON_4_ATI = 0x8945
        /// </summary>
        Con4Ati = ((int)0x8945)        ,
        /// <summary>
        /// Original was GL_CON_5_ATI = 0x8946
        /// </summary>
        Con5Ati = ((int)0x8946)        ,
        /// <summary>
        /// Original was GL_CON_6_ATI = 0x8947
        /// </summary>
        Con6Ati = ((int)0x8947)        ,
        /// <summary>
        /// Original was GL_CON_7_ATI = 0x8948
        /// </summary>
        Con7Ati = ((int)0x8948)        ,
        /// <summary>
        /// Original was GL_CON_8_ATI = 0x8949
        /// </summary>
        Con8Ati = ((int)0x8949)        ,
        /// <summary>
        /// Original was GL_CON_9_ATI = 0x894A
        /// </summary>
        Con9Ati = ((int)0x894A)        ,
        /// <summary>
        /// Original was GL_CON_10_ATI = 0x894B
        /// </summary>
        Con10Ati = ((int)0x894B)        ,
        /// <summary>
        /// Original was GL_CON_11_ATI = 0x894C
        /// </summary>
        Con11Ati = ((int)0x894C)        ,
        /// <summary>
        /// Original was GL_CON_12_ATI = 0x894D
        /// </summary>
        Con12Ati = ((int)0x894D)        ,
        /// <summary>
        /// Original was GL_CON_13_ATI = 0x894E
        /// </summary>
        Con13Ati = ((int)0x894E)        ,
        /// <summary>
        /// Original was GL_CON_14_ATI = 0x894F
        /// </summary>
        Con14Ati = ((int)0x894F)        ,
        /// <summary>
        /// Original was GL_CON_15_ATI = 0x8950
        /// </summary>
        Con15Ati = ((int)0x8950)        ,
        /// <summary>
        /// Original was GL_CON_16_ATI = 0x8951
        /// </summary>
        Con16Ati = ((int)0x8951)        ,
        /// <summary>
        /// Original was GL_CON_17_ATI = 0x8952
        /// </summary>
        Con17Ati = ((int)0x8952)        ,
        /// <summary>
        /// Original was GL_CON_18_ATI = 0x8953
        /// </summary>
        Con18Ati = ((int)0x8953)        ,
        /// <summary>
        /// Original was GL_CON_19_ATI = 0x8954
        /// </summary>
        Con19Ati = ((int)0x8954)        ,
        /// <summary>
        /// Original was GL_CON_20_ATI = 0x8955
        /// </summary>
        Con20Ati = ((int)0x8955)        ,
        /// <summary>
        /// Original was GL_CON_21_ATI = 0x8956
        /// </summary>
        Con21Ati = ((int)0x8956)        ,
        /// <summary>
        /// Original was GL_CON_22_ATI = 0x8957
        /// </summary>
        Con22Ati = ((int)0x8957)        ,
        /// <summary>
        /// Original was GL_CON_23_ATI = 0x8958
        /// </summary>
        Con23Ati = ((int)0x8958)        ,
        /// <summary>
        /// Original was GL_CON_24_ATI = 0x8959
        /// </summary>
        Con24Ati = ((int)0x8959)        ,
        /// <summary>
        /// Original was GL_CON_25_ATI = 0x895A
        /// </summary>
        Con25Ati = ((int)0x895A)        ,
        /// <summary>
        /// Original was GL_CON_26_ATI = 0x895B
        /// </summary>
        Con26Ati = ((int)0x895B)        ,
        /// <summary>
        /// Original was GL_CON_27_ATI = 0x895C
        /// </summary>
        Con27Ati = ((int)0x895C)        ,
        /// <summary>
        /// Original was GL_CON_28_ATI = 0x895D
        /// </summary>
        Con28Ati = ((int)0x895D)        ,
        /// <summary>
        /// Original was GL_CON_29_ATI = 0x895E
        /// </summary>
        Con29Ati = ((int)0x895E)        ,
        /// <summary>
        /// Original was GL_CON_30_ATI = 0x895F
        /// </summary>
        Con30Ati = ((int)0x895F)        ,
        /// <summary>
        /// Original was GL_CON_31_ATI = 0x8960
        /// </summary>
        Con31Ati = ((int)0x8960)        ,
        /// <summary>
        /// Original was GL_MOV_ATI = 0x8961
        /// </summary>
        MovAti = ((int)0x8961)        ,
        /// <summary>
        /// Original was GL_ADD_ATI = 0x8963
        /// </summary>
        AddAti = ((int)0x8963)        ,
        /// <summary>
        /// Original was GL_MUL_ATI = 0x8964
        /// </summary>
        MulAti = ((int)0x8964)        ,
        /// <summary>
        /// Original was GL_SUB_ATI = 0x8965
        /// </summary>
        SubAti = ((int)0x8965)        ,
        /// <summary>
        /// Original was GL_DOT3_ATI = 0x8966
        /// </summary>
        Dot3Ati = ((int)0x8966)        ,
        /// <summary>
        /// Original was GL_DOT4_ATI = 0x8967
        /// </summary>
        Dot4Ati = ((int)0x8967)        ,
        /// <summary>
        /// Original was GL_MAD_ATI = 0x8968
        /// </summary>
        MadAti = ((int)0x8968)        ,
        /// <summary>
        /// Original was GL_LERP_ATI = 0x8969
        /// </summary>
        LerpAti = ((int)0x8969)        ,
        /// <summary>
        /// Original was GL_CND_ATI = 0x896A
        /// </summary>
        CndAti = ((int)0x896A)        ,
        /// <summary>
        /// Original was GL_CND0_ATI = 0x896B
        /// </summary>
        Cnd0Ati = ((int)0x896B)        ,
        /// <summary>
        /// Original was GL_DOT2_ADD_ATI = 0x896C
        /// </summary>
        Dot2AddAti = ((int)0x896C)        ,
        /// <summary>
        /// Original was GL_SECONDARY_INTERPOLATOR_ATI = 0x896D
        /// </summary>
        SecondaryInterpolatorAti = ((int)0x896D)        ,
        /// <summary>
        /// Original was GL_NUM_FRAGMENT_REGISTERS_ATI = 0x896E
        /// </summary>
        NumFragmentRegistersAti = ((int)0x896E)        ,
        /// <summary>
        /// Original was GL_NUM_FRAGMENT_CONSTANTS_ATI = 0x896F
        /// </summary>
        NumFragmentConstantsAti = ((int)0x896F)        ,
        /// <summary>
        /// Original was GL_NUM_PASSES_ATI = 0x8970
        /// </summary>
        NumPassesAti = ((int)0x8970)        ,
        /// <summary>
        /// Original was GL_NUM_INSTRUCTIONS_PER_PASS_ATI = 0x8971
        /// </summary>
        NumInstructionsPerPassAti = ((int)0x8971)        ,
        /// <summary>
        /// Original was GL_NUM_INSTRUCTIONS_TOTAL_ATI = 0x8972
        /// </summary>
        NumInstructionsTotalAti = ((int)0x8972)        ,
        /// <summary>
        /// Original was GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI = 0x8973
        /// </summary>
        NumInputInterpolatorComponentsAti = ((int)0x8973)        ,
        /// <summary>
        /// Original was GL_NUM_LOOPBACK_COMPONENTS_ATI = 0x8974
        /// </summary>
        NumLoopbackComponentsAti = ((int)0x8974)        ,
        /// <summary>
        /// Original was GL_COLOR_ALPHA_PAIRING_ATI = 0x8975
        /// </summary>
        ColorAlphaPairingAti = ((int)0x8975)        ,
        /// <summary>
        /// Original was GL_SWIZZLE_STR_ATI = 0x8976
        /// </summary>
        SwizzleStrAti = ((int)0x8976)        ,
        /// <summary>
        /// Original was GL_SWIZZLE_STQ_ATI = 0x8977
        /// </summary>
        SwizzleStqAti = ((int)0x8977)        ,
        /// <summary>
        /// Original was GL_SWIZZLE_STR_DR_ATI = 0x8978
        /// </summary>
        SwizzleStrDrAti = ((int)0x8978)        ,
        /// <summary>
        /// Original was GL_SWIZZLE_STQ_DQ_ATI = 0x8979
        /// </summary>
        SwizzleStqDqAti = ((int)0x8979)        ,
        /// <summary>
        /// Original was GL_SWIZZLE_STRQ_ATI = 0x897A
        /// </summary>
        SwizzleStrqAti = ((int)0x897A)        ,
        /// <summary>
        /// Original was GL_SWIZZLE_STRQ_DQ_ATI = 0x897B
        /// </summary>
        SwizzleStrqDqAti = ((int)0x897B)        ,
        /// <summary>
        /// Original was GL_INTERLACE_OML = 0x8980
        /// </summary>
        InterlaceOml = ((int)0x8980)        ,
        /// <summary>
        /// Original was GL_INTERLACE_READ_OML = 0x8981
        /// </summary>
        InterlaceReadOml = ((int)0x8981)        ,
        /// <summary>
        /// Original was GL_FORMAT_SUBSAMPLE_24_24_OML = 0x8982
        /// </summary>
        FormatSubsample2424Oml = ((int)0x8982)        ,
        /// <summary>
        /// Original was GL_FORMAT_SUBSAMPLE_244_244_OML = 0x8983
        /// </summary>
        FormatSubsample244244Oml = ((int)0x8983)        ,
        /// <summary>
        /// Original was GL_PACK_RESAMPLE_OML = 0x8984
        /// </summary>
        PackResampleOml = ((int)0x8984)        ,
        /// <summary>
        /// Original was GL_UNPACK_RESAMPLE_OML = 0x8985
        /// </summary>
        UnpackResampleOml = ((int)0x8985)        ,
        /// <summary>
        /// Original was GL_RESAMPLE_REPLICATE_OML = 0x8986
        /// </summary>
        ResampleReplicateOml = ((int)0x8986)        ,
        /// <summary>
        /// Original was GL_RESAMPLE_ZERO_FILL_OML = 0x8987
        /// </summary>
        ResampleZeroFillOml = ((int)0x8987)        ,
        /// <summary>
        /// Original was GL_RESAMPLE_AVERAGE_OML = 0x8988
        /// </summary>
        ResampleAverageOml = ((int)0x8988)        ,
        /// <summary>
        /// Original was GL_RESAMPLE_DECIMATE_OML = 0x8989
        /// </summary>
        ResampleDecimateOml = ((int)0x8989)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_MAP1_APPLE = 0x8A00
        /// </summary>
        VertexAttribMap1Apple = ((int)0x8A00)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_MAP2_APPLE = 0x8A01
        /// </summary>
        VertexAttribMap2Apple = ((int)0x8A01)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_MAP1_SIZE_APPLE = 0x8A02
        /// </summary>
        VertexAttribMap1SizeApple = ((int)0x8A02)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_MAP1_COEFF_APPLE = 0x8A03
        /// </summary>
        VertexAttribMap1CoeffApple = ((int)0x8A03)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_MAP1_ORDER_APPLE = 0x8A04
        /// </summary>
        VertexAttribMap1OrderApple = ((int)0x8A04)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE = 0x8A05
        /// </summary>
        VertexAttribMap1DomainApple = ((int)0x8A05)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_MAP2_SIZE_APPLE = 0x8A06
        /// </summary>
        VertexAttribMap2SizeApple = ((int)0x8A06)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_MAP2_COEFF_APPLE = 0x8A07
        /// </summary>
        VertexAttribMap2CoeffApple = ((int)0x8A07)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_MAP2_ORDER_APPLE = 0x8A08
        /// </summary>
        VertexAttribMap2OrderApple = ((int)0x8A08)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE = 0x8A09
        /// </summary>
        VertexAttribMap2DomainApple = ((int)0x8A09)        ,
        /// <summary>
        /// Original was GL_DRAW_PIXELS_APPLE = 0x8A0A
        /// </summary>
        DrawPixelsApple = ((int)0x8A0A)        ,
        /// <summary>
        /// Original was GL_FENCE_APPLE = 0x8A0B
        /// </summary>
        FenceApple = ((int)0x8A0B)        ,
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_APPLE = 0x8A0C
        /// </summary>
        ElementArrayApple = ((int)0x8A0C)        ,
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_TYPE_APPLE = 0x8A0D
        /// </summary>
        ElementArrayTypeApple = ((int)0x8A0D)        ,
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_POINTER_APPLE = 0x8A0E
        /// </summary>
        ElementArrayPointerApple = ((int)0x8A0E)        ,
        /// <summary>
        /// Original was GL_COLOR_FLOAT_APPLE = 0x8A0F
        /// </summary>
        ColorFloatApple = ((int)0x8A0F)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BUFFER = 0x8A11
        /// </summary>
        UniformBuffer = ((int)0x8A11)        ,
        /// <summary>
        /// Original was GL_BUFFER_SERIALIZED_MODIFY_APPLE = 0x8A12
        /// </summary>
        BufferSerializedModifyApple = ((int)0x8A12)        ,
        /// <summary>
        /// Original was GL_BUFFER_FLUSHING_UNMAP_APPLE = 0x8A13
        /// </summary>
        BufferFlushingUnmapApple = ((int)0x8A13)        ,
        /// <summary>
        /// Original was GL_AUX_DEPTH_STENCIL_APPLE = 0x8A14
        /// </summary>
        AuxDepthStencilApple = ((int)0x8A14)        ,
        /// <summary>
        /// Original was GL_PACK_ROW_BYTES_APPLE = 0x8A15
        /// </summary>
        PackRowBytesApple = ((int)0x8A15)        ,
        /// <summary>
        /// Original was GL_UNPACK_ROW_BYTES_APPLE = 0x8A16
        /// </summary>
        UnpackRowBytesApple = ((int)0x8A16)        ,
        /// <summary>
        /// Original was GL_RELEASED_APPLE = 0x8A19
        /// </summary>
        ReleasedApple = ((int)0x8A19)        ,
        /// <summary>
        /// Original was GL_VOLATILE_APPLE = 0x8A1A
        /// </summary>
        VolatileApple = ((int)0x8A1A)        ,
        /// <summary>
        /// Original was GL_RETAINED_APPLE = 0x8A1B
        /// </summary>
        RetainedApple = ((int)0x8A1B)        ,
        /// <summary>
        /// Original was GL_UNDEFINED_APPLE = 0x8A1C
        /// </summary>
        UndefinedApple = ((int)0x8A1C)        ,
        /// <summary>
        /// Original was GL_PURGEABLE_APPLE = 0x8A1D
        /// </summary>
        PurgeableApple = ((int)0x8A1D)        ,
        /// <summary>
        /// Original was GL_RGB_422_APPLE = 0x8A1F
        /// </summary>
        Rgb422Apple = ((int)0x8A1F)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BUFFER_BINDING = 0x8A28
        /// </summary>
        UniformBufferBinding = ((int)0x8A28)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BUFFER_START = 0x8A29
        /// </summary>
        UniformBufferStart = ((int)0x8A29)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BUFFER_SIZE = 0x8A2A
        /// </summary>
        UniformBufferSize = ((int)0x8A2A)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_UNIFORM_BLOCKS = 0x8A2B
        /// </summary>
        MaxVertexUniformBlocks = ((int)0x8A2B)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_UNIFORM_BLOCKS = 0x8A2C
        /// </summary>
        MaxGeometryUniformBlocks = ((int)0x8A2C)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_UNIFORM_BLOCKS = 0x8A2D
        /// </summary>
        MaxFragmentUniformBlocks = ((int)0x8A2D)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_UNIFORM_BLOCKS = 0x8A2E
        /// </summary>
        MaxCombinedUniformBlocks = ((int)0x8A2E)        ,
        /// <summary>
        /// Original was GL_MAX_UNIFORM_BUFFER_BINDINGS = 0x8A2F
        /// </summary>
        MaxUniformBufferBindings = ((int)0x8A2F)        ,
        /// <summary>
        /// Original was GL_MAX_UNIFORM_BLOCK_SIZE = 0x8A30
        /// </summary>
        MaxUniformBlockSize = ((int)0x8A30)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = 0x8A31
        /// </summary>
        MaxCombinedVertexUniformComponents = ((int)0x8A31)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS = 0x8A32
        /// </summary>
        MaxCombinedGeometryUniformComponents = ((int)0x8A32)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = 0x8A33
        /// </summary>
        MaxCombinedFragmentUniformComponents = ((int)0x8A33)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT = 0x8A34
        /// </summary>
        UniformBufferOffsetAlignment = ((int)0x8A34)        ,
        /// <summary>
        /// Original was GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH = 0x8A35
        /// </summary>
        ActiveUniformBlockMaxNameLength = ((int)0x8A35)        ,
        /// <summary>
        /// Original was GL_ACTIVE_UNIFORM_BLOCKS = 0x8A36
        /// </summary>
        ActiveUniformBlocks = ((int)0x8A36)        ,
        /// <summary>
        /// Original was GL_UNIFORM_TYPE = 0x8A37
        /// </summary>
        UniformType = ((int)0x8A37)        ,
        /// <summary>
        /// Original was GL_UNIFORM_SIZE = 0x8A38
        /// </summary>
        UniformSize = ((int)0x8A38)        ,
        /// <summary>
        /// Original was GL_UNIFORM_NAME_LENGTH = 0x8A39
        /// </summary>
        UniformNameLength = ((int)0x8A39)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_INDEX = 0x8A3A
        /// </summary>
        UniformBlockIndex = ((int)0x8A3A)        ,
        /// <summary>
        /// Original was GL_UNIFORM_OFFSET = 0x8A3B
        /// </summary>
        UniformOffset = ((int)0x8A3B)        ,
        /// <summary>
        /// Original was GL_UNIFORM_ARRAY_STRIDE = 0x8A3C
        /// </summary>
        UniformArrayStride = ((int)0x8A3C)        ,
        /// <summary>
        /// Original was GL_UNIFORM_MATRIX_STRIDE = 0x8A3D
        /// </summary>
        UniformMatrixStride = ((int)0x8A3D)        ,
        /// <summary>
        /// Original was GL_UNIFORM_IS_ROW_MAJOR = 0x8A3E
        /// </summary>
        UniformIsRowMajor = ((int)0x8A3E)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_BINDING = 0x8A3F
        /// </summary>
        UniformBlockBinding = ((int)0x8A3F)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_DATA_SIZE = 0x8A40
        /// </summary>
        UniformBlockDataSize = ((int)0x8A40)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_NAME_LENGTH = 0x8A41
        /// </summary>
        UniformBlockNameLength = ((int)0x8A41)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS = 0x8A42
        /// </summary>
        UniformBlockActiveUniforms = ((int)0x8A42)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = 0x8A43
        /// </summary>
        UniformBlockActiveUniformIndices = ((int)0x8A43)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = 0x8A44
        /// </summary>
        UniformBlockReferencedByVertexShader = ((int)0x8A44)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER = 0x8A45
        /// </summary>
        UniformBlockReferencedByGeometryShader = ((int)0x8A45)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = 0x8A46
        /// </summary>
        UniformBlockReferencedByFragmentShader = ((int)0x8A46)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SRGB_DECODE_EXT = 0x8A48
        /// </summary>
        TextureSrgbDecodeExt = ((int)0x8A48)        ,
        /// <summary>
        /// Original was GL_DECODE_EXT = 0x8A49
        /// </summary>
        DecodeExt = ((int)0x8A49)        ,
        /// <summary>
        /// Original was GL_SKIP_DECODE_EXT = 0x8A4A
        /// </summary>
        SkipDecodeExt = ((int)0x8A4A)        ,
        /// <summary>
        /// Original was GL_PROGRAM_PIPELINE_OBJECT_EXT = 0x8A4F
        /// </summary>
        ProgramPipelineObjectExt = ((int)0x8A4F)        ,
        /// <summary>
        /// Original was GL_RGB_RAW_422_APPLE = 0x8A51
        /// </summary>
        RgbRaw422Apple = ((int)0x8A51)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_SHADER = 0x8B30
        /// </summary>
        FragmentShader = ((int)0x8B30)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_SHADER_ARB = 0x8B30
        /// </summary>
        FragmentShaderArb = ((int)0x8B30)        ,
        /// <summary>
        /// Original was GL_VERTEX_SHADER = 0x8B31
        /// </summary>
        VertexShader = ((int)0x8B31)        ,
        /// <summary>
        /// Original was GL_VERTEX_SHADER_ARB = 0x8B31
        /// </summary>
        VertexShaderArb = ((int)0x8B31)        ,
        /// <summary>
        /// Original was GL_PROGRAM_OBJECT_ARB = 0x8B40
        /// </summary>
        ProgramObjectArb = ((int)0x8B40)        ,
        /// <summary>
        /// Original was GL_PROGRAM_OBJECT_EXT = 0x8B40
        /// </summary>
        ProgramObjectExt = ((int)0x8B40)        ,
        /// <summary>
        /// Original was GL_SHADER_OBJECT_ARB = 0x8B48
        /// </summary>
        ShaderObjectArb = ((int)0x8B48)        ,
        /// <summary>
        /// Original was GL_SHADER_OBJECT_EXT = 0x8B48
        /// </summary>
        ShaderObjectExt = ((int)0x8B48)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = 0x8B49
        /// </summary>
        MaxFragmentUniformComponents = ((int)0x8B49)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB = 0x8B49
        /// </summary>
        MaxFragmentUniformComponentsArb = ((int)0x8B49)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_UNIFORM_COMPONENTS = 0x8B4A
        /// </summary>
        MaxVertexUniformComponents = ((int)0x8B4A)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB = 0x8B4A
        /// </summary>
        MaxVertexUniformComponentsArb = ((int)0x8B4A)        ,
        /// <summary>
        /// Original was GL_MAX_VARYING_COMPONENTS = 0x8B4B
        /// </summary>
        MaxVaryingComponents = ((int)0x8B4B)        ,
        /// <summary>
        /// Original was GL_MAX_VARYING_COMPONENTS_EXT = 0x8B4B
        /// </summary>
        MaxVaryingComponentsExt = ((int)0x8B4B)        ,
        /// <summary>
        /// Original was GL_MAX_VARYING_FLOATS = 0x8B4B
        /// </summary>
        MaxVaryingFloats = ((int)0x8B4B)        ,
        /// <summary>
        /// Original was GL_MAX_VARYING_FLOATS_ARB = 0x8B4B
        /// </summary>
        MaxVaryingFloatsArb = ((int)0x8B4B)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 0x8B4C
        /// </summary>
        MaxVertexTextureImageUnits = ((int)0x8B4C)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB = 0x8B4C
        /// </summary>
        MaxVertexTextureImageUnitsArb = ((int)0x8B4C)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 0x8B4D
        /// </summary>
        MaxCombinedTextureImageUnits = ((int)0x8B4D)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB = 0x8B4D
        /// </summary>
        MaxCombinedTextureImageUnitsArb = ((int)0x8B4D)        ,
        /// <summary>
        /// Original was GL_OBJECT_TYPE_ARB = 0x8B4E
        /// </summary>
        ObjectTypeArb = ((int)0x8B4E)        ,
        /// <summary>
        /// Original was GL_OBJECT_SUBTYPE_ARB = 0x8B4F
        /// </summary>
        ObjectSubtypeArb = ((int)0x8B4F)        ,
        /// <summary>
        /// Original was GL_SHADER_TYPE = 0x8B4F
        /// </summary>
        ShaderType = ((int)0x8B4F)        ,
        /// <summary>
        /// Original was GL_FLOAT_VEC2 = 0x8B50
        /// </summary>
        FloatVec2 = ((int)0x8B50)        ,
        /// <summary>
        /// Original was GL_FLOAT_VEC2_ARB = 0x8B50
        /// </summary>
        FloatVec2Arb = ((int)0x8B50)        ,
        /// <summary>
        /// Original was GL_FLOAT_VEC3 = 0x8B51
        /// </summary>
        FloatVec3 = ((int)0x8B51)        ,
        /// <summary>
        /// Original was GL_FLOAT_VEC3_ARB = 0x8B51
        /// </summary>
        FloatVec3Arb = ((int)0x8B51)        ,
        /// <summary>
        /// Original was GL_FLOAT_VEC4 = 0x8B52
        /// </summary>
        FloatVec4 = ((int)0x8B52)        ,
        /// <summary>
        /// Original was GL_FLOAT_VEC4_ARB = 0x8B52
        /// </summary>
        FloatVec4Arb = ((int)0x8B52)        ,
        /// <summary>
        /// Original was GL_INT_VEC2 = 0x8B53
        /// </summary>
        IntVec2 = ((int)0x8B53)        ,
        /// <summary>
        /// Original was GL_INT_VEC2_ARB = 0x8B53
        /// </summary>
        IntVec2Arb = ((int)0x8B53)        ,
        /// <summary>
        /// Original was GL_INT_VEC3 = 0x8B54
        /// </summary>
        IntVec3 = ((int)0x8B54)        ,
        /// <summary>
        /// Original was GL_INT_VEC3_ARB = 0x8B54
        /// </summary>
        IntVec3Arb = ((int)0x8B54)        ,
        /// <summary>
        /// Original was GL_INT_VEC4 = 0x8B55
        /// </summary>
        IntVec4 = ((int)0x8B55)        ,
        /// <summary>
        /// Original was GL_INT_VEC4_ARB = 0x8B55
        /// </summary>
        IntVec4Arb = ((int)0x8B55)        ,
        /// <summary>
        /// Original was GL_BOOL = 0x8B56
        /// </summary>
        Bool = ((int)0x8B56)        ,
        /// <summary>
        /// Original was GL_BOOL_ARB = 0x8B56
        /// </summary>
        BoolArb = ((int)0x8B56)        ,
        /// <summary>
        /// Original was GL_BOOL_VEC2 = 0x8B57
        /// </summary>
        BoolVec2 = ((int)0x8B57)        ,
        /// <summary>
        /// Original was GL_BOOL_VEC2_ARB = 0x8B57
        /// </summary>
        BoolVec2Arb = ((int)0x8B57)        ,
        /// <summary>
        /// Original was GL_BOOL_VEC3 = 0x8B58
        /// </summary>
        BoolVec3 = ((int)0x8B58)        ,
        /// <summary>
        /// Original was GL_BOOL_VEC3_ARB = 0x8B58
        /// </summary>
        BoolVec3Arb = ((int)0x8B58)        ,
        /// <summary>
        /// Original was GL_BOOL_VEC4 = 0x8B59
        /// </summary>
        BoolVec4 = ((int)0x8B59)        ,
        /// <summary>
        /// Original was GL_BOOL_VEC4_ARB = 0x8B59
        /// </summary>
        BoolVec4Arb = ((int)0x8B59)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT2 = 0x8B5A
        /// </summary>
        FloatMat2 = ((int)0x8B5A)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT2_ARB = 0x8B5A
        /// </summary>
        FloatMat2Arb = ((int)0x8B5A)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT3 = 0x8B5B
        /// </summary>
        FloatMat3 = ((int)0x8B5B)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT3_ARB = 0x8B5B
        /// </summary>
        FloatMat3Arb = ((int)0x8B5B)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT4 = 0x8B5C
        /// </summary>
        FloatMat4 = ((int)0x8B5C)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT4_ARB = 0x8B5C
        /// </summary>
        FloatMat4Arb = ((int)0x8B5C)        ,
        /// <summary>
        /// Original was GL_SAMPLER_1D = 0x8B5D
        /// </summary>
        Sampler1D = ((int)0x8B5D)        ,
        /// <summary>
        /// Original was GL_SAMPLER_1D_ARB = 0x8B5D
        /// </summary>
        Sampler1DArb = ((int)0x8B5D)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D = 0x8B5E
        /// </summary>
        Sampler2D = ((int)0x8B5E)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_ARB = 0x8B5E
        /// </summary>
        Sampler2DArb = ((int)0x8B5E)        ,
        /// <summary>
        /// Original was GL_SAMPLER_3D = 0x8B5F
        /// </summary>
        Sampler3D = ((int)0x8B5F)        ,
        /// <summary>
        /// Original was GL_SAMPLER_3D_ARB = 0x8B5F
        /// </summary>
        Sampler3DArb = ((int)0x8B5F)        ,
        /// <summary>
        /// Original was GL_SAMPLER_CUBE = 0x8B60
        /// </summary>
        SamplerCube = ((int)0x8B60)        ,
        /// <summary>
        /// Original was GL_SAMPLER_CUBE_ARB = 0x8B60
        /// </summary>
        SamplerCubeArb = ((int)0x8B60)        ,
        /// <summary>
        /// Original was GL_SAMPLER_1D_SHADOW = 0x8B61
        /// </summary>
        Sampler1DShadow = ((int)0x8B61)        ,
        /// <summary>
        /// Original was GL_SAMPLER_1D_SHADOW_ARB = 0x8B61
        /// </summary>
        Sampler1DShadowArb = ((int)0x8B61)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_SHADOW = 0x8B62
        /// </summary>
        Sampler2DShadow = ((int)0x8B62)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_SHADOW_ARB = 0x8B62
        /// </summary>
        Sampler2DShadowArb = ((int)0x8B62)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_RECT = 0x8B63
        /// </summary>
        Sampler2DRect = ((int)0x8B63)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_RECT_ARB = 0x8B63
        /// </summary>
        Sampler2DRectArb = ((int)0x8B63)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_RECT_SHADOW = 0x8B64
        /// </summary>
        Sampler2DRectShadow = ((int)0x8B64)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_RECT_SHADOW_ARB = 0x8B64
        /// </summary>
        Sampler2DRectShadowArb = ((int)0x8B64)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT2x3 = 0x8B65
        /// </summary>
        FloatMat2x3 = ((int)0x8B65)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT2x4 = 0x8B66
        /// </summary>
        FloatMat2x4 = ((int)0x8B66)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT3x2 = 0x8B67
        /// </summary>
        FloatMat3x2 = ((int)0x8B67)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT3x4 = 0x8B68
        /// </summary>
        FloatMat3x4 = ((int)0x8B68)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT4x2 = 0x8B69
        /// </summary>
        FloatMat4x2 = ((int)0x8B69)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT4x3 = 0x8B6A
        /// </summary>
        FloatMat4x3 = ((int)0x8B6A)        ,
        /// <summary>
        /// Original was GL_DELETE_STATUS = 0x8B80
        /// </summary>
        DeleteStatus = ((int)0x8B80)        ,
        /// <summary>
        /// Original was GL_OBJECT_DELETE_STATUS_ARB = 0x8B80
        /// </summary>
        ObjectDeleteStatusArb = ((int)0x8B80)        ,
        /// <summary>
        /// Original was GL_COMPILE_STATUS = 0x8B81
        /// </summary>
        CompileStatus = ((int)0x8B81)        ,
        /// <summary>
        /// Original was GL_OBJECT_COMPILE_STATUS_ARB = 0x8B81
        /// </summary>
        ObjectCompileStatusArb = ((int)0x8B81)        ,
        /// <summary>
        /// Original was GL_LINK_STATUS = 0x8B82
        /// </summary>
        LinkStatus = ((int)0x8B82)        ,
        /// <summary>
        /// Original was GL_OBJECT_LINK_STATUS_ARB = 0x8B82
        /// </summary>
        ObjectLinkStatusArb = ((int)0x8B82)        ,
        /// <summary>
        /// Original was GL_OBJECT_VALIDATE_STATUS_ARB = 0x8B83
        /// </summary>
        ObjectValidateStatusArb = ((int)0x8B83)        ,
        /// <summary>
        /// Original was GL_VALIDATE_STATUS = 0x8B83
        /// </summary>
        ValidateStatus = ((int)0x8B83)        ,
        /// <summary>
        /// Original was GL_INFO_LOG_LENGTH = 0x8B84
        /// </summary>
        InfoLogLength = ((int)0x8B84)        ,
        /// <summary>
        /// Original was GL_OBJECT_INFO_LOG_LENGTH_ARB = 0x8B84
        /// </summary>
        ObjectInfoLogLengthArb = ((int)0x8B84)        ,
        /// <summary>
        /// Original was GL_ATTACHED_SHADERS = 0x8B85
        /// </summary>
        AttachedShaders = ((int)0x8B85)        ,
        /// <summary>
        /// Original was GL_OBJECT_ATTACHED_OBJECTS_ARB = 0x8B85
        /// </summary>
        ObjectAttachedObjectsArb = ((int)0x8B85)        ,
        /// <summary>
        /// Original was GL_ACTIVE_UNIFORMS = 0x8B86
        /// </summary>
        ActiveUniforms = ((int)0x8B86)        ,
        /// <summary>
        /// Original was GL_OBJECT_ACTIVE_UNIFORMS_ARB = 0x8B86
        /// </summary>
        ObjectActiveUniformsArb = ((int)0x8B86)        ,
        /// <summary>
        /// Original was GL_ACTIVE_UNIFORM_MAX_LENGTH = 0x8B87
        /// </summary>
        ActiveUniformMaxLength = ((int)0x8B87)        ,
        /// <summary>
        /// Original was GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB = 0x8B87
        /// </summary>
        ObjectActiveUniformMaxLengthArb = ((int)0x8B87)        ,
        /// <summary>
        /// Original was GL_OBJECT_SHADER_SOURCE_LENGTH_ARB = 0x8B88
        /// </summary>
        ObjectShaderSourceLengthArb = ((int)0x8B88)        ,
        /// <summary>
        /// Original was GL_SHADER_SOURCE_LENGTH = 0x8B88
        /// </summary>
        ShaderSourceLength = ((int)0x8B88)        ,
        /// <summary>
        /// Original was GL_ACTIVE_ATTRIBUTES = 0x8B89
        /// </summary>
        ActiveAttributes = ((int)0x8B89)        ,
        /// <summary>
        /// Original was GL_OBJECT_ACTIVE_ATTRIBUTES_ARB = 0x8B89
        /// </summary>
        ObjectActiveAttributesArb = ((int)0x8B89)        ,
        /// <summary>
        /// Original was GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 0x8B8A
        /// </summary>
        ActiveAttributeMaxLength = ((int)0x8B8A)        ,
        /// <summary>
        /// Original was GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB = 0x8B8A
        /// </summary>
        ObjectActiveAttributeMaxLengthArb = ((int)0x8B8A)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_SHADER_DERIVATIVE_HINT = 0x8B8B
        /// </summary>
        FragmentShaderDerivativeHint = ((int)0x8B8B)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB = 0x8B8B
        /// </summary>
        FragmentShaderDerivativeHintArb = ((int)0x8B8B)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_SHADER_DERIVATIVE_HINT_OES = 0x8B8B
        /// </summary>
        FragmentShaderDerivativeHintOes = ((int)0x8B8B)        ,
        /// <summary>
        /// Original was GL_SHADING_LANGUAGE_VERSION = 0x8B8C
        /// </summary>
        ShadingLanguageVersion = ((int)0x8B8C)        ,
        /// <summary>
        /// Original was GL_SHADING_LANGUAGE_VERSION_ARB = 0x8B8C
        /// </summary>
        ShadingLanguageVersionArb = ((int)0x8B8C)        ,
        /// <summary>
        /// Original was GL_ACTIVE_PROGRAM_EXT = 0x8B8D
        /// </summary>
        ActiveProgramExt = ((int)0x8B8D)        ,
        /// <summary>
        /// Original was GL_CURRENT_PROGRAM = 0x8B8D
        /// </summary>
        CurrentProgram = ((int)0x8B8D)        ,
        /// <summary>
        /// Original was GL_PALETTE4_RGB8_OES = 0x8B90
        /// </summary>
        Palette4Rgb8Oes = ((int)0x8B90)        ,
        /// <summary>
        /// Original was GL_PALETTE4_RGBA8_OES = 0x8B91
        /// </summary>
        Palette4Rgba8Oes = ((int)0x8B91)        ,
        /// <summary>
        /// Original was GL_PALETTE4_R5_G6_B5_OES = 0x8B92
        /// </summary>
        Palette4R5G6B5Oes = ((int)0x8B92)        ,
        /// <summary>
        /// Original was GL_PALETTE4_RGBA4_OES = 0x8B93
        /// </summary>
        Palette4Rgba4Oes = ((int)0x8B93)        ,
        /// <summary>
        /// Original was GL_PALETTE4_RGB5_A1_OES = 0x8B94
        /// </summary>
        Palette4Rgb5A1Oes = ((int)0x8B94)        ,
        /// <summary>
        /// Original was GL_PALETTE8_RGB8_OES = 0x8B95
        /// </summary>
        Palette8Rgb8Oes = ((int)0x8B95)        ,
        /// <summary>
        /// Original was GL_PALETTE8_RGBA8_OES = 0x8B96
        /// </summary>
        Palette8Rgba8Oes = ((int)0x8B96)        ,
        /// <summary>
        /// Original was GL_PALETTE8_R5_G6_B5_OES = 0x8B97
        /// </summary>
        Palette8R5G6B5Oes = ((int)0x8B97)        ,
        /// <summary>
        /// Original was GL_PALETTE8_RGBA4_OES = 0x8B98
        /// </summary>
        Palette8Rgba4Oes = ((int)0x8B98)        ,
        /// <summary>
        /// Original was GL_PALETTE8_RGB5_A1_OES = 0x8B99
        /// </summary>
        Palette8Rgb5A1Oes = ((int)0x8B99)        ,
        /// <summary>
        /// Original was GL_IMPLEMENTATION_COLOR_READ_TYPE = 0x8B9A
        /// </summary>
        ImplementationColorReadType = ((int)0x8B9A)        ,
        /// <summary>
        /// Original was GL_IMPLEMENTATION_COLOR_READ_TYPE_OES = 0x8B9A
        /// </summary>
        ImplementationColorReadTypeOes = ((int)0x8B9A)        ,
        /// <summary>
        /// Original was GL_IMPLEMENTATION_COLOR_READ_FORMAT = 0x8B9B
        /// </summary>
        ImplementationColorReadFormat = ((int)0x8B9B)        ,
        /// <summary>
        /// Original was GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES = 0x8B9B
        /// </summary>
        ImplementationColorReadFormatOes = ((int)0x8B9B)        ,
        /// <summary>
        /// Original was GL_COUNTER_TYPE_AMD = 0x8BC0
        /// </summary>
        CounterTypeAmd = ((int)0x8BC0)        ,
        /// <summary>
        /// Original was GL_COUNTER_RANGE_AMD = 0x8BC1
        /// </summary>
        CounterRangeAmd = ((int)0x8BC1)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT64_AMD = 0x8BC2
        /// </summary>
        UnsignedInt64Amd = ((int)0x8BC2)        ,
        /// <summary>
        /// Original was GL_PERCENTAGE_AMD = 0x8BC3
        /// </summary>
        PercentageAmd = ((int)0x8BC3)        ,
        /// <summary>
        /// Original was GL_PERFMON_RESULT_AVAILABLE_AMD = 0x8BC4
        /// </summary>
        PerfmonResultAvailableAmd = ((int)0x8BC4)        ,
        /// <summary>
        /// Original was GL_PERFMON_RESULT_SIZE_AMD = 0x8BC5
        /// </summary>
        PerfmonResultSizeAmd = ((int)0x8BC5)        ,
        /// <summary>
        /// Original was GL_PERFMON_RESULT_AMD = 0x8BC6
        /// </summary>
        PerfmonResultAmd = ((int)0x8BC6)        ,
        /// <summary>
        /// Original was GL_TEXTURE_RED_TYPE = 0x8C10
        /// </summary>
        TextureRedType = ((int)0x8C10)        ,
        /// <summary>
        /// Original was GL_TEXTURE_RED_TYPE_ARB = 0x8C10
        /// </summary>
        TextureRedTypeArb = ((int)0x8C10)        ,
        /// <summary>
        /// Original was GL_TEXTURE_GREEN_TYPE = 0x8C11
        /// </summary>
        TextureGreenType = ((int)0x8C11)        ,
        /// <summary>
        /// Original was GL_TEXTURE_GREEN_TYPE_ARB = 0x8C11
        /// </summary>
        TextureGreenTypeArb = ((int)0x8C11)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BLUE_TYPE = 0x8C12
        /// </summary>
        TextureBlueType = ((int)0x8C12)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BLUE_TYPE_ARB = 0x8C12
        /// </summary>
        TextureBlueTypeArb = ((int)0x8C12)        ,
        /// <summary>
        /// Original was GL_TEXTURE_ALPHA_TYPE = 0x8C13
        /// </summary>
        TextureAlphaType = ((int)0x8C13)        ,
        /// <summary>
        /// Original was GL_TEXTURE_ALPHA_TYPE_ARB = 0x8C13
        /// </summary>
        TextureAlphaTypeArb = ((int)0x8C13)        ,
        /// <summary>
        /// Original was GL_TEXTURE_LUMINANCE_TYPE = 0x8C14
        /// </summary>
        TextureLuminanceType = ((int)0x8C14)        ,
        /// <summary>
        /// Original was GL_TEXTURE_LUMINANCE_TYPE_ARB = 0x8C14
        /// </summary>
        TextureLuminanceTypeArb = ((int)0x8C14)        ,
        /// <summary>
        /// Original was GL_TEXTURE_INTENSITY_TYPE = 0x8C15
        /// </summary>
        TextureIntensityType = ((int)0x8C15)        ,
        /// <summary>
        /// Original was GL_TEXTURE_INTENSITY_TYPE_ARB = 0x8C15
        /// </summary>
        TextureIntensityTypeArb = ((int)0x8C15)        ,
        /// <summary>
        /// Original was GL_TEXTURE_DEPTH_TYPE = 0x8C16
        /// </summary>
        TextureDepthType = ((int)0x8C16)        ,
        /// <summary>
        /// Original was GL_TEXTURE_DEPTH_TYPE_ARB = 0x8C16
        /// </summary>
        TextureDepthTypeArb = ((int)0x8C16)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_NORMALIZED = 0x8C17
        /// </summary>
        UnsignedNormalized = ((int)0x8C17)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_NORMALIZED_ARB = 0x8C17
        /// </summary>
        UnsignedNormalizedArb = ((int)0x8C17)        ,
        /// <summary>
        /// Original was GL_TEXTURE_1D_ARRAY = 0x8C18
        /// </summary>
        Texture1DArray = ((int)0x8C18)        ,
        /// <summary>
        /// Original was GL_TEXTURE_1D_ARRAY_EXT = 0x8C18
        /// </summary>
        Texture1DArrayExt = ((int)0x8C18)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_1D_ARRAY = 0x8C19
        /// </summary>
        ProxyTexture1DArray = ((int)0x8C19)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_1D_ARRAY_EXT = 0x8C19
        /// </summary>
        ProxyTexture1DArrayExt = ((int)0x8C19)        ,
        /// <summary>
        /// Original was GL_TEXTURE_2D_ARRAY = 0x8C1A
        /// </summary>
        Texture2DArray = ((int)0x8C1A)        ,
        /// <summary>
        /// Original was GL_TEXTURE_2D_ARRAY_EXT = 0x8C1A
        /// </summary>
        Texture2DArrayExt = ((int)0x8C1A)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_2D_ARRAY = 0x8C1B
        /// </summary>
        ProxyTexture2DArray = ((int)0x8C1B)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_2D_ARRAY_EXT = 0x8C1B
        /// </summary>
        ProxyTexture2DArrayExt = ((int)0x8C1B)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_1D_ARRAY = 0x8C1C
        /// </summary>
        TextureBinding1DArray = ((int)0x8C1C)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_1D_ARRAY_EXT = 0x8C1C
        /// </summary>
        TextureBinding1DArrayExt = ((int)0x8C1C)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_2D_ARRAY = 0x8C1D
        /// </summary>
        TextureBinding2DArray = ((int)0x8C1D)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_2D_ARRAY_EXT = 0x8C1D
        /// </summary>
        TextureBinding2DArrayExt = ((int)0x8C1D)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_PROGRAM_NV = 0x8C26
        /// </summary>
        GeometryProgramNv = ((int)0x8C26)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_OUTPUT_VERTICES_NV = 0x8C27
        /// </summary>
        MaxProgramOutputVerticesNv = ((int)0x8C27)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV = 0x8C28
        /// </summary>
        MaxProgramTotalOutputComponentsNv = ((int)0x8C28)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS = 0x8C29
        /// </summary>
        MaxGeometryTextureImageUnits = ((int)0x8C29)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB = 0x8C29
        /// </summary>
        MaxGeometryTextureImageUnitsArb = ((int)0x8C29)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT = 0x8C29
        /// </summary>
        MaxGeometryTextureImageUnitsExt = ((int)0x8C29)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BUFFER = 0x8C2A
        /// </summary>
        TextureBuffer = ((int)0x8C2A)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BUFFER_ARB = 0x8C2A
        /// </summary>
        TextureBufferArb = ((int)0x8C2A)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BUFFER_BINDING = 0x8C2A
        /// </summary>
        TextureBufferBinding = ((int)0x8C2A)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BUFFER_EXT = 0x8C2A
        /// </summary>
        TextureBufferExt = ((int)0x8C2A)        ,
        /// <summary>
        /// Original was GL_MAX_TEXTURE_BUFFER_SIZE = 0x8C2B
        /// </summary>
        MaxTextureBufferSize = ((int)0x8C2B)        ,
        /// <summary>
        /// Original was GL_MAX_TEXTURE_BUFFER_SIZE_ARB = 0x8C2B
        /// </summary>
        MaxTextureBufferSizeArb = ((int)0x8C2B)        ,
        /// <summary>
        /// Original was GL_MAX_TEXTURE_BUFFER_SIZE_EXT = 0x8C2B
        /// </summary>
        MaxTextureBufferSizeExt = ((int)0x8C2B)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_BUFFER = 0x8C2C
        /// </summary>
        TextureBindingBuffer = ((int)0x8C2C)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_BUFFER_ARB = 0x8C2C
        /// </summary>
        TextureBindingBufferArb = ((int)0x8C2C)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_BUFFER_EXT = 0x8C2C
        /// </summary>
        TextureBindingBufferExt = ((int)0x8C2C)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BUFFER_DATA_STORE_BINDING = 0x8C2D
        /// </summary>
        TextureBufferDataStoreBinding = ((int)0x8C2D)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB = 0x8C2D
        /// </summary>
        TextureBufferDataStoreBindingArb = ((int)0x8C2D)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT = 0x8C2D
        /// </summary>
        TextureBufferDataStoreBindingExt = ((int)0x8C2D)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BUFFER_FORMAT_ARB = 0x8C2E
        /// </summary>
        TextureBufferFormatArb = ((int)0x8C2E)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BUFFER_FORMAT_EXT = 0x8C2E
        /// </summary>
        TextureBufferFormatExt = ((int)0x8C2E)        ,
        /// <summary>
        /// Original was GL_ANY_SAMPLES_PASSED = 0x8C2F
        /// </summary>
        AnySamplesPassed = ((int)0x8C2F)        ,
        /// <summary>
        /// Original was GL_SAMPLE_SHADING = 0x8C36
        /// </summary>
        SampleShading = ((int)0x8C36)        ,
        /// <summary>
        /// Original was GL_SAMPLE_SHADING_ARB = 0x8C36
        /// </summary>
        SampleShadingArb = ((int)0x8C36)        ,
        /// <summary>
        /// Original was GL_MIN_SAMPLE_SHADING_VALUE = 0x8C37
        /// </summary>
        MinSampleShadingValue = ((int)0x8C37)        ,
        /// <summary>
        /// Original was GL_MIN_SAMPLE_SHADING_VALUE_ARB = 0x8C37
        /// </summary>
        MinSampleShadingValueArb = ((int)0x8C37)        ,
        /// <summary>
        /// Original was GL_R11F_G11F_B10F = 0x8C3A
        /// </summary>
        R11fG11fB10f = ((int)0x8C3A)        ,
        /// <summary>
        /// Original was GL_R11F_G11F_B10F_EXT = 0x8C3A
        /// </summary>
        R11fG11fB10fExt = ((int)0x8C3A)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_10F_11F_11F_REV = 0x8C3B
        /// </summary>
        UnsignedInt10F11F11FRev = ((int)0x8C3B)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_10F_11F_11F_REV_EXT = 0x8C3B
        /// </summary>
        UnsignedInt10F11F11FRevExt = ((int)0x8C3B)        ,
        /// <summary>
        /// Original was GL_RGBA_SIGNED_COMPONENTS_EXT = 0x8C3C
        /// </summary>
        RgbaSignedComponentsExt = ((int)0x8C3C)        ,
        /// <summary>
        /// Original was GL_RGB9_E5 = 0x8C3D
        /// </summary>
        Rgb9E5 = ((int)0x8C3D)        ,
        /// <summary>
        /// Original was GL_RGB9_E5_EXT = 0x8C3D
        /// </summary>
        Rgb9E5Ext = ((int)0x8C3D)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_5_9_9_9_REV = 0x8C3E
        /// </summary>
        UnsignedInt5999Rev = ((int)0x8C3E)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_5_9_9_9_REV_EXT = 0x8C3E
        /// </summary>
        UnsignedInt5999RevExt = ((int)0x8C3E)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SHARED_SIZE = 0x8C3F
        /// </summary>
        TextureSharedSize = ((int)0x8C3F)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SHARED_SIZE_EXT = 0x8C3F
        /// </summary>
        TextureSharedSizeExt = ((int)0x8C3F)        ,
        /// <summary>
        /// Original was GL_SRGB = 0x8C40
        /// </summary>
        Srgb = ((int)0x8C40)        ,
        /// <summary>
        /// Original was GL_SRGB_EXT = 0x8C40
        /// </summary>
        SrgbExt = ((int)0x8C40)        ,
        /// <summary>
        /// Original was GL_SRGB8 = 0x8C41
        /// </summary>
        Srgb8 = ((int)0x8C41)        ,
        /// <summary>
        /// Original was GL_SRGB8_EXT = 0x8C41
        /// </summary>
        Srgb8Ext = ((int)0x8C41)        ,
        /// <summary>
        /// Original was GL_SRGB_ALPHA = 0x8C42
        /// </summary>
        SrgbAlpha = ((int)0x8C42)        ,
        /// <summary>
        /// Original was GL_SRGB_ALPHA_EXT = 0x8C42
        /// </summary>
        SrgbAlphaExt = ((int)0x8C42)        ,
        /// <summary>
        /// Original was GL_SRGB8_ALPHA8 = 0x8C43
        /// </summary>
        Srgb8Alpha8 = ((int)0x8C43)        ,
        /// <summary>
        /// Original was GL_SRGB8_ALPHA8_EXT = 0x8C43
        /// </summary>
        Srgb8Alpha8Ext = ((int)0x8C43)        ,
        /// <summary>
        /// Original was GL_SLUMINANCE_ALPHA = 0x8C44
        /// </summary>
        SluminanceAlpha = ((int)0x8C44)        ,
        /// <summary>
        /// Original was GL_SLUMINANCE_ALPHA_EXT = 0x8C44
        /// </summary>
        SluminanceAlphaExt = ((int)0x8C44)        ,
        /// <summary>
        /// Original was GL_SLUMINANCE8_ALPHA8 = 0x8C45
        /// </summary>
        Sluminance8Alpha8 = ((int)0x8C45)        ,
        /// <summary>
        /// Original was GL_SLUMINANCE8_ALPHA8_EXT = 0x8C45
        /// </summary>
        Sluminance8Alpha8Ext = ((int)0x8C45)        ,
        /// <summary>
        /// Original was GL_SLUMINANCE = 0x8C46
        /// </summary>
        Sluminance = ((int)0x8C46)        ,
        /// <summary>
        /// Original was GL_SLUMINANCE_EXT = 0x8C46
        /// </summary>
        SluminanceExt = ((int)0x8C46)        ,
        /// <summary>
        /// Original was GL_SLUMINANCE8 = 0x8C47
        /// </summary>
        Sluminance8 = ((int)0x8C47)        ,
        /// <summary>
        /// Original was GL_SLUMINANCE8_EXT = 0x8C47
        /// </summary>
        Sluminance8Ext = ((int)0x8C47)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB = 0x8C48
        /// </summary>
        CompressedSrgb = ((int)0x8C48)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB_EXT = 0x8C48
        /// </summary>
        CompressedSrgbExt = ((int)0x8C48)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB_ALPHA = 0x8C49
        /// </summary>
        CompressedSrgbAlpha = ((int)0x8C49)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB_ALPHA_EXT = 0x8C49
        /// </summary>
        CompressedSrgbAlphaExt = ((int)0x8C49)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SLUMINANCE = 0x8C4A
        /// </summary>
        CompressedSluminance = ((int)0x8C4A)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SLUMINANCE_EXT = 0x8C4A
        /// </summary>
        CompressedSluminanceExt = ((int)0x8C4A)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SLUMINANCE_ALPHA = 0x8C4B
        /// </summary>
        CompressedSluminanceAlpha = ((int)0x8C4B)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SLUMINANCE_ALPHA_EXT = 0x8C4B
        /// </summary>
        CompressedSluminanceAlphaExt = ((int)0x8C4B)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB_S3TC_DXT1_EXT = 0x8C4C
        /// </summary>
        CompressedSrgbS3tcDxt1Ext = ((int)0x8C4C)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT = 0x8C4D
        /// </summary>
        CompressedSrgbAlphaS3tcDxt1Ext = ((int)0x8C4D)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT = 0x8C4E
        /// </summary>
        CompressedSrgbAlphaS3tcDxt3Ext = ((int)0x8C4E)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT = 0x8C4F
        /// </summary>
        CompressedSrgbAlphaS3tcDxt5Ext = ((int)0x8C4F)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_LUMINANCE_LATC1_EXT = 0x8C70
        /// </summary>
        CompressedLuminanceLatc1Ext = ((int)0x8C70)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT = 0x8C71
        /// </summary>
        CompressedSignedLuminanceLatc1Ext = ((int)0x8C71)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT = 0x8C72
        /// </summary>
        CompressedLuminanceAlphaLatc2Ext = ((int)0x8C72)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT = 0x8C73
        /// </summary>
        CompressedSignedLuminanceAlphaLatc2Ext = ((int)0x8C73)        ,
        /// <summary>
        /// Original was GL_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV = 0x8C74
        /// </summary>
        TessControlProgramParameterBufferNv = ((int)0x8C74)        ,
        /// <summary>
        /// Original was GL_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV = 0x8C75
        /// </summary>
        TessEvaluationProgramParameterBufferNv = ((int)0x8C75)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH = 0x8C76
        /// </summary>
        TransformFeedbackVaryingMaxLength = ((int)0x8C76)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT = 0x8C76
        /// </summary>
        TransformFeedbackVaryingMaxLengthExt = ((int)0x8C76)        ,
        /// <summary>
        /// Original was GL_BACK_PRIMARY_COLOR_NV = 0x8C77
        /// </summary>
        BackPrimaryColorNv = ((int)0x8C77)        ,
        /// <summary>
        /// Original was GL_BACK_SECONDARY_COLOR_NV = 0x8C78
        /// </summary>
        BackSecondaryColorNv = ((int)0x8C78)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COORD_NV = 0x8C79
        /// </summary>
        TextureCoordNv = ((int)0x8C79)        ,
        /// <summary>
        /// Original was GL_CLIP_DISTANCE_NV = 0x8C7A
        /// </summary>
        ClipDistanceNv = ((int)0x8C7A)        ,
        /// <summary>
        /// Original was GL_VERTEX_ID_NV = 0x8C7B
        /// </summary>
        VertexIdNv = ((int)0x8C7B)        ,
        /// <summary>
        /// Original was GL_PRIMITIVE_ID_NV = 0x8C7C
        /// </summary>
        PrimitiveIdNv = ((int)0x8C7C)        ,
        /// <summary>
        /// Original was GL_GENERIC_ATTRIB_NV = 0x8C7D
        /// </summary>
        GenericAttribNv = ((int)0x8C7D)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_ATTRIBS_NV = 0x8C7E
        /// </summary>
        TransformFeedbackAttribsNv = ((int)0x8C7E)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_MODE = 0x8C7F
        /// </summary>
        TransformFeedbackBufferMode = ((int)0x8C7F)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_MODE_EXT = 0x8C7F
        /// </summary>
        TransformFeedbackBufferModeExt = ((int)0x8C7F)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV = 0x8C7F
        /// </summary>
        TransformFeedbackBufferModeNv = ((int)0x8C7F)        ,
        /// <summary>
        /// Original was GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS = 0x8C80
        /// </summary>
        MaxTransformFeedbackSeparateComponents = ((int)0x8C80)        ,
        /// <summary>
        /// Original was GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT = 0x8C80
        /// </summary>
        MaxTransformFeedbackSeparateComponentsExt = ((int)0x8C80)        ,
        /// <summary>
        /// Original was GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV = 0x8C80
        /// </summary>
        MaxTransformFeedbackSeparateComponentsNv = ((int)0x8C80)        ,
        /// <summary>
        /// Original was GL_ACTIVE_VARYINGS_NV = 0x8C81
        /// </summary>
        ActiveVaryingsNv = ((int)0x8C81)        ,
        /// <summary>
        /// Original was GL_ACTIVE_VARYING_MAX_LENGTH_NV = 0x8C82
        /// </summary>
        ActiveVaryingMaxLengthNv = ((int)0x8C82)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_VARYINGS = 0x8C83
        /// </summary>
        TransformFeedbackVaryings = ((int)0x8C83)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_VARYINGS_EXT = 0x8C83
        /// </summary>
        TransformFeedbackVaryingsExt = ((int)0x8C83)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_VARYINGS_NV = 0x8C83
        /// </summary>
        TransformFeedbackVaryingsNv = ((int)0x8C83)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_START = 0x8C84
        /// </summary>
        TransformFeedbackBufferStart = ((int)0x8C84)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_START_EXT = 0x8C84
        /// </summary>
        TransformFeedbackBufferStartExt = ((int)0x8C84)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_START_NV = 0x8C84
        /// </summary>
        TransformFeedbackBufferStartNv = ((int)0x8C84)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_SIZE = 0x8C85
        /// </summary>
        TransformFeedbackBufferSize = ((int)0x8C85)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT = 0x8C85
        /// </summary>
        TransformFeedbackBufferSizeExt = ((int)0x8C85)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV = 0x8C85
        /// </summary>
        TransformFeedbackBufferSizeNv = ((int)0x8C85)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_RECORD_NV = 0x8C86
        /// </summary>
        TransformFeedbackRecordNv = ((int)0x8C86)        ,
        /// <summary>
        /// Original was GL_PRIMITIVES_GENERATED = 0x8C87
        /// </summary>
        PrimitivesGenerated = ((int)0x8C87)        ,
        /// <summary>
        /// Original was GL_PRIMITIVES_GENERATED_EXT = 0x8C87
        /// </summary>
        PrimitivesGeneratedExt = ((int)0x8C87)        ,
        /// <summary>
        /// Original was GL_PRIMITIVES_GENERATED_NV = 0x8C87
        /// </summary>
        PrimitivesGeneratedNv = ((int)0x8C87)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = 0x8C88
        /// </summary>
        TransformFeedbackPrimitivesWritten = ((int)0x8C88)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT = 0x8C88
        /// </summary>
        TransformFeedbackPrimitivesWrittenExt = ((int)0x8C88)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV = 0x8C88
        /// </summary>
        TransformFeedbackPrimitivesWrittenNv = ((int)0x8C88)        ,
        /// <summary>
        /// Original was GL_RASTERIZER_DISCARD = 0x8C89
        /// </summary>
        RasterizerDiscard = ((int)0x8C89)        ,
        /// <summary>
        /// Original was GL_RASTERIZER_DISCARD_EXT = 0x8C89
        /// </summary>
        RasterizerDiscardExt = ((int)0x8C89)        ,
        /// <summary>
        /// Original was GL_RASTERIZER_DISCARD_NV = 0x8C89
        /// </summary>
        RasterizerDiscardNv = ((int)0x8C89)        ,
        /// <summary>
        /// Original was GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS = 0x8C8A
        /// </summary>
        MaxTransformFeedbackInterleavedComponents = ((int)0x8C8A)        ,
        /// <summary>
        /// Original was GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT = 0x8C8A
        /// </summary>
        MaxTransformFeedbackInterleavedComponentsExt = ((int)0x8C8A)        ,
        /// <summary>
        /// Original was GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV = 0x8C8A
        /// </summary>
        MaxTransformFeedbackInterleavedComponentsNv = ((int)0x8C8A)        ,
        /// <summary>
        /// Original was GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS = 0x8C8B
        /// </summary>
        MaxTransformFeedbackSeparateAttribs = ((int)0x8C8B)        ,
        /// <summary>
        /// Original was GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT = 0x8C8B
        /// </summary>
        MaxTransformFeedbackSeparateAttribsExt = ((int)0x8C8B)        ,
        /// <summary>
        /// Original was GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV = 0x8C8B
        /// </summary>
        MaxTransformFeedbackSeparateAttribsNv = ((int)0x8C8B)        ,
        /// <summary>
        /// Original was GL_INTERLEAVED_ATTRIBS = 0x8C8C
        /// </summary>
        InterleavedAttribs = ((int)0x8C8C)        ,
        /// <summary>
        /// Original was GL_INTERLEAVED_ATTRIBS_EXT = 0x8C8C
        /// </summary>
        InterleavedAttribsExt = ((int)0x8C8C)        ,
        /// <summary>
        /// Original was GL_INTERLEAVED_ATTRIBS_NV = 0x8C8C
        /// </summary>
        InterleavedAttribsNv = ((int)0x8C8C)        ,
        /// <summary>
        /// Original was GL_SEPARATE_ATTRIBS = 0x8C8D
        /// </summary>
        SeparateAttribs = ((int)0x8C8D)        ,
        /// <summary>
        /// Original was GL_SEPARATE_ATTRIBS_EXT = 0x8C8D
        /// </summary>
        SeparateAttribsExt = ((int)0x8C8D)        ,
        /// <summary>
        /// Original was GL_SEPARATE_ATTRIBS_NV = 0x8C8D
        /// </summary>
        SeparateAttribsNv = ((int)0x8C8D)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER = 0x8C8E
        /// </summary>
        TransformFeedbackBuffer = ((int)0x8C8E)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_EXT = 0x8C8E
        /// </summary>
        TransformFeedbackBufferExt = ((int)0x8C8E)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_NV = 0x8C8E
        /// </summary>
        TransformFeedbackBufferNv = ((int)0x8C8E)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_BINDING = 0x8C8F
        /// </summary>
        TransformFeedbackBufferBinding = ((int)0x8C8F)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT = 0x8C8F
        /// </summary>
        TransformFeedbackBufferBindingExt = ((int)0x8C8F)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV = 0x8C8F
        /// </summary>
        TransformFeedbackBufferBindingNv = ((int)0x8C8F)        ,
        /// <summary>
        /// Original was GL_POINT_SPRITE_COORD_ORIGIN = 0x8CA0
        /// </summary>
        PointSpriteCoordOrigin = ((int)0x8CA0)        ,
        /// <summary>
        /// Original was GL_LOWER_LEFT = 0x8CA1
        /// </summary>
        LowerLeft = ((int)0x8CA1)        ,
        /// <summary>
        /// Original was GL_UPPER_LEFT = 0x8CA2
        /// </summary>
        UpperLeft = ((int)0x8CA2)        ,
        /// <summary>
        /// Original was GL_STENCIL_BACK_REF = 0x8CA3
        /// </summary>
        StencilBackRef = ((int)0x8CA3)        ,
        /// <summary>
        /// Original was GL_STENCIL_BACK_VALUE_MASK = 0x8CA4
        /// </summary>
        StencilBackValueMask = ((int)0x8CA4)        ,
        /// <summary>
        /// Original was GL_STENCIL_BACK_WRITEMASK = 0x8CA5
        /// </summary>
        StencilBackWritemask = ((int)0x8CA5)        ,
        /// <summary>
        /// Original was GL_DRAW_FRAMEBUFFER_BINDING = 0x8CA6
        /// </summary>
        DrawFramebufferBinding = ((int)0x8CA6)        ,
        /// <summary>
        /// Original was GL_DRAW_FRAMEBUFFER_BINDING_EXT = 0x8CA6
        /// </summary>
        DrawFramebufferBindingExt = ((int)0x8CA6)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_BINDING = 0x8CA6
        /// </summary>
        FramebufferBinding = ((int)0x8CA6)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_BINDING_EXT = 0x8CA6
        /// </summary>
        FramebufferBindingExt = ((int)0x8CA6)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_BINDING = 0x8CA7
        /// </summary>
        RenderbufferBinding = ((int)0x8CA7)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_BINDING_EXT = 0x8CA7
        /// </summary>
        RenderbufferBindingExt = ((int)0x8CA7)        ,
        /// <summary>
        /// Original was GL_READ_FRAMEBUFFER = 0x8CA8
        /// </summary>
        ReadFramebuffer = ((int)0x8CA8)        ,
        /// <summary>
        /// Original was GL_READ_FRAMEBUFFER_EXT = 0x8CA8
        /// </summary>
        ReadFramebufferExt = ((int)0x8CA8)        ,
        /// <summary>
        /// Original was GL_DRAW_FRAMEBUFFER = 0x8CA9
        /// </summary>
        DrawFramebuffer = ((int)0x8CA9)        ,
        /// <summary>
        /// Original was GL_DRAW_FRAMEBUFFER_EXT = 0x8CA9
        /// </summary>
        DrawFramebufferExt = ((int)0x8CA9)        ,
        /// <summary>
        /// Original was GL_READ_FRAMEBUFFER_BINDING = 0x8CAA
        /// </summary>
        ReadFramebufferBinding = ((int)0x8CAA)        ,
        /// <summary>
        /// Original was GL_READ_FRAMEBUFFER_BINDING_EXT = 0x8CAA
        /// </summary>
        ReadFramebufferBindingExt = ((int)0x8CAA)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_COVERAGE_SAMPLES_NV = 0x8CAB
        /// </summary>
        RenderbufferCoverageSamplesNv = ((int)0x8CAB)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_SAMPLES = 0x8CAB
        /// </summary>
        RenderbufferSamples = ((int)0x8CAB)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_SAMPLES_EXT = 0x8CAB
        /// </summary>
        RenderbufferSamplesExt = ((int)0x8CAB)        ,
        /// <summary>
        /// Original was GL_DEPTH_COMPONENT32F = 0x8CAC
        /// </summary>
        DepthComponent32f = ((int)0x8CAC)        ,
        /// <summary>
        /// Original was GL_DEPTH32F_STENCIL8 = 0x8CAD
        /// </summary>
        Depth32fStencil8 = ((int)0x8CAD)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 0x8CD0
        /// </summary>
        FramebufferAttachmentObjectType = ((int)0x8CD0)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT = 0x8CD0
        /// </summary>
        FramebufferAttachmentObjectTypeExt = ((int)0x8CD0)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 0x8CD1
        /// </summary>
        FramebufferAttachmentObjectName = ((int)0x8CD1)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT = 0x8CD1
        /// </summary>
        FramebufferAttachmentObjectNameExt = ((int)0x8CD1)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 0x8CD2
        /// </summary>
        FramebufferAttachmentTextureLevel = ((int)0x8CD2)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT = 0x8CD2
        /// </summary>
        FramebufferAttachmentTextureLevelExt = ((int)0x8CD2)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 0x8CD3
        /// </summary>
        FramebufferAttachmentTextureCubeMapFace = ((int)0x8CD3)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT = 0x8CD3
        /// </summary>
        FramebufferAttachmentTextureCubeMapFaceExt = ((int)0x8CD3)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT = 0x8CD4
        /// </summary>
        FramebufferAttachmentTexture3DZoffsetExt = ((int)0x8CD4)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = 0x8CD4
        /// </summary>
        FramebufferAttachmentTextureLayer = ((int)0x8CD4)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT = 0x8CD4
        /// </summary>
        FramebufferAttachmentTextureLayerExt = ((int)0x8CD4)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_COMPLETE = 0x8CD5
        /// </summary>
        FramebufferComplete = ((int)0x8CD5)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_COMPLETE_EXT = 0x8CD5
        /// </summary>
        FramebufferCompleteExt = ((int)0x8CD5)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 0x8CD6
        /// </summary>
        FramebufferIncompleteAttachment = ((int)0x8CD6)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT = 0x8CD6
        /// </summary>
        FramebufferIncompleteAttachmentExt = ((int)0x8CD6)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 0x8CD7
        /// </summary>
        FramebufferIncompleteMissingAttachment = ((int)0x8CD7)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT = 0x8CD7
        /// </summary>
        FramebufferIncompleteMissingAttachmentExt = ((int)0x8CD7)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT = 0x8CD9
        /// </summary>
        FramebufferIncompleteDimensionsExt = ((int)0x8CD9)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT = 0x8CDA
        /// </summary>
        FramebufferIncompleteFormatsExt = ((int)0x8CDA)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 0x8CDB
        /// </summary>
        FramebufferIncompleteDrawBuffer = ((int)0x8CDB)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT = 0x8CDB
        /// </summary>
        FramebufferIncompleteDrawBufferExt = ((int)0x8CDB)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 0x8CDC
        /// </summary>
        FramebufferIncompleteReadBuffer = ((int)0x8CDC)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT = 0x8CDC
        /// </summary>
        FramebufferIncompleteReadBufferExt = ((int)0x8CDC)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_UNSUPPORTED = 0x8CDD
        /// </summary>
        FramebufferUnsupported = ((int)0x8CDD)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_UNSUPPORTED_EXT = 0x8CDD
        /// </summary>
        FramebufferUnsupportedExt = ((int)0x8CDD)        ,
        /// <summary>
        /// Original was GL_MAX_COLOR_ATTACHMENTS = 0x8CDF
        /// </summary>
        MaxColorAttachments = ((int)0x8CDF)        ,
        /// <summary>
        /// Original was GL_MAX_COLOR_ATTACHMENTS_EXT = 0x8CDF
        /// </summary>
        MaxColorAttachmentsExt = ((int)0x8CDF)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT0 = 0x8CE0
        /// </summary>
        ColorAttachment0 = ((int)0x8CE0)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT0_EXT = 0x8CE0
        /// </summary>
        ColorAttachment0Ext = ((int)0x8CE0)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT1 = 0x8CE1
        /// </summary>
        ColorAttachment1 = ((int)0x8CE1)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT1_EXT = 0x8CE1
        /// </summary>
        ColorAttachment1Ext = ((int)0x8CE1)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT2 = 0x8CE2
        /// </summary>
        ColorAttachment2 = ((int)0x8CE2)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT2_EXT = 0x8CE2
        /// </summary>
        ColorAttachment2Ext = ((int)0x8CE2)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT3 = 0x8CE3
        /// </summary>
        ColorAttachment3 = ((int)0x8CE3)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT3_EXT = 0x8CE3
        /// </summary>
        ColorAttachment3Ext = ((int)0x8CE3)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT4 = 0x8CE4
        /// </summary>
        ColorAttachment4 = ((int)0x8CE4)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT4_EXT = 0x8CE4
        /// </summary>
        ColorAttachment4Ext = ((int)0x8CE4)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT5 = 0x8CE5
        /// </summary>
        ColorAttachment5 = ((int)0x8CE5)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT5_EXT = 0x8CE5
        /// </summary>
        ColorAttachment5Ext = ((int)0x8CE5)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT6 = 0x8CE6
        /// </summary>
        ColorAttachment6 = ((int)0x8CE6)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT6_EXT = 0x8CE6
        /// </summary>
        ColorAttachment6Ext = ((int)0x8CE6)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT7 = 0x8CE7
        /// </summary>
        ColorAttachment7 = ((int)0x8CE7)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT7_EXT = 0x8CE7
        /// </summary>
        ColorAttachment7Ext = ((int)0x8CE7)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT8 = 0x8CE8
        /// </summary>
        ColorAttachment8 = ((int)0x8CE8)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT8_EXT = 0x8CE8
        /// </summary>
        ColorAttachment8Ext = ((int)0x8CE8)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT9 = 0x8CE9
        /// </summary>
        ColorAttachment9 = ((int)0x8CE9)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT9_EXT = 0x8CE9
        /// </summary>
        ColorAttachment9Ext = ((int)0x8CE9)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT10 = 0x8CEA
        /// </summary>
        ColorAttachment10 = ((int)0x8CEA)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT10_EXT = 0x8CEA
        /// </summary>
        ColorAttachment10Ext = ((int)0x8CEA)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT11 = 0x8CEB
        /// </summary>
        ColorAttachment11 = ((int)0x8CEB)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT11_EXT = 0x8CEB
        /// </summary>
        ColorAttachment11Ext = ((int)0x8CEB)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT12 = 0x8CEC
        /// </summary>
        ColorAttachment12 = ((int)0x8CEC)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT12_EXT = 0x8CEC
        /// </summary>
        ColorAttachment12Ext = ((int)0x8CEC)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT13 = 0x8CED
        /// </summary>
        ColorAttachment13 = ((int)0x8CED)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT13_EXT = 0x8CED
        /// </summary>
        ColorAttachment13Ext = ((int)0x8CED)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT14 = 0x8CEE
        /// </summary>
        ColorAttachment14 = ((int)0x8CEE)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT14_EXT = 0x8CEE
        /// </summary>
        ColorAttachment14Ext = ((int)0x8CEE)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT15 = 0x8CEF
        /// </summary>
        ColorAttachment15 = ((int)0x8CEF)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT15_EXT = 0x8CEF
        /// </summary>
        ColorAttachment15Ext = ((int)0x8CEF)        ,
        /// <summary>
        /// Original was GL_DEPTH_ATTACHMENT = 0x8D00
        /// </summary>
        DepthAttachment = ((int)0x8D00)        ,
        /// <summary>
        /// Original was GL_DEPTH_ATTACHMENT_EXT = 0x8D00
        /// </summary>
        DepthAttachmentExt = ((int)0x8D00)        ,
        /// <summary>
        /// Original was GL_STENCIL_ATTACHMENT = 0x8D20
        /// </summary>
        StencilAttachment = ((int)0x8D20)        ,
        /// <summary>
        /// Original was GL_STENCIL_ATTACHMENT_EXT = 0x8D20
        /// </summary>
        StencilAttachmentExt = ((int)0x8D20)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER = 0x8D40
        /// </summary>
        Framebuffer = ((int)0x8D40)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_EXT = 0x8D40
        /// </summary>
        FramebufferExt = ((int)0x8D40)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER = 0x8D41
        /// </summary>
        Renderbuffer = ((int)0x8D41)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_EXT = 0x8D41
        /// </summary>
        RenderbufferExt = ((int)0x8D41)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_WIDTH = 0x8D42
        /// </summary>
        RenderbufferWidth = ((int)0x8D42)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_WIDTH_EXT = 0x8D42
        /// </summary>
        RenderbufferWidthExt = ((int)0x8D42)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_HEIGHT = 0x8D43
        /// </summary>
        RenderbufferHeight = ((int)0x8D43)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_HEIGHT_EXT = 0x8D43
        /// </summary>
        RenderbufferHeightExt = ((int)0x8D43)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_INTERNAL_FORMAT = 0x8D44
        /// </summary>
        RenderbufferInternalFormat = ((int)0x8D44)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_INTERNAL_FORMAT_EXT = 0x8D44
        /// </summary>
        RenderbufferInternalFormatExt = ((int)0x8D44)        ,
        /// <summary>
        /// Original was GL_STENCIL_INDEX1 = 0x8D46
        /// </summary>
        StencilIndex1 = ((int)0x8D46)        ,
        /// <summary>
        /// Original was GL_STENCIL_INDEX1_EXT = 0x8D46
        /// </summary>
        StencilIndex1Ext = ((int)0x8D46)        ,
        /// <summary>
        /// Original was GL_STENCIL_INDEX4 = 0x8D47
        /// </summary>
        StencilIndex4 = ((int)0x8D47)        ,
        /// <summary>
        /// Original was GL_STENCIL_INDEX4_EXT = 0x8D47
        /// </summary>
        StencilIndex4Ext = ((int)0x8D47)        ,
        /// <summary>
        /// Original was GL_STENCIL_INDEX8 = 0x8D48
        /// </summary>
        StencilIndex8 = ((int)0x8D48)        ,
        /// <summary>
        /// Original was GL_STENCIL_INDEX8_EXT = 0x8D48
        /// </summary>
        StencilIndex8Ext = ((int)0x8D48)        ,
        /// <summary>
        /// Original was GL_STENCIL_INDEX16 = 0x8D49
        /// </summary>
        StencilIndex16 = ((int)0x8D49)        ,
        /// <summary>
        /// Original was GL_STENCIL_INDEX16_EXT = 0x8D49
        /// </summary>
        StencilIndex16Ext = ((int)0x8D49)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_RED_SIZE = 0x8D50
        /// </summary>
        RenderbufferRedSize = ((int)0x8D50)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_RED_SIZE_EXT = 0x8D50
        /// </summary>
        RenderbufferRedSizeExt = ((int)0x8D50)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_GREEN_SIZE = 0x8D51
        /// </summary>
        RenderbufferGreenSize = ((int)0x8D51)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_GREEN_SIZE_EXT = 0x8D51
        /// </summary>
        RenderbufferGreenSizeExt = ((int)0x8D51)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_BLUE_SIZE = 0x8D52
        /// </summary>
        RenderbufferBlueSize = ((int)0x8D52)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_BLUE_SIZE_EXT = 0x8D52
        /// </summary>
        RenderbufferBlueSizeExt = ((int)0x8D52)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_ALPHA_SIZE = 0x8D53
        /// </summary>
        RenderbufferAlphaSize = ((int)0x8D53)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_ALPHA_SIZE_EXT = 0x8D53
        /// </summary>
        RenderbufferAlphaSizeExt = ((int)0x8D53)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_DEPTH_SIZE = 0x8D54
        /// </summary>
        RenderbufferDepthSize = ((int)0x8D54)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_DEPTH_SIZE_EXT = 0x8D54
        /// </summary>
        RenderbufferDepthSizeExt = ((int)0x8D54)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_STENCIL_SIZE = 0x8D55
        /// </summary>
        RenderbufferStencilSize = ((int)0x8D55)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_STENCIL_SIZE_EXT = 0x8D55
        /// </summary>
        RenderbufferStencilSizeExt = ((int)0x8D55)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = 0x8D56
        /// </summary>
        FramebufferIncompleteMultisample = ((int)0x8D56)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT = 0x8D56
        /// </summary>
        FramebufferIncompleteMultisampleExt = ((int)0x8D56)        ,
        /// <summary>
        /// Original was GL_MAX_SAMPLES = 0x8D57
        /// </summary>
        MaxSamples = ((int)0x8D57)        ,
        /// <summary>
        /// Original was GL_MAX_SAMPLES_EXT = 0x8D57
        /// </summary>
        MaxSamplesExt = ((int)0x8D57)        ,
        /// <summary>
        /// Original was GL_RGB565 = 0x8D62
        /// </summary>
        Rgb565 = ((int)0x8D62)        ,
        /// <summary>
        /// Original was GL_PRIMITIVE_RESTART_FIXED_INDEX = 0x8D69
        /// </summary>
        PrimitiveRestartFixedIndex = ((int)0x8D69)        ,
        /// <summary>
        /// Original was GL_ANY_SAMPLES_PASSED_CONSERVATIVE = 0x8D6A
        /// </summary>
        AnySamplesPassedConservative = ((int)0x8D6A)        ,
        /// <summary>
        /// Original was GL_MAX_ELEMENT_INDEX = 0x8D6B
        /// </summary>
        MaxElementIndex = ((int)0x8D6B)        ,
        /// <summary>
        /// Original was GL_RGBA32UI = 0x8D70
        /// </summary>
        Rgba32ui = ((int)0x8D70)        ,
        /// <summary>
        /// Original was GL_RGBA32UI_EXT = 0x8D70
        /// </summary>
        Rgba32uiExt = ((int)0x8D70)        ,
        /// <summary>
        /// Original was GL_RGB32UI = 0x8D71
        /// </summary>
        Rgb32ui = ((int)0x8D71)        ,
        /// <summary>
        /// Original was GL_RGB32UI_EXT = 0x8D71
        /// </summary>
        Rgb32uiExt = ((int)0x8D71)        ,
        /// <summary>
        /// Original was GL_ALPHA32UI_EXT = 0x8D72
        /// </summary>
        Alpha32uiExt = ((int)0x8D72)        ,
        /// <summary>
        /// Original was GL_INTENSITY32UI_EXT = 0x8D73
        /// </summary>
        Intensity32uiExt = ((int)0x8D73)        ,
        /// <summary>
        /// Original was GL_LUMINANCE32UI_EXT = 0x8D74
        /// </summary>
        Luminance32uiExt = ((int)0x8D74)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ALPHA32UI_EXT = 0x8D75
        /// </summary>
        LuminanceAlpha32uiExt = ((int)0x8D75)        ,
        /// <summary>
        /// Original was GL_RGBA16UI = 0x8D76
        /// </summary>
        Rgba16ui = ((int)0x8D76)        ,
        /// <summary>
        /// Original was GL_RGBA16UI_EXT = 0x8D76
        /// </summary>
        Rgba16uiExt = ((int)0x8D76)        ,
        /// <summary>
        /// Original was GL_RGB16UI = 0x8D77
        /// </summary>
        Rgb16ui = ((int)0x8D77)        ,
        /// <summary>
        /// Original was GL_RGB16UI_EXT = 0x8D77
        /// </summary>
        Rgb16uiExt = ((int)0x8D77)        ,
        /// <summary>
        /// Original was GL_ALPHA16UI_EXT = 0x8D78
        /// </summary>
        Alpha16uiExt = ((int)0x8D78)        ,
        /// <summary>
        /// Original was GL_INTENSITY16UI_EXT = 0x8D79
        /// </summary>
        Intensity16uiExt = ((int)0x8D79)        ,
        /// <summary>
        /// Original was GL_LUMINANCE16UI_EXT = 0x8D7A
        /// </summary>
        Luminance16uiExt = ((int)0x8D7A)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ALPHA16UI_EXT = 0x8D7B
        /// </summary>
        LuminanceAlpha16uiExt = ((int)0x8D7B)        ,
        /// <summary>
        /// Original was GL_RGBA8UI = 0x8D7C
        /// </summary>
        Rgba8ui = ((int)0x8D7C)        ,
        /// <summary>
        /// Original was GL_RGBA8UI_EXT = 0x8D7C
        /// </summary>
        Rgba8uiExt = ((int)0x8D7C)        ,
        /// <summary>
        /// Original was GL_RGB8UI = 0x8D7D
        /// </summary>
        Rgb8ui = ((int)0x8D7D)        ,
        /// <summary>
        /// Original was GL_RGB8UI_EXT = 0x8D7D
        /// </summary>
        Rgb8uiExt = ((int)0x8D7D)        ,
        /// <summary>
        /// Original was GL_ALPHA8UI_EXT = 0x8D7E
        /// </summary>
        Alpha8uiExt = ((int)0x8D7E)        ,
        /// <summary>
        /// Original was GL_INTENSITY8UI_EXT = 0x8D7F
        /// </summary>
        Intensity8uiExt = ((int)0x8D7F)        ,
        /// <summary>
        /// Original was GL_LUMINANCE8UI_EXT = 0x8D80
        /// </summary>
        Luminance8uiExt = ((int)0x8D80)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ALPHA8UI_EXT = 0x8D81
        /// </summary>
        LuminanceAlpha8uiExt = ((int)0x8D81)        ,
        /// <summary>
        /// Original was GL_RGBA32I = 0x8D82
        /// </summary>
        Rgba32i = ((int)0x8D82)        ,
        /// <summary>
        /// Original was GL_RGBA32I_EXT = 0x8D82
        /// </summary>
        Rgba32iExt = ((int)0x8D82)        ,
        /// <summary>
        /// Original was GL_RGB32I = 0x8D83
        /// </summary>
        Rgb32i = ((int)0x8D83)        ,
        /// <summary>
        /// Original was GL_RGB32I_EXT = 0x8D83
        /// </summary>
        Rgb32iExt = ((int)0x8D83)        ,
        /// <summary>
        /// Original was GL_ALPHA32I_EXT = 0x8D84
        /// </summary>
        Alpha32iExt = ((int)0x8D84)        ,
        /// <summary>
        /// Original was GL_INTENSITY32I_EXT = 0x8D85
        /// </summary>
        Intensity32iExt = ((int)0x8D85)        ,
        /// <summary>
        /// Original was GL_LUMINANCE32I_EXT = 0x8D86
        /// </summary>
        Luminance32iExt = ((int)0x8D86)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ALPHA32I_EXT = 0x8D87
        /// </summary>
        LuminanceAlpha32iExt = ((int)0x8D87)        ,
        /// <summary>
        /// Original was GL_RGBA16I = 0x8D88
        /// </summary>
        Rgba16i = ((int)0x8D88)        ,
        /// <summary>
        /// Original was GL_RGBA16I_EXT = 0x8D88
        /// </summary>
        Rgba16iExt = ((int)0x8D88)        ,
        /// <summary>
        /// Original was GL_RGB16I = 0x8D89
        /// </summary>
        Rgb16i = ((int)0x8D89)        ,
        /// <summary>
        /// Original was GL_RGB16I_EXT = 0x8D89
        /// </summary>
        Rgb16iExt = ((int)0x8D89)        ,
        /// <summary>
        /// Original was GL_ALPHA16I_EXT = 0x8D8A
        /// </summary>
        Alpha16iExt = ((int)0x8D8A)        ,
        /// <summary>
        /// Original was GL_INTENSITY16I_EXT = 0x8D8B
        /// </summary>
        Intensity16iExt = ((int)0x8D8B)        ,
        /// <summary>
        /// Original was GL_LUMINANCE16I_EXT = 0x8D8C
        /// </summary>
        Luminance16iExt = ((int)0x8D8C)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ALPHA16I_EXT = 0x8D8D
        /// </summary>
        LuminanceAlpha16iExt = ((int)0x8D8D)        ,
        /// <summary>
        /// Original was GL_RGBA8I = 0x8D8E
        /// </summary>
        Rgba8i = ((int)0x8D8E)        ,
        /// <summary>
        /// Original was GL_RGBA8I_EXT = 0x8D8E
        /// </summary>
        Rgba8iExt = ((int)0x8D8E)        ,
        /// <summary>
        /// Original was GL_RGB8I = 0x8D8F
        /// </summary>
        Rgb8i = ((int)0x8D8F)        ,
        /// <summary>
        /// Original was GL_RGB8I_EXT = 0x8D8F
        /// </summary>
        Rgb8iExt = ((int)0x8D8F)        ,
        /// <summary>
        /// Original was GL_ALPHA8I_EXT = 0x8D90
        /// </summary>
        Alpha8iExt = ((int)0x8D90)        ,
        /// <summary>
        /// Original was GL_INTENSITY8I_EXT = 0x8D91
        /// </summary>
        Intensity8iExt = ((int)0x8D91)        ,
        /// <summary>
        /// Original was GL_LUMINANCE8I_EXT = 0x8D92
        /// </summary>
        Luminance8iExt = ((int)0x8D92)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ALPHA8I_EXT = 0x8D93
        /// </summary>
        LuminanceAlpha8iExt = ((int)0x8D93)        ,
        /// <summary>
        /// Original was GL_RED_INTEGER = 0x8D94
        /// </summary>
        RedInteger = ((int)0x8D94)        ,
        /// <summary>
        /// Original was GL_RED_INTEGER_EXT = 0x8D94
        /// </summary>
        RedIntegerExt = ((int)0x8D94)        ,
        /// <summary>
        /// Original was GL_GREEN_INTEGER = 0x8D95
        /// </summary>
        GreenInteger = ((int)0x8D95)        ,
        /// <summary>
        /// Original was GL_GREEN_INTEGER_EXT = 0x8D95
        /// </summary>
        GreenIntegerExt = ((int)0x8D95)        ,
        /// <summary>
        /// Original was GL_BLUE_INTEGER = 0x8D96
        /// </summary>
        BlueInteger = ((int)0x8D96)        ,
        /// <summary>
        /// Original was GL_BLUE_INTEGER_EXT = 0x8D96
        /// </summary>
        BlueIntegerExt = ((int)0x8D96)        ,
        /// <summary>
        /// Original was GL_ALPHA_INTEGER = 0x8D97
        /// </summary>
        AlphaInteger = ((int)0x8D97)        ,
        /// <summary>
        /// Original was GL_ALPHA_INTEGER_EXT = 0x8D97
        /// </summary>
        AlphaIntegerExt = ((int)0x8D97)        ,
        /// <summary>
        /// Original was GL_RGB_INTEGER = 0x8D98
        /// </summary>
        RgbInteger = ((int)0x8D98)        ,
        /// <summary>
        /// Original was GL_RGB_INTEGER_EXT = 0x8D98
        /// </summary>
        RgbIntegerExt = ((int)0x8D98)        ,
        /// <summary>
        /// Original was GL_RGBA_INTEGER = 0x8D99
        /// </summary>
        RgbaInteger = ((int)0x8D99)        ,
        /// <summary>
        /// Original was GL_RGBA_INTEGER_EXT = 0x8D99
        /// </summary>
        RgbaIntegerExt = ((int)0x8D99)        ,
        /// <summary>
        /// Original was GL_BGR_INTEGER = 0x8D9A
        /// </summary>
        BgrInteger = ((int)0x8D9A)        ,
        /// <summary>
        /// Original was GL_BGR_INTEGER_EXT = 0x8D9A
        /// </summary>
        BgrIntegerExt = ((int)0x8D9A)        ,
        /// <summary>
        /// Original was GL_BGRA_INTEGER = 0x8D9B
        /// </summary>
        BgraInteger = ((int)0x8D9B)        ,
        /// <summary>
        /// Original was GL_BGRA_INTEGER_EXT = 0x8D9B
        /// </summary>
        BgraIntegerExt = ((int)0x8D9B)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_INTEGER_EXT = 0x8D9C
        /// </summary>
        LuminanceIntegerExt = ((int)0x8D9C)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ALPHA_INTEGER_EXT = 0x8D9D
        /// </summary>
        LuminanceAlphaIntegerExt = ((int)0x8D9D)        ,
        /// <summary>
        /// Original was GL_RGBA_INTEGER_MODE_EXT = 0x8D9E
        /// </summary>
        RgbaIntegerModeExt = ((int)0x8D9E)        ,
        /// <summary>
        /// Original was GL_INT_2_10_10_10_REV = 0x8D9F
        /// </summary>
        Int2101010Rev = ((int)0x8D9F)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV = 0x8DA0
        /// </summary>
        MaxProgramParameterBufferBindingsNv = ((int)0x8DA0)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV = 0x8DA1
        /// </summary>
        MaxProgramParameterBufferSizeNv = ((int)0x8DA1)        ,
        /// <summary>
        /// Original was GL_VERTEX_PROGRAM_PARAMETER_BUFFER_NV = 0x8DA2
        /// </summary>
        VertexProgramParameterBufferNv = ((int)0x8DA2)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV = 0x8DA3
        /// </summary>
        GeometryProgramParameterBufferNv = ((int)0x8DA3)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV = 0x8DA4
        /// </summary>
        FragmentProgramParameterBufferNv = ((int)0x8DA4)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_GENERIC_ATTRIBS_NV = 0x8DA5
        /// </summary>
        MaxProgramGenericAttribsNv = ((int)0x8DA5)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_GENERIC_RESULTS_NV = 0x8DA6
        /// </summary>
        MaxProgramGenericResultsNv = ((int)0x8DA6)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_LAYERED = 0x8DA7
        /// </summary>
        FramebufferAttachmentLayered = ((int)0x8DA7)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB = 0x8DA7
        /// </summary>
        FramebufferAttachmentLayeredArb = ((int)0x8DA7)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT = 0x8DA7
        /// </summary>
        FramebufferAttachmentLayeredExt = ((int)0x8DA7)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = 0x8DA8
        /// </summary>
        FramebufferIncompleteLayerTargets = ((int)0x8DA8)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB = 0x8DA8
        /// </summary>
        FramebufferIncompleteLayerTargetsArb = ((int)0x8DA8)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT = 0x8DA8
        /// </summary>
        FramebufferIncompleteLayerTargetsExt = ((int)0x8DA8)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT = 0x8DA9
        /// </summary>
        FramebufferIncompleteLayerCount = ((int)0x8DA9)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB = 0x8DA9
        /// </summary>
        FramebufferIncompleteLayerCountArb = ((int)0x8DA9)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT = 0x8DA9
        /// </summary>
        FramebufferIncompleteLayerCountExt = ((int)0x8DA9)        ,
        /// <summary>
        /// Original was GL_LAYER_NV = 0x8DAA
        /// </summary>
        LayerNv = ((int)0x8DAA)        ,
        /// <summary>
        /// Original was GL_DEPTH_COMPONENT32F_NV = 0x8DAB
        /// </summary>
        DepthComponent32fNv = ((int)0x8DAB)        ,
        /// <summary>
        /// Original was GL_DEPTH32F_STENCIL8_NV = 0x8DAC
        /// </summary>
        Depth32fStencil8Nv = ((int)0x8DAC)        ,
        /// <summary>
        /// Original was GL_FLOAT_32_UNSIGNED_INT_24_8_REV = 0x8DAD
        /// </summary>
        Float32UnsignedInt248Rev = ((int)0x8DAD)        ,
        /// <summary>
        /// Original was GL_FLOAT_32_UNSIGNED_INT_24_8_REV_NV = 0x8DAD
        /// </summary>
        Float32UnsignedInt248RevNv = ((int)0x8DAD)        ,
        /// <summary>
        /// Original was GL_SHADER_INCLUDE_ARB = 0x8DAE
        /// </summary>
        ShaderIncludeArb = ((int)0x8DAE)        ,
        /// <summary>
        /// Original was GL_DEPTH_BUFFER_FLOAT_MODE_NV = 0x8DAF
        /// </summary>
        DepthBufferFloatModeNv = ((int)0x8DAF)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_SRGB = 0x8DB9
        /// </summary>
        FramebufferSrgb = ((int)0x8DB9)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_SRGB_EXT = 0x8DB9
        /// </summary>
        FramebufferSrgbExt = ((int)0x8DB9)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_SRGB_CAPABLE_EXT = 0x8DBA
        /// </summary>
        FramebufferSrgbCapableExt = ((int)0x8DBA)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RED_RGTC1 = 0x8DBB
        /// </summary>
        CompressedRedRgtc1 = ((int)0x8DBB)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RED_RGTC1_EXT = 0x8DBB
        /// </summary>
        CompressedRedRgtc1Ext = ((int)0x8DBB)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SIGNED_RED_RGTC1 = 0x8DBC
        /// </summary>
        CompressedSignedRedRgtc1 = ((int)0x8DBC)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SIGNED_RED_RGTC1_EXT = 0x8DBC
        /// </summary>
        CompressedSignedRedRgtc1Ext = ((int)0x8DBC)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RED_GREEN_RGTC2_EXT = 0x8DBD
        /// </summary>
        CompressedRedGreenRgtc2Ext = ((int)0x8DBD)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RG_RGTC2 = 0x8DBD
        /// </summary>
        CompressedRgRgtc2 = ((int)0x8DBD)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT = 0x8DBE
        /// </summary>
        CompressedSignedRedGreenRgtc2Ext = ((int)0x8DBE)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SIGNED_RG_RGTC2 = 0x8DBE
        /// </summary>
        CompressedSignedRgRgtc2 = ((int)0x8DBE)        ,
        /// <summary>
        /// Original was GL_SAMPLER_1D_ARRAY = 0x8DC0
        /// </summary>
        Sampler1DArray = ((int)0x8DC0)        ,
        /// <summary>
        /// Original was GL_SAMPLER_1D_ARRAY_EXT = 0x8DC0
        /// </summary>
        Sampler1DArrayExt = ((int)0x8DC0)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_ARRAY = 0x8DC1
        /// </summary>
        Sampler2DArray = ((int)0x8DC1)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_ARRAY_EXT = 0x8DC1
        /// </summary>
        Sampler2DArrayExt = ((int)0x8DC1)        ,
        /// <summary>
        /// Original was GL_SAMPLER_BUFFER = 0x8DC2
        /// </summary>
        SamplerBuffer = ((int)0x8DC2)        ,
        /// <summary>
        /// Original was GL_SAMPLER_BUFFER_EXT = 0x8DC2
        /// </summary>
        SamplerBufferExt = ((int)0x8DC2)        ,
        /// <summary>
        /// Original was GL_SAMPLER_1D_ARRAY_SHADOW = 0x8DC3
        /// </summary>
        Sampler1DArrayShadow = ((int)0x8DC3)        ,
        /// <summary>
        /// Original was GL_SAMPLER_1D_ARRAY_SHADOW_EXT = 0x8DC3
        /// </summary>
        Sampler1DArrayShadowExt = ((int)0x8DC3)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_ARRAY_SHADOW = 0x8DC4
        /// </summary>
        Sampler2DArrayShadow = ((int)0x8DC4)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_ARRAY_SHADOW_EXT = 0x8DC4
        /// </summary>
        Sampler2DArrayShadowExt = ((int)0x8DC4)        ,
        /// <summary>
        /// Original was GL_SAMPLER_CUBE_SHADOW = 0x8DC5
        /// </summary>
        SamplerCubeShadow = ((int)0x8DC5)        ,
        /// <summary>
        /// Original was GL_SAMPLER_CUBE_SHADOW_EXT = 0x8DC5
        /// </summary>
        SamplerCubeShadowExt = ((int)0x8DC5)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_VEC2 = 0x8DC6
        /// </summary>
        UnsignedIntVec2 = ((int)0x8DC6)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_VEC2_EXT = 0x8DC6
        /// </summary>
        UnsignedIntVec2Ext = ((int)0x8DC6)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_VEC3 = 0x8DC7
        /// </summary>
        UnsignedIntVec3 = ((int)0x8DC7)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_VEC3_EXT = 0x8DC7
        /// </summary>
        UnsignedIntVec3Ext = ((int)0x8DC7)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_VEC4 = 0x8DC8
        /// </summary>
        UnsignedIntVec4 = ((int)0x8DC8)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_VEC4_EXT = 0x8DC8
        /// </summary>
        UnsignedIntVec4Ext = ((int)0x8DC8)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_1D = 0x8DC9
        /// </summary>
        IntSampler1D = ((int)0x8DC9)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_1D_EXT = 0x8DC9
        /// </summary>
        IntSampler1DExt = ((int)0x8DC9)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_2D = 0x8DCA
        /// </summary>
        IntSampler2D = ((int)0x8DCA)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_2D_EXT = 0x8DCA
        /// </summary>
        IntSampler2DExt = ((int)0x8DCA)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_3D = 0x8DCB
        /// </summary>
        IntSampler3D = ((int)0x8DCB)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_3D_EXT = 0x8DCB
        /// </summary>
        IntSampler3DExt = ((int)0x8DCB)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_CUBE = 0x8DCC
        /// </summary>
        IntSamplerCube = ((int)0x8DCC)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_CUBE_EXT = 0x8DCC
        /// </summary>
        IntSamplerCubeExt = ((int)0x8DCC)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_2D_RECT = 0x8DCD
        /// </summary>
        IntSampler2DRect = ((int)0x8DCD)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_2D_RECT_EXT = 0x8DCD
        /// </summary>
        IntSampler2DRectExt = ((int)0x8DCD)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_1D_ARRAY = 0x8DCE
        /// </summary>
        IntSampler1DArray = ((int)0x8DCE)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_1D_ARRAY_EXT = 0x8DCE
        /// </summary>
        IntSampler1DArrayExt = ((int)0x8DCE)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_2D_ARRAY = 0x8DCF
        /// </summary>
        IntSampler2DArray = ((int)0x8DCF)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_2D_ARRAY_EXT = 0x8DCF
        /// </summary>
        IntSampler2DArrayExt = ((int)0x8DCF)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_BUFFER = 0x8DD0
        /// </summary>
        IntSamplerBuffer = ((int)0x8DD0)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_BUFFER_EXT = 0x8DD0
        /// </summary>
        IntSamplerBufferExt = ((int)0x8DD0)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_1D = 0x8DD1
        /// </summary>
        UnsignedIntSampler1D = ((int)0x8DD1)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_1D_EXT = 0x8DD1
        /// </summary>
        UnsignedIntSampler1DExt = ((int)0x8DD1)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_2D = 0x8DD2
        /// </summary>
        UnsignedIntSampler2D = ((int)0x8DD2)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_2D_EXT = 0x8DD2
        /// </summary>
        UnsignedIntSampler2DExt = ((int)0x8DD2)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_3D = 0x8DD3
        /// </summary>
        UnsignedIntSampler3D = ((int)0x8DD3)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_3D_EXT = 0x8DD3
        /// </summary>
        UnsignedIntSampler3DExt = ((int)0x8DD3)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_CUBE = 0x8DD4
        /// </summary>
        UnsignedIntSamplerCube = ((int)0x8DD4)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_CUBE_EXT = 0x8DD4
        /// </summary>
        UnsignedIntSamplerCubeExt = ((int)0x8DD4)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_2D_RECT = 0x8DD5
        /// </summary>
        UnsignedIntSampler2DRect = ((int)0x8DD5)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_2D_RECT_EXT = 0x8DD5
        /// </summary>
        UnsignedIntSampler2DRectExt = ((int)0x8DD5)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_1D_ARRAY = 0x8DD6
        /// </summary>
        UnsignedIntSampler1DArray = ((int)0x8DD6)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_1D_ARRAY_EXT = 0x8DD6
        /// </summary>
        UnsignedIntSampler1DArrayExt = ((int)0x8DD6)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_2D_ARRAY = 0x8DD7
        /// </summary>
        UnsignedIntSampler2DArray = ((int)0x8DD7)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_2D_ARRAY_EXT = 0x8DD7
        /// </summary>
        UnsignedIntSampler2DArrayExt = ((int)0x8DD7)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_BUFFER = 0x8DD8
        /// </summary>
        UnsignedIntSamplerBuffer = ((int)0x8DD8)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_BUFFER_EXT = 0x8DD8
        /// </summary>
        UnsignedIntSamplerBufferExt = ((int)0x8DD8)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_SHADER = 0x8DD9
        /// </summary>
        GeometryShader = ((int)0x8DD9)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_SHADER_ARB = 0x8DD9
        /// </summary>
        GeometryShaderArb = ((int)0x8DD9)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_SHADER_EXT = 0x8DD9
        /// </summary>
        GeometryShaderExt = ((int)0x8DD9)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_VERTICES_OUT_ARB = 0x8DDA
        /// </summary>
        GeometryVerticesOutArb = ((int)0x8DDA)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_VERTICES_OUT_EXT = 0x8DDA
        /// </summary>
        GeometryVerticesOutExt = ((int)0x8DDA)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_INPUT_TYPE_ARB = 0x8DDB
        /// </summary>
        GeometryInputTypeArb = ((int)0x8DDB)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_INPUT_TYPE_EXT = 0x8DDB
        /// </summary>
        GeometryInputTypeExt = ((int)0x8DDB)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_OUTPUT_TYPE_ARB = 0x8DDC
        /// </summary>
        GeometryOutputTypeArb = ((int)0x8DDC)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_OUTPUT_TYPE_EXT = 0x8DDC
        /// </summary>
        GeometryOutputTypeExt = ((int)0x8DDC)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_VARYING_COMPONENTS = 0x8DDD
        /// </summary>
        MaxGeometryVaryingComponents = ((int)0x8DDD)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB = 0x8DDD
        /// </summary>
        MaxGeometryVaryingComponentsArb = ((int)0x8DDD)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_VARYING_COMPONENTS_EXT = 0x8DDD
        /// </summary>
        MaxGeometryVaryingComponentsExt = ((int)0x8DDD)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_VARYING_COMPONENTS = 0x8DDE
        /// </summary>
        MaxVertexVaryingComponents = ((int)0x8DDE)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_VARYING_COMPONENTS_ARB = 0x8DDE
        /// </summary>
        MaxVertexVaryingComponentsArb = ((int)0x8DDE)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_VARYING_COMPONENTS_EXT = 0x8DDE
        /// </summary>
        MaxVertexVaryingComponentsExt = ((int)0x8DDE)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_UNIFORM_COMPONENTS = 0x8DDF
        /// </summary>
        MaxGeometryUniformComponents = ((int)0x8DDF)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB = 0x8DDF
        /// </summary>
        MaxGeometryUniformComponentsArb = ((int)0x8DDF)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT = 0x8DDF
        /// </summary>
        MaxGeometryUniformComponentsExt = ((int)0x8DDF)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_OUTPUT_VERTICES = 0x8DE0
        /// </summary>
        MaxGeometryOutputVertices = ((int)0x8DE0)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_OUTPUT_VERTICES_ARB = 0x8DE0
        /// </summary>
        MaxGeometryOutputVerticesArb = ((int)0x8DE0)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_OUTPUT_VERTICES_EXT = 0x8DE0
        /// </summary>
        MaxGeometryOutputVerticesExt = ((int)0x8DE0)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS = 0x8DE1
        /// </summary>
        MaxGeometryTotalOutputComponents = ((int)0x8DE1)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB = 0x8DE1
        /// </summary>
        MaxGeometryTotalOutputComponentsArb = ((int)0x8DE1)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT = 0x8DE1
        /// </summary>
        MaxGeometryTotalOutputComponentsExt = ((int)0x8DE1)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT = 0x8DE2
        /// </summary>
        MaxVertexBindableUniformsExt = ((int)0x8DE2)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT = 0x8DE3
        /// </summary>
        MaxFragmentBindableUniformsExt = ((int)0x8DE3)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT = 0x8DE4
        /// </summary>
        MaxGeometryBindableUniformsExt = ((int)0x8DE4)        ,
        /// <summary>
        /// Original was GL_ACTIVE_SUBROUTINES = 0x8DE5
        /// </summary>
        ActiveSubroutines = ((int)0x8DE5)        ,
        /// <summary>
        /// Original was GL_ACTIVE_SUBROUTINE_UNIFORMS = 0x8DE6
        /// </summary>
        ActiveSubroutineUniforms = ((int)0x8DE6)        ,
        /// <summary>
        /// Original was GL_MAX_SUBROUTINES = 0x8DE7
        /// </summary>
        MaxSubroutines = ((int)0x8DE7)        ,
        /// <summary>
        /// Original was GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS = 0x8DE8
        /// </summary>
        MaxSubroutineUniformLocations = ((int)0x8DE8)        ,
        /// <summary>
        /// Original was GL_NAMED_STRING_LENGTH_ARB = 0x8DE9
        /// </summary>
        NamedStringLengthArb = ((int)0x8DE9)        ,
        /// <summary>
        /// Original was GL_NAMED_STRING_TYPE_ARB = 0x8DEA
        /// </summary>
        NamedStringTypeArb = ((int)0x8DEA)        ,
        /// <summary>
        /// Original was GL_MAX_BINDABLE_UNIFORM_SIZE_EXT = 0x8DED
        /// </summary>
        MaxBindableUniformSizeExt = ((int)0x8DED)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BUFFER_EXT = 0x8DEE
        /// </summary>
        UniformBufferExt = ((int)0x8DEE)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BUFFER_BINDING_EXT = 0x8DEF
        /// </summary>
        UniformBufferBindingExt = ((int)0x8DEF)        ,
        /// <summary>
        /// Original was GL_LOW_FLOAT = 0x8DF0
        /// </summary>
        LowFloat = ((int)0x8DF0)        ,
        /// <summary>
        /// Original was GL_MEDIUM_FLOAT = 0x8DF1
        /// </summary>
        MediumFloat = ((int)0x8DF1)        ,
        /// <summary>
        /// Original was GL_HIGH_FLOAT = 0x8DF2
        /// </summary>
        HighFloat = ((int)0x8DF2)        ,
        /// <summary>
        /// Original was GL_LOW_INT = 0x8DF3
        /// </summary>
        LowInt = ((int)0x8DF3)        ,
        /// <summary>
        /// Original was GL_MEDIUM_INT = 0x8DF4
        /// </summary>
        MediumInt = ((int)0x8DF4)        ,
        /// <summary>
        /// Original was GL_HIGH_INT = 0x8DF5
        /// </summary>
        HighInt = ((int)0x8DF5)        ,
        /// <summary>
        /// Original was GL_SHADER_BINARY_FORMATS = 0x8DF8
        /// </summary>
        ShaderBinaryFormats = ((int)0x8DF8)        ,
        /// <summary>
        /// Original was GL_NUM_SHADER_BINARY_FORMATS = 0x8DF9
        /// </summary>
        NumShaderBinaryFormats = ((int)0x8DF9)        ,
        /// <summary>
        /// Original was GL_SHADER_COMPILER = 0x8DFA
        /// </summary>
        ShaderCompiler = ((int)0x8DFA)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_UNIFORM_VECTORS = 0x8DFB
        /// </summary>
        MaxVertexUniformVectors = ((int)0x8DFB)        ,
        /// <summary>
        /// Original was GL_MAX_VARYING_VECTORS = 0x8DFC
        /// </summary>
        MaxVaryingVectors = ((int)0x8DFC)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_UNIFORM_VECTORS = 0x8DFD
        /// </summary>
        MaxFragmentUniformVectors = ((int)0x8DFD)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_COLOR_SAMPLES_NV = 0x8E10
        /// </summary>
        RenderbufferColorSamplesNv = ((int)0x8E10)        ,
        /// <summary>
        /// Original was GL_MAX_MULTISAMPLE_COVERAGE_MODES_NV = 0x8E11
        /// </summary>
        MaxMultisampleCoverageModesNv = ((int)0x8E11)        ,
        /// <summary>
        /// Original was GL_MULTISAMPLE_COVERAGE_MODES_NV = 0x8E12
        /// </summary>
        MultisampleCoverageModesNv = ((int)0x8E12)        ,
        /// <summary>
        /// Original was GL_QUERY_WAIT = 0x8E13
        /// </summary>
        QueryWait = ((int)0x8E13)        ,
        /// <summary>
        /// Original was GL_QUERY_WAIT_NV = 0x8E13
        /// </summary>
        QueryWaitNv = ((int)0x8E13)        ,
        /// <summary>
        /// Original was GL_QUERY_NO_WAIT = 0x8E14
        /// </summary>
        QueryNoWait = ((int)0x8E14)        ,
        /// <summary>
        /// Original was GL_QUERY_NO_WAIT_NV = 0x8E14
        /// </summary>
        QueryNoWaitNv = ((int)0x8E14)        ,
        /// <summary>
        /// Original was GL_QUERY_BY_REGION_WAIT = 0x8E15
        /// </summary>
        QueryByRegionWait = ((int)0x8E15)        ,
        /// <summary>
        /// Original was GL_QUERY_BY_REGION_WAIT_NV = 0x8E15
        /// </summary>
        QueryByRegionWaitNv = ((int)0x8E15)        ,
        /// <summary>
        /// Original was GL_QUERY_BY_REGION_NO_WAIT = 0x8E16
        /// </summary>
        QueryByRegionNoWait = ((int)0x8E16)        ,
        /// <summary>
        /// Original was GL_QUERY_BY_REGION_NO_WAIT_NV = 0x8E16
        /// </summary>
        QueryByRegionNoWaitNv = ((int)0x8E16)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS = 0x8E1E
        /// </summary>
        MaxCombinedTessControlUniformComponents = ((int)0x8E1E)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS = 0x8E1F
        /// </summary>
        MaxCombinedTessEvaluationUniformComponents = ((int)0x8E1F)        ,
        /// <summary>
        /// Original was GL_COLOR_SAMPLES_NV = 0x8E20
        /// </summary>
        ColorSamplesNv = ((int)0x8E20)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK = 0x8E22
        /// </summary>
        TransformFeedback = ((int)0x8E22)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_NV = 0x8E22
        /// </summary>
        TransformFeedbackNv = ((int)0x8E22)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED = 0x8E23
        /// </summary>
        TransformFeedbackBufferPaused = ((int)0x8E23)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED_NV = 0x8E23
        /// </summary>
        TransformFeedbackBufferPausedNv = ((int)0x8E23)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_PAUSED = 0x8E23
        /// </summary>
        TransformFeedbackPaused = ((int)0x8E23)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_ACTIVE = 0x8E24
        /// </summary>
        TransformFeedbackActive = ((int)0x8E24)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE = 0x8E24
        /// </summary>
        TransformFeedbackBufferActive = ((int)0x8E24)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE_NV = 0x8E24
        /// </summary>
        TransformFeedbackBufferActiveNv = ((int)0x8E24)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BINDING = 0x8E25
        /// </summary>
        TransformFeedbackBinding = ((int)0x8E25)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BINDING_NV = 0x8E25
        /// </summary>
        TransformFeedbackBindingNv = ((int)0x8E25)        ,
        /// <summary>
        /// Original was GL_FRAME_NV = 0x8E26
        /// </summary>
        FrameNv = ((int)0x8E26)        ,
        /// <summary>
        /// Original was GL_FIELDS_NV = 0x8E27
        /// </summary>
        FieldsNv = ((int)0x8E27)        ,
        /// <summary>
        /// Original was GL_CURRENT_TIME_NV = 0x8E28
        /// </summary>
        CurrentTimeNv = ((int)0x8E28)        ,
        /// <summary>
        /// Original was GL_TIMESTAMP = 0x8E28
        /// </summary>
        Timestamp = ((int)0x8E28)        ,
        /// <summary>
        /// Original was GL_NUM_FILL_STREAMS_NV = 0x8E29
        /// </summary>
        NumFillStreamsNv = ((int)0x8E29)        ,
        /// <summary>
        /// Original was GL_PRESENT_TIME_NV = 0x8E2A
        /// </summary>
        PresentTimeNv = ((int)0x8E2A)        ,
        /// <summary>
        /// Original was GL_PRESENT_DURATION_NV = 0x8E2B
        /// </summary>
        PresentDurationNv = ((int)0x8E2B)        ,
        /// <summary>
        /// Original was GL_PROGRAM_MATRIX_EXT = 0x8E2D
        /// </summary>
        ProgramMatrixExt = ((int)0x8E2D)        ,
        /// <summary>
        /// Original was GL_TRANSPOSE_PROGRAM_MATRIX_EXT = 0x8E2E
        /// </summary>
        TransposeProgramMatrixExt = ((int)0x8E2E)        ,
        /// <summary>
        /// Original was GL_PROGRAM_MATRIX_STACK_DEPTH_EXT = 0x8E2F
        /// </summary>
        ProgramMatrixStackDepthExt = ((int)0x8E2F)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SWIZZLE_R = 0x8E42
        /// </summary>
        TextureSwizzleR = ((int)0x8E42)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SWIZZLE_R_EXT = 0x8E42
        /// </summary>
        TextureSwizzleRExt = ((int)0x8E42)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SWIZZLE_G = 0x8E43
        /// </summary>
        TextureSwizzleG = ((int)0x8E43)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SWIZZLE_G_EXT = 0x8E43
        /// </summary>
        TextureSwizzleGExt = ((int)0x8E43)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SWIZZLE_B = 0x8E44
        /// </summary>
        TextureSwizzleB = ((int)0x8E44)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SWIZZLE_B_EXT = 0x8E44
        /// </summary>
        TextureSwizzleBExt = ((int)0x8E44)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SWIZZLE_A = 0x8E45
        /// </summary>
        TextureSwizzleA = ((int)0x8E45)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SWIZZLE_A_EXT = 0x8E45
        /// </summary>
        TextureSwizzleAExt = ((int)0x8E45)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SWIZZLE_RGBA = 0x8E46
        /// </summary>
        TextureSwizzleRgba = ((int)0x8E46)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SWIZZLE_RGBA_EXT = 0x8E46
        /// </summary>
        TextureSwizzleRgbaExt = ((int)0x8E46)        ,
        /// <summary>
        /// Original was GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS = 0x8E47
        /// </summary>
        ActiveSubroutineUniformLocations = ((int)0x8E47)        ,
        /// <summary>
        /// Original was GL_ACTIVE_SUBROUTINE_MAX_LENGTH = 0x8E48
        /// </summary>
        ActiveSubroutineMaxLength = ((int)0x8E48)        ,
        /// <summary>
        /// Original was GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH = 0x8E49
        /// </summary>
        ActiveSubroutineUniformMaxLength = ((int)0x8E49)        ,
        /// <summary>
        /// Original was GL_NUM_COMPATIBLE_SUBROUTINES = 0x8E4A
        /// </summary>
        NumCompatibleSubroutines = ((int)0x8E4A)        ,
        /// <summary>
        /// Original was GL_COMPATIBLE_SUBROUTINES = 0x8E4B
        /// </summary>
        CompatibleSubroutines = ((int)0x8E4B)        ,
        /// <summary>
        /// Original was GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION = 0x8E4C
        /// </summary>
        QuadsFollowProvokingVertexConvention = ((int)0x8E4C)        ,
        /// <summary>
        /// Original was GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION_EXT = 0x8E4C
        /// </summary>
        QuadsFollowProvokingVertexConventionExt = ((int)0x8E4C)        ,
        /// <summary>
        /// Original was GL_FIRST_VERTEX_CONVENTION = 0x8E4D
        /// </summary>
        FirstVertexConvention = ((int)0x8E4D)        ,
        /// <summary>
        /// Original was GL_FIRST_VERTEX_CONVENTION_EXT = 0x8E4D
        /// </summary>
        FirstVertexConventionExt = ((int)0x8E4D)        ,
        /// <summary>
        /// Original was GL_LAST_VERTEX_CONVENTION = 0x8E4E
        /// </summary>
        LastVertexConvention = ((int)0x8E4E)        ,
        /// <summary>
        /// Original was GL_LAST_VERTEX_CONVENTION_EXT = 0x8E4E
        /// </summary>
        LastVertexConventionExt = ((int)0x8E4E)        ,
        /// <summary>
        /// Original was GL_PROVOKING_VERTEX = 0x8E4F
        /// </summary>
        ProvokingVertex = ((int)0x8E4F)        ,
        /// <summary>
        /// Original was GL_PROVOKING_VERTEX_EXT = 0x8E4F
        /// </summary>
        ProvokingVertexExt = ((int)0x8E4F)        ,
        /// <summary>
        /// Original was GL_SAMPLE_POSITION = 0x8E50
        /// </summary>
        SamplePosition = ((int)0x8E50)        ,
        /// <summary>
        /// Original was GL_SAMPLE_POSITION_NV = 0x8E50
        /// </summary>
        SamplePositionNv = ((int)0x8E50)        ,
        /// <summary>
        /// Original was GL_SAMPLE_MASK = 0x8E51
        /// </summary>
        SampleMask = ((int)0x8E51)        ,
        /// <summary>
        /// Original was GL_SAMPLE_MASK_NV = 0x8E51
        /// </summary>
        SampleMaskNv = ((int)0x8E51)        ,
        /// <summary>
        /// Original was GL_SAMPLE_MASK_VALUE = 0x8E52
        /// </summary>
        SampleMaskValue = ((int)0x8E52)        ,
        /// <summary>
        /// Original was GL_SAMPLE_MASK_VALUE_NV = 0x8E52
        /// </summary>
        SampleMaskValueNv = ((int)0x8E52)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_RENDERBUFFER_NV = 0x8E53
        /// </summary>
        TextureBindingRenderbufferNv = ((int)0x8E53)        ,
        /// <summary>
        /// Original was GL_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV = 0x8E54
        /// </summary>
        TextureRenderbufferDataStoreBindingNv = ((int)0x8E54)        ,
        /// <summary>
        /// Original was GL_TEXTURE_RENDERBUFFER_NV = 0x8E55
        /// </summary>
        TextureRenderbufferNv = ((int)0x8E55)        ,
        /// <summary>
        /// Original was GL_SAMPLER_RENDERBUFFER_NV = 0x8E56
        /// </summary>
        SamplerRenderbufferNv = ((int)0x8E56)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_RENDERBUFFER_NV = 0x8E57
        /// </summary>
        IntSamplerRenderbufferNv = ((int)0x8E57)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV = 0x8E58
        /// </summary>
        UnsignedIntSamplerRenderbufferNv = ((int)0x8E58)        ,
        /// <summary>
        /// Original was GL_MAX_SAMPLE_MASK_WORDS = 0x8E59
        /// </summary>
        MaxSampleMaskWords = ((int)0x8E59)        ,
        /// <summary>
        /// Original was GL_MAX_SAMPLE_MASK_WORDS_NV = 0x8E59
        /// </summary>
        MaxSampleMaskWordsNv = ((int)0x8E59)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_PROGRAM_INVOCATIONS_NV = 0x8E5A
        /// </summary>
        MaxGeometryProgramInvocationsNv = ((int)0x8E5A)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_SHADER_INVOCATIONS = 0x8E5A
        /// </summary>
        MaxGeometryShaderInvocations = ((int)0x8E5A)        ,
        /// <summary>
        /// Original was GL_MIN_FRAGMENT_INTERPOLATION_OFFSET = 0x8E5B
        /// </summary>
        MinFragmentInterpolationOffset = ((int)0x8E5B)        ,
        /// <summary>
        /// Original was GL_MIN_FRAGMENT_INTERPOLATION_OFFSET_NV = 0x8E5B
        /// </summary>
        MinFragmentInterpolationOffsetNv = ((int)0x8E5B)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_INTERPOLATION_OFFSET = 0x8E5C
        /// </summary>
        MaxFragmentInterpolationOffset = ((int)0x8E5C)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_INTERPOLATION_OFFSET_NV = 0x8E5C
        /// </summary>
        MaxFragmentInterpolationOffsetNv = ((int)0x8E5C)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_INTERPOLATION_OFFSET_BITS = 0x8E5D
        /// </summary>
        FragmentInterpolationOffsetBits = ((int)0x8E5D)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_PROGRAM_INTERPOLATION_OFFSET_BITS_NV = 0x8E5D
        /// </summary>
        FragmentProgramInterpolationOffsetBitsNv = ((int)0x8E5D)        ,
        /// <summary>
        /// Original was GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET = 0x8E5E
        /// </summary>
        MinProgramTextureGatherOffset = ((int)0x8E5E)        ,
        /// <summary>
        /// Original was GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB = 0x8E5E
        /// </summary>
        MinProgramTextureGatherOffsetArb = ((int)0x8E5E)        ,
        /// <summary>
        /// Original was GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_NV = 0x8E5E
        /// </summary>
        MinProgramTextureGatherOffsetNv = ((int)0x8E5E)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET = 0x8E5F
        /// </summary>
        MaxProgramTextureGatherOffset = ((int)0x8E5F)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_ARB = 0x8E5F
        /// </summary>
        MaxProgramTextureGatherOffsetArb = ((int)0x8E5F)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_NV = 0x8E5F
        /// </summary>
        MaxProgramTextureGatherOffsetNv = ((int)0x8E5F)        ,
        /// <summary>
        /// Original was GL_MAX_TRANSFORM_FEEDBACK_BUFFERS = 0x8E70
        /// </summary>
        MaxTransformFeedbackBuffers = ((int)0x8E70)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_STREAMS = 0x8E71
        /// </summary>
        MaxVertexStreams = ((int)0x8E71)        ,
        /// <summary>
        /// Original was GL_PATCH_VERTICES = 0x8E72
        /// </summary>
        PatchVertices = ((int)0x8E72)        ,
        /// <summary>
        /// Original was GL_PATCH_DEFAULT_INNER_LEVEL = 0x8E73
        /// </summary>
        PatchDefaultInnerLevel = ((int)0x8E73)        ,
        /// <summary>
        /// Original was GL_PATCH_DEFAULT_OUTER_LEVEL = 0x8E74
        /// </summary>
        PatchDefaultOuterLevel = ((int)0x8E74)        ,
        /// <summary>
        /// Original was GL_TESS_CONTROL_OUTPUT_VERTICES = 0x8E75
        /// </summary>
        TessControlOutputVertices = ((int)0x8E75)        ,
        /// <summary>
        /// Original was GL_TESS_GEN_MODE = 0x8E76
        /// </summary>
        TessGenMode = ((int)0x8E76)        ,
        /// <summary>
        /// Original was GL_TESS_GEN_SPACING = 0x8E77
        /// </summary>
        TessGenSpacing = ((int)0x8E77)        ,
        /// <summary>
        /// Original was GL_TESS_GEN_VERTEX_ORDER = 0x8E78
        /// </summary>
        TessGenVertexOrder = ((int)0x8E78)        ,
        /// <summary>
        /// Original was GL_TESS_GEN_POINT_MODE = 0x8E79
        /// </summary>
        TessGenPointMode = ((int)0x8E79)        ,
        /// <summary>
        /// Original was GL_ISOLINES = 0x8E7A
        /// </summary>
        Isolines = ((int)0x8E7A)        ,
        /// <summary>
        /// Original was GL_FRACTIONAL_ODD = 0x8E7B
        /// </summary>
        FractionalOdd = ((int)0x8E7B)        ,
        /// <summary>
        /// Original was GL_FRACTIONAL_EVEN = 0x8E7C
        /// </summary>
        FractionalEven = ((int)0x8E7C)        ,
        /// <summary>
        /// Original was GL_MAX_PATCH_VERTICES = 0x8E7D
        /// </summary>
        MaxPatchVertices = ((int)0x8E7D)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_GEN_LEVEL = 0x8E7E
        /// </summary>
        MaxTessGenLevel = ((int)0x8E7E)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS = 0x8E7F
        /// </summary>
        MaxTessControlUniformComponents = ((int)0x8E7F)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS = 0x8E80
        /// </summary>
        MaxTessEvaluationUniformComponents = ((int)0x8E80)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS = 0x8E81
        /// </summary>
        MaxTessControlTextureImageUnits = ((int)0x8E81)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS = 0x8E82
        /// </summary>
        MaxTessEvaluationTextureImageUnits = ((int)0x8E82)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS = 0x8E83
        /// </summary>
        MaxTessControlOutputComponents = ((int)0x8E83)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_PATCH_COMPONENTS = 0x8E84
        /// </summary>
        MaxTessPatchComponents = ((int)0x8E84)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS = 0x8E85
        /// </summary>
        MaxTessControlTotalOutputComponents = ((int)0x8E85)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS = 0x8E86
        /// </summary>
        MaxTessEvaluationOutputComponents = ((int)0x8E86)        ,
        /// <summary>
        /// Original was GL_TESS_EVALUATION_SHADER = 0x8E87
        /// </summary>
        TessEvaluationShader = ((int)0x8E87)        ,
        /// <summary>
        /// Original was GL_TESS_CONTROL_SHADER = 0x8E88
        /// </summary>
        TessControlShader = ((int)0x8E88)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS = 0x8E89
        /// </summary>
        MaxTessControlUniformBlocks = ((int)0x8E89)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS = 0x8E8A
        /// </summary>
        MaxTessEvaluationUniformBlocks = ((int)0x8E8A)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_BPTC_UNORM = 0x8E8C
        /// </summary>
        CompressedRgbaBptcUnorm = ((int)0x8E8C)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_BPTC_UNORM_ARB = 0x8E8C
        /// </summary>
        CompressedRgbaBptcUnormArb = ((int)0x8E8C)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM = 0x8E8D
        /// </summary>
        CompressedSrgbAlphaBptcUnorm = ((int)0x8E8D)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB = 0x8E8D
        /// </summary>
        CompressedSrgbAlphaBptcUnormArb = ((int)0x8E8D)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT = 0x8E8E
        /// </summary>
        CompressedRgbBptcSignedFloat = ((int)0x8E8E)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB = 0x8E8E
        /// </summary>
        CompressedRgbBptcSignedFloatArb = ((int)0x8E8E)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT = 0x8E8F
        /// </summary>
        CompressedRgbBptcUnsignedFloat = ((int)0x8E8F)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB = 0x8E8F
        /// </summary>
        CompressedRgbBptcUnsignedFloatArb = ((int)0x8E8F)        ,
        /// <summary>
        /// Original was GL_BUFFER_GPU_ADDRESS_NV = 0x8F1D
        /// </summary>
        BufferGpuAddressNv = ((int)0x8F1D)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_UNIFIED_NV = 0x8F1E
        /// </summary>
        VertexAttribArrayUnifiedNv = ((int)0x8F1E)        ,
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_UNIFIED_NV = 0x8F1F
        /// </summary>
        ElementArrayUnifiedNv = ((int)0x8F1F)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_ADDRESS_NV = 0x8F20
        /// </summary>
        VertexAttribArrayAddressNv = ((int)0x8F20)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_ADDRESS_NV = 0x8F21
        /// </summary>
        VertexArrayAddressNv = ((int)0x8F21)        ,
        /// <summary>
        /// Original was GL_NORMAL_ARRAY_ADDRESS_NV = 0x8F22
        /// </summary>
        NormalArrayAddressNv = ((int)0x8F22)        ,
        /// <summary>
        /// Original was GL_COLOR_ARRAY_ADDRESS_NV = 0x8F23
        /// </summary>
        ColorArrayAddressNv = ((int)0x8F23)        ,
        /// <summary>
        /// Original was GL_INDEX_ARRAY_ADDRESS_NV = 0x8F24
        /// </summary>
        IndexArrayAddressNv = ((int)0x8F24)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COORD_ARRAY_ADDRESS_NV = 0x8F25
        /// </summary>
        TextureCoordArrayAddressNv = ((int)0x8F25)        ,
        /// <summary>
        /// Original was GL_EDGE_FLAG_ARRAY_ADDRESS_NV = 0x8F26
        /// </summary>
        EdgeFlagArrayAddressNv = ((int)0x8F26)        ,
        /// <summary>
        /// Original was GL_SECONDARY_COLOR_ARRAY_ADDRESS_NV = 0x8F27
        /// </summary>
        SecondaryColorArrayAddressNv = ((int)0x8F27)        ,
        /// <summary>
        /// Original was GL_FOG_COORD_ARRAY_ADDRESS_NV = 0x8F28
        /// </summary>
        FogCoordArrayAddressNv = ((int)0x8F28)        ,
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_ADDRESS_NV = 0x8F29
        /// </summary>
        ElementArrayAddressNv = ((int)0x8F29)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_LENGTH_NV = 0x8F2A
        /// </summary>
        VertexAttribArrayLengthNv = ((int)0x8F2A)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_LENGTH_NV = 0x8F2B
        /// </summary>
        VertexArrayLengthNv = ((int)0x8F2B)        ,
        /// <summary>
        /// Original was GL_NORMAL_ARRAY_LENGTH_NV = 0x8F2C
        /// </summary>
        NormalArrayLengthNv = ((int)0x8F2C)        ,
        /// <summary>
        /// Original was GL_COLOR_ARRAY_LENGTH_NV = 0x8F2D
        /// </summary>
        ColorArrayLengthNv = ((int)0x8F2D)        ,
        /// <summary>
        /// Original was GL_INDEX_ARRAY_LENGTH_NV = 0x8F2E
        /// </summary>
        IndexArrayLengthNv = ((int)0x8F2E)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COORD_ARRAY_LENGTH_NV = 0x8F2F
        /// </summary>
        TextureCoordArrayLengthNv = ((int)0x8F2F)        ,
        /// <summary>
        /// Original was GL_EDGE_FLAG_ARRAY_LENGTH_NV = 0x8F30
        /// </summary>
        EdgeFlagArrayLengthNv = ((int)0x8F30)        ,
        /// <summary>
        /// Original was GL_SECONDARY_COLOR_ARRAY_LENGTH_NV = 0x8F31
        /// </summary>
        SecondaryColorArrayLengthNv = ((int)0x8F31)        ,
        /// <summary>
        /// Original was GL_FOG_COORD_ARRAY_LENGTH_NV = 0x8F32
        /// </summary>
        FogCoordArrayLengthNv = ((int)0x8F32)        ,
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_LENGTH_NV = 0x8F33
        /// </summary>
        ElementArrayLengthNv = ((int)0x8F33)        ,
        /// <summary>
        /// Original was GL_GPU_ADDRESS_NV = 0x8F34
        /// </summary>
        GpuAddressNv = ((int)0x8F34)        ,
        /// <summary>
        /// Original was GL_MAX_SHADER_BUFFER_ADDRESS_NV = 0x8F35
        /// </summary>
        MaxShaderBufferAddressNv = ((int)0x8F35)        ,
        /// <summary>
        /// Original was GL_COPY_READ_BUFFER = 0x8F36
        /// </summary>
        CopyReadBuffer = ((int)0x8F36)        ,
        /// <summary>
        /// Original was GL_COPY_READ_BUFFER_BINDING = 0x8F36
        /// </summary>
        CopyReadBufferBinding = ((int)0x8F36)        ,
        /// <summary>
        /// Original was GL_COPY_WRITE_BUFFER = 0x8F37
        /// </summary>
        CopyWriteBuffer = ((int)0x8F37)        ,
        /// <summary>
        /// Original was GL_COPY_WRITE_BUFFER_BINDING = 0x8F37
        /// </summary>
        CopyWriteBufferBinding = ((int)0x8F37)        ,
        /// <summary>
        /// Original was GL_MAX_IMAGE_UNITS = 0x8F38
        /// </summary>
        MaxImageUnits = ((int)0x8F38)        ,
        /// <summary>
        /// Original was GL_MAX_IMAGE_UNITS_EXT = 0x8F38
        /// </summary>
        MaxImageUnitsExt = ((int)0x8F38)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS = 0x8F39
        /// </summary>
        MaxCombinedImageUnitsAndFragmentOutputs = ((int)0x8F39)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS_EXT = 0x8F39
        /// </summary>
        MaxCombinedImageUnitsAndFragmentOutputsExt = ((int)0x8F39)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES = 0x8F39
        /// </summary>
        MaxCombinedShaderOutputResources = ((int)0x8F39)        ,
        /// <summary>
        /// Original was GL_IMAGE_BINDING_NAME = 0x8F3A
        /// </summary>
        ImageBindingName = ((int)0x8F3A)        ,
        /// <summary>
        /// Original was GL_IMAGE_BINDING_NAME_EXT = 0x8F3A
        /// </summary>
        ImageBindingNameExt = ((int)0x8F3A)        ,
        /// <summary>
        /// Original was GL_IMAGE_BINDING_LEVEL = 0x8F3B
        /// </summary>
        ImageBindingLevel = ((int)0x8F3B)        ,
        /// <summary>
        /// Original was GL_IMAGE_BINDING_LEVEL_EXT = 0x8F3B
        /// </summary>
        ImageBindingLevelExt = ((int)0x8F3B)        ,
        /// <summary>
        /// Original was GL_IMAGE_BINDING_LAYERED = 0x8F3C
        /// </summary>
        ImageBindingLayered = ((int)0x8F3C)        ,
        /// <summary>
        /// Original was GL_IMAGE_BINDING_LAYERED_EXT = 0x8F3C
        /// </summary>
        ImageBindingLayeredExt = ((int)0x8F3C)        ,
        /// <summary>
        /// Original was GL_IMAGE_BINDING_LAYER = 0x8F3D
        /// </summary>
        ImageBindingLayer = ((int)0x8F3D)        ,
        /// <summary>
        /// Original was GL_IMAGE_BINDING_LAYER_EXT = 0x8F3D
        /// </summary>
        ImageBindingLayerExt = ((int)0x8F3D)        ,
        /// <summary>
        /// Original was GL_IMAGE_BINDING_ACCESS = 0x8F3E
        /// </summary>
        ImageBindingAccess = ((int)0x8F3E)        ,
        /// <summary>
        /// Original was GL_IMAGE_BINDING_ACCESS_EXT = 0x8F3E
        /// </summary>
        ImageBindingAccessExt = ((int)0x8F3E)        ,
        /// <summary>
        /// Original was GL_DRAW_INDIRECT_BUFFER = 0x8F3F
        /// </summary>
        DrawIndirectBuffer = ((int)0x8F3F)        ,
        /// <summary>
        /// Original was GL_DRAW_INDIRECT_UNIFIED_NV = 0x8F40
        /// </summary>
        DrawIndirectUnifiedNv = ((int)0x8F40)        ,
        /// <summary>
        /// Original was GL_DRAW_INDIRECT_ADDRESS_NV = 0x8F41
        /// </summary>
        DrawIndirectAddressNv = ((int)0x8F41)        ,
        /// <summary>
        /// Original was GL_DRAW_INDIRECT_LENGTH_NV = 0x8F42
        /// </summary>
        DrawIndirectLengthNv = ((int)0x8F42)        ,
        /// <summary>
        /// Original was GL_DRAW_INDIRECT_BUFFER_BINDING = 0x8F43
        /// </summary>
        DrawIndirectBufferBinding = ((int)0x8F43)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_SUBROUTINE_PARAMETERS_NV = 0x8F44
        /// </summary>
        MaxProgramSubroutineParametersNv = ((int)0x8F44)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_SUBROUTINE_NUM_NV = 0x8F45
        /// </summary>
        MaxProgramSubroutineNumNv = ((int)0x8F45)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT2 = 0x8F46
        /// </summary>
        DoubleMat2 = ((int)0x8F46)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT2_EXT = 0x8F46
        /// </summary>
        DoubleMat2Ext = ((int)0x8F46)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT3 = 0x8F47
        /// </summary>
        DoubleMat3 = ((int)0x8F47)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT3_EXT = 0x8F47
        /// </summary>
        DoubleMat3Ext = ((int)0x8F47)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT4 = 0x8F48
        /// </summary>
        DoubleMat4 = ((int)0x8F48)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT4_EXT = 0x8F48
        /// </summary>
        DoubleMat4Ext = ((int)0x8F48)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT2x3 = 0x8F49
        /// </summary>
        DoubleMat2x3 = ((int)0x8F49)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT2x3_EXT = 0x8F49
        /// </summary>
        DoubleMat2x3Ext = ((int)0x8F49)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT2x4 = 0x8F4A
        /// </summary>
        DoubleMat2x4 = ((int)0x8F4A)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT2x4_EXT = 0x8F4A
        /// </summary>
        DoubleMat2x4Ext = ((int)0x8F4A)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT3x2 = 0x8F4B
        /// </summary>
        DoubleMat3x2 = ((int)0x8F4B)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT3x2_EXT = 0x8F4B
        /// </summary>
        DoubleMat3x2Ext = ((int)0x8F4B)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT3x4 = 0x8F4C
        /// </summary>
        DoubleMat3x4 = ((int)0x8F4C)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT3x4_EXT = 0x8F4C
        /// </summary>
        DoubleMat3x4Ext = ((int)0x8F4C)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT4x2 = 0x8F4D
        /// </summary>
        DoubleMat4x2 = ((int)0x8F4D)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT4x2_EXT = 0x8F4D
        /// </summary>
        DoubleMat4x2Ext = ((int)0x8F4D)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT4x3 = 0x8F4E
        /// </summary>
        DoubleMat4x3 = ((int)0x8F4E)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT4x3_EXT = 0x8F4E
        /// </summary>
        DoubleMat4x3Ext = ((int)0x8F4E)        ,
        /// <summary>
        /// Original was GL_VERTEX_BINDING_BUFFER = 0x8F4F
        /// </summary>
        VertexBindingBuffer = ((int)0x8F4F)        ,
        /// <summary>
        /// Original was GL_RED_SNORM = 0x8F90
        /// </summary>
        RedSnorm = ((int)0x8F90)        ,
        /// <summary>
        /// Original was GL_RG_SNORM = 0x8F91
        /// </summary>
        RgSnorm = ((int)0x8F91)        ,
        /// <summary>
        /// Original was GL_RGB_SNORM = 0x8F92
        /// </summary>
        RgbSnorm = ((int)0x8F92)        ,
        /// <summary>
        /// Original was GL_RGBA_SNORM = 0x8F93
        /// </summary>
        RgbaSnorm = ((int)0x8F93)        ,
        /// <summary>
        /// Original was GL_R8_SNORM = 0x8F94
        /// </summary>
        R8Snorm = ((int)0x8F94)        ,
        /// <summary>
        /// Original was GL_RG8_SNORM = 0x8F95
        /// </summary>
        Rg8Snorm = ((int)0x8F95)        ,
        /// <summary>
        /// Original was GL_RGB8_SNORM = 0x8F96
        /// </summary>
        Rgb8Snorm = ((int)0x8F96)        ,
        /// <summary>
        /// Original was GL_RGBA8_SNORM = 0x8F97
        /// </summary>
        Rgba8Snorm = ((int)0x8F97)        ,
        /// <summary>
        /// Original was GL_R16_SNORM = 0x8F98
        /// </summary>
        R16Snorm = ((int)0x8F98)        ,
        /// <summary>
        /// Original was GL_RG16_SNORM = 0x8F99
        /// </summary>
        Rg16Snorm = ((int)0x8F99)        ,
        /// <summary>
        /// Original was GL_RGB16_SNORM = 0x8F9A
        /// </summary>
        Rgb16Snorm = ((int)0x8F9A)        ,
        /// <summary>
        /// Original was GL_RGBA16_SNORM = 0x8F9B
        /// </summary>
        Rgba16Snorm = ((int)0x8F9B)        ,
        /// <summary>
        /// Original was GL_SIGNED_NORMALIZED = 0x8F9C
        /// </summary>
        SignedNormalized = ((int)0x8F9C)        ,
        /// <summary>
        /// Original was GL_PRIMITIVE_RESTART = 0x8F9D
        /// </summary>
        PrimitiveRestart = ((int)0x8F9D)        ,
        /// <summary>
        /// Original was GL_PRIMITIVE_RESTART_INDEX = 0x8F9E
        /// </summary>
        PrimitiveRestartIndex = ((int)0x8F9E)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB = 0x8F9F
        /// </summary>
        MaxProgramTextureGatherComponentsArb = ((int)0x8F9F)        ,
        /// <summary>
        /// Original was GL_BINNING_CONTROL_HINT_QCOM = 0x8FB0
        /// </summary>
        BinningControlHintQcom = ((int)0x8FB0)        ,
        /// <summary>
        /// Original was GL_INT8_NV = 0x8FE0
        /// </summary>
        Int8Nv = ((int)0x8FE0)        ,
        /// <summary>
        /// Original was GL_INT8_VEC2_NV = 0x8FE1
        /// </summary>
        Int8Vec2Nv = ((int)0x8FE1)        ,
        /// <summary>
        /// Original was GL_INT8_VEC3_NV = 0x8FE2
        /// </summary>
        Int8Vec3Nv = ((int)0x8FE2)        ,
        /// <summary>
        /// Original was GL_INT8_VEC4_NV = 0x8FE3
        /// </summary>
        Int8Vec4Nv = ((int)0x8FE3)        ,
        /// <summary>
        /// Original was GL_INT16_NV = 0x8FE4
        /// </summary>
        Int16Nv = ((int)0x8FE4)        ,
        /// <summary>
        /// Original was GL_INT16_VEC2_NV = 0x8FE5
        /// </summary>
        Int16Vec2Nv = ((int)0x8FE5)        ,
        /// <summary>
        /// Original was GL_INT16_VEC3_NV = 0x8FE6
        /// </summary>
        Int16Vec3Nv = ((int)0x8FE6)        ,
        /// <summary>
        /// Original was GL_INT16_VEC4_NV = 0x8FE7
        /// </summary>
        Int16Vec4Nv = ((int)0x8FE7)        ,
        /// <summary>
        /// Original was GL_INT64_VEC2_NV = 0x8FE9
        /// </summary>
        Int64Vec2Nv = ((int)0x8FE9)        ,
        /// <summary>
        /// Original was GL_INT64_VEC3_NV = 0x8FEA
        /// </summary>
        Int64Vec3Nv = ((int)0x8FEA)        ,
        /// <summary>
        /// Original was GL_INT64_VEC4_NV = 0x8FEB
        /// </summary>
        Int64Vec4Nv = ((int)0x8FEB)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT8_NV = 0x8FEC
        /// </summary>
        UnsignedInt8Nv = ((int)0x8FEC)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT8_VEC2_NV = 0x8FED
        /// </summary>
        UnsignedInt8Vec2Nv = ((int)0x8FED)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT8_VEC3_NV = 0x8FEE
        /// </summary>
        UnsignedInt8Vec3Nv = ((int)0x8FEE)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT8_VEC4_NV = 0x8FEF
        /// </summary>
        UnsignedInt8Vec4Nv = ((int)0x8FEF)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT16_NV = 0x8FF0
        /// </summary>
        UnsignedInt16Nv = ((int)0x8FF0)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT16_VEC2_NV = 0x8FF1
        /// </summary>
        UnsignedInt16Vec2Nv = ((int)0x8FF1)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT16_VEC3_NV = 0x8FF2
        /// </summary>
        UnsignedInt16Vec3Nv = ((int)0x8FF2)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT16_VEC4_NV = 0x8FF3
        /// </summary>
        UnsignedInt16Vec4Nv = ((int)0x8FF3)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT64_VEC2_NV = 0x8FF5
        /// </summary>
        UnsignedInt64Vec2Nv = ((int)0x8FF5)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT64_VEC3_NV = 0x8FF6
        /// </summary>
        UnsignedInt64Vec3Nv = ((int)0x8FF6)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT64_VEC4_NV = 0x8FF7
        /// </summary>
        UnsignedInt64Vec4Nv = ((int)0x8FF7)        ,
        /// <summary>
        /// Original was GL_FLOAT16_NV = 0x8FF8
        /// </summary>
        Float16Nv = ((int)0x8FF8)        ,
        /// <summary>
        /// Original was GL_FLOAT16_VEC2_NV = 0x8FF9
        /// </summary>
        Float16Vec2Nv = ((int)0x8FF9)        ,
        /// <summary>
        /// Original was GL_FLOAT16_VEC3_NV = 0x8FFA
        /// </summary>
        Float16Vec3Nv = ((int)0x8FFA)        ,
        /// <summary>
        /// Original was GL_FLOAT16_VEC4_NV = 0x8FFB
        /// </summary>
        Float16Vec4Nv = ((int)0x8FFB)        ,
        /// <summary>
        /// Original was GL_DOUBLE_VEC2 = 0x8FFC
        /// </summary>
        DoubleVec2 = ((int)0x8FFC)        ,
        /// <summary>
        /// Original was GL_DOUBLE_VEC2_EXT = 0x8FFC
        /// </summary>
        DoubleVec2Ext = ((int)0x8FFC)        ,
        /// <summary>
        /// Original was GL_DOUBLE_VEC3 = 0x8FFD
        /// </summary>
        DoubleVec3 = ((int)0x8FFD)        ,
        /// <summary>
        /// Original was GL_DOUBLE_VEC3_EXT = 0x8FFD
        /// </summary>
        DoubleVec3Ext = ((int)0x8FFD)        ,
        /// <summary>
        /// Original was GL_DOUBLE_VEC4 = 0x8FFE
        /// </summary>
        DoubleVec4 = ((int)0x8FFE)        ,
        /// <summary>
        /// Original was GL_DOUBLE_VEC4_EXT = 0x8FFE
        /// </summary>
        DoubleVec4Ext = ((int)0x8FFE)        ,
        /// <summary>
        /// Original was GL_SAMPLER_BUFFER_AMD = 0x9001
        /// </summary>
        SamplerBufferAmd = ((int)0x9001)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_BUFFER_AMD = 0x9002
        /// </summary>
        IntSamplerBufferAmd = ((int)0x9002)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_BUFFER_AMD = 0x9003
        /// </summary>
        UnsignedIntSamplerBufferAmd = ((int)0x9003)        ,
        /// <summary>
        /// Original was GL_TESSELLATION_MODE_AMD = 0x9004
        /// </summary>
        TessellationModeAmd = ((int)0x9004)        ,
        /// <summary>
        /// Original was GL_TESSELLATION_FACTOR_AMD = 0x9005
        /// </summary>
        TessellationFactorAmd = ((int)0x9005)        ,
        /// <summary>
        /// Original was GL_DISCRETE_AMD = 0x9006
        /// </summary>
        DiscreteAmd = ((int)0x9006)        ,
        /// <summary>
        /// Original was GL_CONTINUOUS_AMD = 0x9007
        /// </summary>
        ContinuousAmd = ((int)0x9007)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_ARRAY = 0x9009
        /// </summary>
        TextureCubeMapArray = ((int)0x9009)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_ARRAY_ARB = 0x9009
        /// </summary>
        TextureCubeMapArrayArb = ((int)0x9009)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_CUBE_MAP_ARRAY = 0x900A
        /// </summary>
        TextureBindingCubeMapArray = ((int)0x900A)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB = 0x900A
        /// </summary>
        TextureBindingCubeMapArrayArb = ((int)0x900A)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_CUBE_MAP_ARRAY = 0x900B
        /// </summary>
        ProxyTextureCubeMapArray = ((int)0x900B)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB = 0x900B
        /// </summary>
        ProxyTextureCubeMapArrayArb = ((int)0x900B)        ,
        /// <summary>
        /// Original was GL_SAMPLER_CUBE_MAP_ARRAY = 0x900C
        /// </summary>
        SamplerCubeMapArray = ((int)0x900C)        ,
        /// <summary>
        /// Original was GL_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900C
        /// </summary>
        SamplerCubeMapArrayArb = ((int)0x900C)        ,
        /// <summary>
        /// Original was GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW = 0x900D
        /// </summary>
        SamplerCubeMapArrayShadow = ((int)0x900D)        ,
        /// <summary>
        /// Original was GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_ARB = 0x900D
        /// </summary>
        SamplerCubeMapArrayShadowArb = ((int)0x900D)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_CUBE_MAP_ARRAY = 0x900E
        /// </summary>
        IntSamplerCubeMapArray = ((int)0x900E)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900E
        /// </summary>
        IntSamplerCubeMapArrayArb = ((int)0x900E)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY = 0x900F
        /// </summary>
        UnsignedIntSamplerCubeMapArray = ((int)0x900F)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900F
        /// </summary>
        UnsignedIntSamplerCubeMapArrayArb = ((int)0x900F)        ,
        /// <summary>
        /// Original was GL_ALPHA_SNORM = 0x9010
        /// </summary>
        AlphaSnorm = ((int)0x9010)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_SNORM = 0x9011
        /// </summary>
        LuminanceSnorm = ((int)0x9011)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ALPHA_SNORM = 0x9012
        /// </summary>
        LuminanceAlphaSnorm = ((int)0x9012)        ,
        /// <summary>
        /// Original was GL_INTENSITY_SNORM = 0x9013
        /// </summary>
        IntensitySnorm = ((int)0x9013)        ,
        /// <summary>
        /// Original was GL_ALPHA8_SNORM = 0x9014
        /// </summary>
        Alpha8Snorm = ((int)0x9014)        ,
        /// <summary>
        /// Original was GL_LUMINANCE8_SNORM = 0x9015
        /// </summary>
        Luminance8Snorm = ((int)0x9015)        ,
        /// <summary>
        /// Original was GL_LUMINANCE8_ALPHA8_SNORM = 0x9016
        /// </summary>
        Luminance8Alpha8Snorm = ((int)0x9016)        ,
        /// <summary>
        /// Original was GL_INTENSITY8_SNORM = 0x9017
        /// </summary>
        Intensity8Snorm = ((int)0x9017)        ,
        /// <summary>
        /// Original was GL_ALPHA16_SNORM = 0x9018
        /// </summary>
        Alpha16Snorm = ((int)0x9018)        ,
        /// <summary>
        /// Original was GL_LUMINANCE16_SNORM = 0x9019
        /// </summary>
        Luminance16Snorm = ((int)0x9019)        ,
        /// <summary>
        /// Original was GL_LUMINANCE16_ALPHA16_SNORM = 0x901A
        /// </summary>
        Luminance16Alpha16Snorm = ((int)0x901A)        ,
        /// <summary>
        /// Original was GL_INTENSITY16_SNORM = 0x901B
        /// </summary>
        Intensity16Snorm = ((int)0x901B)        ,
        /// <summary>
        /// Original was GL_FACTOR_MIN_AMD = 0x901C
        /// </summary>
        FactorMinAmd = ((int)0x901C)        ,
        /// <summary>
        /// Original was GL_FACTOR_MAX_AMD = 0x901D
        /// </summary>
        FactorMaxAmd = ((int)0x901D)        ,
        /// <summary>
        /// Original was GL_DEPTH_CLAMP_NEAR_AMD = 0x901E
        /// </summary>
        DepthClampNearAmd = ((int)0x901E)        ,
        /// <summary>
        /// Original was GL_DEPTH_CLAMP_FAR_AMD = 0x901F
        /// </summary>
        DepthClampFarAmd = ((int)0x901F)        ,
        /// <summary>
        /// Original was GL_VIDEO_BUFFER_NV = 0x9020
        /// </summary>
        VideoBufferNv = ((int)0x9020)        ,
        /// <summary>
        /// Original was GL_VIDEO_BUFFER_BINDING_NV = 0x9021
        /// </summary>
        VideoBufferBindingNv = ((int)0x9021)        ,
        /// <summary>
        /// Original was GL_FIELD_UPPER_NV = 0x9022
        /// </summary>
        FieldUpperNv = ((int)0x9022)        ,
        /// <summary>
        /// Original was GL_FIELD_LOWER_NV = 0x9023
        /// </summary>
        FieldLowerNv = ((int)0x9023)        ,
        /// <summary>
        /// Original was GL_NUM_VIDEO_CAPTURE_STREAMS_NV = 0x9024
        /// </summary>
        NumVideoCaptureStreamsNv = ((int)0x9024)        ,
        /// <summary>
        /// Original was GL_NEXT_VIDEO_CAPTURE_BUFFER_STATUS_NV = 0x9025
        /// </summary>
        NextVideoCaptureBufferStatusNv = ((int)0x9025)        ,
        /// <summary>
        /// Original was GL_VIDEO_CAPTURE_TO_422_SUPPORTED_NV = 0x9026
        /// </summary>
        VideoCaptureTo422SupportedNv = ((int)0x9026)        ,
        /// <summary>
        /// Original was GL_LAST_VIDEO_CAPTURE_STATUS_NV = 0x9027
        /// </summary>
        LastVideoCaptureStatusNv = ((int)0x9027)        ,
        /// <summary>
        /// Original was GL_VIDEO_BUFFER_PITCH_NV = 0x9028
        /// </summary>
        VideoBufferPitchNv = ((int)0x9028)        ,
        /// <summary>
        /// Original was GL_VIDEO_COLOR_CONVERSION_MATRIX_NV = 0x9029
        /// </summary>
        VideoColorConversionMatrixNv = ((int)0x9029)        ,
        /// <summary>
        /// Original was GL_VIDEO_COLOR_CONVERSION_MAX_NV = 0x902A
        /// </summary>
        VideoColorConversionMaxNv = ((int)0x902A)        ,
        /// <summary>
        /// Original was GL_VIDEO_COLOR_CONVERSION_MIN_NV = 0x902B
        /// </summary>
        VideoColorConversionMinNv = ((int)0x902B)        ,
        /// <summary>
        /// Original was GL_VIDEO_COLOR_CONVERSION_OFFSET_NV = 0x902C
        /// </summary>
        VideoColorConversionOffsetNv = ((int)0x902C)        ,
        /// <summary>
        /// Original was GL_VIDEO_BUFFER_INTERNAL_FORMAT_NV = 0x902D
        /// </summary>
        VideoBufferInternalFormatNv = ((int)0x902D)        ,
        /// <summary>
        /// Original was GL_PARTIAL_SUCCESS_NV = 0x902E
        /// </summary>
        PartialSuccessNv = ((int)0x902E)        ,
        /// <summary>
        /// Original was GL_SUCCESS_NV = 0x902F
        /// </summary>
        SuccessNv = ((int)0x902F)        ,
        /// <summary>
        /// Original was GL_FAILURE_NV = 0x9030
        /// </summary>
        FailureNv = ((int)0x9030)        ,
        /// <summary>
        /// Original was GL_YCBYCR8_422_NV = 0x9031
        /// </summary>
        Ycbycr8422Nv = ((int)0x9031)        ,
        /// <summary>
        /// Original was GL_YCBAYCR8A_4224_NV = 0x9032
        /// </summary>
        Ycbaycr8A4224Nv = ((int)0x9032)        ,
        /// <summary>
        /// Original was GL_Z6Y10Z6CB10Z6Y10Z6CR10_422_NV = 0x9033
        /// </summary>
        Z6y10z6cb10z6y10z6cr10422Nv = ((int)0x9033)        ,
        /// <summary>
        /// Original was GL_Z6Y10Z6CB10Z6A10Z6Y10Z6CR10Z6A10_4224_NV = 0x9034
        /// </summary>
        Z6y10z6cb10z6A10z6y10z6cr10z6A104224Nv = ((int)0x9034)        ,
        /// <summary>
        /// Original was GL_Z4Y12Z4CB12Z4Y12Z4CR12_422_NV = 0x9035
        /// </summary>
        Z4y12z4cb12z4y12z4cr12422Nv = ((int)0x9035)        ,
        /// <summary>
        /// Original was GL_Z4Y12Z4CB12Z4A12Z4Y12Z4CR12Z4A12_4224_NV = 0x9036
        /// </summary>
        Z4y12z4cb12z4A12z4y12z4cr12z4A124224Nv = ((int)0x9036)        ,
        /// <summary>
        /// Original was GL_Z4Y12Z4CB12Z4CR12_444_NV = 0x9037
        /// </summary>
        Z4y12z4cb12z4cr12444Nv = ((int)0x9037)        ,
        /// <summary>
        /// Original was GL_VIDEO_CAPTURE_FRAME_WIDTH_NV = 0x9038
        /// </summary>
        VideoCaptureFrameWidthNv = ((int)0x9038)        ,
        /// <summary>
        /// Original was GL_VIDEO_CAPTURE_FRAME_HEIGHT_NV = 0x9039
        /// </summary>
        VideoCaptureFrameHeightNv = ((int)0x9039)        ,
        /// <summary>
        /// Original was GL_VIDEO_CAPTURE_FIELD_UPPER_HEIGHT_NV = 0x903A
        /// </summary>
        VideoCaptureFieldUpperHeightNv = ((int)0x903A)        ,
        /// <summary>
        /// Original was GL_VIDEO_CAPTURE_FIELD_LOWER_HEIGHT_NV = 0x903B
        /// </summary>
        VideoCaptureFieldLowerHeightNv = ((int)0x903B)        ,
        /// <summary>
        /// Original was GL_VIDEO_CAPTURE_SURFACE_ORIGIN_NV = 0x903C
        /// </summary>
        VideoCaptureSurfaceOriginNv = ((int)0x903C)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COVERAGE_SAMPLES_NV = 0x9045
        /// </summary>
        TextureCoverageSamplesNv = ((int)0x9045)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COLOR_SAMPLES_NV = 0x9046
        /// </summary>
        TextureColorSamplesNv = ((int)0x9046)        ,
        /// <summary>
        /// Original was GL_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX = 0x9047
        /// </summary>
        GpuMemoryInfoDedicatedVidmemNvx = ((int)0x9047)        ,
        /// <summary>
        /// Original was GL_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX = 0x9048
        /// </summary>
        GpuMemoryInfoTotalAvailableMemoryNvx = ((int)0x9048)        ,
        /// <summary>
        /// Original was GL_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX = 0x9049
        /// </summary>
        GpuMemoryInfoCurrentAvailableVidmemNvx = ((int)0x9049)        ,
        /// <summary>
        /// Original was GL_GPU_MEMORY_INFO_EVICTION_COUNT_NVX = 0x904A
        /// </summary>
        GpuMemoryInfoEvictionCountNvx = ((int)0x904A)        ,
        /// <summary>
        /// Original was GL_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX = 0x904B
        /// </summary>
        GpuMemoryInfoEvictedMemoryNvx = ((int)0x904B)        ,
        /// <summary>
        /// Original was GL_IMAGE_1D = 0x904C
        /// </summary>
        Image1D = ((int)0x904C)        ,
        /// <summary>
        /// Original was GL_IMAGE_1D_EXT = 0x904C
        /// </summary>
        Image1DExt = ((int)0x904C)        ,
        /// <summary>
        /// Original was GL_IMAGE_2D = 0x904D
        /// </summary>
        Image2D = ((int)0x904D)        ,
        /// <summary>
        /// Original was GL_IMAGE_2D_EXT = 0x904D
        /// </summary>
        Image2DExt = ((int)0x904D)        ,
        /// <summary>
        /// Original was GL_IMAGE_3D = 0x904E
        /// </summary>
        Image3D = ((int)0x904E)        ,
        /// <summary>
        /// Original was GL_IMAGE_3D_EXT = 0x904E
        /// </summary>
        Image3DExt = ((int)0x904E)        ,
        /// <summary>
        /// Original was GL_IMAGE_2D_RECT = 0x904F
        /// </summary>
        Image2DRect = ((int)0x904F)        ,
        /// <summary>
        /// Original was GL_IMAGE_2D_RECT_EXT = 0x904F
        /// </summary>
        Image2DRectExt = ((int)0x904F)        ,
        /// <summary>
        /// Original was GL_IMAGE_CUBE = 0x9050
        /// </summary>
        ImageCube = ((int)0x9050)        ,
        /// <summary>
        /// Original was GL_IMAGE_CUBE_EXT = 0x9050
        /// </summary>
        ImageCubeExt = ((int)0x9050)        ,
        /// <summary>
        /// Original was GL_IMAGE_BUFFER = 0x9051
        /// </summary>
        ImageBuffer = ((int)0x9051)        ,
        /// <summary>
        /// Original was GL_IMAGE_BUFFER_EXT = 0x9051
        /// </summary>
        ImageBufferExt = ((int)0x9051)        ,
        /// <summary>
        /// Original was GL_IMAGE_1D_ARRAY = 0x9052
        /// </summary>
        Image1DArray = ((int)0x9052)        ,
        /// <summary>
        /// Original was GL_IMAGE_1D_ARRAY_EXT = 0x9052
        /// </summary>
        Image1DArrayExt = ((int)0x9052)        ,
        /// <summary>
        /// Original was GL_IMAGE_2D_ARRAY = 0x9053
        /// </summary>
        Image2DArray = ((int)0x9053)        ,
        /// <summary>
        /// Original was GL_IMAGE_2D_ARRAY_EXT = 0x9053
        /// </summary>
        Image2DArrayExt = ((int)0x9053)        ,
        /// <summary>
        /// Original was GL_IMAGE_CUBE_MAP_ARRAY = 0x9054
        /// </summary>
        ImageCubeMapArray = ((int)0x9054)        ,
        /// <summary>
        /// Original was GL_IMAGE_CUBE_MAP_ARRAY_EXT = 0x9054
        /// </summary>
        ImageCubeMapArrayExt = ((int)0x9054)        ,
        /// <summary>
        /// Original was GL_IMAGE_2D_MULTISAMPLE = 0x9055
        /// </summary>
        Image2DMultisample = ((int)0x9055)        ,
        /// <summary>
        /// Original was GL_IMAGE_2D_MULTISAMPLE_EXT = 0x9055
        /// </summary>
        Image2DMultisampleExt = ((int)0x9055)        ,
        /// <summary>
        /// Original was GL_IMAGE_2D_MULTISAMPLE_ARRAY = 0x9056
        /// </summary>
        Image2DMultisampleArray = ((int)0x9056)        ,
        /// <summary>
        /// Original was GL_IMAGE_2D_MULTISAMPLE_ARRAY_EXT = 0x9056
        /// </summary>
        Image2DMultisampleArrayExt = ((int)0x9056)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_1D = 0x9057
        /// </summary>
        IntImage1D = ((int)0x9057)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_1D_EXT = 0x9057
        /// </summary>
        IntImage1DExt = ((int)0x9057)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_2D = 0x9058
        /// </summary>
        IntImage2D = ((int)0x9058)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_2D_EXT = 0x9058
        /// </summary>
        IntImage2DExt = ((int)0x9058)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_3D = 0x9059
        /// </summary>
        IntImage3D = ((int)0x9059)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_3D_EXT = 0x9059
        /// </summary>
        IntImage3DExt = ((int)0x9059)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_2D_RECT = 0x905A
        /// </summary>
        IntImage2DRect = ((int)0x905A)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_2D_RECT_EXT = 0x905A
        /// </summary>
        IntImage2DRectExt = ((int)0x905A)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_CUBE = 0x905B
        /// </summary>
        IntImageCube = ((int)0x905B)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_CUBE_EXT = 0x905B
        /// </summary>
        IntImageCubeExt = ((int)0x905B)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_BUFFER = 0x905C
        /// </summary>
        IntImageBuffer = ((int)0x905C)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_BUFFER_EXT = 0x905C
        /// </summary>
        IntImageBufferExt = ((int)0x905C)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_1D_ARRAY = 0x905D
        /// </summary>
        IntImage1DArray = ((int)0x905D)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_1D_ARRAY_EXT = 0x905D
        /// </summary>
        IntImage1DArrayExt = ((int)0x905D)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_2D_ARRAY = 0x905E
        /// </summary>
        IntImage2DArray = ((int)0x905E)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_2D_ARRAY_EXT = 0x905E
        /// </summary>
        IntImage2DArrayExt = ((int)0x905E)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_CUBE_MAP_ARRAY = 0x905F
        /// </summary>
        IntImageCubeMapArray = ((int)0x905F)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_CUBE_MAP_ARRAY_EXT = 0x905F
        /// </summary>
        IntImageCubeMapArrayExt = ((int)0x905F)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_2D_MULTISAMPLE = 0x9060
        /// </summary>
        IntImage2DMultisample = ((int)0x9060)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_2D_MULTISAMPLE_EXT = 0x9060
        /// </summary>
        IntImage2DMultisampleExt = ((int)0x9060)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY = 0x9061
        /// </summary>
        IntImage2DMultisampleArray = ((int)0x9061)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT = 0x9061
        /// </summary>
        IntImage2DMultisampleArrayExt = ((int)0x9061)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_1D = 0x9062
        /// </summary>
        UnsignedIntImage1D = ((int)0x9062)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_1D_EXT = 0x9062
        /// </summary>
        UnsignedIntImage1DExt = ((int)0x9062)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_2D = 0x9063
        /// </summary>
        UnsignedIntImage2D = ((int)0x9063)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_2D_EXT = 0x9063
        /// </summary>
        UnsignedIntImage2DExt = ((int)0x9063)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_3D = 0x9064
        /// </summary>
        UnsignedIntImage3D = ((int)0x9064)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_3D_EXT = 0x9064
        /// </summary>
        UnsignedIntImage3DExt = ((int)0x9064)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_2D_RECT = 0x9065
        /// </summary>
        UnsignedIntImage2DRect = ((int)0x9065)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_2D_RECT_EXT = 0x9065
        /// </summary>
        UnsignedIntImage2DRectExt = ((int)0x9065)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_CUBE = 0x9066
        /// </summary>
        UnsignedIntImageCube = ((int)0x9066)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_CUBE_EXT = 0x9066
        /// </summary>
        UnsignedIntImageCubeExt = ((int)0x9066)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_BUFFER = 0x9067
        /// </summary>
        UnsignedIntImageBuffer = ((int)0x9067)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_BUFFER_EXT = 0x9067
        /// </summary>
        UnsignedIntImageBufferExt = ((int)0x9067)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_1D_ARRAY = 0x9068
        /// </summary>
        UnsignedIntImage1DArray = ((int)0x9068)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_1D_ARRAY_EXT = 0x9068
        /// </summary>
        UnsignedIntImage1DArrayExt = ((int)0x9068)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_2D_ARRAY = 0x9069
        /// </summary>
        UnsignedIntImage2DArray = ((int)0x9069)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_2D_ARRAY_EXT = 0x9069
        /// </summary>
        UnsignedIntImage2DArrayExt = ((int)0x9069)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY = 0x906A
        /// </summary>
        UnsignedIntImageCubeMapArray = ((int)0x906A)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_EXT = 0x906A
        /// </summary>
        UnsignedIntImageCubeMapArrayExt = ((int)0x906A)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE = 0x906B
        /// </summary>
        UnsignedIntImage2DMultisample = ((int)0x906B)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_EXT = 0x906B
        /// </summary>
        UnsignedIntImage2DMultisampleExt = ((int)0x906B)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY = 0x906C
        /// </summary>
        UnsignedIntImage2DMultisampleArray = ((int)0x906C)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT = 0x906C
        /// </summary>
        UnsignedIntImage2DMultisampleArrayExt = ((int)0x906C)        ,
        /// <summary>
        /// Original was GL_MAX_IMAGE_SAMPLES = 0x906D
        /// </summary>
        MaxImageSamples = ((int)0x906D)        ,
        /// <summary>
        /// Original was GL_MAX_IMAGE_SAMPLES_EXT = 0x906D
        /// </summary>
        MaxImageSamplesExt = ((int)0x906D)        ,
        /// <summary>
        /// Original was GL_IMAGE_BINDING_FORMAT = 0x906E
        /// </summary>
        ImageBindingFormat = ((int)0x906E)        ,
        /// <summary>
        /// Original was GL_IMAGE_BINDING_FORMAT_EXT = 0x906E
        /// </summary>
        ImageBindingFormatExt = ((int)0x906E)        ,
        /// <summary>
        /// Original was GL_RGB10_A2UI = 0x906F
        /// </summary>
        Rgb10A2ui = ((int)0x906F)        ,
        /// <summary>
        /// Original was GL_PATH_FORMAT_SVG_NV = 0x9070
        /// </summary>
        PathFormatSvgNv = ((int)0x9070)        ,
        /// <summary>
        /// Original was GL_PATH_FORMAT_PS_NV = 0x9071
        /// </summary>
        PathFormatPsNv = ((int)0x9071)        ,
        /// <summary>
        /// Original was GL_STANDARD_FONT_NAME_NV = 0x9072
        /// </summary>
        StandardFontNameNv = ((int)0x9072)        ,
        /// <summary>
        /// Original was GL_SYSTEM_FONT_NAME_NV = 0x9073
        /// </summary>
        SystemFontNameNv = ((int)0x9073)        ,
        /// <summary>
        /// Original was GL_FILE_NAME_NV = 0x9074
        /// </summary>
        FileNameNv = ((int)0x9074)        ,
        /// <summary>
        /// Original was GL_PATH_STROKE_WIDTH_NV = 0x9075
        /// </summary>
        PathStrokeWidthNv = ((int)0x9075)        ,
        /// <summary>
        /// Original was GL_PATH_END_CAPS_NV = 0x9076
        /// </summary>
        PathEndCapsNv = ((int)0x9076)        ,
        /// <summary>
        /// Original was GL_PATH_INITIAL_END_CAP_NV = 0x9077
        /// </summary>
        PathInitialEndCapNv = ((int)0x9077)        ,
        /// <summary>
        /// Original was GL_PATH_TERMINAL_END_CAP_NV = 0x9078
        /// </summary>
        PathTerminalEndCapNv = ((int)0x9078)        ,
        /// <summary>
        /// Original was GL_PATH_JOIN_STYLE_NV = 0x9079
        /// </summary>
        PathJoinStyleNv = ((int)0x9079)        ,
        /// <summary>
        /// Original was GL_PATH_MITER_LIMIT_NV = 0x907A
        /// </summary>
        PathMiterLimitNv = ((int)0x907A)        ,
        /// <summary>
        /// Original was GL_PATH_DASH_CAPS_NV = 0x907B
        /// </summary>
        PathDashCapsNv = ((int)0x907B)        ,
        /// <summary>
        /// Original was GL_PATH_INITIAL_DASH_CAP_NV = 0x907C
        /// </summary>
        PathInitialDashCapNv = ((int)0x907C)        ,
        /// <summary>
        /// Original was GL_PATH_TERMINAL_DASH_CAP_NV = 0x907D
        /// </summary>
        PathTerminalDashCapNv = ((int)0x907D)        ,
        /// <summary>
        /// Original was GL_PATH_DASH_OFFSET_NV = 0x907E
        /// </summary>
        PathDashOffsetNv = ((int)0x907E)        ,
        /// <summary>
        /// Original was GL_PATH_CLIENT_LENGTH_NV = 0x907F
        /// </summary>
        PathClientLengthNv = ((int)0x907F)        ,
        /// <summary>
        /// Original was GL_PATH_FILL_MODE_NV = 0x9080
        /// </summary>
        PathFillModeNv = ((int)0x9080)        ,
        /// <summary>
        /// Original was GL_PATH_FILL_MASK_NV = 0x9081
        /// </summary>
        PathFillMaskNv = ((int)0x9081)        ,
        /// <summary>
        /// Original was GL_PATH_FILL_COVER_MODE_NV = 0x9082
        /// </summary>
        PathFillCoverModeNv = ((int)0x9082)        ,
        /// <summary>
        /// Original was GL_PATH_STROKE_COVER_MODE_NV = 0x9083
        /// </summary>
        PathStrokeCoverModeNv = ((int)0x9083)        ,
        /// <summary>
        /// Original was GL_PATH_STROKE_MASK_NV = 0x9084
        /// </summary>
        PathStrokeMaskNv = ((int)0x9084)        ,
        /// <summary>
        /// Original was GL_COUNT_UP_NV = 0x9088
        /// </summary>
        CountUpNv = ((int)0x9088)        ,
        /// <summary>
        /// Original was GL_COUNT_DOWN_NV = 0x9089
        /// </summary>
        CountDownNv = ((int)0x9089)        ,
        /// <summary>
        /// Original was GL_PATH_OBJECT_BOUNDING_BOX_NV = 0x908A
        /// </summary>
        PathObjectBoundingBoxNv = ((int)0x908A)        ,
        /// <summary>
        /// Original was GL_CONVEX_HULL_NV = 0x908B
        /// </summary>
        ConvexHullNv = ((int)0x908B)        ,
        /// <summary>
        /// Original was GL_BOUNDING_BOX_NV = 0x908D
        /// </summary>
        BoundingBoxNv = ((int)0x908D)        ,
        /// <summary>
        /// Original was GL_TRANSLATE_X_NV = 0x908E
        /// </summary>
        TranslateXNv = ((int)0x908E)        ,
        /// <summary>
        /// Original was GL_TRANSLATE_Y_NV = 0x908F
        /// </summary>
        TranslateYNv = ((int)0x908F)        ,
        /// <summary>
        /// Original was GL_TRANSLATE_2D_NV = 0x9090
        /// </summary>
        Translate2DNv = ((int)0x9090)        ,
        /// <summary>
        /// Original was GL_TRANSLATE_3D_NV = 0x9091
        /// </summary>
        Translate3DNv = ((int)0x9091)        ,
        /// <summary>
        /// Original was GL_AFFINE_2D_NV = 0x9092
        /// </summary>
        Affine2DNv = ((int)0x9092)        ,
        /// <summary>
        /// Original was GL_AFFINE_3D_NV = 0x9094
        /// </summary>
        Affine3DNv = ((int)0x9094)        ,
        /// <summary>
        /// Original was GL_TRANSPOSE_AFFINE_2D_NV = 0x9096
        /// </summary>
        TransposeAffine2DNv = ((int)0x9096)        ,
        /// <summary>
        /// Original was GL_TRANSPOSE_AFFINE_3D_NV = 0x9098
        /// </summary>
        TransposeAffine3DNv = ((int)0x9098)        ,
        /// <summary>
        /// Original was GL_UTF8_NV = 0x909A
        /// </summary>
        Utf8Nv = ((int)0x909A)        ,
        /// <summary>
        /// Original was GL_UTF16_NV = 0x909B
        /// </summary>
        Utf16Nv = ((int)0x909B)        ,
        /// <summary>
        /// Original was GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV = 0x909C
        /// </summary>
        BoundingBoxOfBoundingBoxesNv = ((int)0x909C)        ,
        /// <summary>
        /// Original was GL_PATH_COMMAND_COUNT_NV = 0x909D
        /// </summary>
        PathCommandCountNv = ((int)0x909D)        ,
        /// <summary>
        /// Original was GL_PATH_COORD_COUNT_NV = 0x909E
        /// </summary>
        PathCoordCountNv = ((int)0x909E)        ,
        /// <summary>
        /// Original was GL_PATH_DASH_ARRAY_COUNT_NV = 0x909F
        /// </summary>
        PathDashArrayCountNv = ((int)0x909F)        ,
        /// <summary>
        /// Original was GL_PATH_COMPUTED_LENGTH_NV = 0x90A0
        /// </summary>
        PathComputedLengthNv = ((int)0x90A0)        ,
        /// <summary>
        /// Original was GL_PATH_FILL_BOUNDING_BOX_NV = 0x90A1
        /// </summary>
        PathFillBoundingBoxNv = ((int)0x90A1)        ,
        /// <summary>
        /// Original was GL_PATH_STROKE_BOUNDING_BOX_NV = 0x90A2
        /// </summary>
        PathStrokeBoundingBoxNv = ((int)0x90A2)        ,
        /// <summary>
        /// Original was GL_SQUARE_NV = 0x90A3
        /// </summary>
        SquareNv = ((int)0x90A3)        ,
        /// <summary>
        /// Original was GL_ROUND_NV = 0x90A4
        /// </summary>
        RoundNv = ((int)0x90A4)        ,
        /// <summary>
        /// Original was GL_TRIANGULAR_NV = 0x90A5
        /// </summary>
        TriangularNv = ((int)0x90A5)        ,
        /// <summary>
        /// Original was GL_BEVEL_NV = 0x90A6
        /// </summary>
        BevelNv = ((int)0x90A6)        ,
        /// <summary>
        /// Original was GL_MITER_REVERT_NV = 0x90A7
        /// </summary>
        MiterRevertNv = ((int)0x90A7)        ,
        /// <summary>
        /// Original was GL_MITER_TRUNCATE_NV = 0x90A8
        /// </summary>
        MiterTruncateNv = ((int)0x90A8)        ,
        /// <summary>
        /// Original was GL_SKIP_MISSING_GLYPH_NV = 0x90A9
        /// </summary>
        SkipMissingGlyphNv = ((int)0x90A9)        ,
        /// <summary>
        /// Original was GL_USE_MISSING_GLYPH_NV = 0x90AA
        /// </summary>
        UseMissingGlyphNv = ((int)0x90AA)        ,
        /// <summary>
        /// Original was GL_PATH_ERROR_POSITION_NV = 0x90AB
        /// </summary>
        PathErrorPositionNv = ((int)0x90AB)        ,
        /// <summary>
        /// Original was GL_PATH_FOG_GEN_MODE_NV = 0x90AC
        /// </summary>
        PathFogGenModeNv = ((int)0x90AC)        ,
        /// <summary>
        /// Original was GL_ACCUM_ADJACENT_PAIRS_NV = 0x90AD
        /// </summary>
        AccumAdjacentPairsNv = ((int)0x90AD)        ,
        /// <summary>
        /// Original was GL_ADJACENT_PAIRS_NV = 0x90AE
        /// </summary>
        AdjacentPairsNv = ((int)0x90AE)        ,
        /// <summary>
        /// Original was GL_FIRST_TO_REST_NV = 0x90AF
        /// </summary>
        FirstToRestNv = ((int)0x90AF)        ,
        /// <summary>
        /// Original was GL_PATH_GEN_MODE_NV = 0x90B0
        /// </summary>
        PathGenModeNv = ((int)0x90B0)        ,
        /// <summary>
        /// Original was GL_PATH_GEN_COEFF_NV = 0x90B1
        /// </summary>
        PathGenCoeffNv = ((int)0x90B1)        ,
        /// <summary>
        /// Original was GL_PATH_GEN_COLOR_FORMAT_NV = 0x90B2
        /// </summary>
        PathGenColorFormatNv = ((int)0x90B2)        ,
        /// <summary>
        /// Original was GL_PATH_GEN_COMPONENTS_NV = 0x90B3
        /// </summary>
        PathGenComponentsNv = ((int)0x90B3)        ,
        /// <summary>
        /// Original was GL_PATH_DASH_OFFSET_RESET_NV = 0x90B4
        /// </summary>
        PathDashOffsetResetNv = ((int)0x90B4)        ,
        /// <summary>
        /// Original was GL_MOVE_TO_RESETS_NV = 0x90B5
        /// </summary>
        MoveToResetsNv = ((int)0x90B5)        ,
        /// <summary>
        /// Original was GL_MOVE_TO_CONTINUES_NV = 0x90B6
        /// </summary>
        MoveToContinuesNv = ((int)0x90B6)        ,
        /// <summary>
        /// Original was GL_PATH_STENCIL_FUNC_NV = 0x90B7
        /// </summary>
        PathStencilFuncNv = ((int)0x90B7)        ,
        /// <summary>
        /// Original was GL_PATH_STENCIL_REF_NV = 0x90B8
        /// </summary>
        PathStencilRefNv = ((int)0x90B8)        ,
        /// <summary>
        /// Original was GL_PATH_STENCIL_VALUE_MASK_NV = 0x90B9
        /// </summary>
        PathStencilValueMaskNv = ((int)0x90B9)        ,
        /// <summary>
        /// Original was GL_SCALED_RESOLVE_FASTEST_EXT = 0x90BA
        /// </summary>
        ScaledResolveFastestExt = ((int)0x90BA)        ,
        /// <summary>
        /// Original was GL_SCALED_RESOLVE_NICEST_EXT = 0x90BB
        /// </summary>
        ScaledResolveNicestExt = ((int)0x90BB)        ,
        /// <summary>
        /// Original was GL_MIN_MAP_BUFFER_ALIGNMENT = 0x90BC
        /// </summary>
        MinMapBufferAlignment = ((int)0x90BC)        ,
        /// <summary>
        /// Original was GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV = 0x90BD
        /// </summary>
        PathStencilDepthOffsetFactorNv = ((int)0x90BD)        ,
        /// <summary>
        /// Original was GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV = 0x90BE
        /// </summary>
        PathStencilDepthOffsetUnitsNv = ((int)0x90BE)        ,
        /// <summary>
        /// Original was GL_PATH_COVER_DEPTH_FUNC_NV = 0x90BF
        /// </summary>
        PathCoverDepthFuncNv = ((int)0x90BF)        ,
        /// <summary>
        /// Original was GL_IMAGE_FORMAT_COMPATIBILITY_TYPE = 0x90C7
        /// </summary>
        ImageFormatCompatibilityType = ((int)0x90C7)        ,
        /// <summary>
        /// Original was GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE = 0x90C8
        /// </summary>
        ImageFormatCompatibilityBySize = ((int)0x90C8)        ,
        /// <summary>
        /// Original was GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS = 0x90C9
        /// </summary>
        ImageFormatCompatibilityByClass = ((int)0x90C9)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_IMAGE_UNIFORMS = 0x90CA
        /// </summary>
        MaxVertexImageUniforms = ((int)0x90CA)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS = 0x90CB
        /// </summary>
        MaxTessControlImageUniforms = ((int)0x90CB)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS = 0x90CC
        /// </summary>
        MaxTessEvaluationImageUniforms = ((int)0x90CC)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_IMAGE_UNIFORMS = 0x90CD
        /// </summary>
        MaxGeometryImageUniforms = ((int)0x90CD)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_IMAGE_UNIFORMS = 0x90CE
        /// </summary>
        MaxFragmentImageUniforms = ((int)0x90CE)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_IMAGE_UNIFORMS = 0x90CF
        /// </summary>
        MaxCombinedImageUniforms = ((int)0x90CF)        ,
        /// <summary>
        /// Original was GL_MAX_DEEP_3D_TEXTURE_WIDTH_HEIGHT_NV = 0x90D0
        /// </summary>
        MaxDeep3DTextureWidthHeightNv = ((int)0x90D0)        ,
        /// <summary>
        /// Original was GL_MAX_DEEP_3D_TEXTURE_DEPTH_NV = 0x90D1
        /// </summary>
        MaxDeep3DTextureDepthNv = ((int)0x90D1)        ,
        /// <summary>
        /// Original was GL_SHADER_STORAGE_BUFFER = 0x90D2
        /// </summary>
        ShaderStorageBuffer = ((int)0x90D2)        ,
        /// <summary>
        /// Original was GL_SHADER_STORAGE_BUFFER_BINDING = 0x90D3
        /// </summary>
        ShaderStorageBufferBinding = ((int)0x90D3)        ,
        /// <summary>
        /// Original was GL_SHADER_STORAGE_BUFFER_START = 0x90D4
        /// </summary>
        ShaderStorageBufferStart = ((int)0x90D4)        ,
        /// <summary>
        /// Original was GL_SHADER_STORAGE_BUFFER_SIZE = 0x90D5
        /// </summary>
        ShaderStorageBufferSize = ((int)0x90D5)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS = 0x90D6
        /// </summary>
        MaxVertexShaderStorageBlocks = ((int)0x90D6)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS = 0x90D7
        /// </summary>
        MaxGeometryShaderStorageBlocks = ((int)0x90D7)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS = 0x90D8
        /// </summary>
        MaxTessControlShaderStorageBlocks = ((int)0x90D8)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS = 0x90D9
        /// </summary>
        MaxTessEvaluationShaderStorageBlocks = ((int)0x90D9)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS = 0x90DA
        /// </summary>
        MaxFragmentShaderStorageBlocks = ((int)0x90DA)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS = 0x90DB
        /// </summary>
        MaxComputeShaderStorageBlocks = ((int)0x90DB)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS = 0x90DC
        /// </summary>
        MaxCombinedShaderStorageBlocks = ((int)0x90DC)        ,
        /// <summary>
        /// Original was GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS = 0x90DD
        /// </summary>
        MaxShaderStorageBufferBindings = ((int)0x90DD)        ,
        /// <summary>
        /// Original was GL_MAX_SHADER_STORAGE_BLOCK_SIZE = 0x90DE
        /// </summary>
        MaxShaderStorageBlockSize = ((int)0x90DE)        ,
        /// <summary>
        /// Original was GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT = 0x90DF
        /// </summary>
        ShaderStorageBufferOffsetAlignment = ((int)0x90DF)        ,
        /// <summary>
        /// Original was GL_SYNC_X11_FENCE_EXT = 0x90E1
        /// </summary>
        SyncX11FenceExt = ((int)0x90E1)        ,
        /// <summary>
        /// Original was GL_DEPTH_STENCIL_TEXTURE_MODE = 0x90EA
        /// </summary>
        DepthStencilTextureMode = ((int)0x90EA)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB = 0x90EB
        /// </summary>
        MaxComputeFixedGroupInvocationsArb = ((int)0x90EB)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS = 0x90EB
        /// </summary>
        MaxComputeWorkGroupInvocations = ((int)0x90EB)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER = 0x90EC
        /// </summary>
        UniformBlockReferencedByComputeShader = ((int)0x90EC)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER = 0x90ED
        /// </summary>
        AtomicCounterBufferReferencedByComputeShader = ((int)0x90ED)        ,
        /// <summary>
        /// Original was GL_DISPATCH_INDIRECT_BUFFER = 0x90EE
        /// </summary>
        DispatchIndirectBuffer = ((int)0x90EE)        ,
        /// <summary>
        /// Original was GL_DISPATCH_INDIRECT_BUFFER_BINDING = 0x90EF
        /// </summary>
        DispatchIndirectBufferBinding = ((int)0x90EF)        ,
        /// <summary>
        /// Original was GL_COMPUTE_PROGRAM_NV = 0x90FB
        /// </summary>
        ComputeProgramNv = ((int)0x90FB)        ,
        /// <summary>
        /// Original was GL_COMPUTE_PROGRAM_PARAMETER_BUFFER_NV = 0x90FC
        /// </summary>
        ComputeProgramParameterBufferNv = ((int)0x90FC)        ,
        /// <summary>
        /// Original was GL_TEXTURE_2D_MULTISAMPLE = 0x9100
        /// </summary>
        Texture2DMultisample = ((int)0x9100)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_2D_MULTISAMPLE = 0x9101
        /// </summary>
        ProxyTexture2DMultisample = ((int)0x9101)        ,
        /// <summary>
        /// Original was GL_TEXTURE_2D_MULTISAMPLE_ARRAY = 0x9102
        /// </summary>
        Texture2DMultisampleArray = ((int)0x9102)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY = 0x9103
        /// </summary>
        ProxyTexture2DMultisampleArray = ((int)0x9103)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_2D_MULTISAMPLE = 0x9104
        /// </summary>
        TextureBinding2DMultisample = ((int)0x9104)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = 0x9105
        /// </summary>
        TextureBinding2DMultisampleArray = ((int)0x9105)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SAMPLES = 0x9106
        /// </summary>
        TextureSamples = ((int)0x9106)        ,
        /// <summary>
        /// Original was GL_TEXTURE_FIXED_SAMPLE_LOCATIONS = 0x9107
        /// </summary>
        TextureFixedSampleLocations = ((int)0x9107)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_MULTISAMPLE = 0x9108
        /// </summary>
        Sampler2DMultisample = ((int)0x9108)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_2D_MULTISAMPLE = 0x9109
        /// </summary>
        IntSampler2DMultisample = ((int)0x9109)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = 0x910A
        /// </summary>
        UnsignedIntSampler2DMultisample = ((int)0x910A)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910B
        /// </summary>
        Sampler2DMultisampleArray = ((int)0x910B)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910C
        /// </summary>
        IntSampler2DMultisampleArray = ((int)0x910C)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910D
        /// </summary>
        UnsignedIntSampler2DMultisampleArray = ((int)0x910D)        ,
        /// <summary>
        /// Original was GL_MAX_COLOR_TEXTURE_SAMPLES = 0x910E
        /// </summary>
        MaxColorTextureSamples = ((int)0x910E)        ,
        /// <summary>
        /// Original was GL_MAX_DEPTH_TEXTURE_SAMPLES = 0x910F
        /// </summary>
        MaxDepthTextureSamples = ((int)0x910F)        ,
        /// <summary>
        /// Original was GL_MAX_INTEGER_SAMPLES = 0x9110
        /// </summary>
        MaxIntegerSamples = ((int)0x9110)        ,
        /// <summary>
        /// Original was GL_MAX_SERVER_WAIT_TIMEOUT = 0x9111
        /// </summary>
        MaxServerWaitTimeout = ((int)0x9111)        ,
        /// <summary>
        /// Original was GL_OBJECT_TYPE = 0x9112
        /// </summary>
        ObjectType = ((int)0x9112)        ,
        /// <summary>
        /// Original was GL_SYNC_CONDITION = 0x9113
        /// </summary>
        SyncCondition = ((int)0x9113)        ,
        /// <summary>
        /// Original was GL_SYNC_STATUS = 0x9114
        /// </summary>
        SyncStatus = ((int)0x9114)        ,
        /// <summary>
        /// Original was GL_SYNC_FLAGS = 0x9115
        /// </summary>
        SyncFlags = ((int)0x9115)        ,
        /// <summary>
        /// Original was GL_SYNC_FENCE = 0x9116
        /// </summary>
        SyncFence = ((int)0x9116)        ,
        /// <summary>
        /// Original was GL_SYNC_GPU_COMMANDS_COMPLETE = 0x9117
        /// </summary>
        SyncGpuCommandsComplete = ((int)0x9117)        ,
        /// <summary>
        /// Original was GL_UNSIGNALED = 0x9118
        /// </summary>
        Unsignaled = ((int)0x9118)        ,
        /// <summary>
        /// Original was GL_SIGNALED = 0x9119
        /// </summary>
        Signaled = ((int)0x9119)        ,
        /// <summary>
        /// Original was GL_ALREADY_SIGNALED = 0x911A
        /// </summary>
        AlreadySignaled = ((int)0x911A)        ,
        /// <summary>
        /// Original was GL_TIMEOUT_EXPIRED = 0x911B
        /// </summary>
        TimeoutExpired = ((int)0x911B)        ,
        /// <summary>
        /// Original was GL_CONDITION_SATISFIED = 0x911C
        /// </summary>
        ConditionSatisfied = ((int)0x911C)        ,
        /// <summary>
        /// Original was GL_WAIT_FAILED = 0x911D
        /// </summary>
        WaitFailed = ((int)0x911D)        ,
        /// <summary>
        /// Original was GL_BUFFER_ACCESS_FLAGS = 0x911F
        /// </summary>
        BufferAccessFlags = ((int)0x911F)        ,
        /// <summary>
        /// Original was GL_BUFFER_MAP_LENGTH = 0x9120
        /// </summary>
        BufferMapLength = ((int)0x9120)        ,
        /// <summary>
        /// Original was GL_BUFFER_MAP_OFFSET = 0x9121
        /// </summary>
        BufferMapOffset = ((int)0x9121)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_OUTPUT_COMPONENTS = 0x9122
        /// </summary>
        MaxVertexOutputComponents = ((int)0x9122)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_INPUT_COMPONENTS = 0x9123
        /// </summary>
        MaxGeometryInputComponents = ((int)0x9123)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_OUTPUT_COMPONENTS = 0x9124
        /// </summary>
        MaxGeometryOutputComponents = ((int)0x9124)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_INPUT_COMPONENTS = 0x9125
        /// </summary>
        MaxFragmentInputComponents = ((int)0x9125)        ,
        /// <summary>
        /// Original was GL_CONTEXT_PROFILE_MASK = 0x9126
        /// </summary>
        ContextProfileMask = ((int)0x9126)        ,
        /// <summary>
        /// Original was GL_UNPACK_COMPRESSED_BLOCK_WIDTH = 0x9127
        /// </summary>
        UnpackCompressedBlockWidth = ((int)0x9127)        ,
        /// <summary>
        /// Original was GL_UNPACK_COMPRESSED_BLOCK_HEIGHT = 0x9128
        /// </summary>
        UnpackCompressedBlockHeight = ((int)0x9128)        ,
        /// <summary>
        /// Original was GL_UNPACK_COMPRESSED_BLOCK_DEPTH = 0x9129
        /// </summary>
        UnpackCompressedBlockDepth = ((int)0x9129)        ,
        /// <summary>
        /// Original was GL_UNPACK_COMPRESSED_BLOCK_SIZE = 0x912A
        /// </summary>
        UnpackCompressedBlockSize = ((int)0x912A)        ,
        /// <summary>
        /// Original was GL_PACK_COMPRESSED_BLOCK_WIDTH = 0x912B
        /// </summary>
        PackCompressedBlockWidth = ((int)0x912B)        ,
        /// <summary>
        /// Original was GL_PACK_COMPRESSED_BLOCK_HEIGHT = 0x912C
        /// </summary>
        PackCompressedBlockHeight = ((int)0x912C)        ,
        /// <summary>
        /// Original was GL_PACK_COMPRESSED_BLOCK_DEPTH = 0x912D
        /// </summary>
        PackCompressedBlockDepth = ((int)0x912D)        ,
        /// <summary>
        /// Original was GL_PACK_COMPRESSED_BLOCK_SIZE = 0x912E
        /// </summary>
        PackCompressedBlockSize = ((int)0x912E)        ,
        /// <summary>
        /// Original was GL_TEXTURE_IMMUTABLE_FORMAT = 0x912F
        /// </summary>
        TextureImmutableFormat = ((int)0x912F)        ,
        /// <summary>
        /// Original was GL_MAX_DEBUG_MESSAGE_LENGTH = 0x9143
        /// </summary>
        MaxDebugMessageLength = ((int)0x9143)        ,
        /// <summary>
        /// Original was GL_MAX_DEBUG_MESSAGE_LENGTH_AMD = 0x9143
        /// </summary>
        MaxDebugMessageLengthAmd = ((int)0x9143)        ,
        /// <summary>
        /// Original was GL_MAX_DEBUG_MESSAGE_LENGTH_ARB = 0x9143
        /// </summary>
        MaxDebugMessageLengthArb = ((int)0x9143)        ,
        /// <summary>
        /// Original was GL_MAX_DEBUG_MESSAGE_LENGTH_KHR = 0x9143
        /// </summary>
        MaxDebugMessageLengthKhr = ((int)0x9143)        ,
        /// <summary>
        /// Original was GL_MAX_DEBUG_LOGGED_MESSAGES = 0x9144
        /// </summary>
        MaxDebugLoggedMessages = ((int)0x9144)        ,
        /// <summary>
        /// Original was GL_MAX_DEBUG_LOGGED_MESSAGES_AMD = 0x9144
        /// </summary>
        MaxDebugLoggedMessagesAmd = ((int)0x9144)        ,
        /// <summary>
        /// Original was GL_MAX_DEBUG_LOGGED_MESSAGES_ARB = 0x9144
        /// </summary>
        MaxDebugLoggedMessagesArb = ((int)0x9144)        ,
        /// <summary>
        /// Original was GL_MAX_DEBUG_LOGGED_MESSAGES_KHR = 0x9144
        /// </summary>
        MaxDebugLoggedMessagesKhr = ((int)0x9144)        ,
        /// <summary>
        /// Original was GL_DEBUG_LOGGED_MESSAGES = 0x9145
        /// </summary>
        DebugLoggedMessages = ((int)0x9145)        ,
        /// <summary>
        /// Original was GL_DEBUG_LOGGED_MESSAGES_AMD = 0x9145
        /// </summary>
        DebugLoggedMessagesAmd = ((int)0x9145)        ,
        /// <summary>
        /// Original was GL_DEBUG_LOGGED_MESSAGES_ARB = 0x9145
        /// </summary>
        DebugLoggedMessagesArb = ((int)0x9145)        ,
        /// <summary>
        /// Original was GL_DEBUG_LOGGED_MESSAGES_KHR = 0x9145
        /// </summary>
        DebugLoggedMessagesKhr = ((int)0x9145)        ,
        /// <summary>
        /// Original was GL_DEBUG_SEVERITY_HIGH = 0x9146
        /// </summary>
        DebugSeverityHigh = ((int)0x9146)        ,
        /// <summary>
        /// Original was GL_DEBUG_SEVERITY_HIGH_AMD = 0x9146
        /// </summary>
        DebugSeverityHighAmd = ((int)0x9146)        ,
        /// <summary>
        /// Original was GL_DEBUG_SEVERITY_HIGH_ARB = 0x9146
        /// </summary>
        DebugSeverityHighArb = ((int)0x9146)        ,
        /// <summary>
        /// Original was GL_DEBUG_SEVERITY_HIGH_KHR = 0x9146
        /// </summary>
        DebugSeverityHighKhr = ((int)0x9146)        ,
        /// <summary>
        /// Original was GL_DEBUG_SEVERITY_MEDIUM = 0x9147
        /// </summary>
        DebugSeverityMedium = ((int)0x9147)        ,
        /// <summary>
        /// Original was GL_DEBUG_SEVERITY_MEDIUM_AMD = 0x9147
        /// </summary>
        DebugSeverityMediumAmd = ((int)0x9147)        ,
        /// <summary>
        /// Original was GL_DEBUG_SEVERITY_MEDIUM_ARB = 0x9147
        /// </summary>
        DebugSeverityMediumArb = ((int)0x9147)        ,
        /// <summary>
        /// Original was GL_DEBUG_SEVERITY_MEDIUM_KHR = 0x9147
        /// </summary>
        DebugSeverityMediumKhr = ((int)0x9147)        ,
        /// <summary>
        /// Original was GL_DEBUG_SEVERITY_LOW = 0x9148
        /// </summary>
        DebugSeverityLow = ((int)0x9148)        ,
        /// <summary>
        /// Original was GL_DEBUG_SEVERITY_LOW_AMD = 0x9148
        /// </summary>
        DebugSeverityLowAmd = ((int)0x9148)        ,
        /// <summary>
        /// Original was GL_DEBUG_SEVERITY_LOW_ARB = 0x9148
        /// </summary>
        DebugSeverityLowArb = ((int)0x9148)        ,
        /// <summary>
        /// Original was GL_DEBUG_SEVERITY_LOW_KHR = 0x9148
        /// </summary>
        DebugSeverityLowKhr = ((int)0x9148)        ,
        /// <summary>
        /// Original was GL_DEBUG_CATEGORY_API_ERROR_AMD = 0x9149
        /// </summary>
        DebugCategoryApiErrorAmd = ((int)0x9149)        ,
        /// <summary>
        /// Original was GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD = 0x914A
        /// </summary>
        DebugCategoryWindowSystemAmd = ((int)0x914A)        ,
        /// <summary>
        /// Original was GL_DEBUG_CATEGORY_DEPRECATION_AMD = 0x914B
        /// </summary>
        DebugCategoryDeprecationAmd = ((int)0x914B)        ,
        /// <summary>
        /// Original was GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD = 0x914C
        /// </summary>
        DebugCategoryUndefinedBehaviorAmd = ((int)0x914C)        ,
        /// <summary>
        /// Original was GL_DEBUG_CATEGORY_PERFORMANCE_AMD = 0x914D
        /// </summary>
        DebugCategoryPerformanceAmd = ((int)0x914D)        ,
        /// <summary>
        /// Original was GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD = 0x914E
        /// </summary>
        DebugCategoryShaderCompilerAmd = ((int)0x914E)        ,
        /// <summary>
        /// Original was GL_DEBUG_CATEGORY_APPLICATION_AMD = 0x914F
        /// </summary>
        DebugCategoryApplicationAmd = ((int)0x914F)        ,
        /// <summary>
        /// Original was GL_DEBUG_CATEGORY_OTHER_AMD = 0x9150
        /// </summary>
        DebugCategoryOtherAmd = ((int)0x9150)        ,
        /// <summary>
        /// Original was GL_BUFFER_OBJECT_EXT = 0x9151
        /// </summary>
        BufferObjectExt = ((int)0x9151)        ,
        /// <summary>
        /// Original was GL_DATA_BUFFER_AMD = 0x9151
        /// </summary>
        DataBufferAmd = ((int)0x9151)        ,
        /// <summary>
        /// Original was GL_PERFORMANCE_MONITOR_AMD = 0x9152
        /// </summary>
        PerformanceMonitorAmd = ((int)0x9152)        ,
        /// <summary>
        /// Original was GL_QUERY_OBJECT_AMD = 0x9153
        /// </summary>
        QueryObjectAmd = ((int)0x9153)        ,
        /// <summary>
        /// Original was GL_QUERY_OBJECT_EXT = 0x9153
        /// </summary>
        QueryObjectExt = ((int)0x9153)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_OBJECT_AMD = 0x9154
        /// </summary>
        VertexArrayObjectAmd = ((int)0x9154)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_OBJECT_EXT = 0x9154
        /// </summary>
        VertexArrayObjectExt = ((int)0x9154)        ,
        /// <summary>
        /// Original was GL_SAMPLER_OBJECT_AMD = 0x9155
        /// </summary>
        SamplerObjectAmd = ((int)0x9155)        ,
        /// <summary>
        /// Original was GL_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD = 0x9160
        /// </summary>
        ExternalVirtualMemoryBufferAmd = ((int)0x9160)        ,
        /// <summary>
        /// Original was GL_QUERY_BUFFER = 0x9192
        /// </summary>
        QueryBuffer = ((int)0x9192)        ,
        /// <summary>
        /// Original was GL_QUERY_BUFFER_AMD = 0x9192
        /// </summary>
        QueryBufferAmd = ((int)0x9192)        ,
        /// <summary>
        /// Original was GL_QUERY_BUFFER_BINDING = 0x9193
        /// </summary>
        QueryBufferBinding = ((int)0x9193)        ,
        /// <summary>
        /// Original was GL_QUERY_BUFFER_BINDING_AMD = 0x9193
        /// </summary>
        QueryBufferBindingAmd = ((int)0x9193)        ,
        /// <summary>
        /// Original was GL_QUERY_RESULT_NO_WAIT = 0x9194
        /// </summary>
        QueryResultNoWait = ((int)0x9194)        ,
        /// <summary>
        /// Original was GL_QUERY_RESULT_NO_WAIT_AMD = 0x9194
        /// </summary>
        QueryResultNoWaitAmd = ((int)0x9194)        ,
        /// <summary>
        /// Original was GL_VIRTUAL_PAGE_SIZE_X_AMD = 0x9195
        /// </summary>
        VirtualPageSizeXAmd = ((int)0x9195)        ,
        /// <summary>
        /// Original was GL_VIRTUAL_PAGE_SIZE_X_ARB = 0x9195
        /// </summary>
        VirtualPageSizeXArb = ((int)0x9195)        ,
        /// <summary>
        /// Original was GL_VIRTUAL_PAGE_SIZE_Y_AMD = 0x9196
        /// </summary>
        VirtualPageSizeYAmd = ((int)0x9196)        ,
        /// <summary>
        /// Original was GL_VIRTUAL_PAGE_SIZE_Y_ARB = 0x9196
        /// </summary>
        VirtualPageSizeYArb = ((int)0x9196)        ,
        /// <summary>
        /// Original was GL_VIRTUAL_PAGE_SIZE_Z_AMD = 0x9197
        /// </summary>
        VirtualPageSizeZAmd = ((int)0x9197)        ,
        /// <summary>
        /// Original was GL_VIRTUAL_PAGE_SIZE_Z_ARB = 0x9197
        /// </summary>
        VirtualPageSizeZArb = ((int)0x9197)        ,
        /// <summary>
        /// Original was GL_MAX_SPARSE_TEXTURE_SIZE_AMD = 0x9198
        /// </summary>
        MaxSparseTextureSizeAmd = ((int)0x9198)        ,
        /// <summary>
        /// Original was GL_MAX_SPARSE_TEXTURE_SIZE_ARB = 0x9198
        /// </summary>
        MaxSparseTextureSizeArb = ((int)0x9198)        ,
        /// <summary>
        /// Original was GL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD = 0x9199
        /// </summary>
        MaxSparse3DTextureSizeAmd = ((int)0x9199)        ,
        /// <summary>
        /// Original was GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB = 0x9199
        /// </summary>
        MaxSparse3DTextureSizeArb = ((int)0x9199)        ,
        /// <summary>
        /// Original was GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS = 0x919A
        /// </summary>
        MaxSparseArrayTextureLayers = ((int)0x919A)        ,
        /// <summary>
        /// Original was GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB = 0x919A
        /// </summary>
        MaxSparseArrayTextureLayersArb = ((int)0x919A)        ,
        /// <summary>
        /// Original was GL_MIN_SPARSE_LEVEL_AMD = 0x919B
        /// </summary>
        MinSparseLevelAmd = ((int)0x919B)        ,
        /// <summary>
        /// Original was GL_MIN_SPARSE_LEVEL_ARB = 0x919B
        /// </summary>
        MinSparseLevelArb = ((int)0x919B)        ,
        /// <summary>
        /// Original was GL_MIN_LOD_WARNING_AMD = 0x919C
        /// </summary>
        MinLodWarningAmd = ((int)0x919C)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BUFFER_OFFSET = 0x919D
        /// </summary>
        TextureBufferOffset = ((int)0x919D)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BUFFER_SIZE = 0x919E
        /// </summary>
        TextureBufferSize = ((int)0x919E)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT = 0x919F
        /// </summary>
        TextureBufferOffsetAlignment = ((int)0x919F)        ,
        /// <summary>
        /// Original was GL_STREAM_RASTERIZATION_AMD = 0x91A0
        /// </summary>
        StreamRasterizationAmd = ((int)0x91A0)        ,
        /// <summary>
        /// Original was GL_VERTEX_ELEMENT_SWIZZLE_AMD = 0x91A4
        /// </summary>
        VertexElementSwizzleAmd = ((int)0x91A4)        ,
        /// <summary>
        /// Original was GL_VERTEX_ID_SWIZZLE_AMD = 0x91A5
        /// </summary>
        VertexIdSwizzleAmd = ((int)0x91A5)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SPARSE_ARB = 0x91A6
        /// </summary>
        TextureSparseArb = ((int)0x91A6)        ,
        /// <summary>
        /// Original was GL_VIRTUAL_PAGE_SIZE_INDEX_ARB = 0x91A7
        /// </summary>
        VirtualPageSizeIndexArb = ((int)0x91A7)        ,
        /// <summary>
        /// Original was GL_NUM_VIRTUAL_PAGE_SIZES_ARB = 0x91A8
        /// </summary>
        NumVirtualPageSizesArb = ((int)0x91A8)        ,
        /// <summary>
        /// Original was GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB = 0x91A9
        /// </summary>
        SparseTextureFullArrayCubeMipmapsArb = ((int)0x91A9)        ,
        /// <summary>
        /// Original was GL_COMPUTE_SHADER = 0x91B9
        /// </summary>
        ComputeShader = ((int)0x91B9)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_UNIFORM_BLOCKS = 0x91BB
        /// </summary>
        MaxComputeUniformBlocks = ((int)0x91BB)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS = 0x91BC
        /// </summary>
        MaxComputeTextureImageUnits = ((int)0x91BC)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_IMAGE_UNIFORMS = 0x91BD
        /// </summary>
        MaxComputeImageUniforms = ((int)0x91BD)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_WORK_GROUP_COUNT = 0x91BE
        /// </summary>
        MaxComputeWorkGroupCount = ((int)0x91BE)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB = 0x91BF
        /// </summary>
        MaxComputeFixedGroupSizeArb = ((int)0x91BF)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_WORK_GROUP_SIZE = 0x91BF
        /// </summary>
        MaxComputeWorkGroupSize = ((int)0x91BF)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_R11_EAC = 0x9270
        /// </summary>
        CompressedR11Eac = ((int)0x9270)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SIGNED_R11_EAC = 0x9271
        /// </summary>
        CompressedSignedR11Eac = ((int)0x9271)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RG11_EAC = 0x9272
        /// </summary>
        CompressedRg11Eac = ((int)0x9272)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SIGNED_RG11_EAC = 0x9273
        /// </summary>
        CompressedSignedRg11Eac = ((int)0x9273)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGB8_ETC2 = 0x9274
        /// </summary>
        CompressedRgb8Etc2 = ((int)0x9274)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB8_ETC2 = 0x9275
        /// </summary>
        CompressedSrgb8Etc2 = ((int)0x9275)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9276
        /// </summary>
        CompressedRgb8PunchthroughAlpha1Etc2 = ((int)0x9276)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9277
        /// </summary>
        CompressedSrgb8PunchthroughAlpha1Etc2 = ((int)0x9277)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA8_ETC2_EAC = 0x9278
        /// </summary>
        CompressedRgba8Etc2Eac = ((int)0x9278)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = 0x9279
        /// </summary>
        CompressedSrgb8Alpha8Etc2Eac = ((int)0x9279)        ,
        /// <summary>
        /// Original was GL_BLEND_PREMULTIPLIED_SRC_NV = 0x9280
        /// </summary>
        BlendPremultipliedSrcNv = ((int)0x9280)        ,
        /// <summary>
        /// Original was GL_BLEND_OVERLAP_NV = 0x9281
        /// </summary>
        BlendOverlapNv = ((int)0x9281)        ,
        /// <summary>
        /// Original was GL_UNCORRELATED_NV = 0x9282
        /// </summary>
        UncorrelatedNv = ((int)0x9282)        ,
        /// <summary>
        /// Original was GL_DISJOINT_NV = 0x9283
        /// </summary>
        DisjointNv = ((int)0x9283)        ,
        /// <summary>
        /// Original was GL_CONJOINT_NV = 0x9284
        /// </summary>
        ConjointNv = ((int)0x9284)        ,
        /// <summary>
        /// Original was GL_BLEND_ADVANCED_COHERENT_NV = 0x9285
        /// </summary>
        BlendAdvancedCoherentNv = ((int)0x9285)        ,
        /// <summary>
        /// Original was GL_SRC_NV = 0x9286
        /// </summary>
        SrcNv = ((int)0x9286)        ,
        /// <summary>
        /// Original was GL_DST_NV = 0x9287
        /// </summary>
        DstNv = ((int)0x9287)        ,
        /// <summary>
        /// Original was GL_SRC_OVER_NV = 0x9288
        /// </summary>
        SrcOverNv = ((int)0x9288)        ,
        /// <summary>
        /// Original was GL_DST_OVER_NV = 0x9289
        /// </summary>
        DstOverNv = ((int)0x9289)        ,
        /// <summary>
        /// Original was GL_SRC_IN_NV = 0x928A
        /// </summary>
        SrcInNv = ((int)0x928A)        ,
        /// <summary>
        /// Original was GL_DST_IN_NV = 0x928B
        /// </summary>
        DstInNv = ((int)0x928B)        ,
        /// <summary>
        /// Original was GL_SRC_OUT_NV = 0x928C
        /// </summary>
        SrcOutNv = ((int)0x928C)        ,
        /// <summary>
        /// Original was GL_DST_OUT_NV = 0x928D
        /// </summary>
        DstOutNv = ((int)0x928D)        ,
        /// <summary>
        /// Original was GL_SRC_ATOP_NV = 0x928E
        /// </summary>
        SrcAtopNv = ((int)0x928E)        ,
        /// <summary>
        /// Original was GL_DST_ATOP_NV = 0x928F
        /// </summary>
        DstAtopNv = ((int)0x928F)        ,
        /// <summary>
        /// Original was GL_PLUS_NV = 0x9291
        /// </summary>
        PlusNv = ((int)0x9291)        ,
        /// <summary>
        /// Original was GL_PLUS_DARKER_NV = 0x9292
        /// </summary>
        PlusDarkerNv = ((int)0x9292)        ,
        /// <summary>
        /// Original was GL_MULTIPLY_NV = 0x9294
        /// </summary>
        MultiplyNv = ((int)0x9294)        ,
        /// <summary>
        /// Original was GL_SCREEN_NV = 0x9295
        /// </summary>
        ScreenNv = ((int)0x9295)        ,
        /// <summary>
        /// Original was GL_OVERLAY_NV = 0x9296
        /// </summary>
        OverlayNv = ((int)0x9296)        ,
        /// <summary>
        /// Original was GL_DARKEN_NV = 0x9297
        /// </summary>
        DarkenNv = ((int)0x9297)        ,
        /// <summary>
        /// Original was GL_LIGHTEN_NV = 0x9298
        /// </summary>
        LightenNv = ((int)0x9298)        ,
        /// <summary>
        /// Original was GL_COLORDODGE_NV = 0x9299
        /// </summary>
        ColordodgeNv = ((int)0x9299)        ,
        /// <summary>
        /// Original was GL_COLORBURN_NV = 0x929A
        /// </summary>
        ColorburnNv = ((int)0x929A)        ,
        /// <summary>
        /// Original was GL_HARDLIGHT_NV = 0x929B
        /// </summary>
        HardlightNv = ((int)0x929B)        ,
        /// <summary>
        /// Original was GL_SOFTLIGHT_NV = 0x929C
        /// </summary>
        SoftlightNv = ((int)0x929C)        ,
        /// <summary>
        /// Original was GL_DIFFERENCE_NV = 0x929E
        /// </summary>
        DifferenceNv = ((int)0x929E)        ,
        /// <summary>
        /// Original was GL_MINUS_NV = 0x929F
        /// </summary>
        MinusNv = ((int)0x929F)        ,
        /// <summary>
        /// Original was GL_EXCLUSION_NV = 0x92A0
        /// </summary>
        ExclusionNv = ((int)0x92A0)        ,
        /// <summary>
        /// Original was GL_CONTRAST_NV = 0x92A1
        /// </summary>
        ContrastNv = ((int)0x92A1)        ,
        /// <summary>
        /// Original was GL_INVERT_RGB_NV = 0x92A3
        /// </summary>
        InvertRgbNv = ((int)0x92A3)        ,
        /// <summary>
        /// Original was GL_LINEARDODGE_NV = 0x92A4
        /// </summary>
        LineardodgeNv = ((int)0x92A4)        ,
        /// <summary>
        /// Original was GL_LINEARBURN_NV = 0x92A5
        /// </summary>
        LinearburnNv = ((int)0x92A5)        ,
        /// <summary>
        /// Original was GL_VIVIDLIGHT_NV = 0x92A6
        /// </summary>
        VividlightNv = ((int)0x92A6)        ,
        /// <summary>
        /// Original was GL_LINEARLIGHT_NV = 0x92A7
        /// </summary>
        LinearlightNv = ((int)0x92A7)        ,
        /// <summary>
        /// Original was GL_PINLIGHT_NV = 0x92A8
        /// </summary>
        PinlightNv = ((int)0x92A8)        ,
        /// <summary>
        /// Original was GL_HARDMIX_NV = 0x92A9
        /// </summary>
        HardmixNv = ((int)0x92A9)        ,
        /// <summary>
        /// Original was GL_HSL_HUE_NV = 0x92AD
        /// </summary>
        HslHueNv = ((int)0x92AD)        ,
        /// <summary>
        /// Original was GL_HSL_SATURATION_NV = 0x92AE
        /// </summary>
        HslSaturationNv = ((int)0x92AE)        ,
        /// <summary>
        /// Original was GL_HSL_COLOR_NV = 0x92AF
        /// </summary>
        HslColorNv = ((int)0x92AF)        ,
        /// <summary>
        /// Original was GL_HSL_LUMINOSITY_NV = 0x92B0
        /// </summary>
        HslLuminosityNv = ((int)0x92B0)        ,
        /// <summary>
        /// Original was GL_PLUS_CLAMPED_NV = 0x92B1
        /// </summary>
        PlusClampedNv = ((int)0x92B1)        ,
        /// <summary>
        /// Original was GL_PLUS_CLAMPED_ALPHA_NV = 0x92B2
        /// </summary>
        PlusClampedAlphaNv = ((int)0x92B2)        ,
        /// <summary>
        /// Original was GL_MINUS_CLAMPED_NV = 0x92B3
        /// </summary>
        MinusClampedNv = ((int)0x92B3)        ,
        /// <summary>
        /// Original was GL_INVERT_OVG_NV = 0x92B4
        /// </summary>
        InvertOvgNv = ((int)0x92B4)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER = 0x92C0
        /// </summary>
        AtomicCounterBuffer = ((int)0x92C0)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_BINDING = 0x92C1
        /// </summary>
        AtomicCounterBufferBinding = ((int)0x92C1)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_START = 0x92C2
        /// </summary>
        AtomicCounterBufferStart = ((int)0x92C2)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_SIZE = 0x92C3
        /// </summary>
        AtomicCounterBufferSize = ((int)0x92C3)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE = 0x92C4
        /// </summary>
        AtomicCounterBufferDataSize = ((int)0x92C4)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS = 0x92C5
        /// </summary>
        AtomicCounterBufferActiveAtomicCounters = ((int)0x92C5)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES = 0x92C6
        /// </summary>
        AtomicCounterBufferActiveAtomicCounterIndices = ((int)0x92C6)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER = 0x92C7
        /// </summary>
        AtomicCounterBufferReferencedByVertexShader = ((int)0x92C7)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER = 0x92C8
        /// </summary>
        AtomicCounterBufferReferencedByTessControlShader = ((int)0x92C8)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x92C9
        /// </summary>
        AtomicCounterBufferReferencedByTessEvaluationShader = ((int)0x92C9)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER = 0x92CA
        /// </summary>
        AtomicCounterBufferReferencedByGeometryShader = ((int)0x92CA)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER = 0x92CB
        /// </summary>
        AtomicCounterBufferReferencedByFragmentShader = ((int)0x92CB)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS = 0x92CC
        /// </summary>
        MaxVertexAtomicCounterBuffers = ((int)0x92CC)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS = 0x92CD
        /// </summary>
        MaxTessControlAtomicCounterBuffers = ((int)0x92CD)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS = 0x92CE
        /// </summary>
        MaxTessEvaluationAtomicCounterBuffers = ((int)0x92CE)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS = 0x92CF
        /// </summary>
        MaxGeometryAtomicCounterBuffers = ((int)0x92CF)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS = 0x92D0
        /// </summary>
        MaxFragmentAtomicCounterBuffers = ((int)0x92D0)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS = 0x92D1
        /// </summary>
        MaxCombinedAtomicCounterBuffers = ((int)0x92D1)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_ATOMIC_COUNTERS = 0x92D2
        /// </summary>
        MaxVertexAtomicCounters = ((int)0x92D2)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS = 0x92D3
        /// </summary>
        MaxTessControlAtomicCounters = ((int)0x92D3)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS = 0x92D4
        /// </summary>
        MaxTessEvaluationAtomicCounters = ((int)0x92D4)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_ATOMIC_COUNTERS = 0x92D5
        /// </summary>
        MaxGeometryAtomicCounters = ((int)0x92D5)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_ATOMIC_COUNTERS = 0x92D6
        /// </summary>
        MaxFragmentAtomicCounters = ((int)0x92D6)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_ATOMIC_COUNTERS = 0x92D7
        /// </summary>
        MaxCombinedAtomicCounters = ((int)0x92D7)        ,
        /// <summary>
        /// Original was GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE = 0x92D8
        /// </summary>
        MaxAtomicCounterBufferSize = ((int)0x92D8)        ,
        /// <summary>
        /// Original was GL_ACTIVE_ATOMIC_COUNTER_BUFFERS = 0x92D9
        /// </summary>
        ActiveAtomicCounterBuffers = ((int)0x92D9)        ,
        /// <summary>
        /// Original was GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX = 0x92DA
        /// </summary>
        UniformAtomicCounterBufferIndex = ((int)0x92DA)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_ATOMIC_COUNTER = 0x92DB
        /// </summary>
        UnsignedIntAtomicCounter = ((int)0x92DB)        ,
        /// <summary>
        /// Original was GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS = 0x92DC
        /// </summary>
        MaxAtomicCounterBufferBindings = ((int)0x92DC)        ,
        /// <summary>
        /// Original was GL_DEBUG_OUTPUT = 0x92E0
        /// </summary>
        DebugOutput = ((int)0x92E0)        ,
        /// <summary>
        /// Original was GL_DEBUG_OUTPUT_KHR = 0x92E0
        /// </summary>
        DebugOutputKhr = ((int)0x92E0)        ,
        /// <summary>
        /// Original was GL_UNIFORM = 0x92E1
        /// </summary>
        Uniform = ((int)0x92E1)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK = 0x92E2
        /// </summary>
        UniformBlock = ((int)0x92E2)        ,
        /// <summary>
        /// Original was GL_PROGRAM_INPUT = 0x92E3
        /// </summary>
        ProgramInput = ((int)0x92E3)        ,
        /// <summary>
        /// Original was GL_PROGRAM_OUTPUT = 0x92E4
        /// </summary>
        ProgramOutput = ((int)0x92E4)        ,
        /// <summary>
        /// Original was GL_BUFFER_VARIABLE = 0x92E5
        /// </summary>
        BufferVariable = ((int)0x92E5)        ,
        /// <summary>
        /// Original was GL_SHADER_STORAGE_BLOCK = 0x92E6
        /// </summary>
        ShaderStorageBlock = ((int)0x92E6)        ,
        /// <summary>
        /// Original was GL_IS_PER_PATCH = 0x92E7
        /// </summary>
        IsPerPatch = ((int)0x92E7)        ,
        /// <summary>
        /// Original was GL_VERTEX_SUBROUTINE = 0x92E8
        /// </summary>
        VertexSubroutine = ((int)0x92E8)        ,
        /// <summary>
        /// Original was GL_TESS_CONTROL_SUBROUTINE = 0x92E9
        /// </summary>
        TessControlSubroutine = ((int)0x92E9)        ,
        /// <summary>
        /// Original was GL_TESS_EVALUATION_SUBROUTINE = 0x92EA
        /// </summary>
        TessEvaluationSubroutine = ((int)0x92EA)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_SUBROUTINE = 0x92EB
        /// </summary>
        GeometrySubroutine = ((int)0x92EB)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_SUBROUTINE = 0x92EC
        /// </summary>
        FragmentSubroutine = ((int)0x92EC)        ,
        /// <summary>
        /// Original was GL_COMPUTE_SUBROUTINE = 0x92ED
        /// </summary>
        ComputeSubroutine = ((int)0x92ED)        ,
        /// <summary>
        /// Original was GL_VERTEX_SUBROUTINE_UNIFORM = 0x92EE
        /// </summary>
        VertexSubroutineUniform = ((int)0x92EE)        ,
        /// <summary>
        /// Original was GL_TESS_CONTROL_SUBROUTINE_UNIFORM = 0x92EF
        /// </summary>
        TessControlSubroutineUniform = ((int)0x92EF)        ,
        /// <summary>
        /// Original was GL_TESS_EVALUATION_SUBROUTINE_UNIFORM = 0x92F0
        /// </summary>
        TessEvaluationSubroutineUniform = ((int)0x92F0)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_SUBROUTINE_UNIFORM = 0x92F1
        /// </summary>
        GeometrySubroutineUniform = ((int)0x92F1)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_SUBROUTINE_UNIFORM = 0x92F2
        /// </summary>
        FragmentSubroutineUniform = ((int)0x92F2)        ,
        /// <summary>
        /// Original was GL_COMPUTE_SUBROUTINE_UNIFORM = 0x92F3
        /// </summary>
        ComputeSubroutineUniform = ((int)0x92F3)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_VARYING = 0x92F4
        /// </summary>
        TransformFeedbackVarying = ((int)0x92F4)        ,
        /// <summary>
        /// Original was GL_ACTIVE_RESOURCES = 0x92F5
        /// </summary>
        ActiveResources = ((int)0x92F5)        ,
        /// <summary>
        /// Original was GL_MAX_NAME_LENGTH = 0x92F6
        /// </summary>
        MaxNameLength = ((int)0x92F6)        ,
        /// <summary>
        /// Original was GL_MAX_NUM_ACTIVE_VARIABLES = 0x92F7
        /// </summary>
        MaxNumActiveVariables = ((int)0x92F7)        ,
        /// <summary>
        /// Original was GL_MAX_NUM_COMPATIBLE_SUBROUTINES = 0x92F8
        /// </summary>
        MaxNumCompatibleSubroutines = ((int)0x92F8)        ,
        /// <summary>
        /// Original was GL_NAME_LENGTH = 0x92F9
        /// </summary>
        NameLength = ((int)0x92F9)        ,
        /// <summary>
        /// Original was GL_TYPE = 0x92FA
        /// </summary>
        Type = ((int)0x92FA)        ,
        /// <summary>
        /// Original was GL_ARRAY_SIZE = 0x92FB
        /// </summary>
        ArraySize = ((int)0x92FB)        ,
        /// <summary>
        /// Original was GL_OFFSET = 0x92FC
        /// </summary>
        Offset = ((int)0x92FC)        ,
        /// <summary>
        /// Original was GL_BLOCK_INDEX = 0x92FD
        /// </summary>
        BlockIndex = ((int)0x92FD)        ,
        /// <summary>
        /// Original was GL_ARRAY_STRIDE = 0x92FE
        /// </summary>
        ArrayStride = ((int)0x92FE)        ,
        /// <summary>
        /// Original was GL_MATRIX_STRIDE = 0x92FF
        /// </summary>
        MatrixStride = ((int)0x92FF)        ,
        /// <summary>
        /// Original was GL_IS_ROW_MAJOR = 0x9300
        /// </summary>
        IsRowMajor = ((int)0x9300)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_INDEX = 0x9301
        /// </summary>
        AtomicCounterBufferIndex = ((int)0x9301)        ,
        /// <summary>
        /// Original was GL_BUFFER_BINDING = 0x9302
        /// </summary>
        BufferBinding = ((int)0x9302)        ,
        /// <summary>
        /// Original was GL_BUFFER_DATA_SIZE = 0x9303
        /// </summary>
        BufferDataSize = ((int)0x9303)        ,
        /// <summary>
        /// Original was GL_NUM_ACTIVE_VARIABLES = 0x9304
        /// </summary>
        NumActiveVariables = ((int)0x9304)        ,
        /// <summary>
        /// Original was GL_ACTIVE_VARIABLES = 0x9305
        /// </summary>
        ActiveVariables = ((int)0x9305)        ,
        /// <summary>
        /// Original was GL_REFERENCED_BY_VERTEX_SHADER = 0x9306
        /// </summary>
        ReferencedByVertexShader = ((int)0x9306)        ,
        /// <summary>
        /// Original was GL_REFERENCED_BY_TESS_CONTROL_SHADER = 0x9307
        /// </summary>
        ReferencedByTessControlShader = ((int)0x9307)        ,
        /// <summary>
        /// Original was GL_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x9308
        /// </summary>
        ReferencedByTessEvaluationShader = ((int)0x9308)        ,
        /// <summary>
        /// Original was GL_REFERENCED_BY_GEOMETRY_SHADER = 0x9309
        /// </summary>
        ReferencedByGeometryShader = ((int)0x9309)        ,
        /// <summary>
        /// Original was GL_REFERENCED_BY_FRAGMENT_SHADER = 0x930A
        /// </summary>
        ReferencedByFragmentShader = ((int)0x930A)        ,
        /// <summary>
        /// Original was GL_REFERENCED_BY_COMPUTE_SHADER = 0x930B
        /// </summary>
        ReferencedByComputeShader = ((int)0x930B)        ,
        /// <summary>
        /// Original was GL_TOP_LEVEL_ARRAY_SIZE = 0x930C
        /// </summary>
        TopLevelArraySize = ((int)0x930C)        ,
        /// <summary>
        /// Original was GL_TOP_LEVEL_ARRAY_STRIDE = 0x930D
        /// </summary>
        TopLevelArrayStride = ((int)0x930D)        ,
        /// <summary>
        /// Original was GL_LOCATION = 0x930E
        /// </summary>
        Location = ((int)0x930E)        ,
        /// <summary>
        /// Original was GL_LOCATION_INDEX = 0x930F
        /// </summary>
        LocationIndex = ((int)0x930F)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_DEFAULT_WIDTH = 0x9310
        /// </summary>
        FramebufferDefaultWidth = ((int)0x9310)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_DEFAULT_HEIGHT = 0x9311
        /// </summary>
        FramebufferDefaultHeight = ((int)0x9311)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_DEFAULT_LAYERS = 0x9312
        /// </summary>
        FramebufferDefaultLayers = ((int)0x9312)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_DEFAULT_SAMPLES = 0x9313
        /// </summary>
        FramebufferDefaultSamples = ((int)0x9313)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS = 0x9314
        /// </summary>
        FramebufferDefaultFixedSampleLocations = ((int)0x9314)        ,
        /// <summary>
        /// Original was GL_MAX_FRAMEBUFFER_WIDTH = 0x9315
        /// </summary>
        MaxFramebufferWidth = ((int)0x9315)        ,
        /// <summary>
        /// Original was GL_MAX_FRAMEBUFFER_HEIGHT = 0x9316
        /// </summary>
        MaxFramebufferHeight = ((int)0x9316)        ,
        /// <summary>
        /// Original was GL_MAX_FRAMEBUFFER_LAYERS = 0x9317
        /// </summary>
        MaxFramebufferLayers = ((int)0x9317)        ,
        /// <summary>
        /// Original was GL_MAX_FRAMEBUFFER_SAMPLES = 0x9318
        /// </summary>
        MaxFramebufferSamples = ((int)0x9318)        ,
        /// <summary>
        /// Original was GL_WARP_SIZE_NV = 0x9339
        /// </summary>
        WarpSizeNv = ((int)0x9339)        ,
        /// <summary>
        /// Original was GL_WARPS_PER_SM_NV = 0x933A
        /// </summary>
        WarpsPerSmNv = ((int)0x933A)        ,
        /// <summary>
        /// Original was GL_SM_COUNT_NV = 0x933B
        /// </summary>
        SmCountNv = ((int)0x933B)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB = 0x9344
        /// </summary>
        MaxComputeVariableGroupInvocationsArb = ((int)0x9344)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB = 0x9345
        /// </summary>
        MaxComputeVariableGroupSizeArb = ((int)0x9345)        ,
        /// <summary>
        /// Original was GL_LOCATION_COMPONENT = 0x934A
        /// </summary>
        LocationComponent = ((int)0x934A)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_INDEX = 0x934B
        /// </summary>
        TransformFeedbackBufferIndex = ((int)0x934B)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE = 0x934C
        /// </summary>
        TransformFeedbackBufferStride = ((int)0x934C)        ,
        /// <summary>
        /// Original was GL_CLEAR_TEXTURE = 0x9365
        /// </summary>
        ClearTexture = ((int)0x9365)        ,
        /// <summary>
        /// Original was GL_NUM_SAMPLE_COUNTS = 0x9380
        /// </summary>
        NumSampleCounts = ((int)0x9380)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_ASTC_4x4_KHR = 0x93B0
        /// </summary>
        CompressedRgbaAstc4X4Khr = ((int)0x93B0)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_ASTC_5x4_KHR = 0x93B1
        /// </summary>
        CompressedRgbaAstc5X4Khr = ((int)0x93B1)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_ASTC_5x5_KHR = 0x93B2
        /// </summary>
        CompressedRgbaAstc5X5Khr = ((int)0x93B2)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_ASTC_6x5_KHR = 0x93B3
        /// </summary>
        CompressedRgbaAstc6X5Khr = ((int)0x93B3)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_ASTC_6x6_KHR = 0x93B4
        /// </summary>
        CompressedRgbaAstc6X6Khr = ((int)0x93B4)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_ASTC_8x5_KHR = 0x93B5
        /// </summary>
        CompressedRgbaAstc8X5Khr = ((int)0x93B5)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_ASTC_8x6_KHR = 0x93B6
        /// </summary>
        CompressedRgbaAstc8X6Khr = ((int)0x93B6)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_ASTC_8x8_KHR = 0x93B7
        /// </summary>
        CompressedRgbaAstc8X8Khr = ((int)0x93B7)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_ASTC_10x5_KHR = 0x93B8
        /// </summary>
        CompressedRgbaAstc10X5Khr = ((int)0x93B8)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_ASTC_10x6_KHR = 0x93B9
        /// </summary>
        CompressedRgbaAstc10X6Khr = ((int)0x93B9)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_ASTC_10x8_KHR = 0x93BA
        /// </summary>
        CompressedRgbaAstc10X8Khr = ((int)0x93BA)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_ASTC_10x10_KHR = 0x93BB
        /// </summary>
        CompressedRgbaAstc10X10Khr = ((int)0x93BB)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_ASTC_12x10_KHR = 0x93BC
        /// </summary>
        CompressedRgbaAstc12X10Khr = ((int)0x93BC)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_ASTC_12x12_KHR = 0x93BD
        /// </summary>
        CompressedRgbaAstc12X12Khr = ((int)0x93BD)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR = 0x93D0
        /// </summary>
        CompressedSrgb8Alpha8Astc4X4Khr = ((int)0x93D0)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR = 0x93D1
        /// </summary>
        CompressedSrgb8Alpha8Astc5X4Khr = ((int)0x93D1)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR = 0x93D2
        /// </summary>
        CompressedSrgb8Alpha8Astc5X5Khr = ((int)0x93D2)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR = 0x93D3
        /// </summary>
        CompressedSrgb8Alpha8Astc6X5Khr = ((int)0x93D3)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR = 0x93D4
        /// </summary>
        CompressedSrgb8Alpha8Astc6X6Khr = ((int)0x93D4)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR = 0x93D5
        /// </summary>
        CompressedSrgb8Alpha8Astc8X5Khr = ((int)0x93D5)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR = 0x93D6
        /// </summary>
        CompressedSrgb8Alpha8Astc8X6Khr = ((int)0x93D6)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR = 0x93D7
        /// </summary>
        CompressedSrgb8Alpha8Astc8X8Khr = ((int)0x93D7)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR = 0x93D8
        /// </summary>
        CompressedSrgb8Alpha8Astc10X5Khr = ((int)0x93D8)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR = 0x93D9
        /// </summary>
        CompressedSrgb8Alpha8Astc10X6Khr = ((int)0x93D9)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR = 0x93DA
        /// </summary>
        CompressedSrgb8Alpha8Astc10X8Khr = ((int)0x93DA)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR = 0x93DB
        /// </summary>
        CompressedSrgb8Alpha8Astc10X10Khr = ((int)0x93DB)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR = 0x93DC
        /// </summary>
        CompressedSrgb8Alpha8Astc12X10Khr = ((int)0x93DC)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR = 0x93DD
        /// </summary>
        CompressedSrgb8Alpha8Astc12X12Khr = ((int)0x93DD)        ,
        /// <summary>
        /// Original was GL_PERFQUERY_COUNTER_EVENT_INTEL = 0x94F0
        /// </summary>
        PerfqueryCounterEventIntel = ((int)0x94F0)        ,
        /// <summary>
        /// Original was GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL = 0x94F1
        /// </summary>
        PerfqueryCounterDurationNormIntel = ((int)0x94F1)        ,
        /// <summary>
        /// Original was GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL = 0x94F2
        /// </summary>
        PerfqueryCounterDurationRawIntel = ((int)0x94F2)        ,
        /// <summary>
        /// Original was GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL = 0x94F3
        /// </summary>
        PerfqueryCounterThroughputIntel = ((int)0x94F3)        ,
        /// <summary>
        /// Original was GL_PERFQUERY_COUNTER_RAW_INTEL = 0x94F4
        /// </summary>
        PerfqueryCounterRawIntel = ((int)0x94F4)        ,
        /// <summary>
        /// Original was GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL = 0x94F5
        /// </summary>
        PerfqueryCounterTimestampIntel = ((int)0x94F5)        ,
        /// <summary>
        /// Original was GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL = 0x94F8
        /// </summary>
        PerfqueryCounterDataUint32Intel = ((int)0x94F8)        ,
        /// <summary>
        /// Original was GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL = 0x94F9
        /// </summary>
        PerfqueryCounterDataUint64Intel = ((int)0x94F9)        ,
        /// <summary>
        /// Original was GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL = 0x94FA
        /// </summary>
        PerfqueryCounterDataFloatIntel = ((int)0x94FA)        ,
        /// <summary>
        /// Original was GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL = 0x94FB
        /// </summary>
        PerfqueryCounterDataDoubleIntel = ((int)0x94FB)        ,
        /// <summary>
        /// Original was GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL = 0x94FC
        /// </summary>
        PerfqueryCounterDataBool32Intel = ((int)0x94FC)        ,
        /// <summary>
        /// Original was GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL = 0x94FD
        /// </summary>
        PerfqueryQueryNameLengthMaxIntel = ((int)0x94FD)        ,
        /// <summary>
        /// Original was GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL = 0x94FE
        /// </summary>
        PerfqueryCounterNameLengthMaxIntel = ((int)0x94FE)        ,
        /// <summary>
        /// Original was GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL = 0x94FF
        /// </summary>
        PerfqueryCounterDescLengthMaxIntel = ((int)0x94FF)        ,
        /// <summary>
        /// Original was GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL = 0x9500
        /// </summary>
        PerfqueryGpaExtendedCountersIntel = ((int)0x9500)        ,
        /// <summary>
        /// Original was GL_RESTART_PATH_NV = 0xF0
        /// </summary>
        RestartPathNv = ((int)0xF0)        ,
        /// <summary>
        /// Original was GL_DUP_FIRST_CUBIC_CURVE_TO_NV = 0xF2
        /// </summary>
        DupFirstCubicCurveToNv = ((int)0xF2)        ,
        /// <summary>
        /// Original was GL_DUP_LAST_CUBIC_CURVE_TO_NV = 0xF4
        /// </summary>
        DupLastCubicCurveToNv = ((int)0xF4)        ,
        /// <summary>
        /// Original was GL_RECT_NV = 0xF6
        /// </summary>
        RectNv = ((int)0xF6)        ,
        /// <summary>
        /// Original was GL_CIRCULAR_CCW_ARC_TO_NV = 0xF8
        /// </summary>
        CircularCcwArcToNv = ((int)0xF8)        ,
        /// <summary>
        /// Original was GL_CIRCULAR_CW_ARC_TO_NV = 0xFA
        /// </summary>
        CircularCwArcToNv = ((int)0xFA)        ,
        /// <summary>
        /// Original was GL_CIRCULAR_TANGENT_ARC_TO_NV = 0xFC
        /// </summary>
        CircularTangentArcToNv = ((int)0xFC)        ,
        /// <summary>
        /// Original was GL_ARC_TO_NV = 0xFE
        /// </summary>
        ArcToNv = ((int)0xFE)        ,
        /// <summary>
        /// Original was GL_RELATIVE_ARC_TO_NV = 0xFF
        /// </summary>
        RelativeArcToNv = ((int)0xFF)        ,
        /// <summary>
        /// Original was GL_ALL_ATTRIB_BITS = 0xFFFFFFFF
        /// </summary>
        AllAttribBits = unchecked((int)0xFFFFFFFF)        ,
        /// <summary>
        /// Original was GL_ALL_BARRIER_BITS = 0xFFFFFFFF
        /// </summary>
        AllBarrierBits = unchecked((int)0xFFFFFFFF)        ,
        /// <summary>
        /// Original was GL_ALL_BARRIER_BITS_EXT = 0xFFFFFFFF
        /// </summary>
        AllBarrierBitsExt = unchecked((int)0xFFFFFFFF)        ,
        /// <summary>
        /// Original was GL_ALL_SHADER_BITS = 0xFFFFFFFF
        /// </summary>
        AllShaderBits = unchecked((int)0xFFFFFFFF)        ,
        /// <summary>
        /// Original was GL_ALL_SHADER_BITS_EXT = 0xFFFFFFFF
        /// </summary>
        AllShaderBitsExt = unchecked((int)0xFFFFFFFF)        ,
        /// <summary>
        /// Original was GL_CLIENT_ALL_ATTRIB_BITS = 0xFFFFFFFF
        /// </summary>
        ClientAllAttribBits = unchecked((int)0xFFFFFFFF)        ,
        /// <summary>
        /// Original was GL_INVALID_INDEX = 0xFFFFFFFF
        /// </summary>
        InvalidIndex = unchecked((int)0xFFFFFFFF)        ,
        /// <summary>
        /// Original was GL_QUERY_ALL_EVENT_BITS_AMD = 0xFFFFFFFF
        /// </summary>
        QueryAllEventBitsAmd = unchecked((int)0xFFFFFFFF)        ,
        /// <summary>
        /// Original was GL_TIMEOUT_IGNORED = 0xFFFFFFFFFFFFFFFF
        /// </summary>
        TimeoutIgnored = unchecked((int)0xFFFFFFFFFFFFFFFF)        ,
        /// <summary>
        /// Original was GL_LAYOUT_LINEAR_INTEL = 1
        /// </summary>
        LayoutLinearIntel = ((int)1)        ,
        /// <summary>
        /// Original was GL_ONE = 1
        /// </summary>
        One = ((int)1)        ,
        /// <summary>
        /// Original was GL_TRUE = 1
        /// </summary>
        True = ((int)1)        ,
        /// <summary>
        /// Original was GL_CULL_VERTEX_IBM = 103050
        /// </summary>
        CullVertexIbm = ((int)103050)        ,
        /// <summary>
        /// Original was GL_ALL_STATIC_DATA_IBM = 103060
        /// </summary>
        AllStaticDataIbm = ((int)103060)        ,
        /// <summary>
        /// Original was GL_STATIC_VERTEX_ARRAY_IBM = 103061
        /// </summary>
        StaticVertexArrayIbm = ((int)103061)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_LIST_IBM = 103070
        /// </summary>
        VertexArrayListIbm = ((int)103070)        ,
        /// <summary>
        /// Original was GL_NORMAL_ARRAY_LIST_IBM = 103071
        /// </summary>
        NormalArrayListIbm = ((int)103071)        ,
        /// <summary>
        /// Original was GL_COLOR_ARRAY_LIST_IBM = 103072
        /// </summary>
        ColorArrayListIbm = ((int)103072)        ,
        /// <summary>
        /// Original was GL_INDEX_ARRAY_LIST_IBM = 103073
        /// </summary>
        IndexArrayListIbm = ((int)103073)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COORD_ARRAY_LIST_IBM = 103074
        /// </summary>
        TextureCoordArrayListIbm = ((int)103074)        ,
        /// <summary>
        /// Original was GL_EDGE_FLAG_ARRAY_LIST_IBM = 103075
        /// </summary>
        EdgeFlagArrayListIbm = ((int)103075)        ,
        /// <summary>
        /// Original was GL_FOG_COORDINATE_ARRAY_LIST_IBM = 103076
        /// </summary>
        FogCoordinateArrayListIbm = ((int)103076)        ,
        /// <summary>
        /// Original was GL_SECONDARY_COLOR_ARRAY_LIST_IBM = 103077
        /// </summary>
        SecondaryColorArrayListIbm = ((int)103077)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_LIST_STRIDE_IBM = 103080
        /// </summary>
        VertexArrayListStrideIbm = ((int)103080)        ,
        /// <summary>
        /// Original was GL_NORMAL_ARRAY_LIST_STRIDE_IBM = 103081
        /// </summary>
        NormalArrayListStrideIbm = ((int)103081)        ,
        /// <summary>
        /// Original was GL_COLOR_ARRAY_LIST_STRIDE_IBM = 103082
        /// </summary>
        ColorArrayListStrideIbm = ((int)103082)        ,
        /// <summary>
        /// Original was GL_INDEX_ARRAY_LIST_STRIDE_IBM = 103083
        /// </summary>
        IndexArrayListStrideIbm = ((int)103083)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM = 103084
        /// </summary>
        TextureCoordArrayListStrideIbm = ((int)103084)        ,
        /// <summary>
        /// Original was GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM = 103085
        /// </summary>
        EdgeFlagArrayListStrideIbm = ((int)103085)        ,
        /// <summary>
        /// Original was GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM = 103086
        /// </summary>
        FogCoordinateArrayListStrideIbm = ((int)103086)        ,
        /// <summary>
        /// Original was GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM = 103087
        /// </summary>
        SecondaryColorArrayListStrideIbm = ((int)103087)        ,
        /// <summary>
        /// Original was GL_LAYOUT_LINEAR_CPU_CACHED_INTEL = 2
        /// </summary>
        LayoutLinearCpuCachedIntel = ((int)2)        ,
        /// <summary>
        /// Original was GL_TWO = 2
        /// </summary>
        Two = ((int)2)        ,
        /// <summary>
        /// Original was GL_NEXT_BUFFER_NV = -2
        /// </summary>
        NextBufferNv = ((int)-2)        ,
        /// <summary>
        /// Original was GL_THREE = 3
        /// </summary>
        Three = ((int)3)        ,
        /// <summary>
        /// Original was GL_SKIP_COMPONENTS4_NV = -3
        /// </summary>
        SkipComponents4Nv = ((int)-3)        ,
        /// <summary>
        /// Original was GL_FOUR = 4
        /// </summary>
        Four = ((int)4)        ,
        /// <summary>
        /// Original was GL_SKIP_COMPONENTS3_NV = -4
        /// </summary>
        SkipComponents3Nv = ((int)-4)        ,
        /// <summary>
        /// Original was GL_SKIP_COMPONENTS2_NV = -5
        /// </summary>
        SkipComponents2Nv = ((int)-5)        ,
        /// <summary>
        /// Original was GL_SKIP_COMPONENTS1_NV = -6
        /// </summary>
        SkipComponents1Nv = ((int)-6)        ,
    }

    /// <summary>
    /// Used in GL.AlphaFunc
    /// </summary>
    public enum AlphaFunction : int
    {
        /// <summary>
        /// Original was GL_NEVER = 0x0200
        /// </summary>
        Never = ((int)0x0200)        ,
        /// <summary>
        /// Original was GL_LESS = 0x0201
        /// </summary>
        Less = ((int)0x0201)        ,
        /// <summary>
        /// Original was GL_EQUAL = 0x0202
        /// </summary>
        Equal = ((int)0x0202)        ,
        /// <summary>
        /// Original was GL_LEQUAL = 0x0203
        /// </summary>
        Lequal = ((int)0x0203)        ,
        /// <summary>
        /// Original was GL_GREATER = 0x0204
        /// </summary>
        Greater = ((int)0x0204)        ,
        /// <summary>
        /// Original was GL_NOTEQUAL = 0x0205
        /// </summary>
        Notequal = ((int)0x0205)        ,
        /// <summary>
        /// Original was GL_GEQUAL = 0x0206
        /// </summary>
        Gequal = ((int)0x0206)        ,
        /// <summary>
        /// Original was GL_ALWAYS = 0x0207
        /// </summary>
        Always = ((int)0x0207)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AmdBlendMinmaxFactor : int
    {
        /// <summary>
        /// Original was GL_FACTOR_MIN_AMD = 0x901C
        /// </summary>
        FactorMinAmd = ((int)0x901C)        ,
        /// <summary>
        /// Original was GL_FACTOR_MAX_AMD = 0x901D
        /// </summary>
        FactorMaxAmd = ((int)0x901D)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AmdConservativeDepth : int
    {
    }

    /// <summary>
    /// Used in GL.Amd.DebugMessageEnable, GL.Amd.DebugMessageInsert and 1 other function
    /// </summary>
    public enum AmdDebugOutput : int
    {
        /// <summary>
        /// Original was GL_MAX_DEBUG_MESSAGE_LENGTH_AMD = 0x9143
        /// </summary>
        MaxDebugMessageLengthAmd = ((int)0x9143)        ,
        /// <summary>
        /// Original was GL_MAX_DEBUG_LOGGED_MESSAGES_AMD = 0x9144
        /// </summary>
        MaxDebugLoggedMessagesAmd = ((int)0x9144)        ,
        /// <summary>
        /// Original was GL_DEBUG_LOGGED_MESSAGES_AMD = 0x9145
        /// </summary>
        DebugLoggedMessagesAmd = ((int)0x9145)        ,
        /// <summary>
        /// Original was GL_DEBUG_SEVERITY_HIGH_AMD = 0x9146
        /// </summary>
        DebugSeverityHighAmd = ((int)0x9146)        ,
        /// <summary>
        /// Original was GL_DEBUG_SEVERITY_MEDIUM_AMD = 0x9147
        /// </summary>
        DebugSeverityMediumAmd = ((int)0x9147)        ,
        /// <summary>
        /// Original was GL_DEBUG_SEVERITY_LOW_AMD = 0x9148
        /// </summary>
        DebugSeverityLowAmd = ((int)0x9148)        ,
        /// <summary>
        /// Original was GL_DEBUG_CATEGORY_API_ERROR_AMD = 0x9149
        /// </summary>
        DebugCategoryApiErrorAmd = ((int)0x9149)        ,
        /// <summary>
        /// Original was GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD = 0x914A
        /// </summary>
        DebugCategoryWindowSystemAmd = ((int)0x914A)        ,
        /// <summary>
        /// Original was GL_DEBUG_CATEGORY_DEPRECATION_AMD = 0x914B
        /// </summary>
        DebugCategoryDeprecationAmd = ((int)0x914B)        ,
        /// <summary>
        /// Original was GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD = 0x914C
        /// </summary>
        DebugCategoryUndefinedBehaviorAmd = ((int)0x914C)        ,
        /// <summary>
        /// Original was GL_DEBUG_CATEGORY_PERFORMANCE_AMD = 0x914D
        /// </summary>
        DebugCategoryPerformanceAmd = ((int)0x914D)        ,
        /// <summary>
        /// Original was GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD = 0x914E
        /// </summary>
        DebugCategoryShaderCompilerAmd = ((int)0x914E)        ,
        /// <summary>
        /// Original was GL_DEBUG_CATEGORY_APPLICATION_AMD = 0x914F
        /// </summary>
        DebugCategoryApplicationAmd = ((int)0x914F)        ,
        /// <summary>
        /// Original was GL_DEBUG_CATEGORY_OTHER_AMD = 0x9150
        /// </summary>
        DebugCategoryOtherAmd = ((int)0x9150)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AmdDepthClampSeparate : int
    {
        /// <summary>
        /// Original was GL_DEPTH_CLAMP_NEAR_AMD = 0x901E
        /// </summary>
        DepthClampNearAmd = ((int)0x901E)        ,
        /// <summary>
        /// Original was GL_DEPTH_CLAMP_FAR_AMD = 0x901F
        /// </summary>
        DepthClampFarAmd = ((int)0x901F)        ,
    }

    /// <summary>
    /// Used in GL.Amd.BlendEquationIndexed, GL.Amd.BlendEquationSeparateIndexed and 2 other functions
    /// </summary>
    public enum AmdDrawBuffersBlend : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AmdGcnShader : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AmdGpuShaderInt64 : int
    {
        /// <summary>
        /// Original was GL_INT64_NV = 0x140E
        /// </summary>
        Int64Nv = ((int)0x140E)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT64_NV = 0x140F
        /// </summary>
        UnsignedInt64Nv = ((int)0x140F)        ,
        /// <summary>
        /// Original was GL_INT8_NV = 0x8FE0
        /// </summary>
        Int8Nv = ((int)0x8FE0)        ,
        /// <summary>
        /// Original was GL_INT8_VEC2_NV = 0x8FE1
        /// </summary>
        Int8Vec2Nv = ((int)0x8FE1)        ,
        /// <summary>
        /// Original was GL_INT8_VEC3_NV = 0x8FE2
        /// </summary>
        Int8Vec3Nv = ((int)0x8FE2)        ,
        /// <summary>
        /// Original was GL_INT8_VEC4_NV = 0x8FE3
        /// </summary>
        Int8Vec4Nv = ((int)0x8FE3)        ,
        /// <summary>
        /// Original was GL_INT16_NV = 0x8FE4
        /// </summary>
        Int16Nv = ((int)0x8FE4)        ,
        /// <summary>
        /// Original was GL_INT16_VEC2_NV = 0x8FE5
        /// </summary>
        Int16Vec2Nv = ((int)0x8FE5)        ,
        /// <summary>
        /// Original was GL_INT16_VEC3_NV = 0x8FE6
        /// </summary>
        Int16Vec3Nv = ((int)0x8FE6)        ,
        /// <summary>
        /// Original was GL_INT16_VEC4_NV = 0x8FE7
        /// </summary>
        Int16Vec4Nv = ((int)0x8FE7)        ,
        /// <summary>
        /// Original was GL_INT64_VEC2_NV = 0x8FE9
        /// </summary>
        Int64Vec2Nv = ((int)0x8FE9)        ,
        /// <summary>
        /// Original was GL_INT64_VEC3_NV = 0x8FEA
        /// </summary>
        Int64Vec3Nv = ((int)0x8FEA)        ,
        /// <summary>
        /// Original was GL_INT64_VEC4_NV = 0x8FEB
        /// </summary>
        Int64Vec4Nv = ((int)0x8FEB)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT8_NV = 0x8FEC
        /// </summary>
        UnsignedInt8Nv = ((int)0x8FEC)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT8_VEC2_NV = 0x8FED
        /// </summary>
        UnsignedInt8Vec2Nv = ((int)0x8FED)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT8_VEC3_NV = 0x8FEE
        /// </summary>
        UnsignedInt8Vec3Nv = ((int)0x8FEE)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT8_VEC4_NV = 0x8FEF
        /// </summary>
        UnsignedInt8Vec4Nv = ((int)0x8FEF)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT16_NV = 0x8FF0
        /// </summary>
        UnsignedInt16Nv = ((int)0x8FF0)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT16_VEC2_NV = 0x8FF1
        /// </summary>
        UnsignedInt16Vec2Nv = ((int)0x8FF1)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT16_VEC3_NV = 0x8FF2
        /// </summary>
        UnsignedInt16Vec3Nv = ((int)0x8FF2)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT16_VEC4_NV = 0x8FF3
        /// </summary>
        UnsignedInt16Vec4Nv = ((int)0x8FF3)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT64_VEC2_NV = 0x8FF5
        /// </summary>
        UnsignedInt64Vec2Nv = ((int)0x8FF5)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT64_VEC3_NV = 0x8FF6
        /// </summary>
        UnsignedInt64Vec3Nv = ((int)0x8FF6)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT64_VEC4_NV = 0x8FF7
        /// </summary>
        UnsignedInt64Vec4Nv = ((int)0x8FF7)        ,
        /// <summary>
        /// Original was GL_FLOAT16_NV = 0x8FF8
        /// </summary>
        Float16Nv = ((int)0x8FF8)        ,
        /// <summary>
        /// Original was GL_FLOAT16_VEC2_NV = 0x8FF9
        /// </summary>
        Float16Vec2Nv = ((int)0x8FF9)        ,
        /// <summary>
        /// Original was GL_FLOAT16_VEC3_NV = 0x8FFA
        /// </summary>
        Float16Vec3Nv = ((int)0x8FFA)        ,
        /// <summary>
        /// Original was GL_FLOAT16_VEC4_NV = 0x8FFB
        /// </summary>
        Float16Vec4Nv = ((int)0x8FFB)        ,
    }

    /// <summary>
    /// Used in GL.Amd.VertexAttribParameter
    /// </summary>
    public enum AmdInterleavedElements : int
    {
        /// <summary>
        /// Original was GL_RED = 0x1903
        /// </summary>
        Red = ((int)0x1903)        ,
        /// <summary>
        /// Original was GL_GREEN = 0x1904
        /// </summary>
        Green = ((int)0x1904)        ,
        /// <summary>
        /// Original was GL_BLUE = 0x1905
        /// </summary>
        Blue = ((int)0x1905)        ,
        /// <summary>
        /// Original was GL_ALPHA = 0x1906
        /// </summary>
        Alpha = ((int)0x1906)        ,
        /// <summary>
        /// Original was GL_RG8UI = 0x8238
        /// </summary>
        Rg8ui = ((int)0x8238)        ,
        /// <summary>
        /// Original was GL_RG16UI = 0x823A
        /// </summary>
        Rg16ui = ((int)0x823A)        ,
        /// <summary>
        /// Original was GL_RGBA8UI = 0x8D7C
        /// </summary>
        Rgba8ui = ((int)0x8D7C)        ,
        /// <summary>
        /// Original was GL_VERTEX_ELEMENT_SWIZZLE_AMD = 0x91A4
        /// </summary>
        VertexElementSwizzleAmd = ((int)0x91A4)        ,
        /// <summary>
        /// Original was GL_VERTEX_ID_SWIZZLE_AMD = 0x91A5
        /// </summary>
        VertexIdSwizzleAmd = ((int)0x91A5)        ,
    }

    /// <summary>
    /// Used in GL.Amd.MultiDrawArraysIndirect, GL.Amd.MultiDrawElementsIndirect
    /// </summary>
    public enum AmdMultiDrawIndirect : int
    {
    }

    /// <summary>
    /// Used in GL.Amd.DeleteNames, GL.Amd.GenNames and 1 other function
    /// </summary>
    public enum AmdNameGenDelete : int
    {
        /// <summary>
        /// Original was GL_DATA_BUFFER_AMD = 0x9151
        /// </summary>
        DataBufferAmd = ((int)0x9151)        ,
        /// <summary>
        /// Original was GL_PERFORMANCE_MONITOR_AMD = 0x9152
        /// </summary>
        PerformanceMonitorAmd = ((int)0x9152)        ,
        /// <summary>
        /// Original was GL_QUERY_OBJECT_AMD = 0x9153
        /// </summary>
        QueryObjectAmd = ((int)0x9153)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_OBJECT_AMD = 0x9154
        /// </summary>
        VertexArrayObjectAmd = ((int)0x9154)        ,
        /// <summary>
        /// Original was GL_SAMPLER_OBJECT_AMD = 0x9155
        /// </summary>
        SamplerObjectAmd = ((int)0x9155)        ,
    }

    /// <summary>
    /// Used in GL.Amd.QueryObjectParameter
    /// </summary>
    public enum AmdOcclusionQueryEvent : int
    {
        /// <summary>
        /// Original was GL_QUERY_DEPTH_PASS_EVENT_BIT_AMD = 0x00000001
        /// </summary>
        QueryDepthPassEventBitAmd = ((int)0x00000001)        ,
        /// <summary>
        /// Original was GL_QUERY_DEPTH_FAIL_EVENT_BIT_AMD = 0x00000002
        /// </summary>
        QueryDepthFailEventBitAmd = ((int)0x00000002)        ,
        /// <summary>
        /// Original was GL_QUERY_STENCIL_FAIL_EVENT_BIT_AMD = 0x00000004
        /// </summary>
        QueryStencilFailEventBitAmd = ((int)0x00000004)        ,
        /// <summary>
        /// Original was GL_QUERY_DEPTH_BOUNDS_FAIL_EVENT_BIT_AMD = 0x00000008
        /// </summary>
        QueryDepthBoundsFailEventBitAmd = ((int)0x00000008)        ,
        /// <summary>
        /// Original was GL_OCCLUSION_QUERY_EVENT_MASK_AMD = 0x874F
        /// </summary>
        OcclusionQueryEventMaskAmd = ((int)0x874F)        ,
        /// <summary>
        /// Original was GL_QUERY_ALL_EVENT_BITS_AMD = 0xFFFFFFFF
        /// </summary>
        QueryAllEventBitsAmd = unchecked((int)0xFFFFFFFF)        ,
    }

    /// <summary>
    /// Used in GL.Amd.GetPerfMonitorCounterData, GL.Amd.GetPerfMonitorCounterInfo
    /// </summary>
    public enum AmdPerformanceMonitor : int
    {
        /// <summary>
        /// Original was GL_COUNTER_TYPE_AMD = 0x8BC0
        /// </summary>
        CounterTypeAmd = ((int)0x8BC0)        ,
        /// <summary>
        /// Original was GL_COUNTER_RANGE_AMD = 0x8BC1
        /// </summary>
        CounterRangeAmd = ((int)0x8BC1)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT64_AMD = 0x8BC2
        /// </summary>
        UnsignedInt64Amd = ((int)0x8BC2)        ,
        /// <summary>
        /// Original was GL_PERCENTAGE_AMD = 0x8BC3
        /// </summary>
        PercentageAmd = ((int)0x8BC3)        ,
        /// <summary>
        /// Original was GL_PERFMON_RESULT_AVAILABLE_AMD = 0x8BC4
        /// </summary>
        PerfmonResultAvailableAmd = ((int)0x8BC4)        ,
        /// <summary>
        /// Original was GL_PERFMON_RESULT_SIZE_AMD = 0x8BC5
        /// </summary>
        PerfmonResultSizeAmd = ((int)0x8BC5)        ,
        /// <summary>
        /// Original was GL_PERFMON_RESULT_AMD = 0x8BC6
        /// </summary>
        PerfmonResultAmd = ((int)0x8BC6)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AmdPinnedMemory : int
    {
        /// <summary>
        /// Original was GL_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD = 0x9160
        /// </summary>
        ExternalVirtualMemoryBufferAmd = ((int)0x9160)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AmdQueryBufferObject : int
    {
        /// <summary>
        /// Original was GL_QUERY_BUFFER_AMD = 0x9192
        /// </summary>
        QueryBufferAmd = ((int)0x9192)        ,
        /// <summary>
        /// Original was GL_QUERY_BUFFER_BINDING_AMD = 0x9193
        /// </summary>
        QueryBufferBindingAmd = ((int)0x9193)        ,
        /// <summary>
        /// Original was GL_QUERY_RESULT_NO_WAIT_AMD = 0x9194
        /// </summary>
        QueryResultNoWaitAmd = ((int)0x9194)        ,
    }

    /// <summary>
    /// Used in GL.Amd.SetMultisample
    /// </summary>
    public enum AmdSamplePositions : int
    {
        /// <summary>
        /// Original was GL_SUBSAMPLE_DISTANCE_AMD = 0x883F
        /// </summary>
        SubsampleDistanceAmd = ((int)0x883F)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AmdSeamlessCubemapPerTexture : int
    {
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_SEAMLESS = 0x884F
        /// </summary>
        TextureCubeMapSeamless = ((int)0x884F)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AmdShaderAtomicCounterOps : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AmdShaderStencilExport : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AmdShaderTrinaryMinmax : int
    {
    }

    /// <summary>
    /// Used in GL.Amd.TexStorageSparse, GL.Amd.TextureStorageSparse
    /// </summary>
    public enum AmdSparseTexture : int
    {
        /// <summary>
        /// Original was GL_TEXTURE_STORAGE_SPARSE_BIT_AMD = 0x00000001
        /// </summary>
        TextureStorageSparseBitAmd = ((int)0x00000001)        ,
        /// <summary>
        /// Original was GL_VIRTUAL_PAGE_SIZE_X_AMD = 0x9195
        /// </summary>
        VirtualPageSizeXAmd = ((int)0x9195)        ,
        /// <summary>
        /// Original was GL_VIRTUAL_PAGE_SIZE_Y_AMD = 0x9196
        /// </summary>
        VirtualPageSizeYAmd = ((int)0x9196)        ,
        /// <summary>
        /// Original was GL_VIRTUAL_PAGE_SIZE_Z_AMD = 0x9197
        /// </summary>
        VirtualPageSizeZAmd = ((int)0x9197)        ,
        /// <summary>
        /// Original was GL_MAX_SPARSE_TEXTURE_SIZE_AMD = 0x9198
        /// </summary>
        MaxSparseTextureSizeAmd = ((int)0x9198)        ,
        /// <summary>
        /// Original was GL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD = 0x9199
        /// </summary>
        MaxSparse3DTextureSizeAmd = ((int)0x9199)        ,
        /// <summary>
        /// Original was GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS = 0x919A
        /// </summary>
        MaxSparseArrayTextureLayers = ((int)0x919A)        ,
        /// <summary>
        /// Original was GL_MIN_SPARSE_LEVEL_AMD = 0x919B
        /// </summary>
        MinSparseLevelAmd = ((int)0x919B)        ,
        /// <summary>
        /// Original was GL_MIN_LOD_WARNING_AMD = 0x919C
        /// </summary>
        MinLodWarningAmd = ((int)0x919C)        ,
    }

    /// <summary>
    /// Used in GL.Amd.StencilOpValue
    /// </summary>
    public enum AmdStencilOperationExtended : int
    {
        /// <summary>
        /// Original was GL_SET_AMD = 0x874A
        /// </summary>
        SetAmd = ((int)0x874A)        ,
        /// <summary>
        /// Original was GL_REPLACE_VALUE_AMD = 0x874B
        /// </summary>
        ReplaceValueAmd = ((int)0x874B)        ,
        /// <summary>
        /// Original was GL_STENCIL_OP_VALUE_AMD = 0x874C
        /// </summary>
        StencilOpValueAmd = ((int)0x874C)        ,
        /// <summary>
        /// Original was GL_STENCIL_BACK_OP_VALUE_AMD = 0x874D
        /// </summary>
        StencilBackOpValueAmd = ((int)0x874D)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AmdTextureTexture4 : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AmdTransformFeedback3LinesTriangles : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AmdTransformFeedback4 : int
    {
        /// <summary>
        /// Original was GL_STREAM_RASTERIZATION_AMD = 0x91A0
        /// </summary>
        StreamRasterizationAmd = ((int)0x91A0)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AmdVertexShaderLayer : int
    {
    }

    /// <summary>
    /// Used in GL.Amd.TessellationMode
    /// </summary>
    public enum AmdVertexShaderTesselator : int
    {
        /// <summary>
        /// Original was GL_SAMPLER_BUFFER_AMD = 0x9001
        /// </summary>
        SamplerBufferAmd = ((int)0x9001)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_BUFFER_AMD = 0x9002
        /// </summary>
        IntSamplerBufferAmd = ((int)0x9002)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_BUFFER_AMD = 0x9003
        /// </summary>
        UnsignedIntSamplerBufferAmd = ((int)0x9003)        ,
        /// <summary>
        /// Original was GL_TESSELLATION_MODE_AMD = 0x9004
        /// </summary>
        TessellationModeAmd = ((int)0x9004)        ,
        /// <summary>
        /// Original was GL_TESSELLATION_FACTOR_AMD = 0x9005
        /// </summary>
        TessellationFactorAmd = ((int)0x9005)        ,
        /// <summary>
        /// Original was GL_DISCRETE_AMD = 0x9006
        /// </summary>
        DiscreteAmd = ((int)0x9006)        ,
        /// <summary>
        /// Original was GL_CONTINUOUS_AMD = 0x9007
        /// </summary>
        ContinuousAmd = ((int)0x9007)        ,
    }

    /// <summary>
    /// Used in GL.Amd.TessellationMode
    /// </summary>
    public enum AmdVertexShaderTessellator : int
    {
        /// <summary>
        /// Original was GL_SAMPLER_BUFFER_AMD = 0x9001
        /// </summary>
        SamplerBufferAmd = ((int)0x9001)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_BUFFER_AMD = 0x9002
        /// </summary>
        IntSamplerBufferAmd = ((int)0x9002)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_BUFFER_AMD = 0x9003
        /// </summary>
        UnsignedIntSamplerBufferAmd = ((int)0x9003)        ,
        /// <summary>
        /// Original was GL_TESSELLATION_MODE_AMD = 0x9004
        /// </summary>
        TessellationModeAmd = ((int)0x9004)        ,
        /// <summary>
        /// Original was GL_TESSELLATION_FACTOR_AMD = 0x9005
        /// </summary>
        TessellationFactorAmd = ((int)0x9005)        ,
        /// <summary>
        /// Original was GL_DISCRETE_AMD = 0x9006
        /// </summary>
        DiscreteAmd = ((int)0x9006)        ,
        /// <summary>
        /// Original was GL_CONTINUOUS_AMD = 0x9007
        /// </summary>
        ContinuousAmd = ((int)0x9007)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AmdVertexShaderViewportIndex : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AppleAuxDepthStencil : int
    {
        /// <summary>
        /// Original was GL_AUX_DEPTH_STENCIL_APPLE = 0x8A14
        /// </summary>
        AuxDepthStencilApple = ((int)0x8A14)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AppleClientStorage : int
    {
        /// <summary>
        /// Original was GL_UNPACK_CLIENT_STORAGE_APPLE = 0x85B2
        /// </summary>
        UnpackClientStorageApple = ((int)0x85B2)        ,
    }

    /// <summary>
    /// Used in GL.Apple.ElementPointer
    /// </summary>
    public enum AppleElementArray : int
    {
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_APPLE = 0x8A0C
        /// </summary>
        ElementArrayApple = ((int)0x8A0C)        ,
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_TYPE_APPLE = 0x8A0D
        /// </summary>
        ElementArrayTypeApple = ((int)0x8A0D)        ,
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_POINTER_APPLE = 0x8A0E
        /// </summary>
        ElementArrayPointerApple = ((int)0x8A0E)        ,
    }

    /// <summary>
    /// Used in GL.Apple.FinishObject, GL.Apple.TestObject
    /// </summary>
    public enum AppleFence : int
    {
        /// <summary>
        /// Original was GL_DRAW_PIXELS_APPLE = 0x8A0A
        /// </summary>
        DrawPixelsApple = ((int)0x8A0A)        ,
        /// <summary>
        /// Original was GL_FENCE_APPLE = 0x8A0B
        /// </summary>
        FenceApple = ((int)0x8A0B)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AppleFloatPixels : int
    {
        /// <summary>
        /// Original was GL_HALF_APPLE = 0x140B
        /// </summary>
        HalfApple = ((int)0x140B)        ,
        /// <summary>
        /// Original was GL_RGBA_FLOAT32_APPLE = 0x8814
        /// </summary>
        RgbaFloat32Apple = ((int)0x8814)        ,
        /// <summary>
        /// Original was GL_RGB_FLOAT32_APPLE = 0x8815
        /// </summary>
        RgbFloat32Apple = ((int)0x8815)        ,
        /// <summary>
        /// Original was GL_ALPHA_FLOAT32_APPLE = 0x8816
        /// </summary>
        AlphaFloat32Apple = ((int)0x8816)        ,
        /// <summary>
        /// Original was GL_INTENSITY_FLOAT32_APPLE = 0x8817
        /// </summary>
        IntensityFloat32Apple = ((int)0x8817)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_FLOAT32_APPLE = 0x8818
        /// </summary>
        LuminanceFloat32Apple = ((int)0x8818)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ALPHA_FLOAT32_APPLE = 0x8819
        /// </summary>
        LuminanceAlphaFloat32Apple = ((int)0x8819)        ,
        /// <summary>
        /// Original was GL_RGBA_FLOAT16_APPLE = 0x881A
        /// </summary>
        RgbaFloat16Apple = ((int)0x881A)        ,
        /// <summary>
        /// Original was GL_RGB_FLOAT16_APPLE = 0x881B
        /// </summary>
        RgbFloat16Apple = ((int)0x881B)        ,
        /// <summary>
        /// Original was GL_ALPHA_FLOAT16_APPLE = 0x881C
        /// </summary>
        AlphaFloat16Apple = ((int)0x881C)        ,
        /// <summary>
        /// Original was GL_INTENSITY_FLOAT16_APPLE = 0x881D
        /// </summary>
        IntensityFloat16Apple = ((int)0x881D)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_FLOAT16_APPLE = 0x881E
        /// </summary>
        LuminanceFloat16Apple = ((int)0x881E)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ALPHA_FLOAT16_APPLE = 0x881F
        /// </summary>
        LuminanceAlphaFloat16Apple = ((int)0x881F)        ,
        /// <summary>
        /// Original was GL_COLOR_FLOAT_APPLE = 0x8A0F
        /// </summary>
        ColorFloatApple = ((int)0x8A0F)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AppleFlushBufferRange : int
    {
        /// <summary>
        /// Original was GL_BUFFER_SERIALIZED_MODIFY_APPLE = 0x8A12
        /// </summary>
        BufferSerializedModifyApple = ((int)0x8A12)        ,
        /// <summary>
        /// Original was GL_BUFFER_FLUSHING_UNMAP_APPLE = 0x8A13
        /// </summary>
        BufferFlushingUnmapApple = ((int)0x8A13)        ,
    }

    /// <summary>
    /// Used in GL.Apple.GetObjectParameter, GL.Apple.ObjectPurgeable and 1 other function
    /// </summary>
    public enum AppleObjectPurgeable : int
    {
        /// <summary>
        /// Original was GL_BUFFER_OBJECT_APPLE = 0x85B3
        /// </summary>
        BufferObjectApple = ((int)0x85B3)        ,
        /// <summary>
        /// Original was GL_RELEASED_APPLE = 0x8A19
        /// </summary>
        ReleasedApple = ((int)0x8A19)        ,
        /// <summary>
        /// Original was GL_VOLATILE_APPLE = 0x8A1A
        /// </summary>
        VolatileApple = ((int)0x8A1A)        ,
        /// <summary>
        /// Original was GL_RETAINED_APPLE = 0x8A1B
        /// </summary>
        RetainedApple = ((int)0x8A1B)        ,
        /// <summary>
        /// Original was GL_UNDEFINED_APPLE = 0x8A1C
        /// </summary>
        UndefinedApple = ((int)0x8A1C)        ,
        /// <summary>
        /// Original was GL_PURGEABLE_APPLE = 0x8A1D
        /// </summary>
        PurgeableApple = ((int)0x8A1D)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AppleRgb422 : int
    {
        /// <summary>
        /// Original was GL_UNSIGNED_SHORT_8_8_APPLE = 0x85BA
        /// </summary>
        UnsignedShort88Apple = ((int)0x85BA)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_SHORT_8_8_REV_APPLE = 0x85BB
        /// </summary>
        UnsignedShort88RevApple = ((int)0x85BB)        ,
        /// <summary>
        /// Original was GL_RGB_422_APPLE = 0x8A1F
        /// </summary>
        Rgb422Apple = ((int)0x8A1F)        ,
        /// <summary>
        /// Original was GL_RGB_RAW_422_APPLE = 0x8A51
        /// </summary>
        RgbRaw422Apple = ((int)0x8A51)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AppleRowBytes : int
    {
        /// <summary>
        /// Original was GL_PACK_ROW_BYTES_APPLE = 0x8A15
        /// </summary>
        PackRowBytesApple = ((int)0x8A15)        ,
        /// <summary>
        /// Original was GL_UNPACK_ROW_BYTES_APPLE = 0x8A16
        /// </summary>
        UnpackRowBytesApple = ((int)0x8A16)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AppleSpecularVector : int
    {
        /// <summary>
        /// Original was GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE = 0x85B0
        /// </summary>
        LightModelSpecularVectorApple = ((int)0x85B0)        ,
    }

    /// <summary>
    /// Used in GL.Apple.GetTexParameterPointer, GL.Apple.TextureRange
    /// </summary>
    public enum AppleTextureRange : int
    {
        /// <summary>
        /// Original was GL_TEXTURE_RANGE_LENGTH_APPLE = 0x85B7
        /// </summary>
        TextureRangeLengthApple = ((int)0x85B7)        ,
        /// <summary>
        /// Original was GL_TEXTURE_RANGE_POINTER_APPLE = 0x85B8
        /// </summary>
        TextureRangePointerApple = ((int)0x85B8)        ,
        /// <summary>
        /// Original was GL_TEXTURE_STORAGE_HINT_APPLE = 0x85BC
        /// </summary>
        TextureStorageHintApple = ((int)0x85BC)        ,
        /// <summary>
        /// Original was GL_STORAGE_PRIVATE_APPLE = 0x85BD
        /// </summary>
        StoragePrivateApple = ((int)0x85BD)        ,
        /// <summary>
        /// Original was GL_STORAGE_CACHED_APPLE = 0x85BE
        /// </summary>
        StorageCachedApple = ((int)0x85BE)        ,
        /// <summary>
        /// Original was GL_STORAGE_SHARED_APPLE = 0x85BF
        /// </summary>
        StorageSharedApple = ((int)0x85BF)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AppleTransformHint : int
    {
        /// <summary>
        /// Original was GL_TRANSFORM_HINT_APPLE = 0x85B1
        /// </summary>
        TransformHintApple = ((int)0x85B1)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AppleVertexArrayObject : int
    {
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_BINDING_APPLE = 0x85B5
        /// </summary>
        VertexArrayBindingApple = ((int)0x85B5)        ,
    }

    /// <summary>
    /// Used in GL.Apple.VertexArrayParameter
    /// </summary>
    public enum AppleVertexArrayRange : int
    {
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_RANGE_APPLE = 0x851D
        /// </summary>
        VertexArrayRangeApple = ((int)0x851D)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE = 0x851E
        /// </summary>
        VertexArrayRangeLengthApple = ((int)0x851E)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_STORAGE_HINT_APPLE = 0x851F
        /// </summary>
        VertexArrayStorageHintApple = ((int)0x851F)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_RANGE_POINTER_APPLE = 0x8521
        /// </summary>
        VertexArrayRangePointerApple = ((int)0x8521)        ,
        /// <summary>
        /// Original was GL_STORAGE_CLIENT_APPLE = 0x85B4
        /// </summary>
        StorageClientApple = ((int)0x85B4)        ,
        /// <summary>
        /// Original was GL_STORAGE_CACHED_APPLE = 0x85BE
        /// </summary>
        StorageCachedApple = ((int)0x85BE)        ,
        /// <summary>
        /// Original was GL_STORAGE_SHARED_APPLE = 0x85BF
        /// </summary>
        StorageSharedApple = ((int)0x85BF)        ,
    }

    /// <summary>
    /// Used in GL.Apple.DisableVertexAttrib, GL.Apple.EnableVertexAttrib and 1 other function
    /// </summary>
    public enum AppleVertexProgramEvaluators : int
    {
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_MAP1_APPLE = 0x8A00
        /// </summary>
        VertexAttribMap1Apple = ((int)0x8A00)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_MAP2_APPLE = 0x8A01
        /// </summary>
        VertexAttribMap2Apple = ((int)0x8A01)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_MAP1_SIZE_APPLE = 0x8A02
        /// </summary>
        VertexAttribMap1SizeApple = ((int)0x8A02)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_MAP1_COEFF_APPLE = 0x8A03
        /// </summary>
        VertexAttribMap1CoeffApple = ((int)0x8A03)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_MAP1_ORDER_APPLE = 0x8A04
        /// </summary>
        VertexAttribMap1OrderApple = ((int)0x8A04)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE = 0x8A05
        /// </summary>
        VertexAttribMap1DomainApple = ((int)0x8A05)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_MAP2_SIZE_APPLE = 0x8A06
        /// </summary>
        VertexAttribMap2SizeApple = ((int)0x8A06)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_MAP2_COEFF_APPLE = 0x8A07
        /// </summary>
        VertexAttribMap2CoeffApple = ((int)0x8A07)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_MAP2_ORDER_APPLE = 0x8A08
        /// </summary>
        VertexAttribMap2OrderApple = ((int)0x8A08)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE = 0x8A09
        /// </summary>
        VertexAttribMap2DomainApple = ((int)0x8A09)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum AppleYcbcr422 : int
    {
        /// <summary>
        /// Original was GL_YCBCR_422_APPLE = 0x85B9
        /// </summary>
        Ycbcr422Apple = ((int)0x85B9)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_SHORT_8_8_APPLE = 0x85BA
        /// </summary>
        UnsignedShort88Apple = ((int)0x85BA)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_SHORT_8_8_REV_APPLE = 0x85BB
        /// </summary>
        UnsignedShort88RevApple = ((int)0x85BB)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbArraysOfArrays : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbBaseInstance : int
    {
    }

    /// <summary>
    /// Used in GL.Arb.GetImageHandle, GL.Arb.MakeImageHandleResident
    /// </summary>
    public enum ArbBindlessTexture : int
    {
        /// <summary>
        /// Original was GL_UNSIGNED_INT64_ARB = 0x140F
        /// </summary>
        UnsignedInt64Arb = ((int)0x140F)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbBlendFuncExtended : int
    {
        /// <summary>
        /// Original was GL_SRC1_ALPHA = 0x8589
        /// </summary>
        Src1Alpha = ((int)0x8589)        ,
        /// <summary>
        /// Original was GL_SRC1_COLOR = 0x88F9
        /// </summary>
        Src1Color = ((int)0x88F9)        ,
        /// <summary>
        /// Original was GL_ONE_MINUS_SRC1_COLOR = 0x88FA
        /// </summary>
        OneMinusSrc1Color = ((int)0x88FA)        ,
        /// <summary>
        /// Original was GL_ONE_MINUS_SRC1_ALPHA = 0x88FB
        /// </summary>
        OneMinusSrc1Alpha = ((int)0x88FB)        ,
        /// <summary>
        /// Original was GL_MAX_DUAL_SOURCE_DRAW_BUFFERS = 0x88FC
        /// </summary>
        MaxDualSourceDrawBuffers = ((int)0x88FC)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbBufferStorage : int
    {
        /// <summary>
        /// Original was GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT = 0x00004000
        /// </summary>
        ClientMappedBufferBarrierBit = ((int)0x00004000)        ,
        /// <summary>
        /// Original was GL_MAP_READ_BIT = 0x0001
        /// </summary>
        MapReadBit = ((int)0x0001)        ,
        /// <summary>
        /// Original was GL_MAP_WRITE_BIT = 0x0002
        /// </summary>
        MapWriteBit = ((int)0x0002)        ,
        /// <summary>
        /// Original was GL_MAP_PERSISTENT_BIT = 0x0040
        /// </summary>
        MapPersistentBit = ((int)0x0040)        ,
        /// <summary>
        /// Original was GL_MAP_COHERENT_BIT = 0x0080
        /// </summary>
        MapCoherentBit = ((int)0x0080)        ,
        /// <summary>
        /// Original was GL_DYNAMIC_STORAGE_BIT = 0x0100
        /// </summary>
        DynamicStorageBit = ((int)0x0100)        ,
        /// <summary>
        /// Original was GL_CLIENT_STORAGE_BIT = 0x0200
        /// </summary>
        ClientStorageBit = ((int)0x0200)        ,
        /// <summary>
        /// Original was GL_BUFFER_IMMUTABLE_STORAGE = 0x821F
        /// </summary>
        BufferImmutableStorage = ((int)0x821F)        ,
        /// <summary>
        /// Original was GL_BUFFER_STORAGE_FLAGS = 0x8220
        /// </summary>
        BufferStorageFlags = ((int)0x8220)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbClearBufferObject : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbClearTexture : int
    {
        /// <summary>
        /// Original was GL_CLEAR_TEXTURE = 0x9365
        /// </summary>
        ClearTexture = ((int)0x9365)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbClEvent : int
    {
        /// <summary>
        /// Original was GL_SYNC_CL_EVENT_ARB = 0x8240
        /// </summary>
        SyncClEventArb = ((int)0x8240)        ,
        /// <summary>
        /// Original was GL_SYNC_CL_EVENT_COMPLETE_ARB = 0x8241
        /// </summary>
        SyncClEventCompleteArb = ((int)0x8241)        ,
    }

    /// <summary>
    /// Used in GL.Arb.ClampColor
    /// </summary>
    public enum ArbColorBufferFloat : int
    {
        /// <summary>
        /// Original was GL_RGBA_FLOAT_MODE_ARB = 0x8820
        /// </summary>
        RgbaFloatModeArb = ((int)0x8820)        ,
        /// <summary>
        /// Original was GL_CLAMP_VERTEX_COLOR_ARB = 0x891A
        /// </summary>
        ClampVertexColorArb = ((int)0x891A)        ,
        /// <summary>
        /// Original was GL_CLAMP_FRAGMENT_COLOR_ARB = 0x891B
        /// </summary>
        ClampFragmentColorArb = ((int)0x891B)        ,
        /// <summary>
        /// Original was GL_CLAMP_READ_COLOR_ARB = 0x891C
        /// </summary>
        ClampReadColorArb = ((int)0x891C)        ,
        /// <summary>
        /// Original was GL_FIXED_ONLY_ARB = 0x891D
        /// </summary>
        FixedOnlyArb = ((int)0x891D)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbCompatibility : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbCompressedTexturePixelStorage : int
    {
        /// <summary>
        /// Original was GL_UNPACK_COMPRESSED_BLOCK_WIDTH = 0x9127
        /// </summary>
        UnpackCompressedBlockWidth = ((int)0x9127)        ,
        /// <summary>
        /// Original was GL_UNPACK_COMPRESSED_BLOCK_HEIGHT = 0x9128
        /// </summary>
        UnpackCompressedBlockHeight = ((int)0x9128)        ,
        /// <summary>
        /// Original was GL_UNPACK_COMPRESSED_BLOCK_DEPTH = 0x9129
        /// </summary>
        UnpackCompressedBlockDepth = ((int)0x9129)        ,
        /// <summary>
        /// Original was GL_UNPACK_COMPRESSED_BLOCK_SIZE = 0x912A
        /// </summary>
        UnpackCompressedBlockSize = ((int)0x912A)        ,
        /// <summary>
        /// Original was GL_PACK_COMPRESSED_BLOCK_WIDTH = 0x912B
        /// </summary>
        PackCompressedBlockWidth = ((int)0x912B)        ,
        /// <summary>
        /// Original was GL_PACK_COMPRESSED_BLOCK_HEIGHT = 0x912C
        /// </summary>
        PackCompressedBlockHeight = ((int)0x912C)        ,
        /// <summary>
        /// Original was GL_PACK_COMPRESSED_BLOCK_DEPTH = 0x912D
        /// </summary>
        PackCompressedBlockDepth = ((int)0x912D)        ,
        /// <summary>
        /// Original was GL_PACK_COMPRESSED_BLOCK_SIZE = 0x912E
        /// </summary>
        PackCompressedBlockSize = ((int)0x912E)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbComputeShader : int
    {
        /// <summary>
        /// Original was GL_COMPUTE_SHADER_BIT = 0x00000020
        /// </summary>
        ComputeShaderBit = ((int)0x00000020)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_SHARED_MEMORY_SIZE = 0x8262
        /// </summary>
        MaxComputeSharedMemorySize = ((int)0x8262)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_UNIFORM_COMPONENTS = 0x8263
        /// </summary>
        MaxComputeUniformComponents = ((int)0x8263)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS = 0x8264
        /// </summary>
        MaxComputeAtomicCounterBuffers = ((int)0x8264)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_ATOMIC_COUNTERS = 0x8265
        /// </summary>
        MaxComputeAtomicCounters = ((int)0x8265)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS = 0x8266
        /// </summary>
        MaxCombinedComputeUniformComponents = ((int)0x8266)        ,
        /// <summary>
        /// Original was GL_COMPUTE_WORK_GROUP_SIZE = 0x8267
        /// </summary>
        ComputeWorkGroupSize = ((int)0x8267)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS = 0x90EB
        /// </summary>
        MaxComputeWorkGroupInvocations = ((int)0x90EB)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER = 0x90EC
        /// </summary>
        UniformBlockReferencedByComputeShader = ((int)0x90EC)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER = 0x90ED
        /// </summary>
        AtomicCounterBufferReferencedByComputeShader = ((int)0x90ED)        ,
        /// <summary>
        /// Original was GL_DISPATCH_INDIRECT_BUFFER = 0x90EE
        /// </summary>
        DispatchIndirectBuffer = ((int)0x90EE)        ,
        /// <summary>
        /// Original was GL_DISPATCH_INDIRECT_BUFFER_BINDING = 0x90EF
        /// </summary>
        DispatchIndirectBufferBinding = ((int)0x90EF)        ,
        /// <summary>
        /// Original was GL_COMPUTE_SHADER = 0x91B9
        /// </summary>
        ComputeShader = ((int)0x91B9)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_UNIFORM_BLOCKS = 0x91BB
        /// </summary>
        MaxComputeUniformBlocks = ((int)0x91BB)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS = 0x91BC
        /// </summary>
        MaxComputeTextureImageUnits = ((int)0x91BC)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_IMAGE_UNIFORMS = 0x91BD
        /// </summary>
        MaxComputeImageUniforms = ((int)0x91BD)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_WORK_GROUP_COUNT = 0x91BE
        /// </summary>
        MaxComputeWorkGroupCount = ((int)0x91BE)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_WORK_GROUP_SIZE = 0x91BF
        /// </summary>
        MaxComputeWorkGroupSize = ((int)0x91BF)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbComputeVariableGroupSize : int
    {
        /// <summary>
        /// Original was GL_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB = 0x90EB
        /// </summary>
        MaxComputeFixedGroupInvocationsArb = ((int)0x90EB)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB = 0x91BF
        /// </summary>
        MaxComputeFixedGroupSizeArb = ((int)0x91BF)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB = 0x9344
        /// </summary>
        MaxComputeVariableGroupInvocationsArb = ((int)0x9344)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB = 0x9345
        /// </summary>
        MaxComputeVariableGroupSizeArb = ((int)0x9345)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbConservativeDepth : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbCopyBuffer : int
    {
        /// <summary>
        /// Original was GL_COPY_READ_BUFFER = 0x8F36
        /// </summary>
        CopyReadBuffer = ((int)0x8F36)        ,
        /// <summary>
        /// Original was GL_COPY_READ_BUFFER_BINDING = 0x8F36
        /// </summary>
        CopyReadBufferBinding = ((int)0x8F36)        ,
        /// <summary>
        /// Original was GL_COPY_WRITE_BUFFER = 0x8F37
        /// </summary>
        CopyWriteBuffer = ((int)0x8F37)        ,
        /// <summary>
        /// Original was GL_COPY_WRITE_BUFFER_BINDING = 0x8F37
        /// </summary>
        CopyWriteBufferBinding = ((int)0x8F37)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbCopyImage : int
    {
    }

    /// <summary>
    /// Used in GL.Arb.DebugMessageControl, GL.Arb.DebugMessageInsert and 1 other function
    /// </summary>
    public enum ArbDebugOutput : int
    {
        /// <summary>
        /// Original was GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB = 0x8242
        /// </summary>
        DebugOutputSynchronousArb = ((int)0x8242)        ,
        /// <summary>
        /// Original was GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB = 0x8243
        /// </summary>
        DebugNextLoggedMessageLengthArb = ((int)0x8243)        ,
        /// <summary>
        /// Original was GL_DEBUG_CALLBACK_FUNCTION_ARB = 0x8244
        /// </summary>
        DebugCallbackFunctionArb = ((int)0x8244)        ,
        /// <summary>
        /// Original was GL_DEBUG_CALLBACK_USER_PARAM_ARB = 0x8245
        /// </summary>
        DebugCallbackUserParamArb = ((int)0x8245)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_API_ARB = 0x8246
        /// </summary>
        DebugSourceApiArb = ((int)0x8246)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB = 0x8247
        /// </summary>
        DebugSourceWindowSystemArb = ((int)0x8247)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_SHADER_COMPILER_ARB = 0x8248
        /// </summary>
        DebugSourceShaderCompilerArb = ((int)0x8248)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_THIRD_PARTY_ARB = 0x8249
        /// </summary>
        DebugSourceThirdPartyArb = ((int)0x8249)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_APPLICATION_ARB = 0x824A
        /// </summary>
        DebugSourceApplicationArb = ((int)0x824A)        ,
        /// <summary>
        /// Original was GL_DEBUG_SOURCE_OTHER_ARB = 0x824B
        /// </summary>
        DebugSourceOtherArb = ((int)0x824B)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_ERROR_ARB = 0x824C
        /// </summary>
        DebugTypeErrorArb = ((int)0x824C)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB = 0x824D
        /// </summary>
        DebugTypeDeprecatedBehaviorArb = ((int)0x824D)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB = 0x824E
        /// </summary>
        DebugTypeUndefinedBehaviorArb = ((int)0x824E)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_PORTABILITY_ARB = 0x824F
        /// </summary>
        DebugTypePortabilityArb = ((int)0x824F)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_PERFORMANCE_ARB = 0x8250
        /// </summary>
        DebugTypePerformanceArb = ((int)0x8250)        ,
        /// <summary>
        /// Original was GL_DEBUG_TYPE_OTHER_ARB = 0x8251
        /// </summary>
        DebugTypeOtherArb = ((int)0x8251)        ,
        /// <summary>
        /// Original was GL_MAX_DEBUG_MESSAGE_LENGTH_ARB = 0x9143
        /// </summary>
        MaxDebugMessageLengthArb = ((int)0x9143)        ,
        /// <summary>
        /// Original was GL_MAX_DEBUG_LOGGED_MESSAGES_ARB = 0x9144
        /// </summary>
        MaxDebugLoggedMessagesArb = ((int)0x9144)        ,
        /// <summary>
        /// Original was GL_DEBUG_LOGGED_MESSAGES_ARB = 0x9145
        /// </summary>
        DebugLoggedMessagesArb = ((int)0x9145)        ,
        /// <summary>
        /// Original was GL_DEBUG_SEVERITY_HIGH_ARB = 0x9146
        /// </summary>
        DebugSeverityHighArb = ((int)0x9146)        ,
        /// <summary>
        /// Original was GL_DEBUG_SEVERITY_MEDIUM_ARB = 0x9147
        /// </summary>
        DebugSeverityMediumArb = ((int)0x9147)        ,
        /// <summary>
        /// Original was GL_DEBUG_SEVERITY_LOW_ARB = 0x9148
        /// </summary>
        DebugSeverityLowArb = ((int)0x9148)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbDepthBufferFloat : int
    {
        /// <summary>
        /// Original was GL_DEPTH_COMPONENT32F = 0x8CAC
        /// </summary>
        DepthComponent32f = ((int)0x8CAC)        ,
        /// <summary>
        /// Original was GL_DEPTH32F_STENCIL8 = 0x8CAD
        /// </summary>
        Depth32fStencil8 = ((int)0x8CAD)        ,
        /// <summary>
        /// Original was GL_FLOAT_32_UNSIGNED_INT_24_8_REV = 0x8DAD
        /// </summary>
        Float32UnsignedInt248Rev = ((int)0x8DAD)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbDepthClamp : int
    {
        /// <summary>
        /// Original was GL_DEPTH_CLAMP = 0x864F
        /// </summary>
        DepthClamp = ((int)0x864F)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbDepthTexture : int
    {
        /// <summary>
        /// Original was GL_DEPTH_COMPONENT16_ARB = 0x81A5
        /// </summary>
        DepthComponent16Arb = ((int)0x81A5)        ,
        /// <summary>
        /// Original was GL_DEPTH_COMPONENT24_ARB = 0x81A6
        /// </summary>
        DepthComponent24Arb = ((int)0x81A6)        ,
        /// <summary>
        /// Original was GL_DEPTH_COMPONENT32_ARB = 0x81A7
        /// </summary>
        DepthComponent32Arb = ((int)0x81A7)        ,
        /// <summary>
        /// Original was GL_TEXTURE_DEPTH_SIZE_ARB = 0x884A
        /// </summary>
        TextureDepthSizeArb = ((int)0x884A)        ,
        /// <summary>
        /// Original was GL_DEPTH_TEXTURE_MODE_ARB = 0x884B
        /// </summary>
        DepthTextureModeArb = ((int)0x884B)        ,
    }

    /// <summary>
    /// Used in GL.Arb.DrawBuffers
    /// </summary>
    public enum ArbDrawBuffers : int
    {
        /// <summary>
        /// Original was GL_MAX_DRAW_BUFFERS_ARB = 0x8824
        /// </summary>
        MaxDrawBuffersArb = ((int)0x8824)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER0_ARB = 0x8825
        /// </summary>
        DrawBuffer0Arb = ((int)0x8825)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER1_ARB = 0x8826
        /// </summary>
        DrawBuffer1Arb = ((int)0x8826)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER2_ARB = 0x8827
        /// </summary>
        DrawBuffer2Arb = ((int)0x8827)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER3_ARB = 0x8828
        /// </summary>
        DrawBuffer3Arb = ((int)0x8828)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER4_ARB = 0x8829
        /// </summary>
        DrawBuffer4Arb = ((int)0x8829)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER5_ARB = 0x882A
        /// </summary>
        DrawBuffer5Arb = ((int)0x882A)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER6_ARB = 0x882B
        /// </summary>
        DrawBuffer6Arb = ((int)0x882B)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER7_ARB = 0x882C
        /// </summary>
        DrawBuffer7Arb = ((int)0x882C)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER8_ARB = 0x882D
        /// </summary>
        DrawBuffer8Arb = ((int)0x882D)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER9_ARB = 0x882E
        /// </summary>
        DrawBuffer9Arb = ((int)0x882E)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER10_ARB = 0x882F
        /// </summary>
        DrawBuffer10Arb = ((int)0x882F)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER11_ARB = 0x8830
        /// </summary>
        DrawBuffer11Arb = ((int)0x8830)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER12_ARB = 0x8831
        /// </summary>
        DrawBuffer12Arb = ((int)0x8831)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER13_ARB = 0x8832
        /// </summary>
        DrawBuffer13Arb = ((int)0x8832)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER14_ARB = 0x8833
        /// </summary>
        DrawBuffer14Arb = ((int)0x8833)        ,
        /// <summary>
        /// Original was GL_DRAW_BUFFER15_ARB = 0x8834
        /// </summary>
        DrawBuffer15Arb = ((int)0x8834)        ,
    }

    /// <summary>
    /// Used in GL.Arb.BlendEquation, GL.Arb.BlendEquationSeparate and 5 other functions
    /// </summary>
    public enum ArbDrawBuffersBlend : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbDrawElementsBaseVertex : int
    {
    }

    /// <summary>
    /// Used in GL.DrawArraysIndirect, GL.DrawElementsIndirect
    /// </summary>
    public enum ArbDrawIndirect : int
    {
        /// <summary>
        /// Original was GL_DRAW_INDIRECT_BUFFER = 0x8F3F
        /// </summary>
        DrawIndirectBuffer = ((int)0x8F3F)        ,
        /// <summary>
        /// Original was GL_DRAW_INDIRECT_BUFFER_BINDING = 0x8F43
        /// </summary>
        DrawIndirectBufferBinding = ((int)0x8F43)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbDrawInstanced : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbEnhancedLayouts : int
    {
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER = 0x8C8E
        /// </summary>
        TransformFeedbackBuffer = ((int)0x8C8E)        ,
        /// <summary>
        /// Original was GL_LOCATION_COMPONENT = 0x934A
        /// </summary>
        LocationComponent = ((int)0x934A)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_INDEX = 0x934B
        /// </summary>
        TransformFeedbackBufferIndex = ((int)0x934B)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE = 0x934C
        /// </summary>
        TransformFeedbackBufferStride = ((int)0x934C)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbEs2Compatibility : int
    {
        /// <summary>
        /// Original was GL_FIXED = 0x140C
        /// </summary>
        Fixed = ((int)0x140C)        ,
        /// <summary>
        /// Original was GL_IMPLEMENTATION_COLOR_READ_TYPE = 0x8B9A
        /// </summary>
        ImplementationColorReadType = ((int)0x8B9A)        ,
        /// <summary>
        /// Original was GL_IMPLEMENTATION_COLOR_READ_FORMAT = 0x8B9B
        /// </summary>
        ImplementationColorReadFormat = ((int)0x8B9B)        ,
        /// <summary>
        /// Original was GL_RGB565 = 0x8D62
        /// </summary>
        Rgb565 = ((int)0x8D62)        ,
        /// <summary>
        /// Original was GL_LOW_FLOAT = 0x8DF0
        /// </summary>
        LowFloat = ((int)0x8DF0)        ,
        /// <summary>
        /// Original was GL_MEDIUM_FLOAT = 0x8DF1
        /// </summary>
        MediumFloat = ((int)0x8DF1)        ,
        /// <summary>
        /// Original was GL_HIGH_FLOAT = 0x8DF2
        /// </summary>
        HighFloat = ((int)0x8DF2)        ,
        /// <summary>
        /// Original was GL_LOW_INT = 0x8DF3
        /// </summary>
        LowInt = ((int)0x8DF3)        ,
        /// <summary>
        /// Original was GL_MEDIUM_INT = 0x8DF4
        /// </summary>
        MediumInt = ((int)0x8DF4)        ,
        /// <summary>
        /// Original was GL_HIGH_INT = 0x8DF5
        /// </summary>
        HighInt = ((int)0x8DF5)        ,
        /// <summary>
        /// Original was GL_SHADER_BINARY_FORMATS = 0x8DF8
        /// </summary>
        ShaderBinaryFormats = ((int)0x8DF8)        ,
        /// <summary>
        /// Original was GL_NUM_SHADER_BINARY_FORMATS = 0x8DF9
        /// </summary>
        NumShaderBinaryFormats = ((int)0x8DF9)        ,
        /// <summary>
        /// Original was GL_SHADER_COMPILER = 0x8DFA
        /// </summary>
        ShaderCompiler = ((int)0x8DFA)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_UNIFORM_VECTORS = 0x8DFB
        /// </summary>
        MaxVertexUniformVectors = ((int)0x8DFB)        ,
        /// <summary>
        /// Original was GL_MAX_VARYING_VECTORS = 0x8DFC
        /// </summary>
        MaxVaryingVectors = ((int)0x8DFC)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_UNIFORM_VECTORS = 0x8DFD
        /// </summary>
        MaxFragmentUniformVectors = ((int)0x8DFD)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbEs3Compatibility : int
    {
        /// <summary>
        /// Original was GL_PRIMITIVE_RESTART_FIXED_INDEX = 0x8D69
        /// </summary>
        PrimitiveRestartFixedIndex = ((int)0x8D69)        ,
        /// <summary>
        /// Original was GL_ANY_SAMPLES_PASSED_CONSERVATIVE = 0x8D6A
        /// </summary>
        AnySamplesPassedConservative = ((int)0x8D6A)        ,
        /// <summary>
        /// Original was GL_MAX_ELEMENT_INDEX = 0x8D6B
        /// </summary>
        MaxElementIndex = ((int)0x8D6B)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_R11_EAC = 0x9270
        /// </summary>
        CompressedR11Eac = ((int)0x9270)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SIGNED_R11_EAC = 0x9271
        /// </summary>
        CompressedSignedR11Eac = ((int)0x9271)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RG11_EAC = 0x9272
        /// </summary>
        CompressedRg11Eac = ((int)0x9272)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SIGNED_RG11_EAC = 0x9273
        /// </summary>
        CompressedSignedRg11Eac = ((int)0x9273)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGB8_ETC2 = 0x9274
        /// </summary>
        CompressedRgb8Etc2 = ((int)0x9274)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB8_ETC2 = 0x9275
        /// </summary>
        CompressedSrgb8Etc2 = ((int)0x9275)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9276
        /// </summary>
        CompressedRgb8PunchthroughAlpha1Etc2 = ((int)0x9276)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 0x9277
        /// </summary>
        CompressedSrgb8PunchthroughAlpha1Etc2 = ((int)0x9277)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA8_ETC2_EAC = 0x9278
        /// </summary>
        CompressedRgba8Etc2Eac = ((int)0x9278)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = 0x9279
        /// </summary>
        CompressedSrgb8Alpha8Etc2Eac = ((int)0x9279)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbExplicitAttribLocation : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbExplicitUniformLocation : int
    {
        /// <summary>
        /// Original was GL_MAX_UNIFORM_LOCATIONS = 0x826E
        /// </summary>
        MaxUniformLocations = ((int)0x826E)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbFragmentCoordConventions : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbFragmentLayerViewport : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbFragmentProgram : int
    {
        /// <summary>
        /// Original was GL_PROGRAM_LENGTH_ARB = 0x8627
        /// </summary>
        ProgramLengthArb = ((int)0x8627)        ,
        /// <summary>
        /// Original was GL_PROGRAM_STRING_ARB = 0x8628
        /// </summary>
        ProgramStringArb = ((int)0x8628)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB = 0x862E
        /// </summary>
        MaxProgramMatrixStackDepthArb = ((int)0x862E)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_MATRICES_ARB = 0x862F
        /// </summary>
        MaxProgramMatricesArb = ((int)0x862F)        ,
        /// <summary>
        /// Original was GL_CURRENT_MATRIX_STACK_DEPTH_ARB = 0x8640
        /// </summary>
        CurrentMatrixStackDepthArb = ((int)0x8640)        ,
        /// <summary>
        /// Original was GL_CURRENT_MATRIX_ARB = 0x8641
        /// </summary>
        CurrentMatrixArb = ((int)0x8641)        ,
        /// <summary>
        /// Original was GL_PROGRAM_ERROR_POSITION_ARB = 0x864B
        /// </summary>
        ProgramErrorPositionArb = ((int)0x864B)        ,
        /// <summary>
        /// Original was GL_PROGRAM_BINDING_ARB = 0x8677
        /// </summary>
        ProgramBindingArb = ((int)0x8677)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_PROGRAM_ARB = 0x8804
        /// </summary>
        FragmentProgramArb = ((int)0x8804)        ,
        /// <summary>
        /// Original was GL_PROGRAM_ALU_INSTRUCTIONS_ARB = 0x8805
        /// </summary>
        ProgramAluInstructionsArb = ((int)0x8805)        ,
        /// <summary>
        /// Original was GL_PROGRAM_TEX_INSTRUCTIONS_ARB = 0x8806
        /// </summary>
        ProgramTexInstructionsArb = ((int)0x8806)        ,
        /// <summary>
        /// Original was GL_PROGRAM_TEX_INDIRECTIONS_ARB = 0x8807
        /// </summary>
        ProgramTexIndirectionsArb = ((int)0x8807)        ,
        /// <summary>
        /// Original was GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = 0x8808
        /// </summary>
        ProgramNativeAluInstructionsArb = ((int)0x8808)        ,
        /// <summary>
        /// Original was GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = 0x8809
        /// </summary>
        ProgramNativeTexInstructionsArb = ((int)0x8809)        ,
        /// <summary>
        /// Original was GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = 0x880A
        /// </summary>
        ProgramNativeTexIndirectionsArb = ((int)0x880A)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB = 0x880B
        /// </summary>
        MaxProgramAluInstructionsArb = ((int)0x880B)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB = 0x880C
        /// </summary>
        MaxProgramTexInstructionsArb = ((int)0x880C)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB = 0x880D
        /// </summary>
        MaxProgramTexIndirectionsArb = ((int)0x880D)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = 0x880E
        /// </summary>
        MaxProgramNativeAluInstructionsArb = ((int)0x880E)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = 0x880F
        /// </summary>
        MaxProgramNativeTexInstructionsArb = ((int)0x880F)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = 0x8810
        /// </summary>
        MaxProgramNativeTexIndirectionsArb = ((int)0x8810)        ,
        /// <summary>
        /// Original was GL_MAX_TEXTURE_COORDS_ARB = 0x8871
        /// </summary>
        MaxTextureCoordsArb = ((int)0x8871)        ,
        /// <summary>
        /// Original was GL_MAX_TEXTURE_IMAGE_UNITS_ARB = 0x8872
        /// </summary>
        MaxTextureImageUnitsArb = ((int)0x8872)        ,
        /// <summary>
        /// Original was GL_PROGRAM_ERROR_STRING_ARB = 0x8874
        /// </summary>
        ProgramErrorStringArb = ((int)0x8874)        ,
        /// <summary>
        /// Original was GL_PROGRAM_FORMAT_ASCII_ARB = 0x8875
        /// </summary>
        ProgramFormatAsciiArb = ((int)0x8875)        ,
        /// <summary>
        /// Original was GL_PROGRAM_FORMAT_ARB = 0x8876
        /// </summary>
        ProgramFormatArb = ((int)0x8876)        ,
        /// <summary>
        /// Original was GL_PROGRAM_INSTRUCTIONS_ARB = 0x88A0
        /// </summary>
        ProgramInstructionsArb = ((int)0x88A0)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_INSTRUCTIONS_ARB = 0x88A1
        /// </summary>
        MaxProgramInstructionsArb = ((int)0x88A1)        ,
        /// <summary>
        /// Original was GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB = 0x88A2
        /// </summary>
        ProgramNativeInstructionsArb = ((int)0x88A2)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB = 0x88A3
        /// </summary>
        MaxProgramNativeInstructionsArb = ((int)0x88A3)        ,
        /// <summary>
        /// Original was GL_PROGRAM_TEMPORARIES_ARB = 0x88A4
        /// </summary>
        ProgramTemporariesArb = ((int)0x88A4)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_TEMPORARIES_ARB = 0x88A5
        /// </summary>
        MaxProgramTemporariesArb = ((int)0x88A5)        ,
        /// <summary>
        /// Original was GL_PROGRAM_NATIVE_TEMPORARIES_ARB = 0x88A6
        /// </summary>
        ProgramNativeTemporariesArb = ((int)0x88A6)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB = 0x88A7
        /// </summary>
        MaxProgramNativeTemporariesArb = ((int)0x88A7)        ,
        /// <summary>
        /// Original was GL_PROGRAM_PARAMETERS_ARB = 0x88A8
        /// </summary>
        ProgramParametersArb = ((int)0x88A8)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_PARAMETERS_ARB = 0x88A9
        /// </summary>
        MaxProgramParametersArb = ((int)0x88A9)        ,
        /// <summary>
        /// Original was GL_PROGRAM_NATIVE_PARAMETERS_ARB = 0x88AA
        /// </summary>
        ProgramNativeParametersArb = ((int)0x88AA)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB = 0x88AB
        /// </summary>
        MaxProgramNativeParametersArb = ((int)0x88AB)        ,
        /// <summary>
        /// Original was GL_PROGRAM_ATTRIBS_ARB = 0x88AC
        /// </summary>
        ProgramAttribsArb = ((int)0x88AC)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_ATTRIBS_ARB = 0x88AD
        /// </summary>
        MaxProgramAttribsArb = ((int)0x88AD)        ,
        /// <summary>
        /// Original was GL_PROGRAM_NATIVE_ATTRIBS_ARB = 0x88AE
        /// </summary>
        ProgramNativeAttribsArb = ((int)0x88AE)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB = 0x88AF
        /// </summary>
        MaxProgramNativeAttribsArb = ((int)0x88AF)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB = 0x88B4
        /// </summary>
        MaxProgramLocalParametersArb = ((int)0x88B4)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_ENV_PARAMETERS_ARB = 0x88B5
        /// </summary>
        MaxProgramEnvParametersArb = ((int)0x88B5)        ,
        /// <summary>
        /// Original was GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB = 0x88B6
        /// </summary>
        ProgramUnderNativeLimitsArb = ((int)0x88B6)        ,
        /// <summary>
        /// Original was GL_TRANSPOSE_CURRENT_MATRIX_ARB = 0x88B7
        /// </summary>
        TransposeCurrentMatrixArb = ((int)0x88B7)        ,
        /// <summary>
        /// Original was GL_MATRIX0_ARB = 0x88C0
        /// </summary>
        Matrix0Arb = ((int)0x88C0)        ,
        /// <summary>
        /// Original was GL_MATRIX1_ARB = 0x88C1
        /// </summary>
        Matrix1Arb = ((int)0x88C1)        ,
        /// <summary>
        /// Original was GL_MATRIX2_ARB = 0x88C2
        /// </summary>
        Matrix2Arb = ((int)0x88C2)        ,
        /// <summary>
        /// Original was GL_MATRIX3_ARB = 0x88C3
        /// </summary>
        Matrix3Arb = ((int)0x88C3)        ,
        /// <summary>
        /// Original was GL_MATRIX4_ARB = 0x88C4
        /// </summary>
        Matrix4Arb = ((int)0x88C4)        ,
        /// <summary>
        /// Original was GL_MATRIX5_ARB = 0x88C5
        /// </summary>
        Matrix5Arb = ((int)0x88C5)        ,
        /// <summary>
        /// Original was GL_MATRIX6_ARB = 0x88C6
        /// </summary>
        Matrix6Arb = ((int)0x88C6)        ,
        /// <summary>
        /// Original was GL_MATRIX7_ARB = 0x88C7
        /// </summary>
        Matrix7Arb = ((int)0x88C7)        ,
        /// <summary>
        /// Original was GL_MATRIX8_ARB = 0x88C8
        /// </summary>
        Matrix8Arb = ((int)0x88C8)        ,
        /// <summary>
        /// Original was GL_MATRIX9_ARB = 0x88C9
        /// </summary>
        Matrix9Arb = ((int)0x88C9)        ,
        /// <summary>
        /// Original was GL_MATRIX10_ARB = 0x88CA
        /// </summary>
        Matrix10Arb = ((int)0x88CA)        ,
        /// <summary>
        /// Original was GL_MATRIX11_ARB = 0x88CB
        /// </summary>
        Matrix11Arb = ((int)0x88CB)        ,
        /// <summary>
        /// Original was GL_MATRIX12_ARB = 0x88CC
        /// </summary>
        Matrix12Arb = ((int)0x88CC)        ,
        /// <summary>
        /// Original was GL_MATRIX13_ARB = 0x88CD
        /// </summary>
        Matrix13Arb = ((int)0x88CD)        ,
        /// <summary>
        /// Original was GL_MATRIX14_ARB = 0x88CE
        /// </summary>
        Matrix14Arb = ((int)0x88CE)        ,
        /// <summary>
        /// Original was GL_MATRIX15_ARB = 0x88CF
        /// </summary>
        Matrix15Arb = ((int)0x88CF)        ,
        /// <summary>
        /// Original was GL_MATRIX16_ARB = 0x88D0
        /// </summary>
        Matrix16Arb = ((int)0x88D0)        ,
        /// <summary>
        /// Original was GL_MATRIX17_ARB = 0x88D1
        /// </summary>
        Matrix17Arb = ((int)0x88D1)        ,
        /// <summary>
        /// Original was GL_MATRIX18_ARB = 0x88D2
        /// </summary>
        Matrix18Arb = ((int)0x88D2)        ,
        /// <summary>
        /// Original was GL_MATRIX19_ARB = 0x88D3
        /// </summary>
        Matrix19Arb = ((int)0x88D3)        ,
        /// <summary>
        /// Original was GL_MATRIX20_ARB = 0x88D4
        /// </summary>
        Matrix20Arb = ((int)0x88D4)        ,
        /// <summary>
        /// Original was GL_MATRIX21_ARB = 0x88D5
        /// </summary>
        Matrix21Arb = ((int)0x88D5)        ,
        /// <summary>
        /// Original was GL_MATRIX22_ARB = 0x88D6
        /// </summary>
        Matrix22Arb = ((int)0x88D6)        ,
        /// <summary>
        /// Original was GL_MATRIX23_ARB = 0x88D7
        /// </summary>
        Matrix23Arb = ((int)0x88D7)        ,
        /// <summary>
        /// Original was GL_MATRIX24_ARB = 0x88D8
        /// </summary>
        Matrix24Arb = ((int)0x88D8)        ,
        /// <summary>
        /// Original was GL_MATRIX25_ARB = 0x88D9
        /// </summary>
        Matrix25Arb = ((int)0x88D9)        ,
        /// <summary>
        /// Original was GL_MATRIX26_ARB = 0x88DA
        /// </summary>
        Matrix26Arb = ((int)0x88DA)        ,
        /// <summary>
        /// Original was GL_MATRIX27_ARB = 0x88DB
        /// </summary>
        Matrix27Arb = ((int)0x88DB)        ,
        /// <summary>
        /// Original was GL_MATRIX28_ARB = 0x88DC
        /// </summary>
        Matrix28Arb = ((int)0x88DC)        ,
        /// <summary>
        /// Original was GL_MATRIX29_ARB = 0x88DD
        /// </summary>
        Matrix29Arb = ((int)0x88DD)        ,
        /// <summary>
        /// Original was GL_MATRIX30_ARB = 0x88DE
        /// </summary>
        Matrix30Arb = ((int)0x88DE)        ,
        /// <summary>
        /// Original was GL_MATRIX31_ARB = 0x88DF
        /// </summary>
        Matrix31Arb = ((int)0x88DF)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbFragmentProgramShadow : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbFragmentShader : int
    {
        /// <summary>
        /// Original was GL_FRAGMENT_SHADER_ARB = 0x8B30
        /// </summary>
        FragmentShaderArb = ((int)0x8B30)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB = 0x8B49
        /// </summary>
        MaxFragmentUniformComponentsArb = ((int)0x8B49)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB = 0x8B8B
        /// </summary>
        FragmentShaderDerivativeHintArb = ((int)0x8B8B)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbFramebufferNoAttachments : int
    {
        /// <summary>
        /// Original was GL_FRAMEBUFFER_DEFAULT_WIDTH = 0x9310
        /// </summary>
        FramebufferDefaultWidth = ((int)0x9310)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_DEFAULT_HEIGHT = 0x9311
        /// </summary>
        FramebufferDefaultHeight = ((int)0x9311)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_DEFAULT_LAYERS = 0x9312
        /// </summary>
        FramebufferDefaultLayers = ((int)0x9312)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_DEFAULT_SAMPLES = 0x9313
        /// </summary>
        FramebufferDefaultSamples = ((int)0x9313)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS = 0x9314
        /// </summary>
        FramebufferDefaultFixedSampleLocations = ((int)0x9314)        ,
        /// <summary>
        /// Original was GL_MAX_FRAMEBUFFER_WIDTH = 0x9315
        /// </summary>
        MaxFramebufferWidth = ((int)0x9315)        ,
        /// <summary>
        /// Original was GL_MAX_FRAMEBUFFER_HEIGHT = 0x9316
        /// </summary>
        MaxFramebufferHeight = ((int)0x9316)        ,
        /// <summary>
        /// Original was GL_MAX_FRAMEBUFFER_LAYERS = 0x9317
        /// </summary>
        MaxFramebufferLayers = ((int)0x9317)        ,
        /// <summary>
        /// Original was GL_MAX_FRAMEBUFFER_SAMPLES = 0x9318
        /// </summary>
        MaxFramebufferSamples = ((int)0x9318)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbFramebufferObject : int
    {
        /// <summary>
        /// Original was GL_INVALID_FRAMEBUFFER_OPERATION = 0x0506
        /// </summary>
        InvalidFramebufferOperation = ((int)0x0506)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = 0x8210
        /// </summary>
        FramebufferAttachmentColorEncoding = ((int)0x8210)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = 0x8211
        /// </summary>
        FramebufferAttachmentComponentType = ((int)0x8211)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE = 0x8212
        /// </summary>
        FramebufferAttachmentRedSize = ((int)0x8212)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = 0x8213
        /// </summary>
        FramebufferAttachmentGreenSize = ((int)0x8213)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = 0x8214
        /// </summary>
        FramebufferAttachmentBlueSize = ((int)0x8214)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = 0x8215
        /// </summary>
        FramebufferAttachmentAlphaSize = ((int)0x8215)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = 0x8216
        /// </summary>
        FramebufferAttachmentDepthSize = ((int)0x8216)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = 0x8217
        /// </summary>
        FramebufferAttachmentStencilSize = ((int)0x8217)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_DEFAULT = 0x8218
        /// </summary>
        FramebufferDefault = ((int)0x8218)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_UNDEFINED = 0x8219
        /// </summary>
        FramebufferUndefined = ((int)0x8219)        ,
        /// <summary>
        /// Original was GL_DEPTH_STENCIL_ATTACHMENT = 0x821A
        /// </summary>
        DepthStencilAttachment = ((int)0x821A)        ,
        /// <summary>
        /// Original was GL_INDEX = 0x8222
        /// </summary>
        Index = ((int)0x8222)        ,
        /// <summary>
        /// Original was GL_MAX_RENDERBUFFER_SIZE = 0x84E8
        /// </summary>
        MaxRenderbufferSize = ((int)0x84E8)        ,
        /// <summary>
        /// Original was GL_DEPTH_STENCIL = 0x84F9
        /// </summary>
        DepthStencil = ((int)0x84F9)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_24_8 = 0x84FA
        /// </summary>
        UnsignedInt248 = ((int)0x84FA)        ,
        /// <summary>
        /// Original was GL_DEPTH24_STENCIL8 = 0x88F0
        /// </summary>
        Depth24Stencil8 = ((int)0x88F0)        ,
        /// <summary>
        /// Original was GL_TEXTURE_STENCIL_SIZE = 0x88F1
        /// </summary>
        TextureStencilSize = ((int)0x88F1)        ,
        /// <summary>
        /// Original was GL_TEXTURE_RED_TYPE = 0x8C10
        /// </summary>
        TextureRedType = ((int)0x8C10)        ,
        /// <summary>
        /// Original was GL_TEXTURE_GREEN_TYPE = 0x8C11
        /// </summary>
        TextureGreenType = ((int)0x8C11)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BLUE_TYPE = 0x8C12
        /// </summary>
        TextureBlueType = ((int)0x8C12)        ,
        /// <summary>
        /// Original was GL_TEXTURE_ALPHA_TYPE = 0x8C13
        /// </summary>
        TextureAlphaType = ((int)0x8C13)        ,
        /// <summary>
        /// Original was GL_TEXTURE_LUMINANCE_TYPE = 0x8C14
        /// </summary>
        TextureLuminanceType = ((int)0x8C14)        ,
        /// <summary>
        /// Original was GL_TEXTURE_INTENSITY_TYPE = 0x8C15
        /// </summary>
        TextureIntensityType = ((int)0x8C15)        ,
        /// <summary>
        /// Original was GL_TEXTURE_DEPTH_TYPE = 0x8C16
        /// </summary>
        TextureDepthType = ((int)0x8C16)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_NORMALIZED = 0x8C17
        /// </summary>
        UnsignedNormalized = ((int)0x8C17)        ,
        /// <summary>
        /// Original was GL_DRAW_FRAMEBUFFER_BINDING = 0x8CA6
        /// </summary>
        DrawFramebufferBinding = ((int)0x8CA6)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_BINDING = 0x8CA6
        /// </summary>
        FramebufferBinding = ((int)0x8CA6)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_BINDING = 0x8CA7
        /// </summary>
        RenderbufferBinding = ((int)0x8CA7)        ,
        /// <summary>
        /// Original was GL_READ_FRAMEBUFFER = 0x8CA8
        /// </summary>
        ReadFramebuffer = ((int)0x8CA8)        ,
        /// <summary>
        /// Original was GL_DRAW_FRAMEBUFFER = 0x8CA9
        /// </summary>
        DrawFramebuffer = ((int)0x8CA9)        ,
        /// <summary>
        /// Original was GL_READ_FRAMEBUFFER_BINDING = 0x8CAA
        /// </summary>
        ReadFramebufferBinding = ((int)0x8CAA)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_SAMPLES = 0x8CAB
        /// </summary>
        RenderbufferSamples = ((int)0x8CAB)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 0x8CD0
        /// </summary>
        FramebufferAttachmentObjectType = ((int)0x8CD0)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 0x8CD1
        /// </summary>
        FramebufferAttachmentObjectName = ((int)0x8CD1)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 0x8CD2
        /// </summary>
        FramebufferAttachmentTextureLevel = ((int)0x8CD2)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 0x8CD3
        /// </summary>
        FramebufferAttachmentTextureCubeMapFace = ((int)0x8CD3)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = 0x8CD4
        /// </summary>
        FramebufferAttachmentTextureLayer = ((int)0x8CD4)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_COMPLETE = 0x8CD5
        /// </summary>
        FramebufferComplete = ((int)0x8CD5)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 0x8CD6
        /// </summary>
        FramebufferIncompleteAttachment = ((int)0x8CD6)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 0x8CD7
        /// </summary>
        FramebufferIncompleteMissingAttachment = ((int)0x8CD7)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 0x8CDB
        /// </summary>
        FramebufferIncompleteDrawBuffer = ((int)0x8CDB)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 0x8CDC
        /// </summary>
        FramebufferIncompleteReadBuffer = ((int)0x8CDC)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_UNSUPPORTED = 0x8CDD
        /// </summary>
        FramebufferUnsupported = ((int)0x8CDD)        ,
        /// <summary>
        /// Original was GL_MAX_COLOR_ATTACHMENTS = 0x8CDF
        /// </summary>
        MaxColorAttachments = ((int)0x8CDF)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT0 = 0x8CE0
        /// </summary>
        ColorAttachment0 = ((int)0x8CE0)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT1 = 0x8CE1
        /// </summary>
        ColorAttachment1 = ((int)0x8CE1)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT2 = 0x8CE2
        /// </summary>
        ColorAttachment2 = ((int)0x8CE2)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT3 = 0x8CE3
        /// </summary>
        ColorAttachment3 = ((int)0x8CE3)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT4 = 0x8CE4
        /// </summary>
        ColorAttachment4 = ((int)0x8CE4)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT5 = 0x8CE5
        /// </summary>
        ColorAttachment5 = ((int)0x8CE5)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT6 = 0x8CE6
        /// </summary>
        ColorAttachment6 = ((int)0x8CE6)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT7 = 0x8CE7
        /// </summary>
        ColorAttachment7 = ((int)0x8CE7)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT8 = 0x8CE8
        /// </summary>
        ColorAttachment8 = ((int)0x8CE8)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT9 = 0x8CE9
        /// </summary>
        ColorAttachment9 = ((int)0x8CE9)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT10 = 0x8CEA
        /// </summary>
        ColorAttachment10 = ((int)0x8CEA)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT11 = 0x8CEB
        /// </summary>
        ColorAttachment11 = ((int)0x8CEB)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT12 = 0x8CEC
        /// </summary>
        ColorAttachment12 = ((int)0x8CEC)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT13 = 0x8CED
        /// </summary>
        ColorAttachment13 = ((int)0x8CED)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT14 = 0x8CEE
        /// </summary>
        ColorAttachment14 = ((int)0x8CEE)        ,
        /// <summary>
        /// Original was GL_COLOR_ATTACHMENT15 = 0x8CEF
        /// </summary>
        ColorAttachment15 = ((int)0x8CEF)        ,
        /// <summary>
        /// Original was GL_DEPTH_ATTACHMENT = 0x8D00
        /// </summary>
        DepthAttachment = ((int)0x8D00)        ,
        /// <summary>
        /// Original was GL_STENCIL_ATTACHMENT = 0x8D20
        /// </summary>
        StencilAttachment = ((int)0x8D20)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER = 0x8D40
        /// </summary>
        Framebuffer = ((int)0x8D40)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER = 0x8D41
        /// </summary>
        Renderbuffer = ((int)0x8D41)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_WIDTH = 0x8D42
        /// </summary>
        RenderbufferWidth = ((int)0x8D42)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_HEIGHT = 0x8D43
        /// </summary>
        RenderbufferHeight = ((int)0x8D43)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_INTERNAL_FORMAT = 0x8D44
        /// </summary>
        RenderbufferInternalFormat = ((int)0x8D44)        ,
        /// <summary>
        /// Original was GL_STENCIL_INDEX1 = 0x8D46
        /// </summary>
        StencilIndex1 = ((int)0x8D46)        ,
        /// <summary>
        /// Original was GL_STENCIL_INDEX4 = 0x8D47
        /// </summary>
        StencilIndex4 = ((int)0x8D47)        ,
        /// <summary>
        /// Original was GL_STENCIL_INDEX8 = 0x8D48
        /// </summary>
        StencilIndex8 = ((int)0x8D48)        ,
        /// <summary>
        /// Original was GL_STENCIL_INDEX16 = 0x8D49
        /// </summary>
        StencilIndex16 = ((int)0x8D49)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_RED_SIZE = 0x8D50
        /// </summary>
        RenderbufferRedSize = ((int)0x8D50)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_GREEN_SIZE = 0x8D51
        /// </summary>
        RenderbufferGreenSize = ((int)0x8D51)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_BLUE_SIZE = 0x8D52
        /// </summary>
        RenderbufferBlueSize = ((int)0x8D52)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_ALPHA_SIZE = 0x8D53
        /// </summary>
        RenderbufferAlphaSize = ((int)0x8D53)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_DEPTH_SIZE = 0x8D54
        /// </summary>
        RenderbufferDepthSize = ((int)0x8D54)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER_STENCIL_SIZE = 0x8D55
        /// </summary>
        RenderbufferStencilSize = ((int)0x8D55)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = 0x8D56
        /// </summary>
        FramebufferIncompleteMultisample = ((int)0x8D56)        ,
        /// <summary>
        /// Original was GL_MAX_SAMPLES = 0x8D57
        /// </summary>
        MaxSamples = ((int)0x8D57)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbFramebufferSrgb : int
    {
        /// <summary>
        /// Original was GL_FRAMEBUFFER_SRGB = 0x8DB9
        /// </summary>
        FramebufferSrgb = ((int)0x8DB9)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbGeometryShader4 : int
    {
        /// <summary>
        /// Original was GL_LINES_ADJACENCY_ARB = 0x000A
        /// </summary>
        LinesAdjacencyArb = ((int)0x000A)        ,
        /// <summary>
        /// Original was GL_LINE_STRIP_ADJACENCY_ARB = 0x000B
        /// </summary>
        LineStripAdjacencyArb = ((int)0x000B)        ,
        /// <summary>
        /// Original was GL_TRIANGLES_ADJACENCY_ARB = 0x000C
        /// </summary>
        TrianglesAdjacencyArb = ((int)0x000C)        ,
        /// <summary>
        /// Original was GL_TRIANGLE_STRIP_ADJACENCY_ARB = 0x000D
        /// </summary>
        TriangleStripAdjacencyArb = ((int)0x000D)        ,
        /// <summary>
        /// Original was GL_PROGRAM_POINT_SIZE_ARB = 0x8642
        /// </summary>
        ProgramPointSizeArb = ((int)0x8642)        ,
        /// <summary>
        /// Original was GL_MAX_VARYING_COMPONENTS = 0x8B4B
        /// </summary>
        MaxVaryingComponents = ((int)0x8B4B)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB = 0x8C29
        /// </summary>
        MaxGeometryTextureImageUnitsArb = ((int)0x8C29)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = 0x8CD4
        /// </summary>
        FramebufferAttachmentTextureLayer = ((int)0x8CD4)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB = 0x8DA7
        /// </summary>
        FramebufferAttachmentLayeredArb = ((int)0x8DA7)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB = 0x8DA8
        /// </summary>
        FramebufferIncompleteLayerTargetsArb = ((int)0x8DA8)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB = 0x8DA9
        /// </summary>
        FramebufferIncompleteLayerCountArb = ((int)0x8DA9)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_SHADER_ARB = 0x8DD9
        /// </summary>
        GeometryShaderArb = ((int)0x8DD9)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_VERTICES_OUT_ARB = 0x8DDA
        /// </summary>
        GeometryVerticesOutArb = ((int)0x8DDA)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_INPUT_TYPE_ARB = 0x8DDB
        /// </summary>
        GeometryInputTypeArb = ((int)0x8DDB)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_OUTPUT_TYPE_ARB = 0x8DDC
        /// </summary>
        GeometryOutputTypeArb = ((int)0x8DDC)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB = 0x8DDD
        /// </summary>
        MaxGeometryVaryingComponentsArb = ((int)0x8DDD)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_VARYING_COMPONENTS_ARB = 0x8DDE
        /// </summary>
        MaxVertexVaryingComponentsArb = ((int)0x8DDE)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB = 0x8DDF
        /// </summary>
        MaxGeometryUniformComponentsArb = ((int)0x8DDF)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_OUTPUT_VERTICES_ARB = 0x8DE0
        /// </summary>
        MaxGeometryOutputVerticesArb = ((int)0x8DE0)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB = 0x8DE1
        /// </summary>
        MaxGeometryTotalOutputComponentsArb = ((int)0x8DE1)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbGetProgramBinary : int
    {
        /// <summary>
        /// Original was GL_PROGRAM_BINARY_RETRIEVABLE_HINT = 0x8257
        /// </summary>
        ProgramBinaryRetrievableHint = ((int)0x8257)        ,
        /// <summary>
        /// Original was GL_PROGRAM_BINARY_LENGTH = 0x8741
        /// </summary>
        ProgramBinaryLength = ((int)0x8741)        ,
        /// <summary>
        /// Original was GL_NUM_PROGRAM_BINARY_FORMATS = 0x87FE
        /// </summary>
        NumProgramBinaryFormats = ((int)0x87FE)        ,
        /// <summary>
        /// Original was GL_PROGRAM_BINARY_FORMATS = 0x87FF
        /// </summary>
        ProgramBinaryFormats = ((int)0x87FF)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbGpuShader5 : int
    {
        /// <summary>
        /// Original was GL_GEOMETRY_SHADER_INVOCATIONS = 0x887F
        /// </summary>
        GeometryShaderInvocations = ((int)0x887F)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_SHADER_INVOCATIONS = 0x8E5A
        /// </summary>
        MaxGeometryShaderInvocations = ((int)0x8E5A)        ,
        /// <summary>
        /// Original was GL_MIN_FRAGMENT_INTERPOLATION_OFFSET = 0x8E5B
        /// </summary>
        MinFragmentInterpolationOffset = ((int)0x8E5B)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_INTERPOLATION_OFFSET = 0x8E5C
        /// </summary>
        MaxFragmentInterpolationOffset = ((int)0x8E5C)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_INTERPOLATION_OFFSET_BITS = 0x8E5D
        /// </summary>
        FragmentInterpolationOffsetBits = ((int)0x8E5D)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_STREAMS = 0x8E71
        /// </summary>
        MaxVertexStreams = ((int)0x8E71)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbGpuShaderFp64 : int
    {
        /// <summary>
        /// Original was GL_DOUBLE = 0x140A
        /// </summary>
        Double = ((int)0x140A)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT2 = 0x8F46
        /// </summary>
        DoubleMat2 = ((int)0x8F46)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT3 = 0x8F47
        /// </summary>
        DoubleMat3 = ((int)0x8F47)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT4 = 0x8F48
        /// </summary>
        DoubleMat4 = ((int)0x8F48)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT2x3 = 0x8F49
        /// </summary>
        DoubleMat2x3 = ((int)0x8F49)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT2x4 = 0x8F4A
        /// </summary>
        DoubleMat2x4 = ((int)0x8F4A)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT3x2 = 0x8F4B
        /// </summary>
        DoubleMat3x2 = ((int)0x8F4B)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT3x4 = 0x8F4C
        /// </summary>
        DoubleMat3x4 = ((int)0x8F4C)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT4x2 = 0x8F4D
        /// </summary>
        DoubleMat4x2 = ((int)0x8F4D)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT4x3 = 0x8F4E
        /// </summary>
        DoubleMat4x3 = ((int)0x8F4E)        ,
        /// <summary>
        /// Original was GL_DOUBLE_VEC2 = 0x8FFC
        /// </summary>
        DoubleVec2 = ((int)0x8FFC)        ,
        /// <summary>
        /// Original was GL_DOUBLE_VEC3 = 0x8FFD
        /// </summary>
        DoubleVec3 = ((int)0x8FFD)        ,
        /// <summary>
        /// Original was GL_DOUBLE_VEC4 = 0x8FFE
        /// </summary>
        DoubleVec4 = ((int)0x8FFE)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbHalfFloatPixel : int
    {
        /// <summary>
        /// Original was GL_HALF_FLOAT_ARB = 0x140B
        /// </summary>
        HalfFloatArb = ((int)0x140B)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbHalfFloatVertex : int
    {
        /// <summary>
        /// Original was GL_HALF_FLOAT = 0x140B
        /// </summary>
        HalfFloat = ((int)0x140B)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbImaging : int
    {
        /// <summary>
        /// Original was GL_CONSTANT_COLOR = 0x8001
        /// </summary>
        ConstantColor = ((int)0x8001)        ,
        /// <summary>
        /// Original was GL_ONE_MINUS_CONSTANT_COLOR = 0x8002
        /// </summary>
        OneMinusConstantColor = ((int)0x8002)        ,
        /// <summary>
        /// Original was GL_CONSTANT_ALPHA = 0x8003
        /// </summary>
        ConstantAlpha = ((int)0x8003)        ,
        /// <summary>
        /// Original was GL_ONE_MINUS_CONSTANT_ALPHA = 0x8004
        /// </summary>
        OneMinusConstantAlpha = ((int)0x8004)        ,
        /// <summary>
        /// Original was GL_BLEND_COLOR = 0x8005
        /// </summary>
        BlendColor = ((int)0x8005)        ,
        /// <summary>
        /// Original was GL_FUNC_ADD = 0x8006
        /// </summary>
        FuncAdd = ((int)0x8006)        ,
        /// <summary>
        /// Original was GL_MIN = 0x8007
        /// </summary>
        Min = ((int)0x8007)        ,
        /// <summary>
        /// Original was GL_MAX = 0x8008
        /// </summary>
        Max = ((int)0x8008)        ,
        /// <summary>
        /// Original was GL_BLEND_EQUATION = 0x8009
        /// </summary>
        BlendEquation = ((int)0x8009)        ,
        /// <summary>
        /// Original was GL_FUNC_SUBTRACT = 0x800A
        /// </summary>
        FuncSubtract = ((int)0x800A)        ,
        /// <summary>
        /// Original was GL_FUNC_REVERSE_SUBTRACT = 0x800B
        /// </summary>
        FuncReverseSubtract = ((int)0x800B)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_1D = 0x8010
        /// </summary>
        Convolution1D = ((int)0x8010)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_2D = 0x8011
        /// </summary>
        Convolution2D = ((int)0x8011)        ,
        /// <summary>
        /// Original was GL_SEPARABLE_2D = 0x8012
        /// </summary>
        Separable2D = ((int)0x8012)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_BORDER_MODE = 0x8013
        /// </summary>
        ConvolutionBorderMode = ((int)0x8013)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_FILTER_SCALE = 0x8014
        /// </summary>
        ConvolutionFilterScale = ((int)0x8014)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_FILTER_BIAS = 0x8015
        /// </summary>
        ConvolutionFilterBias = ((int)0x8015)        ,
        /// <summary>
        /// Original was GL_REDUCE = 0x8016
        /// </summary>
        Reduce = ((int)0x8016)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_FORMAT = 0x8017
        /// </summary>
        ConvolutionFormat = ((int)0x8017)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_WIDTH = 0x8018
        /// </summary>
        ConvolutionWidth = ((int)0x8018)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_HEIGHT = 0x8019
        /// </summary>
        ConvolutionHeight = ((int)0x8019)        ,
        /// <summary>
        /// Original was GL_MAX_CONVOLUTION_WIDTH = 0x801A
        /// </summary>
        MaxConvolutionWidth = ((int)0x801A)        ,
        /// <summary>
        /// Original was GL_MAX_CONVOLUTION_HEIGHT = 0x801B
        /// </summary>
        MaxConvolutionHeight = ((int)0x801B)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_RED_SCALE = 0x801C
        /// </summary>
        PostConvolutionRedScale = ((int)0x801C)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_GREEN_SCALE = 0x801D
        /// </summary>
        PostConvolutionGreenScale = ((int)0x801D)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_BLUE_SCALE = 0x801E
        /// </summary>
        PostConvolutionBlueScale = ((int)0x801E)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_ALPHA_SCALE = 0x801F
        /// </summary>
        PostConvolutionAlphaScale = ((int)0x801F)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_RED_BIAS = 0x8020
        /// </summary>
        PostConvolutionRedBias = ((int)0x8020)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_GREEN_BIAS = 0x8021
        /// </summary>
        PostConvolutionGreenBias = ((int)0x8021)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_BLUE_BIAS = 0x8022
        /// </summary>
        PostConvolutionBlueBias = ((int)0x8022)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_ALPHA_BIAS = 0x8023
        /// </summary>
        PostConvolutionAlphaBias = ((int)0x8023)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM = 0x8024
        /// </summary>
        Histogram = ((int)0x8024)        ,
        /// <summary>
        /// Original was GL_PROXY_HISTOGRAM = 0x8025
        /// </summary>
        ProxyHistogram = ((int)0x8025)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_WIDTH = 0x8026
        /// </summary>
        HistogramWidth = ((int)0x8026)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_FORMAT = 0x8027
        /// </summary>
        HistogramFormat = ((int)0x8027)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_RED_SIZE = 0x8028
        /// </summary>
        HistogramRedSize = ((int)0x8028)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_GREEN_SIZE = 0x8029
        /// </summary>
        HistogramGreenSize = ((int)0x8029)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_BLUE_SIZE = 0x802A
        /// </summary>
        HistogramBlueSize = ((int)0x802A)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_ALPHA_SIZE = 0x802B
        /// </summary>
        HistogramAlphaSize = ((int)0x802B)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_LUMINANCE_SIZE = 0x802C
        /// </summary>
        HistogramLuminanceSize = ((int)0x802C)        ,
        /// <summary>
        /// Original was GL_HISTOGRAM_SINK = 0x802D
        /// </summary>
        HistogramSink = ((int)0x802D)        ,
        /// <summary>
        /// Original was GL_MINMAX = 0x802E
        /// </summary>
        Minmax = ((int)0x802E)        ,
        /// <summary>
        /// Original was GL_MINMAX_FORMAT = 0x802F
        /// </summary>
        MinmaxFormat = ((int)0x802F)        ,
        /// <summary>
        /// Original was GL_MINMAX_SINK = 0x8030
        /// </summary>
        MinmaxSink = ((int)0x8030)        ,
        /// <summary>
        /// Original was GL_TABLE_TOO_LARGE = 0x8031
        /// </summary>
        TableTooLarge = ((int)0x8031)        ,
        /// <summary>
        /// Original was GL_COLOR_MATRIX = 0x80B1
        /// </summary>
        ColorMatrix = ((int)0x80B1)        ,
        /// <summary>
        /// Original was GL_COLOR_MATRIX_STACK_DEPTH = 0x80B2
        /// </summary>
        ColorMatrixStackDepth = ((int)0x80B2)        ,
        /// <summary>
        /// Original was GL_MAX_COLOR_MATRIX_STACK_DEPTH = 0x80B3
        /// </summary>
        MaxColorMatrixStackDepth = ((int)0x80B3)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_RED_SCALE = 0x80B4
        /// </summary>
        PostColorMatrixRedScale = ((int)0x80B4)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_GREEN_SCALE = 0x80B5
        /// </summary>
        PostColorMatrixGreenScale = ((int)0x80B5)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_BLUE_SCALE = 0x80B6
        /// </summary>
        PostColorMatrixBlueScale = ((int)0x80B6)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_ALPHA_SCALE = 0x80B7
        /// </summary>
        PostColorMatrixAlphaScale = ((int)0x80B7)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_RED_BIAS = 0x80B8
        /// </summary>
        PostColorMatrixRedBias = ((int)0x80B8)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_GREEN_BIAS = 0x80B9
        /// </summary>
        PostColorMatrixGreenBias = ((int)0x80B9)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_BLUE_BIAS = 0x80BA
        /// </summary>
        PostColorMatrixBlueBias = ((int)0x80BA)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_ALPHA_BIAS = 0x80BB
        /// </summary>
        PostColorMatrixAlphaBias = ((int)0x80BB)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE = 0x80D0
        /// </summary>
        ColorTable = ((int)0x80D0)        ,
        /// <summary>
        /// Original was GL_POST_CONVOLUTION_COLOR_TABLE = 0x80D1
        /// </summary>
        PostConvolutionColorTable = ((int)0x80D1)        ,
        /// <summary>
        /// Original was GL_POST_COLOR_MATRIX_COLOR_TABLE = 0x80D2
        /// </summary>
        PostColorMatrixColorTable = ((int)0x80D2)        ,
        /// <summary>
        /// Original was GL_PROXY_COLOR_TABLE = 0x80D3
        /// </summary>
        ProxyColorTable = ((int)0x80D3)        ,
        /// <summary>
        /// Original was GL_PROXY_POST_CONVOLUTION_COLOR_TABLE = 0x80D4
        /// </summary>
        ProxyPostConvolutionColorTable = ((int)0x80D4)        ,
        /// <summary>
        /// Original was GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE = 0x80D5
        /// </summary>
        ProxyPostColorMatrixColorTable = ((int)0x80D5)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_SCALE = 0x80D6
        /// </summary>
        ColorTableScale = ((int)0x80D6)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_BIAS = 0x80D7
        /// </summary>
        ColorTableBias = ((int)0x80D7)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_FORMAT = 0x80D8
        /// </summary>
        ColorTableFormat = ((int)0x80D8)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_WIDTH = 0x80D9
        /// </summary>
        ColorTableWidth = ((int)0x80D9)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_RED_SIZE = 0x80DA
        /// </summary>
        ColorTableRedSize = ((int)0x80DA)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_GREEN_SIZE = 0x80DB
        /// </summary>
        ColorTableGreenSize = ((int)0x80DB)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_BLUE_SIZE = 0x80DC
        /// </summary>
        ColorTableBlueSize = ((int)0x80DC)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_ALPHA_SIZE = 0x80DD
        /// </summary>
        ColorTableAlphaSize = ((int)0x80DD)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_LUMINANCE_SIZE = 0x80DE
        /// </summary>
        ColorTableLuminanceSize = ((int)0x80DE)        ,
        /// <summary>
        /// Original was GL_COLOR_TABLE_INTENSITY_SIZE = 0x80DF
        /// </summary>
        ColorTableIntensitySize = ((int)0x80DF)        ,
        /// <summary>
        /// Original was GL_CONSTANT_BORDER = 0x8151
        /// </summary>
        ConstantBorder = ((int)0x8151)        ,
        /// <summary>
        /// Original was GL_REPLICATE_BORDER = 0x8153
        /// </summary>
        ReplicateBorder = ((int)0x8153)        ,
        /// <summary>
        /// Original was GL_CONVOLUTION_BORDER_COLOR = 0x8154
        /// </summary>
        ConvolutionBorderColor = ((int)0x8154)        ,
    }

    /// <summary>
    /// Used in GL.Arb.MultiDrawArraysIndirectCount, GL.Arb.MultiDrawElementsIndirectCount
    /// </summary>
    public enum ArbIndirectParameters : int
    {
        /// <summary>
        /// Original was GL_PARAMETER_BUFFER_ARB = 0x80EE
        /// </summary>
        ParameterBufferArb = ((int)0x80EE)        ,
        /// <summary>
        /// Original was GL_PARAMETER_BUFFER_BINDING_ARB = 0x80EF
        /// </summary>
        ParameterBufferBindingArb = ((int)0x80EF)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbInstancedArrays : int
    {
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB = 0x88FE
        /// </summary>
        VertexAttribArrayDivisorArb = ((int)0x88FE)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbInternalformatQuery : int
    {
        /// <summary>
        /// Original was GL_NUM_SAMPLE_COUNTS = 0x9380
        /// </summary>
        NumSampleCounts = ((int)0x9380)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbInternalformatQuery2 : int
    {
        /// <summary>
        /// Original was GL_TEXTURE_1D = 0x0DE0
        /// </summary>
        Texture1D = ((int)0x0DE0)        ,
        /// <summary>
        /// Original was GL_TEXTURE_2D = 0x0DE1
        /// </summary>
        Texture2D = ((int)0x0DE1)        ,
        /// <summary>
        /// Original was GL_TEXTURE_3D = 0x806F
        /// </summary>
        Texture3D = ((int)0x806F)        ,
        /// <summary>
        /// Original was GL_SAMPLES = 0x80A9
        /// </summary>
        Samples = ((int)0x80A9)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_SUPPORTED = 0x826F
        /// </summary>
        InternalformatSupported = ((int)0x826F)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_PREFERRED = 0x8270
        /// </summary>
        InternalformatPreferred = ((int)0x8270)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_RED_SIZE = 0x8271
        /// </summary>
        InternalformatRedSize = ((int)0x8271)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_GREEN_SIZE = 0x8272
        /// </summary>
        InternalformatGreenSize = ((int)0x8272)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_BLUE_SIZE = 0x8273
        /// </summary>
        InternalformatBlueSize = ((int)0x8273)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_ALPHA_SIZE = 0x8274
        /// </summary>
        InternalformatAlphaSize = ((int)0x8274)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_DEPTH_SIZE = 0x8275
        /// </summary>
        InternalformatDepthSize = ((int)0x8275)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_STENCIL_SIZE = 0x8276
        /// </summary>
        InternalformatStencilSize = ((int)0x8276)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_SHARED_SIZE = 0x8277
        /// </summary>
        InternalformatSharedSize = ((int)0x8277)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_RED_TYPE = 0x8278
        /// </summary>
        InternalformatRedType = ((int)0x8278)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_GREEN_TYPE = 0x8279
        /// </summary>
        InternalformatGreenType = ((int)0x8279)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_BLUE_TYPE = 0x827A
        /// </summary>
        InternalformatBlueType = ((int)0x827A)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_ALPHA_TYPE = 0x827B
        /// </summary>
        InternalformatAlphaType = ((int)0x827B)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_DEPTH_TYPE = 0x827C
        /// </summary>
        InternalformatDepthType = ((int)0x827C)        ,
        /// <summary>
        /// Original was GL_INTERNALFORMAT_STENCIL_TYPE = 0x827D
        /// </summary>
        InternalformatStencilType = ((int)0x827D)        ,
        /// <summary>
        /// Original was GL_MAX_WIDTH = 0x827E
        /// </summary>
        MaxWidth = ((int)0x827E)        ,
        /// <summary>
        /// Original was GL_MAX_HEIGHT = 0x827F
        /// </summary>
        MaxHeight = ((int)0x827F)        ,
        /// <summary>
        /// Original was GL_MAX_DEPTH = 0x8280
        /// </summary>
        MaxDepth = ((int)0x8280)        ,
        /// <summary>
        /// Original was GL_MAX_LAYERS = 0x8281
        /// </summary>
        MaxLayers = ((int)0x8281)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_DIMENSIONS = 0x8282
        /// </summary>
        MaxCombinedDimensions = ((int)0x8282)        ,
        /// <summary>
        /// Original was GL_COLOR_COMPONENTS = 0x8283
        /// </summary>
        ColorComponents = ((int)0x8283)        ,
        /// <summary>
        /// Original was GL_DEPTH_COMPONENTS = 0x8284
        /// </summary>
        DepthComponents = ((int)0x8284)        ,
        /// <summary>
        /// Original was GL_STENCIL_COMPONENTS = 0x8285
        /// </summary>
        StencilComponents = ((int)0x8285)        ,
        /// <summary>
        /// Original was GL_COLOR_RENDERABLE = 0x8286
        /// </summary>
        ColorRenderable = ((int)0x8286)        ,
        /// <summary>
        /// Original was GL_DEPTH_RENDERABLE = 0x8287
        /// </summary>
        DepthRenderable = ((int)0x8287)        ,
        /// <summary>
        /// Original was GL_STENCIL_RENDERABLE = 0x8288
        /// </summary>
        StencilRenderable = ((int)0x8288)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_RENDERABLE = 0x8289
        /// </summary>
        FramebufferRenderable = ((int)0x8289)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_RENDERABLE_LAYERED = 0x828A
        /// </summary>
        FramebufferRenderableLayered = ((int)0x828A)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_BLEND = 0x828B
        /// </summary>
        FramebufferBlend = ((int)0x828B)        ,
        /// <summary>
        /// Original was GL_READ_PIXELS = 0x828C
        /// </summary>
        ReadPixels = ((int)0x828C)        ,
        /// <summary>
        /// Original was GL_READ_PIXELS_FORMAT = 0x828D
        /// </summary>
        ReadPixelsFormat = ((int)0x828D)        ,
        /// <summary>
        /// Original was GL_READ_PIXELS_TYPE = 0x828E
        /// </summary>
        ReadPixelsType = ((int)0x828E)        ,
        /// <summary>
        /// Original was GL_TEXTURE_IMAGE_FORMAT = 0x828F
        /// </summary>
        TextureImageFormat = ((int)0x828F)        ,
        /// <summary>
        /// Original was GL_TEXTURE_IMAGE_TYPE = 0x8290
        /// </summary>
        TextureImageType = ((int)0x8290)        ,
        /// <summary>
        /// Original was GL_GET_TEXTURE_IMAGE_FORMAT = 0x8291
        /// </summary>
        GetTextureImageFormat = ((int)0x8291)        ,
        /// <summary>
        /// Original was GL_GET_TEXTURE_IMAGE_TYPE = 0x8292
        /// </summary>
        GetTextureImageType = ((int)0x8292)        ,
        /// <summary>
        /// Original was GL_MIPMAP = 0x8293
        /// </summary>
        Mipmap = ((int)0x8293)        ,
        /// <summary>
        /// Original was GL_MANUAL_GENERATE_MIPMAP = 0x8294
        /// </summary>
        ManualGenerateMipmap = ((int)0x8294)        ,
        /// <summary>
        /// Original was GL_AUTO_GENERATE_MIPMAP = 0x8295
        /// </summary>
        AutoGenerateMipmap = ((int)0x8295)        ,
        /// <summary>
        /// Original was GL_COLOR_ENCODING = 0x8296
        /// </summary>
        ColorEncoding = ((int)0x8296)        ,
        /// <summary>
        /// Original was GL_SRGB_READ = 0x8297
        /// </summary>
        SrgbRead = ((int)0x8297)        ,
        /// <summary>
        /// Original was GL_SRGB_WRITE = 0x8298
        /// </summary>
        SrgbWrite = ((int)0x8298)        ,
        /// <summary>
        /// Original was GL_SRGB_DECODE_ARB = 0x8299
        /// </summary>
        SrgbDecodeArb = ((int)0x8299)        ,
        /// <summary>
        /// Original was GL_FILTER = 0x829A
        /// </summary>
        Filter = ((int)0x829A)        ,
        /// <summary>
        /// Original was GL_VERTEX_TEXTURE = 0x829B
        /// </summary>
        VertexTexture = ((int)0x829B)        ,
        /// <summary>
        /// Original was GL_TESS_CONTROL_TEXTURE = 0x829C
        /// </summary>
        TessControlTexture = ((int)0x829C)        ,
        /// <summary>
        /// Original was GL_TESS_EVALUATION_TEXTURE = 0x829D
        /// </summary>
        TessEvaluationTexture = ((int)0x829D)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_TEXTURE = 0x829E
        /// </summary>
        GeometryTexture = ((int)0x829E)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_TEXTURE = 0x829F
        /// </summary>
        FragmentTexture = ((int)0x829F)        ,
        /// <summary>
        /// Original was GL_COMPUTE_TEXTURE = 0x82A0
        /// </summary>
        ComputeTexture = ((int)0x82A0)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SHADOW = 0x82A1
        /// </summary>
        TextureShadow = ((int)0x82A1)        ,
        /// <summary>
        /// Original was GL_TEXTURE_GATHER = 0x82A2
        /// </summary>
        TextureGather = ((int)0x82A2)        ,
        /// <summary>
        /// Original was GL_TEXTURE_GATHER_SHADOW = 0x82A3
        /// </summary>
        TextureGatherShadow = ((int)0x82A3)        ,
        /// <summary>
        /// Original was GL_SHADER_IMAGE_LOAD = 0x82A4
        /// </summary>
        ShaderImageLoad = ((int)0x82A4)        ,
        /// <summary>
        /// Original was GL_SHADER_IMAGE_STORE = 0x82A5
        /// </summary>
        ShaderImageStore = ((int)0x82A5)        ,
        /// <summary>
        /// Original was GL_SHADER_IMAGE_ATOMIC = 0x82A6
        /// </summary>
        ShaderImageAtomic = ((int)0x82A6)        ,
        /// <summary>
        /// Original was GL_IMAGE_TEXEL_SIZE = 0x82A7
        /// </summary>
        ImageTexelSize = ((int)0x82A7)        ,
        /// <summary>
        /// Original was GL_IMAGE_COMPATIBILITY_CLASS = 0x82A8
        /// </summary>
        ImageCompatibilityClass = ((int)0x82A8)        ,
        /// <summary>
        /// Original was GL_IMAGE_PIXEL_FORMAT = 0x82A9
        /// </summary>
        ImagePixelFormat = ((int)0x82A9)        ,
        /// <summary>
        /// Original was GL_IMAGE_PIXEL_TYPE = 0x82AA
        /// </summary>
        ImagePixelType = ((int)0x82AA)        ,
        /// <summary>
        /// Original was GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST = 0x82AC
        /// </summary>
        SimultaneousTextureAndDepthTest = ((int)0x82AC)        ,
        /// <summary>
        /// Original was GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST = 0x82AD
        /// </summary>
        SimultaneousTextureAndStencilTest = ((int)0x82AD)        ,
        /// <summary>
        /// Original was GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE = 0x82AE
        /// </summary>
        SimultaneousTextureAndDepthWrite = ((int)0x82AE)        ,
        /// <summary>
        /// Original was GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE = 0x82AF
        /// </summary>
        SimultaneousTextureAndStencilWrite = ((int)0x82AF)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPRESSED_BLOCK_WIDTH = 0x82B1
        /// </summary>
        TextureCompressedBlockWidth = ((int)0x82B1)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT = 0x82B2
        /// </summary>
        TextureCompressedBlockHeight = ((int)0x82B2)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPRESSED_BLOCK_SIZE = 0x82B3
        /// </summary>
        TextureCompressedBlockSize = ((int)0x82B3)        ,
        /// <summary>
        /// Original was GL_CLEAR_BUFFER = 0x82B4
        /// </summary>
        ClearBuffer = ((int)0x82B4)        ,
        /// <summary>
        /// Original was GL_TEXTURE_VIEW = 0x82B5
        /// </summary>
        TextureView = ((int)0x82B5)        ,
        /// <summary>
        /// Original was GL_VIEW_COMPATIBILITY_CLASS = 0x82B6
        /// </summary>
        ViewCompatibilityClass = ((int)0x82B6)        ,
        /// <summary>
        /// Original was GL_FULL_SUPPORT = 0x82B7
        /// </summary>
        FullSupport = ((int)0x82B7)        ,
        /// <summary>
        /// Original was GL_CAVEAT_SUPPORT = 0x82B8
        /// </summary>
        CaveatSupport = ((int)0x82B8)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_4_X_32 = 0x82B9
        /// </summary>
        ImageClass4X32 = ((int)0x82B9)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_2_X_32 = 0x82BA
        /// </summary>
        ImageClass2X32 = ((int)0x82BA)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_1_X_32 = 0x82BB
        /// </summary>
        ImageClass1X32 = ((int)0x82BB)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_4_X_16 = 0x82BC
        /// </summary>
        ImageClass4X16 = ((int)0x82BC)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_2_X_16 = 0x82BD
        /// </summary>
        ImageClass2X16 = ((int)0x82BD)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_1_X_16 = 0x82BE
        /// </summary>
        ImageClass1X16 = ((int)0x82BE)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_4_X_8 = 0x82BF
        /// </summary>
        ImageClass4X8 = ((int)0x82BF)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_2_X_8 = 0x82C0
        /// </summary>
        ImageClass2X8 = ((int)0x82C0)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_1_X_8 = 0x82C1
        /// </summary>
        ImageClass1X8 = ((int)0x82C1)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_11_11_10 = 0x82C2
        /// </summary>
        ImageClass111110 = ((int)0x82C2)        ,
        /// <summary>
        /// Original was GL_IMAGE_CLASS_10_10_10_2 = 0x82C3
        /// </summary>
        ImageClass1010102 = ((int)0x82C3)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_128_BITS = 0x82C4
        /// </summary>
        ViewClass128Bits = ((int)0x82C4)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_96_BITS = 0x82C5
        /// </summary>
        ViewClass96Bits = ((int)0x82C5)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_64_BITS = 0x82C6
        /// </summary>
        ViewClass64Bits = ((int)0x82C6)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_48_BITS = 0x82C7
        /// </summary>
        ViewClass48Bits = ((int)0x82C7)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_32_BITS = 0x82C8
        /// </summary>
        ViewClass32Bits = ((int)0x82C8)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_24_BITS = 0x82C9
        /// </summary>
        ViewClass24Bits = ((int)0x82C9)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_16_BITS = 0x82CA
        /// </summary>
        ViewClass16Bits = ((int)0x82CA)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_8_BITS = 0x82CB
        /// </summary>
        ViewClass8Bits = ((int)0x82CB)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_S3TC_DXT1_RGB = 0x82CC
        /// </summary>
        ViewClassS3tcDxt1Rgb = ((int)0x82CC)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_S3TC_DXT1_RGBA = 0x82CD
        /// </summary>
        ViewClassS3tcDxt1Rgba = ((int)0x82CD)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_S3TC_DXT3_RGBA = 0x82CE
        /// </summary>
        ViewClassS3tcDxt3Rgba = ((int)0x82CE)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_S3TC_DXT5_RGBA = 0x82CF
        /// </summary>
        ViewClassS3tcDxt5Rgba = ((int)0x82CF)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_RGTC1_RED = 0x82D0
        /// </summary>
        ViewClassRgtc1Red = ((int)0x82D0)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_RGTC2_RG = 0x82D1
        /// </summary>
        ViewClassRgtc2Rg = ((int)0x82D1)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_BPTC_UNORM = 0x82D2
        /// </summary>
        ViewClassBptcUnorm = ((int)0x82D2)        ,
        /// <summary>
        /// Original was GL_VIEW_CLASS_BPTC_FLOAT = 0x82D3
        /// </summary>
        ViewClassBptcFloat = ((int)0x82D3)        ,
        /// <summary>
        /// Original was GL_TEXTURE_RECTANGLE = 0x84F5
        /// </summary>
        TextureRectangle = ((int)0x84F5)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP = 0x8513
        /// </summary>
        TextureCubeMap = ((int)0x8513)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPRESSED = 0x86A1
        /// </summary>
        TextureCompressed = ((int)0x86A1)        ,
        /// <summary>
        /// Original was GL_TEXTURE_1D_ARRAY = 0x8C18
        /// </summary>
        Texture1DArray = ((int)0x8C18)        ,
        /// <summary>
        /// Original was GL_TEXTURE_2D_ARRAY = 0x8C1A
        /// </summary>
        Texture2DArray = ((int)0x8C1A)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BUFFER = 0x8C2A
        /// </summary>
        TextureBuffer = ((int)0x8C2A)        ,
        /// <summary>
        /// Original was GL_RENDERBUFFER = 0x8D41
        /// </summary>
        Renderbuffer = ((int)0x8D41)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_ARRAY = 0x9009
        /// </summary>
        TextureCubeMapArray = ((int)0x9009)        ,
        /// <summary>
        /// Original was GL_IMAGE_FORMAT_COMPATIBILITY_TYPE = 0x90C7
        /// </summary>
        ImageFormatCompatibilityType = ((int)0x90C7)        ,
        /// <summary>
        /// Original was GL_TEXTURE_2D_MULTISAMPLE = 0x9100
        /// </summary>
        Texture2DMultisample = ((int)0x9100)        ,
        /// <summary>
        /// Original was GL_TEXTURE_2D_MULTISAMPLE_ARRAY = 0x9102
        /// </summary>
        Texture2DMultisampleArray = ((int)0x9102)        ,
        /// <summary>
        /// Original was GL_NUM_SAMPLE_COUNTS = 0x9380
        /// </summary>
        NumSampleCounts = ((int)0x9380)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbInvalidateSubdata : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbMapBufferAlignment : int
    {
        /// <summary>
        /// Original was GL_MIN_MAP_BUFFER_ALIGNMENT = 0x90BC
        /// </summary>
        MinMapBufferAlignment = ((int)0x90BC)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbMapBufferRange : int
    {
        /// <summary>
        /// Original was GL_MAP_READ_BIT = 0x0001
        /// </summary>
        MapReadBit = ((int)0x0001)        ,
        /// <summary>
        /// Original was GL_MAP_WRITE_BIT = 0x0002
        /// </summary>
        MapWriteBit = ((int)0x0002)        ,
        /// <summary>
        /// Original was GL_MAP_INVALIDATE_RANGE_BIT = 0x0004
        /// </summary>
        MapInvalidateRangeBit = ((int)0x0004)        ,
        /// <summary>
        /// Original was GL_MAP_INVALIDATE_BUFFER_BIT = 0x0008
        /// </summary>
        MapInvalidateBufferBit = ((int)0x0008)        ,
        /// <summary>
        /// Original was GL_MAP_FLUSH_EXPLICIT_BIT = 0x0010
        /// </summary>
        MapFlushExplicitBit = ((int)0x0010)        ,
        /// <summary>
        /// Original was GL_MAP_UNSYNCHRONIZED_BIT = 0x0020
        /// </summary>
        MapUnsynchronizedBit = ((int)0x0020)        ,
    }

    /// <summary>
    /// Used in GL.Arb.MatrixIndexPointer
    /// </summary>
    public enum ArbMatrixPalette : int
    {
        /// <summary>
        /// Original was GL_MATRIX_PALETTE_ARB = 0x8840
        /// </summary>
        MatrixPaletteArb = ((int)0x8840)        ,
        /// <summary>
        /// Original was GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB = 0x8841
        /// </summary>
        MaxMatrixPaletteStackDepthArb = ((int)0x8841)        ,
        /// <summary>
        /// Original was GL_MAX_PALETTE_MATRICES_ARB = 0x8842
        /// </summary>
        MaxPaletteMatricesArb = ((int)0x8842)        ,
        /// <summary>
        /// Original was GL_CURRENT_PALETTE_MATRIX_ARB = 0x8843
        /// </summary>
        CurrentPaletteMatrixArb = ((int)0x8843)        ,
        /// <summary>
        /// Original was GL_MATRIX_INDEX_ARRAY_ARB = 0x8844
        /// </summary>
        MatrixIndexArrayArb = ((int)0x8844)        ,
        /// <summary>
        /// Original was GL_CURRENT_MATRIX_INDEX_ARB = 0x8845
        /// </summary>
        CurrentMatrixIndexArb = ((int)0x8845)        ,
        /// <summary>
        /// Original was GL_MATRIX_INDEX_ARRAY_SIZE_ARB = 0x8846
        /// </summary>
        MatrixIndexArraySizeArb = ((int)0x8846)        ,
        /// <summary>
        /// Original was GL_MATRIX_INDEX_ARRAY_TYPE_ARB = 0x8847
        /// </summary>
        MatrixIndexArrayTypeArb = ((int)0x8847)        ,
        /// <summary>
        /// Original was GL_MATRIX_INDEX_ARRAY_STRIDE_ARB = 0x8848
        /// </summary>
        MatrixIndexArrayStrideArb = ((int)0x8848)        ,
        /// <summary>
        /// Original was GL_MATRIX_INDEX_ARRAY_POINTER_ARB = 0x8849
        /// </summary>
        MatrixIndexArrayPointerArb = ((int)0x8849)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbMultiBind : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbMultiDrawIndirect : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbMultisample : int
    {
        /// <summary>
        /// Original was GL_MULTISAMPLE_BIT_ARB = 0x20000000
        /// </summary>
        MultisampleBitArb = ((int)0x20000000)        ,
        /// <summary>
        /// Original was GL_MULTISAMPLE_ARB = 0x809D
        /// </summary>
        MultisampleArb = ((int)0x809D)        ,
        /// <summary>
        /// Original was GL_SAMPLE_ALPHA_TO_COVERAGE_ARB = 0x809E
        /// </summary>
        SampleAlphaToCoverageArb = ((int)0x809E)        ,
        /// <summary>
        /// Original was GL_SAMPLE_ALPHA_TO_ONE_ARB = 0x809F
        /// </summary>
        SampleAlphaToOneArb = ((int)0x809F)        ,
        /// <summary>
        /// Original was GL_SAMPLE_COVERAGE_ARB = 0x80A0
        /// </summary>
        SampleCoverageArb = ((int)0x80A0)        ,
        /// <summary>
        /// Original was GL_SAMPLE_BUFFERS_ARB = 0x80A8
        /// </summary>
        SampleBuffersArb = ((int)0x80A8)        ,
        /// <summary>
        /// Original was GL_SAMPLES_ARB = 0x80A9
        /// </summary>
        SamplesArb = ((int)0x80A9)        ,
        /// <summary>
        /// Original was GL_SAMPLE_COVERAGE_VALUE_ARB = 0x80AA
        /// </summary>
        SampleCoverageValueArb = ((int)0x80AA)        ,
        /// <summary>
        /// Original was GL_SAMPLE_COVERAGE_INVERT_ARB = 0x80AB
        /// </summary>
        SampleCoverageInvertArb = ((int)0x80AB)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbMultitexture : int
    {
        /// <summary>
        /// Original was GL_TEXTURE0_ARB = 0x84C0
        /// </summary>
        Texture0Arb = ((int)0x84C0)        ,
        /// <summary>
        /// Original was GL_TEXTURE1_ARB = 0x84C1
        /// </summary>
        Texture1Arb = ((int)0x84C1)        ,
        /// <summary>
        /// Original was GL_TEXTURE2_ARB = 0x84C2
        /// </summary>
        Texture2Arb = ((int)0x84C2)        ,
        /// <summary>
        /// Original was GL_TEXTURE3_ARB = 0x84C3
        /// </summary>
        Texture3Arb = ((int)0x84C3)        ,
        /// <summary>
        /// Original was GL_TEXTURE4_ARB = 0x84C4
        /// </summary>
        Texture4Arb = ((int)0x84C4)        ,
        /// <summary>
        /// Original was GL_TEXTURE5_ARB = 0x84C5
        /// </summary>
        Texture5Arb = ((int)0x84C5)        ,
        /// <summary>
        /// Original was GL_TEXTURE6_ARB = 0x84C6
        /// </summary>
        Texture6Arb = ((int)0x84C6)        ,
        /// <summary>
        /// Original was GL_TEXTURE7_ARB = 0x84C7
        /// </summary>
        Texture7Arb = ((int)0x84C7)        ,
        /// <summary>
        /// Original was GL_TEXTURE8_ARB = 0x84C8
        /// </summary>
        Texture8Arb = ((int)0x84C8)        ,
        /// <summary>
        /// Original was GL_TEXTURE9_ARB = 0x84C9
        /// </summary>
        Texture9Arb = ((int)0x84C9)        ,
        /// <summary>
        /// Original was GL_TEXTURE10_ARB = 0x84CA
        /// </summary>
        Texture10Arb = ((int)0x84CA)        ,
        /// <summary>
        /// Original was GL_TEXTURE11_ARB = 0x84CB
        /// </summary>
        Texture11Arb = ((int)0x84CB)        ,
        /// <summary>
        /// Original was GL_TEXTURE12_ARB = 0x84CC
        /// </summary>
        Texture12Arb = ((int)0x84CC)        ,
        /// <summary>
        /// Original was GL_TEXTURE13_ARB = 0x84CD
        /// </summary>
        Texture13Arb = ((int)0x84CD)        ,
        /// <summary>
        /// Original was GL_TEXTURE14_ARB = 0x84CE
        /// </summary>
        Texture14Arb = ((int)0x84CE)        ,
        /// <summary>
        /// Original was GL_TEXTURE15_ARB = 0x84CF
        /// </summary>
        Texture15Arb = ((int)0x84CF)        ,
        /// <summary>
        /// Original was GL_TEXTURE16_ARB = 0x84D0
        /// </summary>
        Texture16Arb = ((int)0x84D0)        ,
        /// <summary>
        /// Original was GL_TEXTURE17_ARB = 0x84D1
        /// </summary>
        Texture17Arb = ((int)0x84D1)        ,
        /// <summary>
        /// Original was GL_TEXTURE18_ARB = 0x84D2
        /// </summary>
        Texture18Arb = ((int)0x84D2)        ,
        /// <summary>
        /// Original was GL_TEXTURE19_ARB = 0x84D3
        /// </summary>
        Texture19Arb = ((int)0x84D3)        ,
        /// <summary>
        /// Original was GL_TEXTURE20_ARB = 0x84D4
        /// </summary>
        Texture20Arb = ((int)0x84D4)        ,
        /// <summary>
        /// Original was GL_TEXTURE21_ARB = 0x84D5
        /// </summary>
        Texture21Arb = ((int)0x84D5)        ,
        /// <summary>
        /// Original was GL_TEXTURE22_ARB = 0x84D6
        /// </summary>
        Texture22Arb = ((int)0x84D6)        ,
        /// <summary>
        /// Original was GL_TEXTURE23_ARB = 0x84D7
        /// </summary>
        Texture23Arb = ((int)0x84D7)        ,
        /// <summary>
        /// Original was GL_TEXTURE24_ARB = 0x84D8
        /// </summary>
        Texture24Arb = ((int)0x84D8)        ,
        /// <summary>
        /// Original was GL_TEXTURE25_ARB = 0x84D9
        /// </summary>
        Texture25Arb = ((int)0x84D9)        ,
        /// <summary>
        /// Original was GL_TEXTURE26_ARB = 0x84DA
        /// </summary>
        Texture26Arb = ((int)0x84DA)        ,
        /// <summary>
        /// Original was GL_TEXTURE27_ARB = 0x84DB
        /// </summary>
        Texture27Arb = ((int)0x84DB)        ,
        /// <summary>
        /// Original was GL_TEXTURE28_ARB = 0x84DC
        /// </summary>
        Texture28Arb = ((int)0x84DC)        ,
        /// <summary>
        /// Original was GL_TEXTURE29_ARB = 0x84DD
        /// </summary>
        Texture29Arb = ((int)0x84DD)        ,
        /// <summary>
        /// Original was GL_TEXTURE30_ARB = 0x84DE
        /// </summary>
        Texture30Arb = ((int)0x84DE)        ,
        /// <summary>
        /// Original was GL_TEXTURE31_ARB = 0x84DF
        /// </summary>
        Texture31Arb = ((int)0x84DF)        ,
        /// <summary>
        /// Original was GL_ACTIVE_TEXTURE_ARB = 0x84E0
        /// </summary>
        ActiveTextureArb = ((int)0x84E0)        ,
        /// <summary>
        /// Original was GL_CLIENT_ACTIVE_TEXTURE_ARB = 0x84E1
        /// </summary>
        ClientActiveTextureArb = ((int)0x84E1)        ,
        /// <summary>
        /// Original was GL_MAX_TEXTURE_UNITS_ARB = 0x84E2
        /// </summary>
        MaxTextureUnitsArb = ((int)0x84E2)        ,
    }

    /// <summary>
    /// Used in GL.Arb.BeginQuery, GL.Arb.EndQuery and 2 other functions
    /// </summary>
    public enum ArbOcclusionQuery : int
    {
        /// <summary>
        /// Original was GL_QUERY_COUNTER_BITS_ARB = 0x8864
        /// </summary>
        QueryCounterBitsArb = ((int)0x8864)        ,
        /// <summary>
        /// Original was GL_CURRENT_QUERY_ARB = 0x8865
        /// </summary>
        CurrentQueryArb = ((int)0x8865)        ,
        /// <summary>
        /// Original was GL_QUERY_RESULT_ARB = 0x8866
        /// </summary>
        QueryResultArb = ((int)0x8866)        ,
        /// <summary>
        /// Original was GL_QUERY_RESULT_AVAILABLE_ARB = 0x8867
        /// </summary>
        QueryResultAvailableArb = ((int)0x8867)        ,
        /// <summary>
        /// Original was GL_SAMPLES_PASSED_ARB = 0x8914
        /// </summary>
        SamplesPassedArb = ((int)0x8914)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbOcclusionQuery2 : int
    {
        /// <summary>
        /// Original was GL_ANY_SAMPLES_PASSED = 0x8C2F
        /// </summary>
        AnySamplesPassed = ((int)0x8C2F)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbPixelBufferObject : int
    {
        /// <summary>
        /// Original was GL_PIXEL_PACK_BUFFER_ARB = 0x88EB
        /// </summary>
        PixelPackBufferArb = ((int)0x88EB)        ,
        /// <summary>
        /// Original was GL_PIXEL_UNPACK_BUFFER_ARB = 0x88EC
        /// </summary>
        PixelUnpackBufferArb = ((int)0x88EC)        ,
        /// <summary>
        /// Original was GL_PIXEL_PACK_BUFFER_BINDING_ARB = 0x88ED
        /// </summary>
        PixelPackBufferBindingArb = ((int)0x88ED)        ,
        /// <summary>
        /// Original was GL_PIXEL_UNPACK_BUFFER_BINDING_ARB = 0x88EF
        /// </summary>
        PixelUnpackBufferBindingArb = ((int)0x88EF)        ,
    }

    /// <summary>
    /// Used in GL.Arb.PointParameter
    /// </summary>
    public enum ArbPointParameters : int
    {
        /// <summary>
        /// Original was GL_POINT_SIZE_MIN_ARB = 0x8126
        /// </summary>
        PointSizeMinArb = ((int)0x8126)        ,
        /// <summary>
        /// Original was GL_POINT_SIZE_MAX_ARB = 0x8127
        /// </summary>
        PointSizeMaxArb = ((int)0x8127)        ,
        /// <summary>
        /// Original was GL_POINT_FADE_THRESHOLD_SIZE_ARB = 0x8128
        /// </summary>
        PointFadeThresholdSizeArb = ((int)0x8128)        ,
        /// <summary>
        /// Original was GL_POINT_DISTANCE_ATTENUATION_ARB = 0x8129
        /// </summary>
        PointDistanceAttenuationArb = ((int)0x8129)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbPointSprite : int
    {
        /// <summary>
        /// Original was GL_POINT_SPRITE_ARB = 0x8861
        /// </summary>
        PointSpriteArb = ((int)0x8861)        ,
        /// <summary>
        /// Original was GL_COORD_REPLACE_ARB = 0x8862
        /// </summary>
        CoordReplaceArb = ((int)0x8862)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbProgramInterfaceQuery : int
    {
        /// <summary>
        /// Original was GL_NUM_COMPATIBLE_SUBROUTINES = 0x8E4A
        /// </summary>
        NumCompatibleSubroutines = ((int)0x8E4A)        ,
        /// <summary>
        /// Original was GL_COMPATIBLE_SUBROUTINES = 0x8E4B
        /// </summary>
        CompatibleSubroutines = ((int)0x8E4B)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER = 0x92C0
        /// </summary>
        AtomicCounterBuffer = ((int)0x92C0)        ,
        /// <summary>
        /// Original was GL_UNIFORM = 0x92E1
        /// </summary>
        Uniform = ((int)0x92E1)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK = 0x92E2
        /// </summary>
        UniformBlock = ((int)0x92E2)        ,
        /// <summary>
        /// Original was GL_PROGRAM_INPUT = 0x92E3
        /// </summary>
        ProgramInput = ((int)0x92E3)        ,
        /// <summary>
        /// Original was GL_PROGRAM_OUTPUT = 0x92E4
        /// </summary>
        ProgramOutput = ((int)0x92E4)        ,
        /// <summary>
        /// Original was GL_BUFFER_VARIABLE = 0x92E5
        /// </summary>
        BufferVariable = ((int)0x92E5)        ,
        /// <summary>
        /// Original was GL_SHADER_STORAGE_BLOCK = 0x92E6
        /// </summary>
        ShaderStorageBlock = ((int)0x92E6)        ,
        /// <summary>
        /// Original was GL_IS_PER_PATCH = 0x92E7
        /// </summary>
        IsPerPatch = ((int)0x92E7)        ,
        /// <summary>
        /// Original was GL_VERTEX_SUBROUTINE = 0x92E8
        /// </summary>
        VertexSubroutine = ((int)0x92E8)        ,
        /// <summary>
        /// Original was GL_TESS_CONTROL_SUBROUTINE = 0x92E9
        /// </summary>
        TessControlSubroutine = ((int)0x92E9)        ,
        /// <summary>
        /// Original was GL_TESS_EVALUATION_SUBROUTINE = 0x92EA
        /// </summary>
        TessEvaluationSubroutine = ((int)0x92EA)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_SUBROUTINE = 0x92EB
        /// </summary>
        GeometrySubroutine = ((int)0x92EB)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_SUBROUTINE = 0x92EC
        /// </summary>
        FragmentSubroutine = ((int)0x92EC)        ,
        /// <summary>
        /// Original was GL_COMPUTE_SUBROUTINE = 0x92ED
        /// </summary>
        ComputeSubroutine = ((int)0x92ED)        ,
        /// <summary>
        /// Original was GL_VERTEX_SUBROUTINE_UNIFORM = 0x92EE
        /// </summary>
        VertexSubroutineUniform = ((int)0x92EE)        ,
        /// <summary>
        /// Original was GL_TESS_CONTROL_SUBROUTINE_UNIFORM = 0x92EF
        /// </summary>
        TessControlSubroutineUniform = ((int)0x92EF)        ,
        /// <summary>
        /// Original was GL_TESS_EVALUATION_SUBROUTINE_UNIFORM = 0x92F0
        /// </summary>
        TessEvaluationSubroutineUniform = ((int)0x92F0)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_SUBROUTINE_UNIFORM = 0x92F1
        /// </summary>
        GeometrySubroutineUniform = ((int)0x92F1)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_SUBROUTINE_UNIFORM = 0x92F2
        /// </summary>
        FragmentSubroutineUniform = ((int)0x92F2)        ,
        /// <summary>
        /// Original was GL_COMPUTE_SUBROUTINE_UNIFORM = 0x92F3
        /// </summary>
        ComputeSubroutineUniform = ((int)0x92F3)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_VARYING = 0x92F4
        /// </summary>
        TransformFeedbackVarying = ((int)0x92F4)        ,
        /// <summary>
        /// Original was GL_ACTIVE_RESOURCES = 0x92F5
        /// </summary>
        ActiveResources = ((int)0x92F5)        ,
        /// <summary>
        /// Original was GL_MAX_NAME_LENGTH = 0x92F6
        /// </summary>
        MaxNameLength = ((int)0x92F6)        ,
        /// <summary>
        /// Original was GL_MAX_NUM_ACTIVE_VARIABLES = 0x92F7
        /// </summary>
        MaxNumActiveVariables = ((int)0x92F7)        ,
        /// <summary>
        /// Original was GL_MAX_NUM_COMPATIBLE_SUBROUTINES = 0x92F8
        /// </summary>
        MaxNumCompatibleSubroutines = ((int)0x92F8)        ,
        /// <summary>
        /// Original was GL_NAME_LENGTH = 0x92F9
        /// </summary>
        NameLength = ((int)0x92F9)        ,
        /// <summary>
        /// Original was GL_TYPE = 0x92FA
        /// </summary>
        Type = ((int)0x92FA)        ,
        /// <summary>
        /// Original was GL_ARRAY_SIZE = 0x92FB
        /// </summary>
        ArraySize = ((int)0x92FB)        ,
        /// <summary>
        /// Original was GL_OFFSET = 0x92FC
        /// </summary>
        Offset = ((int)0x92FC)        ,
        /// <summary>
        /// Original was GL_BLOCK_INDEX = 0x92FD
        /// </summary>
        BlockIndex = ((int)0x92FD)        ,
        /// <summary>
        /// Original was GL_ARRAY_STRIDE = 0x92FE
        /// </summary>
        ArrayStride = ((int)0x92FE)        ,
        /// <summary>
        /// Original was GL_MATRIX_STRIDE = 0x92FF
        /// </summary>
        MatrixStride = ((int)0x92FF)        ,
        /// <summary>
        /// Original was GL_IS_ROW_MAJOR = 0x9300
        /// </summary>
        IsRowMajor = ((int)0x9300)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_INDEX = 0x9301
        /// </summary>
        AtomicCounterBufferIndex = ((int)0x9301)        ,
        /// <summary>
        /// Original was GL_BUFFER_BINDING = 0x9302
        /// </summary>
        BufferBinding = ((int)0x9302)        ,
        /// <summary>
        /// Original was GL_BUFFER_DATA_SIZE = 0x9303
        /// </summary>
        BufferDataSize = ((int)0x9303)        ,
        /// <summary>
        /// Original was GL_NUM_ACTIVE_VARIABLES = 0x9304
        /// </summary>
        NumActiveVariables = ((int)0x9304)        ,
        /// <summary>
        /// Original was GL_ACTIVE_VARIABLES = 0x9305
        /// </summary>
        ActiveVariables = ((int)0x9305)        ,
        /// <summary>
        /// Original was GL_REFERENCED_BY_VERTEX_SHADER = 0x9306
        /// </summary>
        ReferencedByVertexShader = ((int)0x9306)        ,
        /// <summary>
        /// Original was GL_REFERENCED_BY_TESS_CONTROL_SHADER = 0x9307
        /// </summary>
        ReferencedByTessControlShader = ((int)0x9307)        ,
        /// <summary>
        /// Original was GL_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x9308
        /// </summary>
        ReferencedByTessEvaluationShader = ((int)0x9308)        ,
        /// <summary>
        /// Original was GL_REFERENCED_BY_GEOMETRY_SHADER = 0x9309
        /// </summary>
        ReferencedByGeometryShader = ((int)0x9309)        ,
        /// <summary>
        /// Original was GL_REFERENCED_BY_FRAGMENT_SHADER = 0x930A
        /// </summary>
        ReferencedByFragmentShader = ((int)0x930A)        ,
        /// <summary>
        /// Original was GL_REFERENCED_BY_COMPUTE_SHADER = 0x930B
        /// </summary>
        ReferencedByComputeShader = ((int)0x930B)        ,
        /// <summary>
        /// Original was GL_TOP_LEVEL_ARRAY_SIZE = 0x930C
        /// </summary>
        TopLevelArraySize = ((int)0x930C)        ,
        /// <summary>
        /// Original was GL_TOP_LEVEL_ARRAY_STRIDE = 0x930D
        /// </summary>
        TopLevelArrayStride = ((int)0x930D)        ,
        /// <summary>
        /// Original was GL_LOCATION = 0x930E
        /// </summary>
        Location = ((int)0x930E)        ,
        /// <summary>
        /// Original was GL_LOCATION_INDEX = 0x930F
        /// </summary>
        LocationIndex = ((int)0x930F)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbProvokingVertex : int
    {
        /// <summary>
        /// Original was GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION = 0x8E4C
        /// </summary>
        QuadsFollowProvokingVertexConvention = ((int)0x8E4C)        ,
        /// <summary>
        /// Original was GL_FIRST_VERTEX_CONVENTION = 0x8E4D
        /// </summary>
        FirstVertexConvention = ((int)0x8E4D)        ,
        /// <summary>
        /// Original was GL_LAST_VERTEX_CONVENTION = 0x8E4E
        /// </summary>
        LastVertexConvention = ((int)0x8E4E)        ,
        /// <summary>
        /// Original was GL_PROVOKING_VERTEX = 0x8E4F
        /// </summary>
        ProvokingVertex = ((int)0x8E4F)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbQueryBufferObject : int
    {
        /// <summary>
        /// Original was GL_QUERY_BUFFER_BARRIER_BIT = 0x00008000
        /// </summary>
        QueryBufferBarrierBit = ((int)0x00008000)        ,
        /// <summary>
        /// Original was GL_QUERY_BUFFER = 0x9192
        /// </summary>
        QueryBuffer = ((int)0x9192)        ,
        /// <summary>
        /// Original was GL_QUERY_BUFFER_BINDING = 0x9193
        /// </summary>
        QueryBufferBinding = ((int)0x9193)        ,
        /// <summary>
        /// Original was GL_QUERY_RESULT_NO_WAIT = 0x9194
        /// </summary>
        QueryResultNoWait = ((int)0x9194)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbRobustBufferAccessBehavior : int
    {
    }

    /// <summary>
    /// Used in GL.Arb.GetnColorTable, GL.Arb.GetnCompressedTexImage and 8 other functions
    /// </summary>
    public enum ArbRobustness : int
    {
        /// <summary>
        /// Original was GL_NO_ERROR = 0
        /// </summary>
        NoError = ((int)0)        ,
        /// <summary>
        /// Original was GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB = 0x00000004
        /// </summary>
        ContextFlagRobustAccessBitArb = ((int)0x00000004)        ,
        /// <summary>
        /// Original was GL_LOSE_CONTEXT_ON_RESET_ARB = 0x8252
        /// </summary>
        LoseContextOnResetArb = ((int)0x8252)        ,
        /// <summary>
        /// Original was GL_GUILTY_CONTEXT_RESET_ARB = 0x8253
        /// </summary>
        GuiltyContextResetArb = ((int)0x8253)        ,
        /// <summary>
        /// Original was GL_INNOCENT_CONTEXT_RESET_ARB = 0x8254
        /// </summary>
        InnocentContextResetArb = ((int)0x8254)        ,
        /// <summary>
        /// Original was GL_UNKNOWN_CONTEXT_RESET_ARB = 0x8255
        /// </summary>
        UnknownContextResetArb = ((int)0x8255)        ,
        /// <summary>
        /// Original was GL_RESET_NOTIFICATION_STRATEGY_ARB = 0x8256
        /// </summary>
        ResetNotificationStrategyArb = ((int)0x8256)        ,
        /// <summary>
        /// Original was GL_NO_RESET_NOTIFICATION_ARB = 0x8261
        /// </summary>
        NoResetNotificationArb = ((int)0x8261)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbRobustnessIsolation : int
    {
    }

    /// <summary>
    /// Used in GL.GetSamplerParameterI, GL.SamplerParameterI
    /// </summary>
    public enum ArbSamplerObjects : int
    {
        /// <summary>
        /// Original was GL_SAMPLER_BINDING = 0x8919
        /// </summary>
        SamplerBinding = ((int)0x8919)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbSampleShading : int
    {
        /// <summary>
        /// Original was GL_SAMPLE_SHADING_ARB = 0x8C36
        /// </summary>
        SampleShadingArb = ((int)0x8C36)        ,
        /// <summary>
        /// Original was GL_MIN_SAMPLE_SHADING_VALUE_ARB = 0x8C37
        /// </summary>
        MinSampleShadingValueArb = ((int)0x8C37)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbSeamlessCubeMap : int
    {
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_SEAMLESS = 0x884F
        /// </summary>
        TextureCubeMapSeamless = ((int)0x884F)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbSeamlessCubemapPerTexture : int
    {
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_SEAMLESS = 0x884F
        /// </summary>
        TextureCubeMapSeamless = ((int)0x884F)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbSeparateShaderObjects : int
    {
        /// <summary>
        /// Original was GL_VERTEX_SHADER_BIT = 0x00000001
        /// </summary>
        VertexShaderBit = ((int)0x00000001)        ,
        /// <summary>
        /// Original was GL_FRAGMENT_SHADER_BIT = 0x00000002
        /// </summary>
        FragmentShaderBit = ((int)0x00000002)        ,
        /// <summary>
        /// Original was GL_GEOMETRY_SHADER_BIT = 0x00000004
        /// </summary>
        GeometryShaderBit = ((int)0x00000004)        ,
        /// <summary>
        /// Original was GL_TESS_CONTROL_SHADER_BIT = 0x00000008
        /// </summary>
        TessControlShaderBit = ((int)0x00000008)        ,
        /// <summary>
        /// Original was GL_TESS_EVALUATION_SHADER_BIT = 0x00000010
        /// </summary>
        TessEvaluationShaderBit = ((int)0x00000010)        ,
        /// <summary>
        /// Original was GL_PROGRAM_SEPARABLE = 0x8258
        /// </summary>
        ProgramSeparable = ((int)0x8258)        ,
        /// <summary>
        /// Original was GL_ACTIVE_PROGRAM = 0x8259
        /// </summary>
        ActiveProgram = ((int)0x8259)        ,
        /// <summary>
        /// Original was GL_PROGRAM_PIPELINE_BINDING = 0x825A
        /// </summary>
        ProgramPipelineBinding = ((int)0x825A)        ,
        /// <summary>
        /// Original was GL_ALL_SHADER_BITS = 0xFFFFFFFF
        /// </summary>
        AllShaderBits = unchecked((int)0xFFFFFFFF)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbShaderAtomicCounters : int
    {
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER = 0x92C0
        /// </summary>
        AtomicCounterBuffer = ((int)0x92C0)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_BINDING = 0x92C1
        /// </summary>
        AtomicCounterBufferBinding = ((int)0x92C1)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_START = 0x92C2
        /// </summary>
        AtomicCounterBufferStart = ((int)0x92C2)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_SIZE = 0x92C3
        /// </summary>
        AtomicCounterBufferSize = ((int)0x92C3)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE = 0x92C4
        /// </summary>
        AtomicCounterBufferDataSize = ((int)0x92C4)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS = 0x92C5
        /// </summary>
        AtomicCounterBufferActiveAtomicCounters = ((int)0x92C5)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES = 0x92C6
        /// </summary>
        AtomicCounterBufferActiveAtomicCounterIndices = ((int)0x92C6)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER = 0x92C7
        /// </summary>
        AtomicCounterBufferReferencedByVertexShader = ((int)0x92C7)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER = 0x92C8
        /// </summary>
        AtomicCounterBufferReferencedByTessControlShader = ((int)0x92C8)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x92C9
        /// </summary>
        AtomicCounterBufferReferencedByTessEvaluationShader = ((int)0x92C9)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER = 0x92CA
        /// </summary>
        AtomicCounterBufferReferencedByGeometryShader = ((int)0x92CA)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER = 0x92CB
        /// </summary>
        AtomicCounterBufferReferencedByFragmentShader = ((int)0x92CB)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS = 0x92CC
        /// </summary>
        MaxVertexAtomicCounterBuffers = ((int)0x92CC)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS = 0x92CD
        /// </summary>
        MaxTessControlAtomicCounterBuffers = ((int)0x92CD)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS = 0x92CE
        /// </summary>
        MaxTessEvaluationAtomicCounterBuffers = ((int)0x92CE)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS = 0x92CF
        /// </summary>
        MaxGeometryAtomicCounterBuffers = ((int)0x92CF)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS = 0x92D0
        /// </summary>
        MaxFragmentAtomicCounterBuffers = ((int)0x92D0)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS = 0x92D1
        /// </summary>
        MaxCombinedAtomicCounterBuffers = ((int)0x92D1)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_ATOMIC_COUNTERS = 0x92D2
        /// </summary>
        MaxVertexAtomicCounters = ((int)0x92D2)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS = 0x92D3
        /// </summary>
        MaxTessControlAtomicCounters = ((int)0x92D3)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS = 0x92D4
        /// </summary>
        MaxTessEvaluationAtomicCounters = ((int)0x92D4)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_ATOMIC_COUNTERS = 0x92D5
        /// </summary>
        MaxGeometryAtomicCounters = ((int)0x92D5)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_ATOMIC_COUNTERS = 0x92D6
        /// </summary>
        MaxFragmentAtomicCounters = ((int)0x92D6)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_ATOMIC_COUNTERS = 0x92D7
        /// </summary>
        MaxCombinedAtomicCounters = ((int)0x92D7)        ,
        /// <summary>
        /// Original was GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE = 0x92D8
        /// </summary>
        MaxAtomicCounterBufferSize = ((int)0x92D8)        ,
        /// <summary>
        /// Original was GL_ACTIVE_ATOMIC_COUNTER_BUFFERS = 0x92D9
        /// </summary>
        ActiveAtomicCounterBuffers = ((int)0x92D9)        ,
        /// <summary>
        /// Original was GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX = 0x92DA
        /// </summary>
        UniformAtomicCounterBufferIndex = ((int)0x92DA)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_ATOMIC_COUNTER = 0x92DB
        /// </summary>
        UnsignedIntAtomicCounter = ((int)0x92DB)        ,
        /// <summary>
        /// Original was GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS = 0x92DC
        /// </summary>
        MaxAtomicCounterBufferBindings = ((int)0x92DC)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbShaderBitEncoding : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbShaderDrawParameters : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbShaderGroupVote : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbShaderImageLoadStore : int
    {
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT = 0x00000001
        /// </summary>
        VertexAttribArrayBarrierBit = ((int)0x00000001)        ,
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_BARRIER_BIT = 0x00000002
        /// </summary>
        ElementArrayBarrierBit = ((int)0x00000002)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BARRIER_BIT = 0x00000004
        /// </summary>
        UniformBarrierBit = ((int)0x00000004)        ,
        /// <summary>
        /// Original was GL_TEXTURE_FETCH_BARRIER_BIT = 0x00000008
        /// </summary>
        TextureFetchBarrierBit = ((int)0x00000008)        ,
        /// <summary>
        /// Original was GL_SHADER_IMAGE_ACCESS_BARRIER_BIT = 0x00000020
        /// </summary>
        ShaderImageAccessBarrierBit = ((int)0x00000020)        ,
        /// <summary>
        /// Original was GL_COMMAND_BARRIER_BIT = 0x00000040
        /// </summary>
        CommandBarrierBit = ((int)0x00000040)        ,
        /// <summary>
        /// Original was GL_PIXEL_BUFFER_BARRIER_BIT = 0x00000080
        /// </summary>
        PixelBufferBarrierBit = ((int)0x00000080)        ,
        /// <summary>
        /// Original was GL_TEXTURE_UPDATE_BARRIER_BIT = 0x00000100
        /// </summary>
        TextureUpdateBarrierBit = ((int)0x00000100)        ,
        /// <summary>
        /// Original was GL_BUFFER_UPDATE_BARRIER_BIT = 0x00000200
        /// </summary>
        BufferUpdateBarrierBit = ((int)0x00000200)        ,
        /// <summary>
        /// Original was GL_FRAMEBUFFER_BARRIER_BIT = 0x00000400
        /// </summary>
        FramebufferBarrierBit = ((int)0x00000400)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BARRIER_BIT = 0x00000800
        /// </summary>
        TransformFeedbackBarrierBit = ((int)0x00000800)        ,
        /// <summary>
        /// Original was GL_ATOMIC_COUNTER_BARRIER_BIT = 0x00001000
        /// </summary>
        AtomicCounterBarrierBit = ((int)0x00001000)        ,
        /// <summary>
        /// Original was GL_MAX_IMAGE_UNITS = 0x8F38
        /// </summary>
        MaxImageUnits = ((int)0x8F38)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS = 0x8F39
        /// </summary>
        MaxCombinedImageUnitsAndFragmentOutputs = ((int)0x8F39)        ,
        /// <summary>
        /// Original was GL_IMAGE_BINDING_NAME = 0x8F3A
        /// </summary>
        ImageBindingName = ((int)0x8F3A)        ,
        /// <summary>
        /// Original was GL_IMAGE_BINDING_LEVEL = 0x8F3B
        /// </summary>
        ImageBindingLevel = ((int)0x8F3B)        ,
        /// <summary>
        /// Original was GL_IMAGE_BINDING_LAYERED = 0x8F3C
        /// </summary>
        ImageBindingLayered = ((int)0x8F3C)        ,
        /// <summary>
        /// Original was GL_IMAGE_BINDING_LAYER = 0x8F3D
        /// </summary>
        ImageBindingLayer = ((int)0x8F3D)        ,
        /// <summary>
        /// Original was GL_IMAGE_BINDING_ACCESS = 0x8F3E
        /// </summary>
        ImageBindingAccess = ((int)0x8F3E)        ,
        /// <summary>
        /// Original was GL_IMAGE_1D = 0x904C
        /// </summary>
        Image1D = ((int)0x904C)        ,
        /// <summary>
        /// Original was GL_IMAGE_2D = 0x904D
        /// </summary>
        Image2D = ((int)0x904D)        ,
        /// <summary>
        /// Original was GL_IMAGE_3D = 0x904E
        /// </summary>
        Image3D = ((int)0x904E)        ,
        /// <summary>
        /// Original was GL_IMAGE_2D_RECT = 0x904F
        /// </summary>
        Image2DRect = ((int)0x904F)        ,
        /// <summary>
        /// Original was GL_IMAGE_CUBE = 0x9050
        /// </summary>
        ImageCube = ((int)0x9050)        ,
        /// <summary>
        /// Original was GL_IMAGE_BUFFER = 0x9051
        /// </summary>
        ImageBuffer = ((int)0x9051)        ,
        /// <summary>
        /// Original was GL_IMAGE_1D_ARRAY = 0x9052
        /// </summary>
        Image1DArray = ((int)0x9052)        ,
        /// <summary>
        /// Original was GL_IMAGE_2D_ARRAY = 0x9053
        /// </summary>
        Image2DArray = ((int)0x9053)        ,
        /// <summary>
        /// Original was GL_IMAGE_CUBE_MAP_ARRAY = 0x9054
        /// </summary>
        ImageCubeMapArray = ((int)0x9054)        ,
        /// <summary>
        /// Original was GL_IMAGE_2D_MULTISAMPLE = 0x9055
        /// </summary>
        Image2DMultisample = ((int)0x9055)        ,
        /// <summary>
        /// Original was GL_IMAGE_2D_MULTISAMPLE_ARRAY = 0x9056
        /// </summary>
        Image2DMultisampleArray = ((int)0x9056)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_1D = 0x9057
        /// </summary>
        IntImage1D = ((int)0x9057)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_2D = 0x9058
        /// </summary>
        IntImage2D = ((int)0x9058)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_3D = 0x9059
        /// </summary>
        IntImage3D = ((int)0x9059)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_2D_RECT = 0x905A
        /// </summary>
        IntImage2DRect = ((int)0x905A)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_CUBE = 0x905B
        /// </summary>
        IntImageCube = ((int)0x905B)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_BUFFER = 0x905C
        /// </summary>
        IntImageBuffer = ((int)0x905C)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_1D_ARRAY = 0x905D
        /// </summary>
        IntImage1DArray = ((int)0x905D)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_2D_ARRAY = 0x905E
        /// </summary>
        IntImage2DArray = ((int)0x905E)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_CUBE_MAP_ARRAY = 0x905F
        /// </summary>
        IntImageCubeMapArray = ((int)0x905F)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_2D_MULTISAMPLE = 0x9060
        /// </summary>
        IntImage2DMultisample = ((int)0x9060)        ,
        /// <summary>
        /// Original was GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY = 0x9061
        /// </summary>
        IntImage2DMultisampleArray = ((int)0x9061)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_1D = 0x9062
        /// </summary>
        UnsignedIntImage1D = ((int)0x9062)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_2D = 0x9063
        /// </summary>
        UnsignedIntImage2D = ((int)0x9063)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_3D = 0x9064
        /// </summary>
        UnsignedIntImage3D = ((int)0x9064)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_2D_RECT = 0x9065
        /// </summary>
        UnsignedIntImage2DRect = ((int)0x9065)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_CUBE = 0x9066
        /// </summary>
        UnsignedIntImageCube = ((int)0x9066)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_BUFFER = 0x9067
        /// </summary>
        UnsignedIntImageBuffer = ((int)0x9067)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_1D_ARRAY = 0x9068
        /// </summary>
        UnsignedIntImage1DArray = ((int)0x9068)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_2D_ARRAY = 0x9069
        /// </summary>
        UnsignedIntImage2DArray = ((int)0x9069)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY = 0x906A
        /// </summary>
        UnsignedIntImageCubeMapArray = ((int)0x906A)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE = 0x906B
        /// </summary>
        UnsignedIntImage2DMultisample = ((int)0x906B)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY = 0x906C
        /// </summary>
        UnsignedIntImage2DMultisampleArray = ((int)0x906C)        ,
        /// <summary>
        /// Original was GL_MAX_IMAGE_SAMPLES = 0x906D
        /// </summary>
        MaxImageSamples = ((int)0x906D)        ,
        /// <summary>
        /// Original was GL_IMAGE_BINDING_FORMAT = 0x906E
        /// </summary>
        ImageBindingFormat = ((int)0x906E)        ,
        /// <summary>
        /// Original was GL_IMAGE_FORMAT_COMPATIBILITY_TYPE = 0x90C7
        /// </summary>
        ImageFormatCompatibilityType = ((int)0x90C7)        ,
        /// <summary>
        /// Original was GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE = 0x90C8
        /// </summary>
        ImageFormatCompatibilityBySize = ((int)0x90C8)        ,
        /// <summary>
        /// Original was GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS = 0x90C9
        /// </summary>
        ImageFormatCompatibilityByClass = ((int)0x90C9)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_IMAGE_UNIFORMS = 0x90CA
        /// </summary>
        MaxVertexImageUniforms = ((int)0x90CA)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS = 0x90CB
        /// </summary>
        MaxTessControlImageUniforms = ((int)0x90CB)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS = 0x90CC
        /// </summary>
        MaxTessEvaluationImageUniforms = ((int)0x90CC)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_IMAGE_UNIFORMS = 0x90CD
        /// </summary>
        MaxGeometryImageUniforms = ((int)0x90CD)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_IMAGE_UNIFORMS = 0x90CE
        /// </summary>
        MaxFragmentImageUniforms = ((int)0x90CE)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_IMAGE_UNIFORMS = 0x90CF
        /// </summary>
        MaxCombinedImageUniforms = ((int)0x90CF)        ,
        /// <summary>
        /// Original was GL_ALL_BARRIER_BITS = 0xFFFFFFFF
        /// </summary>
        AllBarrierBits = unchecked((int)0xFFFFFFFF)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbShaderImageSize : int
    {
    }

    /// <summary>
    /// Used in GL.Arb.CreateShaderObject, GL.Arb.GetActiveUniform and 2 other functions
    /// </summary>
    public enum ArbShaderObjects : int
    {
        /// <summary>
        /// Original was GL_PROGRAM_OBJECT_ARB = 0x8B40
        /// </summary>
        ProgramObjectArb = ((int)0x8B40)        ,
        /// <summary>
        /// Original was GL_SHADER_OBJECT_ARB = 0x8B48
        /// </summary>
        ShaderObjectArb = ((int)0x8B48)        ,
        /// <summary>
        /// Original was GL_OBJECT_TYPE_ARB = 0x8B4E
        /// </summary>
        ObjectTypeArb = ((int)0x8B4E)        ,
        /// <summary>
        /// Original was GL_OBJECT_SUBTYPE_ARB = 0x8B4F
        /// </summary>
        ObjectSubtypeArb = ((int)0x8B4F)        ,
        /// <summary>
        /// Original was GL_FLOAT_VEC2_ARB = 0x8B50
        /// </summary>
        FloatVec2Arb = ((int)0x8B50)        ,
        /// <summary>
        /// Original was GL_FLOAT_VEC3_ARB = 0x8B51
        /// </summary>
        FloatVec3Arb = ((int)0x8B51)        ,
        /// <summary>
        /// Original was GL_FLOAT_VEC4_ARB = 0x8B52
        /// </summary>
        FloatVec4Arb = ((int)0x8B52)        ,
        /// <summary>
        /// Original was GL_INT_VEC2_ARB = 0x8B53
        /// </summary>
        IntVec2Arb = ((int)0x8B53)        ,
        /// <summary>
        /// Original was GL_INT_VEC3_ARB = 0x8B54
        /// </summary>
        IntVec3Arb = ((int)0x8B54)        ,
        /// <summary>
        /// Original was GL_INT_VEC4_ARB = 0x8B55
        /// </summary>
        IntVec4Arb = ((int)0x8B55)        ,
        /// <summary>
        /// Original was GL_BOOL_ARB = 0x8B56
        /// </summary>
        BoolArb = ((int)0x8B56)        ,
        /// <summary>
        /// Original was GL_BOOL_VEC2_ARB = 0x8B57
        /// </summary>
        BoolVec2Arb = ((int)0x8B57)        ,
        /// <summary>
        /// Original was GL_BOOL_VEC3_ARB = 0x8B58
        /// </summary>
        BoolVec3Arb = ((int)0x8B58)        ,
        /// <summary>
        /// Original was GL_BOOL_VEC4_ARB = 0x8B59
        /// </summary>
        BoolVec4Arb = ((int)0x8B59)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT2_ARB = 0x8B5A
        /// </summary>
        FloatMat2Arb = ((int)0x8B5A)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT3_ARB = 0x8B5B
        /// </summary>
        FloatMat3Arb = ((int)0x8B5B)        ,
        /// <summary>
        /// Original was GL_FLOAT_MAT4_ARB = 0x8B5C
        /// </summary>
        FloatMat4Arb = ((int)0x8B5C)        ,
        /// <summary>
        /// Original was GL_SAMPLER_1D_ARB = 0x8B5D
        /// </summary>
        Sampler1DArb = ((int)0x8B5D)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_ARB = 0x8B5E
        /// </summary>
        Sampler2DArb = ((int)0x8B5E)        ,
        /// <summary>
        /// Original was GL_SAMPLER_3D_ARB = 0x8B5F
        /// </summary>
        Sampler3DArb = ((int)0x8B5F)        ,
        /// <summary>
        /// Original was GL_SAMPLER_CUBE_ARB = 0x8B60
        /// </summary>
        SamplerCubeArb = ((int)0x8B60)        ,
        /// <summary>
        /// Original was GL_SAMPLER_1D_SHADOW_ARB = 0x8B61
        /// </summary>
        Sampler1DShadowArb = ((int)0x8B61)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_SHADOW_ARB = 0x8B62
        /// </summary>
        Sampler2DShadowArb = ((int)0x8B62)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_RECT_ARB = 0x8B63
        /// </summary>
        Sampler2DRectArb = ((int)0x8B63)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_RECT_SHADOW_ARB = 0x8B64
        /// </summary>
        Sampler2DRectShadowArb = ((int)0x8B64)        ,
        /// <summary>
        /// Original was GL_OBJECT_DELETE_STATUS_ARB = 0x8B80
        /// </summary>
        ObjectDeleteStatusArb = ((int)0x8B80)        ,
        /// <summary>
        /// Original was GL_OBJECT_COMPILE_STATUS_ARB = 0x8B81
        /// </summary>
        ObjectCompileStatusArb = ((int)0x8B81)        ,
        /// <summary>
        /// Original was GL_OBJECT_LINK_STATUS_ARB = 0x8B82
        /// </summary>
        ObjectLinkStatusArb = ((int)0x8B82)        ,
        /// <summary>
        /// Original was GL_OBJECT_VALIDATE_STATUS_ARB = 0x8B83
        /// </summary>
        ObjectValidateStatusArb = ((int)0x8B83)        ,
        /// <summary>
        /// Original was GL_OBJECT_INFO_LOG_LENGTH_ARB = 0x8B84
        /// </summary>
        ObjectInfoLogLengthArb = ((int)0x8B84)        ,
        /// <summary>
        /// Original was GL_OBJECT_ATTACHED_OBJECTS_ARB = 0x8B85
        /// </summary>
        ObjectAttachedObjectsArb = ((int)0x8B85)        ,
        /// <summary>
        /// Original was GL_OBJECT_ACTIVE_UNIFORMS_ARB = 0x8B86
        /// </summary>
        ObjectActiveUniformsArb = ((int)0x8B86)        ,
        /// <summary>
        /// Original was GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB = 0x8B87
        /// </summary>
        ObjectActiveUniformMaxLengthArb = ((int)0x8B87)        ,
        /// <summary>
        /// Original was GL_OBJECT_SHADER_SOURCE_LENGTH_ARB = 0x8B88
        /// </summary>
        ObjectShaderSourceLengthArb = ((int)0x8B88)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbShaderPrecision : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbShaderStencilExport : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbShaderStorageBufferObject : int
    {
        /// <summary>
        /// Original was GL_SHADER_STORAGE_BARRIER_BIT = 0x00002000
        /// </summary>
        ShaderStorageBarrierBit = ((int)0x00002000)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS = 0x8F39
        /// </summary>
        MaxCombinedImageUnitsAndFragmentOutputs = ((int)0x8F39)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES = 0x8F39
        /// </summary>
        MaxCombinedShaderOutputResources = ((int)0x8F39)        ,
        /// <summary>
        /// Original was GL_SHADER_STORAGE_BUFFER = 0x90D2
        /// </summary>
        ShaderStorageBuffer = ((int)0x90D2)        ,
        /// <summary>
        /// Original was GL_SHADER_STORAGE_BUFFER_BINDING = 0x90D3
        /// </summary>
        ShaderStorageBufferBinding = ((int)0x90D3)        ,
        /// <summary>
        /// Original was GL_SHADER_STORAGE_BUFFER_START = 0x90D4
        /// </summary>
        ShaderStorageBufferStart = ((int)0x90D4)        ,
        /// <summary>
        /// Original was GL_SHADER_STORAGE_BUFFER_SIZE = 0x90D5
        /// </summary>
        ShaderStorageBufferSize = ((int)0x90D5)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS = 0x90D6
        /// </summary>
        MaxVertexShaderStorageBlocks = ((int)0x90D6)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS = 0x90D7
        /// </summary>
        MaxGeometryShaderStorageBlocks = ((int)0x90D7)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS = 0x90D8
        /// </summary>
        MaxTessControlShaderStorageBlocks = ((int)0x90D8)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS = 0x90D9
        /// </summary>
        MaxTessEvaluationShaderStorageBlocks = ((int)0x90D9)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS = 0x90DA
        /// </summary>
        MaxFragmentShaderStorageBlocks = ((int)0x90DA)        ,
        /// <summary>
        /// Original was GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS = 0x90DB
        /// </summary>
        MaxComputeShaderStorageBlocks = ((int)0x90DB)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS = 0x90DC
        /// </summary>
        MaxCombinedShaderStorageBlocks = ((int)0x90DC)        ,
        /// <summary>
        /// Original was GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS = 0x90DD
        /// </summary>
        MaxShaderStorageBufferBindings = ((int)0x90DD)        ,
        /// <summary>
        /// Original was GL_MAX_SHADER_STORAGE_BLOCK_SIZE = 0x90DE
        /// </summary>
        MaxShaderStorageBlockSize = ((int)0x90DE)        ,
        /// <summary>
        /// Original was GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT = 0x90DF
        /// </summary>
        ShaderStorageBufferOffsetAlignment = ((int)0x90DF)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbShaderSubroutine : int
    {
        /// <summary>
        /// Original was GL_UNIFORM_SIZE = 0x8A38
        /// </summary>
        UniformSize = ((int)0x8A38)        ,
        /// <summary>
        /// Original was GL_UNIFORM_NAME_LENGTH = 0x8A39
        /// </summary>
        UniformNameLength = ((int)0x8A39)        ,
        /// <summary>
        /// Original was GL_ACTIVE_SUBROUTINES = 0x8DE5
        /// </summary>
        ActiveSubroutines = ((int)0x8DE5)        ,
        /// <summary>
        /// Original was GL_ACTIVE_SUBROUTINE_UNIFORMS = 0x8DE6
        /// </summary>
        ActiveSubroutineUniforms = ((int)0x8DE6)        ,
        /// <summary>
        /// Original was GL_MAX_SUBROUTINES = 0x8DE7
        /// </summary>
        MaxSubroutines = ((int)0x8DE7)        ,
        /// <summary>
        /// Original was GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS = 0x8DE8
        /// </summary>
        MaxSubroutineUniformLocations = ((int)0x8DE8)        ,
        /// <summary>
        /// Original was GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS = 0x8E47
        /// </summary>
        ActiveSubroutineUniformLocations = ((int)0x8E47)        ,
        /// <summary>
        /// Original was GL_ACTIVE_SUBROUTINE_MAX_LENGTH = 0x8E48
        /// </summary>
        ActiveSubroutineMaxLength = ((int)0x8E48)        ,
        /// <summary>
        /// Original was GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH = 0x8E49
        /// </summary>
        ActiveSubroutineUniformMaxLength = ((int)0x8E49)        ,
        /// <summary>
        /// Original was GL_NUM_COMPATIBLE_SUBROUTINES = 0x8E4A
        /// </summary>
        NumCompatibleSubroutines = ((int)0x8E4A)        ,
        /// <summary>
        /// Original was GL_COMPATIBLE_SUBROUTINES = 0x8E4B
        /// </summary>
        CompatibleSubroutines = ((int)0x8E4B)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbShaderTextureLod : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbShadingLanguage100 : int
    {
        /// <summary>
        /// Original was GL_SHADING_LANGUAGE_VERSION_ARB = 0x8B8C
        /// </summary>
        ShadingLanguageVersionArb = ((int)0x8B8C)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbShadingLanguage420pack : int
    {
    }

    /// <summary>
    /// Used in GL.Arb.GetNamedString, GL.Arb.NamedString
    /// </summary>
    public enum ArbShadingLanguageInclude : int
    {
        /// <summary>
        /// Original was GL_SHADER_INCLUDE_ARB = 0x8DAE
        /// </summary>
        ShaderIncludeArb = ((int)0x8DAE)        ,
        /// <summary>
        /// Original was GL_NAMED_STRING_LENGTH_ARB = 0x8DE9
        /// </summary>
        NamedStringLengthArb = ((int)0x8DE9)        ,
        /// <summary>
        /// Original was GL_NAMED_STRING_TYPE_ARB = 0x8DEA
        /// </summary>
        NamedStringTypeArb = ((int)0x8DEA)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbShadingLanguagePacking : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbShadow : int
    {
        /// <summary>
        /// Original was GL_TEXTURE_COMPARE_MODE_ARB = 0x884C
        /// </summary>
        TextureCompareModeArb = ((int)0x884C)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPARE_FUNC_ARB = 0x884D
        /// </summary>
        TextureCompareFuncArb = ((int)0x884D)        ,
        /// <summary>
        /// Original was GL_COMPARE_R_TO_TEXTURE_ARB = 0x884E
        /// </summary>
        CompareRToTextureArb = ((int)0x884E)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbShadowAmbient : int
    {
        /// <summary>
        /// Original was GL_TEXTURE_COMPARE_FAIL_VALUE_ARB = 0x80BF
        /// </summary>
        TextureCompareFailValueArb = ((int)0x80BF)        ,
    }

    /// <summary>
    /// Used in GL.Arb.TexPageCommitment
    /// </summary>
    public enum ArbSparseTexture : int
    {
        /// <summary>
        /// Original was GL_VIRTUAL_PAGE_SIZE_X_ARB = 0x9195
        /// </summary>
        VirtualPageSizeXArb = ((int)0x9195)        ,
        /// <summary>
        /// Original was GL_VIRTUAL_PAGE_SIZE_Y_ARB = 0x9196
        /// </summary>
        VirtualPageSizeYArb = ((int)0x9196)        ,
        /// <summary>
        /// Original was GL_VIRTUAL_PAGE_SIZE_Z_ARB = 0x9197
        /// </summary>
        VirtualPageSizeZArb = ((int)0x9197)        ,
        /// <summary>
        /// Original was GL_MAX_SPARSE_TEXTURE_SIZE_ARB = 0x9198
        /// </summary>
        MaxSparseTextureSizeArb = ((int)0x9198)        ,
        /// <summary>
        /// Original was GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB = 0x9199
        /// </summary>
        MaxSparse3DTextureSizeArb = ((int)0x9199)        ,
        /// <summary>
        /// Original was GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB = 0x919A
        /// </summary>
        MaxSparseArrayTextureLayersArb = ((int)0x919A)        ,
        /// <summary>
        /// Original was GL_MIN_SPARSE_LEVEL_ARB = 0x919B
        /// </summary>
        MinSparseLevelArb = ((int)0x919B)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SPARSE_ARB = 0x91A6
        /// </summary>
        TextureSparseArb = ((int)0x91A6)        ,
        /// <summary>
        /// Original was GL_VIRTUAL_PAGE_SIZE_INDEX_ARB = 0x91A7
        /// </summary>
        VirtualPageSizeIndexArb = ((int)0x91A7)        ,
        /// <summary>
        /// Original was GL_NUM_VIRTUAL_PAGE_SIZES_ARB = 0x91A8
        /// </summary>
        NumVirtualPageSizesArb = ((int)0x91A8)        ,
        /// <summary>
        /// Original was GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB = 0x91A9
        /// </summary>
        SparseTextureFullArrayCubeMipmapsArb = ((int)0x91A9)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbStencilTexturing : int
    {
        /// <summary>
        /// Original was GL_DEPTH_STENCIL_TEXTURE_MODE = 0x90EA
        /// </summary>
        DepthStencilTextureMode = ((int)0x90EA)        ,
    }

    /// <summary>
    /// Used in GL.FenceSync, GL.GetInteger64 and 1 other function
    /// </summary>
    public enum ArbSync : int
    {
        /// <summary>
        /// Original was GL_SYNC_FLUSH_COMMANDS_BIT = 0x00000001
        /// </summary>
        SyncFlushCommandsBit = ((int)0x00000001)        ,
        /// <summary>
        /// Original was GL_MAX_SERVER_WAIT_TIMEOUT = 0x9111
        /// </summary>
        MaxServerWaitTimeout = ((int)0x9111)        ,
        /// <summary>
        /// Original was GL_OBJECT_TYPE = 0x9112
        /// </summary>
        ObjectType = ((int)0x9112)        ,
        /// <summary>
        /// Original was GL_SYNC_CONDITION = 0x9113
        /// </summary>
        SyncCondition = ((int)0x9113)        ,
        /// <summary>
        /// Original was GL_SYNC_STATUS = 0x9114
        /// </summary>
        SyncStatus = ((int)0x9114)        ,
        /// <summary>
        /// Original was GL_SYNC_FLAGS = 0x9115
        /// </summary>
        SyncFlags = ((int)0x9115)        ,
        /// <summary>
        /// Original was GL_SYNC_FENCE = 0x9116
        /// </summary>
        SyncFence = ((int)0x9116)        ,
        /// <summary>
        /// Original was GL_SYNC_GPU_COMMANDS_COMPLETE = 0x9117
        /// </summary>
        SyncGpuCommandsComplete = ((int)0x9117)        ,
        /// <summary>
        /// Original was GL_UNSIGNALED = 0x9118
        /// </summary>
        Unsignaled = ((int)0x9118)        ,
        /// <summary>
        /// Original was GL_SIGNALED = 0x9119
        /// </summary>
        Signaled = ((int)0x9119)        ,
        /// <summary>
        /// Original was GL_ALREADY_SIGNALED = 0x911A
        /// </summary>
        AlreadySignaled = ((int)0x911A)        ,
        /// <summary>
        /// Original was GL_TIMEOUT_EXPIRED = 0x911B
        /// </summary>
        TimeoutExpired = ((int)0x911B)        ,
        /// <summary>
        /// Original was GL_CONDITION_SATISFIED = 0x911C
        /// </summary>
        ConditionSatisfied = ((int)0x911C)        ,
        /// <summary>
        /// Original was GL_WAIT_FAILED = 0x911D
        /// </summary>
        WaitFailed = ((int)0x911D)        ,
        /// <summary>
        /// Original was GL_TIMEOUT_IGNORED = 0xFFFFFFFFFFFFFFFF
        /// </summary>
        TimeoutIgnored = unchecked((int)0xFFFFFFFFFFFFFFFF)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTessellationShader : int
    {
        /// <summary>
        /// Original was GL_TRIANGLES = 0x0004
        /// </summary>
        Triangles = ((int)0x0004)        ,
        /// <summary>
        /// Original was GL_QUADS = 0x0007
        /// </summary>
        Quads = ((int)0x0007)        ,
        /// <summary>
        /// Original was GL_PATCHES = 0x000E
        /// </summary>
        Patches = ((int)0x000E)        ,
        /// <summary>
        /// Original was GL_EQUAL = 0x0202
        /// </summary>
        Equal = ((int)0x0202)        ,
        /// <summary>
        /// Original was GL_CW = 0x0900
        /// </summary>
        Cw = ((int)0x0900)        ,
        /// <summary>
        /// Original was GL_CCW = 0x0901
        /// </summary>
        Ccw = ((int)0x0901)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER = 0x84F0
        /// </summary>
        UniformBlockReferencedByTessControlShader = ((int)0x84F0)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER = 0x84F1
        /// </summary>
        UniformBlockReferencedByTessEvaluationShader = ((int)0x84F1)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_CONTROL_INPUT_COMPONENTS = 0x886C
        /// </summary>
        MaxTessControlInputComponents = ((int)0x886C)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS = 0x886D
        /// </summary>
        MaxTessEvaluationInputComponents = ((int)0x886D)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS = 0x8E1E
        /// </summary>
        MaxCombinedTessControlUniformComponents = ((int)0x8E1E)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS = 0x8E1F
        /// </summary>
        MaxCombinedTessEvaluationUniformComponents = ((int)0x8E1F)        ,
        /// <summary>
        /// Original was GL_PATCH_VERTICES = 0x8E72
        /// </summary>
        PatchVertices = ((int)0x8E72)        ,
        /// <summary>
        /// Original was GL_PATCH_DEFAULT_INNER_LEVEL = 0x8E73
        /// </summary>
        PatchDefaultInnerLevel = ((int)0x8E73)        ,
        /// <summary>
        /// Original was GL_PATCH_DEFAULT_OUTER_LEVEL = 0x8E74
        /// </summary>
        PatchDefaultOuterLevel = ((int)0x8E74)        ,
        /// <summary>
        /// Original was GL_TESS_CONTROL_OUTPUT_VERTICES = 0x8E75
        /// </summary>
        TessControlOutputVertices = ((int)0x8E75)        ,
        /// <summary>
        /// Original was GL_TESS_GEN_MODE = 0x8E76
        /// </summary>
        TessGenMode = ((int)0x8E76)        ,
        /// <summary>
        /// Original was GL_TESS_GEN_SPACING = 0x8E77
        /// </summary>
        TessGenSpacing = ((int)0x8E77)        ,
        /// <summary>
        /// Original was GL_TESS_GEN_VERTEX_ORDER = 0x8E78
        /// </summary>
        TessGenVertexOrder = ((int)0x8E78)        ,
        /// <summary>
        /// Original was GL_TESS_GEN_POINT_MODE = 0x8E79
        /// </summary>
        TessGenPointMode = ((int)0x8E79)        ,
        /// <summary>
        /// Original was GL_ISOLINES = 0x8E7A
        /// </summary>
        Isolines = ((int)0x8E7A)        ,
        /// <summary>
        /// Original was GL_FRACTIONAL_ODD = 0x8E7B
        /// </summary>
        FractionalOdd = ((int)0x8E7B)        ,
        /// <summary>
        /// Original was GL_FRACTIONAL_EVEN = 0x8E7C
        /// </summary>
        FractionalEven = ((int)0x8E7C)        ,
        /// <summary>
        /// Original was GL_MAX_PATCH_VERTICES = 0x8E7D
        /// </summary>
        MaxPatchVertices = ((int)0x8E7D)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_GEN_LEVEL = 0x8E7E
        /// </summary>
        MaxTessGenLevel = ((int)0x8E7E)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS = 0x8E7F
        /// </summary>
        MaxTessControlUniformComponents = ((int)0x8E7F)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS = 0x8E80
        /// </summary>
        MaxTessEvaluationUniformComponents = ((int)0x8E80)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS = 0x8E81
        /// </summary>
        MaxTessControlTextureImageUnits = ((int)0x8E81)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS = 0x8E82
        /// </summary>
        MaxTessEvaluationTextureImageUnits = ((int)0x8E82)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS = 0x8E83
        /// </summary>
        MaxTessControlOutputComponents = ((int)0x8E83)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_PATCH_COMPONENTS = 0x8E84
        /// </summary>
        MaxTessPatchComponents = ((int)0x8E84)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS = 0x8E85
        /// </summary>
        MaxTessControlTotalOutputComponents = ((int)0x8E85)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS = 0x8E86
        /// </summary>
        MaxTessEvaluationOutputComponents = ((int)0x8E86)        ,
        /// <summary>
        /// Original was GL_TESS_EVALUATION_SHADER = 0x8E87
        /// </summary>
        TessEvaluationShader = ((int)0x8E87)        ,
        /// <summary>
        /// Original was GL_TESS_CONTROL_SHADER = 0x8E88
        /// </summary>
        TessControlShader = ((int)0x8E88)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS = 0x8E89
        /// </summary>
        MaxTessControlUniformBlocks = ((int)0x8E89)        ,
        /// <summary>
        /// Original was GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS = 0x8E8A
        /// </summary>
        MaxTessEvaluationUniformBlocks = ((int)0x8E8A)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureBorderClamp : int
    {
        /// <summary>
        /// Original was GL_CLAMP_TO_BORDER_ARB = 0x812D
        /// </summary>
        ClampToBorderArb = ((int)0x812D)        ,
    }

    /// <summary>
    /// Used in GL.Arb.TexBuffer
    /// </summary>
    public enum ArbTextureBufferObject : int
    {
        /// <summary>
        /// Original was GL_TEXTURE_BUFFER_ARB = 0x8C2A
        /// </summary>
        TextureBufferArb = ((int)0x8C2A)        ,
        /// <summary>
        /// Original was GL_MAX_TEXTURE_BUFFER_SIZE_ARB = 0x8C2B
        /// </summary>
        MaxTextureBufferSizeArb = ((int)0x8C2B)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_BUFFER_ARB = 0x8C2C
        /// </summary>
        TextureBindingBufferArb = ((int)0x8C2C)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB = 0x8C2D
        /// </summary>
        TextureBufferDataStoreBindingArb = ((int)0x8C2D)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BUFFER_FORMAT_ARB = 0x8C2E
        /// </summary>
        TextureBufferFormatArb = ((int)0x8C2E)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureBufferObjectRgb32 : int
    {
        /// <summary>
        /// Original was GL_RGB32F = 0x8815
        /// </summary>
        Rgb32f = ((int)0x8815)        ,
        /// <summary>
        /// Original was GL_RGB32UI = 0x8D71
        /// </summary>
        Rgb32ui = ((int)0x8D71)        ,
        /// <summary>
        /// Original was GL_RGB32I = 0x8D83
        /// </summary>
        Rgb32i = ((int)0x8D83)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureBufferRange : int
    {
        /// <summary>
        /// Original was GL_TEXTURE_BUFFER_OFFSET = 0x919D
        /// </summary>
        TextureBufferOffset = ((int)0x919D)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BUFFER_SIZE = 0x919E
        /// </summary>
        TextureBufferSize = ((int)0x919E)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT = 0x919F
        /// </summary>
        TextureBufferOffsetAlignment = ((int)0x919F)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureCompression : int
    {
        /// <summary>
        /// Original was GL_COMPRESSED_ALPHA_ARB = 0x84E9
        /// </summary>
        CompressedAlphaArb = ((int)0x84E9)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_LUMINANCE_ARB = 0x84EA
        /// </summary>
        CompressedLuminanceArb = ((int)0x84EA)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_LUMINANCE_ALPHA_ARB = 0x84EB
        /// </summary>
        CompressedLuminanceAlphaArb = ((int)0x84EB)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_INTENSITY_ARB = 0x84EC
        /// </summary>
        CompressedIntensityArb = ((int)0x84EC)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGB_ARB = 0x84ED
        /// </summary>
        CompressedRgbArb = ((int)0x84ED)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_ARB = 0x84EE
        /// </summary>
        CompressedRgbaArb = ((int)0x84EE)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPRESSION_HINT_ARB = 0x84EF
        /// </summary>
        TextureCompressionHintArb = ((int)0x84EF)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB = 0x86A0
        /// </summary>
        TextureCompressedImageSizeArb = ((int)0x86A0)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COMPRESSED_ARB = 0x86A1
        /// </summary>
        TextureCompressedArb = ((int)0x86A1)        ,
        /// <summary>
        /// Original was GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB = 0x86A2
        /// </summary>
        NumCompressedTextureFormatsArb = ((int)0x86A2)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_TEXTURE_FORMATS_ARB = 0x86A3
        /// </summary>
        CompressedTextureFormatsArb = ((int)0x86A3)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureCompressionBptc : int
    {
        /// <summary>
        /// Original was GL_COMPRESSED_RGBA_BPTC_UNORM_ARB = 0x8E8C
        /// </summary>
        CompressedRgbaBptcUnormArb = ((int)0x8E8C)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB = 0x8E8D
        /// </summary>
        CompressedSrgbAlphaBptcUnormArb = ((int)0x8E8D)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB = 0x8E8E
        /// </summary>
        CompressedRgbBptcSignedFloatArb = ((int)0x8E8E)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB = 0x8E8F
        /// </summary>
        CompressedRgbBptcUnsignedFloatArb = ((int)0x8E8F)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureCompressionRgtc : int
    {
        /// <summary>
        /// Original was GL_COMPRESSED_RED_RGTC1 = 0x8DBB
        /// </summary>
        CompressedRedRgtc1 = ((int)0x8DBB)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SIGNED_RED_RGTC1 = 0x8DBC
        /// </summary>
        CompressedSignedRedRgtc1 = ((int)0x8DBC)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_RG_RGTC2 = 0x8DBD
        /// </summary>
        CompressedRgRgtc2 = ((int)0x8DBD)        ,
        /// <summary>
        /// Original was GL_COMPRESSED_SIGNED_RG_RGTC2 = 0x8DBE
        /// </summary>
        CompressedSignedRgRgtc2 = ((int)0x8DBE)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureCubeMap : int
    {
        /// <summary>
        /// Original was GL_NORMAL_MAP_ARB = 0x8511
        /// </summary>
        NormalMapArb = ((int)0x8511)        ,
        /// <summary>
        /// Original was GL_REFLECTION_MAP_ARB = 0x8512
        /// </summary>
        ReflectionMapArb = ((int)0x8512)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_ARB = 0x8513
        /// </summary>
        TextureCubeMapArb = ((int)0x8513)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_CUBE_MAP_ARB = 0x8514
        /// </summary>
        TextureBindingCubeMapArb = ((int)0x8514)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB = 0x8515
        /// </summary>
        TextureCubeMapPositiveXArb = ((int)0x8515)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB = 0x8516
        /// </summary>
        TextureCubeMapNegativeXArb = ((int)0x8516)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB = 0x8517
        /// </summary>
        TextureCubeMapPositiveYArb = ((int)0x8517)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB = 0x8518
        /// </summary>
        TextureCubeMapNegativeYArb = ((int)0x8518)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB = 0x8519
        /// </summary>
        TextureCubeMapPositiveZArb = ((int)0x8519)        ,
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB = 0x851A
        /// </summary>
        TextureCubeMapNegativeZArb = ((int)0x851A)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_CUBE_MAP_ARB = 0x851B
        /// </summary>
        ProxyTextureCubeMapArb = ((int)0x851B)        ,
        /// <summary>
        /// Original was GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB = 0x851C
        /// </summary>
        MaxCubeMapTextureSizeArb = ((int)0x851C)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureCubeMapArray : int
    {
        /// <summary>
        /// Original was GL_TEXTURE_CUBE_MAP_ARRAY_ARB = 0x9009
        /// </summary>
        TextureCubeMapArrayArb = ((int)0x9009)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB = 0x900A
        /// </summary>
        TextureBindingCubeMapArrayArb = ((int)0x900A)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB = 0x900B
        /// </summary>
        ProxyTextureCubeMapArrayArb = ((int)0x900B)        ,
        /// <summary>
        /// Original was GL_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900C
        /// </summary>
        SamplerCubeMapArrayArb = ((int)0x900C)        ,
        /// <summary>
        /// Original was GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_ARB = 0x900D
        /// </summary>
        SamplerCubeMapArrayShadowArb = ((int)0x900D)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900E
        /// </summary>
        IntSamplerCubeMapArrayArb = ((int)0x900E)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_ARB = 0x900F
        /// </summary>
        UnsignedIntSamplerCubeMapArrayArb = ((int)0x900F)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureEnvAdd : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureEnvCombine : int
    {
        /// <summary>
        /// Original was GL_SUBTRACT_ARB = 0x84E7
        /// </summary>
        SubtractArb = ((int)0x84E7)        ,
        /// <summary>
        /// Original was GL_COMBINE_ARB = 0x8570
        /// </summary>
        CombineArb = ((int)0x8570)        ,
        /// <summary>
        /// Original was GL_COMBINE_RGB_ARB = 0x8571
        /// </summary>
        CombineRgbArb = ((int)0x8571)        ,
        /// <summary>
        /// Original was GL_COMBINE_ALPHA_ARB = 0x8572
        /// </summary>
        CombineAlphaArb = ((int)0x8572)        ,
        /// <summary>
        /// Original was GL_RGB_SCALE_ARB = 0x8573
        /// </summary>
        RgbScaleArb = ((int)0x8573)        ,
        /// <summary>
        /// Original was GL_ADD_SIGNED_ARB = 0x8574
        /// </summary>
        AddSignedArb = ((int)0x8574)        ,
        /// <summary>
        /// Original was GL_INTERPOLATE_ARB = 0x8575
        /// </summary>
        InterpolateArb = ((int)0x8575)        ,
        /// <summary>
        /// Original was GL_CONSTANT_ARB = 0x8576
        /// </summary>
        ConstantArb = ((int)0x8576)        ,
        /// <summary>
        /// Original was GL_PRIMARY_COLOR_ARB = 0x8577
        /// </summary>
        PrimaryColorArb = ((int)0x8577)        ,
        /// <summary>
        /// Original was GL_PREVIOUS_ARB = 0x8578
        /// </summary>
        PreviousArb = ((int)0x8578)        ,
        /// <summary>
        /// Original was GL_SOURCE0_RGB_ARB = 0x8580
        /// </summary>
        Source0RgbArb = ((int)0x8580)        ,
        /// <summary>
        /// Original was GL_SOURCE1_RGB_ARB = 0x8581
        /// </summary>
        Source1RgbArb = ((int)0x8581)        ,
        /// <summary>
        /// Original was GL_SOURCE2_RGB_ARB = 0x8582
        /// </summary>
        Source2RgbArb = ((int)0x8582)        ,
        /// <summary>
        /// Original was GL_SOURCE0_ALPHA_ARB = 0x8588
        /// </summary>
        Source0AlphaArb = ((int)0x8588)        ,
        /// <summary>
        /// Original was GL_SOURCE1_ALPHA_ARB = 0x8589
        /// </summary>
        Source1AlphaArb = ((int)0x8589)        ,
        /// <summary>
        /// Original was GL_SOURCE2_ALPHA_ARB = 0x858A
        /// </summary>
        Source2AlphaArb = ((int)0x858A)        ,
        /// <summary>
        /// Original was GL_OPERAND0_RGB_ARB = 0x8590
        /// </summary>
        Operand0RgbArb = ((int)0x8590)        ,
        /// <summary>
        /// Original was GL_OPERAND1_RGB_ARB = 0x8591
        /// </summary>
        Operand1RgbArb = ((int)0x8591)        ,
        /// <summary>
        /// Original was GL_OPERAND2_RGB_ARB = 0x8592
        /// </summary>
        Operand2RgbArb = ((int)0x8592)        ,
        /// <summary>
        /// Original was GL_OPERAND0_ALPHA_ARB = 0x8598
        /// </summary>
        Operand0AlphaArb = ((int)0x8598)        ,
        /// <summary>
        /// Original was GL_OPERAND1_ALPHA_ARB = 0x8599
        /// </summary>
        Operand1AlphaArb = ((int)0x8599)        ,
        /// <summary>
        /// Original was GL_OPERAND2_ALPHA_ARB = 0x859A
        /// </summary>
        Operand2AlphaArb = ((int)0x859A)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureEnvCrossbar : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureEnvDot3 : int
    {
        /// <summary>
        /// Original was GL_DOT3_RGB_ARB = 0x86AE
        /// </summary>
        Dot3RgbArb = ((int)0x86AE)        ,
        /// <summary>
        /// Original was GL_DOT3_RGBA_ARB = 0x86AF
        /// </summary>
        Dot3RgbaArb = ((int)0x86AF)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureFloat : int
    {
        /// <summary>
        /// Original was GL_RGBA32F_ARB = 0x8814
        /// </summary>
        Rgba32fArb = ((int)0x8814)        ,
        /// <summary>
        /// Original was GL_RGB32F_ARB = 0x8815
        /// </summary>
        Rgb32fArb = ((int)0x8815)        ,
        /// <summary>
        /// Original was GL_ALPHA32F_ARB = 0x8816
        /// </summary>
        Alpha32fArb = ((int)0x8816)        ,
        /// <summary>
        /// Original was GL_INTENSITY32F_ARB = 0x8817
        /// </summary>
        Intensity32fArb = ((int)0x8817)        ,
        /// <summary>
        /// Original was GL_LUMINANCE32F_ARB = 0x8818
        /// </summary>
        Luminance32fArb = ((int)0x8818)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ALPHA32F_ARB = 0x8819
        /// </summary>
        LuminanceAlpha32fArb = ((int)0x8819)        ,
        /// <summary>
        /// Original was GL_RGBA16F_ARB = 0x881A
        /// </summary>
        Rgba16fArb = ((int)0x881A)        ,
        /// <summary>
        /// Original was GL_RGB16F_ARB = 0x881B
        /// </summary>
        Rgb16fArb = ((int)0x881B)        ,
        /// <summary>
        /// Original was GL_ALPHA16F_ARB = 0x881C
        /// </summary>
        Alpha16fArb = ((int)0x881C)        ,
        /// <summary>
        /// Original was GL_INTENSITY16F_ARB = 0x881D
        /// </summary>
        Intensity16fArb = ((int)0x881D)        ,
        /// <summary>
        /// Original was GL_LUMINANCE16F_ARB = 0x881E
        /// </summary>
        Luminance16fArb = ((int)0x881E)        ,
        /// <summary>
        /// Original was GL_LUMINANCE_ALPHA16F_ARB = 0x881F
        /// </summary>
        LuminanceAlpha16fArb = ((int)0x881F)        ,
        /// <summary>
        /// Original was GL_TEXTURE_RED_TYPE_ARB = 0x8C10
        /// </summary>
        TextureRedTypeArb = ((int)0x8C10)        ,
        /// <summary>
        /// Original was GL_TEXTURE_GREEN_TYPE_ARB = 0x8C11
        /// </summary>
        TextureGreenTypeArb = ((int)0x8C11)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BLUE_TYPE_ARB = 0x8C12
        /// </summary>
        TextureBlueTypeArb = ((int)0x8C12)        ,
        /// <summary>
        /// Original was GL_TEXTURE_ALPHA_TYPE_ARB = 0x8C13
        /// </summary>
        TextureAlphaTypeArb = ((int)0x8C13)        ,
        /// <summary>
        /// Original was GL_TEXTURE_LUMINANCE_TYPE_ARB = 0x8C14
        /// </summary>
        TextureLuminanceTypeArb = ((int)0x8C14)        ,
        /// <summary>
        /// Original was GL_TEXTURE_INTENSITY_TYPE_ARB = 0x8C15
        /// </summary>
        TextureIntensityTypeArb = ((int)0x8C15)        ,
        /// <summary>
        /// Original was GL_TEXTURE_DEPTH_TYPE_ARB = 0x8C16
        /// </summary>
        TextureDepthTypeArb = ((int)0x8C16)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_NORMALIZED_ARB = 0x8C17
        /// </summary>
        UnsignedNormalizedArb = ((int)0x8C17)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureGather : int
    {
        /// <summary>
        /// Original was GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB = 0x8E5E
        /// </summary>
        MinProgramTextureGatherOffsetArb = ((int)0x8E5E)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_ARB = 0x8E5F
        /// </summary>
        MaxProgramTextureGatherOffsetArb = ((int)0x8E5F)        ,
        /// <summary>
        /// Original was GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB = 0x8F9F
        /// </summary>
        MaxProgramTextureGatherComponentsArb = ((int)0x8F9F)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureMirrorClampToEdge : int
    {
        /// <summary>
        /// Original was GL_MIRROR_CLAMP_TO_EDGE = 0x8743
        /// </summary>
        MirrorClampToEdge = ((int)0x8743)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureMirroredRepeat : int
    {
        /// <summary>
        /// Original was GL_MIRRORED_REPEAT_ARB = 0x8370
        /// </summary>
        MirroredRepeatArb = ((int)0x8370)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureMultisample : int
    {
        /// <summary>
        /// Original was GL_SAMPLE_POSITION = 0x8E50
        /// </summary>
        SamplePosition = ((int)0x8E50)        ,
        /// <summary>
        /// Original was GL_SAMPLE_MASK = 0x8E51
        /// </summary>
        SampleMask = ((int)0x8E51)        ,
        /// <summary>
        /// Original was GL_SAMPLE_MASK_VALUE = 0x8E52
        /// </summary>
        SampleMaskValue = ((int)0x8E52)        ,
        /// <summary>
        /// Original was GL_MAX_SAMPLE_MASK_WORDS = 0x8E59
        /// </summary>
        MaxSampleMaskWords = ((int)0x8E59)        ,
        /// <summary>
        /// Original was GL_TEXTURE_2D_MULTISAMPLE = 0x9100
        /// </summary>
        Texture2DMultisample = ((int)0x9100)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_2D_MULTISAMPLE = 0x9101
        /// </summary>
        ProxyTexture2DMultisample = ((int)0x9101)        ,
        /// <summary>
        /// Original was GL_TEXTURE_2D_MULTISAMPLE_ARRAY = 0x9102
        /// </summary>
        Texture2DMultisampleArray = ((int)0x9102)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY = 0x9103
        /// </summary>
        ProxyTexture2DMultisampleArray = ((int)0x9103)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_2D_MULTISAMPLE = 0x9104
        /// </summary>
        TextureBinding2DMultisample = ((int)0x9104)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = 0x9105
        /// </summary>
        TextureBinding2DMultisampleArray = ((int)0x9105)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SAMPLES = 0x9106
        /// </summary>
        TextureSamples = ((int)0x9106)        ,
        /// <summary>
        /// Original was GL_TEXTURE_FIXED_SAMPLE_LOCATIONS = 0x9107
        /// </summary>
        TextureFixedSampleLocations = ((int)0x9107)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_MULTISAMPLE = 0x9108
        /// </summary>
        Sampler2DMultisample = ((int)0x9108)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_2D_MULTISAMPLE = 0x9109
        /// </summary>
        IntSampler2DMultisample = ((int)0x9109)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = 0x910A
        /// </summary>
        UnsignedIntSampler2DMultisample = ((int)0x910A)        ,
        /// <summary>
        /// Original was GL_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910B
        /// </summary>
        Sampler2DMultisampleArray = ((int)0x910B)        ,
        /// <summary>
        /// Original was GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910C
        /// </summary>
        IntSampler2DMultisampleArray = ((int)0x910C)        ,
        /// <summary>
        /// Original was GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 0x910D
        /// </summary>
        UnsignedIntSampler2DMultisampleArray = ((int)0x910D)        ,
        /// <summary>
        /// Original was GL_MAX_COLOR_TEXTURE_SAMPLES = 0x910E
        /// </summary>
        MaxColorTextureSamples = ((int)0x910E)        ,
        /// <summary>
        /// Original was GL_MAX_DEPTH_TEXTURE_SAMPLES = 0x910F
        /// </summary>
        MaxDepthTextureSamples = ((int)0x910F)        ,
        /// <summary>
        /// Original was GL_MAX_INTEGER_SAMPLES = 0x9110
        /// </summary>
        MaxIntegerSamples = ((int)0x9110)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureNonPowerOfTwo : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureQueryLevels : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureQueryLod : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureRectangle : int
    {
        /// <summary>
        /// Original was GL_TEXTURE_RECTANGLE_ARB = 0x84F5
        /// </summary>
        TextureRectangleArb = ((int)0x84F5)        ,
        /// <summary>
        /// Original was GL_TEXTURE_BINDING_RECTANGLE_ARB = 0x84F6
        /// </summary>
        TextureBindingRectangleArb = ((int)0x84F6)        ,
        /// <summary>
        /// Original was GL_PROXY_TEXTURE_RECTANGLE_ARB = 0x84F7
        /// </summary>
        ProxyTextureRectangleArb = ((int)0x84F7)        ,
        /// <summary>
        /// Original was GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB = 0x84F8
        /// </summary>
        MaxRectangleTextureSizeArb = ((int)0x84F8)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureRg : int
    {
        /// <summary>
        /// Original was GL_RG = 0x8227
        /// </summary>
        Rg = ((int)0x8227)        ,
        /// <summary>
        /// Original was GL_RG_INTEGER = 0x8228
        /// </summary>
        RgInteger = ((int)0x8228)        ,
        /// <summary>
        /// Original was GL_R8 = 0x8229
        /// </summary>
        R8 = ((int)0x8229)        ,
        /// <summary>
        /// Original was GL_R16 = 0x822A
        /// </summary>
        R16 = ((int)0x822A)        ,
        /// <summary>
        /// Original was GL_RG8 = 0x822B
        /// </summary>
        Rg8 = ((int)0x822B)        ,
        /// <summary>
        /// Original was GL_RG16 = 0x822C
        /// </summary>
        Rg16 = ((int)0x822C)        ,
        /// <summary>
        /// Original was GL_R16F = 0x822D
        /// </summary>
        R16f = ((int)0x822D)        ,
        /// <summary>
        /// Original was GL_R32F = 0x822E
        /// </summary>
        R32f = ((int)0x822E)        ,
        /// <summary>
        /// Original was GL_RG16F = 0x822F
        /// </summary>
        Rg16f = ((int)0x822F)        ,
        /// <summary>
        /// Original was GL_RG32F = 0x8230
        /// </summary>
        Rg32f = ((int)0x8230)        ,
        /// <summary>
        /// Original was GL_R8I = 0x8231
        /// </summary>
        R8i = ((int)0x8231)        ,
        /// <summary>
        /// Original was GL_R8UI = 0x8232
        /// </summary>
        R8ui = ((int)0x8232)        ,
        /// <summary>
        /// Original was GL_R16I = 0x8233
        /// </summary>
        R16i = ((int)0x8233)        ,
        /// <summary>
        /// Original was GL_R16UI = 0x8234
        /// </summary>
        R16ui = ((int)0x8234)        ,
        /// <summary>
        /// Original was GL_R32I = 0x8235
        /// </summary>
        R32i = ((int)0x8235)        ,
        /// <summary>
        /// Original was GL_R32UI = 0x8236
        /// </summary>
        R32ui = ((int)0x8236)        ,
        /// <summary>
        /// Original was GL_RG8I = 0x8237
        /// </summary>
        Rg8i = ((int)0x8237)        ,
        /// <summary>
        /// Original was GL_RG8UI = 0x8238
        /// </summary>
        Rg8ui = ((int)0x8238)        ,
        /// <summary>
        /// Original was GL_RG16I = 0x8239
        /// </summary>
        Rg16i = ((int)0x8239)        ,
        /// <summary>
        /// Original was GL_RG16UI = 0x823A
        /// </summary>
        Rg16ui = ((int)0x823A)        ,
        /// <summary>
        /// Original was GL_RG32I = 0x823B
        /// </summary>
        Rg32i = ((int)0x823B)        ,
        /// <summary>
        /// Original was GL_RG32UI = 0x823C
        /// </summary>
        Rg32ui = ((int)0x823C)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureRgb10A2ui : int
    {
        /// <summary>
        /// Original was GL_RGB10_A2UI = 0x906F
        /// </summary>
        Rgb10A2ui = ((int)0x906F)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureStencil8 : int
    {
        /// <summary>
        /// Original was GL_STENCIL_INDEX = 0x1901
        /// </summary>
        StencilIndex = ((int)0x1901)        ,
        /// <summary>
        /// Original was GL_STENCIL_INDEX8 = 0x8D48
        /// </summary>
        StencilIndex8 = ((int)0x8D48)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureStorage : int
    {
        /// <summary>
        /// Original was GL_TEXTURE_IMMUTABLE_FORMAT = 0x912F
        /// </summary>
        TextureImmutableFormat = ((int)0x912F)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureStorageMultisample : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureSwizzle : int
    {
        /// <summary>
        /// Original was GL_TEXTURE_SWIZZLE_R = 0x8E42
        /// </summary>
        TextureSwizzleR = ((int)0x8E42)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SWIZZLE_G = 0x8E43
        /// </summary>
        TextureSwizzleG = ((int)0x8E43)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SWIZZLE_B = 0x8E44
        /// </summary>
        TextureSwizzleB = ((int)0x8E44)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SWIZZLE_A = 0x8E45
        /// </summary>
        TextureSwizzleA = ((int)0x8E45)        ,
        /// <summary>
        /// Original was GL_TEXTURE_SWIZZLE_RGBA = 0x8E46
        /// </summary>
        TextureSwizzleRgba = ((int)0x8E46)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTextureView : int
    {
        /// <summary>
        /// Original was GL_TEXTURE_VIEW_MIN_LEVEL = 0x82DB
        /// </summary>
        TextureViewMinLevel = ((int)0x82DB)        ,
        /// <summary>
        /// Original was GL_TEXTURE_VIEW_NUM_LEVELS = 0x82DC
        /// </summary>
        TextureViewNumLevels = ((int)0x82DC)        ,
        /// <summary>
        /// Original was GL_TEXTURE_VIEW_MIN_LAYER = 0x82DD
        /// </summary>
        TextureViewMinLayer = ((int)0x82DD)        ,
        /// <summary>
        /// Original was GL_TEXTURE_VIEW_NUM_LAYERS = 0x82DE
        /// </summary>
        TextureViewNumLayers = ((int)0x82DE)        ,
        /// <summary>
        /// Original was GL_TEXTURE_IMMUTABLE_LEVELS = 0x82DF
        /// </summary>
        TextureImmutableLevels = ((int)0x82DF)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTimerQuery : int
    {
        /// <summary>
        /// Original was GL_TIME_ELAPSED = 0x88BF
        /// </summary>
        TimeElapsed = ((int)0x88BF)        ,
        /// <summary>
        /// Original was GL_TIMESTAMP = 0x8E28
        /// </summary>
        Timestamp = ((int)0x8E28)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTransformFeedback2 : int
    {
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK = 0x8E22
        /// </summary>
        TransformFeedback = ((int)0x8E22)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED = 0x8E23
        /// </summary>
        TransformFeedbackBufferPaused = ((int)0x8E23)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_PAUSED = 0x8E23
        /// </summary>
        TransformFeedbackPaused = ((int)0x8E23)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_ACTIVE = 0x8E24
        /// </summary>
        TransformFeedbackActive = ((int)0x8E24)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE = 0x8E24
        /// </summary>
        TransformFeedbackBufferActive = ((int)0x8E24)        ,
        /// <summary>
        /// Original was GL_TRANSFORM_FEEDBACK_BINDING = 0x8E25
        /// </summary>
        TransformFeedbackBinding = ((int)0x8E25)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTransformFeedback3 : int
    {
        /// <summary>
        /// Original was GL_MAX_TRANSFORM_FEEDBACK_BUFFERS = 0x8E70
        /// </summary>
        MaxTransformFeedbackBuffers = ((int)0x8E70)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_STREAMS = 0x8E71
        /// </summary>
        MaxVertexStreams = ((int)0x8E71)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTransformFeedbackInstanced : int
    {
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbTransposeMatrix : int
    {
        /// <summary>
        /// Original was GL_TRANSPOSE_MODELVIEW_MATRIX_ARB = 0x84E3
        /// </summary>
        TransposeModelviewMatrixArb = ((int)0x84E3)        ,
        /// <summary>
        /// Original was GL_TRANSPOSE_PROJECTION_MATRIX_ARB = 0x84E4
        /// </summary>
        TransposeProjectionMatrixArb = ((int)0x84E4)        ,
        /// <summary>
        /// Original was GL_TRANSPOSE_TEXTURE_MATRIX_ARB = 0x84E5
        /// </summary>
        TransposeTextureMatrixArb = ((int)0x84E5)        ,
        /// <summary>
        /// Original was GL_TRANSPOSE_COLOR_MATRIX_ARB = 0x84E6
        /// </summary>
        TransposeColorMatrixArb = ((int)0x84E6)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbUniformBufferObject : int
    {
        /// <summary>
        /// Original was GL_UNIFORM_BUFFER = 0x8A11
        /// </summary>
        UniformBuffer = ((int)0x8A11)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BUFFER_BINDING = 0x8A28
        /// </summary>
        UniformBufferBinding = ((int)0x8A28)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BUFFER_START = 0x8A29
        /// </summary>
        UniformBufferStart = ((int)0x8A29)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BUFFER_SIZE = 0x8A2A
        /// </summary>
        UniformBufferSize = ((int)0x8A2A)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_UNIFORM_BLOCKS = 0x8A2B
        /// </summary>
        MaxVertexUniformBlocks = ((int)0x8A2B)        ,
        /// <summary>
        /// Original was GL_MAX_GEOMETRY_UNIFORM_BLOCKS = 0x8A2C
        /// </summary>
        MaxGeometryUniformBlocks = ((int)0x8A2C)        ,
        /// <summary>
        /// Original was GL_MAX_FRAGMENT_UNIFORM_BLOCKS = 0x8A2D
        /// </summary>
        MaxFragmentUniformBlocks = ((int)0x8A2D)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_UNIFORM_BLOCKS = 0x8A2E
        /// </summary>
        MaxCombinedUniformBlocks = ((int)0x8A2E)        ,
        /// <summary>
        /// Original was GL_MAX_UNIFORM_BUFFER_BINDINGS = 0x8A2F
        /// </summary>
        MaxUniformBufferBindings = ((int)0x8A2F)        ,
        /// <summary>
        /// Original was GL_MAX_UNIFORM_BLOCK_SIZE = 0x8A30
        /// </summary>
        MaxUniformBlockSize = ((int)0x8A30)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = 0x8A31
        /// </summary>
        MaxCombinedVertexUniformComponents = ((int)0x8A31)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS = 0x8A32
        /// </summary>
        MaxCombinedGeometryUniformComponents = ((int)0x8A32)        ,
        /// <summary>
        /// Original was GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = 0x8A33
        /// </summary>
        MaxCombinedFragmentUniformComponents = ((int)0x8A33)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT = 0x8A34
        /// </summary>
        UniformBufferOffsetAlignment = ((int)0x8A34)        ,
        /// <summary>
        /// Original was GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH = 0x8A35
        /// </summary>
        ActiveUniformBlockMaxNameLength = ((int)0x8A35)        ,
        /// <summary>
        /// Original was GL_ACTIVE_UNIFORM_BLOCKS = 0x8A36
        /// </summary>
        ActiveUniformBlocks = ((int)0x8A36)        ,
        /// <summary>
        /// Original was GL_UNIFORM_TYPE = 0x8A37
        /// </summary>
        UniformType = ((int)0x8A37)        ,
        /// <summary>
        /// Original was GL_UNIFORM_SIZE = 0x8A38
        /// </summary>
        UniformSize = ((int)0x8A38)        ,
        /// <summary>
        /// Original was GL_UNIFORM_NAME_LENGTH = 0x8A39
        /// </summary>
        UniformNameLength = ((int)0x8A39)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_INDEX = 0x8A3A
        /// </summary>
        UniformBlockIndex = ((int)0x8A3A)        ,
        /// <summary>
        /// Original was GL_UNIFORM_OFFSET = 0x8A3B
        /// </summary>
        UniformOffset = ((int)0x8A3B)        ,
        /// <summary>
        /// Original was GL_UNIFORM_ARRAY_STRIDE = 0x8A3C
        /// </summary>
        UniformArrayStride = ((int)0x8A3C)        ,
        /// <summary>
        /// Original was GL_UNIFORM_MATRIX_STRIDE = 0x8A3D
        /// </summary>
        UniformMatrixStride = ((int)0x8A3D)        ,
        /// <summary>
        /// Original was GL_UNIFORM_IS_ROW_MAJOR = 0x8A3E
        /// </summary>
        UniformIsRowMajor = ((int)0x8A3E)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_BINDING = 0x8A3F
        /// </summary>
        UniformBlockBinding = ((int)0x8A3F)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_DATA_SIZE = 0x8A40
        /// </summary>
        UniformBlockDataSize = ((int)0x8A40)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_NAME_LENGTH = 0x8A41
        /// </summary>
        UniformBlockNameLength = ((int)0x8A41)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS = 0x8A42
        /// </summary>
        UniformBlockActiveUniforms = ((int)0x8A42)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = 0x8A43
        /// </summary>
        UniformBlockActiveUniformIndices = ((int)0x8A43)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = 0x8A44
        /// </summary>
        UniformBlockReferencedByVertexShader = ((int)0x8A44)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER = 0x8A45
        /// </summary>
        UniformBlockReferencedByGeometryShader = ((int)0x8A45)        ,
        /// <summary>
        /// Original was GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = 0x8A46
        /// </summary>
        UniformBlockReferencedByFragmentShader = ((int)0x8A46)        ,
        /// <summary>
        /// Original was GL_INVALID_INDEX = 0xFFFFFFFF
        /// </summary>
        InvalidIndex = unchecked((int)0xFFFFFFFF)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbVertexArrayBgra : int
    {
        /// <summary>
        /// Original was GL_BGRA = 0x80E1
        /// </summary>
        Bgra = ((int)0x80E1)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbVertexArrayObject : int
    {
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_BINDING = 0x85B5
        /// </summary>
        VertexArrayBinding = ((int)0x85B5)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbVertexAttrib64bit : int
    {
        /// <summary>
        /// Original was GL_RGB32I = 0x8D83
        /// </summary>
        Rgb32i = ((int)0x8D83)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT2 = 0x8F46
        /// </summary>
        DoubleMat2 = ((int)0x8F46)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT3 = 0x8F47
        /// </summary>
        DoubleMat3 = ((int)0x8F47)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT4 = 0x8F48
        /// </summary>
        DoubleMat4 = ((int)0x8F48)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT2x3 = 0x8F49
        /// </summary>
        DoubleMat2x3 = ((int)0x8F49)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT2x4 = 0x8F4A
        /// </summary>
        DoubleMat2x4 = ((int)0x8F4A)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT3x2 = 0x8F4B
        /// </summary>
        DoubleMat3x2 = ((int)0x8F4B)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT3x4 = 0x8F4C
        /// </summary>
        DoubleMat3x4 = ((int)0x8F4C)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT4x2 = 0x8F4D
        /// </summary>
        DoubleMat4x2 = ((int)0x8F4D)        ,
        /// <summary>
        /// Original was GL_DOUBLE_MAT4x3 = 0x8F4E
        /// </summary>
        DoubleMat4x3 = ((int)0x8F4E)        ,
        /// <summary>
        /// Original was GL_DOUBLE_VEC2 = 0x8FFC
        /// </summary>
        DoubleVec2 = ((int)0x8FFC)        ,
        /// <summary>
        /// Original was GL_DOUBLE_VEC3 = 0x8FFD
        /// </summary>
        DoubleVec3 = ((int)0x8FFD)        ,
        /// <summary>
        /// Original was GL_DOUBLE_VEC4 = 0x8FFE
        /// </summary>
        DoubleVec4 = ((int)0x8FFE)        ,
    }

    /// <summary>
    /// Not used directly.
    /// </summary>
    public enum ArbVertexAttribBinding : int
    {
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_BINDING = 0x82D4
        /// </summary>
        VertexAttribBinding = ((int)0x82D4)        ,
        /// <summary>
        /// Original was GL_VERTEX_ATTRIB_RELATIVE_OFFSET = 0x82D5
        /// </summary>
        VertexAttribRelativeOffset = ((int)0x82D5)        ,
        /// <summary>
        /// Original was GL_VERTEX_BINDING_DIVISOR = 0x82D6
        /// </summary>
        VertexBindingDivisor = ((int)0x82D6)        ,
        /// <summary>
        /// Original was GL_VERTEX_BINDING_OFFSET = 0x82D7
        /// </summary>
        VertexBindingOffset = ((int)0x82D7)        ,
        /// <summary>
        /// Original was GL_VERTEX_BINDING_STRIDE = 0x82D8
        /// </summary>
        VertexBindingStride = ((int)0x82D8)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET = 0x82D9
        /// </summary>
        MaxVertexAttribRelativeOffset = ((int)0x82D9)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_ATTRIB_BINDINGS = 0x82DA
        /// </summary>
        MaxVertexAttribBindings = ((int)0x82DA)        ,
    }

    /// <summary>
    /// Used in GL.Arb.WeightPointer
    /// </summary>
    public enum ArbVertexBlend : int
    {
        /// <summary>
        /// Original was GL_MODELVIEW0_ARB = 0x1700
        /// </summary>
        Modelview0Arb = ((int)0x1700)        ,
        /// <summary>
        /// Original was GL_MODELVIEW1_ARB = 0x850A
        /// </summary>
        Modelview1Arb = ((int)0x850A)        ,
        /// <summary>
        /// Original was GL_MAX_VERTEX_UNITS_ARB = 0x86A4
        /// </summary>
        MaxVertexUnitsArb = ((int)0x86A4)        ,
        /// <summary>
        /// Original was GL_ACTIVE_VERTEX_UNITS_ARB = 0x86A5
        /// </summary>
        ActiveVertexUnitsArb = ((int)0x86A5)        ,
        /// <summary>
        /// Original was GL_WEIGHT_SUM_UNITY_ARB = 0x86A6
        /// </summary>
        WeightSumUnityArb = ((int)0x86A6)        ,
        /// <summary>
        /// Original was GL_VERTEX_BLEND_ARB = 0x86A7
        /// </summary>
        VertexBlendArb = ((int)0x86A7)        ,
        /// <summary>
        /// Original was GL_CURRENT_WEIGHT_ARB = 0x86A8
        /// </summary>
        CurrentWeightArb = ((int)0x86A8)        ,
        /// <summary>
        /// Original was GL_WEIGHT_ARRAY_TYPE_ARB = 0x86A9
        /// </summary>
        WeightArrayTypeArb = ((int)0x86A9)        ,
        /// <summary>
        /// Original was GL_WEIGHT_ARRAY_STRIDE_ARB = 0x86AA
        /// </summary>
        WeightArrayStrideArb = ((int)0x86AA)        ,
        /// <summary>
        /// Original was GL_WEIGHT_ARRAY_SIZE_ARB = 0x86AB
        /// </summary>
        WeightArraySizeArb = ((int)0x86AB)        ,
        /// <summary>
        /// Original was GL_WEIGHT_ARRAY_POINTER_ARB = 0x86AC
        /// </summary>
        WeightArrayPointerArb = ((int)0x86AC)        ,
        /// <summary>
        /// Original was GL_WEIGHT_ARRAY_ARB = 0x86AD
        /// </summary>
        WeightArrayArb = ((int)0x86AD)        ,
        /// <summary>
        /// Original was GL_MODELVIEW2_ARB = 0x8722
        /// </summary>
        Modelview2Arb = ((int)0x8722)        ,
        /// <summary>
        /// Original was GL_MODELVIEW3_ARB = 0x8723
        /// </summary>
        Modelview3Arb = ((int)0x8723)        ,
        /// <summary>
        /// Original was GL_MODELVIEW4_ARB = 0x8724
        /// </summary>
        Modelview4Arb = ((int)0x8724)        ,
        /// <summary>
        /// Original was GL_MODELVIEW5_ARB = 0x8725
        /// </summary>
        Modelview5Arb = ((int)0x8725)        ,
        /// <summary>
        /// Original was GL_MODELVIEW6_ARB = 0x8726
        /// </summary>
        Modelview6Arb = ((int)0x8726)        ,
        /// <summary>
        /// Original was GL_MODELVIEW7_ARB = 0x8727
        /// </summary>
        Modelview7Arb = ((int)0x8727)        ,
        /// <summary>
        /// Original was GL_MODELVIEW8_ARB = 0x8728
        /// </summary>
        Modelview8Arb = ((int)0x8728)        ,
        /// <summary>
        /// Original was GL_MODELVIEW9_ARB = 0x8729
        /// </summary>
        Modelview9Arb = ((int)0x8729)        ,
        /// <summary>
        /// Original was GL_MODELVIEW10_ARB = 0x872A
        /// </summary>
        Modelview10Arb = ((int)0x872A)        ,
        /// <summary>
        /// Original was GL_MODELVIEW11_ARB = 0x872B
        /// </summary>
        Modelview11Arb = ((int)0x872B)        ,
        /// <summary>
        /// Original was GL_MODELVIEW12_ARB = 0x872C
        /// </summary>
        Modelview12Arb = ((int)0x872C)        ,
        /// <summary>
        /// Original was GL_MODELVIEW13_ARB = 0x872D
        /// </summary>
        Modelview13Arb = ((int)0x872D)        ,
        /// <summary>
        /// Original was GL_MODELVIEW14_ARB = 0x872E
        /// </summary>
        Modelview14Arb = ((int)0x872E)        ,
        /// <summary>
        /// Original was GL_MODELVIEW15_ARB = 0x872F
        /// </summary>
        Modelview15Arb = ((int)0x872F)        ,
        /// <summary>
        /// Original was GL_MODELVIEW16_ARB = 0x8730
        /// </summary>
        Modelview16Arb = ((int)0x8730)        ,
        /// <summary>
        /// Original was GL_MODELVIEW17_ARB = 0x8731
        /// </summary>
        Modelview17Arb = ((int)0x8731)        ,
        /// <summary>
        /// Original was GL_MODELVIEW18_ARB = 0x8732
        /// </summary>
        Modelview18Arb = ((int)0x8732)        ,
        /// <summary>
        /// Original was GL_MODELVIEW19_ARB = 0x8733
        /// </summary>
        Modelview19Arb = ((int)0x8733)        ,
        /// <summary>
        /// Original was GL_MODELVIEW20_ARB = 0x8734
        /// </summary>
        Modelview20Arb = ((int)0x8734)        ,
        /// <summary>
        /// Original was GL_MODELVIEW21_ARB = 0x8735
        /// </summary>
        Modelview21Arb = ((int)0x8735)        ,
        /// <summary>
        /// Original was GL_MODELVIEW22_ARB = 0x8736
        /// </summary>
        Modelview22Arb = ((int)0x8736)        ,
        /// <summary>
        /// Original was GL_MODELVIEW23_ARB = 0x8737
        /// </summary>
        Modelview23Arb = ((int)0x8737)        ,
        /// <summary>
        /// Original was GL_MODELVIEW24_ARB = 0x8738
        /// </summary>
        Modelview24Arb = ((int)0x8738)        ,
        /// <summary>
        /// Original was GL_MODELVIEW25_ARB = 0x8739
        /// </summary>
        Modelview25Arb = ((int)0x8739)        ,
        /// <summary>
        /// Original was GL_MODELVIEW26_ARB = 0x873A
        /// </summary>
        Modelview26Arb = ((int)0x873A)        ,
        /// <summary>
        /// Original was GL_MODELVIEW27_ARB = 0x873B
        /// </summary>
        Modelview27Arb = ((int)0x873B)        ,
        /// <summary>
        /// Original was GL_MODELVIEW28_ARB = 0x873C
        /// </summary>
        Modelview28Arb = ((int)0x873C)        ,
        /// <summary>
        /// Original was GL_MODELVIEW29_ARB = 0x873D
        /// </summary>
        Modelview29Arb = ((int)0x873D)        ,
        /// <summary>
        /// Original was GL_MODELVIEW30_ARB = 0x873E
        /// </summary>
        Modelview30Arb = ((int)0x873E)        ,
        /// <summary>
        /// Original was GL_MODELVIEW31_ARB = 0x873F
        /// </summary>
        Modelview31Arb = ((int)0x873F)        ,
    }

    /// <summary>
    /// Used in GL.Arb.GetBufferParameter, GL.Arb.GetBufferPointer and 1 other function
    /// </summary>
    public enum ArbVertexBufferObject : int
    {
        /// <summary>
        /// Original was GL_BUFFER_SIZE_ARB = 0x8764
        /// </summary>
        BufferSizeArb = ((int)0x8764)        ,
        /// <summary>
        /// Original was GL_BUFFER_USAGE_ARB = 0x8765
        /// </summary>
        BufferUsageArb = ((int)0x8765)        ,
        /// <summary>
        /// Original was GL_ARRAY_BUFFER_ARB = 0x8892
        /// </summary>
        ArrayBufferArb = ((int)0x8892)        ,
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_BUFFER_ARB = 0x8893
        /// </summary>
        ElementArrayBufferArb = ((int)0x8893)        ,
        /// <summary>
        /// Original was GL_ARRAY_BUFFER_BINDING_ARB = 0x8894
        /// </summary>
        ArrayBufferBindingArb = ((int)0x8894)        ,
        /// <summary>
        /// Original was GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB = 0x8895
        /// </summary>
        ElementArrayBufferBindingArb = ((int)0x8895)        ,
        /// <summary>
        /// Original was GL_VERTEX_ARRAY_BUFFER_BINDING_ARB = 0x8896
        /// </summary>
        VertexArrayBufferBindingArb = ((int)0x8896)        ,
        /// <summary>
        /// Original was GL_NORMAL_ARRAY_BUFFER_BINDING_ARB = 0x8897
        /// </summary>
        NormalArrayBufferBindingArb = ((int)0x8897)        ,
        /// <summary>
        /// Original was GL_COLOR_ARRAY_BUFFER_BINDING_ARB = 0x8898
        /// </summary>
        ColorArrayBufferBindingArb = ((int)0x8898)        ,
        /// <summary>
        /// Original was GL_INDEX_ARRAY_BUFFER_BINDING_ARB = 0x8899
        /// </summary>
        IndexArrayBufferBindingArb = ((int)0x8899)        ,
        /// <summary>
        /// Original was GL_TEXTURE_COORD_ARRAY_BU