//                                               -*- C++ -*-
/**
 *  @file  TestResult.cxx
 *  @brief TestResult implements the result of a statistical test
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: TestResult.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "TestResult.hxx"


namespace OpenTURNS
{

  namespace Base
  {

    namespace Stat
    {
      CLASSNAMEINIT(TestResult);
      
      typedef OT::Base::Type::Description Description;

      /* Default constructor */
      TestResult::TestResult():
	PersistentObject(),
	testType_(""),
	binaryQualityMeasure_(false),
	pValueThreshold_(0.0),
	pValue_(0.0)
      {
	// Nothing to do
      }

      /* Parameters constructor */
      TestResult::TestResult(const String & type,
			     const Bool binMeasure,
			     const NumericalScalar pVal,
			     const NumericalScalar pThreshold):
	PersistentObject(),
	testType_(type),
	binaryQualityMeasure_(binMeasure),
	pValueThreshold_(pThreshold),
	pValue_(pVal)
      {
	// Nothing to do
      }

      /* Virtual constructor */
      TestResult * TestResult::clone() const
      {
	return new TestResult(*this);
      }

      /* Description Accessor */
      void TestResult::setDescription(const Description & description)
      {
	description_ = description;
      }
      
      Description TestResult::getDescription() const
      {
	return description_;
      }

      /* String converter */
      String TestResult::__repr__() const
      {
        return OSS() << "class=" << TestResult::GetClassName()
		     << " name=" << getName()
		     << " type=" << testType_ 
		     << " binaryQualityMeasure =" << binaryQualityMeasure_
		     << " p-value threshold =" << pValueThreshold_
		     << " p-value =" << pValue_;;
      }
	
      /* Elements accessors */
      Bool TestResult::getBinaryQualityMeasure() const
      {
        return binaryQualityMeasure_;
      }
      
      NumericalScalar TestResult::getPValue() const
      {
        return pValue_;
      }
      
      NumericalScalar TestResult::getThreshold() const
      {
        return pValueThreshold_;
      }
      
      String TestResult::getTestType() const
      {
        return testType_;
      }
      
      /* Comparison operator */
      Bool TestResult::operator == (const TestResult & rhs) const
      {
        const TestResult &lhs(*this);
	Bool equality = true;
	
	if (&lhs != &rhs)
	  {
	    equality = ( lhs.binaryQualityMeasure_==rhs.binaryQualityMeasure_) && (lhs.pValue_==rhs.pValue_ && lhs.pValueThreshold_==rhs.pValueThreshold_) && (lhs.testType_==rhs.testType_);
	  }

	return equality;
      }  
    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */
