/*                                               -*- C++ -*- */
/*
 * @file  csv_lexer.ll
 * @brief The lexer definition in order to read CSV files
 *
 * (C) Copyright 2005-2010 EDF
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * @author $LastChangedBy: dutka $
 * @date   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 */

%{

#include <stdlib.h>
#include "csv_parser.hh"

#define YY_DECL      int csvlex(YYSTYPE *yylval_param, yyscan_t yyscanner, FILE * theFile, const char * theSeparator)
#define YY_USER_INIT {yyin = theFile;}
%}

%option bison-bridge
%option yylineno
%option reentrant
%option prefix="csv"
%option noyywrap


digit     [0-9]
sign      [+-]
integer   {digit}+
exponent  [eE]{sign}?{integer}
real      {sign}?({integer}("."({integer})?)?|"."{integer}){exponent}?

alpha     [a-zA-Z_]
string    {alpha}({alpha}|{integer})*

space     [ \t]

%%

{real}      { yylval_param->real = atof(yytext); return(REAL); }

{string}    { yylval_param->st = yytext; return(STRING); }

"\n"        { return(CRLF); }

"\r\n"      { return(CRLF); }

"\""        { return(DOUBLEQUOTE); }

{space}     { return(SPACE); }

.           { yylval_param->st = yytext; if (strspn(yytext,theSeparator)) return(COMMA); else return(CHAR); }
