//                                               -*- C++ -*-
/**
 *  @file  FORM.cxx
 *  @brief FORM implements the First Order Reliability Method
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: FORM.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "FORM.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      CLASSNAMEINIT(FORM);

      /*
       * @brief  Standard constructor: the class is defined by an optimisation algorithm, a failure event and a physical starting point
       */
      FORM::FORM(const NearestPointAlgorithm & nearestPointAlgorithm,
		 const Event & event,
		 const NumericalPoint & physicalStartingPoint):
	Analytical(nearestPointAlgorithm, event, physicalStartingPoint)
      {
	// Nothing to do
      }

      /* Virtual constructor */
      FORM * FORM::clone() const
      {
	return new FORM(*this);
      }

      /* Result accessor */
      FORMResult FORM::getResult() const
      {
	return result_;
      }

      /* Result accessor */
      void FORM::setResult(const FORMResult & result)
      {
	result_ = result;
      }


      /* String converter */ 
      String FORM::__repr__() const
      {   
	OSS oss;
	oss << "class=" << FORM::GetClassName()
            << " " << Analytical::__repr__()
            << " result=" << result_;
	return oss;
      }

      /* Function that computes the design point by re-using the Analytical::run() and creates a FORMResult */
      void FORM::run()
      {
	Analytical::run();
	result_ = FORMResult(Analytical::getAnalyticalResult().getStandardSpaceDesignPoint(), Analytical::getAnalyticalResult().getLimitStateVariable(), Analytical::getAnalyticalResult().getIsStandardPointOriginInFailureSpace());
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
