//                                               -*- C++ -*-
/**
 *  @file  ImportanceSampling.hxx
 *  @brief ImportanceSampling is an implementation of the importance sampling Montex Carlo simulation method
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: ImportanceSampling.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_IMPORTANCESAMPLING_HXX
#define OPENTURNS_IMPORTANCESAMPLING_HXX

#include "Simulation.hxx"
#include "Distribution.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {

      /**
       * @class ImportanceSampling
       */

      class ImportanceSampling :
	public Simulation
      {

	CLASSNAME;
      public:

	typedef Simulation::NumericalSample          NumericalSample;
	typedef Simulation::InvalidArgumentException InvalidArgumentException;
	typedef Model::Distribution                  Distribution;

	/** Constructor with parameters */
	ImportanceSampling(const Simulation::Event & event, const Distribution & importanceDistribution);


	/** Virtual constructor */
	virtual ImportanceSampling * clone() const;

	/** Importance distribution accessor */
	Distribution getImportanceDistribution() const;

	/** String converter */
	String __repr__() const;

      private:

	/** Compute the block sample */
	NumericalSample computeBlockSample();

	Distribution importanceDistribution_;

      } ; /* class ImportanceSampling */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_IMPORTANCESAMPLING_HXX */
