// SWIG file uncertainty_simulation.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2009-11-09 17:38:15 +0100 (lun. 09 nov. 2009) $
// Id : $Id: uncertainty_simulation.i 1403 2009-11-09 16:38:15Z dutka $

%module(docstring="Uncertainty is the probabilistic part of Open TURNS.") simulation
#pragma SWIG nowarn=302,509
%feature("autodoc","1");

%{
#include "OTBase.hxx"
#include "OTModel.hxx"
#include "OTDistribution.hxx"
#include "OTIsoProbabilisticTransformation.hxx"
#include "OTAnalytical.hxx"
#include "OTSimulation.hxx"
%}

%include typemaps.i
%include OTtypes.i
%include OTexceptions.i
%include std_vector.i

%import base_common.i
%include TestResult.i
%import base_all.i

/* Uncertainty/Model */
/* Uncertainty/Distribution */
%import uncertainty_model_dist.i
%import UncertaintyModelDistTemplateDefs.i

/* Uncertainty/Algorithm/IsoProbabilisticTransformation */
%import uncertainty_isoprobabilistictransformation.i
%import UncertaintyIsoProbabilisticTransformationTemplateDefs.i

/* Uncertainty/Algorithm/Analytical */
%import uncertainty_analytical.i
%import UncertaintyAnalyticalTemplateDefs.i

/* Uncertainty/Algorithm/Simulation */
%include SimulationResultImplementation.i
%include SimulationResult.i
%include Simulation.i
%include PostAnalyticalSimulation.i
%include Wilks.i
%include MonteCarlo.i
%include LHS.i
%include ImportanceSampling.i
%include PostAnalyticalControlledImportanceSampling.i
%include PostAnalyticalImportanceSampling.i
%include RootStrategyImplementation.i
%include RootStrategy.i
%include SamplingStrategyImplementation.i
%include SamplingStrategy.i
%include DirectionalSampling.i
%include OrthogonalDirection.i
%include RandomDirection.i
%include MediumSafe.i
%include RiskyAndFast.i
%include SafeAndSlow.i
%include QuasiMonteCarlo.i
%include QuasiMonteCarloResult.i

/* At last we include template definitions */
%include UncertaintySimulationTemplateDefs.i
