//                                               -*- C++ -*-
/**
 *  @file  AtomicFunctions.cxx
 *  @brief This file supplies some atomic functions to support multithreading
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-10 16:43:31 +0200 (Thu, 10 May 2007) $
 *  Id:      $Id: AtomicFunctions.cxx 434 2007-05-10 14:43:31Z dutka $
 */

#include "AtomicFunctions.hxx"

BEGIN_NAMESPACE_OPENTURNS

#if !defined(HAVE_SYNC_PRIMITIVES)
pthread_mutex_t Atomic::Atomic_Mutex_ = PTHREAD_MUTEX_INITIALIZER;
#endif

#if !defined(HAVE_SYNC_PRIMITIVES) && !defined(WIN32) && !defined(__i386__)
#warning "Using slow implementation for synchronization functions."
#endif

END_NAMESPACE_OPENTURNS

