//                                               -*- C++ -*-
/**
 *  @file  ConstantNumericalMathHessianImplementation.hxx
 *  @brief Class for a constant numerical math hessian implementation
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: ConstantNumericalMathHessianImplementation.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_CONSTANTNUMERICALMATHHESSIANIMPLEMENTATION_HXX
#define OPENTURNS_CONSTANTNUMERICALMATHHESSIANIMPLEMENTATION_HXX

#include "NumericalMathHessianImplementation.hxx"
#include "SymmetricTensor.hxx"

BEGIN_NAMESPACE_OPENTURNS




/**
 * @class ConstantNumericalMathHessianImplementation
 *
 * This class offers an interface for a real numerical mathematical hessian
 * implementations into the platform. It realizes the computation of the image symmetric tensor
 * of a vector (aka NumericalPoint) through the hessian.
 */
class ConstantNumericalMathHessianImplementation
  : public NumericalMathHessianImplementation
{
  CLASSNAME;
public:


  /** Default constructor */
  ConstantNumericalMathHessianImplementation();

  /** Parameter constructor */
  ConstantNumericalMathHessianImplementation(const SymmetricTensor & constant);

  /** Virtual constructor */
  virtual ConstantNumericalMathHessianImplementation * clone() const;

  /** Comparison operator */
  Bool operator ==(const ConstantNumericalMathHessianImplementation & other) const;

  /** String converter */
  virtual String __repr__() const;
  virtual String __str__(const String & offset = "") const;

  /* Here is the interface that all derived class must implement */

  /** Hessian method */
  virtual SymmetricTensor hessian(const NumericalPoint & inP) const;

  /** Accessor for input point dimension */
  virtual UnsignedLong getInputDimension() const;

  /** Accessor for output point dimension */
  virtual UnsignedLong getOutputDimension() const;

  /** Accessor for the constant term */
  SymmetricTensor getConstant() const;

  /** Method save() stores the object through the StorageManager */
  void save(Advocate & adv) const;

  /** Method load() reloads the object from the StorageManager */
  void load(Advocate & adv);

protected:

private:

  SymmetricTensor constant_;

}; /* class ConstantNumericalMathHessianImplementation */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_CONSTANTNUMERICALMATHHESSIANIMPLEMENTATION_HXX */
