//                                               -*- C++ -*-
/**
 *  @file  Secant.hxx
 *  @brief Implementation class of the scalar nonlinear solver based on
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: Secant.hxx 2392 2012-02-17 18:35:43Z schueller $
 */
#ifndef OPENTURNS_SECANT_HXX
#define OPENTURNS_SECANT_HXX

#include "OTprivate.hxx"
#include "SolverImplementation.hxx"

BEGIN_NAMESPACE_OPENTURNS




/**
 * @class Secant
 *
 * This class is an interface for the 1D nonlinear solverImplementations
 */
class Secant :
  public SolverImplementation
{
  CLASSNAME;
public:


  /** Default constructor */
  explicit Secant();

  /** Parameter constructor */
  Secant(const NumericalScalar absoluteError,
         const NumericalScalar relativeError,
         const UnsignedLong maximumFunctionEvaluation);


  /** Virtual constructor */
  virtual Secant * clone() const;

  /** String converter */
  String __repr__() const;

  /** Solve attempt to find one root to the equation function(x) = value in [infPoint, supPoint] given function(infPoint) and function(supPoint) with the Secant method */
  using SolverImplementation::solve;
  NumericalScalar solve(const NumericalMathFunction & function,
                        const NumericalScalar value,
                        const NumericalScalar infPoint,
                        const NumericalScalar supPoint,
                        const NumericalScalar infValue,
                        const NumericalScalar supValue);

private:

}; /* Class Secant */

END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_SECANT_HXX */
