//                                               -*- C++ -*-
/**
 *  @file  CleaningStrategy.hxx
 *  @brief An implementation returning the set of polynomials in sequence
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.hxx 818 2008-05-21 15:44:02Z dutka $
 */
#ifndef OPENTURNS_CLEANINGSTRATEGY_HXX
#define OPENTURNS_CLEANINGSTRATEGY_HXX

#include "AdaptiveStrategyImplementation.hxx"

BEGIN_NAMESPACE_OPENTURNS



/**
 * @class CleaningStrategy
 *
 * An implementation returning the set of polynomials in sequence
 */

class CleaningStrategy
  : public AdaptiveStrategyImplementation
{
  CLASSNAME;
public:


  /** Constructor from an orthogonal basis */
  CleaningStrategy(const OrthogonalBasis & basis,
                   const UnsignedLong maximumDimension,
                   const Bool verbose = false);

  /** Constructor from an orthogonal basis */
  CleaningStrategy(const OrthogonalBasis & basis,
                   const UnsignedLong maximumDimension,
                   const UnsignedLong maximumSize,
                   const NumericalScalar significanceFactor,
                   const Bool verbose = false);

  /** Virtual constructor */
  virtual CleaningStrategy * clone() const;

  /** Compute initial basis for the approximation */
  void computeInitialBasis();

  /** Update the basis for the next iteration of approximation */
  void updateBasis(const NumericalPoint & alpha_k_p_,
                   const NumericalScalar residual_p_,
                   const NumericalScalar relativeError_p_);

  /** String converter */
  virtual String __repr__() const;

  /** Current vector index accessor */
  UnsignedLong getCurrentVectorIndex() const;

  /** Maximum size accessor */
  UnsignedLong getMaximumSize() const;
  void setMaximumSize(const UnsignedLong maximumSize);

  /** Significance factor */
  NumericalScalar getSignificanceFactor() const;
  void setSignificanceFactor(const NumericalScalar significanceFactor);

  /** Verbose accessor */
  Bool getVerbose() const;
  void setVerbose(const Bool verbose);

  /** Method save() stores the object through the StorageManager */
  virtual void save(Advocate & adv) const;

  /** Method load() reloads the object from the StorageManager */
  virtual void load(Advocate & adv);


protected:

  friend class Factory<CleaningStrategy>;

  /** Default constructor */
  CleaningStrategy();

private:
  // Index of the next vector to be generated
  UnsignedLong currentVectorIndex_;

  // Maximum size of the curent basis
  UnsignedLong maximumSize_;

  // Relative significance factor of a vector
  NumericalScalar significanceFactor_;

  // Verbose
  Bool verbose_;

} ; /* class CleaningStrategy */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_CLEANINGSTRATEGY_HXX */
